class Json2ts < Formula
  desc "Compile JSONSchema to TypeScript type declarations"
  homepage "https://github.com/bcherny/json-schema-to-typescript"
  url "https://registry.npmjs.org/json-schema-to-typescript/-/json-schema-to-typescript-15.0.3.tgz"
  sha256 "82233ff634ed9ffca59710d10056b5e95a0f2268b52543adf9fe578db1e46e40"
  license "MIT"

  bottle do
    sha256 cellar: :any_skip_relocation, all: "11457a39c52b5a1b68bfb59cfc45048e5823d396c67601eaf6c081503045f4fd"
  end

  depends_on "node"

  def install
    system "npm", "install", *std_npm_args
    bin.install_symlink Dir["#{libexec}/bin/*"]
  end

  test do
    schema = <<~JSON
      {
        "title": "Example Schema",
        "type": "object",
        "properties": {
          "firstName": {
            "type": "string"
          },
          "lastName": {
            "type": "string"
          },
          "age": {
            "description": "Age in years",
            "type": "integer",
            "minimum": 0
          },
          "hairColor": {
            "enum": ["black", "brown", "blue"],
            "type": "string"
          }
        },
        "additionalProperties": false,
        "required": ["firstName", "lastName"]
      }
    JSON

    typescript = <<~TS
      /* eslint-disable */
      /**
       * This file was automatically generated by json-schema-to-typescript.
       * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
       * and run json-schema-to-typescript to regenerate this file.
       */

      export interface ExampleSchema {
        firstName: string;
        lastName: string;
        /**
         * Age in years
         */
        age?: number;
        hairColor?: "black" | "brown" | "blue";
      }
    TS

    output = pipe_output(bin/"json2ts", schema)
    assert_equal output, typescript
  end
end
