class Exploitdb < Formula
  desc "Database of public exploits and corresponding vulnerable software"
  homepage "https://www.exploit-db.com/"
  url "https://gitlab.com/exploit-database/exploitdb.git",
      tag:      "2024-11-26",
      revision: "731ce583a5022b84f6b4527019ad9599ad779d7c"
  license "GPL-2.0-or-later"
  head "https://gitlab.com/exploit-database/exploitdb.git", branch: "main"

  bottle do
    sha256 cellar: :any_skip_relocation, arm64_sequoia: "14fef1d3a06ca1e2bf0925ec11261a9e74700d75f750005c7304edae6d089a76"
    sha256 cellar: :any_skip_relocation, arm64_sonoma:  "8bde16455f32c386cc4a34dcefd775263c1b9a87e410ed1b4197b2cb28acd048"
    sha256 cellar: :any_skip_relocation, arm64_ventura: "5240f96757da7ba6de662e86786b0b254973b2e30c2dbc864794bbb9b25a8684"
    sha256 cellar: :any_skip_relocation, sonoma:        "41a55f9c779d5a8c959e293fd821c8c98d02969ca90109e3aeeb3a43d429c247"
    sha256 cellar: :any_skip_relocation, ventura:       "03c9ff6cf843e5c01f8a087805e5473d706ff8b3c114a81d35ca8d3859d7b23c"
    sha256 cellar: :any_skip_relocation, x86_64_linux:  "6f5353a8d7f2d2ecfd6cf6d6caabab1889f3e310f7412d074c6cbae057a04aaa"
  end

  def install
    inreplace "searchsploit",
              "rc_file=\"\"", "rc_file=\"#{etc}/searchsploit_rc\""

    optpath = opt_share/"exploitdb"
    inreplace ".searchsploit_rc" do |s|
      s.gsub! "\"/opt/exploitdb\"", optpath
      s.gsub! "\"/opt/exploitdb-papers\"", "#{optpath}-papers"
    end

    bin.install "searchsploit"
    etc.install ".searchsploit_rc" => "searchsploit_rc"

    pkgshare.install %w[.git exploits files_exploits.csv files_shellcodes.csv
                        shellcodes]
  end

  test do
    system bin/"searchsploit", "sendpage"
  end
end
