cask "tortoisehg" do
  version "6.6.3"
  sha256 "d8c1fec60eb64c93c612ced84ca7e012880c7b989cafe51c7b19aa335a0a88ac"

  url "https://www.mercurial-scm.org/release/tortoisehg/macos/TortoiseHg-#{version}-mac-x64-qt5.dmg",
      verified: "mercurial-scm.org/release/tortoisehg/"
  name "TortoiseHg"
  desc "Tools for the Mercurial distributed revision control system"
  homepage "https://tortoisehg.bitbucket.io/"

  livecheck do
    url "https://www.mercurial-scm.org/release/tortoisehg/macos/"
    regex(/TortoiseHg-(\d+(?:\.\d+)*)-mac-x64-qt5\.dmg/i)
  end

  app "TortoiseHg.app"

  zap trash: "~/.config/tortoisehg.org"

  caveats do
    requires_rosetta
  end
end
