cask "tidal" do
  arch arm: "arm64", intel: "x64"

  version "2.38.5"
  sha256 arm:   "46c5736e3f8503454d8738d004aa1ae5de5fbaffd78d0eee602e1b2b11f5eae0",
         intel: "b5e3f7a354d21ddb92b78cee3b623b57f914a122b6e62d24ad9a824795aec683"

  url "https://download.tidal.com/desktop/mac/TIDAL.#{arch}.#{version}.zip"
  name "TIDAL"
  desc "Music streaming service with high fidelity sound and hi-def video quality"
  homepage "https://tidal.com/"

  livecheck do
    url "https://download.tidal.com/desktop/mac/update-#{arch}.json"
    strategy :json do |json|
      json["currentRelease"]
    end
  end

  auto_updates true

  app "TIDAL.app"

  zap trash: [
    "~/Library/Application Support/TIDAL",
    "~/Library/Caches/com.tidal.desktop",
    "~/Library/Caches/com.tidal.desktop.ShipIt",
    "~/Library/Logs/TIDAL",
    "~/Library/Preferences/com.tidal.*",
    "~/Library/Saved Application State/com.tidal.desktop.savedState",
  ]
end
