cask "thunderbird@esr" do
  version "128.4.1esr"

  language "af" do
    sha256 "debdb363aff8fd5ee8b014838b821ecec5d2c3581dafe0b0c3b22c1253366251"
    "af"
  end
  language "ar" do
    sha256 "5be66dc450d5fc3865cf8eeb6464346da3b35c6d376f4a2a82a21aabc68af811"
    "ar"
  end
  language "be" do
    sha256 "3398c5abc95aea10c375746917e0262ab05e378c6660bd86a0aa6c4ec5e91f19"
    "be"
  end
  language "bg" do
    sha256 "a0b2ac56ed9a70042fbb16a5d8c7edb9e03e934c5567234a9332f1fa83f46469"
    "bg"
  end
  language "ca" do
    sha256 "359efc84298a9647ae83c4a64be47e6b02211d6f887c5414c29a7fd605ab0687"
    "ca"
  end
  language "cs" do
    sha256 "f86ea45ebe3adcfc50f6c65811b0266c5b9ac242935d1da31707d8c1f08be0c8"
    "cs"
  end
  language "cy" do
    sha256 "045631cfaa46d33c191091a3c08ff7bdad2e7c196607de3ee3815c4180bfb50b"
    "cy"
  end
  language "da" do
    sha256 "9f63e254ec822f9bf01a7eb8fad55da38e04c1ff12e1e78cd785bda5f0955797"
    "da"
  end
  language "de" do
    sha256 "8a606a4e17b811d2ac69d0fad714f588b1eefbe137969e57c2935a5c55443443"
    "de"
  end
  language "el" do
    sha256 "8c39361a07214a0f39d211289a21422640d5f931f95ac62c61f3dcbca8d1c92b"
    "el"
  end
  language "en-CA" do
    sha256 "b9d8fc12d718876b02d0cd9c62bf4682647ccd2163c51906687d65c9b9ef7f49"
    "en-CA"
  end
  language "en-GB" do
    sha256 "12f9bbed49f465c2d48d69d9dcdcb59c7eb3e5c29d843c41033d9652da2e3f59"
    "en-GB"
  end
  language "en", default: true do
    sha256 "d0d0b31db0b751468c206b75172f3e57c6d0b563e2b6b85e7cafa85f4a0ad9d1"
    "en-US"
  end
  language "es-ES" do
    sha256 "d43b652ae286cbfbbcd3d5968faaabab23c772759e57d70dd718778ef38327ef"
    "es-ES"
  end
  language "es-MX" do
    sha256 "14557edda5793ea6f6de836560bd36fe4231dffb94585a7b7841d8d71de7c333"
    "es-MX"
  end
  language "et" do
    sha256 "aa8f35721edf8e0e475a26c2314f9555e168ecba3957d08acd2f3ebffed99f8f"
    "et"
  end
  language "fi" do
    sha256 "658da688baf1a2ef0818eb5fe897eee035bb945a59f7fb0ca2cf9111aa86249f"
    "fi"
  end
  language "fr" do
    sha256 "1c96ce493151a6aeb29cfbdc8070c55e67634ac958349396f4c32ec9702cd5bd"
    "fr"
  end
  language "fy" do
    sha256 "9ccc28327953ec0568276ac0fb0941d01cf4d3819a58193557b439201d7b996a"
    "fy-NL"
  end
  language "ga" do
    sha256 "828395e9812c12f9d4ce9def5eed783103e88ce8ca99adfcd5bf40742f871572"
    "ga-IE"
  end
  language "gd" do
    sha256 "6de541537049916235190de2d33ed8fac5536abc625ac8e1ffecdd93c272f57a"
    "gd"
  end
  language "gl" do
    sha256 "f2ebcf7a5af3254a9a7c54b3d903a466ddd0180b7122dc6d0930d05929dc9606"
    "gl"
  end
  language "he" do
    sha256 "d55f09b1cf7f2ed4d4a75ed281d91e82e429dd668836c38df917bf0152d34011"
    "he"
  end
  language "hr" do
    sha256 "2fd7c49d0ee08049ab5932d36cf561a57a7ecc812562071d40766610a178defc"
    "hr"
  end
  language "hu" do
    sha256 "4c35da5934a4a6933cac3441c488e75bd063e3e4d81f645bed93e33302f0e68c"
    "hu"
  end
  language "hy" do
    sha256 "29639fcb505dfdd7063a8be727902ccdb6d861d9d807109bcd6c20838dea0880"
    "hy-AM"
  end
  language "is" do
    sha256 "88461e609051c3ca0d5fd5ba271fa2afc9bb865942d402de6bd3046202242e66"
    "is"
  end
  language "it" do
    sha256 "0b3620bc555aa437a6605eec5c4178f209116f0aab202f1211d799b35fbf0a2a"
    "it"
  end
  language "ja" do
    sha256 "76398af794e8accec8976c9e6571780ef23e8ff0fc8ba62cad1e8d28753831b4"
    "ja-JP-mac"
  end
  language "ka" do
    sha256 "4e2fa24b80c7e82460bd6d5e6b179be77043d906a6fd9c52daee4839c5ea5363"
    "ka"
  end
  language "ko" do
    sha256 "ace54e4306f6bc388a8ef364ecfb4243f9cff0cd684baaf267fe8a9819beea81"
    "ko"
  end
  language "lt" do
    sha256 "84b969add211619eedc4bb59a893e49c92dd4b270fa1f3237e52f2905ba7d638"
    "lt"
  end
  language "lv" do
    sha256 "7228a4b831b963edde60cdf5e4ec491717f0286aab364f3d8c4d72f258ebedc8"
    "lv"
  end
  language "ms" do
    sha256 "0300ff847da32e34db743f886352678cd72a814b34fd93767d05141564978f6f"
    "ms"
  end
  language "nb" do
    sha256 "3f06884178d47a5ceb71821e927378a669a3a6a3390ec81d057b073268716e5e"
    "nb-NO"
  end
  language "nl" do
    sha256 "817c260b3db197d619201f9aa7c891789b08260d48d9f197acc7fc63eb5937c1"
    "nl"
  end
  language "pa-IN" do
    sha256 "40401bad62ad6c5c98824e2fab17367b2dee663a534e481b25e686ab7aca4489"
    "pa-IN"
  end
  language "pl" do
    sha256 "fb9a6635fb055ee50b252a92f59ad39102fbd0e5b6a0de2b217b0eec58ca48f6"
    "pl"
  end
  language "pt" do
    sha256 "fca00c11eeb212d00d367836116965161869b91734ffe31226130a69088b6639"
    "pt-PT"
  end
  language "pt-BR" do
    sha256 "32ef599135f0fe6409b05af3de7c55aa0f8162319607e6a23da692a100f75e9c"
    "pt-BR"
  end
  language "rm" do
    sha256 "dc2067197e08d1a491f7b7ff117b517a094820a0ef1e44aefebbb83236a10eb6"
    "rm"
  end
  language "ro" do
    sha256 "b1b03caebdd72d2dbc3d71f43ba5880beb5811d46d2338507ce5d7d17bb5676a"
    "ro"
  end
  language "ru" do
    sha256 "4a1b946c1acb259aafa7d7c8dad37198b5b991e13e595fff6ca34b784ad6c99a"
    "ru"
  end
  language "sk" do
    sha256 "90ea43d16e4feff8af6f55d8369c64c53c0f104b852a0c4aa09809f17cba8338"
    "sk"
  end
  language "sl" do
    sha256 "f0ab4015dc62fdf9909530b85840dc36d277a32ad27a65d3b44ef908790563ec"
    "sl"
  end
  language "sq" do
    sha256 "6f24967b269636a08e8d36a6a4c296cf60dcd22a681a4a28246dbb9d50298988"
    "sq"
  end
  language "sr" do
    sha256 "e2edf3eb56c311fa4c1b1375d1fb47e6ed0620bd7dc67b084d1c72debe7aae50"
    "sr"
  end
  language "sv" do
    sha256 "d1e929ad1bfc37d69a9cba568484bf468c64f38384d4716b18ba10e6bfc6b3d2"
    "sv-SE"
  end
  language "th" do
    sha256 "e5e62f41546ea595bbd9b2d222947b1b87fae801f798018b28eb212f15322dba"
    "th"
  end
  language "tr" do
    sha256 "94ef7152c6832cb64783e3fccfec54ce7c65056411815b1fdab40925b5072ae5"
    "tr"
  end
  language "uk" do
    sha256 "d28d6ea8b7e7c6521188c86a1f40ac4c08292979d6fe63bead09ee7a1ad55a57"
    "uk"
  end
  language "uz" do
    sha256 "2562821b675883e94e984ab291959d592da303259090ff73b3d1f01219f8e9ad"
    "uz"
  end
  language "vi" do
    sha256 "69328ec7b3f9fdf54a998a8bf510807afb6e98869ce93275ad22b6fa08cec3e3"
    "vi"
  end
  language "zh-TW" do
    sha256 "f63210d9ba7cc63ae09b16604d7705bf41af970138da62c0f2be86dda89cb677"
    "zh-TW"
  end
  language "zh" do
    sha256 "d6501c3f72f73295f3eee448e1e638037bba806fcf76a36938091553c0744f3c"
    "zh-CN"
  end

  url "https://download-installer.cdn.mozilla.net/pub/thunderbird/releases/#{version}/mac/#{language}/Thunderbird%20#{version}.dmg",
      verified: "download-installer.cdn.mozilla.net/pub/thunderbird/"
  name "Mozilla Thunderbird ESR"
  name "Mozilla Thunderbird Extended Support Release"
  desc "Customizable email client"
  homepage "https://www.thunderbird.net/#{language}/download/esr/"

  livecheck do
    url "https://product-details.mozilla.org/1.0/thunderbird_versions.json"
    strategy :json do |json|
      json["THUNDERBIRD_ESR"]
    end
  end

  auto_updates true
  conflicts_with cask: "thunderbird"
  depends_on macos: ">= :catalina"

  app "Thunderbird.app"

  zap trash: [
    "~/Library/Application Support/com.apple.sharedfilelist/com.apple.LSSharedFileList.ApplicationRecentDocuments/org.mozilla.thunderbird*.sfl*",
    "~/Library/Caches/Thunderbird",
    "~/Library/Preferences/org.mozilla.thunderbird*.plist",
    "~/Library/Saved Application State/org.mozilla.thunderbird*.savedState",
    "~/Library/Thunderbird",
  ]
end
