cask "thunderbird" do
  version "132.0"

  language "af" do
    sha256 "b085c8311f0a77f25d5f658a0909751142350080331039c7896e36ba46c9515d"
    "af"
  end
  language "ar" do
    sha256 "9464e339eefefa1e6be46368ecc0afb1f557ff68638e0259c84119e9c760ecde"
    "ar"
  end
  language "be" do
    sha256 "c514ff9f5a22e269d13dada91f94b3bd5dc7354bd9e8df0653e311d83335b41a"
    "be"
  end
  language "bg" do
    sha256 "3e1cbf96aeaead92c227bbfc69ef84abf6aedc20486622a767fdc575a8646d64"
    "bg"
  end
  language "ca" do
    sha256 "d858c1cc16740f8dea212df9c7ee2b1587377de10b3a5bad2be0352d315a177f"
    "ca"
  end
  language "cs" do
    sha256 "f6fc62d433561c2efaacf502f831094ea53d12ca9fb153a2b0aed823c06d422d"
    "cs"
  end
  language "cy" do
    sha256 "b99baf50fdf4e1c5a77ab4741c14e62d0dcd1dae4d43d16ac685a776a9393609"
    "cy"
  end
  language "da" do
    sha256 "b0a32fc15b19aa3e1b0e8cae6a6343007acc6151af3677331e2d072ccb92e7aa"
    "da"
  end
  language "de" do
    sha256 "ff717cc2ce9a2e468e12bbf45d394319c8d8957b63604a87d08925a818b0b090"
    "de"
  end
  language "el" do
    sha256 "3c4ab29ff02d688ea863425edecbf014cfedd74e1358c24cb4c22486506eb866"
    "el"
  end
  language "en-CA" do
    sha256 "165af9e0b9259115fe5a81ddb691fd7a8b428b435ef02529b53a2efa93552fd8"
    "en-CA"
  end
  language "en-GB" do
    sha256 "70c160056f3fdc6401a10e954b458efbad326e2da197e5004799401964dcae7c"
    "en-GB"
  end
  language "en", default: true do
    sha256 "e01c068081eb2f73a7703f6d4f8d5803eaa8c5cd8f558fb534f4727edeba871d"
    "en-US"
  end
  language "es-ES" do
    sha256 "dd4178e667eb56e86ff0e9db012d7cda18ce5dd377fa0e61d702225c3ac539f1"
    "es-ES"
  end
  language "es-MX" do
    sha256 "2ce4b26ad85c9675b427b886393e334406e5421145f0d677fd3bf10e661c8578"
    "es-MX"
  end
  language "et" do
    sha256 "5d89fe097cbc308775086c39a3c389a2be3082c11d67623a9411407012a009c5"
    "et"
  end
  language "fi" do
    sha256 "c3d56ee0ec0cd6972e7ea6e399755ba071a7d54a99b4e8d39048313a634e8cb3"
    "fi"
  end
  language "fr" do
    sha256 "d35c2af220def051a946cc852fa3e8d9a4cb9bd871f949a450cbc6bafbc24ed8"
    "fr"
  end
  language "fy" do
    sha256 "181f718c005d71437b86ea9b2b1f65699de0494ae4dff0d6359dfd0ed963a9f6"
    "fy-NL"
  end
  language "ga" do
    sha256 "05e42a1cb7eeb1ac7354523686e75177a39b8d1aaa118a9ad0d41f88fddea926"
    "ga-IE"
  end
  language "gd" do
    sha256 "da780c6f22d7313263a0fbbc3c7704a76f3c8cad8f55f3e094b4707107d53414"
    "gd"
  end
  language "gl" do
    sha256 "9cfa63d421287cdb0d81a91a5eab0ba10d1ab831f01781772fbed6d68dd79943"
    "gl"
  end
  language "he" do
    sha256 "679c955c179d5ae579e11cdccc51788ff97023480176f1a2e034bc7cb515d888"
    "he"
  end
  language "hr" do
    sha256 "7fbb2016a3c448af9c2413217be1a565a0ac30e193669a23ef1a4930577148ca"
    "hr"
  end
  language "hu" do
    sha256 "4626e645e2faf9ec2bccea6eb74c5c98f6cbf0bbb8e5677612c659edd36598da"
    "hu"
  end
  language "hy" do
    sha256 "e797cea863479e4dab7ec86fc71dadade98d4a94ee96863c9a61e1d6034cae40"
    "hy-AM"
  end
  language "is" do
    sha256 "125b6a95974eeefa0d7347c67266f0759fbf719eb69de9203daa16228f7ecb96"
    "is"
  end
  language "it" do
    sha256 "2c99db656718b3b0b1a77ae07e3ef39b547df39fa16921140495bc64cb67c03b"
    "it"
  end
  language "ja" do
    sha256 "180fc379b5279e08396b751f727ab873fa6dff84b2123633e113c6464043a909"
    "ja-JP-mac"
  end
  language "ka" do
    sha256 "c72ab7ca97defce6e04afeb0fb389f8c789a800ff3ff9d8fa5951bc9c0179250"
    "ka"
  end
  language "ko" do
    sha256 "41cf055e843d21c59d8d94750a9bfebadabf387632145c688124e46687045d09"
    "ko"
  end
  language "lt" do
    sha256 "5e56ae52cd5e1e07812d47fb3030ada052eefc6c5a74514031e8f103bf8dbf20"
    "lt"
  end
  language "lv" do
    sha256 "c532d18495a1add4b180734e6958c7c3bad56f6a69f202db4e7d59163af522f3"
    "lv"
  end
  language "ms" do
    sha256 "a634ce11b63a7eee320076fe9b4c191c14db8e922192886b40f4bf48a22e8bf1"
    "ms"
  end
  language "nb" do
    sha256 "8703eca4ceedd4bfbb133872fb798ba5653cd7ebba9a96df8bda77f5c1d76afb"
    "nb-NO"
  end
  language "nl" do
    sha256 "84866f6362f64b17540f7d3498789df32fab8ad7277ff0712b36a347f4479a5e"
    "nl"
  end
  language "pa-IN" do
    sha256 "437f747cfc86aa352d30f91ff1a9da4001c57f00fb0fea816644faeb67ce28e4"
    "pa-IN"
  end
  language "pl" do
    sha256 "5cda167fb0e4aee574f8d53187eb9335644c79169538cfbb5d42f9a5b1f565ad"
    "pl"
  end
  language "pt" do
    sha256 "d112b96e81f52bf534f738d2bfd2b77fcda468a67982563747ab67857b6f0137"
    "pt-PT"
  end
  language "pt-BR" do
    sha256 "5eb1aa85a0a4a18c2d72d8b80028092d4d8ec428c6cdbcc31bf7cf3705ce5d19"
    "pt-BR"
  end
  language "rm" do
    sha256 "511a5682e77e77a99969230cfc8bceaaaee354ae4e5bff49b2d9b5463856b0ea"
    "rm"
  end
  language "ro" do
    sha256 "5c565ea8fbd436a44b0c2e5e1565db65eb96eff24a95d3e70421b2370cbbe8f8"
    "ro"
  end
  language "ru" do
    sha256 "b0fab0a4977a837a0a2d3392b2389edb729fc2ef2c8fd9a6e84cd65b2675fd5d"
    "ru"
  end
  language "sk" do
    sha256 "acb0aa7d1da1d19d4d94a03bb8d01a45c26730b3798a4f224967b38508d6666e"
    "sk"
  end
  language "sl" do
    sha256 "7a8220da5ef7754f6d653227f5364f4bc10af551dd2c0c62fe57b488df259c80"
    "sl"
  end
  language "sq" do
    sha256 "6e53a29e63c7e37169d1ed00068eb617f9e0dbe69aa77c1e90255ead22cbb020"
    "sq"
  end
  language "sr" do
    sha256 "59937a1a051ec09ca27ca05ea064071d153d85fddad0ccf3827bfe46a00976c6"
    "sr"
  end
  language "sv" do
    sha256 "3eed354736d778f4e80aa683ac0073c6fff99e303b059498a95961e3a08ed685"
    "sv-SE"
  end
  language "th" do
    sha256 "c3d9f101bc704b9fe96b8bf4517cd53d108af7b3c0379fa018f867da2a794282"
    "th"
  end
  language "tr" do
    sha256 "964008d91619912240d98fcbc1ffae4e236dff9152980e63b877d846a9e62b4c"
    "tr"
  end
  language "uk" do
    sha256 "9e316593d14dac06656196723f0a6fc14fcfc8e52a8587dc632a55ec4b0c46be"
    "uk"
  end
  language "uz" do
    sha256 "01243715696bedfef5783061cda9accee9981f1467e31bb52af1f6ad895c82f1"
    "uz"
  end
  language "vi" do
    sha256 "9a9364fbd532644129656822a612970ff279fd655758a9778aa76a399d279de0"
    "vi"
  end
  language "zh-TW" do
    sha256 "0cb4e606cc5c3beb3698d9cd02bb9053c58f1ff78ce1d482ec56b45d593bd47e"
    "zh-TW"
  end
  language "zh" do
    sha256 "836828c4290f02216ac6dfd7f120bed754968f9c1fb0d1d506ca1d56b546168d"
    "zh-CN"
  end

  url "https://download-installer.cdn.mozilla.net/pub/thunderbird/releases/#{version}/mac/#{language}/Thunderbird%20#{version}.dmg",
      verified: "download-installer.cdn.mozilla.net/pub/thunderbird/"
  name "Mozilla Thunderbird"
  desc "Customizable email client"
  homepage "https://www.thunderbird.net/#{language}/"

  livecheck do
    url "https://product-details.mozilla.org/1.0/thunderbird_versions.json"
    strategy :json do |json|
      json["LATEST_THUNDERBIRD_VERSION"]
    end
  end

  auto_updates true
  conflicts_with cask: "thunderbird@esr"
  depends_on macos: ">= :catalina"

  app "Thunderbird.app"

  zap trash: [
    "~/Library/Application Support/com.apple.sharedfilelist/com.apple.LSSharedFileList.ApplicationRecentDocuments/org.mozilla.thunderbird*.sfl*",
    "~/Library/Caches/Thunderbird",
    "~/Library/Preferences/org.mozilla.thunderbird*.plist",
    "~/Library/Saved Application State/org.mozilla.thunderbird*.savedState",
    "~/Library/Thunderbird",
  ]
end
