cask "thorium" do
  version "3.0.0"
  sha256 "340c04e31e750de699a838aca643b4c2c966751d7ad0627cd33f531e1b596d65"

  url "https://github.com/edrlab/thorium-reader/releases/download/v#{version}/Thorium-#{version}.dmg",
      verified: "github.com/edrlab/thorium-reader/"
  name "Thorium Reader"
  desc "Epub reader"
  homepage "https://www.edrlab.org/software/thorium-reader/"

  livecheck do
    url :url
    strategy :github_latest
  end

  conflicts_with cask: "alex313031-thorium"

  app "Thorium.app"

  zap trash: [
    "~/Library/Application Support/EDRLab.ThoriumReader",
    "~/Library/Preferences/io.github.edrlab.thorium.plist",
  ]

  caveats do
    requires_rosetta
  end
end
