cask "polyphone" do
  version "2.4.1,109"
  sha256 "2cb3e037333cb3307df408eb1b77bd4b8df1da5d97a476985fcca5cd63ed898b"

  url "https://www.polyphone.io/download/0/v#{version.csv.second}/Polyphone-MacOS_11.0-#{version.csv.first}.dmg",
      user_agent: :browser
  name "Polyphone"
  desc "Soundfont editor for quickly designing musical instruments"
  homepage "https://www.polyphone.io/en"

  livecheck do
    url "https://www.polyphone.io/en/software"
    regex(/Polyphone\s+(\d+(?:\.\d+)+).*download\?file_id=(\d+).*Mac OS \(/im)
    strategy :page_match do |page, regex|
      match = page.match(regex)
      next if match.blank?

      "#{match[1]},#{match[2]}"
    end
  end

  app "polyphone.app"

  zap trash: [
    "~/Library/Preferences/com.polyphone.Polyphone.plist",
    "~/Library/Saved Application State/fr.polyphone.Polyphone.savedState",
  ]

  caveats do
    requires_rosetta
  end
end
