cask "onecast" do
  version "2.1"
  sha256 :no_check

  url "https://onecast.me/downloads/OneCast.dmg"
  name "OneCast"
  desc "Xbox remote play"
  homepage "https://www.onecast.me/"

  livecheck do
    url "https://www.onecast.me/download/"
    regex(/>v(\d+(?:\.\d+)+)</i)
  end

  auto_updates true
  depends_on macos: ">= :big_sur"

  app "OneCast.app"

  zap trash: [
    "~/Library/Caches/com.onecast.macos",
    "~/Library/HTTPStorages/com.onecast.macos",
    "~/Library/Preferences/com.onecast.macos.plist",
    "~/Library/WebKit/com.onecast.macos",
  ]

  caveats do
    requires_rosetta
  end
end
