cask "malwarebytes" do
  version "4.21.9.5141"
  sha256 "b4f4c4a2b27b5f454feb64129eacb2209a76825f6d7dd828aa97973e63c31955"

  url "https://data-cdn.mbamupdates.com/web/mb#{version.major}_mac/Malwarebytes-Mac-#{version}.pkg",
      verified: "data-cdn.mbamupdates.com/web/"
  name "Malwarebytes for Mac"
  desc "Warns about malware, adware and spyware"
  homepage "https://www.malwarebytes.com/mac/"

  livecheck do
    url "https://downloads.malwarebytes.com/file/mb3-mac"
    strategy :header_match
  end

  auto_updates true
  depends_on macos: ">= :sierra"

  pkg "Malwarebytes-Mac-#{version}.pkg"

  uninstall launchctl: [
              "com.malwarebytes.mbam.frontend.agent",
              "com.malwarebytes.mbam.rtprotection.daemon",
              "com.malwarebytes.mbam.settings.daemon",
            ],
            quit:      "com.malwarebytes.mbam.frontend.agent",
            kext:      "com.malwarebytes.mbam.rtprotection",
            pkgutil:   "com.malwarebytes.mbam.*",
            delete:    "/Library/Application Support/Malwarebytes/MBAM",
            rmdir:     "/Library/Application Support/Malwarebytes"

  zap trash: [
    "~/Library/Application Support/com.malwarebytes.mbam.frontend.*",
    "~/Library/Caches/com.crashlytics.data/com.malwarebytes.mbam.frontend.*",
    "~/Library/Caches/com.malwarebytes.mbam.frontend.*",
    "~/Library/Caches/io.fabric.sdk.mac.data/com.malwarebytes.mbam.frontend.*",
    "~/Library/Preferences/com.malwarebytes.mbam.frontend.*",
    "~/Library/Saved Application State/com.malwarebytes.mbam.frontend.application.savedState",
  ]
end
