cask "font-noto-sans" do
  version "2.014"
  sha256 "1dffbaf31a0a699ee2c57dfb60c1a628010425301dd076cfb485adbe017352c1"

  url "https://github.com/notofonts/latin-greek-cyrillic/releases/download/NotoSans-v#{version}/NotoSans-v#{version}.zip",
      verified: "github.com/notofonts/"
  name "Noto Sans"
  homepage "https://notofonts.github.io/"

  livecheck do
    url :url
    regex(/^NotoSans-v?(\d+(?:\.\d+)+)$/i)
  end

  font "NotoSans/unhinted/variable-ttf/NotoSans-Italic[wdth,wght].ttf"
  font "NotoSans/unhinted/variable-ttf/NotoSans[wdth,wght].ttf"
  font "NotoSans/unhinted/ttf/NotoSans-Black.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-BlackItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-Bold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-BoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-Condensed.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedBlack.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedBlackItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedExtraBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedExtraBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedExtraLight.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedExtraLightItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedLight.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedLightItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedMedium.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedMediumItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedSemiBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedSemiBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedThin.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-CondensedThinItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensed.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedBlack.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedBlackItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedExtraBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedExtraBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedExtraLight.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedExtraLightItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedLight.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedLightItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedMedium.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedMediumItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedSemiBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedSemiBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedThin.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraCondensedThinItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraLight.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ExtraLightItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-Italic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-Light.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-LightItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-Medium.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-MediumItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-Regular.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensed.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedBlack.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedBlackItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedExtraBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedExtraBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedExtraLight.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedExtraLightItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedLight.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedLightItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedMedium.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedMediumItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedSemiBold.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedSemiBoldItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedThin.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-SemiCondensedThinItalic.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-Thin.ttf"
  font "NotoSans/unhinted/ttf/NotoSans-ThinItalic.ttf"

  # No zap stanza required
end
