cask "firefox@esr" do
  version "128.4.0"

  language "af" do
    sha256 "3a133a6aa78a162fcf15f476643024d001a4536ddf94b95ff9a77e361d5b5c69"
    "af"
  end
  language "ar" do
    sha256 "9071b8e02ab81d1365f73dfa2b6e44fd1c2e665ca8d24290d3084fe76d3cc4dd"
    "ar"
  end
  language "be" do
    sha256 "983efc592cc578d0f86f4b409b7254fd7e1a84efeadda8691f604efa91bdd908"
    "be"
  end
  language "bg" do
    sha256 "d863f5f7e52bf8944829cc6b9f02ab06d2cea6ca74db8704ce9f29da20c2e9cf"
    "bg"
  end
  language "bn" do
    sha256 "a461e25eb9080c64f87bb6e8fcfadf4349e7df7cd2f4487f26fe9073ccb346f7"
    "bn"
  end
  language "ca" do
    sha256 "3b73e752090eb8394d4dad7bb8069120234ec13aca1c09bbdeb19a3ec53ab7fe"
    "ca"
  end
  language "cs" do
    sha256 "ad13ef78fe16e82596079796a4716d291be29edce389ef2abf11373b923524ab"
    "cs"
  end
  language "de" do
    sha256 "dcca39c17ec13fef3dfbb5cfa64bcb6b6bcfa571823fb110f9f34886458809b1"
    "de"
  end
  language "en-CA" do
    sha256 "867f06d3b179838440f1f0b71c13020ce312d46ce879aaac4bddc1f5a66d4a21"
    "en-CA"
  end
  language "en-GB" do
    sha256 "801052ea4ac636bd139b42746613ac694844cd0e55c02ebd58bdf6c517f96f61"
    "en-GB"
  end
  language "en", default: true do
    sha256 "4b5ff9c847d76b0768e0a5be4ac82f320610a41188ad8ac21f48136bc27f117f"
    "en-US"
  end
  language "eo" do
    sha256 "0965a5ecacd86c72602a83807749c3b399a7a945446b700e5dd16789d915dffe"
    "eo"
  end
  language "es-AR" do
    sha256 "88dc8494f3e80fb22f7007c54208a652bb08a31079cd06b2be968c7bd5ceb5b7"
    "es-AR"
  end
  language "es-CL" do
    sha256 "c8378a8ef7a40f96ff095a5f67b41920ad027f9eb81a7fed4400534c0d611fd1"
    "es-CL"
  end
  language "es-ES" do
    sha256 "1ab9f16a3761218b75537ab7c7005e853a350c32f612f604a7c03dec6026d352"
    "es-ES"
  end
  language "fa" do
    sha256 "0fdb2cdf15667281d0834047345284783d173cc0fe41e89637fc8cb5d3d443ef"
    "fa"
  end
  language "ff" do
    sha256 "bede042d8ea17dc023b08d2a93a25faeba3ab715ae3458d60dc3f85f31cc5dbd"
    "ff"
  end
  language "fi" do
    sha256 "c308cf25c4bb5d2caf1a4dd9be1f9a75ff2d24842a6a65ce97b0adf3887ce448"
    "fi"
  end
  language "fr" do
    sha256 "ad6162122f02f627a53c838a94dbcd99b3266f0c4960f79c80b739c0e86da0c5"
    "fr"
  end
  language "gl" do
    sha256 "e57f29cd0f61c40fa551e93e4b7e083f990954e9520e4cca91ac1c8260064ae5"
    "gl"
  end
  language "gn" do
    sha256 "7796b16727b074148b6acca295f62ac463d5f080186e8d32d030a4930f7050f5"
    "gn"
  end
  language "gu" do
    sha256 "71ee47163ef7696bb39302800535167bfb9b3d08c4a1852b35c829b426b47dc3"
    "gu-IN"
  end
  language "he" do
    sha256 "25069e00556d75a588e848c3d42a42b779e54f68ddc03bee515e4d1a70671214"
    "he"
  end
  language "hi" do
    sha256 "69819ff97c3ec838fd227604494ba132168ec0794622c171ab5373d78292a0b1"
    "hi-IN"
  end
  language "in" do
    sha256 "69819ff97c3ec838fd227604494ba132168ec0794622c171ab5373d78292a0b1"
    "hi-IN"
  end
  language "it" do
    sha256 "562d31194eeb02e2772e83403c14d0f328c3d65254a9d5892af3eaac5b0c0193"
    "it"
  end
  language "ja" do
    sha256 "3fce3d526fd1a8d88b25544ac44a891742497e9237f73ad1cb43c4a22a823a4e"
    "ja-JP-mac"
  end
  language "ka" do
    sha256 "0420ba53f64a34908a2b98e34962d0a9e505219ebd181cea2473cc69f81fd157"
    "ka"
  end
  language "ko" do
    sha256 "bd42651cb65c16ceaaaf499456b9b2b67f401febbdd29dfb74b019781f385533"
    "ko"
  end
  language "mr" do
    sha256 "d251ff5d7f30fe37f7991e6c423a5a64a2828fca5e4f4fa0dd6444f94d9ed5b4"
    "mr"
  end
  language "my" do
    sha256 "dc272b55079988fe15bec3734bfacaabe7e25b2d65f86393c4f3d09528a0ded6"
    "my"
  end
  language "ne" do
    sha256 "fe94249d4cb5769f6727cd1759cc232fd7012f5826bb677c03961de09964c198"
    "ne-NP"
  end
  language "nl" do
    sha256 "669fb84cec7b894cf2d3f236ba728361e3818ab9eb5c8e95417207260e24d7b0"
    "nl"
  end
  language "pa-IN" do
    sha256 "f644667a1160a02abe82c6753ade0dd45cd85d7420a82e5555537d89186700be"
    "pa-IN"
  end
  language "pl" do
    sha256 "af9d72dec0fee1692accfbf78c009c8903c38987972e29330aa14fdea4758c01"
    "pl"
  end
  language "pt-BR" do
    sha256 "6caf6549d381a20d747f85477f4e20d808fcfdc9a6e35e03c68efadcc96e5af1"
    "pt-BR"
  end
  language "pt" do
    sha256 "3f08fac58e87e08b34445f0d126f232d843d5443ee307e315b60e693e849c7fb"
    "pt-PT"
  end
  language "ru" do
    sha256 "3ddebffc3fb90e77ac34e4ef4d64ab02f99d24daae1d6b812e147d4a947cfd75"
    "ru"
  end
  language "si" do
    sha256 "86ad3a8cebf65e2c16898be547e031c668ab330e6f4a463e23e2e13e0484b286"
    "si"
  end
  language "sq" do
    sha256 "eb80654907b19ab6adc52fe6e42e489fe28103013d2ced381f16436ca5303db1"
    "sq"
  end
  language "sr" do
    sha256 "d53499605d7279b4f66b9e3434d641cd98f0b2b9b4333aeed3909574dafb3c9b"
    "sr"
  end
  language "sv" do
    sha256 "9b2c35eb68d354e11212373c02ad3bed211a47b105fe7ec1d8d708ce8e2cf579"
    "sv-SE"
  end
  language "ta" do
    sha256 "fcb949ec68b33b2d2fb3e5e65313948abb859591baca72ddb7477ea365477907"
    "ta"
  end
  language "te" do
    sha256 "0111aa1ab97eac1609daec8070e1abc1b779ba9ad061f515a4a253ef6d045b4f"
    "te"
  end
  language "th" do
    sha256 "0bd2c6a08a1046edb4486369dca4e36e2e98b21b2c8f38928ef2a1839467364b"
    "th"
  end
  language "tl" do
    sha256 "c8cf401efd8bf0b1fb4577a799d674d8ff876530069d8cb832fcff10aa5e4d82"
    "tl"
  end
  language "tr" do
    sha256 "3f9c6e2ed540a85e9bcfc344c1735f8f195d94f3543afb0375426747fabb8cdb"
    "tr"
  end
  language "uk" do
    sha256 "eb78e877e8ef64a8e32bfb897d2654a219904963a1773cc61b9209cebf04219c"
    "uk"
  end
  language "ur" do
    sha256 "ed3620a9623411ee381dcbd719791714c63e1e8a9beeabd087ea7381e271c259"
    "ur"
  end
  language "zh-TW" do
    sha256 "9760770652b51cb2b991f69e048dc4ff29149ca6431864a07f8c3ae5ab17c86e"
    "zh-TW"
  end
  language "zh" do
    sha256 "3fc28343ee308c920b232993521d978659147c066cd3681fc55ad570f1ecc6cd"
    "zh-CN"
  end

  url "https://download-installer.cdn.mozilla.net/pub/firefox/releases/#{version}esr/mac/#{language}/Firefox%20#{version}esr.dmg",
      verified: "download-installer.cdn.mozilla.net/pub/firefox/releases/"
  name "Mozilla Firefox ESR"
  name "Mozilla Firefox Extended Support Release"
  desc "Web browser"
  homepage "https://www.mozilla.org/en-US/firefox/all/#product-desktop-esr"

  livecheck do
    url "https://product-details.mozilla.org/1.0/firefox_versions.json"
    regex(/v?(\d+(?:\.\d+)+)/i)
    strategy :json do |json, regex|
      match = json["FIREFOX_ESR"]&.match(regex)
      next if match.blank?

      match[1]
    end
  end

  auto_updates true
  conflicts_with cask: [
    "firefox",
    "firefox@beta",
    "firefox@cn",
  ]
  depends_on macos: ">= :catalina"

  app "Firefox.app"

  uninstall quit:   "org.mozilla.firefox",
            delete: "/Library/Logs/DiagnosticReports/firefox_*"

  zap trash: [
        "~/Library/Application Support/com.apple.sharedfilelist/com.apple.LSSharedFileList.ApplicationRecentDocuments/org.mozilla.firefox.sfl*",
        "~/Library/Application Support/CrashReporter/firefox_*",
        "~/Library/Application Support/Firefox",
        "~/Library/Caches/Firefox",
        "~/Library/Caches/Mozilla/updates/Applications/Firefox",
        "~/Library/Caches/org.mozilla.crashreporter",
        "~/Library/Caches/org.mozilla.firefox",
        "~/Library/Preferences/org.mozilla.crashreporter.plist",
        "~/Library/Preferences/org.mozilla.firefox.plist",
        "~/Library/Saved Application State/org.mozilla.firefox.savedState",
        "~/Library/WebKit/org.mozilla.firefox",
      ],
      rmdir: [
        "~/Library/Application Support/Mozilla", #  May also contain non-Firefox data
        "~/Library/Caches/Mozilla",
        "~/Library/Caches/Mozilla/updates",
        "~/Library/Caches/Mozilla/updates/Applications",
      ]
end
