cask "firefox" do
  version "132.0.1"

  language "af" do
    sha256 "c7cbc2fc11d4497cdb51e4f4d1c6a0e7d3519bdb4fea54e5631ff753d30f3858"
    "af"
  end
  language "ar" do
    sha256 "5bb80e1e00eb81fa200727a8505764f3bf36dabc45ad3b91254fbc1347d30148"
    "ar"
  end
  language "be" do
    sha256 "908b019ca04c8c1e19b2a467b923128c06166bef4ecf8bf9e905a180db9ba344"
    "be"
  end
  language "bg" do
    sha256 "4dfb40097ffa0b452107f9df6aeb549f82bbc9ff7ced27f711052615f2039d1d"
    "bg"
  end
  language "bn" do
    sha256 "0254a9f895dd278e5291f23780a0d24cf22774d67b4e71157face958375d4554"
    "bn"
  end
  language "ca" do
    sha256 "23a64d1c2bd949de7a10020f97943af28876758f227a642ad3264491428095e8"
    "ca"
  end
  language "cs" do
    sha256 "ce1561d3090e1e6b88e9dc3c1f0f9c0af0edb010779aee0238dcb5aef60dfd58"
    "cs"
  end
  language "de" do
    sha256 "76a52faa5ec11fa2102c1d70158c4672bdd9b5175b4efc8b46114f0be1e3e0ff"
    "de"
  end
  language "en-CA" do
    sha256 "caca05993926e8e7a5e21d9c34f98a2880b4ed24d9df55121207f4fe21c158b2"
    "en-CA"
  end
  language "en-GB" do
    sha256 "7a3b83b02a5167fdb4526b6247373cde6592e3f92343f4ff914102d3dc34275d"
    "en-GB"
  end
  language "en", default: true do
    sha256 "409c0bdb4e434c1191b71504626f8165b01e2582e561a870591940186614be2e"
    "en-US"
  end
  language "eo" do
    sha256 "2c495e569f61418ba64864d5938e75e97bab18aa9e4da96cf2d44052a8d53872"
    "eo"
  end
  language "es-AR" do
    sha256 "40bfa78cf2e8378cdd4dafb5cc8eefff04f73d5df96734495d5d55205b7cbae8"
    "es-AR"
  end
  language "es-CL" do
    sha256 "824f6a345d94aa11b88737bf6cec7570cd7529bbc80682f2cb8dcd5100648817"
    "es-CL"
  end
  language "es-ES" do
    sha256 "1ee25ecfc34d113df102dccf1741d4b34b7bf63f62a1f97733be900143cd0c96"
    "es-ES"
  end
  language "fa" do
    sha256 "ea4c01d101f9ad3a28ce2e39acb4a153a2eff57952a4074e12396c527530dce2"
    "fa"
  end
  language "ff" do
    sha256 "35eb29b70b40229c45f418637d7662ef7e05cc4ef4c593a499595d8f9b287201"
    "ff"
  end
  language "fi" do
    sha256 "81e0ef9630b7d2b10db996ae47328be7c761c326c001e9ed772758511301110a"
    "fi"
  end
  language "fr" do
    sha256 "62853c06f62366cbed451d6d68658f19da2a47742ad455253b37b0194c8639da"
    "fr"
  end
  language "gl" do
    sha256 "66054f8417ecbd143727581b82d778e1da09b4584550357829d781ff676fcafa"
    "gl"
  end
  language "gn" do
    sha256 "575172f0ce47810b17faa099409a3dddc35387ca7e9737b9fd64c5323db2f67a"
    "gn"
  end
  language "gu" do
    sha256 "ac5cb2d8cb7b2321f6b1b193e2e14775b3463764e87d257dd8d2d917ad76e2eb"
    "gu-IN"
  end
  language "he" do
    sha256 "e76af03d1bbafd4101b204d35c73627ba2883ac5874e6d332a3eecbc296e9c2d"
    "he"
  end
  language "hi" do
    sha256 "f48848c753a8681931eba9574a270c12618efeacea9755870211a859e8fa25fe"
    "hi-IN"
  end
  language "in" do
    sha256 "f48848c753a8681931eba9574a270c12618efeacea9755870211a859e8fa25fe"
    "hi-IN"
  end
  language "it" do
    sha256 "73da1a304cc69fcf2ba95836856bee4d81a1004138d760d0fb82ff1fe96d8826"
    "it"
  end
  language "ja" do
    sha256 "05bf3556de8a059cabbeb372ec02aeb42277708b9b25fc903425c16fda1fd387"
    "ja-JP-mac"
  end
  language "ka" do
    sha256 "3bb3ad1342acaca19cc1ad3a2175a62ec34462e421312947a207963e1e4f8459"
    "ka"
  end
  language "ko" do
    sha256 "b37dec1871705186b563cd1d42f0e2cb57ae0a2aee400329de2341930fb0231b"
    "ko"
  end
  language "mr" do
    sha256 "091eaa87934010dcd4c5f113951b46af27c960bf0737e27257561a664c39a21a"
    "mr"
  end
  language "my" do
    sha256 "29aa1be8ba0686adc0c03f41044319995f5d23c35c6f1c839c596a27395eec24"
    "my"
  end
  language "ne" do
    sha256 "c67a0f7326b7d37357529c68d7ae4c10efc634c34ed39110266e0c5d7bbfce4d"
    "ne-NP"
  end
  language "nl" do
    sha256 "344a2dc17944d44108c5d2a3c542302b382f56689a53eb134e518becb21a067c"
    "nl"
  end
  language "pa-IN" do
    sha256 "24c9a33e1182350ed9fb05b4d3d122ddcd833b3623dbdafcd9c4a77d089e4bd2"
    "pa-IN"
  end
  language "pl" do
    sha256 "97541ddaddad77740d0619d4a103286ecd85fac02ac5b0f52c35d60c05dc3d00"
    "pl"
  end
  language "pt-BR" do
    sha256 "3f982196bbe413a5eb59cdf53f9ca478d346ea012edf1c016b484b0719692557"
    "pt-BR"
  end
  language "pt" do
    sha256 "b9881d8d13b294946b787dc1c0e5dea65a279a07d3afaf9463ddf8b21eab206d"
    "pt-PT"
  end
  language "ru" do
    sha256 "720c15879cd03ba273499bf0a778de84700e709c72d8ccf384e5168476793361"
    "ru"
  end
  language "si" do
    sha256 "d1a208f12cc62153af27ae40b7868b40e3d0599dff38957615899ec8cb9ecb45"
    "si"
  end
  language "sq" do
    sha256 "bf4d4da003e9c7332acd18a246c31c71e0f93775c2c4ecdc3462545479f8ab15"
    "sq"
  end
  language "sr" do
    sha256 "dd3f0be2330f3e00cf74d9f7809c560fc99383d08d541c5a9e7484a36c425eb2"
    "sr"
  end
  language "sv" do
    sha256 "ac4410198d940e4bffc1809ad6634b2d0e0e0cbf08012dfd33ae7634cbfbfa6f"
    "sv-SE"
  end
  language "ta" do
    sha256 "5d2273e5aecc851aeb6dfd9812d79425f6525d024f3757cd944d0bf37ab1aa0a"
    "ta"
  end
  language "te" do
    sha256 "bb3af1148275417958fccf34d486a8f24e1f8011a2453c60cf0fa2d60cec9322"
    "te"
  end
  language "th" do
    sha256 "7d7035761ef1a167b596bf788e6eb68991b21388fa1089dc2e044f9750dfa8a9"
    "th"
  end
  language "tl" do
    sha256 "b9f2aa7c1d69a0b9b2444173ccede67f1cc04d06ae7ecc6a0720077bbfaab2e0"
    "tl"
  end
  language "tr" do
    sha256 "881818a2f7a4507067da424739a888c481292968a8bd25715d1997e099e8e985"
    "tr"
  end
  language "uk" do
    sha256 "d70c46c62ce5d883dcfa03a39d4e599b9f005e091983f499b926c24d6a107e8f"
    "uk"
  end
  language "ur" do
    sha256 "208270f7b0c7a5b13bf9fc47f78541fc58e37730d870dd28387df142983e3b3a"
    "ur"
  end
  language "zh-TW" do
    sha256 "4f3bab90dc946eb93870dd8847290d9683f5d798083b5b4efa9fbb24e69dd17e"
    "zh-TW"
  end
  language "zh" do
    sha256 "cf3a620b2722037d9b48e68a111aeb7f438a1ac7cec69775f75b05a333e48d05"
    "zh-CN"
  end

  url "https://download-installer.cdn.mozilla.net/pub/firefox/releases/#{version}/mac/#{language}/Firefox%20#{version}.dmg",
      verified: "download-installer.cdn.mozilla.net/pub/firefox/releases/"
  name "Mozilla Firefox"
  desc "Web browser"
  homepage "https://www.mozilla.org/firefox/"

  livecheck do
    url "https://product-details.mozilla.org/1.0/firefox_versions.json"
    strategy :json do |json|
      json["LATEST_FIREFOX_VERSION"]
    end
  end

  auto_updates true
  conflicts_with cask: [
    "firefox@beta",
    "firefox@cn",
    "firefox@esr",
  ]
  depends_on macos: ">= :catalina"

  app "Firefox.app"
  # shim script (https://github.com/Homebrew/homebrew-cask/issues/18809)
  shimscript = "#{staged_path}/firefox.wrapper.sh"
  binary shimscript, target: "firefox"

  preflight do
    File.write shimscript, <<~EOS
      #!/bin/bash
      exec '#{appdir}/Firefox.app/Contents/MacOS/firefox' "$@"
    EOS
  end

  uninstall quit: "org.mozilla.firefox"

  zap trash: [
        "/Library/Logs/DiagnosticReports/firefox_*",
        "~/Library/Application Support/com.apple.sharedfilelist/com.apple.LSSharedFileList.ApplicationRecentDocuments/org.mozilla.firefox.sfl*",
        "~/Library/Application Support/CrashReporter/firefox_*",
        "~/Library/Application Support/Firefox",
        "~/Library/Caches/Firefox",
        "~/Library/Caches/Mozilla/updates/Applications/Firefox",
        "~/Library/Caches/org.mozilla.crashreporter",
        "~/Library/Caches/org.mozilla.firefox",
        "~/Library/Preferences/org.mozilla.crashreporter.plist",
        "~/Library/Preferences/org.mozilla.firefox.plist",
        "~/Library/Saved Application State/org.mozilla.firefox.savedState",
        "~/Library/WebKit/org.mozilla.firefox",
      ],
      rmdir: [
        "~/Library/Application Support/Mozilla", #  May also contain non-Firefox data
        "~/Library/Caches/Mozilla",
        "~/Library/Caches/Mozilla/updates",
        "~/Library/Caches/Mozilla/updates/Applications",
      ]
end
