cask "filepane" do
  version "1.10.7,1576186002"
  sha256 "8a3ca4424b4a79485b6a4f9daf879b43430326628d18f38b6eccc1eae56ea5bd"

  url "https://dl.devmate.com/com.mymixapps.FilePane/#{version.csv.first}/#{version.csv.second}/FilePane-#{version.csv.first}.dmg",
      verified: "dl.devmate.com/com.mymixapps.FilePane/"
  name "FilePane"
  desc "File management multi-tool"
  homepage "https://mymixapps.com/filepane"

  # Appcast URL: https://updates.devmate.com/com.mymixapps.FilePane.xml
  livecheck do
    skip "Appcast only provides the version, no timestamp"
  end

  app "FilePane.app"

  zap trash: [
    "~/Library/Application Support/com.apple.sharedfilelist/com.apple.LSSharedFileList.ApplicationRecentDocuments/com.mymixapps.filepane.sfl*",
    "~/Library/Application Support/FilePane",
    "~/Library/Caches/com.mymixapps.FilePane",
    "~/Library/Preferences/com.mymixapps.FilePane.plist",
    "~/Users/Shared/FilePane/",
  ]

  caveats do
    requires_rosetta
  end
end
