cask "authy" do
  version "2.5.0"
  sha256 "7116fa3638eedc66f947acbd75380e1e0f10e0d7e71369e3bb39ce99f8299455"

  url "https://pkg.authy.com/authy/stable/#{version}/darwin/x64/Authy%20Desktop-#{version}.dmg"
  name "Authy Desktop"
  desc "Two-factor authentication software"
  homepage "https://authy.com/"

  deprecate! date: "2024-03-19", because: :discontinued

  auto_updates true

  app "Authy Desktop.app"

  zap trash: [
    "~/Library/Application Support/Authy Desktop",
    "~/Library/Caches/com.authy.authy-mac",
    "~/Library/Caches/com.authy.authy-mac.ShipIt",
    "~/Library/Cookies/com.authy.authy-mac.binarycookies",
    "~/Library/Preferences/com.authy.authy-mac.helper.plist",
    "~/Library/Preferences/com.authy.authy-mac.plist",
  ]

  caveats do
    requires_rosetta
  end
end
