-- 开启多语言
UPDATE `hkcms_config` SET `value`=1 WHERE  `name`="content_lang_on";
UPDATE `hkcms_config` SET `value`=1 WHERE  `name`="admin_lang_on";
UPDATE `hkcms_config` SET `value`=1 WHERE  `name`="index_lang_on";

-- 文档属性
insert  into `hkcms_flags` values (2,'Top','top',1,'en','normal',1650166154,1650166178);

-- 配置信息分区默认多语言
insert  into `hkcms_config` values (null,'basics','title','Site name','HkCms Open Source Content Management System','text',NULL,'请填写网站名称','','','',0,1,'en',NULL,1);
insert  into `hkcms_config` values (null,'basics','home_title','Home title','HkCms Demo site - homepage','text',NULL,'','','','',0,1,'en',NULL,1);
insert  into `hkcms_config` values (null,'basics','keyword','Home Keyword','Keywords, corporate site','textarea',NULL,'建议不超过100字符','','','',0,1,'en',NULL,1);
insert  into `hkcms_config` values (null,'basics','description','Home description','HkCms is a free and open source content management system, the core uses ThinkPHP6.0 framework and many other open source software, we have been committed to provide free and open source content management system for enterprises to build websites.','textarea',NULL,'建议不超过200字符','','','',0,1,'en',NULL,1);
insert  into `hkcms_config` values (null,'basics','icp','Case number','','text',NULL,'粤ICP备10000000号-1','','','',0,1,'en',NULL,3);
insert  into `hkcms_config` values (null,'basics','psrn','PSRN','','text',NULL,'','','','',0,1,'en',NULL,3);
insert  into `hkcms_config` values (null,'basics','logo','Website LOGO','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','image',NULL,'','','','',0,1,'en',NULL,8);
insert  into `hkcms_config` values (null,'basics','favicon','Address bar icon','/favicon.ico','image',NULL,'','','','',0,1,'en',NULL,8);

-- 单页增加联系字段
ALTER TABLE `hkcms_archives_single`
  ADD COLUMN `point` char(250) NOT NULL DEFAULT '' COMMENT '经纬度' AFTER `content`,
  ADD COLUMN `email` char(250) NOT NULL DEFAULT '' COMMENT '联系邮箱' AFTER `point`,
  ADD COLUMN `address` char(250) NOT NULL DEFAULT '' COMMENT '详细地址' AFTER `email`,
  ADD COLUMN `contact_info` char(250) NOT NULL DEFAULT '' COMMENT '联系方式' AFTER `address`,
  ADD COLUMN `company` char(250) NOT NULL DEFAULT '' COMMENT '公司名称' AFTER `contact_info`;

-- 单页模型字段
insert  into `hkcms_model_field` values (158,2,'point','经纬度','text','常规',250,'',NULL,0,0,'required','','','data-toggle=\"address\",data-point=\"frm-point\",data-address=\"frm-address\"',0,0,8,null,0,1,0,0,'normal',1617359532,1617358199);
insert  into `hkcms_model_field` values (159,2,'email','联系邮箱','text','常规',250,'',NULL,0,0,'','','','',0,0,10,null,0,1,0,0,'normal',1617358735,1617358619);
insert  into `hkcms_model_field` values (160,2,'address','详细地址','text','常规',250,'',NULL,0,0,'','','','',0,0,9,null,0,1,0,0,'normal',1617358658,1617358649);
insert  into `hkcms_model_field` values (161,2,'contact_info','联系方式','text','常规',250,'',NULL,0,0,'','','','',0,0,10,null,0,1,0,0,'normal',1617358728,1617358713);
insert  into `hkcms_model_field` values (162,2,'company','公司名称','text','常规',250,'',NULL,0,0,'','','','',0,0,10,null,0,1,0,0,'normal',1617358939,1617358939);

-- 单页字段绑定到栏目
insert  into `hkcms_model_field_bind` values (19,30,159,1637339961,1637339961);
insert  into `hkcms_model_field_bind` values (20,29,159,1637339961,1637339961);
insert  into `hkcms_model_field_bind` values (21,30,162,1637340007,1637340007);
insert  into `hkcms_model_field_bind` values (22,29,162,1637340007,1637340007);
insert  into `hkcms_model_field_bind` values (23,30,161,1637340036,1637340036);
insert  into `hkcms_model_field_bind` values (24,29,161,1637340036,1637340036);
insert  into `hkcms_model_field_bind` values (25,30,160,1637340039,1637340039);
insert  into `hkcms_model_field_bind` values (26,29,160,1637340039,1637340039);
insert  into `hkcms_model_field_bind` values (27,30,158,1637340043,1637340043);
insert  into `hkcms_model_field_bind` values (28,29,158,1637340043,1637340043);
insert  into `hkcms_model_field_bind` values (29,42,200,1657214389,1657214389);
insert  into `hkcms_model_field_bind` values (30,41,200,1657214389,1657214389);

-- 单页数据
insert  into `hkcms_archives` (`id`,`category_id`,`category_ids`,`model_id`,`admin_id`,`user_id`,`title`,`subtitle`,`thumb`,`seotitle`,`keywords`,`description`,`tags`,`style`,`weigh`,`author`,`url`,`diyname`,`views`,`flags`,`price`,`jumplink`,`comments`,`iscomment`,`collection`,`likes`,`dislikes`,`islogin`,`show_tpl`,`status`,`lang`,`publish_time`,`delete_time`,`update_time`,`create_time`) values (1,3,'',2,1,0,'HkCms 演示','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/c.jpg','','','公司简介说明','','',100,'','','',0,'',0.00,'',0,1,0,0,0,0,'page.html','normal','zh-cn','1636986256',null,'1636986256','1636986256');
insert  into `hkcms_archives` (`id`,`category_id`,`category_ids`,`model_id`,`admin_id`,`user_id`,`title`,`subtitle`,`thumb`,`seotitle`,`keywords`,`description`,`tags`,`style`,`weigh`,`author`,`url`,`diyname`,`views`,`flags`,`price`,`jumplink`,`comments`,`iscomment`,`collection`,`likes`,`dislikes`,`islogin`,`show_tpl`,`status`,`lang`,`publish_time`,`delete_time`,`update_time`,`create_time`) values (2,4,'',2,1,0,'HkCms Demo','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/c.jpg','','','Company profile description','','',100,'','','',0,'',0.00,'',0,1,0,0,0,0,'page.html','normal','en','1636986256',null,'1636986256','1636986256');
insert  into `hkcms_archives` (`id`,`category_id`,`category_ids`,`model_id`,`admin_id`,`user_id`,`title`,`subtitle`,`thumb`,`seotitle`,`keywords`,`description`,`tags`,`style`,`weigh`,`author`,`url`,`diyname`,`views`,`flags`,`price`,`jumplink`,`comments`,`iscomment`,`collection`,`likes`,`dislikes`,`islogin`,`show_tpl`,`status`,`lang`,`publish_time`,`delete_time`,`update_time`,`create_time`) values (3,7,'',2,1,0,'公司简介','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/c.jpg','','','公司简介说明','','',100,'','','',0,'',0.00,'',0,1,0,0,0,0,'page.html','normal','zh-cn','1636986256',null,'1636986256','1636986256');
insert  into `hkcms_archives` (`id`,`category_id`,`category_ids`,`model_id`,`admin_id`,`user_id`,`title`,`subtitle`,`thumb`,`seotitle`,`keywords`,`description`,`tags`,`style`,`weigh`,`author`,`url`,`diyname`,`views`,`flags`,`price`,`jumplink`,`comments`,`iscomment`,`collection`,`likes`,`dislikes`,`islogin`,`show_tpl`,`status`,`lang`,`publish_time`,`delete_time`,`update_time`,`create_time`) values (4,8,'',2,1,0,'Company Profile','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/c.jpg','','','Company Profile Description','','',100,'','','',0,'',0.00,'',0,1,0,0,0,0,'page.html','normal','en','1636986256',null,'1636986256','1636986256');
insert  into `hkcms_archives` (`id`,`category_id`,`category_ids`,`model_id`,`admin_id`,`user_id`,`title`,`subtitle`,`thumb`,`seotitle`,`keywords`,`description`,`tags`,`style`,`weigh`,`author`,`url`,`diyname`,`views`,`flags`,`price`,`jumplink`,`comments`,`iscomment`,`collection`,`likes`,`dislikes`,`islogin`,`show_tpl`,`status`,`lang`,`publish_time`,`delete_time`,`update_time`,`create_time`) values (5,29,'',2,1,0,'联系我们','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','seo标题','关键字,seo,联系我们','历史使人明智；诗词使人灵秀；数学使人周密；自然哲学使人深刻；伦理使人庄重；逻辑修辞学使人善辨。','','',100,'','','',0,'',0.00,'',0,1,0,0,0,0,'page_contact.html','normal','zh-cn','1636986256',null,'1636986256','1636986256');
insert  into `hkcms_archives` (`id`,`category_id`,`category_ids`,`model_id`,`admin_id`,`user_id`,`title`,`subtitle`,`thumb`,`seotitle`,`keywords`,`description`,`tags`,`style`,`weigh`,`author`,`url`,`diyname`,`views`,`flags`,`price`,`jumplink`,`comments`,`iscomment`,`collection`,`likes`,`dislikes`,`islogin`,`show_tpl`,`status`,`lang`,`publish_time`,`delete_time`,`update_time`,`create_time`) values (6,30,'',2,1,0,'Contact us','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','SEO title','keyword,seo,contact us','Histories make men wise ; poems witty; the mathematics subtle; natural philosophy deep ; moral grave ; logic and rhetoric able to contend .','','',100,'','','',0,'',0.00,'',0,1,0,0,0,0,'page_contact.html','normal','en','1636986256',null,'1636986256','1636986256');
insert  into `hkcms_archives` (`id`,`category_id`,`category_ids`,`model_id`,`admin_id`,`user_id`,`title`,`subtitle`,`thumb`,`seotitle`,`keywords`,`description`,`tags`,`style`,`weigh`,`author`,`url`,`diyname`,`views`,`flags`,`price`,`jumplink`,`comments`,`iscomment`,`collection`,`likes`,`dislikes`,`islogin`,`show_tpl`,`status`,`lang`,`publish_time`,`delete_time`,`update_time`,`create_time`) values (7,31,'',2,1,0,'我们有专业的团队，一流的服务。','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/ser.jpg','','关键字,seo,服务','','','',100,'','','',0,'',0.00,'',0,1,0,0,0,0,'page.html','normal','zh-cn','1636986256',null,'1636986256','1636986256');
insert  into `hkcms_archives` (`id`,`category_id`,`category_ids`,`model_id`,`admin_id`,`user_id`,`title`,`subtitle`,`thumb`,`seotitle`,`keywords`,`description`,`tags`,`style`,`weigh`,`author`,`url`,`diyname`,`views`,`flags`,`price`,`jumplink`,`comments`,`iscomment`,`collection`,`likes`,`dislikes`,`islogin`,`show_tpl`,`status`,`lang`,`publish_time`,`delete_time`,`update_time`,`create_time`) values (8,32,'',2,1,0,'We have a professional team and first-class service.','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/ser.jpg','','seo,service','','','',100,'','','',0,'',0.00,'',0,1,0,0,0,0,'page.html','normal','en','1636986256',null,'1636986256','1636986256');

insert  into `hkcms_archives_single` (`id`,`content`) values (1,'<p><span style=\"\">[演示数据]<span style=\"\">XXX公司是一家某省最早做大型设计电商平台的现代化互联网公司，多年大型电商平台建设经验，拥有一支技术过硬的电商平台建设团队。XXX公司主要从事大型电商设计，是一家专注于企业信息化和网络营销的公司，可以给客户提供快捷的互联网服务。能为大型企业提供专业电商服务。多年来以优质的服务，过硬的技术，贴心的用户体验，早就了多家大型电商平台的成功建设运营上线都受到广大消费者的赞美。[演示数据]</span></span><br></p>');
insert  into `hkcms_archives_single` (`id`,`content`) values (2,'<p><span style=\"\">XXX Company is a modern Internet company that was the first to design a large-scale e-commerce platform in a certain province. It has many years of experience in the construction of large-scale e-commerce platforms and has a highly skilled e-commerce platform construction team. XXX company is mainly engaged in large-scale e-commerce design. It is a company that focuses on enterprise informatization and network marketing, and can provide customers with fast Internet services. Can provide professional e-commerce services for large enterprises. Over the years, with high-quality services, excellent technology, and intimate user experience, many large-scale e-commerce platforms have been successfully constructed and operated for a long time and have been praised by consumers. [Demo Data]</span><br></p>');
insert  into `hkcms_archives_single` (`id`,`content`) values (3,'<p>[演示数据]XXX公司是一家某省最早做大型设计电商平台的现代化互联网公司，多年大型电商平台建设经验，拥有一支技术过硬的电商平台建设团队。XXX公司主要从事大型电商设计，是一家专注于企业信息化和网络营销的公司，可以给客户提供快捷的互联网服务。能为大型企业提供专业电商服务。多年来以优质的服务，过硬的技术，贴心的用户体验，早就了多家大型电商平台的成功建设运营上线都受到广大消费者的赞美。[演示数据]<br></p>');
insert  into `hkcms_archives_single` (`id`,`content`) values (4,'<p>XXX Company is a modern Internet company that was the first to design a large-scale e-commerce platform in a certain province. It has many years of experience in the construction of large-scale e-commerce platforms and has a highly skilled e-commerce platform construction team. XXX company is mainly engaged in large-scale e-commerce design. It is a company that focuses on enterprise informatization and network marketing, and can provide customers with fast Internet services. Can provide professional e-commerce services for large enterprises. Over the years, with high-quality services, excellent technology, and intimate user experience, many large-scale e-commerce platforms have been successfully constructed and operated for a long time and have been praised by consumers. [Demo Data]<br></p>');
insert  into `hkcms_archives_single` (`id`,`content`,`point`,`email`,`address`,`contact_info`,`company`) values (5,'','{\"lng\":116.404,\"lat\":39.915}','admin2@qq.com','北京市东城区中华路甲10号','400-123-1234,13013013011','公司名称');
insert  into `hkcms_archives_single` (`id`,`content`,`point`,`email`,`address`,`contact_info`,`company`) values (6,'','{\"lng\":116.404,\"lat\":39.915}','admin2@qq.com','10 China Road A, Dongcheng District, Beijing','400-123-1234,13013013011','Company Name');
insert  into `hkcms_archives_single` (`id`,`content`,`point`,`email`,`address`,`contact_info`,`company`) values (7,'<p><span style=\"\">[演示数据]XXX公司是一家某省最早做大型设计电商平台的现代化互联网公司，多年大型电商平台建设经验，拥有一支技术过硬的电商平台建设团队。XXX公司主要从事大型电商设计，是一家专注于企业信息化和网络营销的公司，可以给客户提供快捷的互联网服务。能为大型企业提供专业电商服务。多年来以优质的服务，过硬的技术，贴心的用户体验，早就了多家大型电商平台的成功建设运营上线都受到广大消费者的赞美。[演示数据]</span><br></p>','','','','','');
insert  into `hkcms_archives_single` (`id`,`content`,`point`,`email`,`address`,`contact_info`,`company`) values (8,'<p><span style=\"\">XXX Company is a modern Internet company that was the first to design a large-scale e-commerce platform in a certain province. It has many years of experience in the construction of large-scale e-commerce platforms and has a highly skilled e-commerce platform construction team. XXX company is mainly engaged in large-scale e-commerce design. It is a company that focuses on enterprise informatization and network marketing, and can provide customers with fast Internet services. Can provide professional e-commerce services for large enterprises. Over the years, with high-quality services, excellent technology, and intimate user experience, many large-scale e-commerce platforms have been successfully constructed and operated for a long time and have been praised by consumers. [Demo Data]</span><br></p>','','','','','');


-- 留言表单增加在线应聘
ALTER TABLE `hkcms_guestbook` ADD COLUMN `title` CHAR(100) DEFAULT '' NOT NULL COMMENT '申请职位' AFTER `content`;


-- 增加模型表
insert  into `hkcms_model` values (6,'产品模型','产品','product','archives_product','','Archives','more',0,1,'','','',1637055066,1637055066,'normal',null);
insert  into `hkcms_model` values (7,'图集模型','图集','images','archives_images','','Archives','more',0,1,'','','',1656558734,1656558734,'normal',null);
insert  into `hkcms_model` values (8,'招聘模型','招聘','job','archives_job','','Archives','more',0,1,'','','',1657164403,1657164403,'normal',NULL);

-- 增加产品表演示
DROP TABLE IF EXISTS `hkcms_archives_product`;
CREATE TABLE `hkcms_archives_product` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text,
  `images` text NULL DEFAULT NULL COMMENT '图集',
  `buylink` char(250) NOT NULL DEFAULT '' COMMENT '购买链接',
  `attr` text COMMENT '产品参数',
  `color` enum('red','blue','green','white','black') NOT NULL DEFAULT 'blue' COMMENT '颜色',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 产品模型字段
insert  into `hkcms_model_field` values (163,6,'title','标题','text','常规',200,'',NULL,0,0,'required','','','',1,1,1,null,1,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (164,6,'thumb','封面图','image','常规',100,'',NULL,0,0,'','','','',1,1,3,null,1,1,0,0,'normal',1604564175,1600400154);
insert  into `hkcms_model_field` values (165,6,'keywords','关键词','text','SEO',200,'',NULL,0,0,'','多关键词之间用英文逗号隔开','','',1,1,15,null,0,1,0,0,'normal',1604564378,1600400833);
insert  into `hkcms_model_field` values (166,6,'description','描述','textarea','SEO',250,'',NULL,0,0,'','','','',1,1,16,null,0,1,0,0,'normal',1603937358,1600400870);
insert  into `hkcms_model_field` values (167,6,'show_tpl','内容模板','text','其他',100,'show.html',NULL,0,0,'','','','class=\"form-control selectpage\",data-select-only=\"true\",data-data=\"/cms.model/getTplName.html?type=show\",data-pagination=\"false\",data-key-field=\"name\"',1,1,24,null,0,1,0,0,'normal',1604561449,1600400927);
insert  into `hkcms_model_field` values (168,6,'publish_time','发布时间','datetime','其他',0,'',NULL,0,0,'','','','',1,1,23,null,0,1,0,1,'normal',1604563079,1600401003);
insert  into `hkcms_model_field` values (169,6,'weigh','排序','number','常规',11,'100',NULL,0,0,'','','','',1,1,8,null,0,1,0,0,'normal',1604564047,1600401198);
insert  into `hkcms_model_field` values (170,6,'content','内容','editor','常规',0,'',NULL,0,0,'','','','',0,1,7,null,1,1,0,0,'normal',1604565377,1600410507);
insert  into `hkcms_model_field` values (171,6,'status','状态','radio','常规',250,'normal','{\"normal\":\"\\u6b63\\u5e38\",\"hidden\":\"\\u7981\\u7528\",\"reject\":\"\\u62d2\\u7edd\",\"audit\":\"\\u5f85\\u5ba1\\u6838\"}',0,0,'','','','',1,1,11,null,0,1,0,0,'normal',1604041706,1604041706);
insert  into `hkcms_model_field` values (172,6,'author','作者','text','其他',250,'小编',NULL,0,0,'','','','',1,1,17,null,0,1,0,0,'normal',1604561438,1604557612);
insert  into `hkcms_model_field` values (173,6,'views','浏览量','number','其他',11,'0',NULL,0,0,'','','','',1,1,18,null,0,1,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (174,6,'subtitle','副标题','text','常规',200,'',NULL,0,0,'','','','',1,1,2,null,0,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (175,6,'user_id','投稿人','selectpage','常规',10,0,'{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"user\",\"show-field\":\"username\",\"key-field\":\"id\",\"search-field\":\"username,nickname\",\"and-or\":\"\",\"order-by\":\"\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"pagination\":\"1\"}',0,0,'','需要安装用户中心插件','','',1,1,3,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,0,0,0,'normal',1649942700,1649924031);
insert  into `hkcms_model_field` values (176,6,'flags','文档属性','selectpage','常规',100,'','{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"flags\",\"show-field\":\"title\",\"key-field\":\"name\",\"search-field\":\"title\",\"and-or\":\"\",\"order-by\":\"weigh desc\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"multiple\":\"1\",\"pagination\":\"1\",\"select-only\":\"1\",\"enable-lang\":\"1\"}',0,0,'','','','',1,1,4,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,0,0,'normal',1649942700,1649924031);
insert  into `hkcms_model_field` values (177,6,'price','价格','number','常规',10,'0',NULL,0,2,'','','','',1,1,4,null,1,1,0,1,'normal',1616492830,1616492650);
insert  into `hkcms_model_field` values (178,6,'diyname','自定义URL名','text','常规',100,'',NULL,0,0,'','用于地址栏访问的名称，支持字母,数字,-,_，若为空则采用文章ID','','',1,1,6,null,0,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (179,6,'iscomment','允许评论','radio','常规',1,'1','{\"1\":\"允许\",\"0\":\"不允许\"}',0,0,'','需要安装评论插件','','',1,1,9,null,0,1,0,0,'normal',1604041706,1604041706);
insert  into `hkcms_model_field` values (180,6,'islogin','访问限制','radio','常规',1,'0','{\"1\":\"需要登录\",\"0\":\"无限制\"}',0,0,'','需要安装用户中心插件','','',1,1,10,null,0,1,0,0,'normal',1604041706,1604041706);
insert  into `hkcms_model_field` values (181,6,'seotitle','seo标题','text','SEO',200,'',NULL,0,0,'','seo标题，为空则使用文章标题','','',1,1,14,null,0,1,0,0,'normal',1604564378,1600400833);
insert  into `hkcms_model_field` values (182,6,'jumplink','跳转链接','text','其他',255,'',NULL,0,0,'','设置文档跳转到外部链接','','',1,1,18,null,0,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (183,6,'likes','点赞数','number','其他',11,'0',NULL,0,0,'','','','',1,1,19,null,0,1,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (184,6,'dislikes','点踩数','number','其他',11,'0',NULL,0,0,'','','','',1,1,20,null,0,1,0,0,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (185,6,'comments','评论数','number','其他',11,'0',NULL,0,0,'','','','',1,1,21,null,0,0,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (186,6,'collection','收藏数','number','其他',11,'0',NULL,0,0,'','','','',1,1,22,null,0,0,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (187,6,'images','图集','images','常规',500,'',NULL,6,0,'required','','','',0,0,4,null,1,1,0,0,'normal',1637055273,1637055273);
insert  into `hkcms_model_field` values (188,6,'buylink','购买链接','text','常规',250,'',NULL,0,0,'','','','',0,0,4,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,0,0,'normal',1656515160,1656515119);
insert  into `hkcms_model_field` values (189,6,'attr','产品参数','array','常规',0,'','{\"key\":\"\\u53c2\\u6570\\u540d\",\"value\":\"\\u53c2\\u6570\\u503c\"}',0,0,'','','','',0,0,4,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,0,0,'normal',1656515397,1656515353);
insert  into `hkcms_model_field` values (190,6,'color','颜色','select','常规',250,'blue','{\"red\":\"\\u7ea2\\u8272\",\"blue\":\"\\u84dd\\u8272\",\"green\":\"\\u7eff\\u8272\",\"white\":\"\\u767d\\u8272\",\"black\":\"\\u9ed1\\u8272\"}',0,0,'','','','',0,0,4,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,1,0,'normal',1656516025,1656516018);

-- 增加图集模型字段
insert  into `hkcms_model_field` values (191,7,'title','标题','text','常规',200,'',NULL,0,0,'required','','','',1,1,1,null,1,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (192,7,'thumb','封面图','image','常规',100,'',NULL,0,0,'','','','',1,1,3,null,1,1,0,0,'normal',1604564175,1600400154);
insert  into `hkcms_model_field` values (193,7,'keywords','关键词','text','SEO',200,'',NULL,0,0,'','多关键词之间用英文逗号隔开','','',1,1,15,null,0,1,0,0,'normal',1604564378,1600400833);
insert  into `hkcms_model_field` values (194,7,'description','描述','textarea','SEO',250,'',NULL,0,0,'','','','',1,1,16,null,0,1,0,0,'normal',1603937358,1600400870);
insert  into `hkcms_model_field` values (195,7,'show_tpl','内容模板','text','其他',100,'show.html',NULL,0,0,'','','','class=\"form-control selectpage\",data-select-only=\"true\",data-data=\"/cms.model/getTplName.html?type=show\",data-pagination=\"false\",data-key-field=\"name\"',1,1,24,null,0,1,0,0,'normal',1604561449,1600400927);
insert  into `hkcms_model_field` values (196,7,'publish_time','发布时间','datetime','其他',0,'',NULL,0,0,'','','','',1,1,23,null,0,1,0,1,'normal',1604563079,1600401003);
insert  into `hkcms_model_field` values (197,7,'weigh','排序','number','常规',11,'100',NULL,0,0,'','','','',1,1,8,null,0,1,0,0,'normal',1604564047,1600401198);
insert  into `hkcms_model_field` values (198,7,'content','内容','editor','常规',0,'',NULL,0,0,'','','','',0,1,7,null,1,1,0,0,'normal',1604565377,1600410507);
insert  into `hkcms_model_field` values (199,7,'status','状态','radio','常规',250,'normal','{\"normal\":\"\\u6b63\\u5e38\",\"hidden\":\"\\u7981\\u7528\",\"reject\":\"\\u62d2\\u7edd\",\"audit\":\"\\u5f85\\u5ba1\\u6838\"}',0,0,'','','','',1,1,11,null,0,1,0,0,'normal',1604041706,1604041706);
insert  into `hkcms_model_field` values (200,7,'author','作者','text','其他',250,'小编',NULL,0,0,'','','','',1,1,17,null,0,1,0,0,'normal',1604561438,1604557612);
insert  into `hkcms_model_field` values (201,7,'views','浏览量','number','其他',11,'0',NULL,0,0,'','','','',1,1,18,null,0,1,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (202,7,'subtitle','副标题','text','常规',200,'',NULL,0,0,'','','','',1,1,2,null,0,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (203,7,'user_id','投稿人','selectpage','常规',10,0,'{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"user\",\"show-field\":\"username\",\"key-field\":\"id\",\"search-field\":\"username,nickname\",\"and-or\":\"\",\"order-by\":\"\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"pagination\":\"1\"}',0,0,'','需要安装用户中心插件','','',1,1,3,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,0,0,0,'normal',1649942700,1649924031);
insert  into `hkcms_model_field` values (204,7,'flags','文档属性','selectpage','常规',100,'','{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"flags\",\"show-field\":\"title\",\"key-field\":\"name\",\"search-field\":\"title\",\"and-or\":\"\",\"order-by\":\"weigh desc\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"multiple\":\"1\",\"pagination\":\"1\",\"select-only\":\"1\",\"enable-lang\":\"1\"}',0,0,'','','','',1,1,4,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,0,0,'normal',1649942700,1649924031);
insert  into `hkcms_model_field` values (205,7,'price','价格','number','常规',10,'0',NULL,0,2,'','','','',1,1,4,null,1,0,0,1,'normal',1616492830,1616492650);
insert  into `hkcms_model_field` values (206,7,'diyname','自定义URL名','text','常规',100,'',NULL,0,0,'','用于地址栏访问的名称，支持字母,数字,-,_，若为空则采用文章ID','','',1,1,6,null,0,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (207,7,'iscomment','允许评论','radio','常规',1,'1','{\"1\":\"允许\",\"0\":\"不允许\"}',0,0,'','需要安装评论插件','','',1,1,9,null,0,1,0,0,'normal',1604041706,1604041706);
insert  into `hkcms_model_field` values (208,7,'islogin','访问限制','radio','常规',1,'0','{\"1\":\"需要登录\",\"0\":\"无限制\"}',0,0,'','需要安装用户中心插件','','',1,1,10,null,0,1,0,0,'normal',1604041706,1604041706);
insert  into `hkcms_model_field` values (209,7,'seotitle','seo标题','text','SEO',200,'',NULL,0,0,'','seo标题，为空则使用文章标题','','',1,1,14,null,0,1,0,0,'normal',1604564378,1600400833);
insert  into `hkcms_model_field` values (210,7,'jumplink','跳转链接','text','其他',255,'',NULL,0,0,'','设置文档跳转到外部链接','','',1,1,18,null,0,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (211,7,'likes','点赞数','number','其他',11,'0',NULL,0,0,'','','','',1,1,19,null,0,1,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (212,7,'dislikes','点踩数','number','其他',11,'0',NULL,0,0,'','','','',1,1,20,null,0,1,0,0,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (213,7,'comments','评论数','number','其他',11,'0',NULL,0,0,'','','','',1,1,21,null,0,0,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (214,7,'collection','收藏数','number','其他',11,'0',NULL,0,0,'','','','',1,1,22,null,0,0,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (215,7,'images','图集','images','常规',1000,'',NULL,10,0,'','','','',0,0,4,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',1,1,0,0,'normal',1656560220,1656559756);

-- 招聘模型字段数据
insert  into `hkcms_model_field` values (216,8,'title','申请职位','text','常规',200,'',NULL,0,0,'required','','','',1,1,1,null,1,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (217,8,'thumb','封面图','image','常规',100,'',NULL,0,0,'','','','',1,1,3,null,1,1,0,0,'normal',1604564175,1600400154);
insert  into `hkcms_model_field` values (218,8,'keywords','关键词','text','SEO',200,'',NULL,0,0,'','多关键词之间用英文逗号隔开','','',1,1,15,null,0,1,0,0,'normal',1604564378,1600400833);
insert  into `hkcms_model_field` values (219,8,'description','描述','textarea','SEO',250,'',NULL,0,0,'','','','',1,1,16,null,0,1,0,0,'normal',1603937358,1600400870);
insert  into `hkcms_model_field` values (220,8,'show_tpl','内容模板','text','其他',100,'show.html',NULL,0,0,'','','','class=\"form-control selectpage\",data-select-only=\"true\",data-data=\"/cms.model/getTplName.html?type=show\",data-pagination=\"false\",data-key-field=\"name\"',1,1,24,null,0,1,0,0,'normal',1604561449,1600400927);
insert  into `hkcms_model_field` values (221,8,'publish_time','发布时间','datetime','其他',0,'',NULL,0,0,'','','','',1,1,23,null,0,1,0,1,'normal',1604563079,1600401003);
insert  into `hkcms_model_field` values (222,8,'weigh','排序','number','常规',11,'100',NULL,0,0,'','','','',1,1,8,null,0,1,0,0,'normal',1604564047,1600401198);
insert  into `hkcms_model_field` values (223,8,'content','内容','editor','常规',0,'',NULL,0,0,'','','','',0,1,7,null,1,1,0,0,'normal',1604565377,1600410507);
insert  into `hkcms_model_field` values (224,8,'status','状态','radio','常规',250,'normal','{\"normal\":\"\\u6b63\\u5e38\",\"hidden\":\"\\u7981\\u7528\",\"reject\":\"\\u62d2\\u7edd\",\"audit\":\"\\u5f85\\u5ba1\\u6838\"}',0,0,'','','','',1,1,11,null,0,1,0,0,'normal',1604041706,1604041706);
insert  into `hkcms_model_field` values (225,8,'author','作者','text','其他',250,'小编',NULL,0,0,'','','','',1,1,17,null,0,1,0,0,'normal',1604561438,1604557612);
insert  into `hkcms_model_field` values (226,8,'views','浏览量','number','其他',11,'0',NULL,0,0,'','','','',1,1,18,null,0,1,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (227,8,'subtitle','副标题','text','常规',200,'',NULL,0,0,'','','','',1,1,2,null,0,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (228,8,'user_id','投稿人','selectpage','常规',10,0,'{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"user\",\"show-field\":\"username\",\"key-field\":\"id\",\"search-field\":\"username,nickname\",\"and-or\":\"\",\"order-by\":\"\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"pagination\":\"1\"}',0,0,'','需要安装用户中心插件','','',1,1,3,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,0,0,0,'normal',1649942700,1649924031);
insert  into `hkcms_model_field` values (229,8,'flags','文档属性','selectpage','常规',100,'','{\"type\":\"table\",\"url\":\"\",\"url-show-field\":\"\",\"url-key-field\":\"\",\"url-search-field\":\"\",\"table\":\"flags\",\"show-field\":\"title\",\"key-field\":\"name\",\"search-field\":\"title\",\"and-or\":\"\",\"order-by\":\"weigh desc\",\"param\":{\"custom\":{\"status\":\"normal\"}},\"multiple\":\"1\",\"pagination\":\"1\",\"select-only\":\"1\",\"enable-lang\":\"1\"}',0,0,'','','','',1,1,4,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,0,0,'normal',1649942700,1649924031);
insert  into `hkcms_model_field` values (230,8,'price','价格','number','常规',10,'0',NULL,0,2,'','','','',1,1,4,null,1,0,0,1,'normal',1616492830,1616492650);
insert  into `hkcms_model_field` values (231,8,'diyname','自定义URL名','text','常规',100,'',NULL,0,0,'','用于地址栏访问的名称，支持字母,数字,-,_，若为空则采用文章ID','','',1,1,6,null,0,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (232,8,'iscomment','允许评论','radio','常规',1,'1','{\"1\":\"允许\",\"0\":\"不允许\"}',0,0,'','需要安装评论插件','','',1,1,9,null,0,1,0,0,'normal',1604041706,1604041706);
insert  into `hkcms_model_field` values (233,8,'islogin','访问限制','radio','常规',1,'0','{\"1\":\"需要登录\",\"0\":\"无限制\"}',0,0,'','需要安装用户中心插件','','',1,1,10,null,0,1,0,0,'normal',1604041706,1604041706);
insert  into `hkcms_model_field` values (234,8,'seotitle','seo标题','text','SEO',200,'',NULL,0,0,'','seo标题，为空则使用文章标题','','',1,1,14,null,0,1,0,0,'normal',1604564378,1600400833);
insert  into `hkcms_model_field` values (235,8,'jumplink','跳转链接','text','其他',255,'',NULL,0,0,'','设置文档跳转到外部链接','','',1,1,18,null,0,1,0,0,'normal',1604564165,1600400002);
insert  into `hkcms_model_field` values (236,8,'likes','点赞数','number','其他',11,'0',NULL,0,0,'','','','',1,1,19,null,0,1,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (237,8,'dislikes','点踩数','number','其他',11,'0',NULL,0,0,'','','','',1,1,20,null,0,1,0,0,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (238,8,'comments','评论数','number','其他',11,'0',NULL,0,0,'','','','',1,1,21,null,0,0,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (239,8,'collection','收藏数','number','其他',11,'0',NULL,0,0,'','','','',1,1,22,null,0,0,0,1,'normal',1604563975,1604561217);
insert  into `hkcms_model_field` values (240,8,'address','工作地点','text','常规',250,'',NULL,0,0,'','','','',0,0,6,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,0,0,'normal',1657184066,1657175926);
insert  into `hkcms_model_field` values (241,8,'degree','学历要求','select','常规',20,'不限','{\"\\u4e0d\\u9650\":\"\\u4e0d\\u9650\",\"\\u9ad8\\u4e2d\\u53ca\\u4ee5\\u4e0b\":\"\\u9ad8\\u4e2d\\u53ca\\u4ee5\\u4e0b\",\"\\u5927\\u4e13\":\"\\u5927\\u4e13\",\"\\u672c\\u79d1\":\"\\u672c\\u79d1\",\"\\u7855\\u58eb\":\"\\u7855\\u58eb\",\"\\u535a\\u58eb\":\"\\u535a\\u58eb\"}',0,0,'','','','',0,0,6,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,1,0,'normal',1657193252,1657176248);
insert  into `hkcms_model_field` values (242,8,'salary','薪资待遇','select','常规',20,'面议','{\"\\u9762\\u8bae\":\"\\u9762\\u8bae\",\"3-5K\":\"3-5K\",\"5-10K\":\"5-10K\",\"10-20K\":\"10-20K\"}',0,0,'','','','',0,0,6,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,1,0,'normal',1657193292,1657176628);
insert  into `hkcms_model_field` values (243,8,'nature','工作性质','select','常规',20,'全职','{\"\\u5168\\u804c\":\"\\u5168\\u804c\",\"\\u517c\\u804c\":\"\\u517c\\u804c\"}',0,0,'','','','',0,0,6,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,1,0,'normal',1657193319,1657181008);
insert  into `hkcms_model_field` values (244,8,'exp','工作经验','select','常规',20,'不限','{\"\\u4e0d\\u9650\":\"\\u4e0d\\u9650\",\"\\u5e94\\u5c4a\\u751f\":\"\\u5e94\\u5c4a\\u751f\",\"1\\u5e74\\u4ee5\\u5185\":\"1\\u5e74\\u4ee5\\u5185\",\"1-3\\u5e74\":\"1-3\\u5e74\",\"3-5\\u5e74\":\"3-5\\u5e74\",\"5-10\\u5e74\":\"5-10\\u5e74\",\"10\\u5e74\\u4ee5\\u4e0a\":\"10\\u5e74\\u4ee5\\u4e0a\"}',0,0,'','','','',0,0,6,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,1,0,'normal',1657184080,1657183634);
insert  into `hkcms_model_field` values (245,8,'number','招聘人数','text','常规',20,'',NULL,0,0,'','','','',0,0,6,'{\"ext\":\"\",\"filesize\":\"\",\"filter_option\":\"\"}',0,1,0,0,'normal',1657184083,1657183891);

insert  into `hkcms_model_field` values (246,6,'tags','TAG标签','text','常规',250,'',NULL,0,0,'','','','class=\"form-control selectpage\",data-show-field=\"title\",data-search-field=\"title\",data-key-field=\"title\",data-data=\"/tags/tags\",data-pagination=\"false\",data-multiple=\"true\"',1,1,6,NULL,0,1,0,0,'normal',1667096966,1667096966);
insert  into `hkcms_model_field` values (247,7,'tags','TAG标签','text','常规',250,'',NULL,0,0,'','','','class=\"form-control selectpage\",data-show-field=\"title\",data-search-field=\"title\",data-key-field=\"title\",data-data=\"/tags/tags\",data-pagination=\"false\",data-multiple=\"true\"',1,1,6,NULL,0,1,0,0,'normal',1667096966,1667096966);
insert  into `hkcms_model_field` values (248,8,'tags','TAG标签','text','常规',250,'',NULL,0,0,'','','','class=\"form-control selectpage\",data-show-field=\"title\",data-search-field=\"title\",data-key-field=\"title\",data-data=\"/tags/tags\",data-pagination=\"false\",data-multiple=\"true\"',1,1,6,NULL,0,1,0,0,'normal',1667096966,1667096966);

insert  into `hkcms_model_field` values (249,5,'title','申请职位','text','常规',200,'',NULL,0,0,'','','','',1,0,1,null,0,1,0,0,'normal',1604564165,1600400002);

-- 站点模块
insert  into `hkcms_recommend` values (1,1,'1',NULL,'home_banner','Homepage carousel',0,'en','normal',1636968234,1636968200);
insert  into `hkcms_recommend` values (2,1,'1',NULL,'home_banner','首页轮播图',0,'zh-cn','normal',1636968356,1636968200);
insert  into `hkcms_recommend` values (3,1,'3',NULL,'links','友情链接(HTML演示)',0,'zh-cn','normal',1636978556,1636978556);
insert  into `hkcms_recommend` values (4,1,'3',NULL,'links','Friendship link(HTML Demo)',0,'en','normal',1636979192,1636978556);
insert  into `hkcms_recommend` values (5,2,'1',NULL,'sub','Inner page banner',0,'en','normal',1637142422,1637142375);
insert  into `hkcms_recommend` values (6,2,'1',NULL,'sub','内页横幅',0,'zh-cn','normal',1637142445,1637142375);
insert  into `hkcms_recommend` values (7,1,'2',NULL,'video','视频演示',0,'zh-cn','normal',1637142445,1637142375);
insert  into `hkcms_recommend` values (8,1,'2',NULL,'video','Video demo',0,'en','normal',1637142445,1637142375);
insert  into `hkcms_recommend` values (9,1,'5',NULL,'link','友情链接',0,'zh-cn','normal',1656610216,1656610216);
insert  into `hkcms_recommend` values (10,1,'5',NULL,'link','Links',0,'en','normal',1656610243,1656610216);
insert  into `hkcms_recommend` values (11,1,'1',NULL,'partner','合作伙伴',0,'zh-cn','normal',1657460086,1657460086);
insert  into `hkcms_recommend` values (12,1,'1',NULL,'partner','Partner',0,'en','normal',1657460475,1657460086);


insert  into `hkcms_banner` values (1,1,1,1,'Fashion life, concept design','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner2.jpg','http://www.hkcms.cn','When Services Matters.Your Choice is Simple! We have a culturally diverse, forward thinking team looking for talent like.',NULL,1,0,'en','normal',1636968200,1636968200);
insert  into `hkcms_banner` values (2,2,1,1,'时尚生活、概念设计','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner2.jpg','http://www.hkcms.cn','当服务很重要时，您的选择很简单！我们拥有一支文化多元、具有前瞻性思维的团队，正在寻找类似的人才。',NULL,1,0,'zh-cn','normal',1636968200,1636968200);
insert  into `hkcms_banner` values (3,1,1,1,'Design industry','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner.jpg','https://gitee.com/Hk_Cms/HkCms','17 Years Of Excellence In.You have ideas, goals, and dreams. We have a culturally diverse, forward thinking team looking for talent like.',NULL,2,1,'en','normal',1636968200,1636968200);
insert  into `hkcms_banner` values (4,2,1,1,'设计行业','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner.jpg','https://gitee.com/Hk_Cms/HkCms','17 年的卓越成就。您有想法、目标和梦想。 我们拥有一支文化多元、具有前瞻性思维的团队，正在寻找类似的人才。',NULL,2,1,'zh-cn','normal',1636968200,1636968200);
insert  into `hkcms_banner` values (5,3,1,3,'','','',NULL,'<div class=\"link_list\" id=\"link\">\r\n友情链接：<a href=\"https://www.hkcms.cn/\" target=\"_blank\" title=\"HkCms官网\">HkCms官网</a> | <a href=\"http://doc.hkcms.cn/\" target=\"_blank\" title=\"使用手册\">使用手册</a> | \r\n<a href=\"https://gitee.com/Hk_Cms/HkCms/issues\" target=\"_blank\" title=\"BUG/建议反馈\">BUG/建议反馈</a>\r\n</div>',0,0,'zh-cn','normal',1636978556,1636978556);
insert  into `hkcms_banner` values (6,4,1,3,'','','',NULL,'<div class=\"link_list\" id=\"link\">\r\nFriendship link：<a href=\"https://www.hkcms.cn/\" target=\"_blank\" title=\"HkCms official website\">HkCms official website</a> | <a href=\"http://doc.hkcms.cn/\" target=\"_blank\" title=\"User manual\">User manual</a> | \r\n<a href=\"https://gitee.com/Hk_Cms/HkCms/issues\" target=\"_blank\" title=\"BUG/suggest feedback\">BUG/suggest feedback</a>\r\n</div>',0,0,'en','normal',1636978556,1636978556);
insert  into `hkcms_banner` values (7,5,2,1,'bannerA','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner4.jpg','','',NULL,1,0,'en','normal',1637142375,1637142375);
insert  into `hkcms_banner` values (8,6,2,1,'横幅A','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner4.jpg','','',NULL,1,0,'zh-cn','normal',1637142375,1637142375);
insert  into `hkcms_banner` values (9,5,2,1,'bannerB','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner5.jpg','','',NULL,2,0,'en','normal',1637142375,1637142375);
insert  into `hkcms_banner` values (10,6,2,1,'横幅B','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner5.jpg','','',NULL,2,0,'zh-cn','normal',1637142375,1637142375);
insert  into `hkcms_banner` values (11,1,1,1,'Promotional video','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner3.jpg','#','Learn about the entire design industry from the promotional video, click the button below to play the promotional video and learn more about us!',NULL,3,1,'en','normal',1636968200,1636968200);
insert  into `hkcms_banner` values (12,2,1,1,'宣传视频','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/banner3.jpg','#','从宣传视频了解整个设计行业，点击下方按钮播放宣传视频，更深入的了解我们！',NULL,3,1,'zh-cn','normal',1636968200,1636968200);
insert  into `hkcms_banner` values (13,7,1,2,'视频演示','','#','站点模块视频演示','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/ae38f8c7f57d48d5074bb7e199b6bec8.mp4',0,0,'zh-cn','normal',1656248247,1656248247);
insert  into `hkcms_banner` values (14,8,1,2,'Video demo','','#','Site Module Video Demo','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/ae38f8c7f57d48d5074bb7e199b6bec8.mp4',1,0,'en','normal',1656248247,1656248247);
insert  into `hkcms_banner` values (15,9,1,5,'HkCms官网','','https://www.hkcms.cn/','',NULL,0,1,'zh-cn','normal',1656610216,1656610216);
insert  into `hkcms_banner` values (16,9,1,5,'使用手册','','http://doc.hkcms.cn/','',NULL,0,1,'zh-cn','normal',1656610216,1656610216);
insert  into `hkcms_banner` values (17,9,1,5,'BUG/建议反馈','','https://gitee.com/Hk_Cms/HkCms/issues','',NULL,0,1,'zh-cn','normal',1656610216,1656610216);
insert  into `hkcms_banner` values (18,10,1,5,'HkCms','','https://www.hkcms.cn/','',NULL,1,1,'en','normal',1656610216,1656610216);
insert  into `hkcms_banner` values (19,10,1,5,'User Manual','','http://doc.hkcms.cn/','',NULL,2,1,'en','normal',1656610216,1656610216);
insert  into `hkcms_banner` values (20,10,1,5,'Gitee BUG','','https://gitee.com/Hk_Cms/HkCms/issues','',NULL,3,1,'en','normal',1656610216,1656610216);
insert  into `hkcms_banner` values (21,11,1,1,'伙伴1','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','演示数据',NULL,1,1,'zh-cn','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (22,11,1,1,'伙伴2','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','演示数据',NULL,2,1,'zh-cn','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (23,11,1,1,'伙伴3','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','演示数据',NULL,3,1,'zh-cn','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (24,11,1,1,'伙伴4','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','演示数据',NULL,4,1,'zh-cn','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (25,11,1,1,'伙伴5','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','演示数据',NULL,5,1,'zh-cn','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (26,11,1,1,'伙伴6','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','演示数据',NULL,6,1,'zh-cn','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (27,11,1,1,'伙伴7','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','演示数据',NULL,7,1,'zh-cn','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (28,11,1,1,'伙伴8','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','演示数据',NULL,8,1,'zh-cn','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (29,12,1,1,'Partner 1','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','demo data',NULL,1,1,'en','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (30,12,1,1,'Partner 2','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','demo data',NULL,2,1,'en','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (31,12,1,1,'Partner 3','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','demo data',NULL,3,1,'en','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (32,12,1,1,'Partner 4','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','demo data',NULL,4,1,'en','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (33,12,1,1,'Partner 5','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','demo data',NULL,5,1,'en','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (34,12,1,1,'Partner 6','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','demo data',NULL,6,1,'en','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (35,12,1,1,'Partner 7','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','demo data',NULL,7,1,'en','normal',1657460086,1657460086);
insert  into `hkcms_banner` values (36,12,1,1,'Partner 18','http://holuo.cn-gd.ufileos.com/hkcms/logo.png','/','demo data',NULL,8,1,'en','normal',1657460086,1657460086);



-- 栏目管理
insert  into `hkcms_category` values (1,0,0,'link','cms','hone','首页','/','','','','','','','',1,'_self',0,'zh-cn',1,10,NULL,1636979415,1636979415,'normal');
insert  into `hkcms_category` values (2,0,0,'link','cms','hone','Home','/','','','','','','','',1,'_self',0,'en',1,10,NULL,1636979429,1636979415,'normal');
insert  into `hkcms_category` values (3,2,0,'link','cms','about','关于我们','','','','','page.html','','','',1,'_self',0,'zh-cn',2,10,NULL,1636981343,1636981343,'normal');
insert  into `hkcms_category` values (4,2,0,'link','cms','about','About us','','','','','page.html','','','',1,'_self',0,'en',2,10,NULL,1636981369,1636981343,'normal');
insert  into `hkcms_category` values (5,1,3,'list','cms','honor','公司荣誉','','','','list_honor.html','show.html','','','',1,'_self',0,'zh-cn',4,10,NULL,1636988729,1636986900,'normal');
insert  into `hkcms_category` values (6,1,4,'list','cms','honor','Company honor','','','','list_honor.html','show.html','','','',1,'_self',0,'en',4,10,NULL,1636988489,1636986900,'normal');
insert  into `hkcms_category` values (7,2,3,'link','cms','cp','公司简介','','','','','page.html','','','演示数据-这是栏目的描述信息',1,'_self',0,'zh-cn',3,10,NULL,1636987541,1636986934,'normal');
insert  into `hkcms_category` values (8,2,4,'link','cms','cp','Company Profile','','','','','page.html','','','Presentation data - this is the description of the column',1,'_self',0,'en',3,10,NULL,1636987740,1636986934,'normal');
insert  into `hkcms_category` values (9,1,0,'category','cms','news','新闻中心','','','category.html','','','','','热门资讯、新闻动态、公司新闻',1,'_self',0,'zh-cn',6,5,NULL,1637052314,1637052314,'normal');
insert  into `hkcms_category` values (10,1,0,'category','cms','news','News','','','category.html','','','','','Hot news, news trends, company news',1,'_self',0,'en',6,5,NULL,1637052662,1637052314,'normal');
insert  into `hkcms_category` values (11,1,9,'list','cms','cd','公司新闻','','','','list.html','show.html','','','',1,'_self',0,'zh-cn',10,10,NULL,1637052822,1637052636,'normal');
insert  into `hkcms_category` values (12,1,10,'list','cms','cd','Company news','','','','list.html','show.html','','','',1,'_self',0,'en',10,10,NULL,1637052898,1637052636,'normal');
insert  into `hkcms_category` values (13,1,9,'list','cms','ind','行业资讯','','','','list.html','show.html','','','',1,'_self',0,'zh-cn',11,10,NULL,1637052636,1637052636,'normal');
insert  into `hkcms_category` values (14,1,10,'list','cms','ind','Industry news','','','','list.html','show.html','','','',1,'_self',0,'en',11,10,NULL,1637052889,1637052636,'normal');
insert  into `hkcms_category` values (15,1,9,'list','cms','other','其他资讯','','','','list.html','show.html','','','',1,'_self',0,'zh-cn',13,10,NULL,1637052636,1637052636,'normal');
insert  into `hkcms_category` values (16,1,10,'list','cms','other','Other info','','','','list.html','show.html','','','',1,'_self',0,'en',13,10,NULL,1637052867,1637052636,'normal');
insert  into `hkcms_category` values (17,8,0,'list','cms','job','Jobs','','','','list_job.html','show_job.html','','job','We look forward to help you in taking your company to new height.',1,'_self',0,'en',19,10,NULL,1637288210,1637288017,'normal');
insert  into `hkcms_category` values (18,8,0,'list','cms','job','人才招聘','','','','list_job.html','show_job.html','','招聘','在帮助客户寻找综合解决方案方面拥有超过 10 年的经验。',1,'_self',0,'zh-cn',19,10,NULL,1637288215,1637288017,'normal');
insert  into `hkcms_category` values (19,7,0,'list','cms','case','客户案例','','','','list_image.html','show_image.html','','SEO关键字','SEO描述',1,'_self',0,'zh-cn',18,6,NULL,1637289818,1637289702,'normal');
insert  into `hkcms_category` values (20,7,0,'list','cms','case','Customer case','','','','list_image.html','show_image.html','','SEO keywords','SEO description',1,'_self',0,'en',18,6,NULL,1637289809,1637289702,'normal');
insert  into `hkcms_category` values (21,6,0,'category','cms','product','产品展示','','','category_product.html','','','SEO标题','SEO关键字,演示数据','SEO描述演示数据',1,'_self',0,'zh-cn',14,10,NULL,1637295023,1637295023,'normal');
insert  into `hkcms_category` values (22,6,0,'category','cms','product','Product','','','category_product.html','','','SEO title','SEO keywords, demo data','SEO description demo data',1,'_self',0,'en',14,10,NULL,1637295057,1637295023,'normal');
insert  into `hkcms_category` values (23,6,21,'list','cms','wc','木椅','','','','list_product.html','show_product.html','','','',1,'_self',0,'zh-cn',15,10,NULL,1637317964,1637315946,'normal');
insert  into `hkcms_category` values (24,6,22,'list','cms','wc','Wooden Chair','','','','list_product.html','show_product.html','','','',1,'_self',0,'en',15,10,NULL,1637318012,1637315946,'normal');
insert  into `hkcms_category` values (25,6,21,'list','cms','sa','单人扶手椅','','','','list_product.html','show_product.html','','','',1,'_self',0,'zh-cn',17,10,NULL,1637318003,1637316027,'normal');
insert  into `hkcms_category` values (26,6,22,'list','cms','sa','Single Armchair','','','','list_product.html','show_product.html','','','',1,'_self',0,'en',17,10,NULL,1637318004,1637316027,'normal');
insert  into `hkcms_category` values (27,6,21,'list','cms','wb','木床','','','','list_product.html','show_product.html','','','',1,'_self',0,'zh-cn',16,10,NULL,1637318046,1637316067,'normal');
insert  into `hkcms_category` values (28,6,22,'list','cms','wb','Wooden Bed','','','','list_product.html','show_product.html','','','',1,'_self',0,'en',16,10,NULL,1637318050,1637316067,'normal');
insert  into `hkcms_category` values (29,2,0,'link','cms','us','联系我们','','','','','page_contact.html','','','',1,'_self',0,'zh-cn',20,10,NULL,1637318149,1637318114,'normal');
insert  into `hkcms_category` values (30,2,0,'link','cms','us','Contact us','','','','','page_contact.html','','','',1,'_self',0,'en',20,10,NULL,1637318152,1637318114,'normal');
insert  into `hkcms_category` values (31,2,3,'link','cms','ser','我们的服务','','','','','page.html','','','',1,'_self',0,'zh-cn',5,10,NULL,1637386778,1637386732,'normal');
insert  into `hkcms_category` values (32,2,4,'link','cms','ser','Our service','','','','','page.html','','','',1,'_self',0,'en',5,10,NULL,1637386768,1637386732,'normal');
insert  into `hkcms_category` values (33,5,30,'link','cms','msg','Message','','','','','page_guestbook.html','','','',0,'_self',0,'en',100,10,NULL,1637388362,1637388218,'normal');
insert  into `hkcms_category` values (34,5,29,'link','cms','msg','在线留言','','','','','page_guestbook.html','','','',0,'_self',0,'zh-cn',100,10,NULL,1637388300,1637388218,'normal');
insert  into `hkcms_category` values (35,1,9,'list','cms','mr','媒体报导','','','','list.html','show.html','','','',1,'_self',0,'zh-cn',12,10,NULL,1637052822,1637052636,'normal');
insert  into `hkcms_category` values (36,1,10,'list','cms','mr','Media reports','','','','list.html','show.html','','','',1,'_self',0,'en',12,10,NULL,1637052898,1637052636,'normal');
insert  into `hkcms_category` values (37,7,19,'list','cms','snsj','室内设计','','','','list_image.html','show_image.html','','','',1,'_self',0,'zh-cn',100,10,NULL,1656579210,1656579210,'normal');
insert  into `hkcms_category` values (38,7,20,'list','cms','snsj','Interior design','','','','list_image.html','show_image.html','','','',1,'_self',0,'en',100,10,NULL,1656579210,1656579210,'normal');
insert  into `hkcms_category` values (39,7,19,'list','cms','pmsj','平面设计','','','','list_image.html','show_image.html','','','',1,'_self',0,'zh-cn',100,10,NULL,1656579407,1656579407,'normal');
insert  into `hkcms_category` values (40,7,20,'list','cms','pmsj','Graphic design','','','','list_image.html','show_image.html','','','',1,'_self',0,'en',100,10,NULL,1656579407,1656579407,'normal');
insert  into `hkcms_category` values (41,5,18,'link','cms','zaixianzhaopin','在线招聘','','','','','page_guestbook.html','','','',0,'_self',0,'zh-cn',100,10,NULL,1657214351,1657214339,'normal');
insert  into `hkcms_category` values (42,5,17,'link','cms','zaixianzhaopin','Online jobs','','','','','page_guestbook.html','','','',0,'_self',0,'en',100,10,NULL,1657214339,1657214339,'normal');

-- 新闻模型
insert  into `hkcms_archives` values (10,6,'',1,1,0,'Honor certificate','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg','','','','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (11,6,'',1,1,0,'Honor certificate','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg','','','','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (12,6,'',1,1,0,'Honor certificate','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg','','','','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (13,6,'',1,1,0,'Honor certificate','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg','','','','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (14,5,'',1,1,0,'荣誉证书','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg','','','','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (15,5,'',1,1,0,'荣誉证书','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg','','','','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (16,5,'',1,1,0,'荣誉证书','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg','','','','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (17,5,'',1,1,0,'荣誉证书','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/honor.jpg','','','','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (18,12,'',1,1,0,'[Content pagination demo] Learning the Fundamentals of Generative Design','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','Design,demo data','Learning the Fundamentals of Generative Design.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (19,11,'',1,1,0,'[内容分页演示] 公司全新学习衍生式设计的基础知识','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','基础知识,演示数据','公司全新学习衍生式设计的基础知识，坚持一个行业前行。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (20,11,'',1,1,0,'[演示数据]送给生活中设计爱好者的顶级现代节日礼物','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','SEO自定义标题演示','SEO','通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (21,12,'',1,1,0,'[Demo Data]The Top Modern Holiday Gifts for the Design Lover in Your Life','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','SEO custom title demo','SEO','Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (22,11,'',1,1,0,'十二个设计师之内的多彩设计','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[演示数据],SEO,关键词,英文逗号','[演示数据]','HkCms,标签管理','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (23,12,'',1,1,0,'Inside Division Twelve’s Colorful Designs','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[Demo data], SEO, keywords, English comma','[Demo data]','HkCms,Tags,Hot','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (24,12,'',1,1,0,'This Modern Penthouse In Hong Kong Is a Neutral Lover’s Dream','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[Demo data], SEO, keywords, English comma','Give Modern. Give The Best.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (25,11,'',1,1,0,'香港这座现代顶层公寓是中性情人的梦想','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[演示数据],SEO,关键词,英文逗号','给现代。给予最好的。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (26,12,'',1,1,0,'A Modern Florida Home With Warm Woods + Metallic Accents','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[Demo data], SEO, keywords, English comma','[Demo Data]The open concept kitchen features minimalist white cabinets alongside eye-catching Officine Gullo appliances featuring brass accents.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (27,11,'',1,1,0,'温暖的树林+金属口音的现代佛罗里达住宅','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[演示数据],SEO,关键词,英文逗号','[演示数据]开放式概念厨房配有简约的白色橱柜，以及带有黄铜装饰的引人注目的 Officine Gullo 电器。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (28,11,'',1,1,0,'艺术与设计的基础[演示数据]','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[演示数据],SEO,关键词,英文逗号','艺术与设计的基础[演示数据]','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (29,12,'',1,1,0,'[Demo Data]The basis of art, design, and more','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[Demo data], SEO, keywords, English comma','[Demo Data]The basis of art, design, and more','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (30,12,'',1,1,0,'What do these examples have in common?','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','','line,shape,form,texture','Some very basic elements, including line, shape, form, texture, and balance.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (31,11,'',1,1,0,'这些例子有什么共同点？','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','','线条,形状,形式,纹理','一些非常基本的元素，包括线条、形状、形式、纹理和平衡。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (32,11,'',1,1,0,'线是连接两个或多个点的形状。它可以是胖的、瘦的、波浪形的或锯齿状的——不胜枚举。','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','','[演示数据],SEO,关键词,英文逗号','线是连接两个或多个点的形状。它可以是胖的、瘦的、波浪形的或锯齿状的——不胜枚举。每一种可能性都给这条线带来了略微不同的感觉。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (33,12,'',1,1,0,'A line is a shape that connects two or more points. It can be fat, thin, wavy, or jagged—the list goes on','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','','[Demo data], SEO, keywords, English comma','A line is a shape that connects two or more points. It can be fat, thin, wavy, or jagged—the list goes on. Every possibility gives the line a slightly different feel.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (34,12,'',1,1,0,'Lines can be used in more humble compositions, too—for organization, emphasis, or just decoration','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[Demo data], SEO, keywords, English comma','In the example below, lines have been used to create a flow chart that guides the reader’s eye from one element to the next.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (35,11,'',1,1,0,'行可以更多的使用简陋的成分， 太为组织，重点，或只是摆设','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[演示数据],SEO,关键词,英文逗号','在下面的例子中，线条被用来创建一个流程图，引导读者的视线从一个元素到下一个元素。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (36,12,'',1,1,0,'A shape is any two-dimensional area with a recognizable boundary. This includes circles, squares, triangles, and so on.','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[Demo data], SEO, keywords, English comma','Shapes fall into two distinct categories: geometric (or regular) and organic (where the shapes are more free form).','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (37,11,'',1,1,0,'形状是具有可识别边界的任何二维区域。这包括圆形、正方形、三角形等。','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[演示数据],SEO,关键词,英文逗号','形状分为两个不同的类别：几何（或规则）和有机（形状更自由）。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (38,11,'',1,1,0,'当一个形状变成 3D 时，我们称它为一个表格','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[演示数据],SEO,关键词,英文逗号','形式构成了现实世界中的各种事物，包括雕塑、建筑和其他三维物体。','关键字','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (39,12,'',1,1,0,'When a shape becomes 3D, we call it a form','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[Demo data], SEO, keywords, English comma','Forms make up a variety of things in the real world, including sculptures, architecture, and other three-dimensional objects.','keyword','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (40,14,'',1,1,0,'[Demo Data]The Top Modern Holiday Gifts for the Design Lover in Your Life2','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','SEO custom title demo','SEO','Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (41,16,'',1,1,0,'[Demo Data]The Top Modern Holiday Gifts for the Design Lover in Your Life3','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','SEO custom title demo','SEO','Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (42,13,'',1,1,0,'[演示数据]送给生活中设计爱好者的顶级现代节日礼物2','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','SEO自定义标题演示','SEO','通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (43,15,'',1,1,0,'[演示数据]送给生活中设计爱好者的顶级现代节日礼物3','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','SEO自定义标题演示','SEO','通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (44,14,'',1,1,0,'Texture is the physical quality of a surface','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[Demo data], SEO, keywords, English comma','Texture is the physical quality of a surface. Like form, it can be part of a three-dimensional object, as in the example below (a small prickly cactus in a shiny ceramic pot).','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (45,13,'',1,1,0,'纹理是表面的物理质量。','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[演示数据],SEO,关键词,英文逗号','纹理是表面的物理质量。像表单一样，它可以是一个三维物体，如下例所示（闪亮的陶瓷锅中的小带刺的仙人掌）。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (46,13,'',1,1,0,'在设计中，纹理增加了平面图像的深度和触感','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[演示数据],SEO,关键词,英文逗号','在设计中，纹理增加了平面图像的深度和触感。物体可以显得光滑、粗糙、坚硬或柔软，这取决于所使用的元素。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (47,14,'',1,1,0,'In design, texture adds depth and tactility to otherwise flat images.','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[Demo data], SEO, keywords, English comma','In design, texture adds depth and tactility to otherwise flat images. Objects can appear smooth, rough, hard, or soft, depending on the elements at play.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (48,15,'',1,1,0,'送给生活中设计爱好者的顶级现代节日礼物3','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','SEO自定义标题演示','SEO','通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (49,16,'',1,1,0,'The Top Modern Holiday Gifts for the Design Lover in Your Life3','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg','SEO custom title demo','SEO','Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (50,15,'',1,1,0,'平衡是视觉重量的平均分配。平衡会受到很多因素的影响，包括颜色、大小、数量和负空间。','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[演示数据],SEO,关键词,英文逗号','平衡是视觉重量的平均分配（更具体地说，任何一种元素吸引观众眼球的程度）。平衡会受到很多因素的影响，包括颜色、大小、数量和负空间。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (51,16,'',1,1,0,'Balance is the equal distribution of visual weight. Balance can be affected by many things, including color, size, number, and negative space.','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[Demo data], SEO, keywords, English comma','Balance is the equal distribution of visual weight (more specifically, how much any one element attracts the viewer’s eye). Balance can be affected by many things, including color, size, number, and negative space.','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (52,16,'',1,1,0,'Balance can be affected by many things, including color, size, number, and negative space.','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[Demo data], SEO, keywords, English comma','Balance is the equal distribution of visual weight (more specifically, how much any one element attracts the viewer’s eye). Balance can be affected by many things, including color, size, number, and negative space.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (53,15,'',1,1,0,'平衡会受到很多因素的影响，包括颜色、大小、数量和负空间。','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg','','[演示数据],SEO,关键词,英文逗号','平衡是视觉重量的平均分配（更具体地说，任何一种元素吸引观众眼球的程度）。平衡会受到很多因素的影响，包括颜色、大小、数量和负空间。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (54,16,'',1,1,0,'Many people, including designers and photographers, use a strategy called the rule of thirds','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[Demo data], SEO, keywords, English comma','Many people, including designers and photographers, use a strategy called the rule of thirds. This imagines your work area divided into a 3x3 grid.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (55,15,'',1,1,0,'许多人，包括设计师和摄影师，都使用一种称为三分法的策略','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[演示数据],SEO,关键词,英文逗号','许多人，包括设计师和摄影师，都使用一种称为三分法的策略。这将您的工作区想象成一个3x3 的网格。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (56,14,'',1,1,0,'[Demo data]including designers and photographers, use a strategy called the rule of thirds','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[Demo data], SEO, keywords, English comma','Many people, including designers and photographers, use a strategy called the rule of thirds. This imagines your work area divided into a 3x3 grid.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (57,13,'',1,1,0,'[演示数据]包括设计师和摄影师，都使用一种称为三分法的策略','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[演示数据],SEO,关键词,英文逗号','许多人，包括设计师和摄影师，都使用一种称为三分法的策略。这将您的工作区想象成一个3x3 的网格。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (58,36,'',1,1,0,'[Demo data]including designers and photographers, use a strategy called the rule of thirds','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[Demo data], SEO, keywords, English comma','Many people, including designers and photographers, use a strategy called the rule of thirds. This imagines your work area divided into a 3x3 grid.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (59,35,'',1,1,0,'[演示数据]包括设计师和摄影师，都使用一种称为三分法的策略','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[演示数据],SEO,关键词,英文逗号','许多人，包括设计师和摄影师，都使用一种称为三分法的策略。这将您的工作区想象成一个3x3 的网格。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (60,36,'',1,1,0,'including designers and photographers, use a strategy called the rule of thirds','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[Demo data], SEO, keywords, English comma','Many people, including designers and photographers, use a strategy called the rule of thirds. This imagines your work area divided into a 3x3 grid.','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','en',1636988345,null,1636988345,1636988345);
insert  into `hkcms_archives` values (61,35,'',1,1,0,'包括设计师和摄影师，都使用一种称为三分法的策略','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg','','[演示数据],SEO,关键词,英文逗号','许多人，包括设计师和摄影师，都使用一种称为三分法的策略。这将您的工作区想象成一个3x3 的网格。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show.html','normal','zh-cn',1636988345,null,1636988345,1636988345);



insert  into `hkcms_archives_base`(`id`,`content`) values (10,'');
insert  into `hkcms_archives_base`(`id`,`content`) values (11,'');
insert  into `hkcms_archives_base`(`id`,`content`) values (12,'');
insert  into `hkcms_archives_base`(`id`,`content`) values (13,'');
insert  into `hkcms_archives_base`(`id`,`content`) values (14,'');
insert  into `hkcms_archives_base`(`id`,`content`) values (15,'');
insert  into `hkcms_archives_base`(`id`,`content`) values (16,'');
insert  into `hkcms_archives_base`(`id`,`content`) values (17,'');
insert  into `hkcms_archives_base`(`id`,`content`) values (18,'<p><span style="">Manufacturing an industrial product that can go viral with your target audience is difficult.</span></p><p><span style="">&nbsp;There are so many elements that need to be optimized simultaneously: material, utility, space, strength, and so much more. This makes design the key differentiator of great products from the good ones, where the core challenge lies.&nbsp;</span></p><p><span style="">#page#</span></p><p><span style="">Traditional industrial design development is incredibly limited in nature. Be it the quality, quantity, or time efficiency, your manufacturing process loses a significant amount of potential and resources at this product development stage. This is where generative design comes in.</span></p><p><span style="">[Demo Data]</span></p>');
insert  into `hkcms_archives_base`(`id`,`content`) values (19,'<p><span style="">通过衍生式设计获得战略性以充分利用它。测试</span></p><p><span style="">制造一种可以在目标受众中传播开来的工业产品是很困难的。有很多元素需要同时优化：材料、实用性、空间、强度等等。这使得设计成为优秀产品与优秀产品的关键区别，而核心挑战就在于此。&nbsp;</span></p><p><span style="">#page#</span></p><p><span style="">传统的工业设计开发在本质上是极其有限的。无论是质量、数量还是时间效率，您的制造过程都会在这个产品开发阶段失去大量的潜力和资源。这就是衍生式设计的用武之地。</span></p><p><span style="">[演示数据]</span></p>');
insert  into `hkcms_archives_base`(`id`,`content`) values (20,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 在我们的生活中，我们可能都至少有一位美学家——一个欣赏事物的外观和它的运作方式的人。这不仅仅是喜欢漂亮的东西，而是对事物如何以及为什么以某种方式设计以及它如何让我们感到身临其境的真正欣赏。他们是您想要真正考虑到他们的礼物的人，因为当您找到完美的东西时，您就会知道它会让他们感到多么高兴。用这些现代节日礼物创意，在这个假日季节赠送精美设计的礼物。从装饰和玻璃器皿到游戏和技术，您生活中的设计爱好者会喜欢这些精选的高雅美感。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (21,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;502&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;We probably all have at least one aesthete in our lives – the one who appreciates the way something looks just as much as how it functions. It’s more than just liking pretty things, it’s that true appreciation for how and why something was designed a certain way and how it makes us feel being around it. They’re the ones whose gift you want to put real thought into because when you find that perfect something you know just how happy it will make them. Give the gift of beautiful design this holiday season with these modern holiday gift ideas. From decor and glassware to games and tech, the design lover in your life will love the elevated aesthetic of these picks.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (22,'<p><span style="">[演示数据] HkCms演示数据。</span><br></p>');
insert  into `hkcms_archives_base`(`id`,`content`) values (23,'<p>[Demo Data] HkCms demo data.</p>');
insert  into `hkcms_archives_base`(`id`,`content`) values (24,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;This tonal penthouse features a color and material palette of grey Japanese plastering, matte black rusted metal, warm wood, and subtle olive green accents.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (25,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;这间同色调的顶层公寓采用灰色日本灰泥、哑光黑色生锈金属、温暖的木材和微妙的橄榄绿色调的颜色和材料调色板。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (26,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;Glittering gold, luxe silver, brazen brass, unassuming bronze – most of us have a favorite we gravitate towards. Some go bold and mix metals, and when done right, it truly elevates the visual interest of a room. Others like to ease into metallics by starting with one finish and layering in a few accent pieces to make a space feel captivating. Metals can not only change the look of a space, but they also adjust the feel by adding warmth through bronze and matte gold, or a touch of glam by using chrome or brass. Pair with furniture and decor in bold or subtle textures and patterns, depending on where you fall between minimalism and maximalism, and your metallic elements will make any space shine.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;The open concept kitchen features minimalist white cabinets alongside eye-catching Officine Gullo appliances featuring brass accents. Burnished brass Aquitaine Pendants from RH hang above the white stone island. Even the tile backsplash glistens with brass inlays surrounded by white Thassos marble.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (27,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;闪闪发光的金色、奢华的银色、厚颜无耻的黄铜、不起眼的青铜——我们大多数人都有自己的最爱。有些人大胆地混合金属，如果做得好，它真正提升了房间的视觉趣味。其他人喜欢通过从一个饰面开始并在几个重点部分中分层来使空间变得迷人，从而轻松融入金属色。金属不仅可以改变空间的外观，还可以通过青铜和哑光金增添温暖感，或通过使用铬或黄铜增添一丝魅力，从而调整感觉。搭配大胆或微妙纹理和图案的家具和装饰，取决于您在极简主义和极简主义之间的位置，您的金属元素将使任何空间闪耀。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;[演示数据]&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;开放式概念厨房配有简约的白色橱柜，以及带有黄铜装饰的引人注目的 Officine Gullo 电器。RH 的抛光黄铜阿基坦吊坠悬挂在白色石头岛上。就连瓷砖后挡板上也闪烁着黄铜镶嵌物，周围环绕着白色的 Thassos 大理石。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (28,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;设计的基础是每一种视觉媒体的基础，从美术到现代网页设计。它们甚至出现在看似不重要的细节中，例如构成大多数作品的字体。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (29,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;The fundamentals of design are the foundation of every visual medium, from fine art to modern web design. They’re even present in seemingly unimportant details, like the fonts that make up most compositions.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (30,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;Some very basic elements, including line, shape, form, texture, and balance. They might not seem like much on their own, but together, they’re part of almost everything we see and create.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;The fundamentals can be intimidating at first, especially if you don’t consider yourself an artist. But keep an open mind—there’s a lot they can teach you about working with different assets and creating simple visuals from scratch.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (31,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 这些例子有什么共同点？一些非常基本的元素，包括线条、形状、形式、纹理和平衡。它们本身可能看起来并不多，但它们共同构成了我们所看到和创造的几乎所有事物的一部分。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;510&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;一开始，基本面可能令人生畏，特别是如果您不认为自己是艺术家。但是请保持开放的心态——他们可以教你很多关于使用不同资产和从头开始创建简单视觉效果的知识。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (32,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;线条在设计中经常出现；例如，在图纸和插图中。它们也常见于图形元素，如纹理、图案和背景。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;线是连接两个或多个点的形状。它可以是胖的、瘦的、波浪形的或锯齿状的——不胜枚举。每一种可能性都给这条线带来了略微不同的感觉。&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (33,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;Lines appear frequently in design; for example, in drawings and illustrations. They’re also common in graphic elements, like textures, patterns, and backgrounds.&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;A line is a shape that connects two or more points. It can be fat, thin, wavy, or jagged—the list goes on. Every possibility gives the line a slightly different feel.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (34,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;When working with lines, pay attention to things like weight, color, texture, and style. These subtle qualities can have a big impact on the way your design is perceived.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (35,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;使用线条时，请注意重量、颜色、纹理和样式等内容。这些微妙的品质会对您的设计被感知的方式产生重大影响。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (36,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;Shapes are a vital part of communicating ideas visually. They give images heft and make them recognizable. We understand street signs, symbols, and even abstract art largely because of shapes.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;Shapes have a surprising number of uses in everyday design. They can help you organize or separate content, create simple illustrations, or just add interest to your work. See if you can spot the many examples in the image below.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;Shapes are important because they’re the foundation of so many things. Learn to look for them in other designs, and soon you’ll start seeing them everywhere.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (37,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;形状是视觉传达思想的重要组成部分。它们赋予图像重量并使它们易于识别。我们了解路牌、符号，甚至抽象艺术，很大程度上是因为形状。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;形状在日常设计中有着惊人的用途。它们可以帮助您组织或分离内容、创建简单的插图，或者只是为您的工作增添趣味。看看您是否能在下图中找到许多示例。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;形状很重要，因为它们是许多事物的基础。学习在其他设计中寻找它们，很快您就会开始在任何地方看到它们。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (38,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;但是，形式不必是三维形状。它们也可以通过插图来暗示，使用 t运用光、影、透视等技巧来营造 深度错觉。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;在二维设计中，形式使现实主义成为可能. 没有它，像下图这样的效果图——一个带有高光和阴影的球——根本就不一样。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;即使是不太真实的图像使用类似的技术来创建维度。下面，照明和阴影是程式化的，但仍然暗示形式和深度。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;在日常构图中，形式的目的是相同的，但规模较小。例如，一个简单的阴影可以创造层次的错觉或给一个对象一个地方感.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;基本形式可以为您的工作带来一丝真实感，这是适度使用的强大工具。&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (39,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;However, forms don’t have to be three-dimensional shapes. They can also be implied through illustration, using techniques like light, shadow, and perspective to create the illusion of depth.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;In two-dimensional design, form makes realism possible. Without it, renderings like the image below—a ball with highlights and shading—simply wouldn’t be the same.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;Even images that are less realistic use similar techniques to create dimension. Below, the lighting and shading are stylized, but still hint at form and depth.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;In everyday composition, the purpose of form is the same, but on a smaller scale. For example, a simple shadow can create the illusion of layers or give an object a sense of place.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;Basic forms can bring a touch of realism to your work, which is a powerful tool when used in moderation.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (40,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;502&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;We probably all have at least one aesthete in our lives – the one who appreciates the way something looks just as much as how it functions. It’s more than just liking pretty things, it’s that true appreciation for how and why something was designed a certain way and how it makes us feel being around it. They’re the ones whose gift you want to put real thought into because when you find that perfect something you know just how happy it will make them. Give the gift of beautiful design this holiday season with these modern holiday gift ideas. From decor and glassware to games and tech, the design lover in your life will love the elevated aesthetic of these picks.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (41,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;502&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;We probably all have at least one aesthete in our lives – the one who appreciates the way something looks just as much as how it functions. It’s more than just liking pretty things, it’s that true appreciation for how and why something was designed a certain way and how it makes us feel being around it. They’re the ones whose gift you want to put real thought into because when you find that perfect something you know just how happy it will make them. Give the gift of beautiful design this holiday season with these modern holiday gift ideas. From decor and glassware to games and tech, the design lover in your life will love the elevated aesthetic of these picks.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (42,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 在我们的生活中，我们可能都至少有一位美学家——一个欣赏事物的外观和它的运作方式的人。这不仅仅是喜欢漂亮的东西，而是对事物如何以及为什么以某种方式设计以及它如何让我们感到身临其境的真正欣赏。他们是您想要真正考虑到他们的礼物的人，因为当您找到完美的东西时，您就会知道它会让他们感到多么高兴。用这些现代节日礼物创意，在这个假日季节赠送精美设计的礼物。从装饰和玻璃器皿到游戏和技术，您生活中的设计爱好者会喜欢这些精选的高雅美感。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (43,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 在我们的生活中，我们可能都至少有一位美学家——一个欣赏事物的外观和它的运作方式的人。这不仅仅是喜欢漂亮的东西，而是对事物如何以及为什么以某种方式设计以及它如何让我们感到身临其境的真正欣赏。他们是您想要真正考虑到他们的礼物的人，因为当您找到完美的东西时，您就会知道它会让他们感到多么高兴。用这些现代节日礼物创意，在这个假日季节赠送精美设计的礼物。从装饰和玻璃器皿到游戏和技术，您生活中的设计爱好者会喜欢这些精选的高雅美感。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (44,'&lt;p&gt;&lt;img height=&quot;340&quot; width=&quot;510&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;img height=&quot;340&quot; width=&quot;510&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (45,'&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new3.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (46,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;[演示数据]&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (47,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;[Demo data]&lt;/span&gt;&lt;br&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (48,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;通过这些现代节日礼物创意，从玻璃器皿和装饰到游戏和扬声器，在这个假日季节赠送精美设计的礼物。&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; width=&quot;502&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 在我们的生活中，我们可能都至少有一位美学家——一个欣赏事物的外观和它的运作方式的人。这不仅仅是喜欢漂亮的东西，而是对事物如何以及为什么以某种方式设计以及它如何让我们感到身临其境的真正欣赏。他们是您想要真正考虑到他们的礼物的人，因为当您找到完美的东西时，您就会知道它会让他们感到多么高兴。用这些现代节日礼物创意，在这个假日季节赠送精美设计的礼物。从装饰和玻璃器皿到游戏和技术，您生活中的设计爱好者会喜欢这些精选的高雅美感。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (49,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;Give the gift of beautiful design this holiday season with these modern holiday gift ideas, from glassware and decor to games and speakers.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img height=&quot;340&quot; width=&quot;502&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new1.jpg&quot; alt=&quot;Image&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;We probably all have at least one aesthete in our lives – the one who appreciates the way something looks just as much as how it functions. It’s more than just liking pretty things, it’s that true appreciation for how and why something was designed a certain way and how it makes us feel being around it. They’re the ones whose gift you want to put real thought into because when you find that perfect something you know just how happy it will make them. Give the gift of beautiful design this holiday season with these modern holiday gift ideas. From decor and glassware to games and tech, the design lover in your life will love the elevated aesthetic of these picks.&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (50,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;对于初学者来说，掌握平衡可能会很棘手，因为它确实需要一些直觉。幸运的是，设计世界充满了可以帮助您理解其不同迭代的示例。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;对称设计在轴的两侧相同或相似。他们感到平衡，因为每一方都有效地相同 （如果不相同）。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;不对称设计不同，但重量仍然均匀分布。成分是平衡的，因为它引起注意 到正确的事情（在这个例子中，人的姓名和公司标志）。&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (51,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;Mastering balance can be tricky for beginners because it does take some intuition. Luckily, the design world is full of examples that can help you understand its different iterations.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;Symmetrical&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&amp;nbsp;designs are the same or similar on both sides of an axis. They feel balanced because each side is effectively&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;the same&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&amp;nbsp;(if not identical).&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&lt;span style=&quot;&quot;&gt;Asymmetrical designs are different, but the weight is still evenly distributed. The composition is balanced because it calls attention to the right things (in this example, the person’s name and company logo).&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (52,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;Mastering balance can be tricky for beginners because it does take some intuition. Luckily, the design world is full of examples that can help you understand its different iterations.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;Symmetrical&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&amp;nbsp;designs are the same or similar on both sides of an axis. They feel balanced because each side is effectively&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;the same&lt;/span&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&amp;nbsp;(if not identical).&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;color: rgb(78, 78, 78);&quot;&gt;&lt;span style=&quot;&quot;&gt;Asymmetrical designs are different, but the weight is still evenly distributed. The composition is balanced because it calls attention to the right things (in this example, the person’s name and company logo).&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (53,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;对于初学者来说，掌握平衡可能会很棘手，因为它确实需要一些直觉。幸运的是，设计世界充满了可以帮助您理解其不同迭代的示例。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;对称设计在轴的两侧相同或相似。他们感到平衡，因为每一方都有效地相同 （如果不相同）。&lt;/span&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;&lt;span style=&quot;&quot;&gt;不对称设计不同，但重量仍然均匀分布。成分是平衡的，因为它引起注意 到正确的事情（在这个例子中，人的姓名和公司标志）。&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (54,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;We find this type of composition appealing because, according to studies, the human eye naturally follows this path when scanning a design.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (55,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;我们发现这种类型的构图很有吸引力，因为根据研究，人眼 自然会走这条路 扫描设计时。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (56,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;We find this type of composition appealing because, according to studies, the human eye naturally follows this path when scanning a design.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (57,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;我们发现这种类型的构图很有吸引力，因为根据研究，人眼 自然会走这条路 扫描设计时。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (58,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;We find this type of composition appealing because, according to studies, the human eye naturally follows this path when scanning a design.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (59,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;我们发现这种类型的构图很有吸引力，因为根据研究，人眼 自然会走这条路 扫描设计时。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (60,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;We find this type of composition appealing because, according to studies, the human eye naturally follows this path when scanning a design.&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');
insert  into `hkcms_archives_base`(`id`,`content`) values (61,'&lt;p&gt;&lt;span style=&quot;&quot;&gt;我们发现这种类型的构图很有吸引力，因为根据研究，人眼 自然会走这条路 扫描设计时。&lt;/span&gt;&lt;br&gt;&lt;/p&gt;&lt;p&gt;&lt;span style=&quot;&quot;&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/new2.jpg&quot; width=&quot;510&quot; height=&quot;340&quot;&gt;&lt;br&gt;&lt;/span&gt;&lt;/p&gt;');

-- 产品模型
insert  into `hkcms_archives` values (62,23,'',6,1,0,'奥特维尔摇椅 [演示数据]','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg','','关键字,seo,产品展示,木椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (63,24,'',6,1,0,'Hauteville Rocking Chair [Demo Data]','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg','','keyword,seo,product,wooden chair,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (64,23,'',6,1,0,'奥特维尔摇椅 [演示]2','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','','关键字,seo,产品展示,木椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',199.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (65,25,'',6,1,0,'白色现代椅子','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg','','关键字,seo,产品展示,单人扶手椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (66,27,'',6,1,0,'[演示]奥特维尔摇椅 [演示数据]','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg','','关键字,seo,产品展示,木椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (67,24,'',6,1,0,'Hauteville Rocking Chair [Demo]2','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','','keyword,seo,product,wooden chair,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',199.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (68,26,'',6,1,0,'White Modern Chair','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg','','keyword,seo,product,Single Armch,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (69,28,'',6,1,0,'[Demo]Hauteville Rocking Chair [Demo Data]','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg','','keyword,seo,product,wooden chair,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (70,23,'',6,1,0,'白色现代椅子2','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg','','关键字,seo,产品展示,单人扶手椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (71,25,'',6,1,0,'白色现代椅子2[演示数据]','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg','','关键字,seo,产品展示,单人扶手椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (72,27,'',6,1,0,'白色现代椅子','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg','','关键字,seo,产品展示,单人扶手椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (73,24,'',6,1,0,'White Modern Chair2','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg','','keyword,seo,product,Single Armch,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (74,26,'',6,1,0,'White Modern Chair2[Demo Data]','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg','','keyword,seo,product,Single Armch,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (75,28,'',6,1,0,'White Modern Chair','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg','','keyword,seo,product,Single Armch,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (76,28,'',6,1,0,'Wooden Bed - White Modern Chair','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg','','keyword,seo,product,Single Armch,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (77,27,'',6,1,0,'木床-白色现代椅子','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg','','关键字,seo,产品展示,单人扶手椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (78,27,'',6,1,0,'白色现代椅子','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','','关键字,seo,产品展示,单人扶手椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (79,28,'',6,1,0,'White Modern Chair','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','','keyword,seo,product,Single Armch,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',799.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (80,26,'',6,1,0,'White Modern Chair[demo]','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg','','keyword,seo,product,Single Armch,demo data','If you wish to succeed , you should use persistence as your good friend , experience as your reference , prudence as your brother and hope as your sentry.','','',100,'default','','',0,'',28.00,'',0,1,0,0,0,0,'show_product.html','normal','en',1637383565,NULL,1637383565,1637383565);
insert  into `hkcms_archives` values (81,25,'',6,1,0,'白色现代椅子[演示]','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg','','关键字,seo,产品展示,单人扶手椅,演示数据','如果你希望成功，当以恒心为良友、以经验为参谋、以谨慎为兄弟、以希望为哨兵。','','',100,'小编','','',0,'',28.00,'',0,1,0,0,0,0,'show_product.html','normal','zh-cn',1637383565,NULL,1637383565,1637383565);


insert  into `hkcms_archives_product` values (62,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"款 号\":\"abc4731111THL\",\"材 质\":\"大理石\",\"风 格\":\"休闲\",\"品 牌\":\"ABS\",\"颜 色\":\"红色\"}','green');
insert  into `hkcms_archives_product` values (63,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://local.cms.comhttp://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"Model number\":\"abc4731111THL\",\"Material\":\"Marble\",\"Style\":\"Casual\",\"Brand\":\"ABS\",\"Color\":\"Red\"}','green');
insert  into `hkcms_archives_product` values (64,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"款 号\":\"abc4731111THL\",\"材 质\":\"金刚石\",\"风 格\":\"运动\",\"品 牌\":\"ABC\",\"颜 色\":\"蓝色\"}','blue');
insert  into `hkcms_archives_product` values (65,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.baidu.com/','{\"款 号\":\"abc4732222THL\",\"材 质\":\"黄金\",\"风 格\":\"商务办公\",\"品 牌\":\"GGB\",\"颜 色\":\"红色\"}','red');
insert  into `hkcms_archives_product` values (66,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.baidu.com/','{\"款 号\":\"abc4731111THL\",\"材 质\":\"大理石\",\"风 格\":\"休闲\",\"品 牌\":\"ABS\",\"颜 色\":\"白色\"}','white');
insert  into `hkcms_archives_product` values (67,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://local.cms.comhttp://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"Model number\":\"abc4731111THL\",\"Material\":\"Diamond\",\"Style\":\"Sports\",\"Brand\":\"ABC\",\"Color\":\"Blue\"}','blue');
insert  into `hkcms_archives_product` values (68,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.baidu.com/','{\"Model number\":\"abc4731111THL\",\"Material\":\"Marble\",\"Style\":\"Leisure\",\"Brand\":\"ABS\",\"Color\":\"White\"}','white');
insert  into `hkcms_archives_product` values (69,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;&lt;p&gt;&lt;img alt=&quot;Image&quot; src=&quot;http://local.cms.comhttp://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg&quot; width=&quot;263&quot; height=&quot;280&quot;&gt;&lt;br&gt;&lt;/p&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"Model number\":\"abc4731111THL\",\"Material\":\"Stainless steel\",\"Style\":\"Casual\",\"Brand\":\"ABS\",\"Color\":\"Black\"}','black');
insert  into `hkcms_archives_product` values (70,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.baidu.com/','{\"款 号\":\"abc4701111THL\",\"材 质\":\"不锈钢\",\"风 格\":\"时尚休闲\",\"品 牌\":\"HHJ\",\"颜 色\":\"黑色\"}','black');
insert  into `hkcms_archives_product` values (71,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"款 号\":\"abc4031111THL\",\"材 质\":\"PVC\",\"风 格\":\"现代\",\"品 牌\":\"ABS\",\"颜 色\":\"红色\"}','red');
insert  into `hkcms_archives_product` values (72,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"款 号\":\"abc4031111THL\",\"材 质\":\"黄金\",\"风 格\":\"现代\",\"品 牌\":\"ABS\",\"颜 色\":\"绿色\"}','green');
insert  into `hkcms_archives_product` values (73,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.baidu.com/','{\"Model number\":\"abc4732222THL\",\"Material\":\"Gold\",\"Style\":\"Business office\",\"Brand\":\"GGB\",\"Color\":\"Red\"}','red');
insert  into `hkcms_archives_product` values (74,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"Model number\":\"abc4031111THL\",\"Material\":\"PVC\",\"Style\":\"Modern\",\"Brand\":\"ABS\",\"Color\":\"Red\"}','red');
insert  into `hkcms_archives_product` values (75,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"Model number\":\"abc4031111THL\",\"Material\":\"Gold\",\"Style\":\"Modern\",\"Brand\":\"ABS\",\"Color\":\"Green\"}','green');
insert  into `hkcms_archives_product` values (76,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"Model number\":\"abc5731111THL\",\"Material\":\"Transistor\",\"Style\":\"Business office\",\"Brand\":\"HW\",\"Color\":\"Black\"}','black');
insert  into `hkcms_archives_product` values (77,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"款 号\":\"abc5731111THL\",\"材 质\":\"晶体管\",\"风 格\":\"商务办公\",\"品 牌\":\"HW\",\"颜 色\":\"黑色\"}','black');
insert  into `hkcms_archives_product` values (78,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"款 号\":\"abc4931111THL\",\"材 质\":\"二极管\",\"风 格\":\"民国风\",\"品 牌\":\"CCD\",\"颜 色\":\"白色\"}','white');
insert  into `hkcms_archives_product` values (79,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"Model number\":\"abc4931111THL\",\"Material\":\"Diode\",\"Style\":\"Republic of China style\",\"Brand\":\"CCD\",\"Color\":\"White\"}','white');
insert  into `hkcms_archives_product` values (80,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% Cotton, 50% Polyester&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Imported&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;No Closure closure&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Machine Wash&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Midweight, 50% Cotton/50% Polyester fleece, with up to 5% made from recycled plastic bottles&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Soft, 7.5-Oz cotton blend provides comfort in any climate&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sweatshirt sits just below your natural waistline. Ribbed hem and cuffs keep their shape&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;High-stitch density, so it lasts longer without pilling&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Tag-free for added comfort&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;Sleeve Type: Long Sleeve&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"Model number\":\"abc4731111THL\",\"Material\":\"Rubber\",\"Style\":\"Antique\",\"Brand\":\"ABS\",\"Color\":\"Blue\"}','blue');
insert  into `hkcms_archives_product` values (81,'&lt;ul&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;50% 棉，50% 聚酯纤维&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;洋&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无闭合闭合&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;机洗&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;中等重量，50%棉/50%聚酯纤维摇粒绒，高达5%由回收塑料瓶制成&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;柔软的 7.5 盎司棉混纺面料，在任何气候下都能带来舒适感&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;卫衣位于自然腰围下方。罗纹下摆和袖口保持其形状&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;高针迹密度，因此持续时间更长，不会起球&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;无标签，增加舒适度&lt;/span&gt;&lt;/li&gt;&lt;li&gt;&lt;span style=&quot;&quot;&gt;套筒类型：长袖&lt;/span&gt;&lt;/li&gt;&lt;/ul&gt;','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/product4.jpg','https://www.taobao.com/','{\"款 号\":\"abc4731111THL\",\"材 质\":\"橡胶\",\"风 格\":\"古风\",\"品 牌\":\"ABS\",\"颜 色\":\"蓝色\"}','blue');


-- 图集模型
DROP TABLE IF EXISTS `hkcms_archives_images`;
CREATE TABLE `hkcms_archives_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text,
  `images` text NULL DEFAULT NULL COMMENT '图集',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

insert  into `hkcms_archives` values (82,38,'',7,1,0,'Customer Cases (Demo Data)','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg','','keyword,seo,customer case','Most folks are about as happy as they make up their minds to be .','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','en',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (83,37,'',7,1,0,'客户案例A','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg','','关键字,seo,客户案例','对于大多数人来说，他们认定自己有多幸福，就有多幸福。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','zh-cn',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (84,37,'',7,1,0,'客户案例B','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg','','关键字,seo,客户案例','对于大多数人来说，他们认定自己有多幸福，就有多幸福。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','zh-cn',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (85,37,'',7,1,0,'客户案例C','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg','','关键字,seo,客户案例','对于大多数人来说，他们认定自己有多幸福，就有多幸福。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','zh-cn',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (86,37,'',7,1,0,'客户案例D','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg','','关键字,seo,客户案例','对于大多数人来说，他们认定自己有多幸福，就有多幸福。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','zh-cn',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (87,38,'',7,1,0,'Customer Cases (Demo Data)','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg','','keyword,seo,customer case','Most folks are about as happy as they make up their minds to be .','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','en',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (88,38,'',7,1,0,'Customer Cases (Demo Data)','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg','','keyword,seo,customer case','Most folks are about as happy as they make up their minds to be .','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','en',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (89,38,'',7,1,0,'Customer Cases (Demo Data)','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg','','keyword,seo,customer case','Most folks are about as happy as they make up their minds to be .','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','en',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (90,37,'',7,1,0,'客户案例E','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg','','关键字,seo,客户案例','对于大多数人来说，他们认定自己有多幸福，就有多幸福。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','zh-cn',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (91,37,'',7,1,0,'客户案例F','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg','','关键字,seo,客户案例','对于大多数人来说，他们认定自己有多幸福，就有多幸福。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','zh-cn',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (92,39,'',7,1,0,'客户案例G','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg','','关键字,seo,客户案例','对于大多数人来说，他们认定自己有多幸福，就有多幸福。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','zh-cn',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (93,39,'',7,1,0,'客户案例H','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg','','关键字,seo,客户案例','对于大多数人来说，他们认定自己有多幸福，就有多幸福。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','zh-cn',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (94,38,'',7,1,0,'Customer Cases (Demo Data)','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg','','keyword,seo,customer case','Most folks are about as happy as they make up their minds to be .','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','en',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (95,38,'',7,1,0,'Customer Cases (Demo Data)','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg','','keyword,seo,customer case','Most folks are about as happy as they make up their minds to be .','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','en',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (96,40,'',7,1,0,'Customer Cases (Demo Data)','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg','','keyword,seo,customer case','Most folks are about as happy as they make up their minds to be .','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','en',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (97,40,'',7,1,0,'Customer Cases (Demo Data)','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg','','keyword,seo,customer case','Most folks are about as happy as they make up their minds to be .','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','en',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (98,39,'',7,1,0,'客户案例XZ','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg','','关键字,seo,客户案例','对于大多数人来说，他们认定自己有多幸福，就有多幸福。','','',100,'小编','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','zh-cn',1637382374,null,1637382374,1637382465);
insert  into `hkcms_archives` values (99,40,'',7,1,0,'Customer Cases XZ','','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg','','keyword,seo,customer case','Most folks are about as happy as they make up their minds to be .','','',100,'default','','',0,'',0.00,'',0,1,0,0,0,0,'show_image.html','normal','en',1637382374,null,1637382374,1637382465);

insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (82,'<p><span style="">Customer Cases (Demo Data)</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (83,'<p><span style="">客户案例内容描述信息1</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (84,'<p><span style="">客户案例内容描述信息2</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (85,'<p><span style="">客户案例内容描述信息3</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (86,'<p><span style="">客户案例内容描述信息4</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (87,'<p><span style="">Customer Cases (Demo Data)</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (88,'<p><span style="">Customer Cases (Demo Data)</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (89,'<p><span style="">Customer Cases (Demo Data)</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (90,'<p><span style="">客户案例内容描述信息1</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (91,'<p><span style="">客户案例内容描述信息2</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (92,'<p><span style="">客户案例内容描述信息3</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (93,'<p><span style="">客户案例内容描述信息4</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (94,'<p><span style="">Customer Cases (Demo Data)</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case4.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case5.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (95,'<p><span style="">Customer Cases (Demo Data)</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (96,'<p><span style="">Customer Cases (Demo Data)</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (97,'<p><span style="">Customer Cases (Demo Data)</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case3.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (98,'<p><span style="">客户案例内容描述信息、更多案例</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');
insert  into `hkcms_archives_images`(`id`,`content`,`images`) values (99,'<p><span style="">Customer Cases (Demo Data)、more</span></p>','http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case2.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case6.jpg,http://holuo.cn-gd.ufileos.com/hkcms/static/module/index/default/img/case1.jpg');


-- 招聘模型副表
DROP TABLE IF EXISTS `hkcms_archives_job`;
CREATE TABLE `hkcms_archives_job` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content` text,
  `address` char(250) NOT NULL DEFAULT '' COMMENT '工作地点',
  `degree` enum('不限','高中及以下','大专','本科','硕士','博士') NOT NULL DEFAULT '不限' COMMENT '学历要求',
  `salary` enum('面议','3-5K','5-10K','10-20K') NOT NULL DEFAULT '面议' COMMENT '薪资待遇',
  `nature` enum('全职','兼职') NOT NULL DEFAULT '全职' COMMENT '工作性质',
  `exp` enum('不限','应届生','1年以内','1-3年','3-5年','5-10年','10年以上') NOT NULL DEFAULT '不限' COMMENT '工作经验',
  `number` char(20) NOT NULL DEFAULT '' COMMENT '招聘人数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4;

-- 招聘模型数据
insert  into `hkcms_archives` values (100,18,'',8,1,0,'PHP开发工程师','','','PHP','PHP开发工程师招募','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','zh-cn',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (101,18,'',8,1,0,'PHP工程师','','','PHP','PHP开发工程师招募','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','zh-cn',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (102,18,'',8,1,0,'Python开发','','','Python','Python招募','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','zh-cn',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (103,18,'',8,1,0,'Vue前端工程师','','','vue,js','vue招募','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','zh-cn',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (104,18,'',8,1,0,'Vue初级工程师','','','vue,js','vue初级招募','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','zh-cn',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (105,18,'',8,1,0,'Uniapp','','','vue,js,Uniapp','Uniapp','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','zh-cn',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (106,18,'',8,1,0,'Go开发','','','go','golang','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','zh-cn',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (107,18,'',8,1,0,'Uniapp','','','Uniapp','Uniapp','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','zh-cn',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (108,17,'',8,1,0,'PHP Developer','','','','','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','en',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (109,17,'',8,1,0,'PHP Developer','','','','','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','en',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (110,17,'',8,1,0,'Python development','','','','','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','en',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (111,17,'',8,1,0,'Vue Frontend Engineer','','','','','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','en',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (112,17,'',8,1,0,'Vue Junior Engineer','','','','','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','en',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (113,17,'',8,1,0,'Uniapp','','','','','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','en',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (114,17,'',8,1,0,'Go development','','','','','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','en',1618564047,null,1618564047,1618564047);
insert  into `hkcms_archives` values (115,17,'',8,1,0,'Uniapp','','','','','','','',100,'HR','','',0,'',0.00,'',0,1,0,0,0,0,'show_job.html','normal','en',1618564047,null,1618564047,1618564047);

/* 副表 */
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (100,'<p><span style=\"color: rgb(81, 88, 109);\"><b>1. 岗位职责</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）运用php独立进行网站项目开发，以及网站程序的优化；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）负责解决开发过程中的技术难点等问题，编写网站开发文档工作；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）负责Linux服务器的优化、保证服务器网站正常访问。</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）能独立完成网站的前端、后端开发。</span></p><p><span style=\"color: rgb(81, 88, 109);\"><b>2. 任职要求</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）精通PHP+MYSQL编程，熟悉使用ThinkPHP、HkCms等至少一种开发框架，熟悉Javascript/Ajax以及sql编写；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）熟悉MYSQL索引优化、查询优化和存储优化方面的经验；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）熟悉微信小程序开发，微信接口开发，钉钉接口对接；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）熟悉Vue等单页应用的开发；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）能在uni-app框架下进行移动多端开发者优先；</span></p><blockquote><p>公司有10年行业网站开发大牛带你入行</p></blockquote>','广州天河区','本科','5-10K','全职','1年以内','2');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (101,'<p><span style=\"color: rgb(81, 88, 109);\"><b>1. 岗位职责</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）运用php独立进行网站项目开发，以及网站程序的优化；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）负责解决开发过程中的技术难点等问题，编写网站开发文档工作；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）负责Linux服务器的优化、保证服务器网站正常访问。</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）能独立完成网站的前端、后端开发。</span></p><p><span style=\"color: rgb(81, 88, 109);\"><b>2. 任职要求</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）精通PHP+MYSQL编程，熟悉使用ThinkPHP等至少一种开发框架，熟悉Javascript/Ajax以及sql编写；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）熟悉MYSQL索引优化、查询优化和存储优化方面的经验；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）熟悉微信小程序开发，微信接口开发，钉钉接口对接；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）熟悉Vue等单页应用的开发；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）能在uni-app框架下进行移动多端开发者优先；</span></p>','广州天河区','大专','面议','兼职','1-3年','1');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (102,'<p><span style=\"color: rgb(81, 88, 109);\"><b>1. 岗位职责</b></span></p><p><span style=\"\">负责公司内部数据分析平台，运维管理平台的开发工作。</span><br></p><p><span style=\"color: rgb(81, 88, 109);\"><b>2. 任职要求</b></span></p><p><span style=\"color: rgb(81, 88, 109);\">1）<span style=\"\">熟悉Python语言及其特性，了解相关Python Web框架 Flask，FastAPI 等</span>；</span></p><p><span style=\"color: rgb(81, 88, 109);\">2）熟悉MYSQL索引优化、查询优化和存储优化方面的经验；</span></p><p><span style=\"color: rgb(81, 88, 109);\">3）<span style=\"\">掌握面向对象的程序设计思想</span>；</span></p><p><span style=\"color: rgb(81, 88, 109);\">4）<span style=\"\">熟悉Linux开发环境;</span></span></p>','广州天河区','大专','3-5K','全职','1-3年','3');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (103,'<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p><span style=\"\">1、对Web前沿技术研究和新技术调用，并给出应用建议</span></p><p><span style=\"\">2、负责PC端页面开发、页面重构以及交互设计逻辑处理</span></p><p><span style=\"\">3、负责移动端H5、微信小程序、APP页面开发以及交互设计逻辑处理</span></p><p><span style=\"color: rgb(81, 88, 109);\"><b>任职要求</b></span></p><p><span style=\"\">1、精通JavaScript、JQuery、CSS、HTML 等前端相关技术原理，熟悉 W3C 标准与 ES 规范</span></p><p><span style=\"\">2、熟悉或使用过elementUI、vant、mint UI中一种前端UI框架</span></p><p><span style=\"\">3、至少熟练使用过Vue、React、AngularJS其中一种前端框架，有Vue实际开发经验优先</span></p><p><span style=\"\">4、有丰富的移动端开发经验，对H5、微信小程序的开发有深刻的理解,能够进行APP开发者优先</span></p><p><span style=\"\">5、对移动端的适配以及兼容性问题有较为深刻的理解或丰富的经验</span></p>','广州天河区','大专','10-20K','全职','3-5年','1');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (104,'<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p><span style=\"\">1、对Web前沿技术研究和新技术调用，并给出应用建议</span></p><p><span style=\"\">2、负责PC端页面开发、页面重构以及交互设计逻辑处理</span></p><p><span style=\"\">3、负责移动端H5、微信小程序、APP页面开发以及交互设计逻辑处理</span></p><p><span style=\"color: rgb(81, 88, 109);\"><b>2. 任职要求</b></span></p><p><span style=\"\">1、精通JavaScript、JQuery、CSS、HTML 等前端相关技术原理，熟悉 W3C 标准与 ES 规范</span></p><p><span style=\"\">2、熟悉或使用过elementUI、vant、mint UI中一种前端UI框架</span></p><p><span style=\"\">3、至少熟练使用过Vue、React、AngularJS其中一种前端框架，有Vue实际开发经验优先</span></p><p><span style=\"\">4、有丰富的移动端开发经验，对H5、微信小程序的开发有深刻的理解,能够进行APP开发者优先</span></p><p><span style=\"\">5、对移动端的适配以及兼容性问题有较为深刻的理解或丰富的经验</span></p>','广州天河区','不限','3-5K','全职','1年以内','5');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (105,'<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p>负责公司的Uniapp项目开发与维护<br></p><p><span style=\"color: rgb(81, 88, 109);\"><b>任职要求</b></span></p><p><span style=\"\">1、精通JavaScript、JQuery、CSS、HTML 等前端相关技术原理，熟悉 W3C 标准与 ES 规范</span></p><p><span style=\"\">2、熟悉或使用过elementUI、vant、mint UI中一种前端UI框架</span></p><p><span style=\"\">3、至少熟练使用过Vue、Uniapp、AngularJS其中一种前端框架，有Vue实际开发经验优先</span></p><p><span style=\"\">4、有丰富的移动端开发经验，对H5、微信小程序的开发有深刻的理解,能够进行APP开发者优先</span></p><p><span style=\"\">5、对移动端的适配以及兼容性问题有较为深刻的理解或丰富的经验</span></p>','广州白云区','本科','3-5K','全职','不限','5');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (106,'<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p>负责公司的GO项目的开发与维护<br></p><p><span style=\"color: rgb(81, 88, 109);\"><b>任职要求</b></span></p><p><span style=\"\">1、<span style=\"\">熟悉tcp/http网络原理</span></span></p><p><span style=\"\">2、<span style=\"\">熟悉redis/memcache等缓存中间件</span></span></p><p><span style=\"\">3、<span style=\"\">熟练使用MySQL/MongoDB等数据库</span></span></p><p><span style=\"\">4、<span style=\"\">熟悉Go web开发，有其它语言开发经验优先</span></span></p>','广州白云区','不限','面议','全职','应届生','1');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (107,'<p><span style=\"color: rgb(81, 88, 109);\"><b>岗位职责</b></span></p><p>负责公司的UNIAPP项目的开发与维护<br></p><p><span style=\"color: rgb(81, 88, 109);\"><b>任职要求</b></span></p><p><span style=\"\">1、<span style=\"\">熟悉uniapp框架、vue</span></span></p>','广州天河区','大专','5-10K','全职','5-10年','1');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (108,'<p><span style=\"\"><b>1. Job Responsibilities</b></span></p><p><span style=\"\">1) Use php to independently develop website projects and optimize website programs;</span></p><p><span style=\"\">2) Responsible for solving technical difficulties and other problems in the development process, and writing website development documents;</span></p><p><span style=\"\">3) Responsible for the optimization of the Linux server and ensure the normal access of the server website.</span></p><p><span style=\"\">4) Can independently complete the front-end and back-end development of the website.</span></p><p><span style=\"\"><b>2. Job Requirements</b></span></p><p><span style=\"\">1) Proficient in PHP+MYSQL programming, familiar with at least one development framework such as ThinkPHP, HkCms, familiar with Javascript/Ajax and sql writing;</span></p><p><span style=\"\">2) Familiar with MYSQL index optimization, query optimization and storage optimization experience;</span></p><p><span style=\"\">3) Familiar with WeChat applet development, WeChat interface development, and DingTalk interface docking;</span></p><p><span style=\"\">4) Familiar with the development of single-page applications such as Vue;</span></p><p><span style=\"\">5) Developers who can perform mobile multi-terminal under the uni-app framework are preferred;</span></p><blockquote><p><span style=\"\">The company has 10 years of industry website development Daniel to bring you into the industry</span><br></p></blockquote>','Tianhe District, Guangzhou','本科','5-10K','全职','1年以内','2');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (109,'<p><span style=\"\"><b>1. Job Responsibilities</b></span></p><p><span style=\"\">1) Use php to independently develop website projects and optimize website programs;</span></p><p><span style=\"\">2) Responsible for solving technical difficulties and other problems in the development process, and writing website development documents;</span></p><p><span style=\"\">3) Responsible for the optimization of the Linux server and ensure the normal access of the server website.</span></p><p><span style=\"\">4) Can independently complete the front-end and back-end development of the website.</span></p><p><span style=\"\"><b>2. Job Requirements</b></span></p><p><span style=\"\">1) Proficient in PHP+MYSQL programming, familiar with at least one development framework such as ThinkPHP, familiar with Javascript/Ajax and sql writing;</span></p><p><span style=\"\">2) Familiar with MYSQL index optimization, query optimization and storage optimization experience;</span></p><p><span style=\"\">3) Familiar with WeChat applet development, WeChat interface development, and DingTalk interface docking;</span></p><p><span style=\"\">4) Familiar with the development of single-page applications such as Vue;</span></p><p><span style=\"\">5) Developers who can perform mobile multi-terminal under the uni-app framework are preferred;</span></p>','Tianhe District, Guangzhou','大专','面议','兼职','1-3年','1');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (110,'<p><span style=\"\"><b>1. Job Responsibilities</b></span></p><p><span style=\"\">Responsible for the development of the company\'s internal data analysis platform and operation and maintenance management platform.</span></p><p><span style=\"\"><b>2. Job Requirements</b></span></p><p><span style=\"\">1) Familiar with the Python language and its features, and understand related Python web frameworks Flask, FastAPI, etc.;</span></p><p><span style=\"\">2) Familiar with MYSQL index optimization, query optimization and storage optimization experience;</span></p><p><span style=\"\">3) Master the idea of object-oriented programming;</span></p><p><span style=\"\">4) Familiar with Linux development environment;</span></p>','Tianhe District, Guangzhou','大专','3-5K','全职','1-3年','3');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (111,'<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">1. Research and call new technologies on the web, and give application suggestions</span></p><p><span style=\"\">2. Responsible for PC-side page development, page reconstruction and interaction design logic processing</span></p><p><span style=\"\">3. Responsible for mobile H5, WeChat applet, APP page development and interaction design logic processing</span></p><p><span style=\"\"><b>Job Requirements</b></span></p><p><span style=\"\">1. Proficient in front-end related technical principles such as JavaScript, JQuery, CSS, HTML, etc., familiar with W3C standards and ES specifications</span></p><p><span style=\"\">2. Familiar with or used a front-end UI framework in elementUI, vant, and mint UI</span></p><p><span style=\"\">3. Familiar with at least one of the front-end frameworks of Vue, React and AngularJS, and experience in Vue development is preferred</span></p><p><span style=\"\">4. Have rich experience in mobile terminal development, have a deep understanding of H5 and WeChat applet development, and be able to develop APP is preferred</span></p><p><span style=\"\">5. Have a deep understanding or rich experience in the adaptation and compatibility of mobile terminals</span></p>','Tianhe District, Guangzhou','大专','10-20K','全职','3-5年','1');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (112,'<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">1. Research and call new technologies on the web, and give application suggestions</span></p><p><span style=\"\">2. Responsible for PC-side page development, page reconstruction and interaction design logic processing</span></p><p><span style=\"\">3. Responsible for mobile H5, WeChat applet, APP page development and interaction design logic processing</span></p><p><span style=\"\"><b>Job Requirements</b></span></p><p><span style=\"\">1. Proficient in front-end related technical principles such as JavaScript, JQuery, CSS, HTML, etc., familiar with W3C standards and ES specifications</span></p><p><span style=\"\">2. Familiar with or used a front-end UI framework in elementUI, vant, and mint UI</span></p><p><span style=\"\">3. Familiar with at least one of the front-end frameworks of Vue, React and AngularJS, and experience in Vue development is preferred</span></p><p><span style=\"\">4. Have rich experience in mobile terminal development, have a deep understanding of H5 and WeChat applet development, and be able to develop APP is preferred</span></p><p><span style=\"\">5. Have a deep understanding or rich experience in the adaptation and compatibility of mobile terminals</span></p>','Tianhe District, Guangzhou','不限','3-5K','全职','1年以内','5');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (113,'<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">Responsible for the development and maintenance of the company\'s Uniapp project</span></p><p><span style=\"\"><b>Job Requirements</b></span></p><p><span style=\"\">1. Proficient in front-end related technical principles such as JavaScript, JQuery, CSS, HTML, etc., familiar with W3C standards and ES specifications</span></p><p><span style=\"\">2. Familiar with or used a front-end UI framework in elementUI, vant, and mint UI</span></p><p><span style=\"\">3. At least one of the front-end frameworks such as Vue, Uniapp and AngularJS has been used proficiently. Experience in Vue development is preferred</span></p><p><span style=\"\">4. Have rich experience in mobile terminal development, have a deep understanding of H5 and WeChat applet development, and be able to develop APP is preferred</span></p><p><span style=\"\">5. Have a deep understanding or rich experience in the adaptation and compatibility of mobile terminals</span></p>','Guangzhou Baiyun District','本科','3-5K','全职','不限','5');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (114,'<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">Responsible for the development and maintenance of the company\'s GO project</span></p><p><span style=\"\"><b>job requirements</b></span></p><p><span style=\"\">1. Familiar with tcp/http network principles</span></p><p><span style=\"\">2. Familiar with caching middleware such as redis/memcache</span></p><p><span style=\"\">3. Proficient in using MySQL/MongoDB and other databases</span></p><p><span style=\"\">4. Familiar with Go web development, experience in other language development is preferred</span></p>','Guangzhou Baiyun District','不限','面议','全职','应届生','1');
insert  into `hkcms_archives_job`(`id`,`content`,`address`,`degree`,`salary`,`nature`,`exp`,`number`) values (115,'<p><span style=\"\"><b>Job Responsibilities</b></span></p><p><span style=\"\">Responsible for the development and maintenance of the company\'s UNIAPP project</span></p><p><span style=\"\"><b>job requirements</b></span></p><p><span style=\"\">1. Familiar with uniapp framework and vue</span></p>','Tianhe District, Guangzhou','大专','5-10K','全职','5-10年','1');

-- 标签数据演示
insert  into `hkcms_tags`(`id`,`title`,`img`,`seo_title`,`seo_keywords`,`seo_description`,`total`,`views`,`weigh`,`autolink`,`lang`,`create_time`,`update_time`) values (3,'HkCms','','','','',2,3,100,1,'zh-cn',1667286103,1667286103);
insert  into `hkcms_tags`(`id`,`title`,`img`,`seo_title`,`seo_keywords`,`seo_description`,`total`,`views`,`weigh`,`autolink`,`lang`,`create_time`,`update_time`) values (4,'标签管理','','','','',1,1,100,1,'zh-cn',1667286103,1667286103);
insert  into `hkcms_tags`(`id`,`title`,`img`,`seo_title`,`seo_keywords`,`seo_description`,`total`,`views`,`weigh`,`autolink`,`lang`,`create_time`,`update_time`) values (5,'Tags','','','','',1,0,100,1,'en',1667287963,1667287963);
insert  into `hkcms_tags`(`id`,`title`,`img`,`seo_title`,`seo_keywords`,`seo_description`,`total`,`views`,`weigh`,`autolink`,`lang`,`create_time`,`update_time`) values (6,'Hot','','','','',1,0,100,1,'en',1667287963,1667287963);
insert  into `hkcms_tags`(`id`,`title`,`img`,`seo_title`,`seo_keywords`,`seo_description`,`total`,`views`,`weigh`,`autolink`,`lang`,`create_time`,`update_time`) values (7,'keywords','','','','',1,0,100,1,'en',1667288231,1667288231);
insert  into `hkcms_tags`(`id`,`title`,`img`,`seo_title`,`seo_keywords`,`seo_description`,`total`,`views`,`weigh`,`autolink`,`lang`,`create_time`,`update_time`) values (8,'关键字','','','','',1,0,100,1,'zh-cn',1667288352,1667288352);

insert  into `hkcms_tags_list`(`id`,`tags_id`,`model_id`,`category_id`,`content_id`,`content_title`,`lang`,`create_time`) values (1,3,1,11,22,'十二个设计师之内的多彩设计','zh-cn',1667286103);
insert  into `hkcms_tags_list`(`id`,`tags_id`,`model_id`,`category_id`,`content_id`,`content_title`,`lang`,`create_time`) values (2,4,1,11,22,'十二个设计师之内的多彩设计','zh-cn',1667286103);
insert  into `hkcms_tags_list`(`id`,`tags_id`,`model_id`,`category_id`,`content_id`,`content_title`,`lang`,`create_time`) values (3,3,1,12,23,'Inside Division Twelve’s Colorful Designs','en',1667287963);
insert  into `hkcms_tags_list`(`id`,`tags_id`,`model_id`,`category_id`,`content_id`,`content_title`,`lang`,`create_time`) values (4,5,1,12,23,'Inside Division Twelve’s Colorful Designs','en',1667287963);
insert  into `hkcms_tags_list`(`id`,`tags_id`,`model_id`,`category_id`,`content_id`,`content_title`,`lang`,`create_time`) values (5,6,1,12,23,'Inside Division Twelve’s Colorful Designs','en',1667287963);
insert  into `hkcms_tags_list`(`id`,`tags_id`,`model_id`,`category_id`,`content_id`,`content_title`,`lang`,`create_time`) values (6,7,1,12,39,'When a shape becomes 3D, we call it a form','en',1667288231);
insert  into `hkcms_tags_list`(`id`,`tags_id`,`model_id`,`category_id`,`content_id`,`content_title`,`lang`,`create_time`) values (7,8,1,11,38,'当一个形状变成 3D 时，我们称它为一个表格','zh-cn',1667288352);


-- 多语言表
insert  into `hkcms_lang_bind` values (1,3,0,'recommend','zh-cn',1636978556);
insert  into `hkcms_lang_bind` values (2,3,4,'recommend','en',1636978556);
insert  into `hkcms_lang_bind` values (3,1,0,'category','zh-cn',1636979415);
insert  into `hkcms_lang_bind` values (4,1,2,'category','en',1636979415);
insert  into `hkcms_lang_bind` values (5,3,0,'category','zh-cn',1636981343);
insert  into `hkcms_lang_bind` values (6,3,4,'category','en',1636981343);
insert  into `hkcms_lang_bind` values (7,5,0,'category','zh-cn',1636986900);
insert  into `hkcms_lang_bind` values (8,5,6,'category','en',1636986900);
insert  into `hkcms_lang_bind` values (9,7,0,'category','zh-cn',1636986934);
insert  into `hkcms_lang_bind` values (10,7,8,'category','en',1636986934);
insert  into `hkcms_lang_bind` values (11,2,0,'recommend','zh-cn',1636986934);
insert  into `hkcms_lang_bind` values (22,2,1,'recommend','en',1636986934);
insert  into `hkcms_lang_bind` values (23,9,0,'category','zh-cn',1637052314);
insert  into `hkcms_lang_bind` values (24,9,10,'category','en',1637052314);
insert  into `hkcms_lang_bind` values (25,11,0,'category','zh-cn',1637052636);
insert  into `hkcms_lang_bind` values (26,11,12,'category','en',1637052636);
insert  into `hkcms_lang_bind` values (27,13,0,'category','zh-cn',1637052636);
insert  into `hkcms_lang_bind` values (28,13,14,'category','en',1637052636);
insert  into `hkcms_lang_bind` values (29,15,0,'category','zh-cn',1637052636);
insert  into `hkcms_lang_bind` values (30,15,16,'category','en',1637052636);
insert  into `hkcms_lang_bind` values (31,5,0,'recommend','en',1637142375);
insert  into `hkcms_lang_bind` values (32,5,6,'recommend','zh-cn',1637142375);
insert  into `hkcms_lang_bind` values (33,18,0,'category','zh-cn',1637142375);
insert  into `hkcms_lang_bind` values (34,18,17,'category','en',1637142375);
insert  into `hkcms_lang_bind` values (35,19,0,'category','zh-cn',1637142375);
insert  into `hkcms_lang_bind` values (36,19,20,'category','en',1637142375);
insert  into `hkcms_lang_bind` values (37,21,0,'category','zh-cn',1637142375);
insert  into `hkcms_lang_bind` values (38,21,22,'category','en',1637142375);
insert  into `hkcms_lang_bind` values (39,23,0,'category','zh-cn',1637142375);
insert  into `hkcms_lang_bind` values (40,23,24,'category','en',1637142375);
insert  into `hkcms_lang_bind` values (41,25,0,'category','zh-cn',1637142375);
insert  into `hkcms_lang_bind` values (42,25,26,'category','en',1637142375);
insert  into `hkcms_lang_bind` values (43,27,0,'category','zh-cn',1637142375);
insert  into `hkcms_lang_bind` values (44,27,28,'category','en',1637142375);
insert  into `hkcms_lang_bind` values (45,29,0,'category','zh-cn',1637142375);
insert  into `hkcms_lang_bind` values (46,29,30,'category','en',1637142375);
insert  into `hkcms_lang_bind` values (47,31,0,'category','zh-cn',1637386732);
insert  into `hkcms_lang_bind` values (48,31,32,'category','en',1637386732);
insert  into `hkcms_lang_bind` values (49,33,0,'category','en',1637388218);
insert  into `hkcms_lang_bind` values (50,33,34,'category','zh-cn',1637388218);
insert  into `hkcms_lang_bind` values (51,1,0,'flags','zh-cn',1637388218);
insert  into `hkcms_lang_bind` values (52,1,2,'flags','en',1637388218);
insert  into `hkcms_lang_bind` values (53,7,0,'recommend','zh-cn',1637388218);
insert  into `hkcms_lang_bind` values (54,7,8,'recommend','en',1637388218);
insert  into `hkcms_lang_bind` values (55,35,0,'category','zh-cn',1637388218);
insert  into `hkcms_lang_bind` values (56,35,36,'category','en',1637388218);
insert  into `hkcms_lang_bind` values (57,37,0,'category','zh-cn',1656579210);
insert  into `hkcms_lang_bind` values (58,37,38,'category','en',1656579210);
insert  into `hkcms_lang_bind` values (59,39,0,'category','zh-cn',1656579407);
insert  into `hkcms_lang_bind` values (60,39,40,'category','en',1656579407);
insert  into `hkcms_lang_bind` values (61,9,0,'recommend','zh-cn',1656610216);
insert  into `hkcms_lang_bind` values (62,9,10,'recommend','en',1656610216);
insert  into `hkcms_lang_bind` values (63,11,0,'recommend','zh-cn',1657460086);
insert  into `hkcms_lang_bind` values (64,11,12,'recommend','en',1657460086);
insert  into `hkcms_lang_bind` values (65,41,0,'category','zh-cn',1656579407);
insert  into `hkcms_lang_bind` values (66,41,42,'category','en',1656579407);