/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const zhtw = {
    name: "繁體中文",
    english_name: "Traditional Chinese",
    code: "zhtw",
    dictionary: {
        about: "關於",
        account: "帳戶",
        account_password: "驗證帳戶密碼",
        access_granted_to: "已授予存取權給",
        add_existing_account: "新增現有帳戶",
        all_fields_required: '所有欄位都是必填的。',
        allow: '允許',
        apply: "套用",
        ascending: '升序',
        associated_websites: "關聯的網站",
        auto_arrange: '自動排列',
        background: "背景",
        browse: "瀏覽",
        cancel: '取消',
        center: '置中',
        change_desktop_background: '更改桌面背景…',
        change_email: "更改電子郵件",
        change_language: "更改語言",
        change_password: "更改密碼",
        change_ui_colors: "更改使用者介面顏色",
        change_username: "更改使用者名稱",
        close: '關閉',
        close_all_windows: "關閉所有視窗",
        close_all_windows_confirm: "您確定要關閉所有視窗嗎？",
        close_all_windows_and_log_out: '關閉視窗並登出',
        change_always_open_with: "您是否要始終使用以下程式開啟此類型的檔案",
        color: '顏色',
        confirm: '確認',
        confirm_2fa_setup: '我已將驗證碼新增到我的驗證器應用程式中',
        confirm_2fa_recovery: '我已將我的恢復碼儲存在安全的位置',
        confirm_account_for_free_referral_storage_c2a: '建立帳戶並確認您的電子郵件地址，即可獲得 1 GB 的免費儲存空間。您的朋友也會獲得 1 GB 的免費儲存空間。',
        confirm_code_generic_incorrect: "驗證碼不正確。",
        confirm_code_generic_too_many_requests: "請求次數過多。請稍等幾分鐘。",
        confirm_code_generic_submit: "提交驗證碼",
        confirm_code_generic_try_again: "再試一次",
        confirm_code_generic_title: "輸入確認碼",
        confirm_code_2fa_instruction: "輸入您的驗證器應用程式中的 6 位數驗證碼。",
        confirm_code_2fa_submit_btn: "提交",
        confirm_code_2fa_title: "輸入雙重驗證碼",
        confirm_delete_multiple_items: '您確定要永久刪除這些項目嗎？',
        confirm_delete_single_item: '您要永久刪除此項目嗎？',
        confirm_open_apps_log_out: '您有開啟的應用程式。您確定要登出嗎？',
        confirm_new_password: "確認新密碼",
        confirm_delete_user: "您確定要刪除您的帳戶嗎？所有您的檔案和資料將被永久刪除。此操作無法撤銷。",
        confirm_delete_user_title: "刪除帳戶？",
        confirm_session_revoke: "您確定要撤銷此工作階段嗎？",
        confirm_your_email_address: "確認您的電子郵件地址",
        contact_us: "聯絡我們",
        contact_us_verification_required: "您必須有一個已驗證的電子郵件地址才能使用此功能。",
        contain: '包含',
        continue: "繼續",
        copy: '複製',
        copy_link: "複製連結",
        copying: "正在複製",
        copying_file: "正在複製 %%",
        cover: '覆蓋',
        create_account: "建立帳戶",
        create_free_account: "建立免費帳戶",
        create_shortcut: "建立捷徑",
        credits: "製作群",
        current_password: "目前密碼",
        cut: '剪下',
        clock: "時鐘",
        clock_visible_hide: '隱藏 - 始終隱藏',
        clock_visible_show: '顯示 - 始終可見',
        clock_visible_auto: '自動 - 預設，僅在全螢幕模式下可見。',
        close_all: '全部關閉',
        created: '已建立',
        date_modified: '修改日期',
        default: '預設',
        delete: '刪除',
        delete_account: "刪除帳戶",
        delete_permanently: "永久刪除",
        deleting_file: "正在刪除 %%",
        deploy_as_app: '部署為應用程式',
        descending: '降序',
        desktop: '桌面',
        desktop_background_fit: "適應",
        developers: "開發者",
        dir_published_as_website: `%strong% 已發布到：`,
        disable_2fa: '停用雙重驗證',
        disable_2fa_confirm: "您確定要停用雙重驗證嗎？",
        disable_2fa_instructions: "輸入您的密碼以停用雙重驗證。",
        disassociate_dir: "解除關聯目錄",
        documents: '文件',
        dont_allow: '不允許',
        download: '下載',
        download_file: '下載檔案',
        downloading: "正在下載",
        email: "電子郵件",
        email_change_confirmation_sent: "確認電子郵件已發送到您的新電子郵件地址。請查看您的收件匣並按照指示完成此過程。",
        email_invalid: '電子郵件無效。',
        email_or_username: "電子郵件或使用者名稱",
        email_required: '電子郵件是必填的。',
        empty_trash: '清空垃圾桶',
        empty_trash_confirmation: `您確定要永久刪除垃圾桶中的項目嗎？`,
        emptying_trash: '正在清空垃圾桶…',
        enable_2fa: '啟用雙重驗證',
        end_hard: "強制結束",
        end_process_force_confirm: "您確定要強制結束此程序嗎？",
        end_soft: "正常結束",
        enlarged_qr_code: "放大的 QR 碼",
        enter_password_to_confirm_delete_user: "輸入您的密碼以確認刪除帳戶",
        error_message_is_missing: "錯誤訊息缺失。",
        error_unknown_cause: "發生未知錯誤。",
        error_uploading_files: "上傳檔案失敗",
        favorites: "收藏",
        feedback: "意見回饋",
        feedback_c2a: "請使用以下表單向我們發送您的意見、評論和錯誤報告。",
        feedback_sent_confirmation: "感謝您聯絡我們。如果您的帳戶有關聯的電子郵件，我們將盡快回覆您。",
        fit: "適應",
        folder: '資料夾',
        force_quit: '強制退出',
        forgot_pass_c2a: "忘記密碼？",
        from: "來自",
        general: "一般",
        get_a_copy_of_on_puter: `在 Puter.com 上獲取 '%%' 的副本！`,
        get_copy_link: '獲取副本連結',
        hide_all_windows: "隱藏所有視窗",
        home: '首頁',
        html_document: 'HTML 文件',
        hue: '色相',
        image: '圖片',
        incorrect_password: "密碼不正確",
        invite_link: "邀請連結",
        item: '項目',
        items_in_trash_cannot_be_renamed: `此項目無法重新命名，因為它在垃圾桶中。要重新命名此項目，請先將其從垃圾桶中拖出。`,
        jpeg_image: 'JPEG 圖片',
        keep_in_taskbar: '保留在工作列',
        language: "語言",
        license: "授權",
        lightness: '亮度',
        link_copied: "連結已複製",
        loading: '載入中',
        log_in: "登入",
        log_into_another_account_anyway: '仍然登入另一個帳戶',
        log_out: '登出',
        looks_good: "看起來不錯！",
        manage_sessions: "管理工作階段",
        menubar_style: "選單列樣式",
        menubar_style_desktop: "桌面",
        menubar_style_system: "系統",
        menubar_style_window: "視窗",
        modified: '已修改',
        move: '移動',
        moving_file: "正在移動 %%",
        my_websites: "我的網站",
        name: '名稱',
        name_cannot_be_empty: '名稱不能為空。',
        name_cannot_contain_double_period: "名稱不能是 '..' 字符。",
        name_cannot_contain_period: "名稱不能是 '.' 字符。",
        name_cannot_contain_slash: "名稱不能包含 '/' 字符。",
        name_must_be_string: "名稱只能是字串。",
        name_too_long: `名稱不能超過 %% 個字符。`,
        new: '新增',
        new_email: '新電子郵件',
        new_folder: '新資料夾',
        new_password: "新密碼",
        new_username: "新使用者名稱",
        no: '否',
        no_dir_associated_with_site: '沒有與此地址關聯的目錄。',
        no_websites_published: "您還沒有發布任何網站。右鍵點擊資料夾以開始。",
        ok: '確定',
        open: "開啟",
        open_in_new_tab: "在新分頁中開啟",
        open_in_new_window: "在新視窗中開啟",
        open_with: "開啟方式",
        original_name: '原始名稱',
        original_path: '原始路徑',
        oss_code_and_content: "開源軟體和內容",
        password: "密碼",
        password_changed: "密碼已更改。",
        password_recovery_rate_limit: "您已達到我們的速率限制；請稍等幾分鐘。為了避免將來發生這種情況，請避免過於頻繁地重新載入頁面。",
        password_recovery_token_invalid: "此密碼恢復令牌已不再有效。",
        password_recovery_unknown_error: "發生未知錯誤。請稍後再試。",
        password_required: '密碼是必填的。',
        password_strength_error: "密碼必須至少 8 個字符長，並且包含至少一個大寫字母、一個小寫字母、一個數字和一個特殊字符。",
        passwords_do_not_match: '`新密碼`和`確認新密碼`不匹配。',
        paste: '貼上',
        paste_into_folder: "貼上到資料夾",
        path: '路徑',
        personalization: "個人化",
        pick_name_for_website: "為您的網站選擇一個名稱：",
        picture: "圖片",
        pictures: '圖片',
        plural_suffix: '個',
        powered_by_puter_js: `由 {{link=docs}}Puter.js{{/link}} 提供支援`,
        preparing: "準備中...",
        preparing_for_upload: "準備上傳...",
        print: '列印',
        privacy: "隱私權",
        proceed_to_login: '繼續登入',
        proceed_with_account_deletion: "繼續刪除帳戶",
        process_status_initializing: "初始化中",
        process_status_running: "運行中",
        process_type_app: '應用程式',
        process_type_init: '初始化',
        process_type_ui: '使用者介面',
        properties: "屬性",
        public: '公開',
        publish: "發布",
        publish_as_website: '發布為網站',
        puter_description: `Puter 是一個以隱私為先的個人雲端，可將您所有的檔案、應用程式和遊戲保存在一個安全的地方，隨時隨地都能存取。`,
        reading_file: "正在讀取 %strong%",
        recent: "最近",
        recommended: "推薦",
        recover_password: "恢復密碼",
        refer_friends_c2a: "每邀請一位朋友在 Puter 上建立並確認帳戶，您就可獲得 1 GB 空間。您的朋友也會獲得 1 GB！",
        refer_friends_social_media_c2a: `在 Puter.com 上獲得 1 GB 免費儲存空間！`,
        refresh: '重新整理',
        release_address_confirmation: `您確定要釋放此地址嗎？`,
        remove_from_taskbar: '從工作列移除',
        rename: '重新命名',
        repeat: '重複',
        replace: '取代',
        replace_all: '全部取代',
        resend_confirmation_code: "重新發送確認碼",
        reset_colors: "重設顏色",
        restart_puter_confirm: "您確定要重新啟動 Puter 嗎？",
        restore: "還原",
        save: '儲存',
        saturation: '飽和度',
        save_account: '儲存帳戶',
        save_account_to_get_copy_link: "請建立帳戶以繼續。",
        save_account_to_publish: '請建立帳戶以繼續。',
        save_session: '儲存工作階段',
        save_session_c2a: '建立帳戶以儲存您目前的工作階段並避免失去您的工作。',
        scan_qr_c2a: '掃描下方的代碼\n以從其他裝置登入此工作階段',
        scan_qr_2fa: '使用您的驗證器應用程式掃描 QR 碼',
        scan_qr_generic: '使用您的手機或其他裝置掃描此 QR 碼',
        search: '搜尋',
        seconds: '秒',
        security: "安全性",
        select: "選擇",
        selected: '已選擇',
        select_color: '選擇顏色…',
        sessions: "工作階段",
        send: "發送",
        send_password_recovery_email: "發送密碼恢復電子郵件",
        session_saved: "感謝您建立帳戶。此工作階段已儲存。",
        settings: "設定",
        set_new_password: "設定新密碼",
        share: "分享",
        share_to: "分享到",
        share_with: "分享給：",
        shortcut_to: "捷徑到",
        show_all_windows: "顯示所有視窗",
        show_hidden: '顯示隱藏項目',
        sign_in_with_puter: "使用 Puter 登入",
        sign_up: "註冊",
        signing_in: "正在登入…",
        size: '大小',
        skip: '跳過',
        something_went_wrong: "發生了一些錯誤。",
        sort_by: '排序依據',
        start: '開始',
        status: "狀態",
        storage_usage: "儲存空間使用量",
        storage_puter_used: '由 Puter 使用',
        taking_longer_than_usual: '正在花費比平常更長的時間。請稍候...',
        task_manager: "工作管理員",
        taskmgr_header_name: "名稱",
        taskmgr_header_status: "狀態",
        taskmgr_header_type: "類型",
        terms: "條款",
        text_document: '文字文件',
        tos_fineprint: `點擊「建立免費帳戶」即表示您同意 Puter 的{{link=terms}}服務條款{{/link}}和{{link=privacy}}隱私政策{{/link}}`,
        transparency: "透明度",
        trash: '垃圾桶',
        two_factor: '雙重驗證',
        two_factor_disabled: '雙重驗證已停用',
        two_factor_enabled: '雙重驗證已啟用',
        type: '類型',
        type_confirm_to_delete_account: "輸入「confirm」以刪除您的帳戶。",
        ui_colors: "使用者介面顏色",
        ui_manage_sessions: "工作階段管理器",
        ui_revoke: "撤銷",
        undo: '復原',
        unlimited: '無限制',
        unzip: "解壓縮",
        upload: '上傳',
        upload_here: '上傳到這裡',
        usage: '使用量',
        username: "使用者名稱",
        username_changed: '使用者名稱更新成功。',
        username_required: '使用者名稱是必填的。',
        versions: "版本",
        videos: '影片',
        visibility: '可見性',
        yes: '是',
        yes_release_it: '是的，釋放它',
        you_have_been_referred_to_puter_by_a_friend: "您已被朋友推薦到 Puter！",
        zip: "壓縮",
        zipping_file: "正在壓縮 %strong%",

        // === 2FA Setup ===
        setup2fa_1_step_heading: '開啟您的驗證器應用程式',
        setup2fa_1_instructions: `
	        您可以使用任何支援基於時間的一次性密碼（TOTP）協議的驗證器應用程式。
	        有許多選擇，但如果您不確定，
	        <a target="_blank" href="https://authy.com/download">Authy</a>
	        是 Android 和 iOS 的一個不錯的選擇。
	    `,
        setup2fa_2_step_heading: '掃描 QR 碼',
        setup2fa_3_step_heading: '輸入 6 位數驗證碼',
        setup2fa_4_step_heading: '複製您的恢復碼',
        setup2fa_4_instructions: `
	        如果您遺失手機或無法使用驗證器應用程式，這些恢復碼是存取您帳戶的唯一方法。
	        請確保將它們儲存在安全的地方。
	    `,
        setup2fa_5_step_heading: '確認雙重驗證設置',
        setup2fa_5_confirmation_1: '我已將恢復碼儲存在安全的位置',
        setup2fa_5_confirmation_2: '我已準備好啟用雙重驗證',
        setup2fa_5_button: '啟用雙重驗證',

        // === 2FA Login ===
        login2fa_otp_title: '輸入雙重驗證碼',
        login2fa_otp_instructions: '輸入您驗證器應用程式中的 6 位數驗證碼。',
        login2fa_recovery_title: '輸入恢復碼',
        login2fa_recovery_instructions: '輸入您的其中一個恢復碼以存取您的帳戶。',
        login2fa_use_recovery_code: '使用恢復碼',
        login2fa_recovery_back: '返回',
        login2fa_recovery_placeholder: 'XXXXXXXX',

        "change": '更改', // In English: "Change"
        "clock_visibility": '時鐘可視性', // In English: "Clock Visibility"
        "reading": '正在讀取 %strong%', // In English: "Reading %strong%"
        "writing": '正在寫入 %strong%', // In English: "Writing %strong%"
        "unzipping": '正在解壓 %strong%', // In English: "Unzipping %strong%"
        "sequencing": '正在排序 %strong%', // In English: "Sequencing %strong%"
        "zipping": '正在壓縮 %strong%', // In English: "Zipping %strong%"
        "Editor": '編輯器', // In English: "Editor"
        "Viewer": '檢視者', // In English: "Viewer"
        "People with access": '有權限的人', // In English: "People with access"
        "Share With…": '分享給……', // In English: "Share With…"
        "Owner": '所有者', // In English: "Owner"
        "You can't share with yourself.": '您不能與自己分享。', // In English: "You can't share with yourself."
        "This user already has access to this item": '該用戶已有訪問此項的權限', // In English: "This user already has access to this item"

	"billing.change_payment_method": "更改", // Change
	"billing.cancel": "取消", // Cancel
	"billing.download_invoice": "下載發票", // Download
	"billing.payment_method": "付款方式", // Payment Method
	"billing.payment_method_updated": "付款方式已更新！", // Payment method updated!
	"billing.confirm_payment_method": "確認付款方式", // Confirm Payment Method
	"billing.payment_history": "付款記錄", // Payment History
	"billing.refunded": "已退款", // Refunded
	"billing.paid": "已付款", // Paid
	"billing.ok": "確定", // OK
	"billing.resume_subscription": "恢復訂閱", // Resume Subscription
	"billing.subscription_cancelled": "您的訂閱已被取消。", // Your subscription has been canceled.
	"billing.subscription_cancelled_description": "在本計費週期結束之前，您仍然可以使用您的訂閱。", // You will still have access to your subscription until the end of this billing period.
	"billing.offering.free": "免費", // Free
	"billing.offering.pro": "專業版", // Professional
	"billing.offering.business": "商業版", // Business
	"billing.cloud_storage": "雲端儲存空間", // Cloud Storage
	"billing.ai_access": "AI 使用權限", // AI Access
	"billing.bandwidth": "頻寬", // Bandwidth
	"billing.apps_and_games": "應用程式與遊戲", // Apps & Games
	"billing.upgrade_to_pro": "升級到 %strong%", // Upgrade to %strong%
	"billing.switch_to": "切換到 %strong%", // Switch to %strong%
	"billing.payment_setup": "付款設定", // Payment Setup
	"billing.back": "返回", // Back
	"billing.you_are_now_subscribed_to": "您現在的訂閱等級是 %strong%。", // You are now subscribed to %strong% tier.
	"billing.you_are_now_subscribed_to_without_tier": "您現在是訂閱狀態", // You are now subscribed
	"billing.subscription_cancellation_confirmation": "您確定要取消訂閱嗎？", // Are you sure you want to cancel your subscription?
	"billing.subscription_setup": "訂閱設定", // Subscription Setup
	"billing.cancel_it": "取消", // Cancel It
	"billing.keep_it": "保留", // Keep It
	"billing.subscription_resumed": "您的 %strong% 訂閱已恢復！", // Your %strong% subscription has been resumed!
	"billing.upgrade_now": "立即升級", // Upgrade Now
	"billing.upgrade": "升級", // Upgrade
	"billing.currently_on_free_plan": "您目前使用的是免費方案。", // You are currently on the free plan.
	"billing.download_receipt": "下載收據", // Download Receipt
	"billing.subscription_check_error": "無法檢查您的訂閱狀態，請稍後再試。", // A problem occurred while checking your subscription status.
	"billing.email_confirmation_needed": "您的電子郵件尚未確認。我們會向您發送驗證碼以進行確認。", // Your email has not been confirmed. We'll send you a code to confirm it now.
	"billing.sub_cancelled_but_valid_until": "您已取消訂閱，訂閱將在計費週期結束後自動轉為免費方案。除非重新訂閱，否則不會再次收費。", // You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe.
	"billing.current_plan_until_end_of_period": "您的目前方案將持續到本計費週期結束。", // Your current plan until the end of this billing period.
	"billing.current_plan": "目前方案", // Current plan
	"billing.cancelled_subscription_tier": "已取消的訂閱（%%）", // Cancelled Subscription (%%)
	"billing.manage": "管理", // Manage
	"billing.limited": "有限", // Limited
	"billing.expanded": "擴展", // Expanded
	"billing.accelerated": "加速", // Accelerated
	"billing.enjoy_msg": "享受 %% 的雲端儲存空間及其他福利。", // Enjoy %% of Cloud Storage plus other benefits.
	
    }
};

export default zhtw;
