/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const zh = {
    name: "中文",
    english_name: "Chinese",
    code: "zh",
    dictionary: {
        about: "关于我们",
        account: "账号",
        account_password: "账号密码验证",
        access_granted_to: "访问授权给",
        add_existing_account: "添加现有帐号",
        all_fields_required: '所有字段都是必需的。',
        allow: '允许',
        apply: "应用",
        ascending: '升序',
        associated_websites: "相关网站",
        auto_arrange: '自动排序',
        background: "背景",
        browse: "浏览",
        cancel: '取消',
        center: '中心',
        change_desktop_background: '更改桌面背景…',
        change_email: "更改邮箱",
        change_language: "更改语言",
        change_password: "更改密码",
        change_ui_colors: "更改界面颜色",
        change_username: "更改用户名",
        close: '关闭',
        close_all_windows: "关闭所有窗口",
        close_all_windows_confirm: "确定要关闭所有窗口吗?",
        close_all_windows_and_log_out: '关闭窗口并退出',
        change_always_open_with: "以后都这样打开此类型的文件？",
        color: '颜色',
        confirm: '确认',
        confirm_2fa_setup: '我已完成在身份验证应用中添加代码',
        confirm_2fa_recovery: '我已完成保存恢复码到安全地方',
        confirm_account_for_free_referral_storage_c2a: '创建帐号并确认您的电子邮件地址，以获得1 GB的免费存储空间。您的朋友也将获得1 GB的免费存储空间。',
        confirm_code_generic_incorrect: "代码不正确!",
        confirm_code_generic_too_many_requests: "请求太频繁，请过几分钟后再试。",
        confirm_code_generic_submit: "提交代码",
        confirm_code_generic_try_again: "重试",
        confirm_code_generic_title: "确认代码",
        confirm_code_2fa_instruction: "请输入从身份验证应用中获取的6位数字代码",
        confirm_code_2fa_submit_btn: "提交",
        confirm_code_2fa_title: "请输入二次身份验证码",
        confirm_delete_multiple_items: '确定要永久删除这些文件？',
        confirm_delete_single_item: '确定要永久删除这个文件?',
        confirm_open_apps_log_out: '还有应用未关闭，您确定现在就要退出吗？',
        confirm_new_password: "确认新密码",
        confirm_delete_user: "确认要删除此账号？所有相关文件和数据都将被清空，一旦删除不能恢复!",
        confirm_delete_user_title: "确定删除账号?",
        confirm_session_revoke: "确定要撤销?",
        confirm_your_email_address: "请确认您的邮箱地址",
        contact_us: "联系我们",
        contact_us_verification_required: "需要提供有效的邮箱地址以完成此操作",
        contain: '包含',
        continue: "继续",
        copy: '复制',
        copy_link: "复制链接",
        copying: "复制",
        copying_file: "正在复制 %%",
        cover: '封面',
        create_account: "创建帐户",
        create_free_account: "创建免费帐户",
        create_shortcut: "创建快捷方式",
        credits: "特别鸣谢",
        current_password: "当前密码",
        cut: '剪切',
        clock: "时间",
        clock_visible_hide: '隐藏 - 始终隐藏',
        clock_visible_show: '显示 - 始终显示',
        clock_visible_auto: '自动 - 默认值，全屏显示',
        close_all: '关闭全部',
        created: '已创建',
        date_modified: '修改日期',
        default: '默认',
        delete: '删除',
        delete_account: "删除账号",
        delete_permanently: "永久删除",
        deleting_file: "正在删除文件 %%",
        deploy_as_app: '部署为应用',
        descending: '降序',
        desktop: '桌面',
        desktop_background_fit: "适合",
        developers: "开发人员",
        dir_published_as_website: `%strong% 已发布到：`,
        disable_2fa: '关闭二次认证',
        disable_2fa_confirm: "您确定要关闭二次认证?",
        disable_2fa_instructions: "请输入您的密码以关闭二次认证",
        disassociate_dir: "取消关联目录",
        documents: '文档',
        dont_allow: '操作不允许!',
        download: '下载',
        download_file: '下载文件',
        downloading: "下载",
        email: "邮箱地址",
        email_change_confirmation_sent: "确认邮件已发送到您的新邮箱，请按指令完成操作",
        email_invalid: '邮箱地址未验证',
        email_or_username: "邮箱地址或用户名",
        email_required: '请输入有效的邮箱地址',
        empty_trash: '清空回收站',
        empty_trash_confirmation: `您确定要永久删除回收站中的项目吗？`,
        emptying_trash: '正在清空回收站…',
        enable_2fa: '启用二次身份验证',
        end_hard: "强制关闭",
        end_process_force_confirm: "您确定要强制关闭此程序吗？",
        end_soft: "等待响应",
        enlarged_qr_code: "放大二维码",
        enter_password_to_confirm_delete_user: "请输入您的密码以确认删除账号",
        error_message_is_missing: "未找到错误信息",
        error_unknown_cause: "发生未知错误",
        error_uploading_files: "上传文件失败",
        favorites: "喜欢",
        feedback: "反馈",
        feedback_c2a: "请使用下面的表格向我们发送您的反馈、评论和错误报告。",
        feedback_sent_confirmation: "感谢您与我们联系。如果您的帐户关联有电子邮件，我们会尽快回复您。",
        fit: "适应",
        folder: '文件夹',
        force_quit: '强制退出',
        forgot_pass_c2a: "忘记密码？",
        from: "从",
        general: "常用",
        get_a_copy_of_on_puter: `在 Puter.com 上获取 '%%' 的副本！`,
        get_copy_link: '获取复制链接',
        hide_all_windows: "隐藏所有窗口",
        home: '主页',
        html_document: 'HTML 文档',
        hue: '色调',
        image: '图像',
        incorrect_password: "密码不正确",
        invite_link: "邀请链接",
        item: '项目',
        items_in_trash_cannot_be_renamed: `此项目无法重命名，因为它在回收站中。要重命名此项目，请先将其拖出回收站。`,
        jpeg_image: 'JPEG 图像',
        keep_in_taskbar: '固定在任务栏',
        language: "语言",
        license: "许可协议",
        lightness: '明亮',
        link_copied: "链接已复制",
        loading: '正在加载',
        log_in: "登录",
        log_into_another_account_anyway: '强制切换账号',
        log_out: '退出',
        looks_good: "看起来不错！",
        manage_sessions: "会话管理",
        menubar_style: "菜单条样式",
        menubar_style_desktop: "桌面",
        menubar_style_system: "系统",
        menubar_style_window: "窗口",
        modified: '已修改',
        move: '移动',
        moving_file: "移动 %%",
        my_websites: "我的网站",
        name: '名称',
        name_cannot_be_empty: '名称不能为空。',
        name_cannot_contain_double_period: "名称不能是'..'字符。",
        name_cannot_contain_period: "名称不能是'.'字符。",
        name_cannot_contain_slash: "名称不能包含'/'字符。",
        name_must_be_string: "名称只能是字符串。",
        name_too_long: `名称不能超过 %% 个字符。`,
        new: '新',
        new_email: '新邮箱',
        new_folder: '新文件夹',
        new_password: "新密码",
        new_username: "新用户名",
        no: '取消',
        no_dir_associated_with_site: '此地址没有关联的目录。',
        no_websites_published: "您尚未发布任何网站。",
        ok: '好的',
        open: "打开",
        open_in_new_tab: "在新标签页中打开",
        open_in_new_window: "在新窗口中打开",
        open_with: "打开方式",
        original_name: '原名',
        original_path: '原路径',
        oss_code_and_content: "开源软件和内容",
        password: "密码",
        password_changed: "密码已更改。",
        password_recovery_rate_limit: "操作太频繁请几分钟后再试，请不要频繁刷新页面以避免再次遇到此问题",
        password_recovery_token_invalid: "密码恢复令牌已过期",
        password_recovery_unknown_error: "发生未知错误，请稍后再试",
        password_required: '请输入密码',
        password_strength_error: "密码必须包含至少8个字符且至少含有数字、大写字母、小写字母、特殊符号其中一种。",
        passwords_do_not_match: '`新密码` 和 `确认新密码` 不匹配。',
        paste: '粘贴',
        paste_into_folder: "粘贴到文件夹",
        path: '路径',
        personalization: "个性化",
        pick_name_for_website: "为您的网站选择一个名称：",
        picture: "图片",
        pictures: '图片',
        plural_suffix: '',
        powered_by_puter_js: `由 {{link=docs}}Puter.js{{/link}} 提供支持`,
        preparing: "准备中...",
        preparing_for_upload: "准备上传...",
        print: '打印',
        privacy: "隐私",
        proceed_to_login: '完成登录',
        proceed_with_account_deletion: "完成账号删除操作",
        process_status_initializing: "初始化",
        process_status_running: "运行中",
        process_type_app: '应用',
        process_type_init: '初始',
        process_type_ui: '界面',
        properties: "属性",
        public: '公开',
        publish: "发布",
        publish_as_website: '发布为网站',
        puter_description: `Puter 是一个隐私优先的个人云，可将您的所有文件、应用程序和游戏保存在一个安全的地方，方便随时随地访问。`,
        reading_file: "正在读取 %strong%",
        recent: "最近",
        recommended: "推荐",
        recover_password: "找回密码",
        refer_friends_c2a: "每个创建并确认 Puter 帐户的朋友都会为您获得 1 GB。您的朋友也将获得 1 GB！",
        refer_friends_social_media_c2a: `在 Puter.com 上获取 1 GB 的免费存储空间！`,
        refresh: '刷新',
        release_address_confirmation: `您确定要释放此地址吗？`,
        remove_from_taskbar:'从任务栏中删除',
        rename: '重命名',
        repeat: '重复',
        replace: '替换',
        replace_all: '全部替换',
        resend_confirmation_code: "重新发送确认码",
        reset_colors: "重置颜色",
        restart_puter_confirm: "确定要重启Puter?",
        restore: "还原",
        save: '保存',
        saturation: '饱和度',
        save_account: '保存账号',
        save_account_to_get_copy_link: "请创建帐户以继续。",
        save_account_to_publish: '请创建帐户以继续。',
        save_session: '保存会话',
        save_session_c2a: '创建帐户以保存当前会话，避免丢失工作。',
        scan_qr_c2a: '扫描下面的代码以从其他设备登录此会话',
        scan_qr_2fa: '请使用身份认证应用扫描二维码',
        scan_qr_generic: '请使用您的手机或其它设备扫描二维码',
        search: '查找',
        seconds: '秒',
        security: "安全",
        select: "选择",
        selected: '已选择',
        select_color: '选择颜色…',
        sessions: "会话",
        send: "发送",
        send_password_recovery_email: "发送密码恢复电子邮件",
        session_saved: "感谢您创建帐号。此会话已保存。",
        settings: "设置",
        set_new_password: "设置新密码",
        share: "分享",
        share_to: "分享到",
        share_with: "分享:",
        shortcut_to: "快捷方式",
        show_all_windows: "显示所有窗口",
        show_hidden: '显示隐藏',
        sign_in_with_puter: "使用 Puter 登录",
        sign_up: "注册",
        signing_in: "登录中…",
        size: '大小',
        skip: '跳过',
        something_went_wrong: "操作出差了！",
        sort_by: '排序方式',
        start: '开始',
        status: "状态",
        storage_usage: "存储使用量",
        storage_puter_used: '被Puter使用',
        taking_longer_than_usual: '需要的时间比平时长一点。请稍等...',
        task_manager: "任务管理器",
        taskmgr_header_name: "状态",
        taskmgr_header_status: "名称",
        taskmgr_header_type: "类型",
        terms: "条款",
        text_document: '文本文档',
        tos_fineprint: `点击“创建免费帐户”即表示您同意 Puter 的 {{link=terms}}服务条款{{/link}} 和 {{link=privacy}}隐私政策{{/link}}。`,
        transparency: "透明度",
        trash: '回收站',
        two_factor: '二次身份验证',
        two_factor_disabled: '关闭二次身份验证',
        two_factor_enabled: '启用二次身份验证',
        type: '类型',
        type_confirm_to_delete_account: "请输入 confirm 以确认删除账号.",
        ui_colors: "界面颜色",
        ui_manage_sessions: "会话管理",
        ui_revoke: "取消",
        undo: '撤销',
        unlimited: '无限制',
        unzip: "解压缩",
        upload: '上传',
        upload_here: '在此上传',
        usage: '用量',
        username: "用户名",
        username_changed: '用户名已成功更新。',
        username_required: '请输入用户名',
        versions: "版本",
        videos: '视频',
        visibility: "可见性",
        yes: '确定',
        yes_release_it: '是的，释放它',
        you_have_been_referred_to_puter_by_a_friend: "您已经被朋友推荐到 Puter！",
        zip: "压缩",
        zipping_file: "正在压缩 %strong%",

        // === 2FA Setup ===
        setup2fa_1_step_heading: '打开你的身份验证应用',
        setup2fa_1_instructions: `
            你可以使用任何一种支持TOTP（基于时间的一次性密码生成）协议的应用.
            有很多应用可以选择，如果您不确定用哪一个可以使用
            <a target="_blank" href="https://authy.com/download">Authy</a>
            支持安卓和IOS设备
        `,
        setup2fa_2_step_heading: '扫描二维码',
        setup2fa_3_step_heading: '输入6位数字代码',
        setup2fa_4_step_heading: '复制您的恢复码',
        setup2fa_4_instructions: `
            恢复码是在您无法使用手机或身份验证应用时唯一的访问账号凭证。
            请妥善保存以免丢失
        `,
        setup2fa_5_step_heading: '确认二次认证步骤',
        setup2fa_5_confirmation_1: '我已经将恢复码妥善保存',
        setup2fa_5_confirmation_2: '我已准备好启用二次认证',
        setup2fa_5_button: '启用二次认证',

        // === 2FA Login ===
        login2fa_otp_title: '输入二次认证代码',
        login2fa_otp_instructions: '请输入从身份验证应用获取的6位数字代码',
        login2fa_recovery_title: '请输入恢复码',
        login2fa_recovery_instructions: '请输入恢复码以访问您的账号',
        login2fa_use_recovery_code: '使用恢复码',
        login2fa_recovery_back: '后退',
        login2fa_recovery_placeholder: '********',

        "change": '更改', // In English: "Change"
        "clock_visibility": '时钟可见性', // In English: "Clock Visibility"
        "plural_suffix": '单位后缀', // In English: "plural_suffix"
        "reading": '正在读取 %strong%', // In English: "Reading %strong%"
        "writing": '正在写入 %strong%', // In English: "Writing %strong%"
        "unzipping": '正在解压缩 %strong%', // In English: "Unzipping %strong%"
        "sequencing": '正在排序 %strong%', // In English: "Sequencing %strong%"
        "zipping": '正在压缩 %strong%', // In English: "Zipping %strong%"
        "Editor": '编辑器', // In English: "Editor"
        "Viewer": '查看器', // In English: "Viewer"
        "People with access": '有访问权限的人', // In English: "People with access"
        "Share With…": '与他人分享…', // In English: "Share With…"
        "Owner": '所有者', // In English: "Owner"
        "You can't share with yourself.": '不能分享给你自己', // In English: "You can't share with yourself."
        "This user already has access to this item": '该用户已经拥有访问此项目的权限了', // In English: "This user already has access to this item"

        "billing.change_payment_method": '更改', // In English: "Change"
        "billing.cancel": '取消', // In English: "Cancel"
        "billing.download_invoice": '下载', // In English: "Download"
        "billing.payment_method": '付款方式', // In English: "Payment Method"
        "billing.payment_method_updated": '已更新付款方式！', // In English: "Payment method updated!"
        "billing.confirm_payment_method": '确认付款方式', // In English: "Confirm Payment Method"
        "billing.payment_history": '付款历史', // In English: "Payment History"
        "billing.refunded": '已退款', // In English: "Refunded"
        "billing.paid": '已付款', // In English: "Paid"
        "billing.ok": '确认', // In English: "OK"
        "billing.resume_subscription": '恢复订阅', // In English: "Resume Subscription"
        "billing.subscription_cancelled": '您的订阅已被取消', // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": '在此账单期结束前，您仍可使用您的订阅服务。', // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": '免费', // In English: "Free"
        "billing.offering.pro": '专业', // In English: "Professional"
        "billing.offering.business": '商业', // In English: "Business"
        "billing.cloud_storage": '云存储', // In English: "Cloud Storage"
        "billing.ai_access": '人工智能访问', // In English: "AI Access"
        "billing.bandwidth": '频宽', // In English: "Bandwidth"
        "billing.apps_and_games": '应用和游戏', // In English: "Apps & Games"
        "billing.upgrade_to_pro": '升级至%strong%', // In English: "Upgrade to %strong%"
        "billing.switch_to": '转至%strong%', // In English: "Switch to %strong%"
        "billing.payment_setup": '付款设置', // In English: "Payment Setup"
        "billing.back": '返回', // In English: "Back"
        "billing.you_are_now_subscribed_to": '您现在已订阅了%strong%级别。', // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": '您现在已订阅', // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": '您确定要取消订阅吗？', // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": '订阅设置', // In English: "Subscription Setup"
        "billing.cancel_it": '取消', // In English: "Cancel It"
        "billing.keep_it": '保留', // In English: "Keep It"
        "billing.subscription_resumed": '您的%strong%级别的订阅已被恢复！', // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": '现在升级', // In English: "Upgrade Now"
        "billing.upgrade": '升级', // In English: "Upgrade"
        "billing.currently_on_free_plan": '您目前使用的是免费计划。', // In English: "You are currently on the free plan."
        "billing.download_receipt": '下载收据', // In English: "Download Receipt"
        "billing.subscription_check_error": '检查您的订阅状态时遇到错误。', // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": '您的电邮还没被确认。我们将向您发送一个确认代码。', // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": '您已取消订阅，在结算期后将会自动转为免费级别。除非您重新订阅，否则不会再向您收取费用。', // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": '您当前的计划直至本账单期结束。', // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": '当前计划', // In English: "Current plan"
        "billing.cancelled_subscription_tier": '已取消的订阅(%%)', // In English: "Cancelled Subscription (%%)"
        "billing.manage": '管理', // In English: "Manage"
        "billing.limited": '限制', // In English: "Limited"
        "billing.expanded": '扩展', // In English: "Expanded"
        "billing.accelerated": '加快', // In English: "Accelerated"
        "billing.enjoy_msg": '请享受%%云存储服务及其他优惠。', // In English: "Enjoy %% of Cloud Storage plus other benefits."
    }
};

export default zh;
