/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const vi = {
    name: "Tiếng Việt",
    english_name: "Vietnamese",
    code: "vi",
    dictionary: {
        about: "Giới thiệu",
        account: "Tài khoản",
        account_password: "Xác minh mật khẩu tài khoản",
        access_granted_to: "Đã cấp quyền truy cập cho",
        add_existing_account: "Thêm tài khoản hiện có",
        all_fields_required: 'Tất cả các trường đều bắt buộc.',
        allow: 'Cho phép',
        apply: "Áp dụng",
        ascending: 'Tăng dần',
        associated_websites: "Các trang web liên kết",
        auto_arrange: 'Tự động sắp xếp',
        background: "Nền",
        browse: "Duyệt",
        cancel: 'Hủy',
        center: 'Giữa',
        change_desktop_background: 'Thay đổi hình nền màn hình…',
        change_email: "Thay đổi email",
        change_language: "Thay đổi ngôn ngữ",
        change_password: "Thay đổi mật khẩu",
        change_ui_colors: "Thay đổi màu sắc giao diện",
        change_username: "Thay đổi tên người dùng",
        close: 'Đóng',
        close_all_windows: "Đóng tất cả cửa sổ",
        close_all_windows_confirm: "Bạn có chắc chắn muốn đóng tất cả cửa sổ không?",
        close_all_windows_and_log_out: 'Đóng cửa sổ và đăng xuất',
        change_always_open_with: "Bạn có muốn luôn mở loại tệp này bằng",
        color: 'Màu sắc',
        confirm: 'Xác nhận',
        confirm_2fa_setup: 'Tôi đã thêm mã vào ứng dụng xác thực của mình',
        confirm_2fa_recovery: 'Tôi đã lưu mã khôi phục của mình ở một nơi an toàn',
        confirm_account_for_free_referral_storage_c2a: 'Tạo tài khoản và xác nhận địa chỉ email của bạn để nhận 1 GB dung lượng lưu trữ miễn phí. Bạn của bạn cũng sẽ nhận được 1 GB dung lượng lưu trữ miễn phí.',
        confirm_code_generic_incorrect: "Mã không chính xác.",
        confirm_code_generic_too_many_requests: "Quá nhiều yêu cầu. Vui lòng đợi vài phút.",
        confirm_code_generic_submit: "Gửi mã",
        confirm_code_generic_try_again: "Thử lại",
        confirm_code_generic_title: "Nhập mã xác nhận",
        confirm_code_2fa_instruction: "Nhập mã 6 chữ số từ ứng dụng xác thực của bạn.",
        confirm_code_2fa_submit_btn: "Gửi",
        confirm_code_2fa_title: "Nhập mã 2FA",
        confirm_delete_multiple_items: 'Bạn có chắc chắn muốn xóa vĩnh viễn những mục này không?',
        confirm_delete_single_item: 'Bạn có muốn xóa vĩnh viễn mục này không?',
        confirm_open_apps_log_out: 'Bạn có ứng dụng đang mở. Bạn có chắc chắn muốn đăng xuất không?',
        confirm_new_password: "Xác nhận mật khẩu mới",
        confirm_delete_user: "Bạn có chắc chắn muốn xóa tài khoản của mình không? Tất cả các tệp và dữ liệu của bạn sẽ bị xóa vĩnh viễn. Hành động này không thể hoàn tác.",
        confirm_delete_user_title: "Xóa tài khoản?",
        confirm_session_revoke: "Bạn có chắc chắn muốn thu hồi phiên này không?",
        confirm_your_email_address: "Xác nhận địa chỉ email của bạn",
        contact_us: "Liên hệ chúng tôi",
        contact_us_verification_required: "Bạn phải có địa chỉ email đã xác minh để sử dụng tính năng này.",
        contain: 'Chứa',
        continue: "Tiếp tục",
        copy: 'Sao chép',
        copy_link: "Sao chép liên kết",
        copying: "Đang sao chép",
        copying_file: "Đang sao chép %%",
        cover: 'Che phủ',
        create_account: "Tạo tài khoản",
        create_free_account: "Tạo tài khoản miễn phí",
        create_shortcut: "Tạo lối tắt",
        credits: "Tín dụng",
        current_password: "Mật khẩu hiện tại",
        cut: 'Cắt',
        clock: "Đồng hồ",
        clock_visible_hide: 'Ẩn - Luôn ẩn',
        clock_visible_show: 'Hiện - Luôn hiển thị',
        clock_visible_auto: 'Tự động - Mặc định, chỉ hiển thị ở chế độ toàn màn hình.',
        close_all: 'Đóng tất cả',
        created: 'Đã tạo',
        date_modified: 'Ngày sửa đổi',
        default: 'Mặc định',
        delete: 'Xóa',
        delete_account: "Xóa tài khoản",
        delete_permanently: "Xóa vĩnh viễn",
        deleting_file: "Đang xóa %%",
        deploy_as_app: 'Triển khai như ứng dụng',
        descending: 'Giảm dần',
        desktop: 'Màn hình chính',
        desktop_background_fit: "Vừa khít",
        developers: "Nhà phát triển",
        dir_published_as_website: `%strong% đã được xuất bản tại:`,
        disable_2fa: 'Tắt 2FA',
        disable_2fa_confirm: "Bạn có chắc chắn muốn tắt 2FA không?",
        disable_2fa_instructions: "Nhập mật khẩu của bạn để tắt 2FA.",
        disassociate_dir: "Hủy liên kết thư mục",
        documents: 'Tài liệu',
        dont_allow: 'Không cho phép',
        download: 'Tải xuống',
        download_file: 'Tải xuống tệp',
        downloading: "Đang tải xuống",
        email: "Email",
        email_change_confirmation_sent: "Một email xác nhận đã được gửi đến địa chỉ email mới của bạn. Vui lòng kiểm tra hộp thư đến và làm theo hướng dẫn để hoàn tất quy trình.",
        email_invalid: 'Email không hợp lệ.',
        email_or_username: "Email hoặc tên người dùng",
        email_required: 'Email là bắt buộc.',
        empty_trash: 'Dọn sạch thùng rác',
        empty_trash_confirmation: `Bạn có chắc chắn muốn xóa vĩnh viễn các mục trong Thùng rác không?`,
        emptying_trash: 'Đang dọn sạch Thùng rác…',
        enable_2fa: 'Bật 2FA',
        end_hard: "Kết thúc cứng",
        end_process_force_confirm: "Bạn có chắc chắn muốn buộc kết thúc quá trình này không?",
        end_soft: "Kết thúc mềm",
        enlarged_qr_code: "Mã QR phóng to",
        enter_password_to_confirm_delete_user: "Nhập mật khẩu của bạn để xác nhận xóa tài khoản",
        error_message_is_missing: "Thiếu thông báo lỗi.",
        error_unknown_cause: "Đã xảy ra lỗi không xác định.",
        error_uploading_files: "Không thể tải lên tệp",
        favorites: "Yêu thích",
        feedback: "Phản hồi",
        feedback_c2a: "Vui lòng sử dụng biểu mẫu dưới đây để gửi phản hồi, nhận xét và báo cáo lỗi của bạn.",
        feedback_sent_confirmation: "Cảm ơn bạn đã liên hệ với chúng tôi. Nếu bạn có email liên kết với tài khoản của mình, chúng tôi sẽ phản hồi bạn trong thời gian sớm nhất.",
        fit: "Vừa khít",
        folder: 'Thư mục',
        force_quit: 'Buộc thoát',
        forgot_pass_c2a: "Quên mật khẩu?",
        from: "Từ",
        general: "Chung",
        get_a_copy_of_on_puter: `Nhận một bản sao của '%%' trên Puter.com!`,
        get_copy_link: 'Lấy liên kết sao chép',
        hide_all_windows: "Ẩn tất cả cửa sổ",
        home: 'Trang chủ',
        html_document: 'Tài liệu HTML',
        hue: 'Màu sắc',
        image: 'Hình ảnh',
        incorrect_password: "Mật khẩu không chính xác",
        invite_link: "Liên kết mời",
        item: 'mục',
        items_in_trash_cannot_be_renamed: `Mục này không thể đổi tên vì nó đang ở trong thùng rác. Để đổi tên mục này, trước tiên hãy kéo nó ra khỏi Thùng rác.`,
        jpeg_image: 'Hình ảnh JPEG',
        keep_in_taskbar: 'Giữ trong thanh tác vụ',
        language: "Ngôn ngữ",
        license: "Giấy phép",
        lightness: 'Độ sáng',
        link_copied: "Đã sao chép liên kết",
        loading: 'Đang tải',
        log_in: "Đăng nhập",
        log_into_another_account_anyway: 'Vẫn đăng nhập vào tài khoản khác',
        log_out: 'Đăng xuất',
        looks_good: "Trông tốt!",
        manage_sessions: "Quản lý phiên",
        menubar_style: "Kiểu thanh menu",
        menubar_style_desktop: "Màn hình chính",
        menubar_style_system: "Hệ thống",
        menubar_style_window: "Cửa sổ",
        modified: 'Đã sửa đổi',
        move: 'Di chuyển',
        moving_file: "Đang di chuyển %%",
        my_websites: "Trang web của tôi",
        name: 'Tên',
        name_cannot_be_empty: 'Tên không thể để trống.',
        name_cannot_contain_double_period: "Tên không thể là ký tự '..'.",
        name_cannot_contain_period: "Tên không thể là ký tự '.'.",
        name_cannot_contain_slash: "Tên không thể chứa ký tự '/'.",
        name_must_be_string: "Tên chỉ có thể là chuỗi.",
        name_too_long: `Tên không thể dài hơn %% ký tự.`,
        new: 'Mới',
        new_email: 'Email mới',
        new_folder: 'Thư mục mới',
        new_password: "Mật khẩu mới",
        new_username: "Tên người dùng mới",
        no: 'Không',
        no_dir_associated_with_site: 'Không có thư mục nào liên kết với địa chỉ này.',
        no_websites_published: "Bạn chưa xuất bản trang web nào. Nhấp chuột phải vào một thư mục để bắt đầu.",
        ok: 'OK',
        open: "Mở",
        open_in_new_tab: "Mở trong tab mới",
        open_in_new_window: "Mở trong cửa sổ mới",
        open_with: "Mở bằng",
        original_name: 'Tên gốc',
        original_path: 'Đường dẫn gốc',
        oss_code_and_content: "Phần mềm mã nguồn mở và nội dung",
        password: "Mật khẩu",
        password_changed: "Đã thay đổi mật khẩu.",
        password_recovery_rate_limit: "Bạn đã đạt đến giới hạn tốc độ của chúng tôi; vui lòng đợi vài phút. Để tránh điều này trong tương lai, hãy tránh tải lại trang quá nhiều lần.",
        password_recovery_token_invalid: "Mã khôi phục mật khẩu này không còn hợp lệ.",
        password_recovery_unknown_error: "Đã xảy ra lỗi không xác định. Vui lòng thử lại sau.",
        password_required: 'Mật khẩu là bắt buộc.',
        password_strength_error: "Mật khẩu phải có ít nhất 8 ký tự và chứa ít nhất một chữ cái viết hoa, một chữ cái viết thường, một số và một ký tự đặc biệt.",
        passwords_do_not_match: '`Mật khẩu mới` và `Xác nhận mật khẩu mới` không khớp.',
        paste: 'Dán',
        paste_into_folder: "Dán vào thư mục",
        path: 'Đường dẫn',
        personalization: "Cá nhân hóa",
        pick_name_for_website: "Chọn một tên cho trang web của bạn:",
        picture: "Hình ảnh",
        pictures: 'Hình ảnh',
        plural_suffix: '',
        powered_by_puter_js: `Được hỗ trợ bởi {{link=docs}}Puter.js{{/link}}`,
        preparing: "Đang chuẩn bị...",
        preparing_for_upload: "Đang chuẩn bị để tải lên...",
        print: 'In',
        privacy: "Quyền riêng tư",
        proceed_to_login: 'Tiếp tục đăng nhập',
        proceed_with_account_deletion: "Tiếp tục xóa tài khoản",
        process_status_initializing: "Đang khởi tạo",
        process_status_running: "Đang chạy",
        process_type_app: 'Ứng dụng',
        process_type_init: 'Khởi tạo',
        process_type_ui: 'Giao diện',
        properties: "Thuộc tính",
        public: 'Công khai',
        publish: "Xuất bản",
        publish_as_website: 'Xuất bản như trang web',
        puter_description: `Puter là một đám mây cá nhân đặt quyền riêng tư lên hàng đầu để lưu trữ tất cả các tệp, ứng dụng và trò chơi của bạn trong một nơi an toàn, có thể truy cập từ mọi nơi vào bất kỳ lúc nào.`,
        reading_file: "Đang đọc %strong%",
        recent: "Gần đây",
        recommended: "Được đề xuất",
        recover_password: "Khôi phục mật khẩu",
        refer_friends_c2a: "Nhận 1 GB cho mỗi người bạn tạo và xác nhận tài khoản trên Puter. Bạn của bạn cũng sẽ nhận được 1 GB!",
        refer_friends_social_media_c2a: `Nhận 1 GB dung lượng lưu trữ miễn phí trên Puter.com!`,
        refresh: 'Làm mới',
        release_address_confirmation: `Bạn có chắc chắn muốn giải phóng địa chỉ này không?`,
        remove_from_taskbar: 'Xóa khỏi thanh tác vụ',
        rename: 'Đổi tên',
        repeat: 'Lặp lại',
        replace: 'Thay thế',
        replace_all: 'Thay thế tất cả',
        resend_confirmation_code: "Gửi lại mã xác nhận",
        reset_colors: "Đặt lại màu sắc",
        restart_puter_confirm: "Bạn có chắc chắn muốn khởi động lại Puter không?",
        restore: "Khôi phục",
        save: 'Lưu',
        saturation: 'Độ bão hòa',
        save_account: 'Lưu tài khoản',
        save_account_to_get_copy_link: "Vui lòng tạo một tài khoản để tiếp tục.",
        save_account_to_publish: 'Vui lòng tạo một tài khoản để tiếp tục.',
        save_session: 'Lưu phiên',
        save_session_c2a: 'Tạo một tài khoản để lưu phiên hiện tại của bạn và tránh mất công việc của bạn.',
        scan_qr_c2a: 'Quét mã bên dưới\nđể đăng nhập vào phiên này từ các thiết bị khác',
        scan_qr_2fa: 'Quét mã QR bằng ứng dụng xác thực của bạn',
        scan_qr_generic: 'Quét mã QR này bằng điện thoại hoặc thiết bị khác của bạn',
        search: 'Tìm kiếm',
        seconds: 'giây',
        security: "Bảo mật",
        select: "Chọn",
        selected: 'đã chọn',
        select_color: 'Chọn màu…',
        sessions: "Phiên",
        send: "Gửi",
        send_password_recovery_email: "Gửi email khôi phục mật khẩu",
        session_saved: "Cảm ơn bạn đã tạo tài khoản. Phiên này đã được lưu.",
        settings: "Cài đặt",
        set_new_password: "Đặt mật khẩu mới",
        share: "Chia sẻ",
        share_to: "Chia sẻ đến",
        share_with: "Chia sẻ với:",
        shortcut_to: "Lối tắt đến",
        show_all_windows: "Hiển thị tất cả cửa sổ",
        show_hidden: 'Hiển thị mục ẩn',
        sign_in_with_puter: "Đăng nhập bằng Puter",
        sign_up: "Đăng ký",
        signing_in: "Đang đăng nhập…",
        size: 'Kích thước',
        skip: 'Bỏ qua',
        something_went_wrong: "Đã xảy ra lỗi.",
        sort_by: 'Sắp xếp theo',
        start: 'Bắt đầu',
        status: "Trạng thái",
        storage_usage: "Sử dụng bộ nhớ",
        storage_puter_used: 'đã sử dụng bởi Puter',
        taking_longer_than_usual: 'Đang mất nhiều thời gian hơn bình thường. Vui lòng đợi...',
        task_manager: "Trình quản lý tác vụ",
        taskmgr_header_name: "Tên",
        taskmgr_header_status: "Trạng thái",
        taskmgr_header_type: "Loại",
        terms: "Điều khoản",
        text_document: 'Tài liệu văn bản',
        tos_fineprint: `Bằng cách nhấp vào 'Tạo tài khoản miễn phí', bạn đồng ý với {{link=terms}}Điều khoản dịch vụ{{/link}} và {{link=privacy}}Chính sách quyền riêng tư{{/link}} của Puter.`,
        transparency: "Độ trong suốt",
        trash: 'Thùng rác',
        two_factor: 'Xác thực hai yếu tố',
        two_factor_disabled: '2FA đã tắt',
        two_factor_enabled: '2FA đã bật',
        type: 'Loại',
        type_confirm_to_delete_account: "Gõ 'confirm' để xóa tài khoản của bạn.",
        ui_colors: "Màu sắc giao diện",
        ui_manage_sessions: "Quản lý phiên",
        ui_revoke: "Thu hồi",
        undo: 'Hoàn tác',
        unlimited: 'Không giới hạn',
        unzip: "Giải nén",
        upload: 'Tải lên',
        upload_here: 'Tải lên tại đây',
        usage: 'Sử dụng',
        username: "Tên người dùng",
        username_changed: 'Đã cập nhật tên người dùng thành công.',
        username_required: 'Tên người dùng là bắt buộc.',
        versions: "Phiên bản",
        videos: 'Video',
        visibility: 'Hiển thị',
        yes: 'Có',
        yes_release_it: 'Có, giải phóng nó',
        you_have_been_referred_to_puter_by_a_friend: "Bạn đã được giới thiệu đến Puter bởi một người bạn!",
        zip: "Nén",
        zipping_file: "Đang nén %strong%",

        // === 2FA Setup ===
        setup2fa_1_step_heading: 'Mở ứng dụng xác thực của bạn',
        setup2fa_1_instructions: `
            Bạn có thể sử dụng bất kỳ ứng dụng xác thực nào hỗ trợ giao thức Mật khẩu một lần dựa trên thời gian (TOTP).
            Có nhiều lựa chọn, nhưng nếu bạn không chắc chắn
            <a target="_blank" href="https://authy.com/download">Authy</a>
            là một lựa chọn tốt cho Android và iOS.
        `,
        setup2fa_2_step_heading: 'Quét mã QR',
        setup2fa_3_step_heading: 'Nhập mã 6 chữ số',
        setup2fa_4_step_heading: 'Sao chép mã khôi phục của bạn',
        setup2fa_4_instructions: `
            Những mã khôi phục này là cách duy nhất để truy cập tài khoản của bạn nếu bạn mất điện thoại hoặc không thể sử dụng ứng dụng xác thực.
            Hãy đảm bảo lưu trữ chúng ở một nơi an toàn.
        `,
        setup2fa_5_step_heading: 'Xác nhận thiết lập 2FA',
        setup2fa_5_confirmation_1: 'Tôi đã lưu mã khôi phục của mình ở một nơi an toàn',
        setup2fa_5_confirmation_2: 'Tôi đã sẵn sàng để bật 2FA',
        setup2fa_5_button: 'Bật 2FA',

        // === 2FA Login ===
        login2fa_otp_title: 'Nhập mã 2FA',
        login2fa_otp_instructions: 'Nhập mã 6 chữ số từ ứng dụng xác thực của bạn.',
        login2fa_recovery_title: 'Nhập mã khôi phục',
        login2fa_recovery_instructions: 'Nhập một trong các mã khôi phục của bạn để truy cập tài khoản.',
        login2fa_use_recovery_code: 'Sử dụng mã khôi phục',
        login2fa_recovery_back: 'Quay lại',
        login2fa_recovery_placeholder: 'XXXXXXXX',

        "change": 'Thay đổi', // In English: "Change"
        "clock_visibility": 'ẩn/hiện đồng hồ', // In English: "Clock Visibility"
        "plural_suffix": 'các', // In English: "s"
        "reading": 'Đang đọc %strong%', // In English: "Reading %strong%"
        "writing": 'Đang ghi dữ liệu %strong%', // In English: "Writing %strong%"
        "unzipping": 'Đang giải nén %strong%', // In English: "Unzipping %strong%"
        "sequencing": 'Đang đánh thứ tự %strong%', // In English: "Sequencing %strong%"
        "zipping": 'Đang nén %strong%', // In English: "Zipping %strong%"
        "Editor": 'Người chỉnh sửa', // In English: "Editor"
        "Viewer": 'Người xem', // In English: "Viewer"
        "People with access": 'Người dùng có quyền truy cập', // In English: "People with access"
        "Share With…": 'Chia sẻ với...', // In English: "Share With…"
        "Owner": 'Người sở hữu', // In English: "Owner"
        "You can't share with yourself.": 'Bạn không thể tự chia sẻ với chính mình', // In English: "You can't share with yourself."
        "This user already has access to this item": 'Người dùng này đã có sẵn quyền truy cập cho mục này', // In English: "This user already has access to this item"

        "billing.change_payment_method": "Thay đổi", // In English: "Change"
        "billing.cancel": "Hủy", // In English: "Cancel"
        "billing.download_invoice": "Tải xuống", // In English: "Download"
        "billing.payment_method": "Phương thức thanh toán", // In English: "Payment Method"
        "billing.payment_method_updated": "Phương thức thanh toán đã được cập nhật thành công!", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "Xác nhận phương thức thanh toán", // In English: "Confirm Payment Method"
        "billing.payment_history": "Lịch sử thanh toán", // In English: "Payment History"
        "billing.refunded": "Đã hoàn tiền", // In English: "Refunded"
        "billing.paid": "Đã thanh toán", // In English: "Paid"
        "billing.ok": "OK", // In English: "OK"
        "billing.resume_subscription": "Tiếp tục đăng ký", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "Đăng ký của bạn đã bị hủy.", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "Bạn vẫn có thể tiếp tục sử dụng dịch vụ của mình cho đến cuối kỳ thanh toán này.", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "Miễn phí", // In English: "Free"
        "billing.offering.pro": "Chuyên nghiệp", // In English: "Professional"
        "billing.offering.business": "Doanh nghiệp", // In English: "Business"
        "billing.cloud_storage": "Lưu trữ đám mây", // In English: "Cloud Storage"
        "billing.ai_access": "Truy cập AI", // In English: "AI Access"
        "billing.bandwidth": "Băng thông", // In English: "Bandwidth"
        "billing.apps_and_games": "Ứng dụng & Trò chơi", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "Nâng cấp lên %strong%", // In English: "Upgrade to %strong%"
        "billing.switch_to": "Chuyển sang gói %strong%", // In English: "Switch to %strong%"
        "billing.payment_setup": "Thiết lập thanh toán", // In English: "Payment Setup"
        "billing.back": "Quay lại", // In English: "Back"
        "billing.you_are_now_subscribed_to": "Bạn hiện đang đăng ký gói %strong%.", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "Bạn đã đăng ký", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "Bạn có chắc chắn muốn hủy đăng ký không?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "Thiết lập đăng ký", // In English: "Subscription Setup"
        "billing.cancel_it": "Hủy bỏ", // In English: "Cancel It"
        "billing.keep_it": "Giữ lại", // In English: "Keep It"
        "billing.subscription_resumed": "Đăng ký %strong% của bạn đã được tiếp tục!", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "Nâng cấp ngay", // In English: "Upgrade Now"
        "billing.upgrade": "Nâng cấp", // In English: "Upgrade"
        "billing.currently_on_free_plan": "Bạn hiện đang sử dụng gói miễn phí.", // In English: "You are currently on the free plan."
        "billing.download_receipt": "Tải biên lai", // In English: "Download Receipt"
        "billing.subscription_check_error": "Đã xảy ra sự cố khi kiểm tra trạng thái đăng ký của bạn.", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "Email của bạn chưa được xác nhận. Chúng tôi sẽ gửi mã xác nhận ngay bây giờ.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "Bạn đã hủy đăng ký và được tự động chuyển sang gói miễn phí vào cuối kỳ thanh toán. Bạn sẽ không bị tính phí nữa đến khi đăng ký lại.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "Gói cước hiện tại của bạn đến cuối kỳ thanh toán này.", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "Gói hiện tại", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "Đăng ký đã hủy (%%)", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "Quản lý", // In English: "Manage"
        "billing.limited": "Giới hạn", // In English: "Limited"
        "billing.expanded": "Mở rộng", // In English: "Expanded"
        "billing.accelerated": "Tăng tốc", // In English: "Accelerated"
        "billing.enjoy_msg": "Tận hưởng %% Lưu trữ đám mây và các tiện ích khác.", // In English: "Enjoy %% of Cloud Storage plus other benefits."
    }
};

export default vi;
