/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const ua = {
    name: "Українська",
    english_name: "Ukrainian",
    code: "ua",
    dictionary: {
        about: "Про систему",
        account: "Обліковий запис",
        account_password: "Перевірити пароль облікового запису",
        access_granted_to: "Доступ надано",
        add_existing_account: "Додати існуючий обліковий запис",
        all_fields_required: "Усі поля обов\'язкові.",
        allow: "Дозволити",
        apply: "Застосувати",
        ascending: "За зростанням",
        associated_websites: "Асоційовані веб-сайти",
        auto_arrange: 'Автоупорядкування',
        background: "Фон",
        browse: "Переглянути",
        cancel: "Відміна",
        center: "Відцентрувати",
        change: "Змінити",
        change_desktop_background: "Змінити фон робочого столу…",
        change_email: "Змінити Email",
        change_language: "Змінити Мову",
        change_password: "Змінити Пароль",
        change_ui_colors: "Змінити Тему Оформлення",
        change_username: "Змінити Ім\'я Користувача",
        clock_visibility: "Видимість годинника",
        close: "Закрити",
        close_all_windows: "Закрити всі Вікна",
        close_all_windows_confirm: "Ви впевнені, що хочете закрити всі вікна?",
        close_all_windows_and_log_out: "Закрити Вікна і Вийти",
        change_always_open_with: "Бажаєте завжди відкривати файли цього типу в",
        color: "Колір",
        confirm: "Підтвердити",
        confirm_2fa_setup: "Я додав код у свій додаток для аутентифікації",
        confirm_2fa_recovery: "Я зберіг свої коди для відновлення в безпечному місці",
        confirm_account_for_free_referral_storage_c2a: "Створіть обліковий запис і підтвердіть свою електронну адресу, щоб отримати 1 Гб безкоштовного дискового простору. Ваш друг також отримає 1 Гб безкоштовного дискового простору.",
        confirm_code_generic_incorrect: "Код невірний",
        confirm_code_generic_too_many_requests: "Забагато запитів. Будь ласка, зачекайте кілька хвилин",
        confirm_code_generic_submit: "Прийняти код",
        confirm_code_generic_try_again: "Спробувати знову",
        confirm_code_generic_title: "Ввести код підтвердження",
        confirm_code_2fa_instruction: "Введіть шестизначний код з вашого додатка для аутентифікації.",
        confirm_code_2fa_submit_btn: "Прийняти",
        confirm_code_2fa_title: "Введіть код для двофакторної аутентифікації",
        confirm_delete_multiple_items: "Ви впевнені, що хочете назавжди видалити ці елементи?",
        confirm_delete_single_item: "Ви впевнені, що хочете назавжди видалити цей елемент?",
        confirm_open_apps_log_out: "У вас є відкриті додатки. Ви впевнені, що хочете вийти з системи?",
        confirm_new_password: "Підтвердьте новий пароль",
        confirm_delete_user: "Ви впевнені, що хочете видалити свій обліковий запис? Усі ваші файли та дані будуть видалені назавжди. Цю дію неможливо скасувати.",
        confirm_delete_user_title: "Видалити обліковий запис?",
        confirm_session_revoke: "Ви впевнені, що хочете відкликати цей сеанс?",
        confirm_your_email_address: "Підтвердити електронну адресу",
        contact_us: "Зв'яжіться з нами",
        contact_us_verification_required: "Вам необхідно мати підтверджену електронну адресу для використання цієї функції",
        contain: "Зміст",
        continue: "Продовжити",
        copy: "Копіювати",
        copy_link: "Копіювати Посилання",
        copying: "Копіюється",
        copying_file: "Копіюється %%",
        cover: "Обкладинка",
        create_account: "Створити Обліковий Запис",
        create_free_account: "Створити Безкоштовний Обліковий Запис",
        create_shortcut: "Створити Ярлик",
        credits: "Титри",
        current_password: "Поточний Пароль",
        cut: "Вирізати",
        clock: "Годинник",
        clock_visible_hide: "Приховати - Завжди приховано",
        clock_visible_show: "Показати - Завжди на виду",
        clock_visible_auto: "Авто - За Замовчуванням, видно тільки у повноекранному режимі",
        close_all: "Закрити все",
        created: "Створено",
        date_modified: "Дата зміни",
        default: "За замовчуванням",
        delete: "Видалити",
        delete_account: "Видалити Обліковий Запис",
        delete_permanently: "Видалити Назавжди",
        deleting_file: "Видалення %%",
        deploy_as_app: "Розгорнути як додаток",
        descending: "За спаданням",
        desktop: "Робочий стіл",
        desktop_background_fit: "Вмістити",
        developers: "Розробники",
        dir_published_as_website: `%strong% опубліковано в:`,
        disable_2fa: "Вимкнути двофакторну аутентифікацію",
        disable_2fa_confirm: "Ви впевнені, що хочете вимкнути двофакторну аутентифікацію?",
        disable_2fa_instructions: "Введіть ваш пароль для вимкнення двофакторної аутентифікації",
        disassociate_dir: "Від'єднати Директорію",
        documents: "Документи",
        dont_allow: "Не дозволяти",
        download: "Завантажити",
        download_file: "Завантажити Файл",
        downloading: "Завантажується",
        email: "Email",
        email_change_confirmation_sent: "На вашу нову електронну адресу було надіслано листа з підтвердженням. Будь ласка, перевірте свою поштову скриньку і дотримуйтесь інструкцій, щоб завершити процес.",
        email_invalid: "Електронна адреса недійсна.",
        email_or_username: "Email або Ім'я Користувача",
        email_required: "Email обов\'язковий.",
        empty_trash: "Очистити Кошик",
        empty_trash_confirmation: `Ви впевнені, що хочете назавжди видалити елементи з Кошика?`,
        emptying_trash: "Очищення Кошика…",
        enable_2fa: "Увімкнути двофакторну аутентифікацію",
        end_hard: "Закрити жорстко",
        end_process_force_confirm: "Ви впевнені, що хочете примусово завершити цей процес?",
        end_soft: "Закрити м'яко",
        enlarged_qr_code: "Збільшити QR код",
        enter_password_to_confirm_delete_user: "Введіть пароль для підтвердження видалення облікового запису",
        error_message_is_missing: "Повідомлення про помилку відсутнє",
        error_unknown_cause: "Сталася невідома помилка",
        error_uploading_files: "Збій завантаження файлів",
        favorites: "Вибране",
        feedback: "Зворотній зв'язок",
        feedback_c2a: "Будь ласка, скористайтеся формою нижче, щоб надіслати нам свої відгуки, коментарі та повідомлення про помилки.",
        feedback_sent_confirmation: "Дякуємо, що зв'язалися з нами. Якщо у вас є електронна пошта, пов'язана з вашим обліковим записом, ми відповімо вам якомога швидше.",
        fit: "Вмістити",
        folder: "Папка",
        force_quit: "Примусово Закрити",
        forgot_pass_c2a: "Забули пароль?",
        from: "Від",
        general: "Загальний",
        get_a_copy_of_on_puter: `Отримайте копію '%%' на Puter.com!`,
        get_copy_link: "Отримати Посилання для Копіювання",
        hide_all_windows: "Приховати всі вікна",
        home: "Додому",
        html_document: "HTML документ",
        hue: "Колірна Гама",
        image: "Зображення",
        incorrect_password: "Невірний пароль",
        invite_link: "Невірне посилання",
        item: "Елемент",
        items_in_trash_cannot_be_renamed: `Цей елемент неможливо переіменувати тому що він знаходиться у кошику. Спочатку 
        перемістіть його з корзини`,
        jpeg_image: "JPEG зображення",
        keep_in_taskbar: "Зберегти на Панелі Задач",
        language: "Мова",
        license: "Ліцензія",
        lightness: "Яскравість",
        link_copied: "Посилання скопійоване",
        loading: "Завантажується",
        log_in: "Ввійти",
        log_into_another_account_anyway: "Все одно увійти в інший аккаунт",
        log_out: "Вийти",
        looks_good: "Гарно виглядає!",
        manage_sessions: "Управління Сеансами",
        menubar_style: "Стиль Меню",
        menubar_style_desktop: "Робочого стола",
        menubar_style_system: "Системи",
        menubar_style_window: "Вікна",
        modified: "Змінено",
        move: "Перемістити",
        moving_file: "Переміщується %%",
        my_websites: "Мої Сайти",
        name: "Ім\'я",
        name_cannot_be_empty: "Ім\'я не може бути порожнім.",
        name_cannot_contain_double_period: "Ім'я не может бути '..' символом.",
        name_cannot_contain_period: "Ім'я не може бути '.' символом.",
        name_cannot_contain_slash: "Ім'я не може містити '/' символ.",
        name_must_be_string: "Ім\'я може містити тільки текстові символи",
        name_too_long: `Ім\'я не може бути більш ніж %% символів уздовж.`,
        new: "Новий",
        new_email: "Новий Email",
        new_folder: "Нова папка",
        new_password: "Новий Пароль",
        new_username: "Нове Ім'я Користувача",
        no: "Ні",
        no_dir_associated_with_site: "Немає директорії, пов\'язанної з цією адресою.",
        no_websites_published: "Ви ще не опублікували жодного сайту.",
        ok: "Так",
        open: "Відчинити",
        open_in_new_tab: "Відчинити у Новій Вкладці",
        open_in_new_window: "Відчинити у Новому Вікні",
        open_with: "Відчинити за допомогою",
        original_name: "Оригінальне Ім'я",
        original_path: "Оригінальний шлях",
        oss_code_and_content: "Програмне забезпечення та контент з відкритим кодом",
        password: "Пароль",
        password_changed: "Пароль змінено.",
        password_recovery_rate_limit: "Ви досягли ліміту; будь ласка, зачекайте кілька хвилин. Щоб уникнути цього в майбутньому, не перезавантажуйте сторінку занадто багато разів.",
        password_recovery_token_invalid: "Цей токен відновлення пароля більше не дійсний.",
        password_recovery_unknown_error: "Сталася невідома помилка. Будь ласка, спробуйте пізніше.",
        password_required: "Потрібен Пароль.",
        password_strength_error: "Пароль має містити не менше 8 символів і включати хоча б одну велику літеру, одну малу літеру, одну цифру та один спеціальний символ.",
        passwords_do_not_match: "Поля Новий Пароль і Підтвердіть Новий Пароль не співпадають.",
        paste: "Вставити",
        paste_into_folder: "Вставити в Папку",
        path: "Шлях",
        personalization: "Персоналізація",
        pick_name_for_website: "Виберіть ім'я для вашого сайту:",
        picture: "Зображення",
        pictures: "Зображення",
        plural_suffix: 's',
        powered_by_puter_js: "Створено на {{link=docs}}Puter.js{{/link}}",
        preparing: "Підготовка...",
        preparing_for_upload: "Підготовка до завантаження...",
        print: "Друкувати",
        privacy: "Конфіденційність",
        proceed_to_login: "Перейти до Входу",
        proceed_with_account_deletion: "Продовжити Видалення Облікового Запису",
        process_status_initializing: "Ініціалізація",
        process_status_running: "Виконується",
        process_type_app: "Дод.",
        process_type_init: "Ініц.",
        process_type_ui: "Інтерфейс користувача",
        properties: "Властивості",
        public: "Загальний",
        publish: "Опублікувати",
        publish_as_website: "Опублікувати як сайт",
        puter_description: "Puter — це персональна хмара, яка забезпечує конфіденційність, дозволяючи зберігати всі ваші файли, додатки та ігри в одному безпечному місці, доступному з будь-якого місця в будь-який час.",
        reading: "Читання %strong%",
        reading_file: "Читання файлу",
        recent: "Недавній",
        recommended: "Рекомендований",
        recover_password: "Відновити Пароль",
        refer_friends_c2a: "Отримайте 1 ГБ за кожного друга, який створить і підтвердить обліковий запис на Puter. Ваш друг також отримає 1 ГБ!",
        refer_friends_social_media_c2a: "Отримайте 1 ГБ безкоштовного сховища на Puter.com!",
        refresh: "Оновити",
        release_address_confirmation: "Ви впевнені, що хочете звільнити цю адресу?",
        remove_from_taskbar: "Видалити з Панелі Завдань",
        rename: "Перейменувати",
        repeat: "Повторити",
        replace: "Замінити",
        replace_all: "Замінити Все",
        resend_confirmation_code: "Повторно надіслати Код Підтвердження",
        reset_colors: "Скинути Кольори",
        restart_puter_confirm: "Ви впевнені, що хочете перезапустити Puter?",
        restore: "Відновити",
        save: "Зберегти",
        saturation: "Насиченість",
        save_account: "Зберегти Обліковий запис",
        save_account_to_get_copy_link: "Будь ласка, створіть обліковий запис, щоб продовжити.",
        save_account_to_publish: "Будь ласка, створіть обліковий запис, щоб продовжити.",
        save_session: "Зберегти сеанс",
        save_session_c2a: "Створіть обліковий запис, щоб зберегти поточний сеанс і не втратити дані.",
        scan_qr_c2a: "Скануйте код нижче, щоб увійти в цей сеанс з інших пристроїв",
        scan_qr_2fa: "Скануйте код за допомогою вашого додатку для аутентифікації",
        scan_qr_generic: "Скануйте цей QR-код за допомогою телефону або іншого пристрою",
        search: "Пошук",
        seconds: "секунди",
        security: "Безпека",
        select: "Вибрати",
        selected: "вибрано",
        select_color: "Вибрати колір…",
        sessions: "Сеанси",
        send: "Надіслати",
        send_password_recovery_email: "Надіслати електронний лист для відновлення пароля",
        session_saved: "Дякуємо вам за створення облікового запису. Цей сеанс збережено.",
        settings: "Налаштування",
        set_new_password: "Встановити Новий Пароль",
        share: "Поділитися",
        share_to: "Поділитися з",
        share_with: "Поділитися з",
        shortcut_to: "Ярлик для",
        show_all_windows: "Показати Всі Вікна",
        show_hidden: 'Показати приховані',
        sign_in_with_puter: "Увійти з Puter",
        sign_up: "Зареєструватися",
        signing_in: "Вхід у систему…",
        size: "Розмір",
        skip: "Пропустити",
        sort_by: "Відсортувати за",
        start: "Почати",
        status: "Статус",
        storage_usage: "Використання сховища",
        storage_puter_used: "використано Puter",
        taking_longer_than_usual: "Це займає трохи більше часу, ніж зазвичай. будь ласка, зачекайте...",
        task_manager: "Диспетчер Завдань",
        taskmgr_header_name: "Ім'я",
        taskmgr_header_status: "Статус",
        taskmgr_header_type: "Тип",
        terms: "Умови",
        text_document: "Текстовий документ",
        tos_fineprint: "Натискаючи 'Створити безкоштовний обліковий запис', ви погоджуєтеся з {{link=terms}}Умовами Використання{{/link}} та {{link=privacy}}Політикою Конфіденційності{{/link}} Puter.",
        transparency: "Прозорість",
        trash: "Кошик",
        two_factor: "Двофакторна аутентифікація",
        two_factor_disabled: "Двофакторна аутентифікація вимкнена",
        two_factor_enabled: "Двофакторна аутентифікація увімкнена",
        type: "Тип",
        type_confirm_to_delete_account: "Введіть 'Підтвердити', щоб видалити обліковий запис.",
        ui_colors: "Кольори UI",
        ui_manage_sessions: "Менеджер Сеансів",
        ui_revoke: "Відкликати",
        undo: "Скасувати",
        unlimited: "Необмежено",
        unzip: "Розпакувати",
        unzipping: "Розпакування %strong%",
        upload: "Завантажити",
        upload_here: "Завантажити тут",
        usage: "Використання",
        username: "Ім'я Користувача",
        username_changed: "Ім'я Користувача успішно оновлено.",
        username_required: "Потрібно ім'я Користувача.",
        versions: "Версії",
        videos: "Відео",
        visibility: "Видимість",
        writing: "Написання %strong%",
        yes: "Так",
        yes_release_it: "Так, звільнити.",
        you_have_been_referred_to_puter_by_a_friend: "Вас запросив друг у Puter!",
        zip: "Архівувати",
        zipping: "Архівування %strong%",
        zipping_file: "Архівування %strong%",
        sequencing: "Порядок %strong%",
        setup2fa_1_step_heading: "Відкрийте ваш додаток для аутентифікації",
        setup2fa_1_instructions: `Ви можете використовувати будь-який додаток, який підтримує Одноразовий Пароль на основі часу. Їх багато, але якщо ви не впевнені у виборі <a target="_blank" href="https://authy.com/download">Authy</a> є чудовим варіантом для Android і iOS.`,
        setup2fa_2_step_heading: "Скануйте QR код",
        setup2fa_3_step_heading: "Введіть шестизначний код",
        setup2fa_4_step_heading: "Скопіюйте ваші коди відновлення",
        setup2fa_4_instructions: "Ці коди відновлення є єдиним способом входу у ваш обліковий запис, якщо ви втратите телефон або не зможете використовувати додаток для аутентифікації. Упевніться, що ви їх зберегли.",
        setup2fa_5_step_heading: "Підтвердьте налаштування 2FA",
        setup2fa_5_confirmation_1: "Я зберіг свої коди в надійному місці",
        setup2fa_5_confirmation_2: "Я готовий використовувати 2FA",
        setup2fa_5_button: "Увімкнути 2FA",
        something_went_wrong: "Щось пішло не так.",
        login2fa_otp_title: "Введіть код 2FA",
        login2fa_otp_instructions: "Введіть шестизначний код з вашого додатку для аутентифікації",
        login2fa_recovery_title: "Введіть код відновлення",
        login2fa_recovery_instructions: "Введіть один з кодів відновлення для доступу до облікового запису",
        login2fa_use_recovery_code: "Використовуйте код відновлення",
        login2fa_recovery_back: "Назад",
        login2fa_recovery_placeholder: "XXXXXXXX",
        Editor: "Редактор",
        Viewer: "Переглядач",
        "People with access": "Люди з доступом",
        "Share With…": "Поділитися з...",
        Owner: "Власник",
        "You can't share with yourself.": "Ви не можете поділитися з собою.",
        "This user already has access to this item": "Цей користувач уже має доступ до цього елементу",
        "billing.change_payment_method": "Змінити",
        "billing.cancel": "Скасувати",
        "billing.download_invoice": "Завантажити",
        "billing.payment_method": "Спосіб оплати",
        "billing.payment_method_updated": "Спосіб оплати оновлено!",
        "billing.confirm_payment_method": "Підтвердити спосіб оплати",
        "billing.payment_history": "Історія платежів",
        "billing.refunded": "Платіж повернено",
        "billing.paid": "Cплачено",
        "billing.ok": "Ок",
        "billing.resume_subscription": "Поновити підписку",
        "billing.subscription_cancelled": "Вашу підписку було скасовано.",
        "billing.subscription_cancelled_description": "Ви матимете доступ до своєї підписки до кінця поточного розрахункового періоду.",
        "billing.offering.free": "Free", // In English: "Free"
        "billing.offering.pro": "Professional", // In English: "Professional"
        "billing.offering.business": "Business", // In English: "Business"
        "billing.cloud_storage": "Хмарне сховище",
        "billing.ai_access": "Доступ до ШІ",
        "billing.bandwidth": "Пропускна здатність",
        "billing.apps_and_games": "Додатки та ігри",
        "billing.upgrade_to_pro": "Оновити до %strong%",
        "billing.switch_to": "Перейти до %strong%",
        "billing.payment_setup": "Налаштування платежів",
        "billing.back": "Назад",
        "billing.you_are_now_subscribed_to": "Тепер рівень Вашої підписки — %strong%",
        "billing.you_are_now_subscribed_to_without_tier": "Тепер Ви маєте підписку",
        "billing.subscription_cancellation_confirmation": "Ви впевнені, що хочете скасувати підписку?",
        "billing.subscription_setup": "Налаштування підписки",
        "billing.cancel_it": "Скасувати",
        "billing.keep_it": "Залишити",
        "billing.subscription_resumed": "Вашу підписку %strong% було поновлено!",
        "billing.upgrade_now": "Оновити зараз",
        "billing.upgrade": "Оновити",
        "billing.currently_on_free_plan": "Наразі Ви використовуєте безкоштовний тариф.",
        "billing.download_receipt": "Завантажити квитанцію",
        "billing.subscription_check_error": "Під час перевірки статусу підписки виникла проблема",
        "billing.email_confirmation_needed": "Ваша електронна пошта не була підтверджена. Ми надішлемо Вам код для підтвердження.",
        "billing.sub_cancelled_but_valid_until": "Ви скасували підписку, і вона автоматично перейде на безкоштовний рівень в кінці розрахункового періоду. Плата за підписку не стягуватиметься, якщо ви не оформите її повторно.",
        "billing.current_plan_until_end_of_period": "Ваш тарифний план до кінця поточного розрахункового періоду",
        "billing.current_plan": "Поточний тарифний план",
        "billing.cancelled_subscription_tier": "Скасована підписка (%%)",
        "billing.manage": "Керування",
        "billing.limited": "Обмежений",
        "billing.expanded": "Розширений",
        "billing.accelerated": "Прискорений",
        "billing.enjoy_msg": "Насолоджуйтесь %% хмарного сховища та іншими перевагами.",

    }
}

export default ua;
