/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const tr = {
    name: "Türkçe",
    english_name: "Turkish",
    code: "tr",
    dictionary: {
        about: "Hakkında",
        account: "Hesap",
        account_password: "Hesap parolasını doğrula",
        access_granted_to: "Erişim İzni Verildi",
        add_existing_account: "Mevcut Hesabı Ekle",
        all_fields_required: "Tüm alanların doldurulması zorunludur.",
        allow: "İzin ver",
        apply: "Uygula",
        ascending: "Artan",
        associated_websites: "İlişkilendirilmiş Web Siteleri",
        auto_arrange: "Otomatik Düzenle",
        background: "Arka Plan",
        browse: "Gözat",
        cancel: "İptal",
        center: "Ortala",
        change_desktop_background: "Masaüstü arka planını değiştir…",
        change_email: "E-postayı Değiştir",
        change_language: "Dili Değiştir",
        change_password: "Parolayı Değiştir",
        change_ui_colors: "Arayüz Renklerini Değiştir",
        change_username: "Kullanıcı Adını Değiştir",
        close: "Kapat",
        close_all_windows: "Tüm Pencereleri Kapat",
        close_all_windows_confirm: "Tüm pencereleri kapatmak istediğine emin misin?",
        close_all_windows_and_log_out: "Pencereleri Kapat ve Çıkış Yap",
        change_always_open_with: "Bu tür dosyaları her zaman şununla açmak istiyor musunuz",
        color: "Renk",
        confirm_2fa_setup: "Kodu kimlik doğrulama uygulamama ekledim",
        confirm_2fa_recovery: "Kurtarma kodlarımı güvenli bir yere kaydettim",
        confirm_account_for_free_referral_storage_c2a: "1 GB ücretsiz depolama alanı kazanmak için bir hesap oluşturun ve e-posta adresinizi onaylayın. Arkadaşınız da 1 GB ücretsiz depolama alanı kazanacak.",
        confirm_code_generic_incorrect: "Hatalı Kod.",
        confirm_code_generic_too_many_requests: "Çok fazla istek. Lütfen birkaç dakika bekleyin.",
        confirm_code_generic_submit: "Kodu Gönder",
        confirm_code_generic_try_again: "Tekrar Dene",
        confirm_code_generic_title: "Doğrulama Kodunu Gir",
        confirm_code_2fa_instruction: "Kimlik doğrulama uygulamanızdaki 6 haneli kodu girin",
        confirm_code_2fa_submit_btn: "Gönder",
        confirm_code_2fa_title: "İki faktörlü kimlik doğrulama kodunu girin", // Turkish abbreviation of 2FA doesn't exist
        confirm_delete_multiple_items: "Bu öğeleri kalıcı olarak silmek istediğinize emin misiniz?",
        confirm_delete_single_item: "Bu öğeyi kalıcı olarak silmek istiyor musunuz?",
        confirm_open_apps_log_out: "Açık uygulamalarınız var. Çıkış yapmak istediğinize emin misiniz?",
        confirm_new_password: "Yeni Parolayı Onayla",
        confirm_delete_user: "Hesabınızı silmek istediğinize emin misiniz? Tüm dosyalarınız ve verileriniz kalıcı olarak silinecektir. Bu işlem geri alınamaz.",
        confirm_delete_user_title: "Hesabı Sil?",
        confirm_session_revoke: "Bu oturumu sonlandırmak istediğinize emin misiniz?",
        confirm_your_email_address: "E-Posta Adresini Doğrula",
        contact_us: "Bize Ulaşın",
        contact_us_verification_required: "Bunu kullanmak için doğrulanmış bir e-posta adresiniz olmalıdır.",
        contain: "Dahil et",
        continue: "Devam",
        copy: "Kopyala",
        copy_link: "Bağlantıyı Kopyala",
        copying: "Kopyalanıyor",
        copying_file: "%% Kopyalanıyor",
        cover: "Kapak",
        create_account: "Hesap Oluştur",
        create_free_account: "Ücretsiz Hesap Oluştur",
        create_shortcut: "Kısayol Oluştur",
        credits: "Katkıda Bulunanlar",
        current_password: "Mevcut Parola",
        cut: "Kes",
        clock: "Saat",
        clock_visible_hide: "Gizle - Daima gizli",
        clock_visible_show: "Göster - Daima görünür",
        clock_visible_auto: "Otomatik - Varsayılan, yalnızca tam ekran modunda görünür.",
        close_all: "Tümünü Kapat",
        created: "Oluşturuldu",
        date_modified: "Değiştirilme tarihi",
        default: "Varsayılan",
        delete: "Sil",
        delete_account: "Hesabı Sil",
        delete_permanently: "Kalıcı Olarak Sil",
        deleting_file: "%% Siliniyor",
        deploy_as_app: "Uygulama olarak dağıt",
        descending: "Azalan",
        desktop: "Masaüstü",
        desktop_background_fit: "Sığdır",
        developers: "Geliştiriciler",
        dir_published_as_website: "%strong% şu adrese yayınlandı:",
        disable_2fa: "İki faktörlü doğrulamayı kapat",
        disable_2fa_confirm: "İki faktörlü doğrulamayı kapatmak istediğinize emin misiniz?",
        disable_2fa_instructions: "İki faktörlü doğrulamayı kapatmak için parolanızı girin.",
        disassociate_dir: "Dizini Ayır",
        documents: "Belgeler",
        dont_allow: "İzin Verme",
        download: "İndir",
        download_file: "Dosyayı İndir",
        downloading: "İndiriliyor",
        email: "E-posta",
        email_change_confirmation_sent: "Yeni e-posta adresinize bir onay e-postası gönderilmiştir. Lütfen gelen kutunuzu kontrol edin ve işlemi tamamlamak için talimatları takip edin.",
        email_invalid: "Geçersiz E-Posta",
        email_or_username: "E-posta veya Kullanıcı Adı",
        email_required: "E-Posta gerekli.",
        empty_trash: "Çöp Kutusunu Boşalt",
        empty_trash_confirmation: "Çöp Kutusundaki öğeleri kalıcı olarak silmek istediğinize emin misiniz?",
        emptying_trash: "Çöp Kutusu Boşaltılıyor…",
        enable_2fa: "İki Faktörlü Doğrulamayı Etkinleştir",
        end_hard: "Zorla Bitir",
        end_process_force_confirm: "Bu işlemden çıkmaya zorlamak istediğinize emin misiniz?",
        end_soft: "Normal Bitir",
        enlarged_qr_code: "Büyütülmüş Karekod",
        enter_password_to_confirm_delete_user: "Hesap silme işlemini onaylamak için parolanızı girin",
        error_message_is_missing: "Hata mesajı eksik.",
        error_unknown_cause: "Bilinmeyen bir hata meydana geldi.",
        error_uploading_files: "Dosyalar yüklenemedi",
        favorites: "Favoriler",
        feedback: "Geri Bildirim",
        feedback_c2a: "Lütfen geri bildirimlerinizi, yorumlarınızı ve hata raporlarınızı bize göndermek için aşağıdaki formu kullanın.",
        feedback_sent_confirmation: "Bizimle iletişime geçtiğiniz için teşekkür ederiz. Hesabınızla ilişkili bir e-postanız varsa, en kısa sürede size geri döneceğiz.",
        fit: "Sığdır",
        folder: "Klasör",
        force_quit: "Çıkmaya Zorla",
        forgot_pass_c2a: "Parolanızı mı unuttunuz?",
        from: "Kimden",
        general: "Genel",
        get_a_copy_of_on_puter: "'%' kopyasını Puter.com'da edinin!",
        get_copy_link: "Kopyalama Bağlantısını Al",
        hide_all_windows: "Tüm Pencereleri Gizle",
        home: "Anasayfa",
        html_document: "HTML belgesi",
        hue: "Renk Tonu",
        image: "Resim",
        incorrect_password: "Hatalı Parola",
        invite_link: "Davet Bağlantısı",
        item: "öğe",
        items_in_trash_cannot_be_renamed: "Bu öğe, çöp kutusunda olduğu için yeniden adlandırılamaz. Bu öğeyi yeniden adlandırmak için önce çöp kutusundan çıkarın.",
        jpeg_image: "JPEG görüntüsü",
        keep_in_taskbar: "Görev Çubuğunda Tut",
        language: "Dil",
        license: "Lisans",
        lightness: "Aydınlık",
        link_copied: "Bağlantı kopyalandı",
        loading: "Yükleniyor",
        log_in: "Giriş Yap",
        log_into_another_account_anyway: "Yine de başka bir hesaba giriş yap",
        log_out: "Çıkış Yap",
        looks_good: "İyi görünüyor!",
        manage_sessions: "Oturumları Yönet",
        menubar_style: "Menü Çubuğu Stili",
        menubar_style_desktop: "Masaüstü",
        menubar_style_system: "Sistem",
        menubar_style_window: "Pencere",
        modified: "Değiştirilmiş",
        move: "Taşı",
        moving_file: "%% Taşınıyor",
        my_websites: "Web Sitelerim",
        name: "Ad",
        name_cannot_be_empty: "Ad boş olamaz.",
        name_cannot_contain_double_period: "Ad '..' karakterini içeremez.",
        name_cannot_contain_period: "Ad '.' karakterini içeremez.",
        name_cannot_contain_slash: "Ad '/' karakterini içeremez.",
        name_must_be_string: "Ad yalnızca bir dize olabilir.",
        name_too_long: "Ad %% karakterden uzun olamaz.",
        new: "Yeni",
        new_email: "Yeni E-Posta",
        new_folder: "Yeni klasör",
        new_password: "Yeni Parola",
        new_username: "Yeni Kullanıcı Adı",
        no: "Hayır",
        no_dir_associated_with_site: "Bu adresle ilişkili bir dizin yok.",
        no_websites_published: "Henüz bir web sitesi yayınlamadınız.",
        ok: "Tamam",
        open: "Aç",
        open_in_new_tab: "Yeni Sekmede Aç",
        open_in_new_window: "Yeni Pencerede Aç",
        open_with: "Şununla Aç",
        original_name: "Orijinal Ad",
        original_path: "Orijinal Yol",
        oss_code_and_content: "Açık Kaynak Kodlu Yazılım ve İçerik",
        password: "Parola",
        password_changed: "Parola değiştirildi.",
        password_recovery_rate_limit: "Hız sınırımıza ulaştınız; lütfen birkaç dakika bekleyin. Gelecekte bunu önlemek için sayfayı çok fazla yeniden yüklemekten kaçının.",
        password_recovery_token_invalid: "Bu parola kurtarma anahtarı artık geçerli değil.",
        password_recovery_unknown_error: "Bilinmeyen bir hata oluştu. Lütfen daha sonra tekrar deneyin.",
        password_required: "Parola gerekli.",
        password_strength_error: "Parola en az 8 karakter uzunluğunda olmalı ve en az bir büyük harf, bir küçük harf, bir sayı ve bir özel karakter içermelidir.",
        passwords_do_not_match: "`Yeni Parola` ve `Yeni Parolayı Onayla` eşleşmiyor.",
        paste: "Yapıştır",
        paste_into_folder: "Klasöre Yapıştır",
        path: "Yol",
        personalization: "Kişiselleştirme",
        pick_name_for_website: "Web siteniz için bir ad seçin:",
        picture: "Resim",
        pictures: "Resimler",
        plural_suffix: "",
        powered_by_puter_js: "{{link=docs}}Puter.js{{/link}} tarafından güçlendirilmiştir",
        preparing: "Hazırlanıyor...",
        preparing_for_upload: "Yüklemeye hazırlanıyor...",
        print: "Yazdır",
        privacy: "Gizlilik",
        proceed_to_login: "Giriş yapmak için devam et",
        proceed_with_account_deletion: "Hesap Silme İşlemine Devam Et",
        process_status_initializing: "Başlatılıyor",
        process_status_running: "Çalışıyor",
        process_type_app: "Uygulama",
        process_type_init: "Başlangıç",
        process_type_ui: "Kullanıcı Arayüzü",
        properties: "Özellikler",
        public: "Genel",
        publish: "Yayınla",
        publish_as_website: "Web sitesi olarak yayınla",
        puter_description: "Puter, tüm dosyalarınızı, uygulamalarınızı ve oyunlarınızı tek bir güvenli yerde tutmak için gizliliğe öncelik veren kişisel bir buluttur ve her yerden her zaman erişilebilir.",
        reading_file: "%strong% okunuyor",
        recent: "En son",
        recommended: "Önerilen",
        recover_password: "Parolayı Kurtar",
        refer_friends_c2a: "Hesap oluşturup onaylayan her arkadaşınız için 1 GB kazanın. Arkadaşınız da 1 GB kazanacak!",
        refer_friends_social_media_c2a: "Puter.com'da 1 GB ücretsiz depolama alanı kazanın!",
        refresh: "Yenile",
        release_address_confirmation: "Bu adresi bırakmak istediğinize emin misiniz?",
        remove_from_taskbar: "Görev Çubuğundan Kaldır",
        rename: "Yeniden Adlandır",
        repeat: "Tekrarla",
        replace: "Değiştir",
        replace_all: "Tümünü Değiştir",
        resend_confirmation_code: "Onay Kodunu Yeniden Gönder",
        reset_colors: "Renkleri Sıfırla",
        restart_puter_confirm: "Puter'i yeniden başlatmak istediğinize emin misiniz?",
        restore: "Geri Yükle",
        save: "Kaydet",
        saturation: "Doygunluk",
        save_account: "Hesabı kaydet",
        save_account_to_get_copy_link: "Devam etmek için lütfen bir hesap oluşturun.",
        save_account_to_publish: "Devam etmek için lütfen bir hesap oluşturun.",
        save_session: "Oturumu kaydet",
        save_session_c2a: "Geçerli oturumunuzu kaydetmek ve çalışmalarınızı kaybetmemek için bir hesap oluşturun.",
        scan_qr_c2a: "Bu oturuma diğer cihazlardan\ngiriş yapmak için aşağıdaki kodu tarayın",
        scan_qr_2fa: "Karekodu kimlik doğrulama uygulamanız ile tarayın",
        scan_qr_generic: "Bu karekodu telefonunuz ya da başka bir cihaz ile tarayın",
        search: "Ara",
        seconds: "saniye",
        security: "Güvenlik",
        select: "Seç",
        selected: "seçildi",
        select_color: "Renk seç…",
        sessions: "Oturumlar",
        send: "Gönder",
        send_password_recovery_email: "Parola Kurtarma E-postası Gönder",
        session_saved: "Hesap oluşturduğunuz için teşekkür ederiz. Oturumunuz kaydedildi.",
        settings: "Ayarlar",
        set_new_password: "Yeni Parola Belirle",
        share: "Paylaş",
        share_to: "Şuna paylaş",
        share_with: "Şununla paylaş",
        shortcut_to: "Şuna kısayol oluştur",
        show_all_windows: "Tüm Pencereleri Göster",
        show_hidden: "Gizli dosyaları göster",
        sign_in_with_puter: "Puter ile giriş yap",
        sign_up: "Kaydol",
        signing_in: "Giriş yapılıyor…",
        size: "Boyut",
        skip: "Atla",
        something_went_wrong: "Bir şeyler ters gitti.",
        sort_by: "Şuna göre sırala",
        start: "Başlat",
        status: "Durum",
        storage_usage: "Depolama Alanı Kullanımı",
        storage_puter_used: "Puter tarafından kullanılıyor",
        taking_longer_than_usual: "Normalden biraz daha uzun sürüyor. Lütfen bekleyin...",
        task_manager: "Görev Yöneticisi",
        taskmgr_header_name: "Ad",
        taskmgr_header_status: "Durum",
        taskmgr_header_type: "Tür",
        terms: "Şartlar",
        text_document: "Metin belgesi",
        tos_fineprint: "'Ücretsiz Hesap Oluştur'u tıklayarak Puter'ın {{link=terms}}Hizmet Şartları{{/link}} ve {{link=privacy}}Gizlilik Politikası{{/link}}'nı kabul etmiş olursunuz.",
        transparency: "Saydamlık",
        trash: "Çöp Kutusu",
        two_factor: "İki Faktörlü Doğrulama",
        two_factor_disabled: "İki Faktörlü Doğrulama Devre Dışı",
        two_factor_enabled: "İki Faktörlü Doğrulama Etkin",
        type: "Tür",
        type_confirm_to_delete_account: "Hesabınızı silmek için 'onayla' yazın.",
        ui_colors: "Arayüz Renkleri",
        ui_manage_sessions: "Oturum Yöneticisi",
        ui_revoke: "Sonlandır",
        undo: "Geri Al",
        unlimited: "Sınırsız",
        unzip: "Çıkart",
        upload: "Yükle",
        upload_here: "Buraya yükle",
        usage: "Kullanım",
        username: "Kullanıcı Adı",
        username_changed: "Kullanıcı adı başarıyla güncellendi.",
        username_required: "Kullanıcı Adı gerekli.",
        versions: "Sürümler",
        videos: "Videolar",
        visibility: "Görünürlük",
        yes: "Evet",
        yes_release_it: "Evet, Bırak",
        you_have_been_referred_to_puter_by_a_friend: "Bir arkadaşınız tarafından Puter'a yönlendirildiniz!",
        zip: "Sıkıştır",
        zipping_file: "%strong% sıkıştırılıyor",

        // === 2FA Setup ===
        setup2fa_1_step_heading: "Kimlik doğrulama uygulamanızı açın",
        setup2fa_1_instructions: `
            Zaman tabanlı tek seferlik parola (TOTP) protokolünü
            destekleyen herhangi bir kimlik doğrulayıcı uygulamasını
            kullanabilirsiniz. Aralarından seçim yapabileceğiniz çok 
            sayıda uygulama var, ancak emin değilseniz <a target="_blank" href="https://authy.com/download">Authy</a>
            Android ve IOS için sağlam bir seçimdir.
        `,
        setup2fa_2_step_heading: "Karekodu okut",
        setup2fa_3_step_heading: "6 haneli kodu girin",
        setup2fa_4_step_heading: "Kurtarma kodlarınızı kopyalayın",
        setup2fa_4_instructions: `
            Bu kurtarma kodları, telefonunuzu kaybetmeniz veya
            kimlik doğrulayıcı uygulamanızı kullanamamanız durumunda 
            hesabınıza erişmenin tek yoludur.
            Bunları güvenli bir yerde sakladığınızdan emin olun.
        `,
        setup2fa_5_step_heading: "İki Faktörlü Kimlik Doğrulama kurulumunu onayla",
        setup2fa_5_confirmation_1: "Kurtarma kodlarımı güvenli bir yere kaydettim",
        setup2fa_5_confirmation_2: "İki Faktörlü Kimlik Doğrulamayı etkinleştirmeye hazırım",
        setup2fa_5_button: "İki Faktörlü Kimlik Doğrulamayı etkinleştir",

        // === 2FA Login ===
        login2fa_otp_title: "İki Faktörlü Kimlik Doğrulama kodunu girin",
        login2fa_otp_instructions: "Kimlik doğrulama uygulamanızdaki 6 haneli kodu girin",
        login2fa_recovery_title: "Bir kurtarma kodu girin",
        login2fa_recovery_instructions: "Hesabınıza erişmek için kurtarma kodlarınızdan birini girin.",
        login2fa_use_recovery_code: "Bir kurtarma kodu kullan",
        login2fa_recovery_back: "Geri",
        login2fa_recovery_placeholder: "XXXXXXXX",

        "change": "Değiştir", // In English: "Change"
        "clock_visibility": "Saat Görünürlüğü", // In English: "Clock Visibility"
        "confirm": "Onayla", // In English: "Confirm"
        "plural_suffix": "lar", // I used "lar", but if the preceding syllable contains a vowel like e, i, ü, ö, it should actually be "ler". In English: "s"
        "reading": "%strong% okunuyor", // In English: "Reading %strong%"
        "writing": "%strong% yazılıyor", // In English: "Writing %strong%"
        "unzipping": "%strong% sıkıştırma açılıyor", // In English: "Unzipping %strong%"
        "sequencing": "%strong% sıralanıyor", // In English: "Sequencing %strong%"
        "zipping": "%strong% sıkıştırılıyor", // In English: "Zipping %strong%"
        "Editor": "Editör", // In English: "Editor"
        "Viewer": "Görüntüleyici", // In English: "Viewer"
        "People with access": "Erişimi olan kişiler", // In English: "People with access"
        "Share With…": "Paylaş...", // In English: "Share With…"
        "Owner": "Sahip", // In English: "Owner"
        "You can't share with yourself.": "Kendinizle paylaşamazsınız.", // In English: "You can't share with yourself."
        "This user already has access to this item": "Bu kullanıcının zaten bu öğeye erişimi var. ", // In English: "This user already has access to this item"

        "billing.change_payment_method": "Değiştir", // In English: "Change"
        "billing.cancel": "İptal et", // In English: "Cancel"
        "billing.download_invoice": "İndir", // In English: "Download"
        "billing.payment_method": "Ödeme Yöntemi", // In English: "Payment Method"
        "billing.payment_method_updated": "Ödeme yöntemi güncellendi!", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "Ödeme Yöntemini Onayla", // In English: "Confirm Payment Method"
        "billing.payment_history": "Ödeme Geçmişi", // In English: "Payment History"
        "billing.refunded": "İade edildi", // In English: "Refunded"
        "billing.paid": "Ödendi", // In English: "Paid"
        "billing.ok": "Tamam", // In English: "OK"
        "billing.resume_subscription": "Aboneliğe Devam Et", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "Aboneliğin iptal edildi.", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "Bu fatura döneminin sonuna kadar aboneliğinizi kullanmaya devam edebilirsiniz.", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "Ücretsiz", // In English: "Free"
        "billing.offering.pro": "Profesyonel", // In English: "Professional"
        "billing.offering.business": "İşletme", // In English: "Business"
        "billing.cloud_storage": "Bulut Depolama", // In English: "Cloud Storage"
        "billing.ai_access": "Yapay Zeka Erişimi", // In English: "AI Access"
        "billing.bandwidth": "Bant Genişliği", // In English: "Bandwidth"
        "billing.apps_and_games": "Uygulamalar & Oyunlar", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "Yükselt: %strong%", // In English: "Upgrade to %strong%"
        "billing.switch_to": "Değiştir: %strong%", // In English: "Switch to %strong%"
        "billing.payment_setup": "Ödeme Ayarları", // In English: "Payment Setup"
        "billing.back": "Geri", // In English: "Back"
        "billing.you_are_now_subscribed_to": "%strong% seviyesine abone oldunuz.", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "Abone oldunuz", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "Aboneliğinizi iptal etmek istediğinize emin misiniz?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "Abonelik Ayarları", // In English: "Subscription Setup"
        "billing.cancel_it": "İptal Et", // In English: "Cancel It"
        "billing.keep_it": "Sürdür", // In English: "Keep It"
        "billing.subscription_resumed": "%strong% aboneliğiniz yeniden başlatıldı!", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "Şimdi Yükselt", // In English: "Upgrade Now"
        "billing.upgrade": "Yükselt", // In English: "Upgrade"
        "billing.currently_on_free_plan": "Şu anda ücretsiz plandasınız.", // In English: "You are currently on the free plan."
        "billing.download_receipt": "Makbuzu İndir", // In English: "Download Receipt"
        "billing.subscription_check_error": "Abonelik durumunuzu kontrol ederken bir sorun oluştu.", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "E-Postanız henüz onaylanmadı. Onaylamanız için bir kod göndereceğiz.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "Aboneliğinizi iptal ettiniz ve bu fatura döneminin sonunda otomatik olarak ücretsiz plana geçeceksiniz. Tekrar abone olmadığınız sürece size yeniden ücret yansıtılmayacak.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "Bu fatura döneminin sonuna kadar geçerli olan mevcut planınız.", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "Mevcut planınız", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "İptal Edilen Abonelik (%%)", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "Yönet", // In English: "Manage"
        "billing.limited": "Kısıtlı", // In English: "Limited"
        "billing.expanded": "Genişletilmiş", // In English: "Expanded"
        "billing.accelerated": "Hızlandırılmış", // In English: "Accelerated"
        "billing.enjoy_msg": "Diğer avantajların yanı sıra %% Bulut Depolamanın keyfini çıkarın.", // In English: "Enjoy %% of Cloud Storage plus other benefits."
    }
};

export default tr;
