/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const th = {
    name: "ไทย",
    english_name: "Thai",
    code: "th",
    dictionary: {
        about: "เกี่ยวกับ",
        account: "บัญชี",
        account_password: "ยืนยันรหัสผ่านบัญชี",
        access_granted_to: "อนุญาตให้เข้าถึง",
        add_existing_account: "เพิ่มบัญชี",
        all_fields_required: "จำเป็นต้องกรอกข้อมูลทุกช่อง",
        allow: 'อนุญาต',
        apply: "ปรับใช้",
        ascending: "เรียงจากน้อยไปมาก",
        associated_websites: "เว็บไซต์ที่เกี่ยวข้อง",
        auto_arrange: 'จัดเรียงอัตโนมัติ',
        background: "พื้นหลัง",
        browse: "เรียกดู",
        cancel: "ยกเลิก",
        center: "จัดกึ่งกลาง",
        change_desktop_background: "เปลี่ยนพื้นหลังของเดสก์ท็อป...",
        change_email: "เปลี่ยนอีเมล",
        change_language: "เปลี่ยนภาษา",
        change_password: "เปลี่ยนรหัสผ่าน",
        change_ui_colors: "เปลี่ยนสี UI",
        change_username: "เปลี่ยนชื่อผู้ใช้",
        close: 'ปิด',
        close_all_windows: "ปิดหน้าต่างทั้งหมด",
        close_all_windows_confirm: "คุณแน่ใจว่าต้องการปิดหน้าต่างทั้งหมด?",
        close_all_windows_and_log_out: "ปิดหน้าต่างและออกจากระบบ",
        change_always_open_with: "คุณต้องการเปิดไฟล์ประเภทนี้ด้วย",
        color: "สี",
        confirm_2fa_setup: 'ฉันได้เพิ่มรหัสลงไปใน authenticator แอฟของฉันแล้ว',
        confirm_2fa_recovery: 'ฉันได้เก็บรหัสกู้ในที่ปลอดภัยแล้ว',
        confirm_account_for_free_referral_storage_c2a: "สร้างบัญชีและยืนยันที่อยู่อีเมลของคุณเพื่อรับพื้นที่จัดเก็บข้อมูลฟรี 1 GB เพื่อนของคุณจะได้รับพื้นที่จัดเก็บข้อมูลฟรี 1 GB เช่นกัน",
        confirm_code_generic_incorrect: "รหัสไม่ถูกต้อง",
        confirm_code_generic_too_many_requests: "ส่งรีเควสมากเกินไป กรุณารอสักสองสามนาที",
        confirm_code_generic_submit: "ส่งรหัส",
        confirm_code_generic_try_again: "ลองใหม่",
        confirm_code_generic_title: "กรอกรหัสยืนยัน",
        confirm_code_2fa_instruction: "กรอกรหัส6หลักจากใน authenticator แอฟ",
        confirm_code_2fa_submit_btn: "ส่งข้อมูล",
        confirm_code_2fa_title: "กรอกรหัส 2FA",
        confirm_delete_multiple_items: "คุณแน่ใจหรือไม่ว่าต้องการลบรายการเหล่านี้อย่างถาวร?",
        confirm_delete_single_item: "คุณต้องการลบรายการนี้อย่างถาวรหรือไม่?",
        confirm_open_apps_log_out: "คุณมีแอปพลิเคชันที่เปิดอยู่ คุณแน่ใจหรือไม่ว่าต้องการออกจากระบบ?",
        confirm_new_password: "ยืนยันรหัสผ่านใหม่",
        confirm_delete_user: "คุณแน่ใจว่าต้องการลบบัญชีของคุณ? ไฟล์และข้อมูลทั้งหมดของคุณจะถูกลบอย่างถาวร และไม่สามารถย้อนกลับได้",
        confirm_delete_user_title: "ลบบัญชี?",
        confirm_session_revoke: "คุณแน่ใจว่าเพิกถอนเซสชั่นของคุณ?",
        confirm_your_email_address: "ยืนยันอีเมลของคุณ",
        contact_us: "ติดต่อเรา",
        contact_us_verification_required: "คุณต้องมีอีเมล์ที่ยืนยันแล้วเพื่อใช้งานได้",
        contain: "รวม",
        continue: "ดำเนินการต่อ",
        copy: "คัดลอก",
        copy_link: "คัดลอกลิงก์",
        copying: "กำลังคัดลอก",
        copying_file: "กำลังคัดลอก %%",
        cover: "คลุมทั้งหมด",
        create_account: "สร้างบัญชี",
        create_free_account: "สร้างบัญชีฟรี",
        create_shortcut: "สร้างทางลัด",
        credits: "Credits",
        current_password: "รหัสผ่านปัจจุบัน",
        cut: "ตัด",
        clock: "นาฬิกา",
        clock_visible_hide: 'ซ่อน - ซ่อนตลอด',
        clock_visible_show: 'แสดง - แสดงตลอด',
        clock_visible_auto: 'อัตโนมัติ - ค่าเริ่มต้น, แสดงเฉพาะในโหมดเต็มจอ',
        close_all: 'ปิดหมด',
        created: 'สร้างเมื่อ',
        date_modified: "วันที่แก้ไข",
        default: 'ค่าเริ่มต้น',
        delete: "ลบ",
        delete_account: "ลบบัญชี",
        delete_permanently: "ลบอย่างถาวร",
        deleting_file: "กำลังลบ %%",
        deploy_as_app: "นำไปใช้เป็นแอป",
        descending: "เรียงจากมากไปน้อย",
        desktop: 'เดสก์ท็อป',
        desktop_background_fit: "พอดี",
        developers: "นักพัฒนา",
        dir_published_as_website: `%strong% ได้รับการเผยแพร่ไปยัง:`,
        disable_2fa: 'ปิด 2FA',
        disable_2fa_confirm: "คุณแน่ใจว่าต้องการจะปิด 2FA?",
        disable_2fa_instructions: "กรอกรหัสผ่านเพื่อปิด 2FA.",
        disassociate_dir: "ยกเลิกการเชื่อมโยงไดเรกทอรี",
        documents: 'เอกสาร',
        dont_allow: 'ไม่อนุญาต',
        download: "ดาวน์โหลด",
        download_file: "ดาวน์โหลดไฟล์",
        downloading: "กำลังดาวน์โหลด",
        email: "อีเมล",
        email_change_confirmation_sent: "อีเมล์ยืนยันได้ถูกส่งไปที่อยู่อีเมลใหม่ของคุณแล้ว กรุณาตรวจสอบกล่องข้อความของคุณและทำตามขั้นตอนต่อจนเสร็จ",
        email_invalid: 'อีเมล์ไม่ถูกต้อง.',
        email_or_username: "อีเมลหรือชื่อผู้ใช้",
        email_required: 'ต้องกรอกอีเมล์',
        empty_trash: "ลบไฟล์ในถังขยะ",
        empty_trash_confirmation: "คุณแน่ใจหรือไม่ว่าต้องการลบรายการในถังขยะอย่างถาวร?",
        emptying_trash: "กำลังลบไฟล์ในถังขยะ...",
        enable_2fa: 'เปิดใช้งาน 2FA',
        end_hard: "ปิดแบบหนัก",
        end_process_force_confirm: "คุณต้องการบังคับปิด",
        end_soft: "ปิดแบบเบา",
        enlarged_qr_code: "ขยายคิวอาร์โค้ด",
        enter_password_to_confirm_delete_user: "กรอกรหัสเพื่อยืนยันการลบบัญชี",
        error_message_is_missing: "ไม่พบข้อความแสดงความผิดพลาด",
        error_unknown_cause: "พบปัญหาที่ไม่ทราบสาเหตุ",
        error_uploading_files: "ไม่สามารถอัพโหลดไฟล์ได้",
        favorites: "ชื่นชอบ",
        feedback: "ความคิดเห็น",
        feedback_c2a: "กรุณาใช้แบบฟอร์มด้านล่างเพื่อส่งความคิดเห็น ข้อคิดเห็น และรายงานข้อบกพร่องให้เรา",
        feedback_sent_confirmation: "ขอบคุณที่ติดต่อเรา หากคุณมีอีเมลที่เชื่อมโยงกับบัญชีของคุณ คุณจะได้รับการติดต่อกลับจากเราโดยเร็วที่สุด",
        fit: "พอดี",
        folder: 'โฟลเดอร์',
        force_quit: 'บังคับปิด',
        forgot_pass_c2a: "ลืมรหัสผ่าน?",
        from: "จาก",
        general: "ทั่วไป",
        get_a_copy_of_on_puter: `รับสำเนาของ "%%" ได้ที่ Puter.com!`,
        get_copy_link: "คัดลอกลิงก์",
        hide_all_windows: "ซ่อนหน้าต่างทั้งหมด",
        home: 'บ้าน',
        html_document: "เอกสาร HTML",
        hue: 'สี',
        image: "รูปภาพ",
        incorrect_password: "รหัสไม่ถูกต้อง",
        invite_link: "ลิงก์เชิญชวน",
        item: "รายการ",
        items_in_trash_cannot_be_renamed: "ไม่สามารถเปลี่ยนชื่อรายการนี้ได้เนื่องจากอยู่ในถังขยะ หากต้องการเปลี่ยนชื่อรายการนี้ ให้ลากออกจากถังขยะก่อน",
        jpeg_image: "ภาพ JPEG",
        keep_in_taskbar: "คงไว้ในทาสก์บาร์",
        language: "ภาษา",
        license: "ใบอนุญาต",
        lightness: 'ความสว่าง',
        link_copied: "คัดลอกลิงค์แล้ว",
        loading: "กำลังโหลด",
        log_in: "เข้าสู่ระบบ",
        log_into_another_account_anyway: "ต้องการเข้าสู่บัญชีอื่น",
        log_out: "ออกจากระบบ",
        looks_good: "ดูดีเลย!",
        manage_sessions: "จัดการเซสชั่น",
        menubar_style: "ไตล์เมนูบาร์",
        menubar_style_desktop: "เดสก์ท็อป",
        menubar_style_system: "ระบบ",
        menubar_style_window: "หน้าต่าง",
        modified: 'แก้ไขเเมื่อ',
        move: "ย้าย",
        moving_file: "กำลังย้าย %%",
        my_websites: "เว็บไซต์ของฉัน",
        name: "ชื่อ",
        name_cannot_be_empty: "ไม่สามารถปล่อยช่องชื่อให้ว่างได้",
        name_cannot_contain_double_period: "ชื่อไม่สามารถมี '..' อยู่",
        name_cannot_contain_period: "ชื่อไม่สามารถมี '.' อยู่",
        name_cannot_contain_slash: "ชื่อไม่สามารถมี '/' อยู่",
        name_must_be_string: "ชื่อต้องเป็นข้อความ",
        name_too_long: `ชื่อต้องมีความยาวไม่เกิน %% ตัวอักษร`,
        new: "ใหม่",
        new_email: 'อีเมล์ใหม่',
        new_folder: "สร้างโฟลเดอร์",
        new_password: "รหัสผ่านใหม่",
        new_username: "ชื่อผู้ใช้ใหม่",
        no: "ไม่",
        no_dir_associated_with_site: "ไม่มีไดเรกทอรีเชื่อมโยงกับที่อยู่นี้",
        no_websites_published: "คุณยังไม่ได้เผยแพร่เว็บไซต์ใด ๆ",
        ok: "ตกลง",
        open: "เปิด",
        open_in_new_tab: "เปิดในแท็บใหม่",
        open_in_new_window: "เปิดในหน้าต่างใหม่",
        open_with: "เปิดด้วย",
        original_name: 'ชื่อดั้งเดิม',
        original_path: 'ที่อยู่ดั้งเดิม',
        oss_code_and_content: "ซอฟแวร์โอเพนซอร์สและเนื้อหา",
        password: "รหัสผ่าน",
        password_changed: "เปลี่ยนรหัสผ่านแล้ว",
        password_recovery_rate_limit: "คุณได้ใช้ถึงข้อจำกัดแล้ว; กรุณารอสองสามนาที. เพื่อไม่ให้เกิดแบบนี้ในอนาคต, พยายามเลี่ยงการรีโหลดหลายๆครั้ง.",
        password_recovery_token_invalid: "โทเค็นกู้รหัสผ่านหมดอายุ",
        password_recovery_unknown_error: "พบปัญหาที่ไม่ทราบสาเหตุ กรุณาลองใหม่ภายหลัง",
        password_required: 'ต้องกรอกรหัสผ่าน',
        password_strength_error: "รหัสผ่านต้องมีอย่างน้อยแปดตัวอักษร ประกอบไปด้วยตัวอักษรเล็ก ใหญ่ ตัวเลข และอักขระพิเศษอย่างน้อยหนึ่งตัว",
        passwords_do_not_match: "รหัสผ่านไม่ตรงกัน",
        paste: "วาง",
        paste_into_folder: "วางลงในโฟลเดอร์",
        personalization: "ปรับเฉพาะบุคคล",
        pick_name_for_website: "เลือกชื่อสำหรับเว็บไซต์ของคุณ:",
        picture: "รูปภาพ",
        pictures: 'รูปภาพ',
        plural_suffix: '',
        powered_by_puter_js: `สนับสนุนโดย {{link=docs}}Puter.js{{/link}}`,
        preparing: "กำลังเตรียม...",
        preparing_for_upload: "กำลังเตรียมสำหรับอัปโหลด...",
        print: 'พิมพ์',
        privacy: "ความเป็นส่วนตัว",
        proceed_to_login: "ดำเนินการเข้าสู่ระบบ",
        proceed_with_account_deletion: "ดำเนินการลบบัญชี",
        process_status_initializing: "กำลังเริ่มต้น",
        process_status_running: "กำลังทำงาน",
        process_type_app: 'แอฟ',
        process_type_init: 'เริ่ม',
        process_type_ui: 'UI',
        properties: "คุณสมบัติ",
        public: 'สาธารณะ',
        publish: "เผยแพร่",
        publish_as_website: "เผยแพร่เป็นเว็บไซต์",
        puter_description: `Puter is a privacy-first personal cloud to keep all your files, apps, and games in one secure place, accessible from anywhere at any time.`,
        reading_file: "กำลังอ่าน %strong%",
        recent: "ล่าสุด",
        recommended: "แนะนำ",
        recover_password: "กู้คืนรหัสผ่าน",
        refer_friends_c2a: "รับพื้นที่ 1 GB สำหรับเพื่อนทุกคนที่สร้าง และยืนยันบัญชีบน Puter เพื่อนของคุณจะได้รับพื้นที่ 1 GB เช่นกัน!",
        refer_friends_social_media_c2a: "รับพื้นที่จัดเก็บข้อมูลฟรี 1 GB บน Puter.com!",
        refresh: "รีเฟรช",
        release_address_confirmation: "คุณแน่ใจหรือไม่ว่าต้องการยกเลิกที่อยู่นี้?",
        remove_from_taskbar: "นำออกจากทาสก์บาร์",
        rename: "เปลี่ยนชื่อ",
        repeat: "ทำซ้ำ",
        replace: "แทนที่",
        replace_all: "แทนที่ทั้งหมด",
        resend_confirmation_code: "ส่งรหัสยืนยันอีกครั้ง",
        reset_colors: "ล้างค่าสี",
        restart_puter_confirm: "คุณแน่ใจว่าจะรีสตาร์ท Puter?",
        restore: "คืนค่า",
        saturation: 'ความอิ่มตัว',
        save_account: "บันทึกบัญชี",
        save_account_to_get_copy_link: "กรุณาสร้างบัญชีเพื่อดำเนินการต่อ",
        save_account_to_publish: "กรุณาสร้างบัญชีเพื่อดำเนินการต่อ",
        save_session: "บันทึกเซสชัน",
        save_session_c2a: "สร้างบัญชีเพื่อบันทึกเซสชันปัจจุบัน และป้องกันการสูญเสียข้อมูลการทำงานของคุณ",
        scan_qr_c2a: "สแกนด้านล่างเพื่อเข้าสู่เซสชันนี้จากอุปกรณ์อื่น ๆ",
        scan_qr_2fa: 'แสกนคิวอาร์โค้ดด้วย authenticator แอฟ',
        scan_qr_generic: 'แสกนคิวอาร์โค้ดด้วยโทรศัพท์หรืออุปกรณ์อื่น',
        search: 'ค้นหา',
        seconds: 'วินาที',
        security: "ความปลอดภัย",
        select: "เลือก",
        selected: "ที่เลือก",
        select_color: "เลือกสี...",
        sessions: "เซสชั่น",
        send: "ส่ง",
        send_password_recovery_email: "ส่งอีเมลกู้คืนรหัสผ่าน",
        session_saved: "ขอบคุณสำหรับการสร้างบัญชี เซสชันนี้ได้รับการบันทึกแล้ว",
        settings: "Settings",
        set_new_password: "ตั้งรหัสผ่านใหม่",
        share: "แชร์",
        share_to: "แชร์ไปยัง",
        share_with: "แชร์ไปให้:",
        shortcut_to: "ทางลัดไป",
        show_all_windows: "แสดงหน้าต่างทั้งหมด",
        show_hidden: "แสดงที่ซ่อนไว้",
        sign_in_with_puter: "ลงชื่อเข้าใช้ด้วย Puter",
        sign_up: "สมัครสมาชิก",
        signing_in: "กำลังเข้าสู่ระบบ...",
        size: "ขนาด",
        skip: "ข้าม",
        something_went_wrong: "บางสิ่งผิดพลาด",
        sort_by: "จัดเรียงตาม",
        start: "เริ่มต้น",
        status: "สถานะ",
        storage_usage: "การใช้งานพื้นที่",
        storage_puter_used: 'ถูกใช้โดย Puter',
        taking_longer_than_usual: "ใช้เวลานานกว่าปกติเล็กน้อย กรุณารอสักครู่...",
        task_manager: "ทาส์กแมแนเจอร์",
        taskmgr_header_name: "ชื่อ",
        taskmgr_header_status: "สถานะ",
        taskmgr_header_type: "ประเภท",
        terms: "เงื่อนไข",
        text_document: "เอกสารข้อความ",
        tos_fineprint: `การคลิก 'สร้างบัญชีฟรี' หมายความว่าคุณยอมรับ {{link=terms}}ข้อกำหนดการให้บริการ{{/link}} และ {{link=privacy}}นโยบายความเป็นส่วนตัว{{/link}}.`,
        transparency: "ความโปร่งใส",
        trash: "ถังขยะ",
        two_factor: 'ยืนยันตัวตนสองขั้นตอน',
        two_factor_disabled: 'ปิดการใช้งาน 2FA',
        two_factor_enabled: 'เปิดการใช้งาน 2FA',
        type: "ประเภท",
        type_confirm_to_delete_account: "พิมพ์ 'confirm' เพื่อลบบัญชี",
        ui_colors: "สีของ UI",
        ui_manage_sessions: "ตัวจัดการเซสชั่น",
        ui_revoke: "เพิกถอน",
        undo: "เลิกทำ",
        unlimited: 'ไม่จำกัด',
        unzip: "คลายการบีบอัด",
        upload: "อัปโหลด",
        upload_here: "อัปโหลดที่นี่",
        usage: 'การใช้งาน',
        username: "ชื่อผู้ใช้",
        username_changed: "อัปเดตชื่อผู้ใช้สำเร็จแล้ว",
        username_required: 'ต้องกรอกชื่อผู้ใช้',
        versions: "รุ่น",
        videos: 'วีดีโอ',
        visibility: 'การมองเห็น',
        yes: "ใช่",
        yes_release_it: "ใช่, เผยแพร่มัน",
        you_have_been_referred_to_puter_by_a_friend: "เพื่อนของคุณได้แนะนำ Puter ให้คุณ!",
        zip: "บีบอัด",
        zipping_file: "กำลังบีบอัด %strong%",

         // === 2FA Setup ===
        setup2fa_1_step_heading: 'เปิด authenticator แอฟ',      
        setup2fa_1_instructions: `
            คุณสามารถใช้ authenticator แอฟ ที่รองรับ Time-based One-Time Password (TOTP)
            มีหลายๆแอฟให้เลือกใช้งาน, แต่ถ้าคุณไม่แน่ใจ
            <a target="_blank" href="https://authy.com/download">Authy</a>
            เป็นตัวเลือกที่ดีสำหรับ Android and iOS.
        `,
        setup2fa_2_step_heading: 'แสกนคิวอาร์โค้ด',
        setup2fa_3_step_heading: 'กรอกตัวเลข6หลัก',
        setup2fa_4_step_heading: 'คัดลอกรหัสกู้คืน',
        setup2fa_4_instructions: `
            รหัสกู้คืนเหล่านี้เป็นวิธีเดียวที่จะเข้าถึงบัญชีคุณกรณีไม่มีโทรศัพท์หรือเข้าถึง authenticator แอฟ
            แน่ใจว่าเก็บไว้ในที่ปลอดภัย
        `,
        setup2fa_5_step_heading: 'ยืนยันการตั้งค่า2FA',
        setup2fa_5_confirmation_1: 'ฉันได้เก็บรหัสกู้คืนไว้ในที่ปลอดภัย',
        setup2fa_5_confirmation_2: 'ฉันพร้อมที่จะเปิดการใช้งาน 2FA',
        setup2fa_5_button: 'เปิดการใช้งาน 2FA',

        // === 2FA Login ===
        login2fa_otp_title: 'กรอกรหัส 2FA',
        login2fa_otp_instructions: 'กรอกรหัสตัวเลข6หลักของ authenticator แอฟ',
        login2fa_recovery_title: 'กรอกรหัสกู้คืน',
        login2fa_recovery_instructions: 'กรอกรหัสกู้คืนอันใดอันหนึ่งเพื่อเข้าถึงบัญชีของคุณ',
        login2fa_use_recovery_code: 'ใช้รหัสกู้คืน',
        login2fa_recovery_back: 'ย้อนกลับ',
        login2fa_recovery_placeholder: 'XXXXXXXX',


        "change": 'เปลี่ยนแปลง', // In English: "Change"
        "clock_visibility": 'การมองเห็นนาฬิกา', // In English: "Clock Visibility"
        "confirm": 'ยืนยัน', // In English: "Confirm"
        "path": 'ที่อยู่', // In English: "Path"
        "plural_suffix": 's', // In English: "s"
        "reading": 'กำลังอ่าน %strong%', // In English: "Reading %strong%"
        "writing": 'กำลังเขียน %strong%', // In English: "Writing %strong%"
        "save": 'บันทึก', // In English: "Save"
        "unzipping": 'กำลังแยก %strong%', // In English: "Unzipping %strong%"
        "sequencing": 'กำลังจัดลำดับ %strong%', // In English: "Sequencing %strong%"
        "zipping": 'กำลังบีบอัด %strong%', // In English: "Zipping %strong%"
        "Editor": 'ตัวแก้ไข', // In English: "Editor"
        "Viewer": 'ผู้ชม', // In English: "Viewer"
        "People with access": 'บุคคลที่สามารถเข้าถึงได้', // In English: "People with access"
        "Share With…": 'แบ่งปันร่วมกับ...', // In English: "Share With…"
        "Owner": 'เจ้าของ', // In English: "Owner"
        "You can't share with yourself.": 'คุณไม่สามารถแบ่งปันกับตัวเองได้', // In English: "You can't share with yourself."
        "This user already has access to this item": 'ผู้ใช้นี้สามารถเข้าถึงรายการนี้ได้แล้ว', // In English: "This user already has access to this item"

        "billing.change_payment_method": "เปลี่ยน", // In English: "Change"
        "billing.cancel": "ยกเลิก", // In English: "Cancel"
        "billing.download_invoice": "ดาวน์โหลด", // In English: "Download"
        "billing.payment_method": "วิธีการชำระเงิน", // In English: "Payment Method"
        "billing.payment_method_updated": "เปลี่ยนแปลงวิธีการชำระเงินสำเร็จ", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "ยืนยันวิธีการชำระเงิน", // In English: "Confirm Payment Method"
        "billing.payment_history": "ประวัติการชำระเงิน", // In English: "Payment History"
        "billing.refunded": "คืนเงินสำเร็จ", // In English: "Refunded"
        "billing.paid": "จ่ายแล้ว", // In English: "Paid"
        "billing.ok": "ตกลง", // In English: "OK"
        "billing.resume_subscription": "ต่ออายุสมาชิก", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "สมาชิกของคุณถูกยกเลิกแล้ว", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "คุณยังเป็นสมาชิกอยู่จนถึงวันสิ้นสุดรอบบิลนี้", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "ฟรี", // In English: "Free"
        "billing.offering.pro": "มืออาชีพ", // In English: "Professional"
        "billing.offering.business": "ธุรกิจ", // In English: "Business"
        "billing.cloud_storage": "จัดเก็บบนคลาวด์", // In English: "Cloud Storage"
        "billing.ai_access": "การเข้าถึงโดย AI", // In English: "AI Access"
        "billing.bandwidth": "แบนด์วิดท์", // In English: "Bandwidth"
        "billing.apps_and_games": "แอป และ เกมส์", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "เพิ่ม %strong%", // In English: "Upgrade to %strong%"
        "billing.switch_to": "เปลี่ยนเป็น %strong%", // In English: "Switch to %strong%"
        "billing.payment_setup": "ตั้งค่าการชำระเงิน", // In English: "Payment Setup"
        "billing.back": "ย้อนกลับ", // In English: "Back"
        "billing.you_are_now_subscribed_to": "คุณได้สมัครเป็นระดับ %strong แล้ว", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "คุณเป็นสมาชิกใหม่แล้ว", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "คุณแน่ใจที่จะยกเลิกการเป็นสมาชิกหรือไม่?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "การตั้งค่าการเป็นสมาชิก", // In English: "Subscription Setup"
        "billing.cancel_it": "ยกเลิก", // In English: "Cancel It"
        "billing.keep_it": "เก็บไว้", // In English: "Keep It"
        "billing.subscription_resumed": "คุณได้กลับคืนสู่การเป็นสมาชิกระดับ %strong%", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "อัพเกรดตอนนี้", // In English: "Upgrade Now"
        "billing.upgrade": "อัพเกรด", // In English: "Upgrade"
        "billing.currently_on_free_plan": "คุณเป็นสมาชิกระดับฟรีในตอนนี้", // In English: "You are currently on the free plan."
        "billing.download_receipt": "ดาวน์โหลดใบเสร็จ", // In English: "Download Receipt"
        "billing.subscription_check_error": "มีปัญหาในการตรวจสอบสถานะสมาชิกของคุณ", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "อีเมล์ของคุณยังไม่ได้รับการยืนยัน เราจะส่งโค้ดไปทางอีเมล์ของคุณเพื่อทำการยืนยันตอนนี้", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "สมาชิกของคุณได้ถูกยกเลิกแล้วและจะถูกเปลี่ยนเป็นระดับฟรีหลังจากสิ้นสุดรอบบิลนี้ จะไม่มีการเรียกเก็บค่าใช้จ่ายหลังจากนี้ ยกเว้นกรณีสมัครสมาชิกใหม่", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "ระดับสมาชิกของคุณจนกว่าจะสิ้นสุดรอบบิลนี้", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "ระดับสมาชิกปัจจุบัน", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "สมาชิกที่ถูกยกเลิกไปแล้ว (%%)", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "จัดการ", // In English: "Manage"
        "billing.limited": "จำกัด", // In English: "Limited"
        "billing.expanded": "ขยาย", // In English: "Expanded"
        "billing.accelerated": "เร่ง", // In English: "Accelerated"
        "billing.enjoy_msg": "ขอให้สนุกกับพื้นที่จัดเก็บบนคลาด์ที่เพิ่มขึ้น %% ของคุณ", // In English: "Enjoy "" of Cloud Storage plus other benefits."
    }
};

export default th;
