/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const ta = {
    name: "ஆங்கிலம்",
    english_name: "Tamil",
    code: "ta",
    dictionary: {
        about: "பற்றி",
        account: "கணக்கு",
        account_password: "கணக்கு கடவுச்சொல்லை சரிபார்க்கவும்",
        access_granted_to: "அனுமதி வழங்கப்பட்ட",
        add_existing_account: "ஏற்கனவே உள்ள கணக்கைச் சேர்க்கவும்",
        all_fields_required: 'அனைத்து புலங்களும் தேவை.',
        allow: 'அனுமதி',
        apply: "விண்ணப்பிக்கவும்",
        ascending: 'ஏறுமுகம்',
        associated_websites: "தொடர்புடைய இணையதளங்கள்",
        auto_arrange: 'ஆட்டோ ஏற்பாடு',
        background: "பின்னணி",
        browse: "உலாவவும்",
        cancel: 'ரத்து செய்',
        center: 'மையம்',
        change_desktop_background: 'டெஸ்க்டாப் பின்னணியை மாற்றவும்…',
        change_email: "மின்னஞ்சலை மாற்றவும்",
        change_language: "மொழியை மாற்றவும்",
        change_password: "கடவுச்சொல்லை மாற்றவும்",
        change_ui_colors: "யுஐ நிறங்களை மாற்றவும்",
        change_username: "பயனர் பெயரை மாற்றவும்",
        close: 'மூடு',
        close_all_windows: "அனைத்து விண்டோஸ் மூடு",
        close_all_windows_confirm: "எல்லா சாளரங்களையும் நிச்சயமாக மூட விரும்புகிறீர்களா?",
        close_all_windows_and_log_out: 'விண்டோஸை மூடிவிட்டு வெளியேறவும்',
        change_always_open_with: "இந்த வகையான கோப்பை எப்போதும் திறக்க விரும்புகிறீர்களா?",
        color: 'நிறம்',
        confirm_2fa_setup: 'எனது அங்கீகரிப்பு பயன்பாட்டில் குறியீட்டைச் சேர்த்துள்ளேன்',
        confirm_2fa_recovery: 'எனது மீட்புக் குறியீடுகளை பாதுகாப்பான இடத்தில் சேமித்துள்ளேன்',
        confirm_account_for_free_referral_storage_c2a: '1 ஜிபி இலவச சேமிப்பிடத்தைப் பெற, கணக்கை உருவாக்கி உங்கள் மின்னஞ்சல் முகவரியை உறுதிப்படுத்தவும். உங்கள் நண்பருக்கு 1 ஜிபி இலவச சேமிப்பகமும் கிடைக்கும்.',
        confirm_code_generic_incorrect: "தவறான குறியீடு.",
        confirm_code_generic_too_many_requests: "பல கோரிக்கைகள். தயவுசெய்து சில நிமிடங்கள் காத்திருக்கவும்.",
        confirm_code_generic_submit: "குறியீட்டை சமர்ப்பிக்கவும்",
        confirm_code_generic_try_again: "மீண்டும் முயற்சி செய்யவும்",
        confirm_code_generic_title: "உறுதிப்படுத்தல் குறியீட்டை உள்ளிடவும்",
        confirm_code_2fa_instruction: "உங்கள் அங்கீகரிப்பு பயன்பாட்டிலிருந்து 6 இலக்கக் குறியீட்டை உள்ளிடவும்.",
        confirm_code_2fa_submit_btn: "சமர்ப்பிக்கவும்",
        confirm_code_2fa_title: "2FA குறியீட்டை உள்ளிடவும்",
        confirm_delete_multiple_items: 'இந்த உருப்படிகளை நிரந்தரமாக நீக்க விரும்புகிறீர்களா?',
        confirm_delete_single_item: 'இந்த உருப்படியை நிரந்தரமாக நீக்க வேண்டுமா?',
        confirm_open_apps_log_out: 'உங்களிடம் திறந்த பயன்பாடுகள் உள்ளன. நிச்சயமாக வெளியேற விரும்புகிறீர்களா?',
        confirm_new_password: "புதிய கடவு சொல்லை உறுதி செய்யவும்",
        confirm_delete_user: "உங்கள் கணக்கை நிச்சயமாக நீக்க விரும்புகிறீர்களா? உங்கள் எல்லா கோப்புகளும் தரவுகளும் நிரந்தரமாக நீக்கப்படும். இந்தச் செயலைச் செயல்தவிர்க்க முடியாது.",
        confirm_delete_user_title: "கணக்கை நீக்குக?",
        confirm_session_revoke: "இந்த அமர்வை நிச்சயமாக திரும்பப் பெற விரும்புகிறீர்களா?",
        confirm_your_email_address: "உங்கள் மின்னஞ்சல் முகவரியை உறுதிப்படுத்தவும்",
        contact_us: "எங்களை தொடர்பு கொள்ள",
        contact_us_verification_required: "இதைப் பயன்படுத்த, சரிபார்க்கப்பட்ட மின்னஞ்சல் முகவரி உங்களிடம் இருக்க வேண்டும்.",
        contain: 'கொண்டிருக்கும்',
        continue: "தொடரவும்",
        copy: 'நகலெடுக்கவும்',
        copy_link: "இணைப்பை நகலெடுக்கவும்",
        copying: "நகலெடுக்கிறது",
        copying_file: "நகலெடுக்கிறது %%",
        cover: 'கவர்',
        create_account: "உங்கள் கணக்கை துவங்குங்கள்",
        create_free_account: "இலவச கணக்கை உருவாக்கவும்",
        create_shortcut: "குறுக்குவழியை உருவாக்க",
        credits: "கடன்கள்",
        current_password: "தற்போதைய கடவுச்சொல்",
        cut: 'வெட்டு',
        clock: "கடிகாரம்",
        clock_visible_hide: 'மறை - எப்போதும் மறைந்திருக்கும்',
        clock_visible_show: 'காட்டு - எப்போதும் தெரியும்',
        clock_visible_auto: 'தானியங்கு - இயல்புநிலை, முழுத்திரை பயன்முறையில் மட்டுமே தெரியும்.',
        close_all: 'அனைத்தையும் மூடு',
        created: 'உருவாக்கப்பட்டது',
        date_modified: 'தேதி மாற்றப்பட்டது',
        default: 'இயல்புநிலை',
        delete: 'அழி',
        delete_account: "கணக்கை நீக்குக",
        delete_permanently: "நிரந்தரமாக நீக்குக",
        deleting_file: "நீக்குகிறது %%",
        deploy_as_app: 'பயன்பாடாக வரிசைப்படுத்து',
        descending: 'இறங்குதல்',
        desktop: 'டெஸ்க்டாப்',
        desktop_background_fit: "பொருத்தம்",
        developers: "டெவலப்பர்கள்",
        dir_published_as_website: `%strong% வெளியிடப்பட்டது:`,
        disable_2fa: '2FA ஐ முடக்கு',
        disable_2fa_confirm: "2FA ஐ நிச்சயமாக முடக்க விரும்புகிறீர்களா?",
        disable_2fa_instructions: "2FA ஐ முடக்க உங்கள் கடவுச்சொல்லை உள்ளிடவும்.",
        disassociate_dir: "டிஸ்ஸோசியேட் டைரக்டரி",
        documents: 'ஆவணங்கள்',
        dont_allow: 'அனுமதிக்காதே',
        download: 'பதிவிறக்கவும்',
        download_file: 'பதிவிறக்க கோப்பு',
        downloading: "பதிவிறக்குகிறது",
        email: "மின்னஞ்சல்",
        email_change_confirmation_sent: "உங்கள் புதிய மின்னஞ்சல் முகவரிக்கு உறுதிப்படுத்தல் மின்னஞ்சல் அனுப்பப்பட்டுள்ளது. செயல்முறையை முடிக்க உங்கள் இன்பாக்ஸைச் சரிபார்த்து, வழிமுறைகளைப் பின்பற்றவும்.",
        email_invalid: 'மின்னஞ்சல் தவறானது.',
        email_or_username: "மின்னஞ்சல் அல்லது பயனர் பெயர்",
        email_required: 'மின்னஞ்சல் தேவை.',
        empty_trash: 'வெற்று குப்பை',
        empty_trash_confirmation: `குப்பையில் உள்ள உருப்படிகளை நிரந்தரமாக நீக்க விரும்புகிறீர்களா?`,
        emptying_trash: 'குப்பையைக் காலியாக்குகிறது…',
        enable_2fa: '2FA ஐ இயக்கவும்',
        end_hard: "கடினமாக முடிக்கவும்",
        end_process_force_confirm: "இந்தச் செயல்முறையை கட்டாயப்படுத்தி வெளியேற விரும்புகிறீர்களா?",
        end_soft: "மென்மையான முடிக்கவும்",
        enlarged_qr_code: "விரிவாக்கப்பட்ட QR குறியீடு",
        enter_password_to_confirm_delete_user: "கணக்கு நீக்குதலை உறுதிப்படுத்த உங்கள் கடவுச்சொல்லை உள்ளிடவும்",
        error_message_is_missing: "பிழை செய்தி காணவில்லை.",
        error_unknown_cause: "அறியப்படாத பிழை ஏற்பட்டது.",
        error_uploading_files: "கோப்புகளைப் பதிவேற்றுவதில் தோல்வி",
        favorites: "பிடித்தவை",
        feedback: "பின்னூட்டம்",
        feedback_c2a: "உங்கள் கருத்து, கருத்துகள் மற்றும் பிழை அறிக்கைகளை எங்களுக்கு அனுப்ப கீழே உள்ள படிவத்தைப் பயன்படுத்தவும்.",
        feedback_sent_confirmation: "எங்களை தொடர்பு கொண்டதற்கு நன்றி. உங்கள் கணக்குடன் தொடர்புடைய மின்னஞ்சலை நீங்கள் வைத்திருந்தால், கூடிய விரைவில் எங்களிடமிருந்து பதிலளிப்பீர்கள்.",
        fit: "பொருத்தம்",
        folder: 'கோப்புறை',
        force_quit: 'கட்டாயம் வெளியேறு',
        forgot_pass_c2a: "கடவுச்சொல்லை மறந்துவிட்டீர்களா?",
        from: "இருந்து",
        general: "பொது",
        get_a_copy_of_on_puter: `Puter.com இல் '%%' நகலைப் பெறுங்கள்!`,
        get_copy_link: 'நகல் இணைப்பைப் பெறவும்',
        hide_all_windows: "அனைத்து விண்டோஸையும் மறைக்கவும்",
        home: 'வீடு',
        html_document: 'HTML ஆவணம்',
        hue: 'சாயல்',
        image: 'படம்',
        incorrect_password: "தவறான கடவுச்சொல்",
        invite_link: "அழைப்பு இணைப்பு",
        item: 'பொருள்',
        items_in_trash_cannot_be_renamed: `இந்த உருப்படி குப்பையில் இருப்பதால் மறுபெயரிட முடியாது. இந்த உருப்படியை மறுபெயரிட, முதலில் அதை குப்பையிலிருந்து வெளியே இழுக்கவும்.`,
        jpeg_image: 'JPEG படம்',
        keep_in_taskbar: 'பணிப்பட்டியில் வைக்கவும்',
        language: "மொழி",
        license: "உரிமம்",
        lightness: 'லேசான தன்மை',
        link_copied: "இணைப்பு நகலெடுக்கப்பட்டது",
        loading: 'ஏற்றுகிறது',
        log_in: "உள்நுழைய",
        log_into_another_account_anyway: 'எப்படியும் மற்றொரு கணக்கில் உள்நுழைக',
        log_out: 'வெளியேறு',
        looks_good: "நன்றாக இருக்கிறது!",
        manage_sessions: "அமர்வுகளை நிர்வகிக்கவும்",
        menubar_style: "மெனுபார் உடை",
        menubar_style_desktop: "டெஸ்க்டாப்",
        menubar_style_system: "அமைப்பு",
        menubar_style_window: "ஜன்னல்",
        modified: 'மாற்றியமைக்கப்பட்டது',
        move: 'நகர்வு',
        moving_file: "நகரும் %%",
        my_websites: "எனது இணையதளங்கள்",
        name: 'பெயர்',
        name_cannot_be_empty: 'பெயர் காலியாக இருக்கக்கூடாது.',
        name_cannot_contain_double_period: "பெயர் '..' எழுத்தாக இருக்க முடியாது.",
        name_cannot_contain_period: "பெயர் '.' எழுத்தாக இருக்க முடியாது.",
        name_cannot_contain_slash: "பெயரில் '/' எழுத்து இருக்கக்கூடாது.",
        name_must_be_string: "பெயர் ஒரு சரமாக மட்டுமே இருக்க முடியும்.",
        name_too_long: `பெயர் %% எழுத்துகளுக்கு மேல் இருக்கக்கூடாது.`,
        new: 'புதியது',
        new_email: 'புதிய மின்னஞ்சல்',
        new_folder: 'புதிய அடைவை',
        new_password: "புதிய கடவுச்சொல்",
        new_username: "புதிய பயனர் பெயர்",
        no: 'இல்லை',
        no_dir_associated_with_site: 'இந்த முகவரியுடன் எந்த கோப்பகமும் இணைக்கப்படவில்லை.',
        no_websites_published: "நீங்கள் இதுவரை எந்த இணையதளத்தையும் வெளியிடவில்லை.",
        ok: 'சரி',
        open: "திற",
        open_in_new_tab: "புதிய தாவலில் திறக்கவும்",
        open_in_new_window: "Open in New Window",
        open_with: "உடன் திற",
        original_name: 'அசல் பெயர்',
        original_path: 'அசல் பாதை',
        oss_code_and_content: "திறந்த மூல மென்பொருள் மற்றும் உள்ளடக்கம்",
        password: "கடவுச்சொல்",
        password_changed: "கடவுச்சொல் மாற்றப்பட்டது.",
        password_recovery_rate_limit: "எங்கள் கட்டண வரம்பை அடைந்துவிட்டீர்கள்; தயவுசெய்து சில நிமிடங்கள் காத்திருக்கவும். எதிர்காலத்தில் இதைத் தடுக்க, பக்கத்தை பல முறை மீண்டும் ஏற்றுவதைத் தவிர்க்கவும்.",
        password_recovery_token_invalid: "இந்த கடவுச்சொல் மீட்பு டோக்கன் இனி செல்லுபடியாகாது.",
        password_recovery_unknown_error: "அறியப்படாத பிழை ஏற்பட்டது. பிறகு முயற்சிக்கவும்.",
        password_required: 'கடவுச்சொல் தேவை.',
        password_strength_error: "கடவுச்சொல் குறைந்தபட்சம் 8 எழுத்துக்கள் நீளமாக இருக்க வேண்டும் மற்றும் குறைந்தபட்சம் ஒரு பெரிய எழுத்து, ஒரு சிறிய எழுத்து, ஒரு எண் மற்றும் ஒரு சிறப்பு எழுத்து ஆகியவற்றைக் கொண்டிருக்க வேண்டும்.",
        passwords_do_not_match: '`புதிய கடவுச்சொல்` மற்றும் `புதிய கடவுச்சொல்லை உறுதிப்படுத்து` ஆகியவை பொருந்தவில்லை.',
        paste: 'ஒட்டவும்',
        paste_into_folder: "கோப்புறையில் ஒட்டவும்",
        path: 'பாதை',
        personalization: "தனிப்பயனாக்கம்",
        pick_name_for_website: "உங்கள் வலைத்தளத்திற்கு ஒரு பெயரைத் தேர்ந்தெடுக்கவும்:",
        picture: "படம்",
        pictures: 'படங்கள்',
        plural_suffix: 'கள்',
        powered_by_puter_js: `மூலம் இயக்கப்படுகிறது {{link=docs}}Puter.js{{/link}}`,
        preparing: "தயாராகிறது...",
        preparing_for_upload: "பதிவேற்றம் செய்ய தயாராகிறது...",
        print: 'அச்சிடுக',
        privacy: "தனியுரிமை",
        proceed_to_login: 'உள்நுழைய தொடரவும்',
        proceed_with_account_deletion: "கணக்கு நீக்குதலைத் தொடரவும்",
        process_status_initializing: "துவக்குதல்",
        process_status_running: "ஓடுதல்",
        process_type_app: 'செயலி',
        process_type_init: 'Init',
        process_type_ui: 'யுஐ',
        properties: "பண்புகள்",
        public: 'பொது',
        publish: "வெளியிடு",
        publish_as_website: 'இணையதளமாக வெளியிடவும்',
        puter_description: `உங்கள் கோப்புகள், பயன்பாடுகள் மற்றும் கேம்கள் அனைத்தையும் ஒரே பாதுகாப்பான இடத்தில் வைத்திருக்க, எந்த நேரத்திலும் எங்கிருந்தும் அணுகக்கூடிய தனியுரிமை-முதல் தனிப்பட்ட கிளவுட் புட்டர் ஆகும்.`,
        reading_file: "படித்தல் %strong%",
        recent: "அண்மையில்",
        recommended: "பரிந்துரைக்கப்படுகிறது",
        recover_password: "கடவுச்சொல்லை மீட்டெடுக்கவும்",
        refer_friends_c2a: "புட்டர் இல் கணக்கை உருவாக்கி உறுதிப்படுத்தும் ஒவ்வொரு நண்பருக்கும் 1 GB கிடைக்கும். உங்கள் நண்பருக்கும் 1 ஜிபி கிடைக்கும்!",
        refer_friends_social_media_c2a: `Puter.com இல் 1 GB இலவச சேமிப்பிடத்தைப் பெறுங்கள்!`,
        refresh: 'புதுப்பிப்பு',
        release_address_confirmation: `இந்த முகவரியை நிச்சயமாக வெளியிட விரும்புகிறீர்களா?`,
        remove_from_taskbar: 'பணிப்பட்டியில் இருந்து அகற்று',
        rename: 'மறுபெயரிடவும்',
        repeat: 'மீண்டும் செய்யவும்',
        replace: 'மாற்றவும்',
        replace_all: 'அனைத்தையும் மாற்றவும்',
        resend_confirmation_code: "உறுதிப்படுத்தல் குறியீட்டை மீண்டும் அனுப்பவும்",
        reset_colors: "வண்ணங்களை மீட்டமைக்கவும்",
        restart_puter_confirm: "நிச்சயமாக புட்டர்-ஐ மீண்டும் தொடங்க விரும்புகிறீர்களா?",
        restore: "மீட்டமை",
        save: 'சேமிக்கவும்',
        saturation: 'செறிவூட்டல்',
        save_account: 'கணக்கைச் சேமிக்கவும்',
        save_account_to_get_copy_link: "தொடர ஒரு கணக்கை உருவாக்கவும்.",
        save_account_to_publish: 'தொடர ஒரு கணக்கை உருவாக்கவும்.',
        save_session: 'அமர்வை சேமிக்கவும்',
        save_session_c2a: 'உங்கள் தற்போதைய அமர்வைச் சேமிக்க ஒரு கணக்கை உருவாக்கவும் மற்றும் உங்கள் வேலையை இழப்பதைத் தவிர்க்கவும்.',
        scan_qr_c2a: 'பிற சாதனங்களிலிருந்து இந்த அமர்வில் உள்நுழைய, \nகீழே உள்ள குறியீட்டை ஸ்கேன் செய்யவும்',
        scan_qr_2fa: 'உங்கள் அங்கீகரிப்பு பயன்பாட்டின் மூலம் QR குறியீட்டை ஸ்கேன் செய்யவும்',
        scan_qr_generic: 'உங்கள் தொலைபேசி அல்லது மற்றொரு சாதனத்தைப் பயன்படுத்தி இந்த QR குறியீட்டை ஸ்கேன் செய்யவும்',
        search: 'தேடு',
        seconds: 'வினாடிகள்',
        security: "பாதுகாப்பு",
        select: "தேர்ந்தெடு",
        selected: 'தேர்ந்தெடுக்கப்பட்டது',
        select_color: 'வண்ணத்தைத் தேர்ந்தெடுக்கவும்…',
        sessions: "அமர்வுகள்",
        send: "அனுப்பு",
        send_password_recovery_email: "கடவுச்சொல் மீட்பு மின்னஞ்சலை அனுப்பவும்",
        session_saved: "கணக்கை உருவாக்கியதற்கு நன்றி. இந்த அமர்வு சேமிக்கப்பட்டது.",
        settings: "அமைப்புகள்",
        set_new_password: "புதிய கடவுச்சொல்லை அமை",
        share: "பகிர்",
        share_to: "பகிரவும்",
        share_with: "இவர்களுடன் பகிரவும்:",
        shortcut_to: "குறுக்குவழி",
        show_all_windows: "அனைத்து விண்டோஸையும் காட்டு",
        show_hidden: 'மறைக்கப்பட்டதைக் காட்டு',
        sign_in_with_puter: "புட்டர் மூலம் உள்நுழையவும்",
        sign_up: "பதிவு செய்யவும்",
        signing_in: "உள்நுழைகிறேன்…",
        size: 'அளவு',
        skip: 'தவிர்க்கவும்',
        something_went_wrong: "ஏதோ தவறு நடந்துவிட்டது.",
        sort_by: 'வரிசைப்படுத்து',
        start: 'தொடங்கு',
        status: "நிலை",
        storage_usage: "சேமிப்பக பயன்பாடு",
        storage_puter_used: 'புட்டரால் பயன்படுத்தப்பட்டது',
        taking_longer_than_usual: 'வழக்கத்தை விட சிறிது நேரம் எடுக்கும். தயவுசெய்து காத்திருங்கள்...',
        task_manager: "பணி மேலாளர்",
        taskmgr_header_name: "பெயர்",
        taskmgr_header_status: "நிலை",
        taskmgr_header_type: "வகை",
        terms: "விதிமுறை",
        text_document: 'உரை ஆவணம்',
        tos_fineprint: `'இலவச கணக்கை உருவாக்கு' என்பதைக் கிளிக் செய்வதன் மூலம், புட்டர் இன் {{link=terms}}சேவை விதிமுறைகள்{{/link}} மற்றும் {{link=privacy}}தனியுரிமைக் கொள்கையை{{/link}} ஏற்கிறீர்கள்.`,
        transparency: "வெளிப்படைத்தன்மை",
        trash: 'குப்பை',
        two_factor: 'இரண்டு காரணி அங்கீகாரம்',
        two_factor_disabled: '2FA முடக்கப்பட்டது',
        two_factor_enabled: '2FA இயக்கப்பட்டது',
        type: 'வகை',
        type_confirm_to_delete_account: "உங்கள் கணக்கை நீக்க, 'உறுதிப்படுத்து' என தட்டச்சு செய்யவும்.",
        ui_colors: "UI நிறங்கள்",
        ui_manage_sessions: "அமர்வு மேலாளர்",
        ui_revoke: "திரும்பப் பெறு",
        undo: 'செயல்தவிர்',
        unlimited: 'வரம்பற்ற',
        unzip: "அன்ஜிப்",
        upload: 'பதிவேற்றவும்',
        upload_here: 'இங்கே பதிவேற்றவும்',
        usage: 'பயன்பாடு',
        username: "பயனர் பெயர்",
        username_changed: 'பயனர்பெயர் வெற்றிகரமாக புதுப்பிக்கப்பட்டது.',
        username_required: 'பயனர் பெயர் தேவை.',
        versions: "Versions",
        videos: 'வீடியோக்கள்',
        visibility: 'தெரிவுநிலை',
        yes: 'ஆம்',
        yes_release_it: 'ஆம், வெளியிடு',
        you_have_been_referred_to_puter_by_a_friend: "நீங்கள் ஒரு நண்பரால் புட்டருக்கு பரிந்துரைக்கப்பட்டீர்கள்!",
        zip: "ஜிப்",
        zipping_file: "ஜிப்பிங் %strong%",

        // === 2FA Setup ===
        setup2fa_1_step_heading: 'உங்கள் அங்கீகரிப்பு பயன்பாட்டைத் திறக்கவும்',
        setup2fa_1_instructions: `
            Time-based One-Time Password (TOTP) நெறிமுறையை ஆதரிக்கும் எந்த அங்கீகார பயன்பாட்டையும் நீங்கள் பயன்படுத்தலாம்.
 தேர்வு செய்ய பல உள்ளன, ஆனால் நீங்கள் உறுதியாக தெரியவில்லை என்றால்
 <a target="_blank" href="https://authy.com/download">Authy</a>
 ஆண்ட்ராய்டு மற்றும் iOSக்கு ஒரு திடமான தேர்வாகும்.
        `,
        setup2fa_2_step_heading: 'QR குறியீட்டை ஸ்கேன் செய்யவும்',
        setup2fa_3_step_heading: '6 இலக்கக் குறியீட்டை உள்ளிடவும்',
        setup2fa_4_step_heading: 'உங்கள் மீட்பு குறியீடுகளை நகலெடுக்கவும்',
        setup2fa_4_instructions: `
            உங்கள் ஃபோனை இழந்தாலோ அல்லது அங்கீகரிப்பு பயன்பாட்டைப் பயன்படுத்த முடியாமலோ உங்கள் கணக்கை அணுக இந்த மீட்புக் குறியீடுகள் மட்டுமே ஒரே வழி.
அவற்றை பாதுகாப்பான இடத்தில் சேமித்து வைப்பதை உறுதி செய்யவும்.
        `,
        setup2fa_5_step_heading: '2FA அமைப்பை உறுதிப்படுத்தவும்',
        setup2fa_5_confirmation_1: 'எனது மீட்புக் குறியீடுகளை பாதுகாப்பான இடத்தில் சேமித்துள்ளேன்',
        setup2fa_5_confirmation_2: '2FA ஐ இயக்க நான் தயாராக இருக்கிறேன்',
        setup2fa_5_button: '2FA ஐ இயக்கவும்',

        // === 2FA Login ===
        login2fa_otp_title: '2FA குறியீட்டை உள்ளிடவும்',
        login2fa_otp_instructions: 'உங்கள் அங்கீகரிப்பு பயன்பாட்டிலிருந்து 6 இலக்கக் குறியீட்டை உள்ளிடவும்.',
        login2fa_recovery_title: 'மீட்புக் குறியீட்டை உள்ளிடவும்',
        login2fa_recovery_instructions: 'உங்கள் கணக்கை அணுக, உங்கள் மீட்புக் குறியீடுகளில் ஒன்றை உள்ளிடவும்.',
        login2fa_use_recovery_code: 'மீட்புக் குறியீட்டைப் பயன்படுத்தவும்',
        login2fa_recovery_back: 'மீண்டும்',
        login2fa_recovery_placeholder: 'XXXXXXXX',

        "change": "மாற்றம்", // In English: "Change"
        "clock_visibility": "கடிகாரத் தெரிவுநிலை", // In English: "Clock Visibility"
        "confirm": "உறுதி", // In English: "Confirm"
        "reading": "வாசித்தல் %strong%", // In English: "Reading %strong%"
        "writing": "எழுதுதல் %strong%", // In English: "Writing %strong%"
        "unzipping": "அவிழ்ப்பது %strong%", // In English: "Unzipping %strong%"
        "sequencing": "வரிசைப்படுத்துதல் %strong%", // In English: "Sequencing %strong%"
        "zipping": 'சுருக்குதல் %strong%', // In English: "Zipping %strong%"
        "Editor": 'பதிப்பாசிரியர்', // In English: "Editor"
        "Viewer": 'பார்வையாளர்', // In English: "Viewer"
        "People with access": 'அணுகல் உள்ளவர்கள்', // In English: "People with access"
        "Share With…": 'உடன் பகிர்ந்து கொள்..', // In English: "Share With…"
        "Owner": 'உரிமையாளர்', // In English: "Owner"
        "You can't share with yourself.": 'உங்களுடன் பகிர்ந்து கொள்ள முடியாது', // In English: "You can't share with yourself."
        "This user already has access to this item": 'இந்தப் பயனருக்கு ஏற்கனவே இந்த உருப்படிக்கான அணுகல் உள்ளது', // In English: "This user already has access to this item"

        // ----------------------------------------
        // Missing translations:
        // ----------------------------------------
        "billing.change_payment_method": "மாற்று", // In English: "Change"
        "billing.cancel": "ரத்து செய்", // In English: "Cancel"
        "billing.download_invoice": "பதிவிறக்கு", // In English: "Download"
        "billing.payment_method": "பணம் செலுத்தும் முறை", // In English: "Payment Method"
        "billing.payment_method_updated": "பணம் செலுத்தும் முறை புதுப்பிக்கப்பட்டது!", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "பணம் செலுத்தும் முறையை உறுதிப்படுத்து", // In English: "Confirm Payment Method"
        "billing.payment_history": "பணம் செலுத்திய வரலாறு", // In English: "Payment History"
        "billing.refunded": "திரும்பப் பெற்றது", // In English: "Refunded"
        "billing.paid": "செலுத்தப்பட்டது", // In English: "Paid"
        "billing.ok": "சரி", // In English: "OK"
        "billing.resume_subscription": "சப்ஸ்கிரிப்ஷன் மீண்டும் தொடங்கு", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "உங்கள் சப்ஸ்கிரிப்ஷன் ரத்து செய்யப்பட்டு விட்டது.", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "நீங்கள் இந்த பில்லிங் காலத்தின் முடிவுவரை உங்கள் சப்ஸ்கிரிப்ஷனுக்கு அணுகல் பெறுவீர்கள்.", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "இலவசம்", // In English: "Free"
        "billing.offering.pro": "தொழில்முறை", // In English: "Professional"
        "billing.offering.business": "வியாபாரம்", // In English: "Business"
        "billing.cloud_storage": "மேக சேமிப்பு", // In English: "Cloud Storage"
        "billing.ai_access": "AI அணுகல்", // In English: "AI Access"
        "billing.bandwidth": "அலைவரிசை", // In English: "Bandwidth"
        "billing.apps_and_games": "ஆப்ஸ் & கேம்ஸ்", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "%strong%க்கு மேம்படுத்தவும்", // In English: "Upgrade to %strong%"
        "billing.switch_to": "%strong% இதற்கு மாறவும்", // In English: "Switch to %strong%"
        "billing.payment_setup": "கட்டண அமைப்பு", // In English: "Payment Setup"
        "billing.back": "திரும்ப", // In English: "Back"
        "billing.you_are_now_subscribed_to": "நீங்கள் இப்போது %strong% அடுக்குக்கு குழுசேர்ந்துள்ளீர்கள்.", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "நீங்கள் இப்போது குழுசேர்ந்துள்ளீர்கள்", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "உங்கள் சந்தாவை நிச்சயமாக ரத்துசெய்ய விரும்புகிறீர்களா?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "சந்தா அமைப்பு", // In English: "Subscription Setup"
        "billing.cancel_it": "ரத்து செய்", // In English: "Cancel It"
        "billing.keep_it": "வைத்துக்கொள்", // In English: "Keep It"
        "billing.subscription_resumed": "உங்கள் %strong% சந்தா மீண்டும் தொடங்கப்பட்டது!", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "இப்போது மேம்படுத்து", // In English: "Upgrade Now"
        "billing.upgrade": "மேம்படுத்து", // In English: "Upgrade"
        "billing.currently_on_free_plan": "நீங்கள் தற்போது இலவச திட்டத்தில் உள்ளீர்கள்.", // In English: "You are currently on the free plan."
        "billing.download_receipt": "ரசீதைப் பதிவிறக்கவும்", // In English: "Download Receipt"
        "billing.subscription_check_error": "உங்கள் சந்தா நிலையைச் சரிபார்க்கும் போது சிக்கல் ஏற்பட்டது.", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "உங்கள் மின்னஞ்சல் உறுதிப்படுத்தப்படவில்லை. இப்போது அதை உறுதிப்படுத்த ஒரு குறியீட்டை அனுப்புவோம்.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "உங்கள் சந்தாவை ரத்து செய்துவிட்டீர்கள், பில்லிங் காலத்தின் முடிவில் அது தானாகவே இலவச அடுக்குக்கு மாறும். நீங்கள் மீண்டும் சந்தா செலுத்தும் வரை உங்களிடம் கட்டணம் வசூலிக்கப்படாது.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "இந்த பில்லிங் காலம் முடியும் வரை உங்களின் தற்போதைய திட்டம்.", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "தற்போதைய திட்டம்", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "ரத்துசெய்யப்பட்ட சந்தா (%%)", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "நிர்வகிக்கவும்", // In English: "Manage"
        "billing.limited": "வரையறுக்கப்பட்டவை", // In English: "Limited"
        "billing.expanded": "விரிவாக்கப்பட்டது", // In English: "Expanded"
        "billing.accelerated": "வேகப்படுத்தப்பட்டது", // In English: "Accelerated"
        "billing.enjoy_msg": "%% கிளவுட் ஸ்டோரேஜ் மற்றும் பிற பலன்களை அனுபவிக்கவும்.", // In English: "Enjoy %% of Cloud Storage plus other benefits."
    }
};

export default ta;
