/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const sv = {
    name: "Svenska",
    english_name: "Swedish",
    code: "sv",
    dictionary: {
        about: "Om",
        account: "Konto",
        account_password: "Bekräfta kontolösenord",
        access_granted_to: "Tillgång beviljad till",
        add_existing_account: "Lägg till befintligt konto",
        all_fields_required: "Alla fält är obligatoriska.",
        allow: "Tillåt",
        apply: "Tillämpa",
        ascending: "Stigande",
        associated_websites: "Anknytande webbplatser",
        auto_arrange: "Auto Arrange",
        background: "Bakgrund",
        browse: "Bläddra",
        cancel: "Avbryt",
        center: "Centrera",
        change_desktop_background: "Ändra skrivbordsbakgrund…",
        change_email: "Ändra e-postadress",
        change_language: "Ändra språk",
        change_password: "Byt lösenord",
        change_ui_colors: "Ändra gränssnittets färger",
        change_username: "Byt användarnamn",
        close: "Stäng",
        close_all_windows: "Stäng alla fönster",
        close_all_windows_confirm: "Är det säkert att du vill stänga alla fönster?",
        close_all_windows_and_log_out: "Stäng alla fönster och logga ut",
        change_always_open_with: "Vill du alltid öppna den här filtypen med",
        color: "Färg",
        confirm: "Bekräfta",
        confirm_2fa_setup: "Jag har lagt in koden i min autentiseringsapp",
        confirm_2fa_recovery: "Jag har sparat mina återställningskoder på en säker plats",
        confirm_account_for_free_referral_storage_c2a: "Skapa ett konto och bekräfta din e-postadress för att få 1 GB gratis lagringsutrymme. Din vän får också 1 GB gratis lagringsutrymme.",
        confirm_code_generic_incorrect: "Felaktig kod.",
        confirm_code_generic_too_many_requests: "För många förfrågningar. Var god vänta ett par minuter.",
        confirm_code_generic_submit: "Skicka in kod",
        confirm_code_generic_try_again: "Försök igen",
        confirm_code_generic_title: "Fyll i bekräftelsekod",
        confirm_code_2fa_instruction: "Fyll i de 6 siffrorna från din autentiseringsapp.",
        confirm_code_2fa_submit_btn: "Skicka in",
        confirm_code_2fa_title: "Fyll i 2FA-kod",
        confirm_delete_multiple_items: "Är det säkert att du vill ta bort de här objekten permanent?",
        confirm_delete_single_item: "Vill du ta bort det här objektet?",
        confirm_open_apps_log_out: "Du har öppna applikationer. Är det säkert att du vill logga ut?",
        confirm_new_password: "Bekräfta det nya lösenordet",
        confirm_delete_user: "Är det säkert att du vill radera ditt konto? Alla dina filer och data kommer att tas bort permanent. Detta steg kan inte ångras.",
        confirm_delete_user_title: "Ta bort konto?",
        confirm_session_revoke: "Är det säkert att du vill upphäva den här sessionen?",
        confirm_your_email_address: "Bekräfta din e-postadress",
        contact_us: "Kontakta oss",
        contact_us_verification_required: "Du behöver en verifierad e-postadress för att använda den här funktionen.",
        contain: "Innehåll",
        continue: "Continue",
        copy: "Kopiera",
        copy_link: "Kopiera länk",
        copying: "Kopierar",
        copying_file: "Kopierar %%",
        cover: "Täck",
        create_account: "Skapa konto",
        create_free_account: "Skapa gratis konto",
        create_shortcut: "Skapa genväg",
        credits: "Tack",
        current_password: "Nuvarande lösenord",
        cut: "Klipp ut",
        clock: "Klocka",
        clock_visible_hide: "Dölj - Alltid dold",
        clock_visible_show: "Visa - Alltid synlig",
        clock_visible_auto: "Auto - Förval, bara synlig i helskärm.",
        close_all: "Stäng alla",
        created: "Skapad",
        date_modified: "Ändringsdatum",
        default: "Förval",
        delete: "Ta bort",
        delete_account: "Ta bort kontot",
        delete_permanently: "Radera permanent",
        deleting_file: "Tar bort %%",
        deploy_as_app: "Distribuera som app",
        descending: "Fallande",
        desktop: "Skrivbord",
        desktop_background_fit: "Anpassa",
        developers: "Utvecklare",
        dir_published_as_website: "%strong% är publicerat på:",
        disable_2fa: "Stäng av 2FA",
        disable_2fa_confirm: "Är det säkert att du vill stänga av 2FA?",
        disable_2fa_instructions: "Fyll i ditt lösenord för att stänga av 2FA.",
        disassociate_dir: "Avassociera mapp",
        documents: "Dokument",
        dont_allow: "Tillåt inte",
        download: "Ladda ner",
        download_file: "Ladda ner fil",
        downloading: "Laddar ner",
        email: "E-post",
        email_change_confirmation_sent: "Ett bekräftelsemail har skickats till din nya e-postadress. Var god kontrollera inkorgen och följ instruktionerna för att fullfölja processen.",
        email_invalid: "Adressen är ogiltig.",
        email_or_username: "E-post eller användarnamn",
        email_required: "E-post krävs.",
        empty_trash: "Töm papperskorgen",
        empty_trash_confirmation: "Är du säker på att du vill permanent radera allt i papperskorgen?",
        emptying_trash: "Tömmer papperskorgen…",
        enable_2fa: 'Aktivera 2FA',
        end_hard: "Hårt slut",
        end_process_force_confirm: "Är det säkert att du vill tvinga avslut för den här processen?",
        end_soft: "Mjukt slut",
        enlarged_qr_code: "Förstorad QR-kod",
        enter_password_to_confirm_delete_user: "Fyll i ditt lösenord för att bekräfta kontots borttagning.",
        error_message_is_missing: "Felmeddelande saknas.",
        error_unknown_cause: "Ett okänt fel inträffade.",
        error_uploading_files: "Uppladdningen misslyckades",
        favorites: "Favoriter",
        feedback: "Feedback",
        feedback_c2a: "Vänligen använd formuläret nedan för att skicka oss din feedback, kommentarer och felrapporter.",
        feedback_sent_confirmation: "Tack för att du kontaktade oss. Om du har en e-post kopplad till ditt konto kommer du att höra från oss så snart som möjligt.",
        fit: "Anpassa",
        folder: "Mapp",
        force_quit: "Tvinga avslut",
        forgot_pass_c2a: "Glömt lösenord?",
        from: "Från",
        general: "Allmänt",
        get_a_copy_of_on_puter: "Få en kopia av '%%' på Puter.com!",
        get_copy_link: "Få kopieringslänk",
        hide_all_windows: "Dölj alla fönster",
        home: "Hem",
        html_document: "HTML-dokument",
        hue: "Färgton",
        image: "Bild",
        incorrect_password: "Felaktigt lösenord",
        invite_link: "Länk för inbjudan",
        item: "Objekt",
        items_in_trash_cannot_be_renamed: "Det här objektet kan inte byta namn eftersom det är i papperskorgen. För att byta namn på detta objekt, dra det först ur papperskorgen.",
        jpeg_image: "JPEG-bild",
        keep_in_taskbar: "Behåll i aktivitetsfältet",
        language: "Språk",
        license: "Licens",
        lightness: "Ljus",
        link_copied: "Länk kopierad",
        loading: "Laddar",
        log_in: "Logga in",
        log_into_another_account_anyway: "Logga ändå in till annat konto",
        log_out: "Logga ut",
        looks_good: "Ser bra ut!",
        manage_sessions: "Hantera sessioner",
        menubar_style: "Stil för menyraden",
        menubar_style_desktop: "Skrivbord",
        menubar_style_system: "System",
        menubar_style_window: "Fönster",
        modified: "Ändrad",
        move: "Flytta",
        moving_file: "Flyttar %%",
        my_websites: "Mina webbplatser",
        name: "Namn",
        name_cannot_be_empty: "Namn kan inte vara tomt.",
        name_cannot_contain_double_period: "Namn kan inte innehålla '..'.",
        name_cannot_contain_period: "Namn kan inte innehålla '.'-tecknet.",
        name_cannot_contain_slash: "Namn kan inte innehålla '/'-tecknet.",
        name_must_be_string: "Namn måste vara en sträng.",
        name_too_long: "Namn kan inte vara längre än %% tecken.",
        new: "Nytt",
        new_email: "Ny e-post",
        new_folder: "Ny mapp",
        new_password: "Nytt lösenord",
        new_username: "Nytt användarnamn",
        no: "Nej",
        no_dir_associated_with_site: "Ingen mapp är associerad med denna adress.",
        no_websites_published: "Du har ännu inte publicerat några webbplatser.",
        ok: "OK",
        open: "Öppna",
        open_in_new_tab: "Öppna i ny flik",
        open_in_new_window: "Öppna i nytt fönster",
        open_with: "Öppna med",
        original_name: "Utsprungligt namn",
        original_path: "Utsprunglig filväg",
        oss_code_and_content: "Öppen mjukvara och innehåll",
        password: "Lösenord",
        password_changed: "Lösenord ändrat.",
        password_recovery_rate_limit: "Du har uppnått vår hastighetsgräns; var god vänta ett par minuter. För att motverka detta i framtiden, undvik att ladda om sidan för många gånger.",
        password_recovery_token_invalid: "Den här återställningsnyckeln är inte giltig längre.",
        password_recovery_unknown_error: "Ett okänt fel inträffade. Var god försök igen senare.",
        password_required: "Lösenord krävs.",
        password_strength_error: "Lösenordet måste vara minst 8 tecken och innehålla minst en stor bokstav, en liten bokstav, en siffra, och ett specialtecken.",
        passwords_do_not_match: "`Nytt lösenord` och `Bekräfta nytt lösenord` stämmer inte överens.",
        paste: "Klistra in",
        paste_into_folder: "Klistra in i mapp",
        path: "Filväg",
        personalization: "Personalisering",
        pick_name_for_website: "Välj ett namn för din webbplats:",
        picture: "Bild",
        pictures: "Bilder",
        plural_suffix: "", // neutrum has "", utrum has "or", "ar", "er"
        powered_by_puter_js: "Drivs av {{link=docs}}Puter.js{{/link}}",
        preparing: "Förbereder...",
        preparing_for_upload: "Förbereder för uppladdning...",
        print: "Skriv ut",
        privacy: "Integritet",
        proceed_to_login: "Förtsätt till inloggning",
        proceed_with_account_deletion: "Försätt med kontoborttagning",
        process_status_initializing: "Processen påbörjas",
        process_status_running: "Processen körs",
        process_type_app: "App",
        process_type_init: "Init",
        process_type_ui: "UI",
        properties: "Egenskaper",
        public: "Offentligt",
        publish: "Publicera",
        publish_as_website: "Publicera som webbplats",
        puter_description: "Puter är ett integritetsvänligt personligt moln för alla dina filer, appar och spel på ett säkert ställe, tillgängligt varsomhelst och närsomhelst.",
        reading_file: "Läser in %strong%",
        recent: "Senaste",
        recommended: "Rekommenderat",
        recover_password: "Återställ lösenord",
        refer_friends_c2a: "Få 1 GB för varje vän som skapar och bekräftar ett konto på Puter. Din vän får också 1 GB.",
        refer_friends_social_media_c2a: "Få 1 GB gratis lagringsutrymme på Puter.com!",
        refresh: "Uppdatera",
        release_address_confirmation: "Är du säker på att du vill frigöra denna adress?",
        remove_from_taskbar: "Ta bort från aktivitetsfältet",
        rename: "Byt namn",
        repeat: "Upprepa",
        replace: "Ersätt",
        replace_all: "Ersätt alla",
        resend_confirmation_code: "Skicka bekräftelsekoden igen",
        reset_colors: "Nolställ färgerna",
        restart_puter_confirm: "Är det säkert att du vill starta om Puter?",
        restore: "Återställ",
        save: "Spara",
        saturation: "Mättnad",
        save_account: "Spara konto",
        save_account_to_get_copy_link: "Vänligen skapa ett konto för att fortsätta.",
        save_account_to_publish: "Vänligen skapa ett konto för att fortsätta.",
        save_session: "Spara sessionen",
        save_session_c2a: "Skapa ett konto för att spara den nuvarande sessionen och undvika att ditt arbete går förlorat.",
        scan_qr_c2a: "Skanna koden nedan för att logga in på denna session från andra enheter",
        scan_qr_2fa: "Skanna QR-koden med din autentiseringsapp",
        scan_qr_generic: "Skanna den här QR-koden med din telefon eller en annan enhet",
        search: "Sök",
        seconds: "sekunder",
        security: "Säkerhet",
        select: "Välj",
        selected: "vald",
        select_color: "Välj färg…",
        sessions: "Sessioner",
        send: "Skicka",
        send_password_recovery_email: "Skicka e-post för återställning av lösenord",
        session_saved: "Tack för att du skapade ett konto. Denna session är sparad.",
        settings: "Inställningar",
        set_new_password: "Ange nytt lösenord",
        share: "Dela",
        share_to: "Dela till",
        share_with: "Dela med:",
        shortcut_to: "Genväg till",
        show_all_windows: "Visa alla fönster",
        show_hidden: "Visa dolda",
        sign_in_with_puter: "Logga in med Puter",
        sign_up: "Skapa konto",
        signing_in: "Loggar in…",
        size: "Storlek",
        skip: "Hoppa över",
        something_went_wrong: "Någonting gick fel.",
        sort_by: "Sortera efter",
        start: "Start",
        status: "Tillstånd",
        storage_usage: "Användning av lagringsutrymme",
        storage_puter_used: "använt av Puter",
        taking_longer_than_usual: "Detta tar längre tid än vanligt. Vänligen vänta...",
        task_manager: "Aktivitetshanteraren",
        taskmgr_header_name: "Namn",
        taskmgr_header_status: "Tillstånd",
        taskmgr_header_type: "Typ",
        terms: "Villkor",
        text_document: "Textdokument",
        tos_fineprint: "Genom att klicka på 'Skapa gratis konto' godkänner du Puters {{link=terms}}användarvillkor{{/link}} och {{link=privacy}}integritetspolicy{{/link}}.",
        transparency: "Transparens",
        trash: "Papperskorg",
        two_factor: "Tvåfaktors-autentisering",
        two_factor_disabled: "2FA inaktiverad",
        two_factor_enabled: "2FA aktiverad",
        type: "Typ",
        type_confirm_to_delete_account: "Skriv 'bekräfta' för att ta bort ditt konto.",
        ui_colors: "Färger för användargränssnitt",
        ui_manage_sessions: "Sessionshanterare",
        ui_revoke: "Upphäv",
        undo: "Ångra",
        unlimited: "Obegränsat",
        unzip: "Packa upp",
        upload: "Ladda upp",
        upload_here: "Ladda upp hit",
        usage: "Används",
        username: "Användarnamn",
        username_changed: "Användarnamn uppdaterat.",
        username_required: "Användarnamn krävs.",
        versions: "Versioner",
        videos: "Videor",
        visibility: "Synlighet",
        yes: "Ja",
        yes_release_it: "Ja, frigör den",
        you_have_been_referred_to_puter_by_a_friend: "Du har blivit hänvisad till Puter av en vän!",
        zip: "Zippa",
        zipping_file: "Komprimerar %strong%",

        // === 2FA Setup ===
        setup2fa_1_step_heading: "Öppna din autentiseringsapp",
        setup2fa_1_instructions: `
            Du kan använda godtycklig autentiseringsapp som stöder Time-based One-Time Password (TOTP)-protokollet.
            Det finns många att välja bland, men om du är osäker så är
            <a target="_blank" href="https://authy.com/download">Authy</a>
            ett stabilt val för Android och iOS.
	`,
        setup2fa_2_step_heading: "Skanna QR-kod",
        setup2fa_3_step_heading: "Fyll i koden om 6 siffror",
        setup2fa_4_step_heading: "Kopiera dina återställningskoder",
        setup2fa_4_instructions: `
            De här återställningskoderna är det enda sättet att komma åt ditt konto om du skulle tappa bort din telefon eller inte kan använda din autentiseringsapp.
            Försäkra dig om att du förvarar dem på en säker plats.
        `,
        setup2fa_5_step_heading: "Bekräfta 2FA-installationen",
        setup2fa_5_confirmation_1: "Jag har sparat mina återställningskoder på en säker plats",
        setup2fa_5_confirmation_2: "Jag är redo att aktivera 2FA",
        setup2fa_5_button: "Aktivera 2FA",

        // === 2FA Login ===
        login2fa_otp_title: "Fyll i 2FA-kod",
        login2fa_otp_instructions: "Fyll i koden om 6 siffror från din autentiseringsapp.",
        login2fa_recovery_title: "Fyll i en återhämtningskod",
        login2fa_recovery_instructions: "Fyll i en av dina återhämtningskoder för att få tillgång till ditt konto.",
        login2fa_use_recovery_code: "Använd en återhämtningskod",
        login2fa_recovery_back: "Tillbaka",
        login2fa_recovery_placeholder: "XXXXXXXX",

        "change": "Ändra", // In English: "Change"
        "clock_visibility": "Klocksynlighet", // In English: "Clock Visibility"
        "plural_suffix": "", // In English: "s" (Plural suffix is context dependent in Swedish, it can be "or", "ar", "er", "en" or just no suffix)
        "reading": "Läser %strong%", // In English: "Reading %strong%"
        "writing": "Skriver %strong%", // In English: "Writing %strong%"
        "unzipping": "Packar upp %strong%", // In English: "Unzipping %strong%"
        "sequencing": "Sekvenserar %strong%", // In English: "Sequencing %strong%"
        "zipping": "Komprimerar %strong%", // In English: "Zipping %strong%"
        "Editor": "Redigerare", // In English: "Editor"
        "Viewer": "Granskare", // In English: "Viewer"
        "People with access": "Personer med åtkomst", // In English: "People with access"
        "Share With…": "Dela med…", // In English: "Share With…"
        "Owner": "Ägare", // In English: "Owner"
        "You can't share with yourself.": "Du kan inte dela med dig själv.", // In English: "You can't share with yourself."
        "This user already has access to this item":
        "Den här användaren har redan åtkomst till det här objektet", // In English: "This user already has access to this item"

        "plural_suffix": "", // In English: "s" (Plural suffix is context dependent in Swedish, it can be "or", "ar", "er", "en" or just no suffix)
        "billing.change_payment_method": "Ändra", // In English: "Change"
        "billing.cancel": "Avbryt", // In English: "Cancel"
        "billing.download_invoice": "Ladda ner", // In English: "Download"
        "billing.payment_method": "Betalningsmetod", // In English: "Payment Method"
        "billing.payment_method_updated": "Betalningsmetod uppdaterad!", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "Bekräfta Betalningsmetod", // In English: "Confirm Payment Method"
        "billing.payment_history": "Betalningshistorik", // In English: "Payment History"
        "billing.refunded": "Återbetalas", // In English: "Refunded"
        "billing.paid": "Betalt", // In English: "Paid"
        "billing.ok": "OK", // In English: "OK"
        "billing.resume_subscription": "Återuppta Prenumeration", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "Din prenumeration har avbrutits.", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "Du har fortfarande tillgång till din prenumeration fram till slutet av denna faktureringsperiod.", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "Gratis", // In English: "Free"
        "billing.offering.pro": "Professionell", // In English: "Professional"
        "billing.offering.business": "Företag", // In English: "Business"
        "billing.cloud_storage": "Molnlagring", // In English: "Cloud Storage"
        "billing.ai_access": "AI Tillgång", // In English: "AI Access"
        "billing.bandwidth": "Bandbredd", // In English: "Bandwidth"
        "billing.apps_and_games": "Appar & Spel", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "Uppgradera till %strong%", // In English: "Upgrade to %strong%"
        "billing.switch_to": "Byt till %strong%", // In English: "Switch to %strong%"
        "billing.payment_setup": "Betalningsinställningar", // In English: "Payment Setup"
        "billing.back": "Tillbaka", // In English: "Back"
        "billing.you_are_now_subscribed_to": "Du prenumererar nu på %strong% tier.", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "Du är nu prenumererad", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "Är du säker på att du vill avsluta din prenumeration?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "Prenumerationsinställningar", // In English: "Subscription Setup"
        "billing.cancel_it": "Avbryt det", // In English: "Cancel It"
        "billing.keep_it": "Behåll det", // In English: "Keep It"
        "billing.subscription_resumed": "Din %strong% prenumeration har återupptagits!", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "Uppgradera nu", // In English: "Upgrade Now"
        "billing.upgrade": "Uppgradera", // In English: "Upgrade"
        "billing.currently_on_free_plan": "Du har för närvarande den kostnadsfria planen.", // In English: "You are currently on the free plan."
        "billing.download_receipt": "Ladda ner Kvitto", // In English: "Download Receipt"
        "billing.subscription_check_error": "Ett problem uppstod när du kontrollerade din prenumerationsstatus.", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "Din e-post har inte bekräftats. Vi skickar dig en kod för att bekräfta den nu.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "Du har sagt upp din prenumeration och den byter automatiskt till gratisnivån i slutet av faktureringsperioden. Du kommer inte att debiteras igen om du inte prenumererar på nytt.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "Din nuvarande plan fram till slutet av denna faktureringsperiod.", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "Nuvarande plan", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "Avbruten Prenumeration (%%)", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "Hantera", // In English: "Manage"
        "billing.limited": "Begränsad", // In English: "Limited"
        "billing.expanded": "Utökad", // In English: "Expanded"
        "billing.accelerated": "Accelererad", // In English: "Accelerated"
        "billing.enjoy_msg": "Njut av %% av Cloud Storage plus andra förmåner.", // In English: "Enjoy %% of Cloud Storage plus other benefits."
    }
};

export default sv;
