/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const ru = {
  name: 'Русский',
  english_name: 'Russian',
  code: 'ru',
  dictionary: {
    about: 'О системе',
    account: 'Учетная запись',
    account_password: 'Подтвердите пароль',
    access_granted_to: 'Доступ предоставлен',
    add_existing_account: 'Добавить существующую Учетную запись',
    all_fields_required: 'Все поля обязательны для заполнения.',
    allow: 'Разрешить',
    apply: 'Применить',
    ascending: 'По возрастанию',
    associated_websites: 'Связанные сайты',
    auto_arrange: 'Автоупорядочивание',
    background: 'Фон',
    browse: 'Пролистать',
    cancel: 'Отмена',
    center: 'По центру',
    change_desktop_background: 'Сменить фон рабочего стола…',
    change_email: 'Изменить электронную почту',
    change_language: 'Изменить язык',
    change_password: 'Изменить пароль',
    change_ui_colors: 'Изменить тему оформления',
    change_username: 'Изменить имя пользователя',
    close: 'Закрыть',
    close_all_windows: 'Закрыть все окна',
    close_all_windows_confirm: 'Вы уверены, что хотите закрыть все окна?',
    close_all_windows_and_log_out: 'Закрыть все окна и выйти',
    change_always_open_with:
      'Хотите всегда открывать файлы этого типа с помощью',
    color: 'Цвет',
    confirm: 'Подтвердить',
    confirm_2fa_setup: 'Я добавил код в приложение для аутентификации',
    confirm_2fa_recovery:
      'Я сохранил коды восстановления доступа в безопасном месте',
    confirm_account_for_free_referral_storage_c2a:
      'Создайте учетную запись и подтвердите свой адрес электронной почты, чтобы получить 1 Гб бесплатного дискового пространства. Ваш друг также получит 1 Гб бесплатного дискового пространства.',
    confirm_code_generic_incorrect: 'Неверный код.',
    confirm_code_generic_too_many_requests:
      'Слишком много запросов. Пожалуйста, подождите несколько минут.',
    confirm_code_generic_submit: 'Отправить код',
    confirm_code_generic_try_again: 'Попробуйте снова',
    confirm_code_generic_title: 'Введите код подтверждения',
    confirm_code_2fa_instruction:
      'Введите 6-значный код из приложения для аутентификации.',
    confirm_code_2fa_submit_btn: 'Отправить',
    confirm_code_2fa_title: 'Введите код аутентификации',
    confirm_delete_multiple_items:
      'Вы уверены, что хотите навсегда удалить эти элементы?',
    confirm_delete_single_item:
      'Вы уверены, что хотите навсегда удалить этот элемент?',
    confirm_open_apps_log_out:
      'У вас имеются открытые приложения. Вы уверены, что хотите выйти из системы?',
    confirm_new_password: 'Подтвердите новый пароль',
    confirm_delete_user:
      'Вы уверены, что хотите удалить свою учетную запись? Все ваши файлы и данные будут удалены безвозвратно. Это действие нельзя отменить.',
    confirm_delete_user_title: 'Удалить учетную запись?',
    confirm_session_revoke: 'Вы уверены, что хотите отменить эту сессию?',
    contact_us: 'Связаться с нами',
    contact_us_verification_required:
      'Подтвердите адрес электронной почты чтобы продожить.',
    contain: 'Содержание',
    continue: 'Продолжить',
    copy: 'Копировать',
    copy_link: 'Скопировать ссылку',
    copying: 'Создаю копию',
    copying_file: 'Создаю копию %%',
    cover: 'Обложка',
    create_account: 'Создать учетную запись',
    create_free_account: 'Создать бесплатную учетную запись',
    create_shortcut: 'Создать ярлык',
    credits: 'Авторы',
    current_password: 'Текущий пароль',
    cut: 'Вырезать',
    clock: 'Часы',
    clock_visible_hide: 'Скрыть - Всегда скрыто',
    clock_visible_show: 'Показать - Всегда на виду',
    clock_visible_auto:
      'Авто - По Умолчанию, видно только в полноэкранном режиме.',
    close_all: 'Закрыть все',
    created: 'Создано',
    date_modified: 'Дата изменения',
    default: 'По умолчанию',
    delete: 'Удалить',
    delete_account: 'Удалить учетную запись',
    delete_permanently: 'Удалить безвозвратно',
    deleting_file: 'Удаление %%',
    deploy_as_app: 'Развернуть как приложение',
    descending: 'По убыванию',
    desktop: 'Рабочий стол',
    desktop_background_fit: 'Вместить',
    developers: 'Разработчики',
    dir_published_as_website: `%strong% опубликован в:`,
    disable_2fa: 'Отключить двойную аутентификацию',
    disable_2fa_confirm:
      'Вы уверены, что хотите отключить двойную аутентификацию?',
    disable_2fa_instructions:
      'Введите пароль чтобы отключить двойную аутентификацию.',
    disassociate_dir: 'Отключить директорию',
    documents: 'Документы',
    dont_allow: 'Доступ запрещён',
    download: 'Загрузить',
    download_file: 'Загрузить файл',
    downloading: 'Загрузка',
    email: 'Электронная почта',
    email_change_confirmation_sent:
      'На ваш новый адрес электронной почты было отправлено письмо с подтверждением. Пожалуйста, проверьте свой ящик электронной почты и следуйте инструкциям, чтобы завершить процесс.',
    email_invalid: 'Адрес электронной почты недействителен.',
    email_or_username: 'Email или Имя пользователя',
    email_required: 'Email обязателен.',
    empty_trash: 'Очистить корзину',
    empty_trash_confirmation: `Вы уверены, что хотите навсегда удалить элементы из Корзины?`,
    emptying_trash: 'Очистка Корзины…',
    enable_2fa: 'Включить двойную аутентификацию',
    end_hard: 'Принудительно закрыть',
    end_process_force_confirm:
      'Вы уверены, что хотите принудительно завершить этот процесс?',
    end_soft: 'Закрыть',
    enlarged_qr_code: 'Увеличить QR код',
    enter_password_to_confirm_delete_user:
      'Введите пароль для подтверждения удаления учетной записи',
    error_message_is_missing: 'Сообщение об ошибке отсутствует.',
    error_unknown_cause: 'Неизвестная ошибка.',
    error_uploading_files: 'Не удалось загрузить файлы',
    favorites: 'Избранное',
    feedback: 'Обратная связь',
    feedback_c2a:
      'Пожалуйста, используйте форму ниже, чтобы отправить отзыв, комментарии и сообщения об ошибках.',
    feedback_sent_confirmation:
      'Спасибо, что связались с нами. Если у вас есть электронная почта, связанная с вашим аккаунтом, мы ответим вам как можно скорее.',
    fit: 'Вместить',
    folder: 'Папка',
    force_quit: 'Принудительно закрыть',
    forgot_pass_c2a: 'Забыли пароль?',
    from: 'От',
    general: 'Общее',
    get_a_copy_of_on_puter: `Получите копию '%%' на Puter.com!`,
    get_copy_link: 'Получить ссылку для копирования',
    hide_all_windows: 'Скрыть все окна',
    home: 'Домой',
    html_document: 'HTML документ',
    hue: 'Оттенок',
    image: 'Изображение',
    incorrect_password: 'Неверный пароль',
    invite_link: 'Ссылка для приглашения',
    item: 'элемент',
    items_in_trash_cannot_be_renamed: `Этот элемент нельзя переименовать, потому что он находится в Корзине. Чтобы переименовать этот элемент, сначала перенесите его из Корзины.`,
    jpeg_image: 'JPEG изображение',
    keep_in_taskbar: 'Сохранить на Панели Задач',
    language: 'Язык',
    license: 'Лицензия',
    lightness: 'Легкость', //нужен контекст
    link_copied: 'Ссылка скопирована',
    loading: 'Загружается',
    log_in: 'Войти',
    log_into_another_account_anyway: 'Все-равно войти в другой аккаунт',
    log_out: 'Выйти',
    looks_good: 'Выглядит здорово!',
    manage_sessions: 'Управление Сеансами',
    menubar_style: 'Стиль меню',
    menubar_style_desktop: 'Рабочий стол',
    menubar_style_system: 'Система',
    menubar_style_window: 'Окно',
    modified: 'Изменено',
    move: 'Переместить',
    moving_file: 'Перемещаю %%',
    my_websites: 'Мои Сайты',
    name: 'Имя',
    name_cannot_be_empty: 'Имя не может быть пустым.',
    name_cannot_contain_double_period: "Имя не может быть '..' символом.",
    name_cannot_contain_period: "Имя не может быть '.' символом.",
    name_cannot_contain_slash: "Имя не может содержать '/' символ.",
    name_must_be_string: 'Имя может содержать только текстовые символы.',
    name_too_long: `Имя не может быть длинее %% символов.`,
    new: 'Новый',
    new_email: 'Новая электронная почта',
    new_folder: 'Новая папка',
    new_password: 'Новый пароль',
    new_username: 'Новое имя пользователя',
    no: 'Нет',
    no_dir_associated_with_site: 'Нет директории, связанной с этим адресом.',
    no_websites_published: 'Вы еще не опубликовали ни одного сайта.',
    ok: 'OK',
    open: 'Открыть',
    open_in_new_tab: 'Открыть в новой вкладке',
    open_in_new_window: 'Открыть в новом окне',
    open_with: 'Открыть с помощью',
    original_name: 'Оригинальное имя',
    original_path: 'Изначальный путь',
    oss_code_and_content:
      'Программное обеспечение и контент с открытым исходным кодом',
    password: 'Пароль',
    password_changed: 'Пароль изменен.',
    password_recovery_rate_limit:
      'Вы достигли лимита. Пожалуйста, подождите несколько минут. Чтобы предотвратить это в будущем, не перезагружайте страницу слишком много раз.',
    password_recovery_token_invalid:
      'Этот токен восстановления пароля больше не действителен.',
    password_recovery_unknown_error:
      'Неизвестная ошибка. Пожалуйста, повторите попытку позже.',
    password_required: 'Необходимо ввести пароль.',
    password_strength_error:
      'Пароль должен иметь длину не менее 8 символов и содержать хотя бы одну заглавную букву, одну строчную букву, одну цифру и один специальный знак.',
    passwords_do_not_match:
      'Поля `Новый пароль` и `Подтвердите новый пароль` не совпадают.',
    paste: 'Вставить',
    paste_into_folder: 'Вставить в папку',
    path: 'Путь',
    personalization: 'Персонализация',
    pick_name_for_website: 'Выберите имя для вашего сайта:',
    picture: 'Изображение',
    pictures: 'Изображения',
    plural_suffix: 's', //does not exist in Russian language
    powered_by_puter_js: `Создано на {{link=docs}}Puter.js{{/link}}`,
    preparing: 'Подготовка...',
    preparing_for_upload: 'Подготовка к загрузке...',
    print: 'Печать',
    privacy: 'Конфиденциальность',
    proceed_to_login: 'Перейти ко входу',
    proceed_with_account_deletion: 'Продолжить удаление учетной записи',
    process_status_initializing: 'Инициализация',
    process_status_running: 'Выполняется',
    process_type_app: 'Прил.',
    process_type_init: 'Иниц.',
    process_type_ui: 'Пользовательский интерфейс',
    properties: 'Свойства',
    publish: 'Опубликовать',
    public: 'Общий доступ',
    publish_as_website: 'Опубликовать как сайт',
    puter_description: `Puter — это персональное облако, обеспечивающее конфиденциальность, позволяющее хранить все ваши файлы, приложения и игры в одном безопасном месте, доступном из любого места в любое время.`,
    reading_file: 'Чтение %strong%',
    recent: 'Недавнее',
    recommended: 'Рекоммендации',
    recover_password: 'Восстановить Пароль',
    refer_friends_c2a:
      'Получите 1 ГБ за каждого друга, который создаст и подтвердит учетную запись на Puter. Ваш друг тоже получит 1 ГБ!',
    refer_friends_social_media_c2a: `Получите 1 ГБ бесплатного хранилища на Puter.com!`,
    refresh: 'Обновить',
    release_address_confirmation: `Вы уверены, что хотите освободить этот адрес?`,
    remove_from_taskbar: 'Удалить из панели задач',
    rename: 'Переименовать',
    repeat: 'Повторить',
    replace: 'Заменить',
    replace_all: 'Заменить все',
    resend_confirmation_code: 'Повторно отправить код подтверждения',
    reset_colors: 'Сбросить цвета',
    restart_puter_confirm: 'Вы уверены, что хотите перезапустить Puter?',
    restore: 'Восстановить',
    save: 'Сохранить',
    saturation: 'Насыщенность',
    save_account: 'Сохранить Учетную запись',
    save_account_to_get_copy_link:
      'Пожалуйста, создайте учетную запись, чтобы продолжить.',
    save_account_to_publish:
      'Пожалуйста, создайте учетную запись, чтобы продолжить.',
    save_session: 'Сохранить сеанс',
    save_session_c2a:
      'Создайте учетную запись, чтобы сохранить текущий сеанс и не потерять данные.',
    scan_qr_c2a:
      'Отсканируйте код ниже, чтобы войти в этот сеанс с других устройств',
    scan_qr_2fa: 'Отсканируйте QR-код с помощью приложения аутентификации',
    scan_qr_generic:
      'Отсканируйте этот QR-код с помощью телефона или другого устройства',
    search: 'Поиск',
    seconds: 'секунды',
    security: 'Безопасность',
    select: 'Выбрать',
    selected: 'выбрано',
    select_color: 'Выбрать цвет…',
    sessions: 'Сеансы',
    send: 'Отправить',
    send_password_recovery_email:
      'Отправить электронное письмо для восстановления пароля',
    session_saved:
      'Благодарим вас за создание учетной записи. Этот сеанс сохранен.',
    settings: 'Настройки',
    set_new_password: 'Установить новый пароль',
    share: 'Поделиться',
    share_to: 'Поделиться',
    share_with: 'Поделиться с: ',
    shortcut_to: 'Ярлык для',
    show_all_windows: 'Показать Все Окна',
    show_hidden: 'Показать скрытые',
    sign_in_with_puter: 'Войти с Puter',
    sign_up: 'Зарегистрироваться',
    signing_in: 'Вход в систему…',
    size: 'Размер',
    skip: 'Пропустить',
    something_went_wrong: 'Что-то пошло не так.',
    sort_by: 'Отсортировать по',
    start: 'Начать',
    status: 'Статус',
    storage_usage: 'Использование хранилища',
    storage_puter_used: 'использовано Puter',
    taking_longer_than_usual:
      'Это занимает немного больше времени чем обычно, пожалуйста, подождите...',
    task_manager: 'Диспетчер задач',
    taskmgr_header_name: 'Имя',
    taskmgr_header_status: 'Статус',
    taskmgr_header_type: 'Тип',
    terms: 'Условия',
    text_document: 'Текстовый документ',
    tos_fineprint: `Нажимая 'Создать бесплатную учетную запись', вы соглашаетесь с {{link=terms}}Условиями Использования{{/link}} и {{link=privacy}}Политикой Конфиденциальности{{/link}} Puter.`,
    transparency: 'Прозрачность',
    trash: 'Корзина',
    two_factor: 'Двухфакторная аутентификация',
    two_factor_disabled: 'Двухфакторная аутентификация отключена',
    two_factor_enabled: 'Двухфакторная аутентификация включена',
    type: 'Тип',
    type_confirm_to_delete_account:
      "Введите 'подтвердить', чтобы удалить учетную запись.",
    ui_colors: 'Цвета пользовательского интерфейса',
    ui_manage_sessions: 'Менеджер Сеансов',
    ui_revoke: 'Отозвать',
    undo: 'Отменить',
    unlimited: 'Неограничено',
    unzip: 'Распаковать',
    upload: 'Загрузить',
    upload_here: 'Загрузить здесь',
    usage: 'Использование',
    username: 'Имя пользователя',
    username_changed: 'Имя пользователя успешно обновлено.',
    username_required: 'Требуется имя Пользователя.',
    versions: 'Версии',
    videos: 'Видео',
    visibility: 'Видимость',
    yes: 'Да',
    yes_release_it: 'Да, освободить.',
    you_have_been_referred_to_puter_by_a_friend:
      'Вы были приглашены в Puter другом!',
    zip: 'Добавить в архив',
    zipping_file: 'Добавление в архив %strong%',

    // === 2FA Setup ===
    setup2fa_1_step_heading: 'Откройте приложение для аутенцификации',
    setup2fa_1_instructions: `
            Вы можете использовать любое приложение для аутентификации, поддерживающее протокол одноразового пароля на основе времени (TOTP).
            Существует большой выбор приложений, но если вы не уверены, то
            <a target="_blank" href="https://authy.com/download">Authy</a>
            это хороший выбор для Android и iOS
        `,
    setup2fa_2_step_heading: 'Отсканируйте QR-код',
    setup2fa_3_step_heading: 'Введите 6-значный код',
    setup2fa_4_step_heading: 'Скопируйте коды восстановления',
    setup2fa_4_instructions: `
            Эти коды восстановления — единственный способ получить доступ к вашей учетной записи, если вы потеряете свой телефон или не сможете использовать приложение для аутентификации.
            Обязательно храните их в безопасном месте.
        `,
    setup2fa_5_step_heading:
      'Подтвердите установку двухфакторной аутентификации',
    setup2fa_5_confirmation_1:
      'Я сохранил коды восстановления в безопасном месте',
    setup2fa_5_confirmation_2: 'Я готов включить двухфакторную аутентификацию',
    setup2fa_5_button: 'Включить двухфакторную аутентификацию',

    // === 2FA Login ===
    login2fa_otp_title: 'Введите код двухфакторной аутентификации',
    login2fa_otp_instructions:
      'Введите 6-значный код из приложения для аутентификации',
    login2fa_recovery_title: 'Введите код восстановления доступа',
    login2fa_recovery_instructions:
      'Введите один из кодов восстановления доступа чтобы получить доступ к учетной записи.',
    login2fa_use_recovery_code: 'Используйте код восстановления доступа',
    login2fa_recovery_back: 'Назад',
    login2fa_recovery_placeholder: 'XXXXXXXX',
    change: 'Изменить',
    clock_visibility: 'Видимость часов',
    confirm_your_email_address: 'Подтвердить электронную почту',
    reading: 'Чтение %strong%',
    writing: 'Запись %strong%',
    unzipping: 'Распаковка %strong%',
    sequencing: 'Упорядочивание %strong%',
    zipping: 'Архивирование %strong%',
    Editor: 'Редактор',
    Viewer: 'Наблюдатель',
    'People with access': 'Люди с доступом',
    'Share With…': 'Поделиться с...',
    Owner: 'Владелец',
    "You can't share with yourself.": 'Вы не можете поделиться с самим собой.',
    'This user already has access to this item': 'Этот пользователь уже имеет доступ к этому элементу.',

    "billing.change_payment_method": 'Изменить', // In English: "Change"
    "billing.cancel": 'Отмена', // In English: "Cancel"
    "billing.download_invoice": 'Загрузить', // In English: "Download"
    "billing.payment_method": 'Метод оплаты', // In English: "Payment Method"
    "billing.payment_method_updated": 'Метод оплаты обновлён!', // In English: "Payment method updated!"
    "billing.confirm_payment_method": 'Подтвердить метод оплаты', // In English: "Confirm Payment Method"
    "billing.payment_history": 'История платежей', // In English: "Payment History"
    "billing.refunded": 'Средства возвращены', // In English: "Refunded"
    "billing.paid": 'Оплачено', // In English: "Paid"
    "billing.ok": 'Ок', // In English: "OK"
    "billing.resume_subscription": 'Продолжить подписку', // In English: "Resume Subscription"
    "billing.subscription_cancelled": 'Ваша подписка отменена.', // In English: "Your subscription has been canceled."
    "billing.subscription_cancelled_description": 'Вы можете пользоваться подпиской до конца оплаченного периода', // In English: "You will still have access to your subscription until the end of this billing period."
    "billing.offering.free": 'Бесплатно', // In English: "Free"
    "billing.offering.pro": 'Профессиональная', // In English: "Professional"
    "billing.offering.business": 'Бизнес', // In English: "Business"
    "billing.cloud_storage": 'Облачное хранилище', // In English: "Cloud Storage"
    "billing.ai_access": 'Доступ к ИИ', // In English: "AI Access"
    "billing.bandwidth": 'Пропускная способность', // In English: "Bandwidth"
    "billing.apps_and_games": 'Игры и приложения', // In English: "Apps & Games"
    "billing.upgrade_to_pro": 'Обновить до %strong%', // In English: "Upgrade to %strong%"
    "billing.switch_to": 'Переключиться на %strong%', // In English: "Switch to %strong%"
    "billing.payment_setup": 'Настройки оплаты', // In English: "Payment Setup"
    "billing.back": 'Назад', // In English: "Back"
    "billing.you_are_now_subscribed_to": 'Теперь Ваш уровень подписки %strong%.', // In English: "You are now subscribed to %strong% tier."
    "billing.you_are_now_subscribed_to_without_tier": 'Теперь Вы подписаны', // In English: "You are now subscribed"
    "billing.subscription_cancellation_confirmation": 'Вы уверены, что хотите отменить Вашу подписку?', // In English: "Are you sure you want to cancel your subscription?"
    "billing.subscription_setup": 'Настройки подписки', // In English: "Subscription Setup"
    "billing.cancel_it": 'Отменить', // In English: "Cancel It"
    "billing.keep_it": 'Удержать', // In English: "Keep It"
    "billing.subscription_resumed": 'Ваша %strong% подписка была продлена!', // In English: "Your %strong% subscription has been resumed!"
    "billing.upgrade_now": 'Обновить сейчас', // In English: "Upgrade Now"
    "billing.upgrade": 'Обновить', // In English: "Upgrade"
    "billing.currently_on_free_plan": 'Сейчас у Вас бесплатный план.', // In English: "You are currently on the free plan."
    "billing.download_receipt": 'Загрузить квитанцию', // In English: "Download Receipt"
    "billing.subscription_check_error": 'Произошла ошибка при проверке статуса Вашей подписки.', // In English: "A problem occurred while checking your subscription status."
    "billing.email_confirmation_needed": 'Ваш e-mail не подтверждён. Мы отправили Вам код для подтверждения.', // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
    "billing.sub_cancelled_but_valid_until": 'Вы отменили Вашу подписку и она автоматически переключится на бесплатный план по истечению оплаченного периода. С Вас не будет взыматься плата, если Вы не подпишетесь повторно', // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
    "billing.current_plan_until_end_of_period": 'Ваш действующий план до конца оплаченного периода', // In English: "Your current plan until the end of this billing period."
    "billing.current_plan": 'Настоящий план', // In English: "Current plan"
    "billing.cancelled_subscription_tier": 'Отменённая подписка (%%)', // In English: "Cancelled Subscription (%%)"
    "billing.manage": 'Управление', // In English: "Manage"
    "billing.limited": 'Ограничено', // In English: "Limited"
    "billing.expanded": 'Расширенный', // In English: "Expanded"
    "billing.accelerated": 'Ускоренный', // In English: "Accelerated"
    "billing.enjoy_msg": 'Пользуйтесь %% Облачным Хранилищем и остальными выгодами', // In English: "Enjoy %% of Cloud Storage plus other benefits."
  },
}

export default ru
