/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const ro = {
    name: "Română",
    english_name: "Romanian",
    code: "ro",
    dictionary: {
        about: "Despre Puter",
        account: "Cont",
        account_password: "Verifică parola contului",
        access_granted_to: "Acces acordat pentru",
        add_existing_account: "Adaugă cont existent",
        all_fields_required: 'Toate câmpurile sunt necesare.',
        allow: "Permite",
        apply: "Aplică",
        ascending: 'Ascendent',
        associated_websites: "Site-uri partenere",
        auto_arrange: "Aranjare automată",
        background: "Background",
        browse: "Caută",
        cancel: 'Anulează',
        center: 'Centru',
        change_desktop_background: 'Schimbă imaginea de fundal…',
        change_email: "Schimbă e-mailul",
        change_language: "Schimbă Limba",
        change_password: "Schimbă Parola",
        change_ui_colors: "Schimbă Culorile Interfeței",
        change_username: "Schimbă User-ul",
        close: "Închide",
        close_all_windows: "Închide toate ferestrele",
        close_all_windows_confirm: "Sunteți sigur(ă) că doriți să închideți toate ferestrele?",
        close_all_windows_and_log_out: "Închide toate ferestrele și delogheză-mă",
        change_always_open_with: "Doriți să deschideți acest tip de fișiere cu ",
        color: 'Culoare',
        confirm: "Confirmă",
        confirm_2fa_setup: "Am adăgat codul la aplicația de autentificare",
        confirm_2fa_recovery: "Am salvat codurile de recuperare într-o locație sigură",
 
        confirm_account_for_free_referral_storage_c2a: 'Creați un cont și confirmați adresa de e-mail pentru a primi 1 GB de spațiu de stocare gratuit. Deasemenea, un prieten de-al tău va primi 1 GB de spațiu de stocare gratuit.',
        confirm_code_generic_incorrect: "Cod incorect",
        confirm_code_generic_too_many_requests: "Prea multe solicitări. Vă rugăm așteptați câteva minute.",
        confirm_code_generic_submit: "Trimite cod",
        confirm_code_generic_try_again: "Încercați din nou",
        confirm_code_generic_title: "Introduceți codul de confirmare",
        confirm_code_2fa_instruction: "Introduceți codul de 6 cifre generat de aplicația de autentificare",
        confirm_code_2fa_submit_btn: "Trimite",
        confirm_code_2fa_title: "Introduceți codul 2FA",
        confirm_delete_multiple_items: "Sunteți sigur(ă) că doriți să ștergeți aceste obiecte permanent",
        confirm_delete_single_item: "Doriți să ștergeți acest obiect permanent?",
        confirm_open_apps_log_out: "Aveți aplicații care rulează. Sunteți sigur(ă) că doriți să vă delogați?",
        confirm_new_password: "Confirmă Parola Nouă",
        confirm_delete_user: "Sunteți sigur(ă) că doriți să ștergeți acest cont? Toate fișierele dumneavoastră și toate datele vor fi șterse permanent. Această operație nu poate fi anulată.",
        confirm_delete_user_title: "Ștergeți contul?",
        confirm_session_revoke: "Sunteți sigur(ă) că doriți să revocați sesiunea curentă?",
        confirm_your_email_address: "Confirmați adresa dumneavoastră de e-mail",
        contact_us: "Contactează-ne",
        contact_us_verification_required: "Aveți nevoie de o adresă de e-mail confirmată.",
        contain: 'Conțină',
        continue: "Continuă",
        copy: 'Copiază',
        copy_link: "Copiază link",
        copying: "Se copiază",
        copying_file: "Se copiază %%",
        cover: 'Copertă',
        create_account: "Crează un cont",
        create_free_account: "Crează un cont gratuit",
        create_shortcut: "Crează o comandă rapidă",
        credits: "Credite",
        current_password: "Parola Curentă",
        cut: 'Decupează',
        clock: "Ora",
        clock_visible_hide: "Ascunde - Întotdeauna ascuns",
        clock_visible_show: "Afișează - Întotdeauna vizibil",
        clock_visible_auto: "Automat - Mod implicit, vizibil doar în modul ecran complet.",
        close_all: "Închide toate",
        created: "Creat",
        date_modified: 'Dată modificare',
        default: "Implicit",
        delete: 'Șterge',
        delete_account: "Șterge cont",
        delete_permanently: "Șterge Permanent",
        deleting_file: "Se șterge %%",
        deploy_as_app: 'Publică ca aplicație',
        descending: 'Coborând',
        desktop: 'Desktop',
        desktop_background_fit: "Potrivește fundalul",
        developers: "Programatori",
        dir_published_as_website: `%strong% a fost publicat către:`,
        disable_2fa: "Dezactivați 2FA",
        disable_2fa_confirm: "Sunteți sigur(ă) că doriți să dezactivați 2FA?",
        disable_2fa_instructions: "Introduceți parola dumneavoastră pentru a dezactiva 2FA.",
        disassociate_dir: "Dezasociaza folderul",
        documents: "Documente",
        dont_allow: "Nu permiteți",
        download: 'Descarcă',
        download_file: "Descarcă fișier",
        downloading: "Se descarcă",
        email: "E-mail",
        email_change_confirmation_sent: "Un e-mail de confirmare a fost trimis către noua dumneavoastră adresă de e-mail. Vă rugăm să verificați ©ăsuța și să urmați intrucțiunile pentru a finaliza procesul.",
        email_invalid: "E-mailul este invalid.",
        email_or_username: "E-mail sau Nume de Utilizator",
        email_required: "E-mailul este necesar.",
        empty_trash: 'Golește Coșul de gunoi',
        empty_trash_confirmation: `Ești sigur că vrei să ștergi permanent conținutul Coșului de gunoi?`,
        emptying_trash: 'Coșul de gunoi se golește…',
        enable_2fa: "Activați 2FA",
        end_hard: "Terminați brutal",
        end_process_force_confirm: "Sunteți sigur(ă) că doriți să forțați terminarea acestui proces",
        end_soft: "Terminați Aplicația",
        enlarged_qr_code: "Măriți Codul QR",
        enter_password_to_confirm_delete_user: "Introduceți parola pentru a confirma începerea ștergerii contului",
        error_message_is_missing: "Mesajul de eroare lipsește.",
        error_unknown_cause: "A apărut o erorare necunoscută.",
        error_uploading_files: "Încărcarea fișierelor a eșuat",
        favorites: "Preferate",
        feedback: "Evaluare",
        feedback_c2a: "Vă rugăm să folosiți formularul de mai jos pentru a ne trimite feedback, comentarii și rapoarte de erori.",
        feedback_sent_confirmation: "Mulțumim că ne-ți contactat. Dacă aveți un e-mail asociat contului dvs, veți primi un răspuns de la noi cât mai curând posibil.",
        fit: "Potrivit",
        folder: "Folder",
        force_quit: "Forțează ieșirea",
        forgot_pass_c2a: "Ați uitat parola?",
        from: "De la",
        general: "General",
        get_a_copy_of_on_puter: `Obțineți o copie a '%%' pe Puter.com!`,
        get_copy_link: 'Obțineți link-ul copiei',
        hide_all_windows: "Ascunde toate ferestrele",
        home: "Acasă",
        html_document: 'Document HTML',
        hue: "Hue",
        image: 'Imagine',
        incorrect_password: "Parolă incorectă",
        invite_link: "Link de invitație",
        item: "Obiect",
        items_in_trash_cannot_be_renamed: `Acest obiect nu poate fi redenumit deoarece este în coșul de gunoi. Pentru a redenumi acest obiect, mai întâi scoateți-l din Coșul de gunoi.`,
        jpeg_image: 'Imagine JPEG',
        keep_in_taskbar: 'Păstrează în bara de activități',
        language: "Limbă",
        license: "Licență",
        lightness: "Luminozitate",
        link_copied: "Link copiat",
        loading: "Încarcă",
        log_in: "Loghează-te",
        log_into_another_account_anyway: "Logați-vă oricum într-un alt cont",
        log_out: 'Deconectează-te',
        looks_good: "Arată bine!",
        manage_sessions: "Administrează sesiuni",
        menubar_style: "Stil bară de meniu",
        menubar_style_desktop: "Desktop",
        menubar_style_system: "Sistem",
        menubar_style_window: "Fereastră",
        modified: "Modificat",
        move: 'Mută',
        moving_file: "Se mută %%",
        my_websites: "Site-urile mele",
        name: 'Nume',
        name_cannot_be_empty: 'Numele nu poate fi necompletat.',
        name_cannot_contain_double_period: "Numele nu poate conține ..",
        name_cannot_contain_period: "Numele nu poate conține .",
        name_cannot_contain_slash: "Numele nu poate contine /",
        name_must_be_string: "Numele poate fi doar un șir.",
        name_too_long: `Numele nu poate fi mai lung de %% caractere.`,
        new: 'Nou',
        new_email: "E-mail nou",
        new_folder: 'Folder nou',
        new_password: "Parolă nouă",
        new_username: "Nume de Utilizator nou",
        no: "Nu",
        no_dir_associated_with_site: 'Niciun director asociat cu această adresă.',
        no_websites_published: "Nu ați publicat încă niciun site web.",
        ok: 'OK',
        open: "Deschide",
        open_in_new_tab: "Deschide in alt tab",
        open_in_new_window: "Deschide in fereastră nouă",
        open_with: "Deschide cu",
        original_name: "Numele original",
        original_path: "Calea originală",
        oss_code_and_content: "Software și conținut Open Source",
        password: "Parolă",
        password_changed: "Parolă schimbată.",
        password_recovery_rate_limit: "Ați ajuns la frecvența limită; vă rugăm așteptați câteva minute. Pentru a nu se mai repeta pe viitor, evitați să reîncărcați pagina de prea multe ori.",
        password_recovery_token_invalid: "Acest cod de recuperare nu mai este valabil.",
        password_recovery_unknown_error: "A apărut o eroare necunoscută. Vă rugăm încercați din nou mai târziu.", 
        password_required: "Parola este necesară",
        password_strength_error: "Parola trebuie să aibe cel puțin 8 caractere și să conțină cel puțin o literă mare, o litera mică, o cifră și un caracter special.",
        passwords_do_not_match: '`Parola nouă` și `Confirmă Parola nouă` nu sunt la fel.',
        paste: 'Inserează',
        paste_into_folder: "Inserează in folder",
        path: "Cale",
        personalization: "Personalizare",
        pick_name_for_website: "Alegeți un nume pentru site-ul dvs:",
        picture: "Imagine",
        pictures: "Imagini",
        plural_suffix: "e",
        powered_by_puter_js: `Creat de {{link=docs}}Puter.js{{/link}}`,
        preparing: "Preparare...",
        preparing_for_upload: "Preparare pentru încărcare...",
        print: "Tipărește",
        privacy: "Confidențialitate",
        proceed_to_login: "Mergeți mai departe pentru logare",
        proceed_with_account_deletion: "Mergeți mai departe cu ștergerea contului",
        process_status_initializing: "Se inițializează",
        process_status_running: "Procesează",
        process_type_app: "App",
        process_type_init: "Inițializare",
        process_type_ui: "Interfață grafică",
        properties: "Proprietăți",
        public: "Public",
        publish: "Publică",
        publish_as_website: 'Publică, ca site web',
        puter_description: "Puter este un cloud personal care pune pe primul loc confidențialitatea pentru păstrarea tuturor fișierelor dumneavoastră, a app-urilor, a jocurilor într-un loc sigur și accesibil de oriunde oricând.",
        reading_file: "Citind %strong%",
        recent: "Recente",
        recommended: "Recomandat",
        recover_password: "Recuperare Parolă",
        refer_friends_c2a: "Obțineți 1 GB pentru fiecare prieten care creează și confirmă un cont pe Puter. și prietenul tău va primi 1 GB!",
        refer_friends_social_media_c2a: `Obțineți 1 GB de spațiu de stocare gratuit pe Puter.com!`,
        refresh: 'Reîmprospătare',
        release_address_confirmation: `Sigur doriți să eliberați această adresă?`,
        remove_from_taskbar:'Eliminați din bara de activități',
        rename: 'Redenumește',
        repeat: 'Repetă',
        replace: "Înlocuiește",
        replace_all: "Înlocuiește toate",
        resend_confirmation_code: "Re-trimite cod de confirmare",
        reset_colors: "Resetează culori",
        restart_puter_confirm: "Sunteți sigur(ă) că doriți să reporniți Puter?",
        restore: "Restaurare",
        save: "Salvare",
        saturation: "Saturație",
        save_account: "Salvați contul",
        save_account_to_get_copy_link: "Vă rugăm să creați un cont pentru a copia un link.",
        save_account_to_publish: 'Vă rugăm să creați un cont pentru a publica.',
        save_session: "Salvați sesiunea",
        save_session_c2a: 'Creați un cont pentru a vă salva sesiunea curentă și pentru a evita pierderea muncii.',
        scan_qr_c2a: 'Scanați codul de mai jos pentru a vă conecta la această sesiune de pe alte dispozitive',
        scan_qr_2fa: "Scanati codul QR cu aplicația de autentificare",
        scan_qr_generic: "Scanați acest cod QR folsindu-vă telefonul personal sau un alt dispozitiv",
        search: "Caută",
        seconds: "Secunde",
        security: "Securitate",
        select: "Selectează",
        selected: "Selectat",
        select_color: 'Selectează culoare…',
        sessions: "Sesiuni",
        send: "Trimite",
        send_password_recovery_email: "Trimite mail de recuperare parolă",
        session_saved: "Vă mulțumim pentru crearea unui cont. Această sesiune a fost salvată.",
        settings: "Setări",
        set_new_password: "Setează o parolă Nouă",
        share: "Distribuie",
        share_to: "Distribuie către",
        share_with: "Distribuie cu",
        shortcut_to: "Comandă rapidă ©ătre",
        show_all_windows: "Afișați toate ferestrele",
        show_hidden: 'Arată ascuns',
        sign_in_with_puter: "Conectați-vă cu Puter",
        sign_up: "Inscrie-te",
        signing_in: "Se conectează…",
        size: 'Mărime',
        skip: "Ignoră",
        something_went_wrong: "Ceva nu a funcționat.",
        sort_by: 'Sortează dupa',
        start: 'Start',
        status: "Stare",
        storage_usage: "Utilizare spațiu",
        storage_puter_used: "folosit de Puter",
        taking_longer_than_usual: 'Durează puțin mai mult decât de obicei. Vă rugăm așteptați...',
        task_manager: "Administrator aplicații",
        taskmgr_header_name: "Nume",
        taskmgr_header_status: "Stare",
        taskmgr_header_type: "Tip",
        terms: "Termeni",
        text_document: 'Document Text',
        tos_fineprint: `Făcând clic pe „Creați un cont gratuit”, sunteți de acord cu {{link=terms}}Termenii si conditiile{{/link}} si {{link=privacy}}Politia de Confidentialitate Puter.com{{/link}}.`,
        transparency: "Transparență",
        trash: 'Coș de gunoi',
        two_factor: "Autentificare Two Factor",
        two_factor_disabled: "2FA Dezactivat",
        two_factor_enabled: "2FA Activat",
        type: 'Type',
        type_confirm_to_delete_account: "Tastați 'confirm' pentru a șterge contul dumneavoastră.",
        ui_colors: "Culori Interfața",
        ui_manage_sessions: "Administrator Sesiuni",
        ui_revoke: "Revocă",
        undo: 'Undo',
        unlimited: "Nelimitat",
        unzip: "Unzip",
        upload: 'Incarcă',
        upload_here: 'Incarcă aici',
        usage: "Grad de utilizare",
        username: "Nume de Utilizator",
        username_changed: 'Nume de Utilizator actualizat cu succes.',
        username_required: "Utilizatorul este necesar",
        versions: "Versiuni",
        videos: "Video-uri",
        visibility: "Vizibilitate",
        yes: "Da",
        yes_release_it: 'Da, publică',
        you_have_been_referred_to_puter_by_a_friend: "Ai fost invitat pe Puter de către un prieten!",
        zip: "Zip",
        zipping_file: 'Se arhivează %strong%',
        
        setup2fa_1_step_heading: "Deschideți aplicația de autentificare",
        setup2fa_1_instructions: `
           Puteți folosi orice aplicație de autentificare care folosește protocolul Time-based One-Time Password (TOTP).
           Sunt multe astfel de aplicații, dar dacă sunteți nesiguri
           <a target="_blank" href="https://authy.com/download">Authy</a>
           este o opțiune serioasă pentru Android si iOS.
           `,
        setup2fa_2_step_heading: "Scanați codul QR",
        setup2fa_3_step_heading: "Introduceți codul de 6 cifre",
        setup2fa_4_step_heading: "Copiați codurile dumneavoastră de restaurare",
        setup2fa_4_instructions: `
           Aceste coduri de restaurare sunt singurul mod în care vă puteți accesa contul dacă vă pierdeți telefonul sau nu puteți folosi aplicația de autentificare.
           Asigurați-vă că le scrie-ți într-un loc sigur.`,
        setup2fa_5_step_heading: "Confirmați configurația 2FA",
        setup2fa_5_confirmation_1: "Mi-am salvat codurile de restaurare într-un loc sigur",
        setup2fa_5_confirmation_2: "Sunt gata să activez 2FA",
        setup2fa_5_button: "Activează 2FA",
        
        login2fa_otp_title: "Introduceți codul 2FA",
        login2fa_otp_instructions: "Introduceți codul de 6 cifre din aplicația de autentificare.",
        login2fa_recovery_title: "Introduceți un cod de restaurare",
        login2fa_recovery_instructions: "Introduceți unul dintre codurile de restaurare pentru a vă accesa contul.",
        login2fa_use_recovery_code: "Folosiți un cod de restaurare",
        login2fa_recovery_back: "Înapoi",
        login2fa_recovery_placeholder: "XXXXXXXX",

        change: "Schimbǎ",
        clock_visibility: "Vizibilitatea Ceasului",
        reading: "Citire %strong%",
        writing: "Scriere %strong%",
        unzipping: "Dezarhivare %strong%",
        sequencing: "Segvențiere %strong%",
        zipping: "Arhivare %strong%",
        Editor: "Editor",
        Viewer: "Privitor",
        "People with access": "Persoane cu acces",
        "Share With…": "Partajare cu…", // In Romanian "partajare" is not that used, we use the verb "a împărți" but all apps seem to translate "share" to "partajare"
        Owner: "Proprietar",
        "You can't share with yourself.": "Nu poți partaja cu tine însuți.", // In English: "You can't share with yourself."
        "This user already has access to this item": "Acest utilizator are deja acces la acest element",

       "billing.change_payment_method": "Schimbă", 
        "billing.cancel": "Anulează",
        "billing.download_invoice": "Descarcă",
        "billing.payment_method": "Metodă de plată",
        "billing.payment_method_updated": "Metoda de plată a fost actualizată!",
        "billing.confirm_payment_method": "Confirmă metoda de plată",
        "billing.payment_history": "Istoric plăți",
        "billing.refunded": "Rambursat",
        "billing.paid": "Plătit",
        "billing.ok": "OK",
        "billing.resume_subscription": "Reactivează abonamentul",
        "billing.subscription_cancelled": "Abonamentul tău a fost anulat.",
        "billing.subscription_cancelled_description": "Vei avea în continuare acces la abonament până la sfârșitul perioadei de facturare actuale.",
        "billing.offering.free": "Gratis",
        "billing.offering.pro": "Profesional", 
        "billing.offering.business": "Business", // Keeping "Business" as it's commonly used in Romanian
        "billing.cloud_storage": "Stocare în cloud",
        "billing.ai_access": "Acces AI",
        "billing.bandwidth": "Lățime de bandă",
        "billing.apps_and_games": "Aplicații și jocuri",
        "billing.upgrade_to_pro": "Actualizează la %strong%",
        "billing.switch_to": "Schimbă la %strong%",
        "billing.payment_setup": "Configurare plată",
        "billing.back": "Înapoi",
        "billing.you_are_now_subscribed_to": "Acum ești abonat la nivelul %strong%.",
        "billing.you_are_now_subscribed_to_without_tier": "Acum ești abonat",
        "billing.subscription_cancellation_confirmation": "Ești sigur că vrei să anulezi abonamentul?",
        "billing.subscription_setup": "Configurare abonament",
        "billing.cancel_it": "Anulează-l",
        "billing.keep_it": "Păstrează-l",
        "billing.subscription_resumed": "Abonamentul tău %strong% a fost reactivat!",
        "billing.upgrade_now": "Actualizează acum",
        "billing.upgrade": "Actualizează",
        "billing.currently_on_free_plan": "În prezent folosești planul gratuit.",
        "billing.download_receipt": "Descarcă chitanța",
        "billing.subscription_check_error": "A apărut o problemă la verificarea abonamentului.",
        "billing.email_confirmation_needed": "E-mailul tău nu a fost confirmat. Îți vom trimite acum un cod de confirmare.",
        "billing.sub_cancelled_but_valid_until": "Ți-ai anulat abonamentul și va trece automat la planul gratuit la sfârșitul perioadei de facturare. Nu vei mai fi taxat decât dacă te reabonezi.",
        "billing.current_plan_until_end_of_period": "Planul tău actual până la sfârșitul perioadei de facturare actuale.",
        "billing.current_plan": "Plan actual",
        "billing.cancelled_subscription_tier": "Abonament anulat (%%)",
        "billing.manage": "Administrează",
        "billing.limited": "Limitat",
        "billing.expanded": "Extins",
        "billing.accelerated": "Accelerat",
        "billing.enjoy_msg": "Bucură-te de %% spațiu de stocare în cloud plus alte beneficii.",
    }
}

export default ro;
