/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const pt = {
    name: "Português",
    english_name: "Portuguese",
    code: "pt",
    dictionary: {
        about: "Sobre",
        account: "Conta",
        account_password: "Verificar a palavra-passe da conta",
        access_granted_to: "Acesso Concedido a",
        add_existing_account: "Adicionar Conta Existente",
        all_fields_required: 'Todos os campos são obrigatórios.',
        allow: 'Permitir',
        apply: "Aplicar",
        ascending: 'Ascendente',
        associated_websites: "Sites Associados",
        auto_arrange: 'Auto Organizar',
        background: "Fundo",
        browse: "Explorar",
        cancel: 'Cancelar',
        center: 'Centrar',
        change: 'Alterar', 
        change_desktop_background: 'Alterar fundo do ambiente de trabalho…',
        change_email: "Alterar e-mail",
        change_language: "Alterar Idioma",
        change_password: "Alterar Senha",
        change_ui_colors: "Alterar Cores da Interface",
        change_username: "Alterar Nome de Utilizador",
        clock_visibility: 'Visibilidade do Relógio', 
        close: 'Fechar',
        close_all_windows: "Fechar Todas as Janelas",
        close_all_windows_confirm: "Tem a certeza de que deseja fechar todas as janelas?",
        close_all_windows_and_log_out: 'Fechar Janelas e Sair',
        change_always_open_with: "Queres que ficheiros deste tipo abram sempre com",
        color: 'Cor',
        confirm: 'Confirmar',
        confirm_2fa_setup: 'Adicionei o código à minha aplicação de autenticação',
        confirm_2fa_recovery: 'Guardei os meus códigos de recuperação em um local seguro.',
        confirm_account_for_free_referral_storage_c2a: 'Cria uma conta e confirma o endereço do email para receberes 1 GB de armazenamento gratuito. O teu amigo também receberá 1 GB de armazenamento gratuito.',
        confirm_code_generic_incorrect: "Código Incorreto.",
        confirm_code_generic_too_many_requests: "Demasiados pedidos. Aguarde alguns minutos.",
        confirm_code_generic_submit: "Submeter Código",
        confirm_code_generic_try_again: "Tentar Novamente",
        confirm_code_generic_title: "Introduza o Código de Confirmação",
        confirm_code_2fa_instruction: "Introduza o código de 6 dígitos da sua aplicação de autenticação.",
        confirm_code_2fa_submit_btn: "Submeter",
        confirm_code_2fa_title: "Introduza o Código 2FA",
        confirm_delete_multiple_items: 'Tens a certeza que queres apagar estes itens permanentemente?',
        confirm_delete_single_item: 'Queres apagar este item permanentemente?',
        confirm_open_apps_log_out: 'Tens aplicações abertas. Queres mesmo terminar a sessão?',
        confirm_new_password: "Confirma a Nova Password",
        confirm_delete_user: "Tens a certeza que queres apagar a tua conta? Todos os ficheiros e dados serão apagados permanentemente. Esta operação é final.",
        confirm_delete_user_title: "Eliminar Conta?",
        confirm_session_revoke: "Tem a certeza de que deseja revogar esta sessão?",
        confirm_your_email_address: "Confirme o Seu Endereço de Email",
        contact_us: "Contacta-nos",
        contact_us_verification_required: "É necessário ter um endereço de email verificado para usar isto.",
        contain: 'Contém',
        continue: "Continua",
        copy: 'Copia',
        copy_link: "Copia Link",
        copying: "Copiando",
        copying_file: "Copiando %%",
        cover: 'Capa',
        create_account: "Criar Conta",
        create_free_account: "Criar Conta Gratuita",
        create_shortcut: "Criar Atalho",
        credits: "Créditos",
        current_password: "Password Atual",
        cut: 'Cortar',
        clock: 'Relógio',
        clock_visible_hide: 'Esconder - Sempre escondido',
        clock_visible_show: 'Mostrar - Sempre visível',
        clock_visible_auto: 'Auto - Por defeito, mostra apenas em modo full-screen',
        close_all: 'Fechar Todos',
        created: 'Criado',
        date_modified: 'Data alterada',
        default: 'Pré definido',
        delete: 'Apagar',
        delete_account: "Apagar Conta",
        delete_permanently: "Apagar Permanentemente",
        deleting_file: "A Eliminar %%",
        deploy_as_app: 'Publicar como aplicativo',
        descending: 'Descendente',
        desktop: 'Desktop',
        desktop_background_fit: "Ajustado",
        developers: "Desenvolvedores",
        dir_published_as_website: `%strong% foi publicado em:`,
        disable_2fa: 'Disabilitar 2FA',
        disable_2fa_confirm: "Tem acerteza que quer desabilitar a 2FA?",
        disable_2fa_instructions: "Submetar a sua password para desabilitar 2FA.",
        disassociate_dir: "Desassociar Diretório",
        documents: 'Dicumentos',
        dont_allow: 'Não Permitir',
        download: 'Descarregar',
        download_file: 'Descarregar Ficheiro',
        downloading: "Fazendo a descarga",
        email: "Email",
        email_change_confirmation_sent: "Um email de confirmação foi enviado para o teu novo endereço de email. Por favor, verifique a sua caixa de entrada e siga as instruções para completar o processo.",
        email_invalid: 'O Email que providenciou é invalido.',
        email_or_username: "Email ou Nome de Utilizador",
        email_required: 'Email é obrigatorio.',
        empty_trash: 'Esvaziar Lixo',
        empty_trash_confirmation: `Queres apagar os itens do Lixo permanentemente?`,
        emptying_trash: 'Deitando o Lixo fora…',
        enable_2fa: 'Habilitar 2FA',
        end_hard: "Forçar Encerramento",
        end_process_force_confirm: "Tem a certeza de que deseja forçar o encerramento deste processo?",
        end_soft: "Finalizar Suavemente",
        enlarged_qr_code: "Ampliar QR Code",
        enter_password_to_confirm_delete_user: "Insere a Password para confirmar a remoção da conta",
        error_message_is_missing: "Mensagem de erro em falta.",
        error_unknown_cause: "Um erro desconhecido ocorreu.",
        error_uploading_files: "Erro ao carregar ficheiros.",
        favorites: "Favoritos",
        feedback: "Feedback",
        feedback_c2a: "Por favor usa o formulário abaixo para enviar feedback, comentários e bugs.",
        feedback_sent_confirmation: "Obrigado por nos contactares. Se tiveres um email associado a esta conta, receberás notícias o mais brevemente que nos seja possível.",
        fit: "Ajustar",
        folder: 'Pasta',
        force_quit: 'Forçar Encerramento',
        forgot_pass_c2a: "Esqueceste a senha?",
        from: "De",
        general: "Geral",
        get_a_copy_of_on_puter: `Obter uma cópia de '%%' em Puter.com!`,
        get_copy_link: 'Copiar Link',
        hide_all_windows: "Ocultar Todas as Janelas",
        home: 'Home',
        html_document: 'Documento HTML',
        hue: 'Hue',
        image: 'Imagem',
        incorrect_password: "Password Incorreta.",
        invite_link: "Link do Convite",
        item: 'item',
        items_in_trash_cannot_be_renamed: `Este item não pode ser renomeado porque está no lixo. Para alterar o nome, primeiro arrasta-o para fora do Lixo.`,
        jpeg_image: 'Imagem JPEG',
        keep_in_taskbar: 'Manter na Barra de Tarefas',
        language: "Língua",
        license: "Licença",
        lightness: 'Lightness',
        link_copied: "Link Copiado",
        loading: 'Carregando',
        log_in: "Entrar",
        log_into_another_account_anyway: 'Entrar com outra conta na mesma',
        log_out: 'Sair',
        looks_good: "Looks good!",
        manage_sessions: "Gerir Sessões",
        menubar_style: "Estilo da Barra de Menu",
        menubar_style_desktop: "Desktop",
        menubar_style_system: "Sistema",
        menubar_style_window: "Window",
        modified: 'Modificado',
        move: 'Mover',
        moving_file: "Movendo %%",
        my_websites: "Meus Sites",
        name: 'Nome',
        name_cannot_be_empty: 'Nome não pode ser vazio.',
        name_cannot_contain_double_period: "Nome não pode conter o caractere '..'.",
        name_cannot_contain_period: "Nome não pode conter o caractere '.'.",
        name_cannot_contain_slash: "Nome não pode conter o caractere '/'.",
        name_must_be_string: "Nome tem que ser apenas texto.",
        name_too_long: `Nome não pode ter mais que %% caracteres.`,
        new: 'Novo',
        new_email: 'New Email',
        new_folder: 'Nova Pasta',
        new_password: "Nova Password",
        new_username: "Novo Nome de Utilizador",
        no: 'Não',
        no_dir_associated_with_site: 'Não existe diretório associado com este endereço.',
        no_websites_published: "Ainda não tens sites publicados.",
        ok: 'OK',
        open: "Abrir",
        open_in_new_tab: "Abrir em Nova Aba",
        open_in_new_window: "Abrir em Nova Janela",
        open_with: "Abrir Com",
        original_name: 'Original Name',
        original_path: 'Original Path',
        oss_code_and_content: "Software de Código Aberto",
        password: "Password",
        password_changed: "Password alterada.",
        password_recovery_rate_limit: "Atingiste o nosso limite de pedidos; por favor, espera alguns minutos. Para evitar isto no futuro, evita recarregar a página demasiadas vezes",
        password_recovery_token_invalid: "Token de recuperação de password inválido.",
        password_recovery_unknown_error: "Ocorreu um erro desconhecido ao tentar recuperar a password.",
        password_required: 'Password é obrigatória.',
        password_strength_error: "A password deve ter pelo menos 8 caracteres e conter pelo menos uma letra maiúscula, uma letra minúscula, um número e um caractere especial.",
        passwords_do_not_match: '`Nova Password` e `Confirmação de Nova Password` são diferentes.',
        paste: 'Colar',
        paste_into_folder: "Cola na Pasta",
        path: 'Caminho',
        personalization: "Personalização",
        pick_name_for_website: "Escolha um nome para seu site:",
        picture: "Imagem",
        pictures: 'Imagens',
        plural_suffix: 's',
        powered_by_puter_js: `Criado com {{link=docs}}Puter.js{{/link}}`,
        preparing: "A preparar...",
        preparing_for_upload: "A preparar o upload...",
        print: 'Imprimir',
        privacy: "Privacidade",
        proceed_to_login: 'Prosseguir para o login',
        proceed_with_account_deletion: "Prosseguir com Remoção da Conta",
        process_status_initializing: "Inicializando",
        process_status_running: "A correr",
        process_type_app: 'App',
        process_type_init: 'Init',
        process_type_ui: 'UI',
        properties: "Propriedades",
        public: 'Público',
        publish: "Publicar",
        publish_as_website: 'Publicar como Site',
        puter_description: `Puter é uma nuvem pessoal que prioriza a privacidade e que mantém todos os teus ficheiros, aplicativos e jogos num local seguro, acessível de qualquer lugar e a qualquer hora.`,
        reading: 'A ler %strong%', 
        writing: 'A escrever %strong%',
        reading_file: "A ler %strong%",
        recent: "Recente",
        recommended: "Recomendado",
        recover_password: "Recuperar Password",
        refer_friends_c2a: "Ganha 1 GB por cada amigo que criar e confirmar uma conta Puter. Os teus amigos também ganham 1 GB!",
        refer_friends_social_media_c2a: `Ganha 1 GB de armazenamento gratuito em Puter.com!`,
        refresh: 'Atualizar',
        release_address_confirmation: `Queres libertar este endereço?`,
        remove_from_taskbar:'Remover da Barra de Tarefas',
        rename: 'Renomear',
        repeat: 'Repetir',
        replace: 'Substituir',
        replace_all: 'Substituir Todos',
        resend_confirmation_code: "Re-enviar o Código de Confirmação",
        reset_colors: "Voltar às cores pré-definidas",
        restart_puter_confirm: "Tem a certeza de que deseja reiniciar Puter?",
        restore: "Restaurar",
        save: 'Gravar',
        saturation: 'Saturação',
        save_account: 'Gravar conta',
        save_account_to_get_copy_link: "Para continuar, por favor crie uma conta.",
        save_account_to_publish: 'Para continuar, por favor crie uma conta.',
        save_session: 'Gravar sessão',
        save_session_c2a: 'Crie uma conta para gravar a sessão atual e evitar perder o seu trabalho.',
        scan_qr_c2a: 'Digitalize o código abaixo para entrares nesta sessão com outros dispositivos',
        scan_qr_2fa: 'Digitalize o código QR com a tua aplicação de autenticação',
        scan_qr_generic: 'Digitalize o código QR usando o telefone ou outro dispositivo',
        search: 'Pesquisar',
        seconds: 'segundos',
        security: "Segurança",
        select: "Selecionar",
        selected: 'selecionado',
        select_color: 'Selecionar cor…',
        sessions: "Sessions",
        send: "Enviar",
        send_password_recovery_email: "Enviar Email de Recuperação de Password",
        session_saved: "Obrigado por criares uma conta. Esta sessão foi gravada.",
        settings: "Definições",
        set_new_password: "Definir nova Password",
        share: "Partilhar",
        share_to: "Partilhar com",
        share_with: " Partilhar com:",
        shortcut_to: "Atalho para",
        show_all_windows: "Mostrar Todas as Janelas",
        show_hidden: 'Exibir janelas ocultas',
        sign_in_with_puter: "Entrar em Puter",
        sign_up: "Registar",
        signing_in: "Entrar…",
        size: 'Tamanho',
        skip: 'Passar à frente',
        something_went_wrong: "Algo correu mal.",
        sort_by: 'Ordenar por',
        start: 'Iniciar',
        status: "Status",
        storage_usage: "Uso do Armazenamento",
        storage_puter_used: 'Usado por Puter',
        taking_longer_than_usual: 'Está a levar mais tempo que o usual. Por favor aguarda...',
        task_manager: "Gestor de Tarefas",
        taskmgr_header_name: "Nome",
        taskmgr_header_status: "Status",
        taskmgr_header_type: "Tipo",
        terms: "Termos",
        text_document: 'Documento de Texto',
        tos_fineprint: `Ao clicares em 'Criar Conta Gratuita' concordas com os {{link=terms}}Termos de Serviço{{/link}} e {{link=privacy}}Política de Privacidade{{/link}} do Puter.`,
        transparency: "Transparência",
        trash: 'Lixo',
        two_factor: 'Two Factor Authentication',
        two_factor_disabled: '2FA Desabilitado',
        two_factor_enabled: '2FA Habilitado',
        type: 'Tipo',
        type_confirm_to_delete_account: "Escreve 'confirm' para apagares esta conta.",
        ui_colors: "UI Colors",
        ui_manage_sessions: "Session Manager",
        ui_revoke: "Revoke",
        undo: 'Voltar atrás',
        unlimited: 'Ilimitado',
        unzip: "Abrir zip",
        unzipping: 'A descompactar %strong%', // In English: "Unzipping %strong%"
        upload: 'Carregar',
        upload_here: 'Carregar para aqui',
        usage: 'Utilização',
        username: "Nome de Utilizador",
        username_changed: 'Nome de Utilizador atualizado.',
        username_required: 'Username é obrigatório.',
        versions: "Versões",
        videos: 'Videos',
        visibility: 'Visibilidade',
        yes: 'Sim',
        yes_release_it: 'Sim, libertar',
        you_have_been_referred_to_puter_by_a_friend: "Um amigo teu recomendou-te a Puter.com!",
        zip: "Zipar",
        sequencing: 'A sequenciar %strong%', // In English: "Sequencing %strong%"
        zipping: 'A compactar %strong%', // In English: "Zipping %strong%"
        
        // === 2FA Setup ===
        setup2fa_1_step_heading: 'Abra uma aplicação de autenticação',      
        setup2fa_1_instructions: `
            Podes usar qualquer aplicação de autenticação que suporte o protocolo Time-based One-Time Password (TOTP). 
            Existem muitas opções, mas se não tiveres a certeza, 
            <a target="_blank" href="https://authy.com/download">Authy</a> 
            é uma escolha sólida para Android e iOS.
        `,
        setup2fa_2_step_heading: 'Digitalize o código QR',
        setup2fa_3_step_heading: 'Introduza o código de 6 dígitos',
        setup2fa_4_step_heading: 'Guarde os códigos de recuperação',
        setup2fa_4_instructions: `
           Estes códigos de recuperação são a única maneira de aceder à tua conta se perderes o teu telefone ou não puderes usar a tua aplicação de autenticação.
           Certifica-te de os guardar num local seguro.
        `,
        setup2fa_5_step_heading: 'Confirmação',
        setup2fa_5_confirmation_1: 'Guardei os meus códigos de recuperação num local seguro.',
        setup2fa_5_confirmation_2: 'Estou pronto para ativar a 2FA.',
        setup2fa_5_button: 'Ativar 2FA',

        // === 2FA Login ===
        login2fa_otp_title: 'Introduza o código 2FA',
        login2fa_otp_instructions: 'Introduza o código de 6 dígitos da sua aplicação de autenticação.',
        login2fa_recovery_title: 'Intruduza o codigo de Recuperação de 2FA',
        login2fa_recovery_instructions: 'Introduza um dos seus códigos de recuperação de 2FA para ter acesso a sua conta.',
        login2fa_use_recovery_code: 'Usar código de recuperação',
        login2fa_recovery_back: 'Voltar',
        login2fa_recovery_placeholder: 'XXXXXXXX',

        'Editor': 'Editor', // In English: "Editor"
        'Viewer': 'Visualizador', // In English: "Viewer"
        'People_with_access': 'Pessoas com acesso', // In English: "People with access"
        'Share_With': 'Partilhar com…', // In English: "Share With…"
        'Owner': 'Administrador', // In English: "Owner"
        'You_cant_share_with_yourself': 'Não podes partilhar contigo mesmo', // In English: "You can't share with yourself."
        'This_user_already_has_access_to_this_item': 'Este utilizador já tem acesso a este item', // In English: "This user already has access to this item"

        // ----------------------------------------
        // Missing translations:
        // ----------------------------------------
        "People with access": "Pessoas com acesso", // In English: "People with access"
        "Share With…": "Partilhar com…", // In English: "Share With…"
        "You can't share with yourself.": "Não pode partilhar consigo mesmo.", // In English: "You can't share with yourself."
        "This user already has access to this item": "Este utilizador já tem acesso a este item.", // In English: "This user already has access to this item"
        "billing.change_payment_method": "Alterar", // In English: "Change"
        "billing.cancel": "Cancelar", // In English: "Cancel"
        "billing.download_invoice": "Descarregar", // In English: "Download"
        "billing.payment_method": "Método de Pagamento", // In English: "Payment Method"
        "billing.payment_method_updated": "Método de pagamento atualizado!", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "Confirmar Método de Pagamento", // In English: "Confirm Payment Method"
        "billing.payment_history": "Histórico de Pagamentos", // In English: "Payment History"
        "billing.refunded": "Reembolsado", // In English: "Refunded"
        "billing.paid": "Pago", // In English: "Paid"
        "billing.ok": "OK", // In English: "OK"
        "billing.resume_subscription": "Retomar Subscrição", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "A sua subscrição foi cancelada.", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "Ainda terá acesso à sua subscrição até ao final deste período de faturação.", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "Grátis", // In English: "Free"
        "billing.offering.pro": "Profissional", // In English: "Professional"
        "billing.offering.business": "Empresarial", // In English: "Business"
        "billing.cloud_storage": "Armazenamento na Nuvem", // In English: "Cloud Storage"
        "billing.ai_access": "Acesso à IA", // In English: "AI Access"
        "billing.bandwidth": "Largura de Banda", // In English: "Bandwidth"
        "billing.apps_and_games": "Aplicações e Jogos", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "Atualizar para %strong%", // In English: "Upgrade to %strong%"
        "billing.switch_to": "Trocar para %strong%", // In English: "Switch to %strong%"
        "billing.payment_setup": "Configuração de Pagamento", // In English: "Payment Setup"
        "billing.back": "Voltar", // In English: "Back"
        "billing.you_are_now_subscribed_to": "A sua subscrição no nivel %strong% foi realizada com uscesso.", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "A sua subscrição foi realizada com sucesso", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "Tem a certeza de que deseja cancelar a sua subscrição?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "Configuração da Subscrição", // In English: "Subscription Setup"
        "billing.cancel_it": "Cancelar", // In English: "Cancel It"
        "billing.keep_it": "Manter", // In English: "Keep It"
        "billing.subscription_resumed": "A sua subscrição %strong% foi reativada!", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "Atualizar Agora", // In English: "Upgrade Now"
        "billing.upgrade": "Atualizar", // In English: "Upgrade"
        "billing.currently_on_free_plan": "Está atualmente no plano gratuito.", // In English: "You are currently on the free plan."
        "billing.download_receipt": "Descarregar Recibo", // In English: "Download Receipt"
        "billing.subscription_check_error": "Ocorreu um problema ao verificar o estado da sua subscrição.", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "O seu email não foi confirmado. Enviaremos agora um código para o confirmar.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "Cancelou a sua subscrição e será automaticamente ativado o plano gratuito no final do período de faturação. Não será cobrado novamente a menos que volte a subscrever.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "O seu plano atual até ao final deste período de faturação.", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "Plano Atual", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "Subscrição Cancelada (%%)", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "Gerir", // In English: "Manage"
        "billing.limited": "Limitado", // In English: "Limited"
        "billing.expanded": "Expandido", // In English: "Expanded"
        "billing.accelerated": "Acelerado", // In English: "Accelerated"
        "billing.enjoy_msg": "Desfrute de %% de Armazenamento na Nuvem e outros benefícios.", // In English: "Enjoy %% of Cloud Storage plus other benefits."

    }
};

export default pt;
