/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const pl = {
    name: "Polski",
    english_name: "Polish",
    code: "pl",
    dictionary: {
        about: "Informacje",
        account: "Konto",
        account_password: "Sprawdź hasło konta",
        access_granted_to: "Przyznano dostęp do",
        add_existing_account: "Dodaj istniejące konto",
        all_fields_required: 'Wszystkie pola są wymagane.',
        allow: 'Pozwól',
        apply: "Zaaplikuj",
        ascending: 'Rosnąco',
        associated_websites: "Powiązane strony",
        auto_arrange: 'Auto Aranżacja',
        background: "Tło",
        browse: "Przeglądaj",
        cancel: 'Anuluj',
        center: 'Na środku',
        change_desktop_background: 'Zmień tło pulpitu…',
        change_email: "Zmień email",
        change_language: "Zmień język",
        change_password: "Zmień hasło",
        change_ui_colors: "Zmień kolory interfejsu",
        change_username: "Zmień użytkownika",
        close: 'Zamknij',
        close_all_windows: "Zamknij wszystkie okna",
        close_all_windows_confirm: "Czy jesteś pewien że chcesz zamknąć wszystkie okna?",
        close_all_windows_and_log_out: 'Zamknij wszystkie okna i wyloguj',
        change_always_open_with: "Czy chcesz zawsze otwierać ten typ pliku używając",
        color: 'Kolor',
        confirm: 'Potwierdzam',
        confirm_2fa_setup: 'Dodałem kod do mojej aplikacji autentykującej',
        confirm_2fa_recovery: 'Zapisałem moje kody odzyskiwania w bezpiecznym miejscu',
        confirm_account_for_free_referral_storage_c2a: 'Stwórz konto i potwierdź swój adres e-mail, żeby dostać 1 GB darmowego miejsca. Twój znajomy również dostanie 1 GB darmowego miejsca.',
        confirm_code_generic_incorrect: "Nieprawidłowy kod.",
        confirm_code_generic_too_many_requests: "Zbyt wiele zapytań. Zaczekaj kilka minut.",
        confirm_code_generic_submit: "Wyślij kod",
        confirm_code_generic_try_again: "Spróbuj jeszcze raz",
        confirm_code_generic_title: "Wprowadź kod odzyskiwania",
        confirm_code_2fa_instruction: "Wprowadź 6-cyfrowy kod ze swojej aplikacji autentykującej.",
        confirm_code_2fa_submit_btn: "Wyślij",
        confirm_code_2fa_title: "Wprowadź kod uwierzytelniania dwuskładnikowego",
        confirm_delete_multiple_items: 'Czy na pewno chcesz na zawsze usunąć te przedmioty?',
        confirm_delete_single_item: 'Czy chcesz na zawsze usunąć ten przedmiot?',
        confirm_open_apps_log_out: 'Masz otwarte aplikacje. Czy chcesz na pewno się wylogować?',
        confirm_new_password: "Potwierdź nowe hasło",
        confirm_delete_user: "Czy jesteś pewien że chcesz skasować swoje konto? Wszystkie twoje pliki i dane zostaną trwale skasowane. Tej czynności nie da się cofnąć.",
        confirm_delete_user_title: "Skasować konto?",
        confirm_session_revoke: "Czy jesteś pewien że chcesz unieważnić tą sesję?",
        confirm_your_email_address: "Potwierdź swój adres email",
        contact_us: "Skontaktuj się z nami",
        contact_us_verification_required: "Twój adres email musi być potwierdzony aby tego użyć.",
        contain: 'Dopasuj do ekranu',
        continue: "Kontynuuj",
        copy: 'Kopiuj',
        copy_link: "Kopiuj Link",
        copying: "Kopiowanie",
        copying_file: "Kopiowanie %%",
        cover: 'Wypełnij ekran',
        create_account: "Stwórz konto",
        create_free_account: "Stwórz darmowe konto",
        create_shortcut: "Stwórz skrót",
        credits: "Licencje",
        current_password: "Aktualne hasło",
        cut: 'Wytnij',
        clock: "Zegar",
        clock_visible_hide: 'Ukryj - zawsze ukryty',
        clock_visible_show: 'Pokaż - zawsze widoczny',
        clock_visible_auto: 'Automatycznie (domyślne) - widoczny tylko w trybie pełnoekranowym',
        close_all: 'Zamknij wszystko',
        created: 'Stworzone',
        date_modified: 'Data zmodyfikowania',
        default: 'Domyślne',
        delete: 'Usuń',
        delete_account: "Skasuj konto",
        delete_permanently: "Usuń permamentnie",
        deleting_file: "Usuwanie %%",
        deploy_as_app: 'Wdrożenie jako apkę',
        descending: 'Malejąco',
        desktop: 'Pulpit',
        desktop_background_fit: "Dopasowanie",
        developers: "Dla deweloperów",
        dir_published_as_website: `%strong% został opublikowany do:`,
        disable_2fa: 'Wyłącz uwierzytelnianie dwuskładnikowe',
        disable_2fa_confirm: "Czy jesteś pewien że chcesz wyłączyć uwierzytelnianie dwuskładnikowe?",
        disable_2fa_instructions: "Wprowadź swoje hasło aby wyłączyć uwierzytelnianie dwuskładnikowe.",
        disassociate_dir: "Odłącz katalog",
        documents: 'Dokumenty',
        dont_allow: 'Nie pozwalaj',
        download: 'Pobierz',
        download_file: 'Pobierz plik',
        downloading: "Pobieranie",
        email: "Email",
        email_change_confirmation_sent: "Email z potwierdzeniem został wysłany na twój adres. Sprawdź swoją skrzynkę mailową i wykonaj przesłane instrukcje aby zakończyć proces.",
        email_invalid: 'Email jest nieprawidłowy.',
        email_or_username: "Email lub nazwa użytkownika",
        email_required: 'Email jest wymagany.',
        empty_trash: 'Opróżnij Kosz',
        empty_trash_confirmation: `Czy chcesz nieodwracalnie usunąć pliki z kosza?`,
        emptying_trash: 'Opróżnianie Kosza...',
        enable_2fa: 'Włącz uwierzytelnianie dwuskładnikowe',
        end_hard: "Wymuś zakończenie",
        end_process_force_confirm: "Czy jesteś pewien, że chcesz wymusić zakończenie tego procesu?",
        end_soft: "Zakończ łagodnie",
        enlarged_qr_code: "Powiększony kod QR",
        enter_password_to_confirm_delete_user: "Wpisz swoje hasło aby potwierdzić skasowanie konta",
        error_message_is_missing: "Brak komunikatu błędu.",
        error_unknown_cause: "Wystąpił nieznany błąd.",
        error_uploading_files: "Wgrywanie plików nie powiodło się",
        favorites: "Ulubione",
        feedback: "Opinie",
        feedback_c2a: "Prosimy, aby użyć poniższego formularza do zwracania opinii, komentarzy i zgłaszania błędów.",
        feedback_sent_confirmation: "Dziękujemy za kontakt. Jeżeli z twoim kontem powiązany jest adres email, skontaktujemy się z tobą tak szybko jak to możliwe.",
        fit: "Dopasuj",
        folder: 'Folder',
        force_quit: 'Wymuś zakończenie',
        forgot_pass_c2a: "Zapomniałeś hasła?",
        from: "Od",
        general: "Ogólne",
        get_a_copy_of_on_puter: `Pobierz kopię '%%' na Puter.com!`,
        get_copy_link: 'Pobierz skopiowany link',
        hide_all_windows: "Zamknij wszystkie okna",
        home: 'Folder domowy',
        html_document: 'dokument HTML',
        hue: 'Odcień',
        image: 'Obraz',
        incorrect_password: "Nieprawidłowe hasło",
        invite_link: "Link zaproszeniowy",
        item: 'przedmiot',
        items_in_trash_cannot_be_renamed: `Nazwa tego przedmiotu nie może zostać zmieniona, ponieważ znajduje się on w koszu. Aby zmienić jego nazwę, wyciągnij go z kosza.`,
        jpeg_image: 'Obraz JPEG',
        keep_in_taskbar: 'Zachowaj na pasku zadań',
        language: "Język",
        license: "Licencja",
        lightness: 'Jasność',
        link_copied: "Link skopiowany",
        loading: 'Ładowanie',
        log_in: "Zaloguj się",
        log_into_another_account_anyway: 'Zaloguj się do innego konta mimo wszystko',
        log_out: 'Wyloguj się',
        looks_good: "W porządku!",
        manage_sessions: "Zarządzaj sesjami",
        menubar_style: "Styl paska menu",
        menubar_style_desktop: "Pulpit",
        menubar_style_system: "Jak w systemie",
        menubar_style_window: "Okno",
        modified: 'Zmodyfikowany',
        move: 'Przenieś',
        moving_file: "Przenoszenie %%",
        my_websites: "Moje strony",
        name: 'Nazwa',
        name_cannot_be_empty: 'Nazwa nie może być pusta.',
        name_cannot_contain_double_period: "Nazwa nie może zawierać znaków '..'.",
        name_cannot_contain_period: "Nazwa nie może zawierać znaku '.'.",
        name_cannot_contain_slash: "Nazwa nie może zawierać znaku '/'.",
        name_must_be_string: "Nazwa musi być napisem",
        name_too_long: `Nazwa nie może być dłuższa niż %% znaków.`,
        new: 'Nowy',
        new_email: 'Nowy email',
        new_folder: 'Nowy folder',
        new_password: "Nowe hasło",
        new_username: "Nowa nazwa użytkownika",
        no: 'Nie',
        no_dir_associated_with_site: 'Nie ma folderu powiązanego z tym adresem.',
        no_websites_published: "Nie opublikowałeś jeszcze żadnej strony.",
        ok: 'OK',
        open: "Otwórz",
        open_in_new_tab: "Otwórz w nowej karcie",
        open_in_new_window: "Otwórz w nowym oknie",
        open_with: "Otwórz za pomocą",
        original_name: 'Oryginalna nazwa',
        original_path: 'Oryginalna ścieżka',
        oss_code_and_content: "Oprogramowanie i treści open source",
        password: "Hasło",
        password_changed: "Hasło zostało zmienione.",
        password_recovery_rate_limit: "Osiągnąłeś limit szybkości powtórzeń; poczekaj kilka minut. Aby zapobiec temu w przyszłości, unikaj wielokrotnego przeładowywania strony.",
        password_recovery_token_invalid: "Ten kod odzyskiwania hasła nie jest już ważny.",
        password_recovery_unknown_error: "Wystąpił nieznany błąd. Proszę spróbować później.",
        password_required: 'Wymagane jest hasło.',
        password_strength_error: "Hasło musi mieć co najmniej 8 znaków i musi zawierać co najmniej jedną dużą literę, małą literę, cyfrę i znak specjalny.",
        passwords_do_not_match: 'Pola `Nowe hasło` i `Potwierdź nowe hasło` nie są takie same.',
        paste: 'Wklej',
        paste_into_folder: "Wklej do folderu",
        path: 'Ścieżka',
        personalization: "Personalizacja",
        pick_name_for_website: "Wybierz nazwę dla swojej strony:",
        picture: "Obraz",
        pictures: 'Obrazy',
        plural_suffix: '', //In polish there is a ton of plural suffixes, so I just left it empty
        powered_by_puter_js: `Zasilane za pomocą {{link=docs}}Puter.js{{/link}}`,
        preparing: "Przygotowywanie...",
        preparing_for_upload: "Przygotowywanie do wgrania...",
        print: 'Drukuj',
        privacy: "Prywatność",
        proceed_to_login: 'Przejdź do logowania',
        proceed_with_account_deletion: "Przejdź do kasowania konta",
        process_status_initializing: "Rozpoczynanie",
        process_status_running: "Działanie",
        process_type_app: 'Apka',
        process_type_init: 'Start',
        process_type_ui: 'UI',
        properties: "Właściwości",
        public: 'Publiczne',
        publish: "Opublikuj",
        publish_as_website: 'Opublikuj jako stronę',
        puter_description: `Puter to zachowująca twoją prywatność osobista chmura, służąca do przechowywania wszystkich twoich plików, aplikacji i gier w jednym, bezpiecznym miejscu, dostępnym z dowolnego miejsca w dowolnej chwili.`,
        reading_file: "Odczyt %strong%",
        recent: "Ostatnie",
        recommended: "Polecane",
        recover_password: "Odzyskaj hasło",
        refer_friends_c2a: "Zdobądź 1 GB za każdego znajomego, który założy konto na Puter! On również otrzyma 1 GB.",
        refer_friends_social_media_c2a: `Zdobądź 1 GB darmowego miejsca na Puter.com!`,
        refresh: 'Odśwież',
        release_address_confirmation: `Jesteś pewien, że chcesz wypuścić ten adres?`,
        remove_from_taskbar:'Usuń z paska zadań',
        rename: 'Zmień nazwę',
        repeat: 'Powtarzaj',
        replace: 'Zamień',
        replace_all: 'Zamień wszystkie',
        resend_confirmation_code: "Wyślij kod potwierdzający ponownie.",
        reset_colors: "Przywróc kolory",
        restart_puter_confirm: "Na pewno zrestartować Puter?",
        restore: "Odzyskaj",
        save: 'Zapisz',
        saturation: 'Nasycenie',
        save_account: 'Zapisz konto',
        save_account_to_get_copy_link: "Zapisz konto, aby uzyskać link do skopiowania",
        save_account_to_publish: 'Zapisz konto, aby opublikować',
        save_session: 'Zapisz sesję',
        save_session_c2a: 'Stwórz konto, żeby zapisać aktualną sesję i nie utracić swojej pracy.',
        scan_qr_c2a: 'Zeskanuj poniższy kod, aby zalogować się do tej sesji z innego urządzenia.',
        scan_qr_2fa: 'Zeskanuj kod QR za pomocą apki autentykującej',
        scan_qr_generic: 'Zeskanuj ten kod QR za pomocą swojego telefonu albo innego urządzenia',
        search: 'Szukaj',
        seconds: 'sekund',
        security: "Bezpieczeństwo",
        select: "Wybierz",
        selected: 'Wybrany',
        select_color: 'Wybierz kolor…',
        sessions: "Sesje",
        send: "Wyślij",
        send_password_recovery_email: "Wyślij email do odzyskania hasła",
        session_saved: "Dziękujemy za stworzenie konta. Ta sesja została zapisana. ",
        settings: "Ustawienia",
        set_new_password: "Ustaw nowe hasło.",
        share: "Udostępnij",
        share_to: "Udostępnij do",
        share_with: "Udostępnij dla:",
        shortcut_to: "Skrót do",
        show_all_windows: "Pokaż wszystkie okna",
        show_hidden: 'Pokaż ukryte',
        sign_in_with_puter: "Zaloguj się z Puter",
        sign_up: "Zarejestruj się",
        signing_in: "Logowanie…",
        size: 'Rozmiar',
        skip: 'Pomiń',
        something_went_wrong: "Coś poszło nie tak.",
        sort_by: 'Sortuj',
        start: 'Start',
        status: "Status",
        storage_usage: "Wykorzystanie miejsca",
        storage_puter_used: 'wykorzystane przez Puter',
        taking_longer_than_usual: 'To trwa chwilę dłużej niż zwyklę. Prosimy poczekać...',
        task_manager: "Menedżer zadań",
        taskmgr_header_name: "Nazwa",
        taskmgr_header_status: "Status",
        taskmgr_header_type: "Typ",
        terms: "Warunki",
        text_document: 'Dokument tekstowy',
        tos_fineprint: `Klikając 'Stwórz darmowe konto' Zgadzasz się z {{link=terms}}Warunkami Obsługi{{/link}} i {{link=privacy}}Polityką Prywatności{{/link}}.`,
        transparency: "Przezroczystość",
        trash: 'Kosz',
        two_factor: 'Uwierzytelnianie dwuetapowe',
        two_factor_disabled: 'Uwierzytelnianie dwuetapowe zablokowane',
        two_factor_enabled: 'Uwierzytelnianie dwuetapowe odblokowane',
        type: 'Wpisz',
        type_confirm_to_delete_account: "Wpisz 'potwierdzam', aby skasować swoje konto.",
        ui_colors: "Kolory interfejsu użytkownika",
        ui_manage_sessions: "Menedżer sesji",
        ui_revoke: "Unieważnij",
        undo: 'Cofnij',
        unlimited: 'Nieograniczone',
        unzip: "Rozpakuj",
        upload: 'Wgraj',
        upload_here: 'Wgraj tutaj',
        usage: 'Wykorzystanie',
        username: "Nazwa użytkownika",
        username_changed: 'Nazwa użytkownika została zmieniona pomyślnie.',
        username_required: 'Nazwa użytkownika jest wymagana.',
        versions: "Wersje",
        videos: 'Wideo',
        visibility: 'Widoczność',
        yes: 'Tak',
        yes_release_it: 'Tak, Opublikuj',
        you_have_been_referred_to_puter_by_a_friend: "Zostałeś wspomniany od znajomego!",
        zip: "Spakuj",
        zipping_file: "Pakowanie %strong%",
        
        // === 2FA Setup ===
        setup2fa_1_step_heading: 'Otwórz swoją aplikację autentykującą',
        setup2fa_1_instructions: `
        Możesz użyć dowolnej aplikacji autentykującej, która wspiera protokół haseł jednorazowych opartych o czas (TOTP).
        Jest ich wiele, ale jeżeli nie masz pewności,
        <a target="_blank" href="https://authy.com/download">Authy</a>
        to solidny wybór dla systemów Android i iOS.
        `,
        setup2fa_2_step_heading: 'Zeskanuj kod QR',
        setup2fa_3_step_heading: 'Wprowadź 6-cyfrowy kod',
        setup2fa_4_step_heading: 'Skopiuj swoje kody odzyskiwania',
        setup2fa_4_instructions: `
        Te kody odzyskiwania są jedynym sposobem aby uzyskać dostęp do twojego konta jeżeli stracisz swój telefon lub nie jesteś w stanie użyć aplikacji autentykującej.
        Upewnij się, że przechowujesz je w bezpiecznym miejscu
        `,
        setup2fa_5_step_heading: 'Potwierdź ustawienia autentykacji dwuetapowej',
        setup2fa_5_confirmation_1: 'Zachowałem moje kody odzyskiwania w bezpiecznym miejscu',
        setup2fa_5_confirmation_2: 'Jestem gotów aby włączyć autentykację dwuetapową',
        setup2fa_5_button: 'Włącz autentykację dwuetapową',
        
        // === 2FA Login ===
        login2fa_otp_title: 'Wprowadź kod autentykacji dwuetapowej',
        login2fa_otp_instructions: 'Wprowadź 6-cyfrowy kod ze swojej aplikacji autentykującej.',
        login2fa_recovery_title: 'Wprowadź kod odzyskiwania',
        login2fa_recovery_instructions: 'Wprowadź jeden ze swoich kodów odzyskiwania aby uzyskać dostęp do swojego konta.',
        login2fa_use_recovery_code: 'Użyj kod odzyskiwania',
        login2fa_recovery_back: 'Powrót',
        login2fa_recovery_placeholder: 'XXXXXXXX',
        
        "change": 'Zmiana',
        "clock_visibility": 'Widoczność zegara',
        "plural_suffix": undefined, //In polish there is a ton of plural suffixes, so will be left empty eg Samochód (car) → Samochody (cars) and Pies (dog) → Psy (dogs)
        "reading": 'Odczyt %strong%', 
        "writing": 'Pisownia %strong%',
        "unzipping": 'Rozpakowanie %strong%',
        "sequencing": 'Kolejność %strong%',
        "zipping": 'Pakowanie %strong%',
        "Editor": 'Edytor',
        "Viewer": 'Widz',
        "People with access": 'Osoby z dostępem',
        "Share With…": 'Podziel się z',
        "Owner": 'właściciel',
        "You can't share with yourself.": 'Nie możesz dzielić się z samym sobą',
        "This user already has access to this item": 'Ten użytkownik ma już dostęp do tego elementu',

        "plural_suffix": '', // Leaving it empty, as the previous translator did
        "billing.change_payment_method": 'Zmień',
        "billing.cancel": 'Anuluj',
        "billing.download_invoice": 'Pobierz',
        "billing.payment_method": 'Metoda Płatności',
        "billing.payment_method_updated": 'Metoda płatności została zaktualizowana!',
        "billing.confirm_payment_method": 'Potwierdź Metodę Płatności',
        "billing.payment_history": 'Historia Płatności',
        "billing.refunded": 'Zwrócono',
        "billing.paid": 'Opłacono',
        "billing.ok": 'OK',
        "billing.resume_subscription": 'Wznów Subskrypcję',
        "billing.subscription_cancelled": 'Twoja subskrypcja została anulowana',
        "billing.subscription_cancelled_description": 'Dostęp do Twojej subskrypcji będzie możliwy do końca tego okresu rozliczeniowego.',
        "billing.offering.free": 'Darmowy',
        "billing.offering.pro": 'Pro',
        "billing.offering.business": 'Dla Firm',
        "billing.cloud_storage": 'Pamięć w Chmurze',
        "billing.ai_access": 'Możliwość Dostępu do AI',
        "billing.bandwidth": 'Przepustowość',
        "billing.apps_and_games": 'Aplikacji i Gier', // "1000s of Apps & Games"
        "billing.upgrade_to_pro": 'Rozszerz na plan %strong%',
        "billing.switch_to": 'Zmień na plan %strong%',
        "billing.payment_setup": 'Ustawienia Płatności',
        "billing.back": 'Wstecz',
        "billing.you_are_now_subscribed_to": 'Obecnie subskrybujesz plan %strong%',
        "billing.you_are_now_subscribed_to_without_tier": 'Jesteś teraz subskrybentem',
        "billing.subscription_cancellation_confirmation": 'Czy na pewno chcesz anulować subskrypcję?',
        "billing.subscription_setup": 'Ustawienia Subskrypcji',
        "billing.cancel_it": 'Anuluj To',
        "billing.keep_it": 'Zachowaj To',
        "billing.subscription_resumed": 'Twoja subskrypcja obejmująca plan %strong% została wznowiona',
        "billing.upgrade_now": 'Ulepsz Teraz',
        "billing.upgrade": 'Ulepsz',
        "billing.currently_on_free_plan": 'Obecnie korzystasz z darmowego planu.',
        "billing.download_receipt": 'Pobierz Potwierdzenie',
        "billing.subscription_check_error": 'Wystąpił błąd podczas sprawdzania stanu Twojej subskrypcji.',
        "billing.email_confirmation_needed": 'Twój adres e-mail nie został potwierdzony. Wyślemy Ci kod, aby potwierdzić go teraz.',
        "billing.sub_cancelled_but_valid_until": 'Twoja subskrypcja została anulowana i po zakończeniu okresu rozliczeniowego zostanie automatycznie zmieniona na plan darmowy. Opłata nie zostanie naliczona ponownie, dopóki nie dokonasz ponownej subskrypcji.',
        "billing.current_plan_until_end_of_period": 'Twój obecny plan do końca tego okresu rozliczeniowego.',
        "billing.current_plan": 'Twój obecny plan',
        "billing.cancelled_subscription_tier": 'Anulowana Subskrypcja (%%)',
        "billing.manage": 'Zarządzaj',
        "billing.limited": 'Ograniczona',       // \
        "billing.expanded": 'Rozszerzona',      //  -> These adjectives are used to describe the "AI Access" and/or "Bandwidth"
        "billing.accelerated": 'Przyspieszona', // /
        "billing.enjoy_msg": 'Ciesz się pakietem %% pamięci w chmurze i innymi benefitami',
    }
};

export default pl;
