/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const nl = {
	name: 'Nederlands',
	english_name: 'Dutch',
	code: 'nl',
	dictionary: {
		about: 'Over',
		account: 'Account',
		account_password: 'Verifieer Account Wachtwoord',
		access_granted_to: 'Toegang gegeven aan',
		add_existing_account: 'Bestaand Account Toevoegen',
		all_fields_required: 'Alle velden zijn vereist.',
		allow: 'Toestaan',
		apply: 'Toepassen',
		ascending: 'Oplopend',
		associated_websites: 'Geassocieerde Websites',
		auto_arrange: 'Automatisch sorteren',
		background: 'Achtergrond',
		browse: 'Bladeren',
		cancel: 'Annuleren',
		center: 'Centreren',
		change_desktop_background: 'Bureaubladachtergrond veranderen…',
		change_email: 'E-mail Wijzigen',
		change_language: 'Taal veranderen',
		change_password: 'Wachtwoord veranderen',
		change_ui_colors: 'UI Kleuren veranderen',
		change_username: 'Gebruikersnaam veranderen',
		close: 'Sluiten',
		close_all_windows: 'Alle vensters sluiten',
		close_all_windows_confirm: 'Weet u zeker dat u alle vensters wilt sluiten?',
		close_all_windows_and_log_out: 'Vensters sluiten en afmelden',
		change_always_open_with: 'Wilt u dit bestandstype altijd openen met',
		color: 'Kleur',
		confirm: 'Bevestig',
		confirm_2fa_setup: 'Ik heb de code toegevoegd aan mijn authenticatie-app',
		confirm_2fa_recovery: 'Ik heb mijn herstelcodes op een veilige plaats opgeslagen',
		confirm_account_for_free_referral_storage_c2a: 'Maak een account aan en bevestig uw e-mailadres om 1 GB gratis opslag te ontvangen. Uw vriend krijgt ook 1 GB gratis opslag.',
		confirm_code_generic_incorrect: 'Onjuiste code.',
		confirm_code_generic_too_many_requests: 'Te veel aanvragen. Wacht een paar minuten.',
		confirm_code_generic_submit: 'Code invoeren',
		confirm_code_generic_try_again: 'Probeer opnieuw',
		confirm_code_generic_title: 'Bevestigingscode Invoeren',
		confirm_code_2fa_instruction: 'Voer de 6-cijferige code in van uw authenticatie-app.',
		confirm_code_2fa_submit_btn: 'Verzenden',
		confirm_code_2fa_title: 'Voer 2FA Code In',
		confirm_delete_multiple_items: 'Weet u zeker dat u deze items permanent wilt verwijderen?',
		confirm_delete_single_item: 'Wilt u dit item permanent verwijderen?',
		confirm_open_apps_log_out: 'U heeft geopende apps. Weet u zeker dat u wilt uitloggen?',
		confirm_new_password: 'Bevestig Nieuw Wachtwoord',
		confirm_delete_user: 'Weet u zeker dat u uw account wilt verwijderen? Al uw bestanden en gegevens worden permanent verwijderd. Deze actie kan niet ongedaan worden gemaakt.',
		confirm_delete_user_title: 'Account Verwijderen?',
		confirm_session_revoke: 'Weet u zeker dat u deze sessie wilt intrekken?',
		confirm_your_email_address: 'Bevestig Uw E-mailadres',
		contact_us: 'Neem Contact Op',
		contact_us_verification_required: 'U moet een geverifieerd e-mailadres hebben om dit te gebruiken.',
		contain: 'Bevatten',
		continue: 'Doorgaan',
		copy: 'Kopiëren',
		copy_link: 'Link Kopiëren',
		copying: 'Kopiëren',
		copying_file: 'Bestand Kopiëren %%',
		cover: 'Omslag',
		create_account: 'Account Aanmaken',
		create_free_account: 'Gratis Account Aanmaken',
		create_shortcut: 'Snelkoppeling Maken',
		credits: 'Credits',
		current_password: 'Huidig Wachtwoord',
		cut: 'Knippen',
		clock: 'Klok',
		clock_visible_hide: 'Verbergen - Altijd verborgen',
		clock_visible_show: 'Weergeven - Altijd zichtbaar',
		clock_visible_auto: 'Auto - Standaard, alleen zichtbaar in de volledige schermmodus.',
		close_all: 'Alles Sluiten',
		created: 'Gemaakt',
		date_modified: 'Datum Gewijzigd',
		default: 'Standaard',
		delete: 'Verwijderen',
		delete_account: 'Account Verwijderen',
		delete_permanently: 'Permanent Verwijderen',
		deleting_file: 'Bestand Verwijderen %%',
		deploy_as_app: 'Uitrollen als app',
		descending: 'Aflopend',
		desktop: 'Bureaublad',
		desktop_background_fit: 'Aanpassen',
		developers: 'Ontwikkelaars',
		dir_published_as_website: `%strong% is gepubliceerd op:`,
		disable_2fa: '2FA Uitschakelen',
		disable_2fa_confirm: 'Weet u zeker dat u 2FA wilt uitschakelen?',
		disable_2fa_instructions: 'Voer uw wachtwoord in om 2FA uit te schakelen.',
		disassociate_dir: 'Map Loskoppelen',
		documents: 'Documenten',
		dont_allow: 'Niet Toestaan',
		download: 'Downloaden',
		download_file: 'Bestand Downloaden',
		downloading: 'Downloaden',
		email: 'E-mail',
		email_change_confirmation_sent: 'Er is een bevestigingsmail gestuurd naar uw nieuwe e-mailadres. Controleer uw inbox en volg de instructies om het proces te voltooien.',
		email_invalid: 'E-mail is ongeldig.',
		email_or_username: 'E-mail of Gebruikersnaam',
		email_required: 'E-mail is verplicht.',
		empty_trash: 'Prullenbak Leegmaken',
		empty_trash_confirmation: `Weet u zeker dat u de items in de prullenbak permanent wilt verwijderen?`,
		emptying_trash: 'Prullenbak Legen…',
		enable_2fa: '2FA Inschakelen',
		end_hard: 'Hard Stoppen',
		end_process_force_confirm: 'Weet u zeker dat u dit proces geforceerd wilt beëindigen?',
		end_soft: 'Zacht Stoppen',
		enlarged_qr_code: 'Vergrote QR Code',
		enter_password_to_confirm_delete_user: 'Voer uw wachtwoord in om de verwijdering van het account te bevestigen',
		error_message_is_missing: 'Foutbericht ontbreekt.',
		error_unknown_cause: 'Er is een onbekende fout opgetreden.',
		error_uploading_files: 'Bestanden uploaden mislukt',
		favorites: 'Favorieten',
		feedback: 'Feedback',
		feedback_c2a: 'Gebruik het onderstaande formulier om ons uw feedback, opmerkingen en bugrapporten te sturen.',
		feedback_sent_confirmation: 'Bedankt dat u contact met ons heeft opgenomen. Als u een e-mail heeft gekoppeld aan uw account, hoort u zo snel mogelijk van ons.',
		fit: 'Aanpassen',
		folder: 'Map',
		force_quit: 'Geforceerd Stoppen',
		forgot_pass_c2a: 'Wachtwoord vergeten?',
		from: 'Van',
		general: 'Algemeen',
		get_a_copy_of_on_puter: `Krijg een kopie van '%%' op Puter.com!`,
		get_copy_link: 'Krijg Kopieerlink',
		hide_all_windows: 'Alle Vensters Verbergen',
		home: 'Home',
		html_document: 'HTML-document',
		hue: 'Tint',
		image: 'Afbeelding',
		incorrect_password: 'Onjuist wachtwoord',
		invite_link: 'Uitnodigingslink',
		item: 'item',
		items_in_trash_cannot_be_renamed: `Dit item kan niet worden hernoemd omdat het in de prullenbak zit. Om dit item te hernoemen, sleept u het eerst uit de prullenbak.`,
		jpeg_image: 'JPEG-afbeelding',
		keep_in_taskbar: 'In Taakbalk Houden',
		language: 'Taal',
		license: 'Licentie',
		lightness: 'Helderheid',
		link_copied: 'Link gekopieerd',
		loading: 'Laden',
		log_in: 'Inloggen',
		log_into_another_account_anyway: 'Log toch in op een ander account',
		log_out: 'Uitloggen',
		looks_good: 'Ziet er goed uit!',
		manage_sessions: 'Sessies Beheren',
		menubar_style: 'Menubalk Stijl',
		menubar_style_desktop: 'Bureaublad',
		menubar_style_system: 'Systeem',
		menubar_style_window: 'Venster',
		mobile_device: 'Mobiel apparaat',
		modified: 'Gewijzigd',
		move: 'Verplaatsen',
		moving_file: 'Verplaatsen %%',
		my_websites: 'Mijn Websites',
		name: 'Naam',
		name_cannot_be_empty: 'Naam kan niet leeg zijn.',
		name_cannot_contain_double_period: 'Naam mag geen dubbele punt \'..\' bevatten.',
		name_cannot_contain_period: 'Naam mag geen punt \' . \' bevatten.',
		name_cannot_contain_slash: 'Naam mag geen schuine streep \' / \' bevatten.',
		name_must_be_string: 'Naam moet een alfanumerieke tekenreeks zijn.',
		name_too_long: 'Naam mag niet langer zijn dan %% karakters.',
		new: 'Nieuw',
		new_email: 'Nieuwe E-mail',
		new_folder: 'Nieuwe Map',
		new_password: 'Nieuw Wachtwoord',
		new_username: 'Nieuwe Gebruikersnaam',
		no: 'Nee',
		no_dir_associated_with_site: 'Geen map geassocieerd met dit adres.',
		no_websites_published: 'Je hebt nog geen websites gepubliceerd. Klik met de rechtermuisknop op een map om te beginnen.',
		ok: 'OK',
		open: 'Openen',
		open_in_new_tab: 'Openen in Nieuw Tabblad',
		open_in_new_window: 'Openen in Nieuw Venster',
		open_with: 'Openen met',
		original_name: 'Originele Naam',
		original_path: 'Origineel Pad',
		oss_code_and_content: 'Open Source Software Code en Inhoud',
		password: 'Wachtwoord',
		password_changed: 'Wachtwoord gewijzigd',
		password_recovery_rate_limit: 'U heeft te veel verzoeken ingediend. Wacht een paar minuten voordat u het opnieuw probeert.',
		password_recovery_token_invalid: 'Wachtwoord hersteltoken is verlopen of ongeldig.',
		password_recovery_unknown_error: 'Onbekende fout opgetreden bij het herstellen van het wachtwoord. Probeer het opnieuw.',
		password_required: 'Wachtwoord is verplicht.',
		password_strength_error: 'Wachtwoord moet minimaal 8 tekens lang zijn en minimaal één hoofdletter, één kleine letter, één cijfer en één speciaal teken bevatten.',
		passwords_do_not_match: 'Wachtwoorden komen niet overeen.',
		paste: 'Plakken',
		paste_into_folder: 'Plakken in Map',
		path: 'Pad',
		personalization: 'Personalisatie',
		pick_name_for_website: 'Kies een naam voor uw website',
		picture: 'Afbeelding',
		pictures: 'Afbeeldingen',
		plural_suffix: 'en',
		powered_by_puter_js: 'Aangedreven door {{link=docs}}Puter.js{{/link}}',
		preparing: 'Voorbereiden...',
		preparing_for_upload: 'Voorbereiden voor upload...',
		print: 'Afdrukken',
		privacy: 'Privacy',
		proceed_to_login: 'Doorgaan naar inloggen',
		proceed_with_account_deletion: 'Doorgaan met accountverwijdering',
		process_status_initializing: 'Initialiseren',
		process_status_running: 'Bezig',
		process_type_app: 'App',
		process_type_init: 'Init',
		process_type_ui: 'UI',
		properties: 'Eigenschappen',
		public: 'Openbaar',
		publish: 'Publiceren',
		publish_as_website: 'Publiceer als website',
		puter_description: `Puter is een privacy-first persoonlijke cloud om al je bestanden, apps en games op één veilige plek te bewaren, overal en altijd toegankelijk.`,
		reading_file: 'Lezen %strong%',
		recent: 'Recent',
		recommended: 'Aanbevolen',
		recover_password: 'Wachtwoord herstellen',
		refer_friends_c2a: 'Krijg 1 GB voor elke vriend die een account aanmaakt en bevestigt op Puter. Je vriend krijgt ook 1 GB!',
		refer_friends_social_media_c2a: `Krijg 1 GB gratis opslagruimte op Puter.com!`,
		refresh: 'Vernieuwen',
		release_address_confirmation: `Weet je zeker dat je dit adres wilt vrijgeven?`,
		remove_from_taskbar: 'Verwijderen van taakbalk',
		rename: 'Hernoemen',
		repeat: 'Herhalen',
		replace: 'Vervangen',
		replace_all: 'Alles vervangen',
		resend_confirmation_code: 'Bevestigingscode opnieuw verzenden',
		reset_colors: 'Kleuren resetten',
		restart_puter_confirm: 'Weet je zeker dat je Puter wilt herstarten?',
		restore: 'Herstellen',
		save: 'Opslaan',
		saturation: 'Verzadiging',
		save_account: 'Account opslaan',
		save_account_to_get_copy_link: 'Maak een account aan om verder te gaan.',
		save_account_to_publish: 'Maak een account aan om verder te gaan.',
		save_session: 'Sessie opslaan',
		save_session_c2a: 'Maak een account aan om je huidige sessie op te slaan en verlies van werk te voorkomen.',
		scan_qr_c2a: 'Scan de onderstaande code\nom in te loggen op deze sessie vanaf andere apparaten',
		scan_qr_2fa: 'Scan de QR-code met je authenticator-app',
		scan_qr_generic: 'Scan deze QR-code met je telefoon of een ander apparaat',
		search: 'Zoeken',
		seconds: 'seconden',
		security: 'Beveiliging',
		select: 'Selecteren',
		selected: 'geselecteerd',
		select_color: 'Selecteer kleur…',
		sessions: 'Sessies',
		send: 'Verzenden',
		send_password_recovery_email: 'Wachtwoordherstelsmail verzenden',
		session_saved: 'Bedankt voor het aanmaken van een account. Deze sessie is opgeslagen.',
		settings: 'Instellingen',
		set_new_password: 'Nieuw wachtwoord instellen',
		share: 'Delen',
		share_to: 'Delen met',
		share_with: 'Delen met:',
		shortcut_to: 'Snelkoppeling naar',
		show_all_windows: 'Toon alle vensters',
		show_hidden: 'Toon verborgen',
		sign_in_with_puter: 'Inloggen met Puter',
		sign_up: 'Aanmelden',
		signing_in: 'Inloggen…',
		size: 'Grootte',
		skip: 'Overslaan',
		something_went_wrong: 'Er is iets misgegaan.',
		sort_by: 'Sorteren op',
		start: 'Start',
		status: 'Status',
		storage_usage: 'Opslaggebruik',
		storage_puter_used: 'gebruikt door Puter',
		taking_longer_than_usual: 'Het duurt langer dan normaal. Even geduld alstublieft...',
		task_manager: 'Taakbeheer',
		taskmgr_header_name: 'Naam',
		taskmgr_header_status: 'Status',
		taskmgr_header_type: 'Type',
		terms: 'Voorwaarden',
		text_document: 'Tekstdocument',
		tos_fineprint: `Door op 'Gratis Account Aanmaken' te klikken, ga je akkoord met de {{link=terms}}Servicevoorwaarden{{/link}} en de {{link=privacy}}Privacybeleid{{/link}} van Puter.`,
		transparency: 'Transparantie',
		trash: 'Prullenbak',
		two_factor: 'Tweestapsverificatie',
		two_factor_disabled: '2FA Uitgeschakeld',
		two_factor_enabled: '2FA Ingeschakeld',
		type: 'Type',
		type_confirm_to_delete_account: 'Typ \'bevestigen\' om je account te verwijderen.',
		ui_colors: 'UI Kleuren',
		ui_manage_sessions: 'Sessiebeheer',
		ui_revoke: 'Intrekken',
		undo: 'Ongedaan maken',
		unlimited: 'Onbeperkt',
		unzip: 'Uitpakken',
		upload: 'Uploaden',
		upload_here: 'Hier uploaden',
		usage: 'Gebruik',
		username: 'Gebruikersnaam',
		username_changed: 'Gebruikersnaam succesvol bijgewerkt.',
		username_required: 'Gebruikersnaam is vereist.',
		versions: 'Versies',
		videos: 'Video\'s',
		visibility: 'Zichtbaarheid',
		yes: 'Ja',
		yes_release_it: 'Ja, vrijgeven',
		you_have_been_referred_to_puter_by_a_friend: 'Je bent door een vriend doorverwezen naar Puter!',
		zip: 'Zip',
		zipping_file: 'Bestand inpakken %strong%',

		// === 2FA Setup ===
		setup2fa_1_step_heading: 'Open je authenticator-app',
		setup2fa_1_instructions: `
            Je kunt elke authenticator-app gebruiken die het Time-based One-Time Password (TOTP) protocol ondersteunt.
            Er zijn veel opties om uit te kiezen, maar als je twijfelt,
            <a target="_blank" href="https://authy.com/download">Authy</a>
            is een goede keuze voor Android en iOS.
        `,
		setup2fa_2_step_heading: 'Scan de QR-code',
		setup2fa_3_step_heading: 'Voer de 6-cijferige code in',
		setup2fa_4_step_heading: 'Kopieer je herstelcodes',
		setup2fa_4_instructions: `
            Deze herstelcodes zijn de enige manier om toegang te krijgen tot je account als je je telefoon kwijtraakt of je authenticator-app niet kunt gebruiken.
            Zorg ervoor dat je ze op een veilige plaats bewaart.
        `,
		setup2fa_5_step_heading: 'Bevestig 2FA-instelling',
		setup2fa_5_confirmation_1: 'Ik heb mijn herstelcodes op een veilige plaats opgeslagen',
		setup2fa_5_confirmation_2: 'Ik ben klaar om 2FA in te schakelen',
		setup2fa_5_button: '2FA inschakelen',

		// === 2FA Login ===
		login2fa_otp_title: 'Voer 2FA-code in',
		login2fa_otp_instructions: 'Voer de 6-cijferige code in uit je authenticator-app.',
		login2fa_recovery_title: 'Voer een herstelcode in',
		login2fa_recovery_instructions: 'Voer een van je herstelcodes in om toegang te krijgen tot je account.',
		login2fa_use_recovery_code: 'Gebruik een herstelcode',
		login2fa_recovery_back: 'Terug',
		login2fa_recovery_placeholder: 'XXXXXXXX',

		"change": 'Wijzig',
		"clock_visibility": 'Klok zichtbaarheid',
		"reading": 'Lezen %strong%',
		"writing": 'Schrijven %strong%',
		"unzipping": 'Decomprimeren %strong%',
		"sequencing": 'Alles op een rijtje aan het zetten %strong%',
		"zipping": 'Aan het comprimeren %strong%',
		"Editor": 'Redacteur',
		"Viewer": 'Kijker',
		"People with access": 'Mensen met toegang',
		"Share With…": 'Deel met...',
		"Owner": 'Eigenaar',
		"You can't share with yourself.": 'Je kan niet met jezelf delen.',
		"This user already has access to this item": 'De gebruiker heeft al toegang tot dit item',

		"billing.change_payment_method": 'Wijzig', // In English: 'Change"
        "billing.cancel": 'Annuleer', // In English: 'Cancel"
        "billing.download_invoice": 'Download', // In English: 'Download"
        "billing.payment_method": 'Betaalmethode', // In English: 'Payment Method"
        "billing.payment_method_updated": 'Betaalmethode bijgewerkt!', // In English: 'Payment method updated!"
        "billing.confirm_payment_method": 'Bevestig Betaalmethode', // In English: 'Confirm Payment Method"
        "billing.payment_history": 'Betaalgeschiedenis', // In English: 'Payment History"
        "billing.refunded": 'Terugbetaald', // In English: 'Refunded"
        "billing.paid": 'Betaald', // In English: 'Paid"
        "billing.ok": 'OK', // In English: 'OK"
        "billing.resume_subscription": 'Zet Abonnement voort', // In English: 'Resume Subscription"
        "billing.subscription_cancelled": 'Uw abonnement is stopgezet.', // In English: 'Your subscription has been canceled."
        "billing.subscription_cancelled_description": 'U behoudt toegang tot uw abonnement tot het einde van deze factureringsperiode.', // In English: 'You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": 'Gratis', // In English: 'Free"
        "billing.offering.pro": 'Professioneel', // In English: 'Professional"
        "billing.offering.business": 'Bedrijf', // In English: 'Business"
        "billing.cloud_storage": 'Cloudopslag', // In English: 'Cloud Storage"
        "billing.ai_access": 'AI Toegang', // In English: 'AI Access"
        "billing.bandwidth": 'Bandbreedte', // In English: 'Bandwidth"
        "billing.apps_and_games": 'Apps & Spelletjes', // In English: 'Apps & Games"
        "billing.upgrade_to_pro": 'Upgraden naar %strong%', // In English: 'Upgrade to %strong%"
        "billing.switch_to": 'Wissel naar %strong%', // In English: 'Switch to %strong%"
        "billing.payment_setup": 'Betaal', // In English: 'Payment Setup"
        "billing.back": 'Terug', // In English: 'Back"
        "billing.you_are_now_subscribed_to": 'U bent nu geabonneerd op de %strong% rang.', // In English: 'You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": 'U bent nu geabonneerd', // In English: 'You are now subscribed"
        "billing.subscription_cancellation_confirmation": 'Bent u zeker dat u uw abonnement wilt stopzetten?', // In English: 'Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": 'Abonnement Instellen ', // In English: 'Subscription Setup"
        "billing.cancel_it": 'Annuleer het', // In English: 'Cancel It"
        "billing.keep_it": 'Hou het', // In English: 'Keep It"
        "billing.subscription_resumed": 'Uw %strong% abonnement is voortgezet!', // In English: 'Your %strong% subscription has been resumed!"
        "billing.upgrade_now": 'Upgrade Nu', // In English: 'Upgrade Now"
        "billing.upgrade": 'Upgrade', // In English: 'Upgrade"
        "billing.currently_on_free_plan": 'U hebt momenteel het gratis abonnement.', // In English: 'You are currently on the free plan."
        "billing.download_receipt": 'Download Ontvangstbewijs', // In English: 'Download Receipt"
        "billing.subscription_check_error": 'Er is een probleem opgetreden bij het controleren van uw abonnementsstatus.', // In English: 'A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": 'Uw e-mail is nog niet bevestigd. We zullen u een code sturen om het te bevestigen.', // In English: 'Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": 'U hebt uw abonnement stopgezet en het zal automatisch overschakelen naar het gratis abonnement op het einde van deze factureringsperiode. Er worden geen kosten in rekening gebracht, tenzij u opnieuw abonneert.', // In English: 'You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": 'Uw huidige abonnement tot het einde van deze factureringsperiode.', // In English: 'Your current plan until the end of this billing period."
        "billing.current_plan": 'Huidige Abonnement', // In English: 'Current plan"
        "billing.cancelled_subscription_tier": 'Stop Abonnement', // In English: 'Cancelled Subscription (%%)"
        "billing.manage": 'Beheer', // In English: 'Manage"
        "billing.limited": 'Beperkt', // In English: 'Limited"
        "billing.expanded": 'Uitgebreid', // In English: 'Expanded"
        "billing.accelerated": 'Versneld', // In English: 'Accelerated"
        "billing.enjoy_msg": 'Geniet %% van Cloudopslag en meer voordelen.', // In English: 'Enjoy %% of Cloud Storage plus other benefits."
	}
};

export default nl;
