/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const nb = {
    name: "Norsk Bokmål",
    english_name: "Norwegian Bokmål",
    code: "nb",
    dictionary: {
        access_granted_to: "Tilgang gitt til",
        add_existing_account: "Legg til eksisterende konto",
        all_fields_required: "Alle felt er obligatoriske.",
        apply: "Bruk",
        ascending: "Stigende",
        background: "Bakgrunn",
        browse: "Bla gjennom",
        cancel: "Avbryt",
        center: "Sentrer",
        change_desktop_background: "Endre skrivebordsbakgrunn…",
        change_language: "Endre språk",
        change_password: "Endre passord",
        change_username: "Endre brukernavn",
        close_all_windows: "Lukk alle vinduer",
        close_all_windows_and_log_out: 'Lukk alle vinduer og logg ut',
        change_always_open_with: "Ønsker du å alltid åpne denne filtypen med",
        color: "Farge",
        confirm_account_for_free_referral_storage_c2a: "Opprett en konto og bekreft e-postadressen din for å motta 1 GB gratis lagringsplass. Din venn vil også få 1 GB gratis lagringsplass.",
        confirm_delete_multiple_items: 'Er du sikker på at du vil slette disse elementene permanent?',
        confirm_delete_single_item: 'Er du sikker på at du vil slette dette elemente permanent?',
        confirm_open_apps_log_out: 'Du har åpene apper, er du sikker på at du vil logge ut?',
        confirm_new_password: "Bekreft nytt passord",
        contact_us: "Kontakt oss",
        contain: "Inneholde",
        continue: "Fortsett",
        copy: "Kopier",
        copy_link: "Kopier lenke",
        copying: "Kopierer",
        cover: "Dekke",
        create_account: "Opprett konto",
        create_free_account: "Opprett gratis konto",
        create_shortcut: "Opprett snarvei",
        current_password: "Nåværende passord",
        cut: "Klipp ut",
        date_modified: "Endret dato",
        delete: "Slett",
        delete_permanently: "Slett permanent",
        deploy_as_app: "Distribuer som app",
        descending: "Synkende",
        desktop_background_fit: "Tilpass",
        dir_published_as_website: "%strong% er publisert på:",
        disassociate_dir: "Fjern tilknytning fra mappe",
        download: "Last ned",
        download_file: 'Last ned fil',
        downloading: "Laster ned",
        email: "E-post",
        email_or_username: "E-post eller brukernavn",
        empty_trash: "Tøm papirkurv",
        empty_trash_confirmation: "Er du sikker på at du vil slette alt i papirkurven permanent?",
        emptying_trash: "Tømmer papirkurv…",
        feedback: "Tilbakemelding",
        feedback_c2a: "Vennligst bruk skjemaet nedenfor for å sende oss din tilbakemelding, kommentarer og feilrapporter.",
        feedback_sent_confirmation: "Takk for at du kontaktet oss. Hvis du har en e-post knyttet til kontoen din, vil du høre fra oss så snart som mulig.",
        forgot_pass_c2a: "Glemt passord?",
        from: "Fra",
        general: "Generelt",
        get_a_copy_of_on_puter: "Få en kopi av '%%' på Puter.com!",
        get_copy_link: "Få kopilenke",
        hide_all_windows: "Skjul alle vinduer",
        html_document: "HTML-dokument",
        image: "Bilde",
        invite_link: "Invitasjonslenke",
        item: 'element',
        items_in_trash_cannot_be_renamed: "Dette elementet kan ikke omdøpes fordi det er i papirkurven. For å omdøpe dette elementet, dra det først ut av papirkurven.",
        jpeg_image: "JPEG-bilde",
        keep_in_taskbar: "Behold i oppgavelinjen",
        loading: 'Laster',
        log_in: "Logg inn",
        log_into_another_account_anyway: 'Logg inn på en annen bruker uansett',
        log_out: "Logg ut",
        move: "Flytt",
        moving_file: "Flytter %%",
        my_websites: "Mine nettsteder",
        name: "Navn",
        name_cannot_be_empty: "Navn kan ikke være tomt.",
        name_cannot_contain_double_period: "Navn kan ikke inneholde '..'.",
        name_cannot_contain_period: "Navn kan ikke inneholde '.'-tegnet.",
        name_cannot_contain_slash: "Navn kan ikke inneholde '/'-tegnet.",
        name_must_be_string: "Navn kan bare være en streng.",
        name_too_long: "Navn kan ikke være lengre enn %% tegn.",
        new: "Ny",
        new_folder: "Ny mappe",
        new_password: "Nytt passord",
        new_username: "Nytt brukernavn",
        no: 'Nei',
        no_dir_associated_with_site: "Ingen mappe er tilknyttet denne adressen.",
        no_websites_published: "Du har ikke publisert noen nettsteder ennå.",
        ok: "OK",
        open: "Åpne",
        open_in_new_tab: "Åpne i ny fane",
        open_in_new_window: "Åpne i nytt vindu",
        open_with: "Åpne med",
        password: "Passord",
        password_changed: "Passord endret.",
        passwords_do_not_match: "`Nytt passord` og `Bekreft nytt passord` stemmer ikke overens.",
        paste: "Lim inn",
        paste_into_folder: "Lim inn i mappe",
        pick_name_for_website: "Velg et navn for nettstedet ditt:",
        picture: "Bilde",
        powered_by_puter_js: "Drevet av {{link=docs}}Puter.js{{/link}}",
        preparing: "Forbereder...",
        preparing_for_upload: "Forbereder opplasting...",
        properties: "Egenskaper",
        proceed_to_login: 'Fortsett til innlogging',
        publish: "Publiser",
        publish_as_website: "Publiser som nettsted",
        plural_suffix: 'er',
        recent: "Nylig",
        recover_password: "Gjenopprett passord",
        refer_friends_c2a: "Få 1 GB for hver venn som oppretter og bekrefter en konto på Puter. Vennen din får også 1 GB.",
        refer_friends_social_media_c2a: "Få 1 GB gratis lagringsplass på Puter.com!",
        refresh: "Oppdater",
        release_address_confirmation: "Er du sikker på at du vil frigi denne adressen?",
        remove_from_taskbar: "Fjern fra oppgavelinjen",
        rename: "Gi nytt navn",
        repeat: "Gjenta",
        replace: 'Erstatt',
        replace_all: 'Erstatt alle',
        resend_confirmation_code: "Send bekreftelseskoden på nytt",
        restore: "Gjenopprett",
        save_account: 'Lagre konto',
        save_account_to_get_copy_link: "Vennligst opprett en konto for å fortsette.",
        save_account_to_publish: "Vennligst opprett en konto for å fortsette.",
        save_session: 'Lagre økt',
        save_session_c2a: "Opprett en konto for å lagre gjeldende økt og unngå å miste arbeidet ditt.",
        scan_qr_c2a: "Skann koden nedenfor for å logge inn på denne økten fra andre enheter",
        select: "Velg",
        selected: 'valgt',
        select_color: "Velg farge…",
        send: "Send",
        send_password_recovery_email: "Send e-post for gjenoppretting av passord",
        session_saved: "Takk for at du opprettet en konto. Denne økten er lagret.",
        set_new_password: "Angi nytt passord",
        share_to: "Del",
        show_all_windows: "Vis alle vinduer",
        show_hidden: "Vis skjulte",
        sign_in_with_puter: "Logg inn med Puter",
        sign_up: "Registrer deg",
        signing_in: "Logger inn…",
        size: "Størrelse",
        skip: 'Hopp over',
        sort_by: "Sorter etter",
        start: "Start",
        taking_longer_than_usual: "Dette tar litt lenger tid enn vanlig. Vennligst vent...",
        text_document: "Tekstdokument",
        tos_fineprint: "Ved å klikke på 'Opprett gratis konto' godtar du Puters {{link=terms}}tjenestevilkår{{/link}} og {{link=privacy}}personvernpolicy{{/link}}.",
        trash: "Papirkurv",
        type: "Type",
        undo: "Angre",
        unzip: "Pakk ut",
        upload: "Last opp",
        upload_here: "Last opp her",
        username: "Brukernavn",
        username_changed: "Brukernavn oppdatert.",
        versions: "Versjoner",
        yes_release_it: "Ja, frigi den",
        yes: 'ja',
        you_have_been_referred_to_puter_by_a_friend: "Du har blitt henvist til Puter av en venn!",
        zip: "Zip",

		// ***********************************
		// Missing translations
		// ***********************************
        "about": undefined, // In English: "About"
        "account": undefined, // In English: "Account"
        "account_password": undefined, // In English: "Verify Account Password"
        "allow": undefined, // In English: "Allow"
        "associated_websites": undefined, // In English: "Associated Websites"
        "auto_arrange": undefined, // In English: "Auto Arrange"
        "change": undefined, // In English: "Change"
        "change_email": undefined, // In English: "Change Email"
        "change_ui_colors": undefined, // In English: "Change UI Colors"
        "clock_visibility": undefined, // In English: "Clock Visibility"
        "close": undefined, // In English: "Close"
        "close_all_windows_confirm": undefined, // In English: "Are you sure you want to close all windows?"
        "confirm": undefined, // In English: "Confirm"
        "confirm_2fa_setup": undefined, // In English: "I have added the code to my authenticator app"
        "confirm_2fa_recovery": undefined, // In English: "I have saved my recovery codes in a secure location"
        "confirm_code_generic_incorrect": undefined, // In English: "Incorrect Code."
        "confirm_code_generic_too_many_requests": undefined, // In English: "Too many requests. Please wait a few minutes."
        "confirm_code_generic_submit": undefined, // In English: "Submit Code"
        "confirm_code_generic_try_again": undefined, // In English: "Try Again"
        "confirm_code_generic_title": undefined, // In English: "Enter Confirmation Code"
        "confirm_code_2fa_instruction": undefined, // In English: "Enter the 6-digit code from your authenticator app."
        "confirm_code_2fa_submit_btn": undefined, // In English: "Submit"
        "confirm_code_2fa_title": undefined, // In English: "Enter 2FA Code"
        "confirm_delete_user": undefined, // In English: "Are you sure you want to delete your account? All your files and data will be permanently deleted. This action cannot be undone."
        "confirm_delete_user_title": undefined, // In English: "Delete Account?"
        "confirm_session_revoke": undefined, // In English: "Are you sure you want to revoke this session?"
        "confirm_your_email_address": undefined, // In English: "Confirm Your Email Address"
        "contact_us_verification_required": undefined, // In English: "You must have a verified email address to use this."
        "copying_file": undefined, // In English: "Copying %%"
        "credits": undefined, // In English: "Credits"
        "clock": undefined, // In English: "Clock"
        "clock_visible_hide": undefined, // In English: "Hide - Always hidden"
        "clock_visible_show": undefined, // In English: "Show - Always visible"
        "clock_visible_auto": undefined, // In English: "Auto - Default, visible only in full-screen mode."
        "close_all": undefined, // In English: "Close All"
        "created": undefined, // In English: "Created"
        "default": undefined, // In English: "Default"
        "delete_account": undefined, // In English: "Delete Account"
        "deleting_file": undefined, // In English: "Deleting %%"
        "desktop": undefined, // In English: "Desktop"
        "developers": undefined, // In English: "Developers"
        "disable_2fa": undefined, // In English: "Disable 2FA"
        "disable_2fa_confirm": undefined, // In English: "Are you sure you want to disable 2FA?"
        "disable_2fa_instructions": undefined, // In English: "Enter your password to disable 2FA."
        "documents": undefined, // In English: "Documents"
        "dont_allow": undefined, // In English: "Don't Allow"
        "email_change_confirmation_sent": undefined, // In English: "A confirmation email has been sent to your new email address. Please check your inbox and follow the instructions to complete the process."
        "email_invalid": undefined, // In English: "Email is invalid."
        "email_required": undefined, // In English: "Email is required."
        "enable_2fa": undefined, // In English: "Enable 2FA"
        "end_hard": undefined, // In English: "End Hard"
        "end_process_force_confirm": undefined, // In English: "Are you sure you want to force-quit this process?"
        "end_soft": undefined, // In English: "End Soft"
        "enlarged_qr_code": undefined, // In English: "Enlarged QR Code"
        "enter_password_to_confirm_delete_user": undefined, // In English: "Enter your password to confirm account deletion"
        "error_message_is_missing": undefined, // In English: "Error message is missing."
        "error_unknown_cause": undefined, // In English: "An unknown error occurred."
        "error_uploading_files": undefined, // In English: "Failed to upload files"
        "favorites": undefined, // In English: "Favorites"
        "fit": undefined, // In English: "Fit"
        "folder": undefined, // In English: "Folder"
        "force_quit": undefined, // In English: "Force Quit"
        "home": undefined, // In English: "Home"
        "hue": undefined, // In English: "Hue"
        "incorrect_password": undefined, // In English: "Incorrect password"
        "language": undefined, // In English: "Language"
        "license": undefined, // In English: "License"
        "lightness": undefined, // In English: "Lightness"
        "link_copied": undefined, // In English: "Link copied"
        "looks_good": undefined, // In English: "Looks good!"
        "manage_sessions": undefined, // In English: "Manage Sessions"
        "menubar_style": undefined, // In English: "Menubar Style"
        "menubar_style_desktop": undefined, // In English: "Desktop"
        "menubar_style_system": undefined, // In English: "System"
        "menubar_style_window": undefined, // In English: "Window"
        "modified": undefined, // In English: "Modified"
        "new_email": undefined, // In English: "New Email"
        "original_name": undefined, // In English: "Original Name"
        "original_path": undefined, // In English: "Original Path"
        "oss_code_and_content": undefined, // In English: "Open Source Software and Content"
        "password_recovery_rate_limit": undefined, // In English: "You've reached our rate-limit; please wait a few minutes. To prevent this in the future, avoid reloading the page too many times."
        "password_recovery_token_invalid": undefined, // In English: "This password recovery token is no longer valid."
        "password_recovery_unknown_error": undefined, // In English: "An unknown error occurred. Please try again later."
        "password_required": undefined, // In English: "Password is required."
        "password_strength_error": undefined, // In English: "Password must be at least 8 characters long and contain at least one uppercase letter, one lowercase letter, one number, and one special character."
        "path": undefined, // In English: "Path"
        "personalization": undefined, // In English: "Personalization"
        "pictures": undefined, // In English: "Pictures"
        "print": undefined, // In English: "Print"
        "privacy": undefined, // In English: "Privacy"
        "proceed_with_account_deletion": undefined, // In English: "Proceed with Account Deletion"
        "process_status_initializing": undefined, // In English: "Initializing"
        "process_status_running": undefined, // In English: "Running"
        "process_type_app": undefined, // In English: "App"
        "process_type_init": undefined, // In English: "Init"
        "process_type_ui": undefined, // In English: "UI"
        "public": undefined, // In English: "Public"
        "puter_description": undefined, // In English: "Puter is a privacy-first personal cloud to keep all your files, apps, and games in one secure place, accessible from anywhere at any time."
        "reading": undefined, // In English: "Reading %strong%"
        "writing": undefined, // In English: "Writing %strong%"
        "recommended": undefined, // In English: "Recommended"
        "reset_colors": undefined, // In English: "Reset Colors"
        "restart_puter_confirm": undefined, // In English: "Are you sure you want to restart Puter?"
        "save": undefined, // In English: "Save"
        "saturation": undefined, // In English: "Saturation"
        "scan_qr_2fa": undefined, // In English: "Scan the QR code with your authenticator app"
        "scan_qr_generic": undefined, // In English: "Scan this QR code using your phone or another device"
        "search": undefined, // In English: "Search"
        "seconds": undefined, // In English: "seconds"
        "security": undefined, // In English: "Security"
        "sessions": undefined, // In English: "Sessions"
        "settings": undefined, // In English: "Settings"
        "share": undefined, // In English: "Share"
        "share_with": undefined, // In English: "Share with:"
        "shortcut_to": undefined, // In English: "Shortcut to"
        "something_went_wrong": undefined, // In English: "Something went wrong."
        "status": undefined, // In English: "Status"
        "storage_usage": undefined, // In English: "Storage Usage"
        "storage_puter_used": undefined, // In English: "used by Puter"
        "task_manager": undefined, // In English: "Task Manager"
        "taskmgr_header_name": undefined, // In English: "Name"
        "taskmgr_header_status": undefined, // In English: "Status"
        "taskmgr_header_type": undefined, // In English: "Type"
        "terms": undefined, // In English: "Terms"
        "transparency": undefined, // In English: "Transparency"
        "two_factor": undefined, // In English: "Two Factor Authentication"
        "two_factor_disabled": undefined, // In English: "2FA Disabled"
        "two_factor_enabled": undefined, // In English: "2FA Enabled"
        "type_confirm_to_delete_account": undefined, // In English: "Type 'confirm' to delete your account."
        "ui_colors": undefined, // In English: "UI Colors"
        "ui_manage_sessions": undefined, // In English: "Session Manager"
        "ui_revoke": undefined, // In English: "Revoke"
        "unlimited": undefined, // In English: "Unlimited"
        "unzipping": undefined, // In English: "Unzipping %strong%"
        "usage": undefined, // In English: "Usage"
        "username_required": undefined, // In English: "Username is required."
        "videos": undefined, // In English: "Videos"
        "visibility": undefined, // In English: "Visibility"
        "sequencing": undefined, // In English: "Sequencing %strong%"
        "zipping": undefined, // In English: "Zipping %strong%"
        "setup2fa_1_step_heading": undefined, // In English: "Open your authenticator app"
        "setup2fa_1_instructions": undefined, // In English: "
                //     You can use any authenticator app that supports the Time-based One-Time Password (TOTP) protocol.
                //     There are many to choose from, but if you're unsure
                //     <a target="_blank" href="https://authy.com/download">Authy</a>
                //     is a solid choice for Android and iOS.
                // "
        "setup2fa_2_step_heading": undefined, // In English: "Scan the QR code"
        "setup2fa_3_step_heading": undefined, // In English: "Enter the 6-digit code"
        "setup2fa_4_step_heading": undefined, // In English: "Copy your recovery codes"
        "setup2fa_4_instructions": undefined, // In English: "
                //     These recovery codes are the only way to access your account if you lose your phone or can't use your authenticator app.
                //     Make sure to store them in a safe place.
                // "
        "setup2fa_5_step_heading": undefined, // In English: "Confirm 2FA setup"
        "setup2fa_5_confirmation_1": undefined, // In English: "I have saved my recovery codes in a secure location"
        "setup2fa_5_confirmation_2": undefined, // In English: "I am ready to enable 2FA"
        "setup2fa_5_button": undefined, // In English: "Enable 2FA"
        "login2fa_otp_title": undefined, // In English: "Enter 2FA Code"
        "login2fa_otp_instructions": undefined, // In English: "Enter the 6-digit code from your authenticator app."
        "login2fa_recovery_title": undefined, // In English: "Enter a recovery code"
        "login2fa_recovery_instructions": undefined, // In English: "Enter one of your recovery codes to access your account."
        "login2fa_use_recovery_code": undefined, // In English: "Use a recovery code"
        "login2fa_recovery_back": undefined, // In English: "Back"
        "login2fa_recovery_placeholder": undefined, // In English: "XXXXXXXX"
        "Editor": undefined, // In English: "Editor"
        "Viewer": undefined, // In English: "Viewer"
        "People with access": undefined, // In English: "People with access"
        "Share With…": undefined, // In English: "Share With…"
        "Owner": undefined, // In English: "Owner"
        "You can't share with yourself.": undefined, // In English: "You can't share with yourself."
        "This user already has access to this item": undefined, // In English: "This user already has access to this item"

        "billing.change_payment_method": undefined, // In English: "Change"
        "billing.cancel": undefined, // In English: "Cancel"
        "billing.download_invoice": undefined, // In English: "Download"
        "billing.payment_method": undefined, // In English: "Payment Method"
        "billing.payment_method_updated": undefined, // In English: "Payment method updated!"
        "billing.confirm_payment_method": undefined, // In English: "Confirm Payment Method"
        "billing.payment_history": undefined, // In English: "Payment History"
        "billing.refunded": undefined, // In English: "Refunded"
        "billing.paid": undefined, // In English: "Paid"
        "billing.ok": undefined, // In English: "OK"
        "billing.resume_subscription": undefined, // In English: "Resume Subscription"
        "billing.subscription_cancelled": undefined, // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": undefined, // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": undefined, // In English: "Free"
        "billing.offering.pro": undefined, // In English: "Professional"
        "billing.offering.business": undefined, // In English: "Business"
        "billing.cloud_storage": undefined, // In English: "Cloud Storage"
        "billing.ai_access": undefined, // In English: "AI Access"
        "billing.bandwidth": undefined, // In English: "Bandwidth"
        "billing.apps_and_games": undefined, // In English: "Apps & Games"
        "billing.upgrade_to_pro": undefined, // In English: "Upgrade to %strong%"
        "billing.switch_to": undefined, // In English: "Switch to %strong%"
        "billing.payment_setup": undefined, // In English: "Payment Setup"
        "billing.back": undefined, // In English: "Back"
        "billing.you_are_now_subscribed_to": undefined, // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": undefined, // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": undefined, // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": undefined, // In English: "Subscription Setup"
        "billing.cancel_it": undefined, // In English: "Cancel It"
        "billing.keep_it": undefined, // In English: "Keep It"
        "billing.subscription_resumed": undefined, // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": undefined, // In English: "Upgrade Now"
        "billing.upgrade": undefined, // In English: "Upgrade"
        "billing.currently_on_free_plan": undefined, // In English: "You are currently on the free plan."
        "billing.download_receipt": undefined, // In English: "Download Receipt"
        "billing.subscription_check_error": undefined, // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": undefined, // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": undefined, // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": undefined, // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": undefined, // In English: "Current plan"
        "billing.cancelled_subscription_tier": undefined, // In English: "Cancelled Subscription (%%)"
        "billing.manage": undefined, // In English: "Manage"
        "billing.limited": undefined, // In English: "Limited"
        "billing.expanded": undefined, // In English: "Expanded"
        "billing.accelerated": undefined, // In English: "Accelerated"
        "billing.enjoy_msg": undefined, // In English: "Enjoy %% of Cloud Storage plus other benefits."

    }
};

export default nb;