/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const ml = {
    name: "മലയാളം",
    english_name: "Malayalam",
    code: "ml",
    dictionary: {
        about: "കുറിച്ച്",
        account: "അക്കൗണ്ട്",
        account_password: "അക്കൗണ്ട് പാസ്‌വേഡ് പരിശോധിക്കുക",
        access_granted_to: "പ്രവേശനം അനുവദിച്ചിരിക്കുന്നത്",
        add_existing_account: "നിലവിലുള്ള അക്കൗണ്ട് ചേർക്കുക",
        all_fields_required: 'എല്ലാ ഫീൽഡുകളും ആവശ്യമാണ്.',
        allow: 'അനുവദിക്കുക',
        apply: "പ്രയോഗിക്കുക",
        ascending: 'ആരോഹണം',
        associated_websites: "ബന്ധപ്പെട്ട വെബ്സൈറ്റുകൾ",
        auto_arrange: 'സ്വയം ക്രമീകരിക്കുക',
        background: "പശ്ചാത്തലം",
        browse: "ബ്രൗസ് ചെയ്യുക",
        cancel: 'റദ്ദാക്കുക',
        center: 'മധ്യം',
        change: 'മാറ്റുക',
        change_always_open_with: "ഈ തരത്തിലുള്ള ഫയൽ എപ്പോഴും ഇതുപയോഗിച്ച് തുറക്കണോ",
        change_desktop_background: 'ഡെസ്ക്ടോപ്പ് പശ്ചാത്തലം മാറ്റുക…',
        change_email: "ഇമെയിൽ മാറ്റുക",
        change_language: "ഭാഷ മാറ്റുക",
        change_password: "പാസ്‌വേഡ് മാറ്റുക",
        change_ui_colors: "UI നിറങ്ങൾ മാറ്റുക",
        change_username: "ഉപയോക്തൃനാമം മാറ്റുക",
        clock_visibility: 'ക്ലോക്ക് ദൃശ്യത',
        close: 'അടയ്ക്കുക',
        close_all_windows: "എല്ലാ വിൻഡോകളും അടയ്ക്കുക",
        close_all_windows_confirm: "എല്ലാ വിൻഡോകളും അടയ്ക്കണമെന്ന് തീർച്ചയാണോ?",
        close_all_windows_and_log_out: 'വിൻഡോകൾ അടച്ച് ലോഗ്ഔട്ട് ചെയ്യുക',
        color: 'നിറം',
        confirm: 'സ്ഥിരീകരിക്കുക',
        confirm_2fa_setup: 'ഞാൻ കോഡ് എന്റെ ഓതന്റിക്കേറ്റർ ആപ്പിലേക്ക് ചേർത്തു',
        confirm_2fa_recovery: 'ഞാൻ എന്റെ റിക്കവറി കോഡുകൾ സുരക്ഷിതമായി സംരക്ഷിച്ചു',
        confirm_account_for_free_referral_storage_c2a: '1 GB സൗജന്യ സ്റ്റോറേജ് ലഭിക്കാൻ ഒരു അക്കൗണ്ട് സൃഷ്ടിച്ച് നിങ്ങളുടെ ഇമെയിൽ സ്ഥിരീകരിക്കുക. നിങ്ങളുടെ സുഹൃത്തിനും 1 GB സൗജന്യ സ്റ്റോറേജ് ലഭിക്കും.',
        confirm_code_generic_incorrect: "തെറ്റായ കോഡ്.",
        confirm_code_generic_too_many_requests: "വളരെയധികം അഭ്യർത്ഥനകൾ. കുറച്ച് മിനിറ്റുകൾ കാത്തിരിക്കുക.",
        confirm_code_generic_submit: "കോഡ് സമർപ്പിക്കുക",
        confirm_code_generic_try_again: "വീണ്ടും ശ്രമിക്കുക",
        confirm_code_generic_title: "സ്ഥിരീകരണ കോഡ് നൽകുക",
        confirm_code_2fa_instruction: "നിങ്ങളുടെ ഓതന്റിക്കേറ്റർ ആപ്പിൽ നിന്നുള്ള 6-അക്ക കോഡ് നൽകുക.",
        confirm_code_2fa_submit_btn: "സമർപ്പിക്കുക",
        confirm_code_2fa_title: "2FA കോഡ് നൽകുക",
        confirm_delete_multiple_items: 'ഈ ഇനങ്ങൾ സ്ഥിരമായി ഇല്ലാതാക്കണമെന്ന് തീർച്ചയാണോ?',
        confirm_delete_single_item: 'ഈ ഇനം സ്ഥിരമായി ഇല്ലാതാക്കണമെന്ന് ആഗ്രഹിക്കുന്നുവോ?',
        confirm_open_apps_log_out: 'നിങ്ങൾക്ക് തുറന്ന ആപ്പുകളുണ്ട്. ലോഗ്ഔട്ട് ചെയ്യണമെന്ന് തീർച്ചയാണോ?',
        confirm_new_password: "പുതിയ പാസ്‌വേഡ് സ്ഥിരീകരിക്കുക",
        confirm_delete_user: "നിങ്ങളുടെ അക്കൗണ്ട് ഇല്ലാതാക്കണമെന്ന് തീർച്ചയാണോ? നിങ്ങളുടെ എല്ലാ ഫയലുകളും ഡാറ്റയും സ്ഥിരമായി ഇല്ലാതാക്കപ്പെടും. ഈ പ്രവർത്തി പിന്നീട് പഴയപടിയാക്കാൻ കഴിയില്ല.",
        confirm_delete_user_title: "അക്കൗണ്ട് ഇല്ലാതാക്കണോ?",
        confirm_session_revoke: "ഈ സെഷൻ റദ്ദാക്കണമെന്ന് തീർച്ചയാണോ?",
        confirm_your_email_address: "നിങ്ങളുടെ ഇമെയിൽ വിലാസം സ്ഥിരീകരിക്കുക",
        contact_us: "ഞങ്ങളെ ബന്ധപ്പെടുക",
        contact_us_verification_required: "ഇത് ഉപയോഗിക്കാൻ നിങ്ങൾക്ക് സ്ഥിരീകരിച്ച ഇമെയിൽ വിലാസം ഉണ്ടായിരിക്കണം.",
        contain: 'ഉൾക്കൊള്ളുക',
        continue: "തുടരുക",
        copy: 'പകർത്തുക',
        copy_link: "ലിങ്ക് പകർത്തുക",
        copying: "പകർത്തുന്നു",
        copying_file: "%% പകർത്തുന്നു",
        cover: 'പൂർണമായി കാണിക്കുക',
        create_account: "അക്കൗണ്ട് സൃഷ്ടിക്കുക",
        create_free_account: "സൗജന്യ അക്കൗണ്ട് സൃഷ്ടിക്കുക",
        create_shortcut: "ഷോർട്ട്കട്ട് സൃഷ്ടിക്കുക",
        credits: "ക്രെഡിറ്റുകൾ",
        current_password: "നിലവിലെ പാസ്‌വേഡ്",
        cut: 'മുറിക്കുക',
        clock: "ക്ലോക്ക്",
        clock_visible_hide: 'മറയ്ക്കുക - എപ്പോഴും മറഞ്ഞിരിക്കും',
        clock_visible_show: 'കാണിക്കുക - എപ്പോഴും ദൃശ്യമായിരിക്കും',
        clock_visible_auto: 'സ്വയം - സ്ഥിരസ്ഥിതി, പൂർണ്ണ സ്ക്രീൻ മോഡിൽ മാത്രം ദൃശ്യമാകും.',
        close_all: 'എല്ലാം അടയ്ക്കുക',
        created: 'സൃഷ്ടിച്ചത്',
        date_modified: 'മാറ്റം വരുത്തിയ തീയതി',
        default: 'സ്ഥിരസ്ഥിതി',
        delete: 'ഇല്ലാതാക്കുക',
        delete_account: "അക്കൗണ്ട് ഇല്ലാതാക്കുക",
        delete_permanently: "സ്ഥിരമായി ഇല്ലാതാക്കുക",
        deleting_file: "%% ഇല്ലാതാക്കുന്നു",
        deploy_as_app: 'ആപ്പായി വിന്യസിക്കുക',
        descending: 'അവരോഹണം',
        desktop: 'ഡെസ്ക്ടോപ്പ്',
        desktop_background_fit: "ഫിറ്റ്",
        developers: "ഡെവലപ്പർമാർ",
        dir_published_as_website: `%strong% എന്നതിലേക്ക് പ്രസിദ്ധീകരിച്ചിരിക്കുന്നു:`,
        disable_2fa: '2FA പ്രവർത്തനരഹിതമാക്കുക',
        disable_2fa_confirm: "2FA പ്രവർത്തനരഹിതമാക്കണമെന്ന് തീർച്ചയാണോ?",
        disable_2fa_instructions: "2FA പ്രവർത്തനരഹിതമാക്കാൻ നിങ്ങളുടെ പാസ്‌വേഡ് നൽകുക.",
        disassociate_dir: "ഡയറക്ടറി ബന്ധം വിച്ഛേദിക്കുക",
        documents: 'രേഖകൾ',
        dont_allow: 'അനുവദിക്കരുത്',
        download: 'ഡൗൺലോഡ്',
        download_file: 'ഫയൽ ഡൗൺലോഡ് ചെയ്യുക',
        downloading: "ഡൗൺലോഡ് ചെയ്യുന്നു",
        email: "ഇമെയിൽ",
        email_change_confirmation_sent: "നിങ്ങളുടെ പുതിയ ഇമെയിൽ വിലാസത്തിലേക്ക് ഒരു സ്ഥിരീകരണ ഇമെയിൽ അയച്ചിട്ടുണ്ട്. ദയവായി നിങ്ങളുടെ ഇൻബോ" ,
        email_invalid: 'ഇമെയിൽ അസാധുവാണ്.',
        email_or_username: "ഇമെയിൽ അല്ലെങ്കിൽ ഉപയോക്തൃനാമം",
        email_required: 'ഇമെയിൽ ആവശ്യമാണ്.',
        empty_trash: 'ട്രാഷ് ശൂന്യമാക്കുക',
        empty_trash_confirmation: `ട്രാഷിലെ ഇനങ്ങൾ സ്ഥിരമായി ഇല്ലാതാക്കണമെന്ന് തീർച്ചയാണോ?`,
        emptying_trash: 'ട്രാഷ് ശൂന്യമാക്കുന്നു…',
        enable_2fa: '2FA പ്രവർത്തനക്ഷമമാക്കുക',
        end_hard: "കഠിനമായി അവസാനിപ്പിക്കുക",
        end_process_force_confirm: "ഈ പ്രക്രിയ നിർബന്ധിച്ച് അവസാനിപ്പിക്കണമെന്ന് തീർച്ചയാണോ?",
        end_soft: "സൗമ്യമായി അവസാനിപ്പിക്കുക",
        enlarged_qr_code: "വലുതാക്കിയ QR കോഡ്",
        enter_password_to_confirm_delete_user: "അക്കൗണ്ട് ഇല്ലാതാക്കൽ സ്ഥിരീകരിക്കാൻ നിങ്ങളുടെ പാസ്‌വേഡ് നൽകുക",
        error_message_is_missing: "പിശക് സന്ദേശം കാണുന്നില്ല.",
        error_unknown_cause: "അജ്ഞാതമായ ഒരു പിശക് സംഭവിച്ചു.",
        error_uploading_files: "ഫയലുകൾ അപ്‌ലോഡ് ചെയ്യുന്നതിൽ പരാജയപ്പെട്ടു",
        favorites: "പ്രിയപ്പെട്ടവ",
        feedback: "പ്രതികരണം",
        feedback_c2a: "നിങ്ങളുടെ പ്രതികരണം, അഭിപ്രായങ്ങൾ, ബഗ് റിപ്പോർട്ടുകൾ എന്നിവ അയയ്ക്കാൻ താഴെയുള്ള ഫോം ഉപയോഗിക്കുക.",
        feedback_sent_confirmation: "ഞങ്ങളെ ബന്ധപ്പെട്ടതിന് നന്ദി. നിങ്ങളുടെ അക്കൗണ്ടുമായി ബന്ധപ്പെട്ട ഒരു ഇമെയിൽ ഉണ്ടെങ്കിൽ, കഴിയുന്നത്ര വേഗം നിങ്ങൾക്ക് മറുപടി ലഭിക്കും.",
        fit: "ഫിറ്റ്",
        folder: 'ഫോൾഡർ',
        force_quit: 'നിർബന്ധിത നിർത്തൽ',
        forgot_pass_c2a: "പാസ്‌വേഡ് മറന്നുപോയോ?",
        from: "എവിടെ നിന്ന്",
        general: "പൊതുവായത്",
        get_a_copy_of_on_puter: `Puter.com-ൽ '%%' എന്നതിന്റെ ഒരു പകർപ്പ് നേടുക!`,
        get_copy_link: 'പകർപ്പ് ലിങ്ക് നേടുക',
        hide_all_windows: "എല്ലാ വിൻഡോകളും മറയ്ക്കുക",
        home: 'ഹോം',
        html_document: 'HTML ഡോക്യുമെന്റ്',
        hue: 'ഹ്യൂ',
        image: 'ചിത്രം',
        incorrect_password: "തെറ്റായ പാസ്‌വേഡ്",
        invite_link: "ക്ഷണിക്കൽ ലിങ്ക്",
        item: 'ഇനം',
        items_in_trash_cannot_be_renamed: `ഈ ഇനം ട്രാഷിലായതിനാൽ പേരുമാറ്റാൻ കഴിയില്ല. ഈ ഇനത്തിന്റെ പേരുമാറ്റാൻ, ആദ്യം ഇത് ട്രാഷിൽ നിന്ന് പുറത്തെടുക്കുക.`,
        jpeg_image: 'JPEG ചിത്രം',
        keep_in_taskbar: 'ടാസ്ക്ബാറിൽ നിലനിർത്തുക',
        language: "ഭാഷ",
        license: "ലൈസൻസ്",
        lightness: 'പ്രകാശം',
        link_copied: "ലിങ്ക് പകർത്തി",
        loading: 'ലോഡ് ചെയ്യുന്നു',
        log_in: "ലോഗിൻ",
        log_into_another_account_anyway: 'എന്നിട്ടും മറ്റൊരു അക്കൗണ്ടിലേക്ക് ലോഗിൻ ചെയ്യുക',
        log_out: 'ലോഗ്ഔട്ട്',
        looks_good: "നന്നായിരിക്കുന്നു!",
        manage_sessions: "സെഷനുകൾ കൈകാര്യം ചെയ്യുക",
        menubar_style: "മെനുബാർ ശൈലി",
        menubar_style_desktop: "ഡെസ്ക്ടോപ്പ്",
        menubar_style_system: "സിസ്റ്റം",
        menubar_style_window: "വിൻഡോ",
        modified: 'പരിഷ്കരിച്ചത്',
        move: 'നീക്കുക',
        moving_file: "%% നീക്കുന്നു",
        my_websites: "എന്റെ വെബ്സൈറ്റുകൾ",
        name: 'പേര്',
        name_cannot_be_empty: 'പേര് ശൂന്യമായിരിക്കാൻ പാടില്ല.',
        name_cannot_contain_double_period: "പേര് '..' ആയിരിക്കാൻ പാടില്ല.",
        name_cannot_contain_period: "പേര് '.' ആയിരിക്കാൻ പാടില്ല.",
        name_cannot_contain_slash: "പേരിൽ '/' അടങ്ങിയിരിക്കാൻ പാടില്ല.",
        name_must_be_string: "പേര് ഒരു സ്ട്രിംഗ് മാത്രമേ ആകാവൂ.",
        name_too_long: `പേര് %% അക്ഷരങ്ങളിൽ കൂടുതൽ നീളമുള്ളതാകാൻ പാടില്ല.`,
        new: 'പുതിയത്',
        new_email: 'പുതിയ ഇമെയിൽ',
        new_folder: 'പുതിയ ഫോൾഡർ',
        new_password: "പുതിയ പാസ്‌വേഡ്",
        new_username: "പുതിയ ഉപയോക്തൃനാമം",
        no: 'അല്ല',
        no_dir_associated_with_site: 'ഈ വിലാസവുമായി ബന്ധപ്പെട്ട ഡയറക്ടറി ഇല്ല.',
        no_websites_published: "നിങ്ങൾ ഇതുവരെ വെബ്സൈറ്റുകളൊന്നും പ്രസിദ്ധീകരിച്ചിട്ടില്ല. ആരംഭിക്കാൻ ഒരു ഫോൾഡറിൽ റൈറ്റ് ക്ലിക്ക് ചെയ്യുക.",
        ok: 'ശരി',
        open: "തുറക്കുക",
        open_in_new_tab: "പുതിയ ടാബിൽ തുറക്കുക",
        open_in_new_window: "പുതിയ വിൻഡോയിൽ തുറക്കുക",
        open_with: "ഇതുപയോഗിച്ച് തുറക്കുക",
        original_name: 'യഥാർത്ഥ പേര്',
        original_path: 'യഥാർത്ഥ പാത',
        oss_code_and_content: "ഓപ്പൺ സോഴ്സ് സോഫ്റ്റ്‌വെയറും ഉള്ളടക്കവും",
        password: "പാസ്‌വേഡ്",
        password_changed: "പാസ്‌വേഡ് മാറ്റി.",
        password_recovery_rate_limit: "നിങ്ങൾ പരിധി കവിഞ്ഞു; ദയവായി കുറച്ച് മിനിറ്റുകൾ കാത്തിരിക്കുക. ഭാവിയിൽ ഇത് ഒഴിവാക്കാൻ, പേജ് വളരെയധികം തവണ റീലോഡ് ചെയ്യുന്നത് ഒഴിവാക്കുക.",
        password_recovery_token_invalid: "ഈ പാസ്‌വേഡ് റിക്കവറി ടോക്കൺ ഇനി സാധുവല്ല.",
        password_recovery_unknown_error: "അജ്ഞാതമായ ഒരു പിശക് സംഭവിച്ചു. ദയവായി പിന്നീട് വീണ്ടും ശ്രമിക്കുക.",
        password_required: 'പാസ്‌വേഡ് ആവശ്യമാണ്.',
        password_strength_error: "പാസ്‌വേഡിൽ കുറഞ്ഞത് 8 അക്ഷരങ്ങൾ, ഒരു അപ്പർകേസ് അക്ഷരം, ഒരു ലോവർകേസ് അക്ഷരം, ഒരു അക്കം, ഒരു പ്രത്യേക അക്ഷരം എന്നിവ ഉണ്ടായിരിക്കണം.",
        passwords_do_not_match: '`പുതിയ പാസ്‌വേഡ്` ഉം `പുതിയ പാസ്‌വേഡ് സ്ഥിരീകരിക്കുക` യും പൊരുത്തപ്പെടുന്നില്ല.',
        paste: 'പേസ്റ്റ്',
        paste_into_folder: "ഫോൾഡറിലേക്ക് പേസ്റ്റ് ചെയ്യുക",
        path: 'പാത',
        personalization: "വ്യക്തിഗതമാക്കൽ",
        pick_name_for_website: "നിങ്ങളുടെ വെബ്സൈറ്റിന് ഒരു പേര് തിരഞ്ഞെടുക്കുക:",
        picture: "ചിത്രം",
        pictures: 'ചിത്രങ്ങൾ',
        plural_suffix: 'കൾ',
        powered_by_puter_js: `{{link=docs}}Puter.js{{/link}} ഉപയോഗിച്ച് നിർമ്മിച്ചത്`,
        preparing: "തയ്യാറാക്കുന്നു...",
        preparing_for_upload: "അപ്‌ലോഡിനായി തയ്യാറാക്കുന്നു...",
        print: 'പ്രിന്റ്',
        privacy: "സ്വകാര്യത",
        proceed_to_login: 'ലോഗിനിലേക്ക് പോകുക',
        proceed_with_account_deletion: "അക്കൗണ്ട് ഇല്ലാതാക്കൽ തുടരുക",
        process_status_initializing: "ആരംഭിക്കുന്നു",
        process_status_running: "പ്രവർത്തിക്കുന്നു",
        process_type_app: 'ആപ്പ്',
        process_type_init: 'ആരംഭം',
        process_type_ui: 'UI',
        properties: "സവിശേഷതകൾ",
        public: 'പൊതു',
        publish: "പ്രസിദ്ധീകരിക്കുക",
        publish_as_website: 'വെബ്സൈറ്റായി പ്രസിദ്ധീകരിക്കുക',
        puter_description: `പ്യൂട്ടർ എന്നത് നിങ്ങളുടെ എല്ലാ ഫയലുകളും, ആപ്പുകളും, ഗെയിമുകളും ഒരു സുരക്ഷിത സ്ഥലത്ത് സൂക്ഷിക്കാനുള്ള സ്വകാര്യത കേന്ദ്രീകരിച്ച വ്യക്തിഗത ക്ലൗഡ് ആണ്, ഏത് സമയത്തും എവിടെ നിന്നും ആക്സസ് ചെയ്യാൻ കഴിയും.`,
        reading: "%strong% വായിക്കുന്നു",
        writing: "%strong% എഴുതുന്നു",
        recent: "സമീപകാലം",
        recommended: "ശുപാർശ ചെയ്തവ",
        recover_password: "പാസ്‌വേഡ് വീണ്ടെടുക്കുക",
        refer_friends_c2a: "അക്കൗണ്ട് സൃഷ്ടിച്ച് സ്ഥിരീകരിക്കുന്ന ഓരോ സുഹൃത്തിനും 1 GB നേടുക. നിങ്ങളുടെ സുഹൃത്തിനും 1 GB ലഭിക്കും!",
        refer_friends_social_media_c2a: `Puter.com-ൽ 1 GB സൗജന്യ സ്റ്റോറേജ് നേടുക!`,
        refresh: 'പുതുക്കുക',
        release_address_confirmation: `ഈ വിലാസം വിട്ടുകൊടുക്കണമെന്ന് തീർച്ചയാണോ?`,
        remove_from_taskbar: 'ടാസ്ക്ബാറിൽ നിന്ന് നീക്കം ചെയ്യുക',
        rename: 'പേരുമാറ്റുക',
        repeat: 'ആവർത്തിക്കുക',
        replace: 'മാറ്റിസ്ഥാപിക്കുക',
        replace_all: 'എല്ലാം മാറ്റിസ്ഥാപിക്കുക',
        resend_confirmation_code: "സ്ഥിരീകരണ കോഡ് വീണ്ടും അയയ്ക്കുക",
        reset_colors: "നിറങ്ങൾ പുനഃക്രമീകരിക്കുക",
        restart_puter_confirm: "പ്യൂട്ടർ റീസ്റ്റാർട്ട് ചെയ്യണമെന്ന് തീർച്ചയാണോ?",
        restore: "പുനഃസ്ഥാപിക്കുക",
        save: 'സംരക്ഷിക്കുക',
        saturation: 'സാച്ചുറേഷൻ',
        save_account: 'അക്കൗണ്ട് സംരക്ഷിക്കുക',
        save_account_to_get_copy_link: "തുടരുന്നതിന് ദയവായി ഒരു അക്കൗണ്ട് സൃഷ്ടിക്കുക.",
        save_account_to_publish: 'തുടരുന്നതിന് ദയവായി ഒരു അക്കൗണ്ട് സൃഷ്ടിക്കുക.',
        save_session: 'സെഷൻ സംരക്ഷിക്കുക',
        save_session_c2a: 'നിങ്ങളുടെ നിലവിലെ സെഷൻ സംരക്ഷിക്കാനും ജോലി നഷ്ടപ്പെടുന്നത് ഒഴിവാക്കാനും ഒരു അക്കൗണ്ട് സൃഷ്ടിക്കുക.',
        scan_qr_c2a: 'മറ്റ് ഉപകരണങ്ങളിൽ നിന്ന് ഈ സെഷനിലേക്ക് ലോഗിൻ ചെയ്യാൻ\nതാഴെയുള്ള കോഡ് സ്കാൻ ചെയ്യുക',
        scan_qr_2fa: 'നിങ്ങളുടെ ഓതന്റിക്കേറ്റർ ആപ്പ് ഉപയോഗിച്ച് QR കോഡ് സ്കാൻ ചെയ്യുക',
        scan_qr_generic: 'നിങ്ങളുടെ ഫോൺ അല്ലെങ്കിൽ മറ്റൊരു ഉപകരണം ഉപയോഗിച്ച് ഈ QR കോഡ് സ്കാൻ ചെയ്യുക',
        search: 'തിരയുക',
        seconds: 'സെക്കൻഡുകൾ',
        security: "സുരക്ഷ",
        select: "തിരഞ്ഞെടുക്കുക",
        selected: 'തിരഞ്ഞെടുത്തു',
        select_color: 'നിറം തിരഞ്ഞെടുക്കുക…',
        sessions: "സെഷനുകൾ",
        send: "അയയ്ക്കുക",
        send_password_recovery_email: "പാസ്‌വേഡ് വീണ്ടെടുക്കൽ ഇമെയിൽ അയയ്ക്കുക",
        session_saved: "ഒരു അക്കൗണ്ട് സൃഷ്ടിച്ചതിന് നന്ദി. ഈ സെഷൻ സംരക്ഷിച്ചിരിക്കുന്നു.",
        settings: "ക്രമീകരണങ്ങൾ",
        set_new_password: "പുതിയ പാസ്‌വേഡ് സജ്ജമാക്കുക",
        share: "പങ്കുവയ്ക്കുക",
        share_to: "ഇതിലേക്ക് പങ്കുവയ്ക്കുക",
        share_with: "ഇവരുമായി പങ്കുവയ്ക്കുക:",
        shortcut_to: "ഷോർട്ട്കട്ട്",
        show_all_windows: "എല്ലാ വിൻഡോകളും കാണിക്കുക",
        show_hidden: 'മറഞ്ഞിരിക്കുന്നവ കാണിക്കുക',
        sign_in_with_puter: "പ്യൂട്ടർ ഉപയോഗിച്ച് സൈൻ ഇൻ ചെയ്യുക",
        sign_up: "സൈൻ അപ്പ്",
        signing_in: "സൈൻ ഇൻ ചെയ്യുന്നു…",
        size: 'വലുപ്പം',
        skip: 'ഒഴിവാക്കുക',
        something_went_wrong: "എന്തോ തെറ്റ് സംഭവിച്ചു.",
        sort_by: 'ഇതനുസരിച്ച് അടുക്കുക',
        start: 'ആരംഭിക്കുക',
        status: "നില",
        storage_usage: "സ്റ്റോറേജ് ഉപയോഗം",
        storage_puter_used: 'പ്യൂട്ടർ ഉപയോഗിച്ചത്',
        taking_longer_than_usual: 'സാധാരണയേക്കാൾ കൂടുതൽ സമയമെടുക്കുന്നു. ദയവായി കാത്തിരിക്കുക...',
        task_manager: "ടാസ്ക് മാനേജർ",
        taskmgr_header_name: "പേര്",
        taskmgr_header_status: "നില",
        taskmgr_header_type: "തരം",
        terms: "നിബന്ധനകൾ",
        text_document: 'ടെക്സ്റ്റ് ഡോക്യുമെന്റ്',
        tos_fineprint: `'സൗജന്യ അക്കൗണ്ട് സൃഷ്ടിക്കുക' ക്ലിക്ക് ചെയ്യുന്നതിലൂടെ നിങ്ങൾ പ്യൂട്ടറിന്റെ {{link=terms}}സേവന നിബന്ധനകളും{{/link}} {{link=privacy}}സ്വകാര്യതാ നയവും{{/link}} അംഗീകരിക്കുന്നു.`,
        transparency: "സുതാര്യത",
        trash: 'ട്രാഷ്',
        two_factor: 'രണ്ട് ഘടക പ്രമാണീകരണം',
        two_factor_disabled: '2FA പ്രവർത്തനരഹിതമാക്കി',
        two_factor_enabled: '2FA പ്രവർത്തനക്ഷമമാക്കി',
        type: 'തരം',
        type_confirm_to_delete_account: "നിങ്ങളുടെ അക്കൗണ്ട് ഇല്ലാതാക്കാൻ 'confirm' എന്ന് ടൈപ്പ് ചെയ്യുക.",
        ui_colors: "UI നിറങ്ങൾ",
        ui_manage_sessions: "സെഷൻ മാനേജർ",
        ui_revoke: "റദ്ദാക്കുക",
        undo: 'പഴയപടിയാക്കുക',
        unlimited: 'പരിധിയില്ലാത്തത്',
        unzip: "അൺസിപ്പ്",
        unzipping: "%strong% അൺസിപ്പ് ചെയ്യുന്നു",
        upload: 'അപ്‌ലോഡ്',
        upload_here: 'ഇവിടെ അപ്‌ലോഡ് ചെയ്യുക',
        usage: 'ഉപയോഗം',
        username: "ഉപയോക്തൃനാമം",
        username_changed: 'ഉപയോക്തൃനാമം വിജയകരമായി പുതുക്കി.',
        username_required: 'ഉപയോക്തൃനാമം ആവശ്യമാണ്.',
        versions: "പതിപ്പുകൾ",
        videos: 'വീഡിയോകൾ',
        visibility: 'ദൃശ്യത',
        yes: 'അതെ',
        yes_release_it: 'അതെ, വിട്ടുകൊടുക്കുക',
        you_have_been_referred_to_puter_by_a_friend: "ഒരു സുഹൃത്ത് നിങ്ങളെ പ്യൂട്ടറിലേക്ക് റഫർ ചെയ്തിരിക്കുന്നു!",
        zip: "സിപ്പ്",
        sequencing: "%strong% ക്രമപ്പെടുത്തുന്നു",
        zipping: "%strong% സിപ്പ് ചെയ്യുന്നു",

        // === 2FA Setup ===
        setup2fa_1_step_heading: 'നിങ്ങളുടെ ഓതന്റിക്കേറ്റർ ആപ്പ് തുറക്കുക',
        setup2fa_1_instructions: `
        നിങ്ങളുടെ അക്കൗണ്ടിൽ ടൈം-ബേസ്ഡ് വൺ-ടൈം പാസ്‌വേർഡ് (TOTP) പ്രോട്ടോക്കോൾ പിന്തുണക്കുന്ന ഏതെങ്കിലും ഓതന്റിക്കേറ്റർ ആപ്പ് ഉപയോഗിക്കാം.
        ഉപയോഗിക്കാൻ പറ്റിയവയിൽ നിങ്ങൾക്കു സംശയമുണ്ടെങ്കിൽ, 
        <a target="_blank" href="https://authy.com/download">Authy</a>
        ആൻഡ്രോയിഡ്, ഐഒഎസ് ഉപയോക്താക്കൾക്ക് നല്ലൊരു തിരഞ്ഞെടുപ്പാണ്.
    `,
    setup2fa_2_step_heading: 'QR കോഡ് സ്കാൻ ചെയ്യുക',
    setup2fa_3_step_heading: '6-അക്കം ഉള്ള കോഡ് നൽകുക',
    setup2fa_4_step_heading: 'റിക്കവറി കോഡുകൾ പകർത്തുക',
    setup2fa_4_instructions: `
        നിങ്ങളുടെ ഫോൺ നഷ്ടപ്പെടുകയോ ഓതന്റിക്കേറ്റർ ആപ്പ് ഉപയോഗിക്കാൻ കഴിയാതാവുകയോ ചെയ്താൽ നിങ്ങളുടെ അക്കൗണ്ടിൽ ആക്സസ് നേടാനുള്ള ഏക മാർഗമാണ് ഈ റിക്കവറി കോഡുകൾ.
        അവ ഒരു സുരക്ഷിതമായ സ്ഥലത്ത് സൂക്ഷിക്കുക.
    `,
    setup2fa_5_step_heading: '2FA സെറ്റപ്പ് സ്ഥിരീകരിക്കുക',
    setup2fa_5_confirmation_1: 'ഞാൻ എന്റെ റിക്കവറി കോഡുകൾ ഒരു സുരക്ഷിതമായ സ്ഥലത്ത് സൂക്ഷിച്ചു',
    setup2fa_5_confirmation_2: 'ഞാൻ 2FA പ്രവർത്തനക്ഷമമാക്കാൻ തയ്യാറാണ്',
    setup2fa_5_button: '2FA പ്രവർത്തനക്ഷമമാക്കുക',

    // === 2FA Login ===
    login2fa_otp_title: '2FA കോഡ് നൽകുക',
    login2fa_otp_instructions: 'നിങ്ങളുടെ ഓതന്റിക്കേറ്റർ ആപ്പിൽ നിന്ന് 6-അക്കം ഉള്ള കോഡ് നൽകുക.',
    login2fa_recovery_title: 'ഒരു റിക്കവറി കോഡ് നൽകുക',
    login2fa_recovery_instructions: 'നിങ്ങളുടെ അക്കൗണ്ടിൽ ആക്സസ് നേടാൻ നിങ്ങളുടെ ഒരു റിക്കവറി കോഡ് നൽകുക.',
    login2fa_use_recovery_code: 'റിക്കവറി കോഡ് ഉപയോഗിക്കുക',
    login2fa_recovery_back: 'തിരികെ',
    login2fa_recovery_placeholder: 'XXXXXXXX',

    // Sharing
    'Editor': 'എഡിറ്റർ',
    'Viewer': 'കാഴ്‌ചക്കാരൻ',
    'People with access': 'ആക്സസ് ഉള്ളവർ',
    'Share With…' : 'പങ്കിടുക…',
    'Owner': 'ഉടമ',
    "You can't share with yourself.": 'നിങ്ങൾക്ക് സ്വയം പങ്കിടാൻ സാധിക്കില്ല.',
    'This user already has access to this item': 'ഈ ഉപയോക്താവിന് ഇതിനകം ഈ ഇനം ആക്സസ് ഉണ്ട്.',

    // Billing
    'billing.change_payment_method': "മാറ്റുക",
    'billing.cancel': "റദ്ദാക്കുക",
    'billing.download_invoice': "ഡൗൺലോഡ് ചെയ്യുക",
    'billing.payment_method': "പേയ്‌മെന്റ് രീതികൾ",
    'billing.payment_method_updated': "പേയ്‌മെന്റ് രീതികൾ അപ്ഡേറ്റ് ചെയ്തു!",
    'billing.confirm_payment_method': 'പേയ്‌മെന്റ് രീതി സ്ഥിരീകരിക്കുക',
    'billing.payment_history': "പേയ്‌മെന്റ് ചരിത്രം",
    'billing.refunded': "പുനഃസമർപ്പിച്ചു",
    'billing.paid': "പേയ്ഡ്",
    'billing.ok': "ശരി",
    'billing.resume_subscription': 'സബ്സ്ക്രിപ്ഷൻ പുനഃസജീവമാക്കുക',
    'billing.subscription_cancelled': 'നിങ്ങളുടെ സബ്സ്ക്രിപ്ഷൻ റദ്ദാക്കിയിരിക്കുന്നു.',
    'billing.subscription_cancelled_description': 'ഈ ബില്ലിംഗ് കാലാവധിയുടെ അവസാനം വരെ നിങ്ങൾക്ക് നിങ്ങളുടെ സബ്സ്ക്രിപ്ഷൻ ആക്സസ് ലഭിക്കും.',
    'billing.offering.free': 'ഫ്രീ',
    'billing.offering.pro': 'പ്രൊഫഷണൽ',
    'billing.offering.business': 'ബിസിനസ്',
    'billing.cloud_storage': 'ക്ലൗഡ് സ്റ്റോറേജ്',
    'billing.ai_access': 'AI ആക്സസ്',
    'billing.bandwidth': 'ബാൻഡ്‌വിഡ്ത്ത്',
    'billing.apps_and_games': 'ആപ്പുകളും ഗെയിമുകളും',
    'billing.upgrade_to_pro': '%strong% ലേക്ക് അപ്‌ഗ്രേഡ് ചെയ്യുക',
    'billing.switch_to': '%strong% ലേക്ക് മാറുക',
    'billing.payment_setup': 'പേയ്‌മെന്റ് ക്രമീകരണം',
    'billing.back': 'തിരികെ',
    'billing.you_are_now_subscribed_to': 'നിങ്ങൾ ഇപ്പോൾ %strong% ലേക്ക് സബ്സ്ക്രൈബ് ചെയ്തു.',
    'billing.you_are_now_subscribed_to_without_tier': 'നിങ്ങൾ ഇപ്പോൾ സബ്സ്ക്രൈബ് ചെയ്തു',
    'billing.subscription_cancellation_confirmation': 'നിങ്ങളുടെ സബ്സ്ക്രിപ്ഷൻ റദ്ദാക്കാൻ നിങ്ങൾക്കു താൽപ്പര്യമുണ്ടോ?',
    'billing.subscription_setup': 'സബ്സ്ക്രിപ്ഷൻ ക്രമീകരണം',
    'billing.cancel_it': 'ഇത് റദ്ദാക്കുക',
    'billing.keep_it': 'ഇത് നിലനിർത്തുക',
    'billing.subscription_resumed': 'നിങ്ങളുടെ %strong% സബ്സ്ക്രിപ്ഷൻ പുനഃസജീവമാക്കിയിരിക്കുന്നു!',
    'billing.upgrade_now': 'ഇപ്പോൾ അപ്‌ഗ്രേഡ് ചെയ്യുക',
    'billing.upgrade': 'അപ്‌ഗ്രേഡ്',
    'billing.currently_on_free_plan': 'നിങ്ങൾ ഇപ്പോൾ ഫ്രീ പ്ലാനിലാണ്.',
    'billing.download_receipt': 'രസീത് ഡൗൺലോഡ് ചെയ്യുക',
    'billing.subscription_check_error': 'നിങ്ങളുടെ സബ്സ്ക്രിപ്ഷൻ നില പരിശോധിക്കുമ്പോൾ പ്രശ്നം ഉണ്ടായി.',
    'billing.payment_method_updated': 'പേയ്‌മെന്റ് രീതി അപ്ഡേറ്റ് ചെയ്തു!',
    'billing.email_confirmation_needed': 'നിങ്ങളുടെ ഇമെയിൽ സ്ഥിരീകരിച്ചിട്ടില്ല. ഇത് സ്ഥിരീകരിക്കാൻ ഞങ്ങൾ നിങ്ങൾക്ക് ഒരു കോഡ് അയയ്ക്കും.',
    'billing.sub_cancelled_but_valid_until': 'നിങ്ങൾ നിങ്ങളുടെ സബ്സ്ക്രിപ്ഷൻ റദ്ദാക്കി. ഇത് ബില്ലിംഗ് കാലാവധിയുടെ അവസാനം ഫ്രീ ടിയറിലേക്ക് സ്വിച്ച് ചെയ്യും. നിങ്ങൾ വീണ്ടും സബ്സ്ക്രൈബ് ചെയ്യാതെ വീണ്ടും ചാർജ് ചെയ്യില്ല.',
    'billing.current_plan_until_end_of_period': 'ഈ ബില്ലിംഗ് കാലാവധിയുടെ അവസാനം വരെ നിങ്ങളുടെ നിലവിലെ പ്ലാൻ.',
    'billing.current_plan': 'നിലവിലെ പ്ലാൻ',
    'billing.cancelled_subscription_tier': 'റദ്ദാക്കിയ സബ്സ്ക്രിപ്ഷൻ (%%)',
    'billing.manage': 'മനേജുചെയ്യുക',
    'billing.limited': 'പരിമിതം',
    'billing.expanded': 'വിസ്താരിച്ചു',
    'billing.accelerated': 'ത്വരിതമാക്കി',
    'billing.enjoy_msg': '%% ക്ലൗഡ് സ്റ്റോറേജും മറ്റ് ആനുകൂല്യങ്ങളും ആസ്വദിക്കുക.',

    }

};

export default ml;