/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const ja = {
    name: "日本語",
    english_name: "Japanese",
    code: "ja",
    dictionary: {
        about: "概要",
        account: "アカウント",
        account_password: "アカウントのパスワードを確認",
        access_granted_to: "アクセスを承認するアカウント",
        add_existing_account: "既存のアカウントを追加",
        all_fields_required: '全ての項目が必須です。',
        allow: '許可',
        apply: "適用",
        ascending: '昇順',
        associated_websites: "関連ウェブサイト",
        auto_arrange: '自動配置',
        background: "背景",
        browse: "ブラウズ",
        cancel: 'キャンセル',
        center: '中央',
        change_desktop_background: 'デスクトップの背景を変更…',
        change_email: "メールアドレスを変更",
        change_language: "言語を変更",
        change_password: "パスワードを変更",
        change_ui_colors: "UIの色を変更",
        change_username: "ユーザー名を変更",
        close: '閉じる',
        close_all_windows: "すべてのウィンドウを閉じる",
        close_all_windows_confirm: "すべてのウィンドウを閉じてよろしいですか？",
        close_all_windows_and_log_out: 'ウィンドウを閉じてログアウト',
        change_always_open_with: "この種類のファイルを常にこのアプリで開きますか？",
        color: '色',
        confirm: '確認',
        confirm_2fa_setup: '認証アプリにコードを追加しました',
        confirm_2fa_recovery: 'リカバリーコードを安全な場所に保存しました',
        confirm_account_for_free_referral_storage_c2a: 'アカウントを作成してメールアドレスを確認すると、1GBの無料ストレージを獲得できます。友人も1GBの無料ストレージを獲得します。',
        confirm_code_generic_incorrect: "コードが間違っています。",
        confirm_code_generic_too_many_requests: "リクエストが多すぎます。数分待ってください。",
        confirm_code_generic_submit: "コードを送信",
        confirm_code_generic_try_again: "もう一度試す",
        confirm_code_generic_title: "確認コードを入力",
        confirm_code_2fa_instruction: "認証アプリから6桁のコードを入力してください。",
        confirm_code_2fa_submit_btn: "送信",
        confirm_code_2fa_title: "2FAコードを入力",
        confirm_delete_multiple_items: 'これらの項目を完全に削除してよろしいですか？',
        confirm_delete_single_item: 'この項目を完全に削除してよろしいですか？',
        confirm_open_apps_log_out: 'アプリが開いています。ログアウトしてもよろしいですか？',
        confirm_new_password: "新しいパスワードを確認",
        confirm_delete_user: "アカウントを削除してよろしいですか？すべてのファイルとデータが完全に削除されます。この操作は元に戻せません。",
        confirm_delete_user_title: "アカウントを削除しますか？",
        confirm_session_revoke: "このセッションを取り消してもよろしいですか？",
        confirm_your_email_address: "メールアドレスを確認",
        contact_us: "お問い合わせ",
        contact_us_verification_required: "この機能を使用するには、確認済みのメールアドレスが必要です。",
        contain: '合わせる',
        continue: "続行",
        copy: 'コピー',
        copy_link: "リンクをコピー",
        copying: "コピー中",
        copying_file: "%% コピー中",
        cover: '全体に表示',
        create_account: "アカウントを作成",
        create_free_account: "無料アカウントを作成",
        create_shortcut: "ショートカットを作成",
        credits: "クレジット",
        current_password: "現在のパスワード",
        cut: 'カット',
        clock: "時計",
        clock_visible_hide: '非表示 - 常に非表示',
        clock_visible_show: '表示 - 常に表示',
        clock_visible_auto: '自動 - デフォルト、フルスクリーンモードでのみ表示',
        close_all: 'すべて閉じる',
        created: '作成日',
        date_modified: '更新日',
        default: 'デフォルト',
        delete: '削除',
        delete_account: "アカウントを削除",
        delete_permanently: "完全に削除",
        deleting_file: "削除中 %%",
        deploy_as_app: 'アプリとしてデプロイ',
        descending: '降順',
        desktop: 'デスクトップ',
        desktop_background_fit: "画面背景をフィット",
        developers: "開発者",
        dir_published_as_website: `%strong% が公開されました：`,
        disable_2fa: '2FAを無効にする',
        disable_2fa_confirm: "2FAを無効にしてよろしいですか？",
        disable_2fa_instructions: "パスワードを入力して2FAを無効にします。",
        disassociate_dir: "ディレクトリの関連付けを解除",
        documents: 'ドキュメント',
        dont_allow: '許可しない',
        download: 'ダウンロード',
        download_file: 'ファイルをダウンロード',
        downloading: "ダウンロード中",
        email: "メール",
        email_change_confirmation_sent: "確認メールが新しいメールアドレスに送信されました。受信トレイを確認し、指示に従って手続きを完了してください。",
        email_invalid: 'メールアドレスが無効です。',
        email_or_username: "メールアドレスまたはユーザー名",
        email_required: 'メールアドレスは必須です。',
        empty_trash: 'ゴミ箱を空にする',
        empty_trash_confirmation: 'ゴミ箱の中のアイテムを完全に削除してもよろしいですか？',
        emptying_trash: 'ゴミ箱を空にしています…',
        enable_2fa: '2FAを有効にする',
        end_hard: "ハード終了",
        end_process_force_confirm: "このプロセスを強制終了してもよろしいですか？",
        end_soft: "ソフト終了",
        enlarged_qr_code: "拡大QRコード",
        enter_password_to_confirm_delete_user: "アカウント削除を確認するためにパスワードを入力してください",
        error_message_is_missing: "エラーメッセージがありません。",
        error_unknown_cause: "不明なエラーが発生しました。",
        error_uploading_files: "ファイルのアップロードに失敗しました",
        favorites: "お気に入り",
        feedback: "フィードバック",
        feedback_c2a: "以下のフォームを使用して、フィードバック、コメント、およびバグ報告をお送りください。",
        feedback_sent_confirmation: "お問い合わせいただきありがとうございます。アカウントに関連付けられたメールがある場合は、できるだけ早く返信いたします。",
        fit: "フィット",
        folder: 'フォルダー',
        force_quit: '強制終了',
        forgot_pass_c2a: "パスワードを忘れましたか？",
        from: "送信者",
        general: "一般",
        get_a_copy_of_on_puter: `Puter.comで '%%' のコピーを取得！`,
        get_copy_link: 'コピーリンクを取得',
        hide_all_windows: "すべてのウィンドウを隠す",
        home: 'ホーム',
        html_document: 'HTML文書',
        hue: '色合い',
        image: '画像',
        incorrect_password: "パスワードが間違っています",
        invite_link: "招待リンク",
        item: 'アイテム',
        items_in_trash_cannot_be_renamed: 'このアイテムはゴミ箱にあるため、名前を変更できません。このアイテムの名前を変更するには、まずゴミ箱からドラッグしてください。',
        jpeg_image: 'JPEG画像',
        keep_in_taskbar: 'タスクバーに保持',
        language: "言語",
        license: "ライセンス",
        lightness: '明るさ',
        link_copied: "リンクがコピーされました",
        loading: '読み込み中',
        log_in: "ログイン",
        log_into_another_account_anyway: '別のアカウントにログインする',
        log_out: 'ログアウト',
        looks_good: "ナイス！",
        manage_sessions: "セッションを管理",
        menubar_style: "メニューバースタイル",
        menubar_style_desktop: "デスクトップ",
        menubar_style_system: "システム",
        menubar_style_window: "ウィンドウ",
        modified: '変更日時',
        move: '移動',
        moving_file: "移動中 %%",
        my_websites: "私のウェブサイト",
        name: '名前',
        name_cannot_be_empty: '名前は空にできません。',
        name_cannot_contain_double_period: "名前には '..' 文字を含めることはできません。",
        name_cannot_contain_period: "名前には '.' 文字を含めることはできません。",
        name_cannot_contain_slash: "名前には '/' 文字を含めることはできません。",
        name_must_be_string: "名前は文字列のみ可能です。",
        name_too_long: `名前は %% 文字を超えてはなりません。`,
        new: '新規',
        new_email: '新しいメールアドレス',
        new_folder: '新しいフォルダー',
        new_password: "新しいパスワード",
        new_username: "新しいユーザー名",
        no: 'いいえ',
        no_dir_associated_with_site: 'このアドレスには関連付けられたディレクトリがありません。',
        no_websites_published: "まだウェブサイトを公開していません。開始するにはフォルダーを右クリックしてください。",
        ok: 'OK',
        open: "開く",
        open_in_new_tab: "新しいタブで開く",
        open_in_new_window: "新しいウィンドウで開く",
        open_with: "アプリケーションで開く",
        original_name: '元の名前',
        original_path: '元のパス',
        oss_code_and_content: "オープンソースソフトウェアとコンテンツ",
        password: "パスワード",
        password_changed: "パスワードが変更されました。",
        password_recovery_rate_limit: "レート制限に達しました。数分待ってください。将来これを防ぐために、ページを何度もリロードしないでください。",
        password_recovery_token_invalid: "このパスワードリカバリトークンは無効です。",
        password_recovery_unknown_error: "不明なエラーが発生しました。後でもう一度試してください。",
        password_required: 'パスワードは必須です。',
        password_strength_error: "パスワードは8文字以上で、少なくとも1つの大文字、小文字、数字、および特殊文字を含む必要があります。",
        passwords_do_not_match: '`新しいパスワード`と`新しいパスワードを確認`が一致しません。',
        paste: '貼り付け',
        paste_into_folder: "フォルダーに貼り付け",
        path: 'パス',
        personalization: "パーソナライズ",
        pick_name_for_website: "ウェブサイトの名前を選んでください：",
        picture: "写真",
        pictures: '写真',
        plural_suffix: '',
        powered_by_puter_js: `{{link=docs}}Puter.js{{/link}} によって提供されています`,
        preparing: "準備中...",
        preparing_for_upload: "アップロードの準備中...",
        print: '印刷',
        privacy: "プライバシー",
        proceed_to_login: 'ログインに進む',
        proceed_with_account_deletion: "アカウントの削除を続行",
        process_status_initializing: "初期化中",
        process_status_running: "実行中",
        process_type_app: 'アプリ',
        process_type_init: '初期化',
        process_type_ui: 'UI',
        properties: "プロパティ",
        public: '公開',
        publish: "公開",
        publish_as_website: 'ウェブサイトとして公開',        
        puter_description: `Puterは、すべてのファイル、アプリ、およびゲームを一か所に安全に保管し、いつでもどこからでもアクセスできるプライバシー重視の個人用クラウドです。`,
        reading_file: "読み込み中 %strong%",
        recent: "最近",
        recommended: "おすすめ",
        recover_password: "パスワードを回復",
        refer_friends_c2a: "友達がPuterでアカウントを作成して確認すると、1GBを獲得できます。友達も1GBを獲得できます！",
        refer_friends_social_media_c2a: `Puter.comで1GBの無料ストレージを手に入れよう！`,
        refresh: '更新',
        release_address_confirmation: `このアドレスを解放してもよろしいですか？`,
        remove_from_taskbar: 'タスクバーから削除',
        rename: '名前を変更',
        repeat: '繰り返す',
        replace: '置換',
        replace_all: 'すべて置換',
        resend_confirmation_code: "確認コードを再送信",
        reset_colors: "色をリセット",
        restart_puter_confirm: "Puterを再起動してもよろしいですか？",
        restore: "復元",
        save: '保存',
        saturation: '彩度',
        save_account: 'アカウントを保存',
        save_account_to_get_copy_link: "続行するにはアカウントを作成してください。",
        save_account_to_publish: '続行するにはアカウントを作成してください。',
        save_session: 'セッションを保存',
        save_session_c2a: '現在のセッションを保存して、作業を失わないようにするにはアカウントを作成してください。',
        scan_qr_c2a: '以下のコードをスキャンすると、他のデバイスからこのセッションにログインできます',
        scan_qr_2fa: '認証アプリでQRコードをスキャンしてください',
        scan_qr_generic: 'スマートフォンまたは他のデバイスでこのQRコードをスキャンしてください',
        search: '検索',
        seconds: '秒',
        security: "セキュリティ",
        select: "選択",
        selected: '選択済み',
        select_color: '色を選択…',
        sessions: "セッション",
        send: "送信",
        send_password_recovery_email: "パスワード回復メールを送信",
        session_saved: "アカウントを作成していただきありがとうございます。このセッションは保存されました。",
        settings: "設定",
        set_new_password: "新しいパスワードを設定",
        share: "共有",
        share_to: "共有先",
        share_with: "共有相手：",
        shortcut_to: "ショートカット先",
        show_all_windows: "すべてのウィンドウを表示",
        show_hidden: '隠しファイルを表示',
        sign_in_with_puter: "Puterでサインイン",
        sign_up: "サインアップ",
        signing_in: "サインイン中…",
        size: 'サイズ',
        skip: 'スキップ',
        something_went_wrong: "問題が発生しました。",
        sort_by: '並べ替え',
        start: '開始',
        status: "ステータス",
        storage_usage: "ストレージ使用量",
        storage_puter_used: 'Puterで使用中',
        taking_longer_than_usual: 'いつもより少し時間がかかっています。お待ちください...',
        task_manager: "タスクマネージャー",
        taskmgr_header_name: "名前",
        taskmgr_header_status: "ステータス",
        taskmgr_header_type: "タイプ",
        terms: "利用規約",
        text_document: 'テキスト文書',
        tos_fineprint: `「無料アカウントを作成」をクリックすることで、Puterの{{link=terms}}利用規約{{/link}}および{{link=privacy}}プライバシーポリシー{{/link}}に同意するものとします。`,
        transparency: "透明度",
        trash: 'ゴミ箱',
        two_factor: '二要素認証',
        two_factor_disabled: '2FA無効',
        two_factor_enabled: '2FA有効',
        type: 'タイプ',
        type_confirm_to_delete_account: "アカウントを削除するには「confirm」と入力してください。",
        ui_colors: "UIカラー",
        ui_manage_sessions: "セッションマネージャー",
        ui_revoke: "取り消し",
        undo: '元に戻す',
        unlimited: '無制限',
        unzip: "解凍",
        upload: 'アップロード',
        upload_here: 'ここにアップロード',
        usage: '使用量',
        username: "ユーザー名",
        username_changed: 'ユーザー名が正常に更新されました。',
        username_required: 'ユーザー名は必須です。',
        versions: "バージョン",
        videos: '動画',
        visibility: '見え方',
        yes: 'はい',
        yes_release_it: 'はい、解放します',
        you_have_been_referred_to_puter_by_a_friend: "友達からPuterに紹介されました！",
        zip: "圧縮",
        zipping_file: "圧縮中 %strong%",        

        // === 2FA Setup ===
        setup2fa_1_step_heading: '認証アプリを開く',
        setup2fa_1_instructions: `
            Time-based One-Time Password (TOTP) プロトコルをサポートする任意の認証アプリを使用できます。
            多くの選択肢がありますが、迷った場合は
            <a target="_blank" href="https://authy.com/download">Authy</a>
            がAndroidとiOSのおすすめの選択肢です。
        `,
        setup2fa_2_step_heading: 'QRコードをスキャンする',
        setup2fa_3_step_heading: '6桁のコードを入力',
        setup2fa_4_step_heading: '回復コードをコピーする',
        setup2fa_4_instructions: `
            これらの回復コードは、電話を紛失したり認証アプリを使用できない場合にアカウントにアクセスする唯一の方法です。
            安全な場所に保管してください。
        `,
        setup2fa_5_step_heading: '2FA設定を確認',
        setup2fa_5_confirmation_1: '回復コードを安全な場所に保存しました',
        setup2fa_5_confirmation_2: '2FAを有効にする準備ができました',
        setup2fa_5_button: '2FAを有効にする',
        
        // === 2FA Login ===
        login2fa_otp_title: '2FAコードを入力',
        login2fa_otp_instructions: '認証アプリから6桁のコードを入力してください。',
        login2fa_recovery_title: '回復コードを入力',
        login2fa_recovery_instructions: 'アカウントにアクセスするために、回復コードの1つを入力してください。',
        login2fa_use_recovery_code: '回復コードを使用',
        login2fa_recovery_back: '戻る',
        
        login2fa_recovery_placeholder: 'XXXXXXXX',

        "change": "変更", // In English: "Change"
        "clock_visibility": "時計の表示設定", // In English: "Clock Visibility"
        "plural_suffix": "", // In English: "s"
        "reading": "読み取り中 %strong%", // In English: "Reading %strong%"
        "writing": "書き込み中 %strong%", // In English: "Writing %strong%"
        "unzipping": "解凍中 %strong%", // In English: "Unzipping %strong%"
        "sequencing": "シーケンス中 %strong%", // In English: "Sequencing %strong%"
        "zipping": "圧縮中 %strong%", // In English: "Zipping %strong%"
        "Editor": "エディター", // In English: "Editor"
        "Viewer": "ビューアー", // In English: "Viewer"
        "People with access": "アクセス権を持つ人々", // In English: "People with access"
        "Share With…": "共有する…", // In English: "Share With…"
        "Owner": "所有者", // In English: "Owner"
        "You can't share with yourself.": "自分自身と共有することはできません。", // In English: "You can't share with yourself."
        "This user already has access to this item": "このユーザーは既にこのアイテムにアクセスできます。", // In English: "This user already has access to this item"
    
        "plural_suffix": "複数形接尾辞", // In English: "s"
        "billing.change_payment_method": "支払い方法を変更", // In English: "Change"
        "billing.cancel": "支払いをキャンセル", // In English: "Cancel"
        "billing.download_invoice": "請求書をダウンロード", // In English: "Download"
        "billing.payment_method": "支払い方法", // In English: "Payment Method"
        "billing.payment_method_updated": "支払い方法が更新されました！", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "支払い方法を確認", // In English: "Confirm Payment Method"
        "billing.payment_history": "支払い履歴", // In English: "Payment History"
        "billing.refunded": "返金されました", // In English: "Refunded"
        "billing.paid": "支払い済み", // In English: "Paid"
        "billing.ok": "OK", // In English: "OK"
        "billing.resume_subscription": "サブスクリプションを再開", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "サブスクリプションがキャンセルされました。", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "この請求期間の終了までサブスクリプションを利用できます。", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "無料", // In English: "Free"
        "billing.offering.pro": "プロフェッショナル", // In English: "Professional"
        "billing.offering.business": "ビジネス", // In English: "Business"
        "billing.cloud_storage": "クラウドストレージ", // In English: "Cloud Storage"
        "billing.ai_access": "AIアクセス", // In English: "AI Access"
        "billing.bandwidth": "データの転送量や速度", // In English: "Bandwidth"
        "billing.apps_and_games": "アプリ＆ゲーム", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "%strong%にアップグレード", // In English: "Upgrade to %strong%"
        "billing.switch_to": "%strong%に切り替え", // In English: "Switch to %strong%"
        "billing.payment_setup": "支払い設定", // In English: "Payment Setup"
        "billing.back": "戻る", // In English: "Back"
        "billing.you_are_now_subscribed_to": "現在%strong%プランに加入しています。", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "現在サブスクリプションに加入しています。", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "サブスクリプションをキャンセルしてもよろしいですか？", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "サブスクリプションの設定", // In English: "Subscription Setup"
        "billing.cancel_it": "キャンセルする", // In English: "Cancel It"
        "billing.keep_it": "維持する", // In English: "Keep It"
        "billing.subscription_resumed": "%strong%のサブスクリプションが再開されました！", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "今すぐアップグレード", // In English: "Upgrade Now"
        "billing.upgrade": "アップグレード", // In English: "Upgrade"
        "billing.currently_on_free_plan": "現在、無料プランに加入しています。", // In English: "You are currently on the free plan."
        "billing.download_receipt": "領収書をダウンロード", // In English: "Download Receipt"
        "billing.subscription_check_error": "サブスクリプションの状況を確認中に問題が発生しました。", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "メールが確認されていません。確認コードをお送りします。", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "サブスクリプションをキャンセルしました。この請求期間の終了時に自動的に無料プランに切り替わります。再加入しない限り、追加料金は発生しません。", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "この請求期間の終了時までの現在のプランを続ける。", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "現在のプラン", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "キャンセルされたサブスクリプション（%%）", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "管理", // In English: "Manage"
        "billing.limited": "制限付き", // In English: "Limited"
        "billing.expanded": "拡張", // In English: "Expanded"
        "billing.accelerated": "高速化", // In English: "Accelerated"
        "billing.enjoy_msg": "クラウドストレージの%%とその他の特典をお楽しみください。", // In English: "Enjoy %% of Cloud Storage plus other benefits."
    }
};

export default ja;
