/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const it = {
  name: "Italiano",
  english_name: "Italian",
  code: "it",
  dictionary: {
    about: "Informazioni", // This is better in the context of the setting page title. It may be tricky.
    account: "Account",
    account_password: "Verifica  Password del account",
    access_granted_to: "Accesso garantito a",
    add_existing_account: "Aggiungi un account esistente",
    all_fields_required: "Tutti i campi sono richiesti.",
    allow: "Consenti",
    apply: "Applica",
    ascending: "Ascendente",
    associated_websites: "Siti associati",
    auto_arrange: "Organizzazione automatica",
    background: "Sfondo",
    browse: "Sfoglia",
    cancel: "Annulla",
    center: "Centra ",
    change_desktop_background: "Modifica sfondo…",
    change_email: "Modifica Email",
    change_language: "Cambia lingua",
    change_password: "Modifica password",
    change_ui_colors: "Cambia i colori dell'interfaccia",
    change_username: "Modifica Nome Utente",
    close: "Chiudi",
    close_all_windows: "Chiudi tutte le finestre",
    close_all_windows_confirm:
      "Sei sicuro di voler chiudere tutte le finestre?",
    close_all_windows_and_log_out: "Chiudi tutte le finestre e disconnettiti",
    change_always_open_with: "Vuoi sempre aprire questo tipo di file con",
    color: "Colore",
    confirm: "Conferma",
    confirm_2fa_setup: "Ho aggiunto il codice alla mia app di autenticazione",
    confirm_2fa_recovery: "Ho salvato il codice di recupero in un posto sicuro",
    confirm_account_for_free_referral_storage_c2a:
      "Crea un account e conferma la tua email per ricevere 1 GB di spazio di archiviazione gratuito. Anche il tuo amico riceverà dello spazio extra!",
    confirm_code_generic_incorrect: "Codice errato.",
    confirm_code_generic_too_many_requests:
      "Troppe richieste. Attendi qualche minuto.",
    confirm_code_generic_submit: "Invia Codice",
    confirm_code_generic_try_again: "Riprova",
    confirm_code_generic_title: "Inserisci Codice di Conferma",
    confirm_code_2fa_instruction:
      "Inserisci il codice a 6 cifre dalla tua app di autenticazione.",
    confirm_code_2fa_submit_btn: "Invia",
    confirm_code_2fa_title: "Inserisci il Codice 2FA",
    confirm_delete_multiple_items:
      "Sei sicuro di voler eliminare definitivamente questi elementi?",
    confirm_delete_single_item:
      "Vuoi eliminare definitivamente questo elemento?",
    confirm_open_apps_log_out:
      "Ci sono delle applicazioni aperte. Sei sicuro di voler effettuare il log out?",
    confirm_new_password: "Conferma la nuova Password",
    confirm_delete_user:
      "Sei sicuro di voler cancellare il tuo account? Tutti i tuoi file e dati saranno definitivamente cancellati. Quest'azione non è reversibile.",
    confirm_delete_user_title: "Cancellare l'Account?",
    confirm_session_revoke: "Sei sicuro di voler revocare questa sessione?",
    confirm_your_email_address: "Conferma il tuo indirizzo email",
    contact_us: "Contattaci",
    contact_us_verification_required:
      "Devi verificare il tuo indirizzo email per utilizzare questa funzione.",
    contain: "Contiene",
    continue: "Continua",
    copy: "Copia",
    copy_link: "Copia il link",
    copying: "Copia in corso",
    copying_file: "Copiando %%",
    cover: "Cover",
    create_account: "Crea Account",
    create_free_account: "Crea un account gratis",
    create_shortcut: "Crea Scorciatoia",
    credits: "Crediti",
    current_password: "Password attuale",
    cut: "Taglia",
    clock: "Orologio",
    clock_visible_hide: "Nascondi - Sempre nascosto",
    clock_visible_show: "Mostra - Sempre visibile",
    clock_visible_auto:
      "Auto - Default, visibile solo in modalità schermo intero",
    close_all: "Chiudi tutte",
    created: "Creata",
    date_modified: "Data ultima modifica",
    default: "Predefinita",
    delete: "Elimina",
    delete_account: "Elimina Account",
    delete_permanently: "Elimina permanentemente",
    deleting_file: "Eliminando %%",
    deploy_as_app: "Distribuisci come Applicazione",
    descending: "Discendente",
    desktop: "Scrivania",
    desktop_background_fit: "Adatta",
    developers: "Sviluppatori",
    dir_published_as_website: `%strong% è stato pubblicato su:`,
    disable_2fa: "Disabilita 2FA",
    disable_2fa_confirm: "Sei sicuro di voler disabilitare la 2FA?",
    disable_2fa_instructions:
      "Inserisci la tua password per disabilitare la 2FA.",
    disassociate_dir: "Dissocia la Directory",
    documents: "Documenti",
    dont_allow: "Non consentire",
    download: "Scarica",
    download_file: "Scarica file",
    downloading: "Download in corso",
    email: "Email",
    email_change_confirmation_sent:
      "Ti abbiamo inviato un'email di conferma. Controlla la tua casella di posta e segui le istruzioni per completare il processo.",
    email_invalid: "Email invalida.",
    email_or_username: "Email o Nome Utente",
    email_required: "Email richiesta.",
    empty_trash: "Svuota Cestino",
    empty_trash_confirmation: `Sei sicuro di voler svuotare il cestino?`,
    emptying_trash: "Il cestino si sta svuotando…",
    enable_2fa: "Abilita la 2FA",
    end_hard: "Forza la chiusura",
    end_process_force_confirm:
      "Sei sicuro di voler forzare la chiusura di questo processo?",
    end_soft: "Chiudi",
    enlarged_qr_code: "QR Code ingrandito",
    enter_password_to_confirm_delete_user:
      "Inserisci la tua password per confermare l'eliminazione del tuo account.",
    error_message_is_missing: "Messaggio di errore mancante.",
    error_unknown_cause: "Errore sconosciuto.",
    error_uploading_files: "Errore durante l'upload dei file.",
    favorites: "Preferiti",
    feedback: "Feedback",
    feedback_c2a:
      "Usa il form qua sotto per inviarci feedback, commenti, e segnalarci dei bug.",
    feedback_sent_confirmation:
      "Grazie per averci contattato. Se hai un indirizzo email associato al tuo account, ti ricontatteremo il prima possibile.",
    fit: "Adatta",
    folder: "Cartella",
    force_quit: "Forza la chiusura",
    forgot_pass_c2a: "Password dimenticata?",
    from: "Da",
    general: "Generale",
    get_a_copy_of_on_puter: `Ottieni una copia di '%%' su Puter.com!`,
    get_copy_link: "Ottieni link di copia",
    hide_all_windows: "Nascondi tutte le finestre",
    home: "Home",
    html_document: "Documento HTML",
    hue: "Tonalità",
    image: "Immagine",
    incorrect_password: "Password errata",
    invite_link: "Link d’invito",
    item: "elemento",
    items_in_trash_cannot_be_renamed: `Impossibile rinominare un elemento nel Cestino. Per rinominarlo, è necessario ripristinarlo.`,
    jpeg_image: "Immagine JPEG",
    keep_in_taskbar: "Blocca nella barra delle applicazioni",
    language: "Lingua",
    license: "Licenza",
    lightness: "Luminosità",
    link_copied: "Link copiato",
    loading: "Caricamento",
    log_in: "Accedi",
    log_into_another_account_anyway: "Accedi comunque con un altro account",
    log_out: "Disconnettiti",
    looks_good: "Sembra buono!",
    manage_sessions: "Gestisci le sessioni",
    menubar_style: "Stile della barra dei menu",
    menubar_style_desktop: "Scrivania",
    menubar_style_system: "Sistema",
    menubar_style_window: "Finestra",
    modified: "Modificato",
    move: "Sposta",
    moving_file: "Spostamento in corso %%",
    my_websites: "I miei siti web",
    name: "Nome",
    name_cannot_be_empty: "Il nome non può essere vuoto.",
    name_cannot_contain_double_period: "Il nome non può contenere '..' .",
    name_cannot_contain_period: "Il nome non può contenere '.' .",
    name_cannot_contain_slash: "Il nome non può contenere '/' .",
    name_must_be_string: "Il nome può contenere una sola linea.",
    name_too_long: `Il nome non può essere più lungo di %% caratteri.`,
    new: "Nuovo",
    new_email: "Nuova Email",
    new_folder: "Nuova Cartella",
    new_password: "Nuova Password",
    new_username: "Nuovo Nome Utente",
    no: "No",
    no_dir_associated_with_site:
      "Nessuna directory è stata associata all’indirizzo.",
    no_websites_published:
      "Non hai pubblicato nessun sito web. Clicca tasto destro su una cartella per iniziare.",
    ok: "OK",
    open: "Apri",
    open_in_new_tab: "Apri in una nuova scheda",
    open_in_new_window: "Apri in una nuova finestra",
    open_with: "Apri con",
    original_name: "Nome originale",
    original_path: "Percorso originale",
    oss_code_and_content: "Contenuto e software Open Source",
    password: "Password",
    password_changed: "Password modificata.",
    password_recovery_rate_limit:
      "Hai raggiunto il limite di richieste; per favore attendi qualche minuto. Per evitarlo in futuro evita di ricaricare la pagina troppe volte.",
    password_recovery_token_invalid:
      "Questo token per il recupero della password non è valido.",
    password_recovery_unknown_error:
      "Errore sconosciuto. Per favore riprova più tardi.",
    password_required: "Password richiesta.",
    password_strength_error:
      "La password deve essere lunga almeno 8 caratteri e contenete almeno una maiuscola, una minuscola, un numero e un carattere speciale.",
    passwords_do_not_match:
      "Le caselle `Nuova Password` and `Conferma Nuova Password` non corrispondono.",
    paste: "Incolla",
    paste_into_folder: "Incolla nella cartella",
    path: "Percorso",
    personalization: "Personalizzazione",
    pick_name_for_website: "Scegli un nome per il tuo sito web:",
    picture: "Immagine",
    pictures: "Immagini",
    plural_suffix: "i",
    powered_by_puter_js: `Realizzato con {{link=docs}}Puter.js{{/link}}`,
    preparing: "Preparazione in corso...",
    preparing_for_upload: "Preparazione per l’upload...",
    print: "Stampa",
    privacy: "Privacy",
    proceed_to_login: "Procedi con il login",
    proceed_with_account_deletion: "Continua con l'eliminazione dell'account",
    process_status_initializing: "Inizializzando",
    process_status_running: "In esecuzione",
    process_type_app: "App",
    process_type_init: "Inizializzazione",
    process_type_ui: "UI",
    properties: "Proprietà",
    public: "Pubblico",
    publish: "Pubblica",
    publish_as_website: "Pubblica come sito web",
    puter_description: `Puter è un cloud personale che mette la privacy al primo posto, per conservare tutti i tuoi file, app e giochi in un unico luogo sicuro, accessibile da qualsiasi luogo e in qualsiasi momento.`,
    reading_file: "Leggendo %strong%",
    recent: "Recenti",
    recommended: "Consigliati",
    recover_password: "Ripristina la Password",
    refer_friends_c2a:
      "Ottieni 1 GB di spazio di archiviazione per ogni amico che crea un account e conferma l’email su Puter. Anche il tuo amico riceverà dello spazio extra!",
    refer_friends_social_media_c2a: `Ottieni 1GB di spazio di spazio di archiviazione gratuito su Puter.com!`,
    refresh: "Ricarica",
    release_address_confirmation: `Sei sicuro di voler liberare questo indirizzo?`,
    remove_from_taskbar: "Sblocca dalla barra delle applicazioni",
    rename: "Rinomina",
    repeat: "Ripeti",
    replace: "Sostituisci",
    replace_all: "Sostituisci tutto",
    resend_confirmation_code: "Invia di nuovo il codice di conferma",
    reset_colors: "Ripristina i colori",
    restart_puter_confirm: "Sei sicuro di voler riavviare Puter?",
    restore: "Ripristina",
    save: "Salva",
    saturation: "Saturazione",
    save_account: "Salva Account",
    save_account_to_get_copy_link:
      "È necessario creare un account per procedere.",
    save_account_to_publish: "È necessario creare un account per procedere.",
    save_session: "Salva sessione",
    save_session_c2a:
      "Crea un account per salvare la tua sessione e non perdere i tuoi dati.",
    scan_qr_c2a:
      "Scansiona il codice qua sotto per utilizzare questa sessione da altri dispositivi",
    scan_qr_2fa: "Scansiona il codice QR con la tua app di autenticazione",
    scan_qr_generic: "Scansiona il codice QR usando il tuo smartphone",
    search: "Search",
    seconds: "seconds",
    security: "Sicurezza",
    select: "Seleziona",
    selected: "Selezionato",
    select_color: "Seleziona un colore…",
    sessions: "Sessioni",
    send: "Invia",
    send_password_recovery_email:
      "Invia email per il ripristino della password",
    session_saved:
      "Grazie per aver creato un account. La sessione è stata salvata",
    settings: "Impostazioni",
    set_new_password: "Imposta una nuova Password",
    share: "Condividi",
    share_to: "Condividi con",
    share_with: "Condividi con",
    shortcut_to: "Scorciatoia per",
    show_all_windows: "Mostra tutte le finestre",
    show_hidden: "Mostra nascosti",
    sign_in_with_puter: "Accedi con Puter",
    sign_up: "Registrati",
    signing_in: "Accesso in corso…",
    size: "Dimensione",
    skip: "Salta",
    something_went_wrong: "Qualcosa è andato storto.",
    sort_by: "Ordina per",
    start: "Start",
    status: "Stato",
    storage_usage: "Utilizzo dello spazio",
    storage_puter_used: "utilizzato da Puter",
    taking_longer_than_usual:
      "Il processo in corso ci sta mettendo più del solito. Attendere prego...",
    task_manager: "Gestione attività",
    taskmgr_header_name: "Nome",
    taskmgr_header_status: "Stato",
    taskmgr_header_type: "Tipo",
    terms: "Termini",
    text_document: "Documento di testo",
    tos_fineprint: `Cliccando su 'Crea un account gratis' accetti i {{link=terms}}Termini di Servizio{{/link}} e l'{{link=privacy}}Informativa sulla Privacy{{/link}} di Puter.`,
    transparency: "Trasparenza",
    trash: "Cestino",
    two_factor: "Autenticazione a due fattori",
    two_factor_disabled: "2FA Disabilitata",
    two_factor_enabled: "2FA Abilitata",
    type: "Tipo",
    type_confirm_to_delete_account:
      "Scrivi 'conferma' per eliminare il tuo account.",
    ui_colors: "Colori dell'interfaccia",
    ui_manage_sessions: "Session Manager",
    ui_revoke: "Revoca",
    undo: "Annulla",
    unlimited: "Illimitato",
    unzip: "Estrai",
    upload: "Carica",
    upload_here: "Carica qui",
    usage: "Utilizzo",
    username: "Nome Utente",
    username_changed: "Nome utente aggiornato con successo.",
    username_required: "Il nome utente è richiesto.",
    versions: "Versioni",
    videos: "Video",
    visibility: "Visibilità",
    yes: "Sì",
    yes_release_it: "Si, rilascialo",
    you_have_been_referred_to_puter_by_a_friend:
      "Sei stato invitato su Puter da un amico!",
    zip: "File compresso",
    zipping_file: "Compressione di %strong%",

    // === 2FA Setup ===
    setup2fa_1_step_heading: "Apri la tua app di autenticazione",
    setup2fa_1_instructions: `
            Puoi utilizzare qualsiasi app di autenticazione che supporti il protocollo TOTP (Time-based One-Time Password).
            Ci sono molte opzioni tra cui scegliere, ma se non sei sicuro,
            <a target="_blank" href="https://authy.com/download">Authy</a>
            è una scelta valida sia per Android che per iOS.
        `,
    setup2fa_2_step_heading: "Scansiona il codice QR",
    setup2fa_3_step_heading: "Inserisci il codice a 6 cifre",
    setup2fa_4_step_heading: "Copia i tuoi codici di recupero",
    setup2fa_4_instructions: `
            Questi codici di recupero sono l'unico modo per accedere al tuo account se perdi il telefono o non puoi utilizzare la tua app di autenticazione.
            Assicurati di conservarli in un luogo sicuro.
        `,
    setup2fa_5_step_heading: "Conferma la configurazione del 2FA",
    setup2fa_5_confirmation_1:
      "Ho salvato i miei codici di recupero in un luogo sicuro",
    setup2fa_5_confirmation_2: "Sono pronto per abilitare la 2FA",
    setup2fa_5_button: "Abilita la 2FA",

    // === 2FA Login ===
    login2fa_otp_title: "Inserisci il codice 2FA",
    login2fa_otp_instructions:
      "Inserisci il codice a 6 cifre dalla tua app di autenticazione.",
    login2fa_recovery_title: "Inserisci un codice di recupero",
    login2fa_recovery_instructions:
      "Inserisci uno dei tuoi codici di recupero per accedere al tuo account.",
    login2fa_use_recovery_code: "Usa un codice di recupero",
    login2fa_recovery_back: "Indietro",
    login2fa_recovery_placeholder: "XXXXXXXX",

    change: "Cambia", // In English: "Change"
    clock_visibility: "Visibilità orologio", // In English: "Clock Visibility"
    reading: "Legendo %strong%", // In English: "Reading %strong%"
    writing: "Scrivendo %strong%", // In English: "Writing %strong%"
    unzipping: "Decompressione di %strong%", // In English: "Unzipping %strong%"
    sequencing: "Sequenziamento di %strong%", // In English: "Sequencing %strong%"
    zipping: "Compressione di %strong%", // In English: "Zipping %strong%"
    Editor: "Editore", // In English: "Editor"
    Viewer: "Visualizatore", // In English: "Viewer"
    "People with access": "Persone con accesso", // In English: "People with access"
    "Share With…": "Condividi con…", // In English: "Share With…"
    Owner: "Proprietario", // In English: "Owner"
    "You can't share with yourself.": "Non puoi condividere con te stesso", // In English: "You can't share with yourself."
    "This user already has access to this item":
      "Questo utente ha già accesso a questo file", // In English: "This user already has access to this item"
    
        "billing.change_payment_method": "Modifica", // In English: "Change"
        "billing.cancel": "Annulla", // In English: "Cancel"
        "billing.download_invoice": "Scarica", // In English: "Download"
        "billing.payment_method": "Metodo di pagamento", // In English: "Payment Method"
        "billing.payment_method_updated": "Metodo di pagamento aggiornato!", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "Conferma metodo di pagamento", // In English: "Confirm Payment Method"
        "billing.payment_history": "Storico dei pagamenti", // In English: "Payment History"
        "billing.refunded": "Rimborsato", // In English: "Refunded"
        "billing.paid":  "Pagato", // In English: "Paid"
        "billing.ok": "OK", // In English: "OK"
        "billing.resume_subscription":  "Riprendi abbonamento", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "Il tuo abbonamento è stato annullato.", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "Avrai ancora accesso al tuo abbonamento fino alla fine di questo periodo di fatturazione.",
        // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "Gratuito", // In English: "Free"
        "billing.offering.pro": "Professionale", // In English: "Professional"
        "billing.offering.business": "Business", // In English: "Business"
        "billing.cloud_storage": "Archiviazione cloud", // In English: "Cloud Storage"
        "billing.ai_access": "Accesso AI", // In English: "AI Access"
        "billing.bandwidth": "Larghezza di banda", // In English: "Bandwidth"
        "billing.apps_and_games": "App e Giochi", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "Passa al piano %strong%", // In English: "Upgrade to %strong%"
        "billing.switch_to": "Passa a %strong%", // In English: "Switch to %strong%"
        "billing.payment_setup": "Impostazioni di pagamento", // In English: "Payment Setup"
        "billing.back": "Indietro", // In English: "Back"
        "billing.you_are_now_subscribed_to":  "Ora sei abbonato al piano %strong%.", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier":  "Ora sei abbonato.", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation":  "Sei sicuro di voler annullare il tuo abbonamento?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "Impostazione abbonamento", // In English: "Subscription Setup"
        "billing.cancel_it":  "Annulla", // In English: "Cancel It"
        "billing.keep_it": "Mantieni", // In English: "Keep It"
        "billing.subscription_resumed": "Il tuo abbonamento %strong% è stato ripristinato!", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "Aggiorna ora", // In English: "Upgrade Now"
        "billing.upgrade":  "Aggiorna", // In English: "Upgrade"
        "billing.currently_on_free_plan": "Attualmente sei nel piano gratuito.", // In English: "You are currently on the free plan."
        "billing.download_receipt": "Scarica ricevuta", // In English: "Download Receipt"
        "billing.subscription_check_error": "Si è verificato un problema durante il controllo dello stato dell'abbonamento.",
        // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "La tua email non è stata confermata. Ti invieremo un codice per completare la conferma.", 
        // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "Hai annullato il tuo abbonamento. Passerà automaticamente al piano gratuito alla fine del periodo di fatturazione. Non ti verrà addebitato nuovamente a meno che non ti iscrivi di nuovo.",
        // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "Il tuo piano attuale è valido fino alla fine del periodo di fatturazione.",
        // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "Piano attuale", // In English: "Current plan"
        "billing.cancelled_subscription_tier":  "Abbonamento annullato (%%)", // In English: "Cancelled Subscription (%%)"
        "billing.manage":  "Gestisci", // In English: "Manage"
        "billing.limited": "Limitato", // In English: "Limited"
        "billing.expanded": "Espanso", // In English: "Expanded"
        "billing.accelerated": "Accelerato", // In English: "Accelerated"
        "billing.enjoy_msg": "Goditi %% di spazio di archiviazione cloud e altri vantaggi.", // In English: "Enjoy %% of Cloud Storage plus other benefits."
    }
};

export default it;
