/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const id = {
  name: "Bahasa Indonesia",
  english_name: "Indonesian",
  code: "id",
  dictionary: {
    about: "Tentang",
    account: "Akun",
    account_password: "Verifikasi Kata Sandi Akun",
    access_granted_to: "Akses Diberikan Kepada",
    add_existing_account: "Tambahkan Akun yang Ada",
    all_fields_required: "Semua kolom diperlukan.",
    allow: "Izinkan",
    apply: "Terapkan",
    ascending: "Menaik",
    associated_websites: "Situs Web Terkait",
    auto_arrange: "Atur Otomatis",
    background: "Latar Belakang",
    browse: "Jelajahi",
    cancel: "Batal",
    center: "Tengah",
    change_desktop_background: "Ubah latar belakang desktop…",
    change_email: "Ubah Email",
    change_language: "Ubah Bahasa",
    change_password: "Ubah Kata Sandi",
    change_ui_colors: "Ubah Warna UI",
    change_username: "Ubah Nama Pengguna",
    close: "Tutup",
    close_all_windows: "Tutup Semua Jendela",
    close_all_windows_confirm: "Apakah Anda yakin ingin menutup semua jendela?",
    close_all_windows_and_log_out: "Tutup Jendela dan Keluar",
    change_always_open_with: "Apakah Anda ingin selalu membuka jenis file ini dengan",
    color: "Warna",
    confirm: "Konfirmasi",
    confirm_2fa_setup: "Saya telah menambahkan kode ke aplikasi autentikator saya",
    confirm_2fa_recovery: "Saya telah menyimpan kode pemulihan saya di tempat yang aman",
    confirm_account_for_free_referral_storage_c2a:
      "Buat akun dan konfirmasi alamat email Anda untuk menerima 1 GB penyimpanan gratis. Teman Anda juga akan mendapatkan 1 GB penyimpanan gratis.",
    confirm_code_generic_incorrect: "Kode Salah.",
    confirm_code_generic_too_many_requests:
      "Terlalu banyak permintaan. Silakan tunggu beberapa menit.",
    confirm_code_generic_submit: "Kirim Kode",
    confirm_code_generic_try_again: "Coba Lagi",
    confirm_code_generic_title: "Masukkan Kode Konfirmasi",
    confirm_code_2fa_instruction:
      "Masukkan kode 6-digit dari aplikasi autentikator Anda.",
    confirm_code_2fa_submit_btn: "Kirim",
    confirm_code_2fa_title: "Masukkan Kode 2FA",
    confirm_delete_multiple_items:
      "Apakah Anda yakin ingin menghapus barang-barang ini secara permanen?",
    confirm_delete_single_item: "Apakah Anda ingin menghapus barang ini secara permanen?",
    confirm_open_apps_log_out:
      "Anda memiliki aplikasi yang terbuka. Apakah Anda yakin ingin keluar?",
    confirm_new_password: "Konfirmasi Kata Sandi Baru",
    confirm_delete_user:
      "Apakah Anda yakin ingin menghapus akun Anda? Semua file dan data Anda akan dihapus secara permanen. Tindakan ini tidak dapat dibatalkan.",
    confirm_delete_user_title: "Hapus Akun?",
    confirm_session_revoke: "Apakah Anda yakin ingin mencabut sesi ini?",
    confirm_your_email_address: "Konfirmasi Alamat Email Anda",
    contact_us: "Hubungi Kami",
    contact_us_verification_required:
      "Anda harus memiliki alamat email yang terverifikasi untuk menggunakan ini.",
    contain: "Berisi",
    continue: "Lanjutkan",
    copy: "Salin",
    copy_link: "Salin Tautan",
    copying: "Menyalin",
    copying_file: "Menyalin berkas",
    cover: "Sampul",
    create_account: "Buat Akun",
    create_free_account: "Buat Akun Gratis",
    create_shortcut: "Buat Pintasan",
    credits: "Kredit",
    current_password: "Kata Sandi Saat Ini",
    cut: "Potong",
    clock: "Jam",
    clock_visible_hide: "Sembunyikan - Selalu tersembunyi",
    clock_visible_show: "Tampilkan - Selalu terlihat",
    clock_visible_auto: "Otomatis - Default, terlihat hanya dalam mode layar penuh.",
    close_all: "Tutup Semua",
    created: "Dibuat",
    date_modified: "Tanggal diubah",
    default: "Bawaan",
    delete: "Hapus",
    delete_account: "Hapus Akun",
    delete_permanently: "Hapus Permanen",
    deleting_file: "Menghapus berkas %%",
    deploy_as_app: "Pasang sebagai aplikasi",
    descending: "Menurun",
    desktop: "Desktop",
    desktop_background_fit: "Cocokkan",
    developers: "Pengembang",
    dir_published_as_website: `%strong% telah diterbitkan di:`,
    disable_2fa: "Nonaktifkan 2FA",
    disable_2fa_confirm: "Apakah Anda yakin ingin menonaktifkan 2FA?",
    disable_2fa_instructions: "Masukkan kata sandi Anda untuk menonaktifkan 2FA.",
    disassociate_dir: "Pisahkan Direktori",
    documents: "Dokumen",
    dont_allow: "Jangan Izinkan",
    download: "Unduh",
    download_file: "Unduh File",
    downloading: "Mengunduh",
    email: "Email",
    email_change_confirmation_sent:
      "Email konfirmasi telah dikirim ke alamat email baru Anda. Silakan periksa kotak masuk Anda dan ikuti petunjuk untuk menyelesaikan prosesnya.",
    email_invalid: "Email tidak valid.",
    email_or_username: "Email atau Nama Pengguna",
    email_required: "Email diperlukan.",
    empty_trash: "Kosongkan Sampah",
    empty_trash_confirmation: `Apakah Anda yakin ingin menghapus barang-barang di Sampah secara permanen?`,
    emptying_trash: "Mengosongkan Sampah…",
    enable_2fa: "Aktifkan 2FA",
    end_hard: "Akhiri Secara Paksa",
    end_process_force_confirm: "Apakah Anda yakin menghentikan proses ini secara paksa?",
    end_soft: "Akhiri Secara Lembut",
    enlarged_qr_code: "Kode QR Diperbesar",
    enter_password_to_confirm_delete_user:
      "Masukkan kata sandi Anda untuk mengonfirmasi penghapusan akun",
    error_message_is_missing: "Pesan kesalahan hilang.",
    error_unknown_cause: "Terjadi kesalahan yang tidak diketahui.",
    error_uploading_files: "Gagal mengunggah file",
    favorites: "Kesukaan",
    feedback: "Umpan Balik",
    feedback_c2a:
      "Silakan gunakan formulir di bawah ini untuk mengirimkan umpan balik, komentar, dan laporan bug kepada kami.",
    feedback_sent_confirmation:
      "Terima kasih telah menghubungi kami. Jika Anda memiliki email yang terhubung dengan akun Anda, Anda akan menerima balasan dari kami sesegera mungkin.",
    fit: "Cocokkan",
    folder: "Folder",
    force_quit: "Keluar dengan Paksa",
    forgot_pass_c2a: "Lupa kata sandi?",
    from: "Dari",
    general: "Umum",
    get_a_copy_of_on_puter: `Dapatkan salinan '%%' di Puter.com!`,
    get_copy_link: "Dapatkan Tautan Salinan",
    hide_all_windows: "Sembunyikan Semua Jendela",
    home: "Beranda",
    html_document: "Dokumen HTML",
    hue: "Hue",
    image: "Gambar",
    incorrect_password: "Kata sandi salah",
    invite_link: "Tautan Undangan",
    item: "barang",
    items_in_trash_cannot_be_renamed: `Barang ini tidak dapat dinamai ulang karena berada di sampah. Untuk mengganti nama barang ini, pertama-tama keluarkan dari Sampah.`,
    jpeg_image: "Gambar JPEG",
    keep_in_taskbar: "Pertahankan di Bilah Tugas",
    language: "Bahasa",
    license: "Lisensi",
    lightness: "Kecerahan",
    link_copied: "Tautan disalin",
    loading: "Memuat",
    log_in: "Masuk",
    log_into_another_account_anyway: "Masuk ke akun lain saja",
    log_out: "Keluar",
    looks_good: "Tampak bagus!",
    manage_sessions: "Kelola Sesi",
    menubar_style: "Gaya Menubar",
    menubar_style_desktop: "Desktop",
    menubar_style_system: "Sistem",
    menubar_style_window: "Jendela",
    modified: "Dimodifikasi",
    move: "Pindahkan",
    moving_file: "Memindahkan %%",
    my_websites: "Situs Web Saya",
    name: "Nama",
    name_cannot_be_empty: "Nama tidak boleh kosong.",
    name_cannot_contain_double_period: "Nama tidak boleh berisi karakter '..'.",
    name_cannot_contain_period: "Nama tidak boleh berisi karakter '.'.",
    name_cannot_contain_slash: "Nama tidak boleh berisi karakter '/'",
    name_must_be_string: "Nama hanya boleh berupa string.",
    name_too_long: `Nama tidak boleh lebih dari %% karakter.`,
    new: "Baru",
    new_email: "Email Baru",
    new_folder: "Folder Baru",
    new_password: "Kata Sandi Baru",
    new_username: "Nama Pengguna Baru",
    no: "Tidak",
    no_dir_associated_with_site: "Tidak ada direktori yang terkait dengan alamat ini.",
    no_websites_published:
      "Anda belum menerbitkan situs web. Klik kanan pada folder untuk memulai.",
    ok: "OK",
    open: "Buka",
    open_in_new_tab: "Buka di Tab Baru",
    open_in_new_window: "Buka di Jendela Baru",
    open_with: "Buka Dengan",
    original_name: "Nama Asli",
    original_path: "Jalur Asli",
    oss_code_and_content: "Perangkat Lunak dan Konten Open Source",
    password: "Kata Sandi",
    password_changed: "Kata sandi telah diubah.",
    password_recovery_rate_limit:
      "Anda telah mencapai batas kecepatan kami; silakan tunggu beberapa menit. Untuk mencegah ini di masa depan, hindari memuat ulang halaman terlalu sering.",
    password_recovery_token_invalid: "Token pemulihan kata sandi sudah tidak berlaku.",
    password_recovery_unknown_error:
      "Terjadi kesalahan yang tidak dikenal. Silakan coba lagi nanti.",
    password_required: "Kata sandi diperlukan.",
    password_strength_error:
      "Panjang Kata sandi minimal 8 karakter dan mengandung setidaknya satu huruf kapital, satu huruf kecil, satu angka, dan satu karakter khusus.",
    passwords_do_not_match:
      "`Kata Sandi Baru` dan `Konfirmasi Kata Sandi Baru` tidak cocok.",
    paste: "Tempel",
    paste_into_folder: "Tempel ke dalam Folder",
    path: "Jalur",
    personalization: "Personalisasi",
    pick_name_for_website: "Pilih nama untuk situs web Anda:",
    picture: "Gambar",
    pictures: "Gambar",
    plural_suffix: "s",
    powered_by_puter_js: `Ditenagai oleh {{link=docs}}Puter.js{{/link}}`,
    preparing: "Mempersiapkan...",
    preparing_for_upload: "Persiapan untuk menggunggah...",
    print: "Cetak",
    privacy: "Privasi",
    proceed_to_login: "Lanjutkan untuk masuk",
    proceed_with_account_deletion: "Lanjutkan dengan Penghapusan Akun",
    process_status_initializing: "Memulai",
    process_status_running: "Berjalan",
    process_type_app: "Aplikasi",
    process_type_init: "Inisialisasi",
    process_type_ui: "UI",
    properties: "Properti",
    public: "Publik",
    publish: "Terbitkan",
    publish_as_website: "Terbitkan sebagai situs web",
    puter_description: `Puter adalah cloud pribadi yang mengutamakan privasi untuk menyimpan semua file, aplikasi, dan permainan Anda di satu tempat yang aman, dapat diakses dari mana saja kapan saja.`,
    reading_file: "Membaca %strong%",
    recent: "Terbaru",
    recommended: "Direkomendasikan",
    recover_password: "Pulihkan Kata Sandi",
    refer_friends_c2a:
      "Dapatkan 1 GB untuk setiap teman yang membuat dan mengonfirmasi akun di Puter. Teman Anda juga akan mendapatkan 1 GB!",
    refer_friends_social_media_c2a: "Dapatkan 1 GB penyimpanan gratis di Puter.com!",
    refresh: "Memuat Ulang",
    release_address_confirmation: "Apakah Anda yakin ingin melepaskan alamat ini?",
    remove_from_taskbar: "Hapus dari Bilah Tugas",
    rename: "Ganti Nama",
    repeat: "Ulangi",
    replace: "Ganti",
    replace_all: "Ganti Semua",
    resend_confirmation_code: "Kirim Ulang Kode Konfirmasi",
    reset_colors: "Mengatur Ulang Warna",
    restart_puter_confirm: "Apakah Anda yakin ingin memulai ulang Puter?",
    restore: "Pulihkan",
    save: "Simpan",
    saturation: "Saturasi",
    save_account: "Simpan akun",
    save_account_to_get_copy_link: "Silakan buat akun untuk mendapatkan salinan tautan.",
    save_account_to_publish: "Silakan buat akun untuk melanjutkan.",
    save_session: "Simpan sesi",
    save_session_c2a:
      "Buat akun untuk menyimpan sesi Anda saat ini dan menghindari kehilangan pekerjaan Anda.",
    scan_qr_c2a: "Pindai kode di bawah ini\nuntuk masuk ke sesi ini dari perangkat lain",
    scan_qr_2fa: "Pindai kode QR dengan aplikasi autentikator Anda",
    scan_qr_generic: "Pindai kode QR ini menggunakan ponsel atau perangkat lain Anda",
    search: "Pencarian",
    seconds: "detik",
    security: "Keamanan",
    select: "Pilih",
    selected: "terpilih",
    select_color: "Pilih warna…",
    sessions: "Sesi",
    send: "Kirim",
    send_password_recovery_email: "Kirim Email Pemulihan Kata Sandi",
    session_saved: "Terima kasih telah membuat akun. Sesi ini telah disimpan.",
    settings: "Pengaturan",
    set_new_password: "Tetapkan Kata Sandi Baru",
    share: "Bagikan",
    share_to: "Bagikan ke",
    share_with: "Bagikan dengan:",
    shortcut_to: "Jalan Pintas ke",
    show_all_windows: "Tampilkan Semua Jendela",
    show_hidden: "Tampilkan yang tersembunyi",
    sign_in_with_puter: "Masuk dengan Puter",
    sign_up: "Daftar",
    signing_in: "Masuk…",
    size: "Ukuran",
    skip: "Lewati",
    something_went_wrong: "Terjadi kesalahan.",
    sort_by: "Urutkan berdasarkan",
    start: "Mulai",
    status: "Status",
    storage_usage: "Penggunaan Penyimpanan",
    storage_puter_used: "digunakan oleh Puter",
    taking_longer_than_usual:
      "Memakan waktu sedikit lebih lama dari biasanya. Silakan tunggu...",
    task_manager: "Pengelola Tugas",
    taskmgr_header_name: "Nama",
    taskmgr_header_status: "Status",
    taskmgr_header_type: "Tipe",
    terms: "Syarat",
    text_document: "Dokumen Teks",
    tos_fineprint: `Dengan mengklik 'Buat Akun Gratis', Anda menyetujui {{link=terms}}Syarat Layanan{{/link}} dan {{link=privacy}}Kebijakan Privasi{{/link}} Puter.`,
    transparency: "Transparansi",
    trash: "Tempat Sampah",
    two_factor: "Otentikasi Dua Faktor",
    two_factor_disabled: "2FA Dinonaktifkan",
    two_factor_enabled: "2FA Diaktifkan",
    type: "Tipe",
    type_confirm_to_delete_account: "Ketik 'confirm' untuk menghapus akun Anda.",
    ui_colors: "Warna UI",
    ui_manage_sessions: "Pengelola Sesi",
    ui_revoke: "Batalkan",
    undo: "Batalkan",
    unlimited: "Tak Terbatas",
    unzip: "Ekstrak",
    upload: "Unggah",
    upload_here: "Unggah di sini",
    usage: "Penggunaan",
    username: "Nama Pengguna",
    username_changed: "Nama pengguna berhasil diperbarui.",
    username_required: "Nama pengguna diperlukan.",
    versions: "Versi",
    videos: "Video",
    visibility: "Visibilitas",
    yes: "Ya",
    yes_release_it: "Ya, Lepaskan",
    you_have_been_referred_to_puter_by_a_friend:
      "Anda telah dirujuk ke Puter oleh seorang teman!",
    zip: "Zip",
    zipping_file: "Mengekstrak %strong%",

    // === 2FA Setup ===
    setup2fa_1_step_heading: "Buka aplikasi autentikator Anda",
    setup2fa_1_instructions: `
        Anda dapat menggunakan aplikasi autentikator apa pun yang mendukung protokol Time-based One-Time Password (TOTP).
        Ada banyak pilihan, tetapi jika Anda tidak yakin
        <a target="_blank" href="https://authy.com/download">Authy</a>
        adalah pilihan yang solid untuk Android dan iOS.
    `,
    setup2fa_2_step_heading: "Pindai kode QR",
    setup2fa_3_step_heading: "Masukkan kode 6 digit",
    setup2fa_4_step_heading: "Salin kode pemulihan Anda",
    setup2fa_4_instructions: `
        Kode pemulihan ini adalah satu-satunya cara untuk mengakses akun Anda jika Anda kehilangan ponsel atau tidak dapat menggunakan aplikasi autentikator Anda.
        Pastikan untuk menyimpannya di tempat yang aman.
    `,
    setup2fa_5_step_heading: "Konfirmasi pengaturan 2FA",
    setup2fa_5_confirmation_1:
      "Saya telah menyimpan kode pemulihan saya di tempat yang aman",
    setup2fa_5_confirmation_2: "Saya siap untuk mengaktifkan 2FA",
    setup2fa_5_button: "Aktifkan 2FA",

    // === 2FA Login ===
    login2fa_otp_title: "Masukkan Kode 2FA",
    login2fa_otp_instructions: "Masukkan kode 6 digit dari aplikasi autentikator Anda.",
    login2fa_recovery_title: "Masukkan kode pemulihan",
    login2fa_recovery_instructions:
      "Masukkan salah satu kode pemulihan Anda untuk mengakses akun Anda.",
    login2fa_use_recovery_code: "Gunakan kode pemulihan",
    login2fa_recovery_back: "Kembali",
    login2fa_recovery_placeholder: "XXXXXXXX",

    "change": "Mengubah", // In English: "Change"
    "clock_visibility": "Visibilitas Jam", // In English: "Clock Visibility"
    "reading": "Membaca %strong%", // In English: "Reading %strong%"
    "writing": "Menulis %strong%", // In English: "Writing %strong%"
    "unzipping": "Mengekstrak %strong%", // In English: "Unzipping %strong%"
    "sequencing": "Pengurutan %strong%", // In English: "Sequencing %strong%"
    "zipping": "Mengarsipkan %strong%", // In English: "Zipping %strong%"
    "Editor": "Editor", // In English: "Editor"
    "Viewer": "Penampil", // In English: "Viewer"
    "People with access": "Orang yang memiliki akses", // In English: "People with access"
    "Share With…": "Bagikan Dengan...", // In English: "Share With…"
    "Owner": "Pemilik", // In English: "Owner"
    "You can't share with yourself.": "Anda tidak bisa membaginya dengan diri sendiri.", // In English: "You can't share with yourself."
    "This user already has access to this item": "Pengguna ini telah memiliki akses ke barang ini", // In English: "This user already has access to this item"

    "billing.change_payment_method": "Ubah", // In English: "Change"
    "billing.cancel": "Batal", // In English: "Cancel"
    "billing.download_invoice": "Unduh", // In English: "Download"
    "billing.payment_method": "Metode Pembayaran", // In English: "Payment Method"
    "billing.payment_method_updated": "Metode pembayaran diperbarui!", // In English: "Payment method updated!"
    "billing.confirm_payment_method": "Konfirmasi Metode Pembayaran", // In English: "Confirm Payment Method"
    "billing.payment_history": "Riwayat Pembayaran", // In English: "Payment History"
    "billing.refunded": "Dikembalikan", // In English: "Refunded"
    "billing.paid": "Dibayar", // In English: "Paid"
    "billing.ok": "OK", // In English: "OK"
    "billing.resume_subscription": "Lanjutkan Berlangganan", // In English: "Resume Subscription"
    "billing.subscription_cancelled": "Langganan Anda telah dibatalkan.", // In English: "Your subscription has been canceled."
    "billing.subscription_cancelled_description": "Anda masih memiliki akses ke langganan Anda hingga akhir periode penagihan ini.", // In English: "You will still have access to your subscription until the end of this billing period."
    "billing.offering.free": "Gratis", // In English: "Free"
    "billing.offering.pro": "Profesional", // In English: "Professional"
    "billing.offering.business": "Bisnis", // In English: "Business"
    "billing.cloud_storage": "Penyimpanan Cloud", // In English: "Cloud Storage"
    "billing.ai_access": "Akses AI", // In English: "AI Access"
    "billing.bandwidth": "Bandwidth", // In English: "Bandwidth"
    "billing.apps_and_games": "Aplikasi & Game", // In English: "Apps & Games"
    "billing.switch_to": "Beralih ke %strong%", // In English: "Switch to %strong%"
    "billing.payment_setup": "Pengaturan Pembayaran", // In English: "Payment Setup"
    "billing.back": "Kembali", // In English: "Back"
    "billing.you_are_now_subscribed_to": "Anda sekarang berlangganan paket %strong%.", // In English: "You are now subscribed to %strong% tier."
    "billing.you_are_now_subscribed_to_without_tier": "Anda sekarang berlangganan", // In English: "You are now subscribed"
    "billing.subscription_cancellation_confirmation": "Apakah Anda yakin ingin membatalkan langganan Anda?", // In English: "Are you sure you want to cancel your subscription?"
    "billing.subscription_setup": "Pengaturan Langganan", // In English: "Subscription Setup"
    "billing.cancel_it": "Batalkan", // In English: "Cancel It"
    "billing.keep_it": "Pertahankan", // In English: "Keep It"
    "billing.subscription_resumed": "Langganan %strong% Anda telah dilanjutkan!", // In English: "Your %strong% subscription has been resumed!"
    //Note: literal translation of 'upgrade' is 'tingkatkan' but for this context 'upgrade' more commonly used
    "billing.upgrade": "Upgrade", // In English: "Upgrade"
    "billing.upgrade_to_pro": "Upgrade ke %strong%", // In English: "Upgrade to %strong%"
    "billing.upgrade_now": "Upgrade Sekarang", // In English: "Upgrade Now"
    "billing.currently_on_free_plan": "Anda saat ini menggunakan paket gratis.", // In English: "You are currently on the free plan."
    "billing.download_receipt": "Unduh Bukti Pembayaran", // In English: "Download Receipt"
    "billing.subscription_check_error": "Terjadi masalah saat memeriksa status langganan Anda.", // In English: "A problem occurred while checking your subscription status."
    "billing.email_confirmation_needed": "Email Anda belum dikonfirmasi. Kami akan mengirimkan kode untuk mengonfirmasinya sekarang.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
    "billing.sub_cancelled_but_valid_until": "Anda telah membatalkan langganan Anda dan secara otomatis akan beralih ke paket gratis di akhir periode penagihan. Anda tidak akan dikenakan biaya lagi kecuali Anda berlangganan ulang.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
    "billing.current_plan_until_end_of_period": "Paket Anda saat ini berlaku hingga akhir periode penagihan ini.", // In English: "Your current plan until the end of this billing period."
    "billing.current_plan": "Paket saat ini", // In English: "Current plan"
    "billing.cancelled_subscription_tier": "Langganan Dibatalkan (%%)", // In English: "Cancelled Subscription (%%)"
    "billing.manage": "Kelola", // In English: "Manage"
    "billing.limited": "Terbatas", // In English: "Limited"
    "billing.expanded": "Diperluas", // In English: "Expanded"
    "billing.accelerated": "Dipercepat", // In English: "Accelerated"
    "billing.enjoy_msg": "Nikmati %% dari Penyimpanan Cloud dan manfaat lainnya." // In English: "Enjoy %% of Cloud Storage plus other benefits."
  },
};

export default id;
