/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const hi = {
    name: "हिंदी",
    english_name: "Hindi",
    code: "hi",
    dictionary: {
        about: "के बारे में",
        account: "खाता",
        account_password: "खाता पासवर्ड सत्यापित करें",
        access_granted_to: "प्रवेश की अनुमति दी गई",
        add_existing_account: "मौजूदा खाता जोड़ें",
        all_fields_required: 'सभी स्थान आवश्यक हैं',
        allow: 'अनुमति दें',
        apply: "आवेदन करें",
        ascending: 'आरोही',
        associated_websites: "संबंधित वेबसाइटें",
        auto_arrange: 'स्वचालित व्यवस्तित',
        background: "पृष्ठभूमि",
        browse: "देखें",
        cancel: 'रद्द',
        center: 'केन्द्र',
        change_desktop_background: 'डेस्कटॉप पृष्ठभूमि बदलें…',
        change_email: "ई - मेल बदले",
        change_language: "भाषा बदलें",
        change_password: "पासवर्ड बदलें",
        change_ui_colors: "यूआई रंग बदलें",
        change_username: "उपयोगकर्ता नाम बदलें",
        close: 'बंद ',
        close_all_windows: "सभी विंडोज़ बंद करें",
        close_all_windows_confirm: "क्या आप निश्चय ही सभी विंडो बंद करना चाहते हैं?",
        close_all_windows_and_log_out: 'विंडोज़ बंद करें और लॉग आउट करें',
        change_always_open_with: "क्या आप इस प्रकार की फ़ाइल को हमेशा खोलना चाहते हैं?",
        color: 'रंग',
        confirm_2fa_setup: 'मैंने अपने प्रमाणक ऐप में कोड जोड़ दिया है',
        confirm_2fa_recovery: 'मैंने अपने पुनर्प्राप्ति कोड सुरक्षित स्थान पर सहेजे हैं',
        confirm_account_for_free_referral_storage_c2a: 'एक खाता बनाएं और 1 जीबी निःशुल्क संग्रहण प्राप्त करने के लिए अपने ईमेल पते की पुष्टि करें। आपके दोस्त को भी 1 जीबी मुफ्त स्टोरेज मिलेगा।',
        confirm_code_generic_incorrect: "गलत कोड़।",
        confirm_code_generic_too_many_requests: "बहुत सारे अनुरोध. कृपया कुछ मिनट प्रतीक्षा करें.",
        confirm_code_generic_submit: "कोड जमा करें",
        confirm_code_generic_try_again: "पुनः प्रयास करें",
        confirm_code_generic_title: "पुष्टि कोड दर्ज करें",
        confirm_code_2fa_instruction: "अपने प्रमाणक ऐप से 6 अंकों का कोड दर्ज करें।",
        confirm_code_2fa_submit_btn: "जमा करें",
        confirm_code_2fa_title: "2FA कोड दर्ज करें",
        confirm_delete_multiple_items: 'क्या आप वाकई इन वस्तुओं को स्थायी रूप से हटाना चाहते हैं?',
        confirm_delete_single_item: 'क्या आप वाकई इस वस्तु को स्थायी रूप से हटाना चाहते हैं?',
        confirm_open_apps_log_out: 'आपके पास ऐप्स खुला हैं. क्या आप लॉग आउट करना चाहते हैं?',
        confirm_new_password: "नए पासवर्ड की पुष्टि करें",
        confirm_delete_user: "क्या आप इस खाते को हटाने के लिए सुनिश्चित हैं? आपकी सभी फ़ाइलें और डेटा स्थायी रूप से हटा दिए जाएंगे. इस काम को वापस नहीं किया जा सकता।",
        confirm_delete_user_title: "खाता हटा दे?",
        confirm_session_revoke: "क्या आप वाकई इस सत्र को रद्द करना चाहते हैं?",
        confirm_your_email_address: "अपने ईमेल पते की पुष्टि करें",
        contact_us: "संपर्क करें",
        contact_us_verification_required: "इसका उपयोग करने के लिए आपके पास एक सत्यापित ईमेल पता होना चाहिए।",
        contain: 'रोकना',
        continue: "निरंतर",
        copy: 'प्रतिलिपि',
        copy_link: "लिंक की प्रतिलिपि करें",
        copying: "प्रतिलिपि बनाई जा रही",
        copying_file: "प्रतिलिपि बनाई जा रही %%",
        cover: 'ढकना',
        create_account: "खाता बनाएं",
        create_free_account: "मुफ्त खाता बनाएं",
        create_shortcut: "शॉर्टकट बनाएं",
        credits: "क्रेडिट",
        current_password: "वर्तमान पासवर्ड",
        cut: 'काटना',
        clock: "घड़ी",
        clock_visible_hide: 'छुपना - हमेशा छिपा रहना',
        clock_visible_show: 'दिखाएँ - सदैव दृश्यमान',
        clock_visible_auto: 'स्वतः - डिफ़ॉल्ट, केवल पूर्ण-स्क्रीन मोड में दृश्यमान।',
        close_all: 'सब बंद करें',
        created: 'बनाया',
        date_modified: 'तारीख संशोधित',
        default: 'पूर्व स्वरूप',
        delete: 'हटाए',
        delete_account: "खाता हटा दो",
        delete_permanently: "स्थायी रूप से मिटाएं",
        deleting_file: "हटाया जा रहा है %%",
        deploy_as_app: 'ऐप के रूप में तैनात करें',
        descending: 'अवरोही',
        desktop: 'डेस्कटॉप',
        desktop_background_fit: "उपयुक्त",
        developers: "डेवलपर्स",
        dir_published_as_website: "निर्देशिका को एक वेबसाइट के रूप में प्रकाशित किया गया है",
        disable_2fa: '2एफए गायब करें',
        disable_2fa_confirm: "क्या आप वाकई 2एफए को गायब करना चाहते हैं?",
        disable_2fa_instructions: "2एफए को गायब करने के लिए अपना पासवर्ड दर्ज करें।",
        disassociate_dir: "निर्देशिका को अलग करें",
        documents: 'दस्तावेज़',
        dont_allow: 'अनुमति न दें',
        download: 'डाउनलोड',
        download_file: 'डाउनलोड फ़ाइल',
        downloading: "डाउनलोड हो रहा है",
        email: "ईमेल",
        email_change_confirmation_sent: "आपके नए ईमेल पते पर एक पुष्टिकरण ईमेल भेज दिया गया है। कृपया अपना इनबॉक्स जांचें और प्रक्रिया पूरी करने के लिए निर्देशों का पालन करें।",
        email_invalid: 'ईमेल अमान्य है।',
        email_or_username: "ईमेल या उपयोगकर्ता का नाम",
        email_required: 'ईमेल की जरूरत है।',
        empty_trash: 'ट्रैश खाली करें',
        empty_trash_confirmation: "क्या आप वाकई ट्रैश में मौजूद आइटम को स्थायी रूप से हटाना चाहते हैं?",
        emptying_trash: 'ट्रैश खाली करना…',
        enable_2fa: '2एफए सक्षम करें',
        end_hard: "कठिन अंत",
        end_process_force_confirm: "क्या आप वाकई इस प्रक्रिया को बलपूर्वक छोड़ना चाहते हैं?",
        end_soft: "अंत नरम",
        enlarged_qr_code: "उन्नत क्यूआर कोड",
        enter_password_to_confirm_delete_user: "खाता हटाने की पुष्टि के लिए अपना पासवर्ड दर्ज करें",
        error_message_is_missing: "त्रुटि संदेश अनुपलब्ध है",
        error_unknown_cause: "एक अज्ञात त्रुटि हुई।",
        error_uploading_files: "फ़ाइलें अपलोड करने में विफल",
        favorites: "पसंदीदा",
        feedback: "प्रतिक्रिया",
        feedback_c2a: "कृपया हमें अपनी प्रतिक्रिया, टिप्पणियाँ और बग रिपोर्ट भेजने के लिए नीचे दिए गए फॉर्म का उपयोग करें।",
        feedback_sent_confirmation: "हमसे संपर्क करने के लिए धन्यवाद। यदि आपके पास अपने खाते से जुड़ा कोई ईमेल है, तो आप यथाशीघ्र हमसे जवाब प्राप्त करेंगे।",
        fit: "उपयुक्त",
        folder: 'फ़ोल्डर',
        force_quit: 'जबरन छोड़ना',
        forgot_pass_c2a: "पासवर्ड भूल गए?",
        from: "से",
        general: "सामान्य",
        get_a_copy_of_on_puter: "Purer.com पर '%%' की एक कॉपी प्राप्त करें!",
        get_copy_link: 'कॉपी लिंक प्राप्त करें',
        hide_all_windows: "सभी विंडोज़ छिपाएँ",
        home: 'घर',
        html_document: 'एचटीएमएल दस्तावेज़',
        hue: 'रंग',
        image: 'छवि',
        incorrect_password: "गलत पासवर्ड",
        invite_link: "लिंक आमंत्रित करें",
        item: 'वस्तु',
        items_in_trash_cannot_be_renamed: "इस वस्तु का नाम नहीं बदला जा सकता क्योंकि यह कूड़ेदान में है। इस वस्तु का नाम बदलने के लिए, पहले इसे ट्रैश से बाहर खींचें।",
        jpeg_image: 'जेपीईजी छवि',
        keep_in_taskbar: 'टास्कबार में रखें',
        language: "भाषा",
        license: "लाइसेंस",
        lightness: 'चमक',
        link_copied: "लिंक कॉपी किया गया",
        loading: 'लोड हो रहा है',
        log_in: "लॉग इन करें",
        log_into_another_account_anyway: 'फिर भी दूसरे खाते में लॉग इन करें',
        log_out: 'लॉग आउट',
        looks_good: "अच्छा लग रहा है!",
        manage_sessions: "सत्र प्रबंधित करें",
        menubar_style: "मेनूबार शैली",
        menubar_style_desktop: "डेस्कटॉप",
        menubar_style_system: "प्रणाली",
        menubar_style_window: "खिड़की",
        modified: 'संशोधित',
        move: 'बदले',
        moving_file: "जा रहे हैं %%",
        my_websites: "मेरी वेबसाइटें",
        name: 'नाम',
        name_cannot_be_empty: 'नाम खाली नहीं हो सकता',
        name_cannot_contain_double_period: "नाम '..' वर्ण नहीं हो सकता",
        name_cannot_contain_period: "नाम '.' वर्ण नहीं हो सकता",
        name_cannot_contain_slash: "नाम में '/' वर्ण नहीं हो सकता",
        name_must_be_string: "नाम केवल एक स्ट्रिंग हो सकता है",
        name_too_long: "नाम %% वर्णों से अधिक लंबा नहीं हो सकता",
        new: 'नया',
        new_email: 'नया ईमेल',
        new_folder: 'नया फ़ोल्डर',
        new_password: "नया पासवर्ड",
        new_username: "नया उपयोगकर्ता नाम",
        no: 'नहीं',
        no_dir_associated_with_site: 'इस पते से कोई निर्देशिका संबद्ध नहीं है',
        no_websites_published: "आपने अभी तक कोई वेबसाइट प्रकाशित नहीं की है",
        ok: 'ठीक है',
        open: "खुला",
        open_in_new_tab: "वेब टेब में खोलें",
        open_in_new_window: "नई विंडो में खोलें",
        open_with: "के साथ खोलें",
        original_name: 'वास्तविक नाम',
        original_path: 'वास्तविक पथ',
        oss_code_and_content: "ओपन सोर्स सॉफ्टवेयर और सामग्री",
        password: "पासवर्ड",
        password_changed: "पासवर्ड बदला गया।",
        password_recovery_rate_limit: "आप हमारी दर-सीमा तक पहुंच गए हैं; कृपया कुछ मिनट प्रतीक्षा करें. भविष्य में इसे रोकने के लिए, पृष्ठ को कई बार पुनः लोड करने से बचें।",
        password_recovery_token_invalid: "यह पासवर्ड पुनर्प्राप्ति टोकन अब मान्य नहीं है.",
        password_recovery_unknown_error: "एक अज्ञात त्रुटि हुई। कृपया बाद में पुन: प्रयास करें।",
        password_required: 'पासवर्ड की आवश्यकता है।',
        password_strength_error: "पासवर्ड कम से कम 8 अक्षर लंबा होना चाहिए और इसमें कम से कम एक अपरकेस अक्षर, एक लोअरकेस अक्षर, एक संख्या और एक विशेष अक्षर होना चाहिए।",
        passwords_do_not_match: '`नया पासवर्ड` और `नए पासवर्ड की पुष्टि करें` मेल नहीं खाते।',
        paste: 'पेस्ट करें',
        paste_into_folder: "फ़ोल्डर में पेस्ट करें",
        path: 'पथ',
        personalization: "वैयक्तिकरण",
        pick_name_for_website: "अपनी वेबसाइट के लिए एक नाम चुनें:",
        picture: "चित्र",
        pictures: 'चित्रों',
        plural_suffix: 'एस',
        powered_by_puter_js: "{{link=docs}}Puter.js{{/link}} द्वारा संचालित",
        preparing: "तैयार कर रहे हैं...",
        preparing_for_upload: "अपलोड करने की तैयारी है...",
        print: 'छाप',
        privacy: "गोपनीयता",
        proceed_to_login: 'लॉगिन करने के लिए आगे बढ़ें',
        proceed_with_account_deletion: "खाता हटाने के साथ आगे बढ़ें",
        process_status_initializing: "शुरु कर रहा है",
        process_status_running: "दौड़ना",
        process_type_app: 'अनुप्रयोग',
        process_type_init: 'इस में',
        process_type_ui: 'यूआई',
        properties: "गुण",
        public: 'लोग',
        publish: "प्रकाशित",
        publish_as_website: 'वेबसाइट के रूप में प्रकाशित करें',
        puter_description: "पुटर एक गोपनीयता-प्रथम व्यक्तिगत क्लाउड है जो आपकी सभी फ़ाइलों, ऐप्स और गेम को एक सुरक्षित स्थान पर रखता है, जिसे किसी भी समय कहीं से भी एक्सेस किया जा सकता है।",
        reading_file: "पढ़ना  %strong%",
        recent: "हाल ही में",
        recommended: "अनुशंसित",
        recover_password: "पासवर्ड वापस लाये",
        refer_friends_c2a: "पुटर पर खाता बनाने और पुष्टि करने वाले प्रत्येक मित्र के लिए 1 जीबी प्राप्त करें। आपके दोस्त को भी मिलेगा 1 जीबी!",
        refer_friends_social_media_c2a: "Purer.com पर 1 जीबी निःशुल्क स्टोरेज प्राप्त करें!",
        refresh: 'ताजा करना ',
        release_address_confirmation: "क्या आप वाकई यह पता जारी करना चाहते हैं?",
        remove_from_taskbar:'टास्कबार से हटाएँ',
        rename: 'नाम बदलें',
        repeat: 'दोहराना',
        replace: 'प्रतिस्थापित करें',
        replace_all: 'सबको बदली करें',
        resend_confirmation_code: "पुष्टिकरण कोड पुनः भेजें",
        reset_colors: "रंग रीसेट करें",
        restart_puter_confirm: "क्या आप वाकई पुटर को पुनः आरंभ करना चाहते हैं?",
        restore: "पुनर्स्थापित",
        save: 'सहेजें',
        saturation: 'परिपूर्णता',
        save_account: 'खाता सहेजें',
        save_account_to_get_copy_link: "कृपया आगे बढ़ने के लिए एक खाता बनाएँ।",
        save_account_to_publish: 'कृपया आगे बढ़ने के लिए एक खाता बनाएँ।',
        save_session: 'सत्र को बचाए',
        save_session_c2a: 'अपने वर्तमान सत्र को सहेजने और अपना काम खोने से बचने के लिए एक खाता बनाएं।',
        scan_qr_c2a: 'अन्य डिवाइस से इस सत्र में लॉग इन करने के लिए नीचे दिए गए कोड को स्कैन करें',
        scan_qr_2fa: 'अपने प्रमाणक ऐप से क्यूआर कोड को स्कैन करें',
        scan_qr_generic: 'अपने फ़ोन या किसी अन्य डिवाइस का उपयोग करके इस क्यूआर कोड को स्कैन करें',
        search: 'खोजे',
        seconds: 'सेकंड',
        security: "सुरक्षा",
        select: "चुने",
        selected: 'चयनित',
        select_color: 'रंग चुने…',
        sessions: "सत्र",
        send: "भेजे",
        send_password_recovery_email: "पासवर्ड पुनर्प्राप्ति ईमेल भेजें",
        session_saved: "खाता बनाने के लिए धन्यवाद. यह सत्र सहेजा गया है",
        settings: "समायोजन",
        set_new_password: "नया पासवर्ड सेट करें",
        share: "आदान-प्रदान",
        share_to: "साझा",
        share_with: "के साथ साझा करें",
        shortcut_to: "के लिए शॉर्टकट",
        show_all_windows: "सभी विंडोज़ दिखाएँ",
        show_hidden: 'छिपा हुआ दिखाएं',
        sign_in_with_puter: "पुटर के साथ साइन इन करें",
        sign_up: "साइन अप करें",
        signing_in: "साइन कर रहे हैं…",
        size: 'आकार',
        skip: 'छोडना',
        something_went_wrong: "कुछ गलत हो गया।",
        sort_by: 'इसके अनुसार क्रमबद्ध करें',
        start: 'शुरू',
        status: "स्थिति",
        storage_usage: "भंडारण उपयोग",
        storage_puter_used: 'पुटर द्वारा उपयोग किया गया',
        taking_longer_than_usual: 'सामान्य से थोड़ा अधिक समय लग रहा है. कृपया प्रतीक्षा करें...',
        task_manager: "कार्य प्रबंधक",
        taskmgr_header_name: "नाम",
        taskmgr_header_status: "स्थिति",
        taskmgr_header_type: "प्रकार",
        terms: "Terms",
        text_document: 'Text document',
        tos_fineprint: "'निःशुल्क खाता बनाएं' पर क्लिक करके आप पुटर की {{link=terms}}सेवा की शर्तों{{/लिंक}} और {{link=privacy}}गोपनीयता नीति{{/लिंक}} से सहमत होते हैं।",
        transparency: "पारदर्शिता",
        trash: 'कचरा',
        two_factor: 'दो तरीकों से प्रमाणीकरण',
        two_factor_disabled: '2एफए अक्षम',
        two_factor_enabled: '2एफए सक्षम',
        type: 'प्रकार',
        type_confirm_to_delete_account: "अपना खाता हटाने के लिए 'पुष्टि करें' टाइप करें।",
        ui_colors: "यूआई रंग",
        ui_manage_sessions: "सत्र प्रबंधक",
        ui_revoke: "रद्द",
        undo: 'पूर्ववत',
        unlimited: 'असीमित',
        unzip: "खोलना",
        upload: 'डालना',
        upload_here: 'यहाँ अपलोड करें',
        usage: 'प्रयोग',
        username: "उपयोगकर्ता नाम",
        username_changed: 'उपयोगकर्ता नाम सफलतापूर्वक अपडेट किया गया',
        username_required: 'उपयोगकर्ता नाम आवश्यक है।',
        versions: "संस्करणों",
        videos: 'वीडियो',
        visibility: 'दृश्यता',
        yes: 'हाँ',
        yes_release_it: 'हाँ, इसे जारी करें',
        you_have_been_referred_to_puter_by_a_friend: "आपको एक मित्र ने पुटर के बारे में बताया है!",
        zip: "ज़िप",
        zipping_file: "ज़िपिंग  %strong%",

        // === 2FA Setup ===
        setup2fa_1_step_heading: 'अपना प्रमाणक ऐप खोलें',      
        setup2fa_1_instructions: "आप किसी भी प्रमाणक ऐप का उपयोग कर सकते हैं जो टाइम-आधारित वन-टाइम पासवर्ड (टीओटीपी) प्रोटोकॉल का समर्थन करता है।चुनने के लिए बहुत कुछ है, लेकिन यदि आप अनिश्चित हैं <a target='_blank' href='https://authy.com/download'>Authy</a>Android और iOS के लिए एक ठोस विकल्प है",
        setup2fa_2_step_heading: 'क्यूआर कोड को स्कैन करें',
        setup2fa_3_step_heading: '6 अंकीय कोड दर्ज करें',
        setup2fa_4_step_heading: 'अपने पुनर्प्राप्ति कोड कॉपी करें',
        setup2fa_4_instructions: "यदि आप अपना फ़ोन खो देते हैं या अपने प्रमाणक ऐप का उपयोग नहीं कर पाते हैं तो ये पुनर्प्राप्ति कोड आपके खाते तक पहुंचने का एकमात्र तरीका हैं।उन्हें सुरक्षित स्थान पर संग्रहित करना सुनिश्चित करें।",
        setup2fa_5_step_heading: '2एफए सेटअप की पुष्टि करें',
        setup2fa_5_confirmation_1: 'मैंने अपने पुनर्प्राप्ति कोड सुरक्षित स्थान पर सहेजे हैं',
        setup2fa_5_confirmation_2: 'मैं 2एफए सक्षम करने के लिए तैयार हूं',
        setup2fa_5_button: '2एफए सक्षम करें',

        // === 2FA Login ===
        login2fa_otp_title: '2एफए कोड दर्ज करें',
        login2fa_otp_instructions: 'अपने प्रमाणक ऐप से 6 अंकों का कोड दर्ज करें।',
        login2fa_recovery_title: 'एक पुनर्प्राप्ति कोड दर्ज करें',
        login2fa_recovery_instructions: 'अपने खाते तक पहुंचने के लिए अपना एक पुनर्प्राप्ति कोड दर्ज करें।',
        login2fa_use_recovery_code: 'पुनर्प्राप्ति कोड का उपयोग करें',
        login2fa_recovery_back: 'पीछे',
        login2fa_recovery_placeholder: 'XXXXXXXX',

        "change": "बदलें", // In English: "Change"
        "clock_visibility": "घड़ी की दृश्यता", // In English: "Clock Visibility"
        "confirm": "पुष्टि करें", // In English: "Confirm"
        "reading": "पढ़ना %strong%", // In English: "Reading %strong%"
        "writing": "लिखना %strong%", // In English: "Writing %strong%"
        "unzipping": "अनज़िपिंग %strong%", // In English: "Unzipping %strong%"
        "sequencing": "क्रमबद्ध करना %strong%", // In English: "Sequencing %strong%"
        "zipping": "ज़िपिंग %strong%", // In English: "Zipping %strong%"
        "Editor": "संपादक", // In English: "Editor"
        "Viewer": "दर्शक", // In English: "Viewer"
        "People with access": "प्रवेश वाले लोग", // In English: "People with access"
        "Share With…": "के साथ साझा करें…", // In English: "Share With…"
        "Owner": "मालिक", // In English: "Owner"
        "You can't share with yourself.": "आप अपने आप के साथ साझा नहीं कर सकते।", // In English: "You can't share with yourself."
        "This user already has access to this item": "इस उपयोगकर्ता के पास पहले से ही इस वस्तु का प्रवेश है", // In English: "This user already has access to this item"

        "billing.change_payment_method": "बदलें", // In English: "Change"
        "billing.cancel": "रद्द करें", // In English: "Cancel"
        "billing.download_invoice": "डाउनलोड करें", // In English: "Download"
        "billing.payment_method": "भुगतान की विधि", // In English: "Payment Method"
        "billing.payment_method_updated": "भुगतान विधि अद्यतन किया गया!", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "भुगतान विधि की पुष्टि करें।", // In English: "Confirm Payment Method"
        "billing.payment_history": "भुगतान इतिहास", // In English: "Payment History"
        "billing.refunded": "धनवापसी पूरी हुई।", // In English: "Refunded"
        "billing.paid": "भुगतान चुकाया गया है।", // In English: "Paid"
        "billing.ok": "ठीक है।", // In English: "OK"
        "billing.resume_subscription": "सदस्यता फिर से शुरू करें।", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "आपकी सदस्यता रद्द कर दी गई है।", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "इस विधेयक अवधि के अंत तक आप अपनी सदस्यता का उपयोग कर पाएंगे।", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "मुक्त", // In English: "Free"
        "billing.offering.pro": "पेशेवर", // In English: "Professional"
        "billing.offering.business": "व्यापार", // In English: "Business"
        "billing.cloud_storage": "क्लाउड स्टोरेज", // In English: "Cloud Storage"
        "billing.ai_access": "एआई पहुँच", // In English: "AI Access"
        "billing.bandwidth": "डाटा संचरण क्षमता", // In English: "Bandwidth"
        "billing.apps_and_games": "अनुप्रयोग और खेल", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "%strong% में अपग्रेड करें", // In English: "Upgrade to %strong%"
        "billing.switch_to": "%strong% पर बदलें", // In English: "Switch to %strong%"
        "billing.payment_setup": "भुगतान व्यवस्था", // In English: "Payment Setup"
        "billing.back": "पीछे", // In English: "Back"
        "billing.you_are_now_subscribed_to": "अब आप %strong% स्तर की सदस्यता ले चुके हैं।", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "अब आप सदस्य बन चुके हैं।", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "क्या आप वाकई अपनी सदस्यता रद्द करना चाहते हैं?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "सदस्यता व्यवस्था", // In English: "Subscription Setup"
        "billing.cancel_it": "इसे रद्द करें", // In English: "Cancel It"
        "billing.keep_it": "इसे रखें", // In English: "Keep It"
        "billing.subscription_resumed": "आपकी %strong% सदस्यता फिर से सक्रिय हो गई है!", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "अभी उन्नत करें।", // In English: "Upgrade Now"
        "billing.upgrade": "उन्नति करें", // In English: "Upgrade"
        "billing.currently_on_free_plan": "आप वर्तमान में मुफ्त योजना पर हैं।", // In English: "You are currently on the free plan."
        "billing.download_receipt": "रसीद डाउनलोड करें", // In English: "Download Receipt"
        "billing.subscription_check_error": "आपकी सदस्यता स्थिति जांचते समय एक समस्या हुई।", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "आपका ईमेल सत्यापित नहीं हुआ है। हम इसे सत्यापित करने के लिए आपको एक कोड भेजेंगे।", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "आपने अपनी सदस्यता रद्द कर दी है और यह विधेयक अवधि के अंत में स्वचालित रूप से मुफ्त योजना पर बदल जाएगी। जब तक आप फिर से सदस्यता नहीं लेते, तब तक आपसे फिर से शुल्क नहीं लिया जाएगा।", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "आपकी वर्तमान योजना इस विधेयक अवधि के अंत तक।", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "वर्तमान योजना", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "रद्द की गई (%%) सदस्यता", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "प्रबंधन", // In English: "Manage"
        "billing.limited": "सीमित", // In English: "Limited"
        "billing.expanded": "विस्तारित ", // In English: "Expanded"
        "billing.accelerated": "त्वरित ", // In English: "Accelerated"
        "billing.enjoy_msg": "%% क्लाउड स्टोरेज का आनंद लें और अन्य लाभ प्राप्त करें।", // In English: "Enjoy %% of Cloud Storage plus other benefits."

    }
};

export default hi;

