/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const en = {
  name: "עברית",
  english_name: "Hebrew",
  code: "he",
  dictionary: {
    about: "אודות",
    account: "חשבון",
    account_password: "אמת את סיסמת החשבון",
    access_granted_to: "ניתנת גישה ל",
    add_existing_account: "הוספת חשבון קיים",
    all_fields_required: "כל השדות הם שדות חובה.",
    allow: "להרשות",
    apply: "ביצוע",
    ascending: "בסדר עולה",
    associated_websites: "אתרים קשורים",
    auto_arrange: "סידור אוטומטי",
    background: "רקע",
    browse: "דפדף",
    cancel: "ביטול",
    center: "אמצע",
    change_desktop_background: "שינוי רקע לשולחן העבודה…",
    change_email: "שינוי כתובת אימייל",
    change_language: "החלפת שפה",
    change_password: "שינוי סיסמה",
    change_ui_colors: "שינוי צבעי ממשק המשתמש",
    change_username: "שינוי שם משתמש",
    close: "סגירה",
    close_all_windows: "סגירת כל החלונות",
    close_all_windows_confirm: "האם אתה בטוח שברצונך לסגור את כל החלונות?",
    close_all_windows_and_log_out: "סגור את החלונות והתנתק",
    change_always_open_with: "האם אתה רוצה תמיד לפתוח סוג זה של קובץ עם",
    color: "צבע",
    confirm: "לאשר",
    confirm_2fa_setup: "הוספתי את הקוד לאפליקצית האימות שלי",
    confirm_2fa_recovery: "שמרתי את קודי השחזור שלי במיקום מאובטח",
    confirm_account_for_free_referral_storage_c2a:
      'צור חשבון ואשר את כתובת הדוא"ל שלך כדי לקבל 1 גיגה בייט של אחסון בחינם. חברך יקבל גם 1 גיגה בייט של אחסון בחינם.',
    confirm_code_generic_incorrect: "קוד שגוי.",
    confirm_code_generic_too_many_requests:
      "יותר מדי בקשות. אנא המתינו מספר דקות.",
    confirm_code_generic_submit: "שלח קוד",
    confirm_code_generic_try_again: "נסה שוב",
    confirm_code_generic_title: "הזן קוד אישור",
    confirm_code_2fa_instruction: "הזינו את הקוד בן 6 הספרות מאפליקציית המאמת.",
    confirm_code_2fa_submit_btn: "שלח",
    confirm_code_2fa_title: "הזינו קוד אימות דו-שלבי",
    confirm_delete_multiple_items:
      "האם אתה בטוח שברצונך למחוק פריטים אלה לצמיתות?",
    confirm_delete_single_item: "האם ברצונך למחוק פריט זה לצמיתות?",
    confirm_open_apps_log_out:
      "יש לך אפליקציות פתוחות. האם אתה בטוח שברצונך להתנתק",
    confirm_new_password: "אשר סיסמה חדשה",
    confirm_delete_user:
      "האם אתה בטוח שברצונך למחוק את חשבונך? כל הקבצים והנתונים שלך יימחקו לצמיתות. לא ניתן לבטל פעולה זו.",
    confirm_delete_user_title: "מחיקת חשבון?",
    confirm_session_revoke: "האם אתה בטוח שברצונך לבטל ישיבה זו?",
    confirm_your_email_address: "אשר את כתובת האימייל שלך",
    contact_us: "צור קשר",
    contact_us_verification_required:
      "עליך להיות בעל כתובת אימייל מאומתת כדי להשתמש בזה.",
    contain: "מכיל",
    continue: "המשיך",
    copy: "העתק",
    copy_link: "העתק קישור",
    copying: "מעתיק",
    copying_file: "מעתיק %%",
    cover: "כיסוי",
    create_account: "יצירת חשבון",
    create_free_account: "יצירת חשבון חנמי",
    create_shortcut: "יצירת קיצור דרך",
    credits: "הערכה",
    current_password: "סיסמה נוכחית",
    cut: "גזירה",
    clock: "שעון",
    clock_visible_hide: "הסתר - תמיד מוסתר",
    clock_visible_show: "הצג - תמיד מוצג",
    clock_visible_auto: "אוטומטי - ברירת מחדל, מוצג רק במצב מסך מלא.",
    close_all: "סגירת הכל",
    created: "נוצר",
    date_modified: "תאריך שינוי",
    default: "ברירת מחדל",
    delete: "מחיקה",
    delete_account: "מחיקת חשבון",
    delete_permanently: "מחיקה לצמיתות",
    deleting_file: "מוחק %%",
    deploy_as_app: "לפרוס כאפליקציה",
    descending: "בסדר יורד",
    desktop: "שולחן העבודה ",
    desktop_background_fit: "התאים",
    developers: "מפתחים",
    dir_published_as_website: `%strong% פורסם ל:`,
    disable_2fa: "השבתת אימות דו-שלבי",
    disable_2fa_confirm: "האם אתם בטוחים שברצונכם להשבית אימות דו-שלבי?",
    disable_2fa_instructions: "הזינו את הסיסמה שלכם כדי להשבית אימות דו-שלבי.",
    disassociate_dir: "נתק מדריך",
    documents: "מסמכים",
    dont_allow: "אל תאפשר",
    download: "הורדה",
    download_file: "הורדת קובץ",
    downloading: "מוריד",
    email: "אימייל",
    email_change_confirmation_sent:
      "אימייל אישור נשלח לכתובת האימייל החדשה שלך. אנא בדוק את תיבת הדואר הנכנס ופעל לפי ההוראות להשלמת התהליך.",
    email_invalid: "כתובת האימייל אינה חוקית.",
    email_or_username: "אימייל או שם משתמש",
    email_required: "אימייל חובה.",
    empty_trash: "ריקון אשפה",
    empty_trash_confirmation: `האם אתה בטוח שברצונך למחוק לצמיתות את הפריטים באשפה?`,
    emptying_trash: "מרוקן אשפה…",
    enable_2fa: "הפעלת אימות דו-שלבי",
    end_hard: "נגמר קשה",
    end_process_force_confirm:
      "האם אתה בטוח שאתה רוצה להפסיק בכוח את התהליך הזה?",
    end_soft: "נגמר ברכות",
    enlarged_qr_code: "קוד QR מוגדל",
    enter_password_to_confirm_delete_user:
      "הזן את הסיסמה שלך כדי לאשר את מחיקת החשבון",
    error_message_is_missing: "הודעת שגיאה חסרה.",
    error_unknown_cause: "אירעה שגיאה לא ידועה.",
    error_uploading_files: "העלאת קבצים נכשלה",
    favorites: "מועדפים",
    feedback: "משוב",
    feedback_c2a:
      "אנא השתמש בטופס שלהלן כדי לשלוח לנו את המשוב, ההערות ודוחות הבאגים שלך.",
    feedback_sent_confirmation:
      "תודה שפנית אלינו. אם יש לך איממיל המשויך לחשבון שלך, נחזור אליכם בהקדם האפשרי.",
    fit: "להתאים",
    folder: "תיקיה",
    force_quit: "לעזוב בכוח",
    forgot_pass_c2a: "שכחת את הסיסמא?",
    from: "טופס",
    general: "כללי",
    get_a_copy_of_on_puter: `קבל עותק של '%%' ב Puter.com!`,
    get_copy_link: "קבל העתק קישור",
    hide_all_windows: "הסתר את כל החלונות",
    home: "בית",
    html_document: "מסמך HTML",
    hue: "דרגת צבע",
    image: "תמונה",
    incorrect_password: "סיסמה שגויה",
    invite_link: "קישור הזמנה",
    item: "פריט",
    items_in_trash_cannot_be_renamed: `לא ניתן לשנות את שם הפריט הזה כי הוא נמצא באשפה. כדי לשנות את שם הפריט הזה, תחילה גרור אותו מחוץ לאשפה.`,
    jpeg_image: "JPEG תמונת",
    keep_in_taskbar: "שמירה בשורת המשימות",
    language: "שפה",
    license: "רישיון",
    lightness: "בהירות",
    link_copied: "הקישור הועתק",
    loading: "טוען",
    log_in: "התחברות",
    log_into_another_account_anyway: "התחבר לחשבון אחר בכל מקרה",
    log_out: "התנתק",
    looks_good: "נראה טוב!",
    manage_sessions: "ניהול ישיבות",
    menubar_style: "סגנון שורת התפריט",
    menubar_style_desktop: "שולחן העבודה",
    menubar_style_system: "מערכת",
    menubar_style_window: "חַלוֹן",
    modified: "שונה",
    move: "לעבור",
    moving_file: "מעביר %%",
    my_websites: "אתרי האינטרנט שלי",
    name: "שם",
    name_cannot_be_empty: "השם לא יכול להיות ריק.",
    name_cannot_contain_double_period: "השם לא יכול להיות עם סימן '..'.",
    name_cannot_contain_period: "השם לא יכול להיות עם סימן '.'.",
    name_cannot_contain_slash: "השם לא יכול להיות עם סימן '/'.",
    name_must_be_string: "השם יכול להיות רק מחרוזת.",
    name_too_long: `השם לא יכול להיות ארוך מ %% אותיות.`,
    new: "חדש",
    new_email: "אימייל חדש",
    new_folder: "תיקייה חדשה",
    new_password: "סיסמה חדשה",
    new_username: "שם משתמש חדש",
    no: "לא",
    no_dir_associated_with_site: "אין ספריה המשויכת לכתובת זו.",
    no_websites_published:
      "עדיין לא פרסמת אתרי אינטרנט. לחץ לחיצה ימנית על תיקיה כדי להתחיל.",
    ok: "בסדר",
    open: "פתח",
    open_in_new_tab: "פתח בלשונית חדשה",
    open_in_new_window: "פתח בחלון חדש",
    open_with: "לפתוח באמצעות",
    original_name: "שם מקורי",
    original_path: "מסלול מקורי",
    oss_code_and_content: "תוכנה ותוכן בקוד פתוח",
    password: "סיסמה",
    password_changed: "הסיסמה השתנתה.",
    password_recovery_rate_limit:
      "הגעתם למגבלת התעריף שלנו; אנא המתינו מספר דקות. כדי למנוע זאת בעתיד, הימנע מטעינה מחדש של הדף יותר מדי פעמים.",
    password_recovery_token_invalid: "טוקן שחזור סיסמה זה אינו חוקי יותר.",
    password_recovery_unknown_error:
      "אירעה שגיאה לא ידועה. נסה שוב מאוחר יותר.",
    password_required: "סיסמה חובה.",
    password_strength_error:
      "הסיסמה חייבת להיות באורך של 8 תווים לפחות ולהכיל לפחות אות גדולה אחת , אות קטנה אחת, מספר אחד ותו מיוחד אחד.",
    passwords_do_not_match: "`סיסמה חדשה` ו `אשר סיסמה חדשה` אינן תואמות.",
    paste: "הדבק",
    paste_into_folder: "הדבק בתיקיה",
    path: "מסלול",
    personalization: "התאמה אישית",
    pick_name_for_website: "בחר שם לאתר האינטרנט שלך:",
    picture: "תמונה",
    pictures: "תמונות",
    plural_suffix: "s",
    powered_by_puter_js: `מונע ע"י {{link=docs}}Puter.js{{/link}}`,
    preparing: "מכין...",
    preparing_for_upload: "מתכוננים להעלאה...",
    print: "הדפס",
    privacy: "פרטיות",
    proceed_to_login: "המשך לכניסה",
    proceed_with_account_deletion: "המשך למחיקת חשבון",
    process_status_initializing: "אתחול",
    process_status_running: "עובד",
    process_type_app: "אפליקציה",
    process_type_init: "התחלתי",
    process_type_ui: "ממשק משתמש",
    properties: "תכונות",
    public: "ציבורי",
    publish: "פרסם",
    publish_as_website: "פרסום כאתר אינטרנט",
    puter_description: `Puter הוא ענן אישי ששם את הפרטיות בראש סדר העדיפויות כדי לשמור על כל הקבצים שלך, האפליקציות  ו המשחקים במקום מאובטח אחד, נגיש מכל מקום ובכל זמן.`,
    reading_file: "קורא %strong%",
    recent: "לאחרונה",
    recommended: "מומלץ",
    recover_password: "שחזור סיסמה",
    refer_friends_c2a:
      "קבל 1 גיגה בייט עבור כל חבר שיוצר ומאשר חשבון ב  Puter. גם החבר שלך יקבל 1 גיגה בייט!",
    refer_friends_social_media_c2a: `קבל שטח אחסון של 1 גיגה בייט בחינם Puter.com!`,
    refresh: "רענן",
    release_address_confirmation: `האם אתה בטוח שברצונך לשחרר כתובת זו?`,
    remove_from_taskbar: "הסרה משורת המשימות",
    rename: "שנה שם",
    repeat: "חזור",
    replace: "החלף",
    replace_all: "החלף הכל",
    resend_confirmation_code: "שליחה מחדש של קוד אישור",
    reset_colors: "איפוס צבעים",
    restart_puter_confirm: "האם אתה בטוח שברצונך להפעיל Puter מחדש ?",
    restore: "שחזור",
    save: "שמירה",
    saturation: "הרויה",
    save_account: "שמירת חשבון",
    save_account_to_get_copy_link: "אנא צור חשבון כדי להמשיך.",
    save_account_to_publish: "אנא צור חשבון כדי להמשיך.",
    save_session: "שמירת הפעלה",
    save_session_c2a:
      "צור חשבון כדי לשמור את ההפעלה הנוכחית שלך ולהימנע מאובדן העבודה שלך.",
    scan_qr_c2a: "סרוק את הקוד שלהלן\nכדי להתחבר להפעלה זו ממכשירים אחרים",
    scan_qr_2fa: "סרוק את קוד ה- QR באמצעות אפליקציית האימות שלך",
    scan_qr_generic: "סרוק קוד QR זה באמצעות הטלפון שלך או מכשיר אחר",
    search: "חיפוש",
    seconds: "שניות",
    security: "אבטחה",
    select: "לבחירה",
    selected: "נבחר",
    select_color: "בחירת צבע…",
    sessions: "ישיבות",
    send: "שלח",
    send_password_recovery_email: "שלח אימייל שחזור סיסמה",
    session_saved: "תודה שיצרת חשבון. הפעלה זו נשמרה",
    settings: "הגדרות",
    set_new_password: "הגדרת סיסמה חדשה",
    share: "שיתוף",
    share_to: "שתף אל",
    share_with: "שתף עם:",
    shortcut_to: "קיצור דרך אל",
    show_all_windows: "הצג את כל החלונות",
    show_hidden: "הצג מוסתר",
    sign_in_with_puter: "להתחבר עם Puter",
    sign_up: "הרשמה",
    signing_in: "התחברות…",
    size: "גודל",
    skip: "דלג",
    something_went_wrong: "משהו השתבש.",
    sort_by: "מיין לפי",
    start: "התחלה",
    status: "סטטוס",
    storage_usage: "שימוש באחסון",
    storage_puter_used: "בשימוש על ידי Puter",
    taking_longer_than_usual: "לוקח קצת יותר זמן מהרגיל. חכה בבקשה...",
    task_manager: "מנהל משימות",
    taskmgr_header_name: "שם",
    taskmgr_header_status: "סטטוס",
    taskmgr_header_type: "סוג",
    terms: "תנאים",
    text_document: "מסמך טקסטואלי",
    tos_fineprint: `על ידי לחיצה על 'צור חשבון חינם' אתה מסכים Puter's {{link=terms}}תנאי שימוש{{/link}} ו {{link=privacy}}מדיניות פרטיות{{/link}}.`,
    transparency: "שקיפות",
    trash: "אשפה",
    two_factor: "אימות דו-שלבי",
    two_factor_disabled: "אימות דו-שלבי הושבת",
    two_factor_enabled: "אימות דו-שלבי הופעל",
    type: "סוג",
    type_confirm_to_delete_account: "הקלד 'אישור' כדי למחוק את חשבונך.",
    ui_colors: "צבעי ממשק משתמש",
    ui_manage_sessions: "מנהל ישיבות",
    ui_revoke: "בטל",
    undo: "בטל",
    unlimited: "ללא הגבלה",
    unzip: "פתח קובץ מכווץ",
    upload: "העלאה",
    upload_here: "העלה כאן",
    usage: "שמוש",
    username: "שם משתמש",
    username_changed: "שם המשתמש עודכן בהצלחה.",
    username_required: "שם משתמש חובה.",
    versions: "גרסאות",
    videos: "סרטונים",
    visibility: "נראות",
    yes: "כן",
    yes_release_it: "כן, שחררו אותו",
    you_have_been_referred_to_puter_by_a_friend: "הופנית אל Puter על ידי חבר!",
    zip: "מכווץ",
    zipping_file: "מכווץ קובץ %strong%",

    // === 2FA Setup ===
    setup2fa_1_step_heading: "פתחו את אפליקציית המאמת",
    setup2fa_1_instructions: `
            אתה יכול להשתמש בכל אפליקציית אימות התומכת בפרוטוקול סיסמה חד פעמית מבוססת זמן (TOTP).
 יש הרבה לבחירה, אבל אם אתה לא בטוח
            <a target="_blank" href="https://authy.com/download">Authy</a>
            היא בחירה סולידית עבור אנדרואיד ו- iOS.
        `,
    setup2fa_2_step_heading: "סרוק את קוד ה- QR",
    setup2fa_3_step_heading: "הזן את הקוד בן 6 הספרות",
    setup2fa_4_step_heading: "העתק את קודי השחזור שלך",
    setup2fa_4_instructions: `
            קודי שחזור אלו הם הדרך היחידה לגשת לחשבון שלך במידה של איבוד הטלפון או אי יכולת שימוש באפליקציית המאמת .
 הקפד לאחסן אותם במקום בטוח.
        `,
    setup2fa_5_step_heading: "אשר את הגדרת האימות הדו-שלבי",
    setup2fa_5_confirmation_1: "שמרתי את קודי השחזור שלי במיקום מאובטח",
    setup2fa_5_confirmation_2: "אני מוכן להפעיל אימות דו-שלבי",
    setup2fa_5_button: "הפעלת אימות דו-שלבי",

    // === 2FA Login ===
    login2fa_otp_title: "הזינו קוד אימות דו-שלבי",
    login2fa_otp_instructions: "הזינו את הקוד בן 6 הספרות מאפליקציית המאמת.",
    login2fa_recovery_title: "הזן קוד שחזור",
    login2fa_recovery_instructions:
      "הזן אחד מקודי השחזור שלך כדי לגשת לחשבון שלך.",
    login2fa_use_recovery_code: "שימוש בקוד שחזור",
    login2fa_recovery_back: "לאחור",
    login2fa_recovery_placeholder: "XXXXXXXX",

    "change": "שנה", // In English: "Change"
    "clock_visibility": "נראות שעון", // In English: "Clock Visibility"
    "reading": "קורא %strong%", // In English: "Reading %strong%"
    "writing": "כותב %strong%", // In English: "Writing %strong%"
    "unzipping": "מחלץ %strong%", // In English: "Unzipping %strong%"
    "sequencing": "רצף %strong%", // In English: "Sequencing %strong%"
    "zipping": "מכווץ %strong%", // In English: "Zipping %strong%"
    "Editor": "עורך", // In English: "Editor"
    "Viewer": "צופה", // In English: "Viewer"
    "People with access": "אנשים עם גישה", // In English: "People with access"
    "Share With…": "שתף עם…", // In English: "Share With…"
    "Owner": "בעלים", // In English: "Owner"
    "You can't share with yourself.": "אינך יכול לשתף עם עצמך.", // In English: "You can't share with yourself."
    "This user already has access to this item": "למשתמש זה כבר יש גישה לפריט זה", // In English: "This user already has access to this item"

    "billing.change_payment_method": "שינוי", // In English: "Change"
    "billing.cancel": "ביטול", // In English: "Cancel"
    "billing.download_invoice": "הורדה", // In English: "Download"
    "billing.payment_method": "שיטת תשלום", // In English: "Payment Method"
    "billing.payment_method_updated": "שיטת תשלום עודכנה!", // In English: "Payment method updated!"
    "billing.confirm_payment_method": "אישור שיטת תשלום", // In English: "Confirm Payment Method"
    "billing.payment_history": "היסטוריית תשלומים", // In English: "Payment History"
    "billing.refunded": "הוחזר", // In English: "Refunded"
    "billing.paid": "שולם", // In English: "Paid"
    "billing.ok": "אוקיי", // In English: "OK"
    "billing.resume_subscription": "חידוש מנוי", // In English: "Resume Subscription"
    "billing.subscription_cancelled": "המנוי שלכם בוטל", // In English: "Your subscription has been canceled."
    "billing.subscription_cancelled_description": "עדיין תהיה לכם גישה למנוי עד סוף תקופת החיוב.", // In English: "You will still have access to your subscription until the end of this billing period."
    "billing.offering.free": "חינם", // In English: "Free"
    "billing.offering.pro": "מקצועי", // In English: "Professional"
    "billing.offering.business": "עסקי", // In English: "Business"
    "billing.cloud_storage": "אחסון בענן", // In English: "Cloud Storage"
    "billing.ai_access": "גישה לAI", // In English: "AI Access"
    "billing.bandwidth": "רוחב פס", // In English: "Bandwidth"
    "billing.apps_and_games": "אפליקציות ומשחקים", // In English: "Apps & Games"
    "billing.upgrade_to_pro": "שדרוג ל %strong%", // In English: "Upgrade to %strong%"
    "billing.switch_to": "שינוי ל %strong%", // In English: "Switch to %strong%"
    "billing.payment_setup": "הגדרות תשלום", // In English: "Payment Setup"
    "billing.back": "חזרה", // In English: "Back"
    "billing.you_are_now_subscribed_to": "אתם עכשיו מנויים למסלול %strong%", // In English: "You are now subscribed to %strong% tier."
    "billing.you_are_now_subscribed_to_without_tier": "אתם עכשיו מנויים", // In English: "You are now subscribed"
    "billing.subscription_cancellation_confirmation": "אתם בטוחים שאתם מעוניינים לבטל את המנוי?", // In English: "Are you sure you want to cancel your subscription?"
    "billing.subscription_setup": "הגדרות מנוי", // In English: "Subscription Setup"
    "billing.cancel_it": "ביטול", // In English: "Cancel It"
    "billing.keep_it": "שמירה", // In English: "Keep It"
    "billing.subscription_resumed": "%strong% המנוי שוחזר!", // In English: "Your %strong% subscription has been resumed!"
    "billing.upgrade_now": "שדרגו עכשיו", // In English: "Upgrade Now"
    "billing.upgrade": "שדרוג", // In English: "Upgrade"
    "billing.currently_on_free_plan": "אתם כרגע בתכנית החינמית", // In English: "You are currently on the free plan."
    "billing.download_receipt": "הורדת קבלה", // In English: "Download Receipt"
    "billing.subscription_check_error": "קרתה תקלה בזמן בדיקת סטאטוס המנוי שלכם.", // In English: "A problem occurred while checking your subscription status."
    "billing.email_confirmation_needed": "האימייל שלכם לא אומת. נשלח עכשיו קוד אימות לאימייל", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
    "billing.sub_cancelled_but_valid_until": "ביטלתם את המנוי והוא אוטומתית יעבור למנוי חינמי בסוף תקופת החיוב. לא יתבצעו עוד חיובים אלא אם תשחזרו את המנוי", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
    "billing.current_plan_until_end_of_period": "המנוי שלכם עד סוף תקופת החיוב.", // In English: "Your current plan until the end of this billing period."
    "billing.current_plan": "תכנית עכשווית", // In English: "Current plan"
    "billing.cancelled_subscription_tier": "ביטול מנוי (%%)", // In English: "Cancelled Subscription (%%)"
    "billing.manage": "ניהול", // In English: "Manage"
    "billing.limited": "מוגבל", // In English: "Limited"
    "billing.expanded": "מורחב", // In English: "Expanded"
    "billing.accelerated": "מואץ", // In English: "Accelerated"
    "billing.enjoy_msg": "תהנו מ  %% של אחסון ענן בנוסף להטבות נוספות", // In English: "Enjoy %% of Cloud Storage plus other benefits."
  },
};

export default en;
