/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const fr = {
    name: "Français",
    english_name: "French",
    code: "fr",
    dictionary: {
        about: "À propos",
        account: "Compte",
        account_password: "Vérifier le mot de passe du compte",
        access_granted_to: "Accès accordé à",
        add_existing_account: "Ajouter un compte existant",
        all_fields_required: 'Tous les champs sont requis.',
        allow: 'Autoriser',
        apply: "Appliquer",
        ascending: 'Ascendant',
        associated_websites: "Sites associés",
        auto_arrange: 'Organisation automatique',
        background: "Arrière-plan",
        browse: "Parcourir",
        cancel: 'Annuler',
        center: 'Centrer',
        change_desktop_background: 'Changer l’arrière-plan du bureau…',
        change_email: "Changer l'e-mail",
        change_language: "Changer de langue",
        change_password: "Changer le mot de passe",
        change_ui_colors: "Changer les couleurs de l'interface",
        change_username: "Changer le nom d'utilisateur",
        close: 'Fermer',
        close_all_windows: "Fermer toutes les fenêtres",
        close_all_windows_confirm: "Êtes-vous sûr de vouloir fermer toutes les fenêtres ?",
        close_all_windows_and_log_out: 'Fermer les fenêtres et se déconnecter',
        change_always_open_with: "Voulez-vous toujours ouvrir ce type de fichier avec",
        color: 'Couleur',
        confirm_2fa_setup: "J'ai ajouté le code à mon application d'authentification",
        confirm_2fa_recovery: "J'ai enregistré mes codes de récupération dans un emplacement sécurisé",
        confirm_account_for_free_referral_storage_c2a: 'Créez un compte et confirmez votre adresse e-mail pour recevoir 1 Go de stockage gratuit. Votre ami bénéficiera également de 1 Go de stockage gratuit.',
        confirm_code_generic_incorrect: "Code incorrect.",
        confirm_code_generic_too_many_requests: "Trop de demandes. Veuillez patienter quelques minutes.",
        confirm_code_generic_submit: "Envoyer le code",
        confirm_code_generic_try_again: "Réessayer",
        confirm_code_generic_title: "Entrez le code de confirmation",
        confirm_code_2fa_instruction: "Saisissez le code à 6 chiffres de votre application d'authentification.",
        confirm_code_2fa_submit_btn: "Valider",
        confirm_code_2fa_title: "Entrez le code A2F",
        confirm_delete_multiple_items: 'Êtes-vous sûr de vouloir supprimer définitivement ces éléments ?',
        confirm_delete_single_item: 'Voulez-vous supprimer définitivement cet élément ?',
        confirm_open_apps_log_out: 'Vous avez des applications ouvertes. Êtes-vous sûr de vouloir vous déconnecter ?',
        confirm_new_password: "Confirmer le nouveau mot de passe",
        confirm_delete_user: "Êtes-vous sûr de vouloir supprimer votre compte ? Tous vos fichiers et données seront définitivement supprimés. Cette action est irréversible.",
        confirm_delete_user_title: "Supprimer le compte ?",
        confirm_session_revoke: "Êtes-vous sûr de vouloir révoquer cette session ?",
        confirm_your_email_address: "Confirmez votre adresse e-mail",
        contact_us: "Nous contacter",
        contact_us_verification_required: "Vous devez disposer d'une adresse e-mail vérifiée pour pouvoir utiliser ceci.",
        contain: 'Contenir',
        continue: "Continuer",
        copy: 'Copier',
        copy_link: "Copier le lien",
        copying: "Copie...",
        copying_file: "Copie de %%...",
        cover: 'Couverture',
        create_account: "Créer un compte",
        create_free_account: "Créer un compte gratuitement",
        create_shortcut: "Créer un raccourci",
        credits: "Crédits",
        current_password: "Mot de passe actuel",
        cut: 'Couper',
        clock: "Horloge",
        clock_visible_hide: 'Cacher - Toujours cachée',
        clock_visible_show: 'Afficher - Toujours visible',
        clock_visible_auto: 'Auto - Par défaut, visible uniquement en mode plein écran.',
        close_all: 'Fermer tout',
        created: 'Crée',
        date_modified: 'Date de modification',
        default: 'Par défaut',
        delete: 'Supprimer',
        delete_account: "Supprimer le compte",
        delete_permanently: "Supprimer définitivement",
        deleting_file: "Suppression de %%",
        deploy_as_app: "Déployer en tant qu'application",
        descending: 'Descendant',
        desktop: 'Bureau',
        desktop_background_fit: "Ajuster",
        developers: "Développeurs",
        dir_published_as_website: `%strong% a été publié sur :`,
        disable_2fa: "Désactiver l'A2F",
        disable_2fa_confirm: "Êtes-vous sûr de vouloir désactiver l'A2F ?",
        disable_2fa_instructions: "Entrez votre mot de passe pour désactiver l'A2F.",
        disassociate_dir: "Dissocier le répertoire",
        documents: 'Documents',
        dont_allow: 'Ne pas autoriser',
        download: 'Télécharger',
        download_file: 'Télécharger le fichier',
        downloading: "Téléchargement en cours",
        email: "E-mail",
        email_change_confirmation_sent: "Un e-mail de confirmation a été envoyé à votre nouvelle adresse e-mail. Veuillez vérifier votre boîte de réception et suivre les instructions pour terminer le processus.",
        email_invalid: 'L\'e-mail n\'est pas valide.',
        email_or_username: "E-mail ou nom d'utilisateur",
        email_required: 'Un e-mail est requis.',
        empty_trash: 'Vider la corbeille',
        empty_trash_confirmation: `Êtes-vous sûr de vouloir supprimer définitivement les éléments de la corbeille ?`,
        emptying_trash: 'Vidage de la corbeille...',
        enable_2fa: 'Activer l\'A2F',
        end_hard: "Forcer l'ârret",
        end_process_force_confirm: "Êtes-vous sûr de vouloir forcer l'arrêt de ce processus ?",
        end_soft: "Quitter",
        enlarged_qr_code: "Code QR agrandi",
        enter_password_to_confirm_delete_user: "Entrez votre mot passe pour confirmer la supression du compte",
        error_message_is_missing: "Message d'erreur manquant.",
        error_unknown_cause: "Une erreur inconnue s'est produite",
        error_uploading_files: "Échec de l'importation des fichiers",
        favorites: "Favoris",
        feedback: "Commentaires",
        feedback_c2a: "Veuillez utiliser le formulaire ci-dessous pour nous envoyer vos retours, commentaires et rapports de bugs.",
        feedback_sent_confirmation: "Merci de nous contacter. Si vous avez un e-mail associé à votre compte, vous recevrez une réponse de notre part dans les plus brefs délais.",
        fit: "Ajuster",
        folder: 'Dossier',
        force_quit: 'Forcer l\'arrêt',
        forgot_pass_c2a: "Mot de passe oublié ?",
        from: "Depuis",
        general: "Général",
        get_a_copy_of_on_puter: `Obtenez une copie de '%%' sur Puter.com !`,
        get_copy_link: 'Obtenir le lien de copie',
        hide_all_windows: "Masquer toutes les fenêtres",
        home: 'Accueil',
        html_document: 'Document HTML',
        hue: 'Teinte',
        image: 'Image',
        incorrect_password: "Mot de passe incorrect",
        invite_link: "Lien d'invitation",
        item: 'élément',
        items_in_trash_cannot_be_renamed: `Cet élément ne peut pas être renommé car il se trouve dans la corbeille. Pour renommer cet élément, faites-le d'abord glisser hors de la corbeille.`,
        jpeg_image: 'Image JPEG',
        keep_in_taskbar: 'Garder dans la barre des tâches',
        language: "Langue",
        license: "Licence",
        lightness: 'Luminosité',
        link_copied: "Lien copié",
        loading: 'Chargement',
        log_in: "Se connecter",
        log_into_another_account_anyway: 'Se connecter à un autre compte quand même',
        log_out: 'Se déconnecter',
        looks_good: "Ça a l'air bien !",
        manage_sessions: "Gérer les sessions",
        menubar_style: "Style barre de menu",
        menubar_style_desktop: "Bureau",
        menubar_style_system: "Système",
        menubar_style_window: "Fenêtre",
        modified: 'Modifié',
        move: 'Déplacer',
        moving_file: "Déplacement de %%",
        my_websites: "Mes sites internet",
        name: 'Nom',
        name_cannot_be_empty: 'Le nom ne peut pas être vide.',
        name_cannot_contain_double_period: "Le nom ne peut pas être le caractère '..'.",
        name_cannot_contain_period: "Le nom ne peut pas être le caractère '.'.",
        name_cannot_contain_slash: "Le nom ne peut pas contenir le caractère '/'.",
        name_must_be_string: "Le nom ne peut être qu'une chaîne.",
        name_too_long: `Le nom ne peut pas contenir plus de %% caractères.`,
        new: 'Nouveau',
        new_email: 'Nouvel e-mail',
        new_folder: 'Nouveau dossier',
        new_password: "Nouveau mot de passe",
        new_username: "Nouveau nom d'utilisateur",
        no: 'Non',
        no_dir_associated_with_site: 'Aucun répertoire associé à cette adresse.',
        no_websites_published: "Vous n'avez pas encore publié de sites internet.",
        ok: 'OK',
        open: "Ouvrir",
        open_in_new_tab: "Ouvrir dans un nouvel onglet",
        open_in_new_window: "Ouvrir dans une nouvelle fenêtre",
        open_with: "Ouvrir avec",
        original_name: "Nom d'origine",
        original_path: "Chemin d'origine",
        oss_code_and_content: "Logiciels et contenu open source",
        password: "Mot de passe",
        password_changed: "Mot de passe modifié.",
        password_recovery_rate_limit: "Vous avez atteint notre limite de débit ; veuillez patienter quelques minutes. Pour éviter cela à l'avenir, évitez de recharger la page trop de fois.",
        password_recovery_token_invalid: "Ce jeton de récupération de mot de passe n'est plus valide.",
        password_recovery_unknown_error: "Une erreur inconnue s'est produite. Veuillez réessayer plus tard.",
        password_required: 'Mot de passe requis.',
        password_strength_error: "Le mot de passe doit comporter au moins 8 caractères et contenir au moins une lettre majuscule, une lettre minuscule, un chiffre et un caractère spécial.",
        passwords_do_not_match: '`Nouveau mot de passe` et `Confirmer le nouveau mot de passe` ne correspondent pas.',
        paste: 'Coller',
        paste_into_folder: "Coller dans le dossier",
        path: 'Chemin',
        personalization: "Personnalisation",
        pick_name_for_website: "Choisissez un nom pour votre site internet :",
        picture: "Image",
        pictures: 'Images',
        plural_suffix: 's',
        powered_by_puter_js: `Propulsé par {{link=docs}}Puter.js{{/link}}`,
        preparing: "Préparation...",
        preparing_for_upload: "Préparation de l'importation...",
        print: 'Imprimer',
        privacy: "Confidentialité",
        proceed_to_login: 'Procéder à la connexion',
        proceed_with_account_deletion: "Procéder à la suppression du compte",
        process_status_initializing: "Initialisation",
        process_status_running: "En cours",
        process_type_app: 'Application',
        process_type_init: 'Init',
        process_type_ui: 'IU',
        properties: "Propriétés",
        publish: "Publier",
        publish_as_website: 'Publier en tant que site internet',
        puter_description: `Puter est un cloud personnel axé sur la confidentialité pour conserver tous vos fichiers, applications et jeux en un seul
        endroit sécurisé, accessible de partout et à tout moment.`,
        reading_file: "Lecture de %strong%",
        recent: "Récent",
        recommended: "Recommandé",
        recover_password: "Récupérer le mot de passe",
        refer_friends_c2a: "Obtenez 1 Go pour chaque ami qui crée et confirme un compte sur Puter. Votre ami recevra également 1 Go !",
        refer_friends_social_media_c2a: `Obtenez 1 Go de stockage gratuit sur Puter.com !`,
        refresh: 'Actualiser',
        release_address_confirmation: `Etes-vous sûr de vouloir libérer cette adresse ?`,
        remove_from_taskbar: 'Retirer de la barre des tâches',
        rename: 'Renommer',
        repeat: 'Répéter',
        replace: 'Remplacer',
        replace_all: 'Tout remplacer',
        resend_confirmation_code: "Renvoyer le code de confirmation",
        reset_colors: "Réinitialiser les couleurs",
        restart_puter_confirm: "Êtes-vous sûr de vouloir redémarrer Puter ?",
        restore: "Restaurer",
        save: 'Sauvegarder',
        saturation: 'Saturation',
        save_account: 'Enregistrer le compte',
        save_account_to_get_copy_link: "Veuillez créer un compte pour continuer.",
        save_account_to_publish: 'Veuillez créer un compte pour continuer.',
        save_session: 'Sauvegarder la session',
        save_session_c2a: 'Créez un compte pour enregistrer votre session actuelle et éviter de perdre votre travail.',
        scan_qr_c2a: 'Scannez le code ci-dessous\npour vous connecter à cette session depuis d\'autres appareils',
        scan_qr_2fa: 'Scannez le code QR avec votre application d\'authentification',
        scan_qr_generic: 'Scannez ce code QR à l\'aide de votre téléphone ou d\'un autre appareil',
        search: 'Rechercher',
        seconds: 'secondes',
        security: "Sécurité",
        select: "Sélectionner",
        selected: 'sélectionné',
        select_color: 'Sélectionnez la couleur…',
        sessions: "Sessions",
        send: "Envoyer",
        send_password_recovery_email: "Envoyer un e-mail de récupération de mot de passe",
        session_saved: "Merci d'avoir créé un compte. Cette session a été sauvegardée.",
        settings: "Paramètres",
        set_new_password: "Definir un nouveau mot de passe",
        share: "Partager",
        share_to: "Partager à",
        share_with: "Partager avec",
        shortcut_to: "Raccourci vers",
        show_all_windows: "Afficher toutes les fenêtres",
        show_hidden: 'Afficher les fichiers cachés',
        sign_in_with_puter: "Se connecter avec Puter",
        sign_up: "S'inscrire",
        signing_in: "Connexion…",
        size: 'Taille',
        skip: 'Passer',
        something_went_wrong: "Quelque chose s'est mal passé.",
        sort_by: 'Trier par',
        start: 'Démarrer',
        status: "Statut",
        storage_usage: "Utilisation du stockage",
        storage_puter_used: 'utilisé par Puter',
        taking_longer_than_usual: "Cela prend un peu plus de temps que d'habitude. Veuillez patienter...",
        task_manager: "Gestionnaire des tâches",
        taskmgr_header_name: "Nom",
        taskmgr_header_status: "Statut",
        taskmgr_header_type: "Type",
        terms: "Termes",
        text_document: 'Document texte',
        tos_fineprint: `En cliquant sur "Créer un compte gratuit", vous acceptez les {{link=terms}}Conditions d'utilisation{{/link}} et la {{link=privacy}}Politique de confidentialité{{/link}} de Puter.`,
        transparency: "Transparence",
        trash: 'Corbeille',
        two_factor: 'Authentification à deux facteurs',
        two_factor_disabled: 'A2F désactivée',
        two_factor_enabled: 'A2F activée',
        type: 'Type',
        type_confirm_to_delete_account: "Tapez 'confirm' pour supprimer votre compte.",
        ui_colors: "Couleurs d'interface",
        ui_manage_sessions: "Gestionnaire de sessions",
        ui_revoke: "Révoquer",
        undo: 'Annuler',
        unlimited: 'Illimité',
        unzip: "Décompresser",
        upload: 'Importer',
        upload_here: 'Importer ici',
        usage: 'Usage',
        username: "Nom d'utilisateur",
        username_changed: 'Nom d\'utilisateur mis à jour avec succès.',
        username_required: 'Le nom d\'utilisateur est requis.',
        versions: "Versions",
        videos: 'Vidéos',
        visibility: 'Visibilité',
        yes: 'Oui',
        yes_release_it: 'Oui, libérez-la',
        you_have_been_referred_to_puter_by_a_friend: "Vous avez été recommandé à Puter par un ami !",
        zip: "Compresser",
        zipping_file: "Compression de %strong%",

        // === 2FA Setup ===
        setup2fa_1_step_heading: 'Ouvrez votre application d\'authentification',
        setup2fa_1_instructions: `
            Vous pouvez utiliser n'importe quelle application d'authentification prenant en charge le protocole TOTP (Time-based One-Time Password).
            Il y a beaucoup de choix, mais si vous n'êtes pas sûr
            <a target="_blank" href="https://authy.com/download">Authy</a>
            est un choix solide pour Android et iOS.
        `,
        setup2fa_2_step_heading: 'Scannez le code QR',
        setup2fa_3_step_heading: 'Entrez le code à 6 chiffres',
        setup2fa_4_step_heading: 'Copiez vos codes de récupération',
        setup2fa_4_instructions: `
            Ces codes de récupération sont le seul moyen d'accéder à votre compte si vous perdez votre téléphone ou si vous ne pouvez pas utiliser votre application d'authentification.
            Assurez-vous de les conserver dans un endroit sûr.
        `,
        setup2fa_5_step_heading: 'Confirmer la configuration de l\'A2F',
        setup2fa_5_confirmation_1: "J'ai enregistré mes codes de récupération dans un emplacement sécurisé",
        setup2fa_5_confirmation_2: "Je suis prêt à activer l'A2F",
        setup2fa_5_button: "Activer l'A2F",

        // === 2FA Login ===
        login2fa_otp_title: 'Entrez le code A2F',
        login2fa_otp_instructions: "Saisissez le code à 6 chiffres de votre application d'authentification.",
        login2fa_recovery_title: 'Entrez un code de récupération',
        login2fa_recovery_instructions: "Entrez l'un de vos codes de récupération pour accéder à votre compte.",
        login2fa_use_recovery_code: 'Utiliser un code de récupération',
        login2fa_recovery_back: 'Retour',
        login2fa_recovery_placeholder: 'XXXXXXXX',

        "change": 'changer',
        "clock_visibility": "visibilité de l'horloge",
        "confirm": 'Confirmer',
        "public": 'Publique',
        "reading": 'lecture de %strong%',
        "writing": 'écriture de %strong%',
        "unzipping": 'décompression de %strong%',
        "sequencing": 'séquençage de %strong%',
        "zipping": 'compression de %strong%',
        "Editor": 'Éditeur',
        "Viewer": 'Lecteur',
        "People with access": 'Utilisateurs avec accès',
        "Share With…": 'Partager avec...',
        "Owner": 'Propriétaire',
        "You can't share with yourself.": 'Vous ne pouvez pas partager avec vous-même',
        "This user already has access to this item": 'Cet utilisateur à déja accès à cet élément',
        "billing.change_payment_method": "Modifier", 
        "billing.cancel": "Annuler", 
        "billing.download_invoice": "Télécharger", 
        "billing.payment_method": "Mode de paiement", 
        "billing.payment_method_updated": "Mode de paiement mis à jour !", 
        "billing.confirm_payment_method": "Confirmer le mode de paiement", 
        "billing.payment_history": "Historique des paiements", 
        "billing.refunded": "Remboursé", 
        "billing.paid": "Payé", 
        "billing.ok": "OK", 
        "billing.resume_subscription": "Reprendre l'abonnement", 
        "billing.subscription_cancelled": "Votre abonnement a été annulé.", 
        "billing.subscription_cancelled_description": "Vous aurez toujours accès à votre abonnement jusqu'à la fin de cette période de facturation.", 
        "billing.offering.free": "Gratuit", 
        "billing.offering.pro": "Professionnel",
        "billing.offering.business": "Entreprise", 
        "billing.cloud_storage": "Stockage Cloud", 
        "billing.ai_access": "Accès IA", 
        "billing.bandwidth": "Bande passante", 
        "billing.apps_and_games": "Applications & Jeux", 
        "billing.upgrade_to_pro": "Mettre à niveau vers %strong%", 
        "billing.switch_to": "Passer à %strong%", 
        "billing.payment_setup": "Configuration du paiement",
        "billing.back": "Retour",
        "billing.you_are_now_subscribed_to": "Vous êtes maintenant abonné au niveau %strong%.", 
        "billing.you_are_now_subscribed_to_without_tier": "Vous êtes maintenant abonné", 
        "billing.subscription_cancellation_confirmation": "Êtes-vous sûr de vouloir annuler votre abonnement ?", 
        "billing.subscription_setup": "Configuration de l'abonnement", 
        "billing.cancel_it": "L'annuler", 
        "billing.keep_it": "Le garder",
        "billing.subscription_resumed": "Votre abonnement %strong% a été repris !", 
        "billing.upgrade_now": "Mettre à niveau maintenant", 
        "billing.upgrade": "Mettre à niveau", 
        "billing.currently_on_free_plan": "Vous êtes actuellement sur le plan gratuit.",
        "billing.download_receipt": "Télécharger le reçu", 
        "billing.subscription_check_error": "Un problème est survenu lors de la vérification de l'état de votre abonnement.", 
        "billing.email_confirmation_needed": "Votre e-mail n'a pas été confirmé. Nous allons vous envoyer un code pour le confirmer maintenant.", 
        "billing.sub_cancelled_but_valid_until": "Vous avez annulé votre abonnement, et il passera automatiquement au niveau gratuit à la fin de la période de facturation. Vous ne serez pas facturé à nouveau, sauf si vous vous réabonnez.", 
        "billing.current_plan_until_end_of_period": "Votre plan actuel jusqu'à la fin de cette période de facturation.", 
        "billing.current_plan": "Plan actuel", 
        "billing.cancelled_subscription_tier": "Abonnement annulé (%%)",
        "billing.manage": "Gérer", 
        "billing.limited": "Limité", 
        "billing.expanded": "Étendu", 
        "billing.accelerated": "Accéléré", 
        "billing.enjoy_msg": "Profitez de %% de stockage Cloud ainsi que d'autres avantages.", 
        "billing.change_payment_method": "Modifier le mode de paiement", // In English: "Change"
        "billing.cancel": "Annuler", // In English: "Cancel"
        "billing.download_invoice": "Télécharger la facture", // In English: "Download"
        "billing.payment_method": "Mode de paiement", // In English: "Payment Method"
        "billing.payment_method_updated": "Mode de paiement mis à jour !", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "Confirmer le mode de paiement", // In English: "Confirm Payment Method"
        "billing.payment_history": "Historique des paiements", // In English: "Payment History"
        "billing.refunded": "Remboursé", // In English: "Refunded"
        "billing.paid": "Payé", // In English: "Paid"
        "billing.ok": "OK", // In English: "OK"
        "billing.resume_subscription": "Reprendre l'abonnement", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "Votre abonnement a été annulé.", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "Vous aurez toujours accès à votre abonnement jusqu'à la fin de cette période de facturation.", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "Gratuit", // In English: "Free"
        "billing.offering.pro": "Professionnel", // In English: "Professional"
        "billing.offering.business": "Entreprise", // In English: "Business"
        "billing.cloud_storage": "Stockage Cloud", // In English: "Cloud Storage"
        "billing.ai_access": "Accès à l'IA", // In English: "AI Access"
        "billing.bandwidth": "Bande passante", // In English: "Bandwidth"
        "billing.apps_and_games": "Applications et jeux", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "Passer à %strong%", // In English: "Upgrade to %strong%"
        "billing.switch_to": "Passer à %strong%", // In English: "Switch to %strong%"
        "billing.payment_setup": "Configuration du paiement", // In English: "Payment Setup"
        "billing.back": "Retour", // In English: "Back"
        "billing.you_are_now_subscribed_to": "Vous êtes maintenant abonné au niveau %strong%.", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "Vous êtes maintenant abonné", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "Êtes-vous sûr de vouloir annuler votre abonnement ?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "Configuration de l'abonnement", // In English: "Subscription Setup"
        "billing.cancel_it": "L'annuler", // In English: "Cancel It"
        "billing.keep_it": "Le conserver", // In English: "Keep It"
        "billing.subscription_resumed": "Votre abonnement %strong% a été repris !", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "Mettre à niveau maintenant", // In English: "Upgrade Now"
        "billing.upgrade": "Mettre à niveau", // In English: "Upgrade"
        "billing.currently_on_free_plan": "Vous êtes actuellement sur le plan gratuit.", // In English: "You are currently on the free plan."
        "billing.download_receipt": "Télécharger le reçu", // In English: "Download Receipt"
        "billing.subscription_check_error": "Un problème est survenu lors de la vérification de votre statut d'abonnement.", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "Votre e-mail n'a pas été confirmé. Nous allons vous envoyer un code pour le confirmer maintenant.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "Vous avez annulé votre abonnement et il passera automatiquement au niveau gratuit à la fin de la période de facturation. Vous ne serez pas facturé à nouveau sauf si vous vous réabonnez.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "Votre plan actuel jusqu'à la fin de cette période de facturation.", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "Plan actuel", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "Abonnement annulé (%%)", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "Gérer", // In English: "Manage"
        "billing.limited": "Limité", // In English: "Limited"
        "billing.expanded": "Étendu", // In English: "Expanded"
        "billing.accelerated": "Accéléré", // In English: "Accelerated"
        "billing.enjoy_msg": "Profitez de %% de stockage cloud et d'autres avantages.", // In English: "Enjoy %% of Cloud Storage plus other benefits."
    }
};

export default fr;
