/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const fa = {
  name: "فارسی",
  english_name: "Farsi",
  code: "fa",
  dictionary: {
    about: "درباره",
    account: "حساب کاربری",
    access_granted_to: "دسترسی داده شده به",
    add_existing_account: "افزودن حساب کاربری موجود",
    all_fields_required: "تمامی فیلدها الزامی هستند.",
    apply: "اعمال",
    ascending: "صعودی",
    auto_arrange: "ترتیب خودکار",
    background: "پس زمینه",
    browse: "مرور",
    cancel: "لغو",
    center: "مرکز",
    change_desktop_background: "تغییر پس زمینه دسکتاپ…",
    change_language: "تغییر زبان",
    change_password: "تغییر رمز عبور",
    change_username: "تغییر نام کاربری",
    clock: "ساعت",
    close_all_windows: "بستن همه پنجره ها",
    color: "رنگ",
    confirm_account_for_free_referral_storage_c2a:
      "حساب کاربری خود را ایجاد کرده و آدرس ایمیل خود را تأیید کنید تا 1 گیگابایت فضای ذخیره سازی رایگان دریافت کنید. دوست شما هم 1 گیگابایت فضای ذخیره سازی رایگان دریافت خواهد کرد.",
    confirm_new_password: "تأیید رمز عبور جدید",
    contact_us: "تماس با ما",
    contain: "شامل",
    continue: "ادامه",
    copy: "کپی",
    copy_link: "کپی لینک",
    copying: "کپی",
    cover: "جلد",
    create_account: "ایجاد حساب کاربری",
    create_free_account: "ایجاد حساب کاربری رایگان",
    create_shortcut: "ایجاد میانبر",
    current_password: "رمز عبور فعلی",
    cut: "برش",
    date_modified: "تاریخ تغییر",
    delete: "حذف",
    delete_permanently: "حذف دائمی",
    deploy_as_app: "نصب به عنوان برنامه",
    descending: "نزولی",
    desktop_background_fit: "متناسب",
    dir_published_as_website: `%strong% منتشر شده به:`,
    disassociate_dir: "قطع ارتباط دایرکتوری",
    download: "دانلود",
    downloading: "دانلود",
    email: "ایمیل",
    email_or_username: "ایمیل یا نام کاربری",
    empty_trash: "خالی کردن سطل زباله",
    empty_trash_confirmation: `آیا از حذف دائمی موارد در سطل زباله مطمئن هستید؟`,
    emptying_trash: "خالی کردن سطل زباله…",
    feedback: "بازخورد",
    feedback_c2a:
      "لطفا از فرم زیر برای ارسال بازخورد، نظرات و گزارش خطا استفاده کنید.",
    feedback_sent_confirmation:
      "با تشکر از تماس شما. اگر ایمیلی به حساب کاربری شما متصل است، در اسرع وقت پاسخ خواهیم داد.",
    forgot_pass_c2a: "رمز عبور را فراموش کرده اید؟",
    from: "از",
    general: "عمومی",
    get_a_copy_of_on_puter: `یک نسخه از '%%' را در Puter.com بگیرید!`,
    get_copy_link: "گرفتن لینک کپی",
    hide_all_windows: "پنهان کردن همه پنجره ها",
    html_document: "سند HTML",
    image: "تصویر",
    invite_link: "لینک دعوت",
    items_in_trash_cannot_be_renamed: `این مورد نمی تواند تغییر نام دهد زیرا در سطل زباله است. برای تغییر نام این مورد، ابتدا آن را از سطل زباله بیرون بکشید.`,
    jpeg_image: "تصویر JPEG",
    keep_in_taskbar: "در نوار وظایف نگه دارید",
    language: "زبان",
    log_in: "ورود",
    log_out: "خروج",
    move: "انتقال",
    moving_file: "انتقال %%",
    my_websites: "وبسایت های من",
    name: "نام",
    name_cannot_be_empty: "نام نمی تواند خالی باشد.",
    name_cannot_contain_double_period: "نام نمی تواند شامل '..' باشد.",
    name_cannot_contain_period: "نام نمی تواند شامل '.' باشد.",
    name_cannot_contain_slash: "نام نمی تواند شامل '/' باشد.",
    name_must_be_string: "نام فقط می تواند یک رشته باشد.",
    name_too_long: `نام نمی تواند بیشتر از %% کاراکتر باشد.`,
    new: "جدید",
    new_folder: "پوشه جدید",
    new_password: "رمز عبور جدید",
    new_username: "نام کاربری جدید",
    no_dir_associated_with_site: "هیچ دایرکتوری مرتبط با این آدرس وجود ندارد.",
    no_websites_published: "هنوز هیچ وبسایتی منتشر نکرده اید.",
    ok: "خوب",
    open: "باز کردن",
    open_in_new_tab: "در تب جدید باز کن",
    open_in_new_window: "در پنجره جدید باز کن",
    open_with: "باز کردن با",
    password: "رمز عبور",
    password_changed: "رمز عبور تغییر یافت.",
    passwords_do_not_match:
      "`رمز عبور جدید` و `تأیید رمز عبور جدید` مطابقت ندارند.",
    paste: "چسباندن",
    paste_into_folder: "چسباندن در پوشه",
    personalization: "شخصی سازی",
    pick_name_for_website: "یک نام برای وبسایت خود انتخاب کنید:",
    picture: "تصویر",
    powered_by_puter_js: `پشتیبانی شده توسط {{link=docs}}Puter.js{{/link}}`,
    preparing: "در حال آماده سازی...",
    preparing_for_upload: "آماده سازی برای بارگذاری...",
    properties: "ویژگی ها",
    publish: "انتشار",
    publish_as_website: "انتشار به عنوان وبسایت",
    recent: "اخیر",
    recover_password: "بازیابی رمز عبور",
    refer_friends_c2a:
      "برای هر دوستی که حساب کاربری Puter ایجاد و تأیید کند، 1 گیگابایت دریافت کنید. دوست شما هم 1 گیگابایت دریافت خواهد کرد!",
    refer_friends_social_media_c2a: `1 گیگابایت فضای ذخیره سازی رایگان را در Puter.com بگیرید!`,
    refresh: "تازه کردن",
    release_address_confirmation: `آیا مطمئن هستید که می خواهید این آدرس را آزاد کنید؟`,
    remove_from_taskbar: "از نوار وظایف حذف کن",
    rename: "تغییر نام",
    repeat: "تکرار",
    resend_confirmation_code: "ارسال مجدد کد تأیید",
    restore: "بازیابی",
    save_account_to_get_copy_link: "لطفا برای ادامه یک حساب کاربری ایجاد کنید.",
    save_account_to_publish: "لطفا برای ادامه یک حساب کاربری ایجاد کنید.",
    save_session_c2a:
      "برای ذخیره جلسه فعلی و جلوگیری از از دست دادن کار خود یک حساب کاربری ایجاد کنید.",
    scan_qr_c2a:
      "کد زیر را از دستگاه های دیگر اسکن کنید تا به این جلسه وارد شوید",
    security: "امنیت",
    select: "انتخاب",
    select_color: "انتخاب رنگ…",
    send: "ارسال",
    send_password_recovery_email: "ارسال ایمیل بازیابی رمز عبور",
    session_saved: "با تشکر از ایجاد حساب کاربری. این جلسه ذخیره شده است.",
    set_new_password: "تنظیم رمز عبور جدید",
    settings: "تنظیمات",
    share_to: "اشتراک گذاری به",
    show_all_windows: "نمایش همه پنجره ها",
    show_hidden: "نمایش مخفی",
    sign_in_with_puter: "ورود با Puter",
    sign_up: "ثبت نام",
    signing_in: "ورود…",
    size: "اندازه",
    sort_by: "مرتب سازی بر اساس",
    start: "شروع",
    storage_puter_used: "استفاده شده توسط Puter",
    taking_longer_than_usual: "کمی بیشتر از معمول طول می کشد. لطفا صبر کنید...",
    task_manager: "مدیر وظایف",
    text_document: "سند متنی",
    tos_fineprint: `با کلیک بر روی 'ایجاد حساب کاربری رایگان' شما با {{link=terms}}شرایط خدمات{{/link}} و {{link=privacy}}سیاست حفظ حریم خصوصی{{/link}} Puter موافقت می کنید.`,
    trash: "سطل زباله",
    type: "نوع",
    undo: "بازگشت",
    unzip: "باز کردن فایل فشرده",
    usage: "استفاده",
    upload: "بارگذاری",
    upload_here: "اینجا بارگذاری کنید",
    username: "نام کاربری",
    username_changed: "نام کاربری با موفقیت به روز شد.",
    versions: "نسخه ها",
    yes_release_it: "بله، آن را آزاد کن",
    you_have_been_referred_to_puter_by_a_friend:
      "شما توسط یک دوست به Puter معرفی شده اید!",
    zip: "فشرده سازی",

    account_password: "تایید رمزعبور", // In English: "Verify Account Password"
    allow: "اجازه دسترسی", // In English: "Allow"
    associated_websites: "وب سایت های مرتبط", // In English: "Associated Websites"
    change: "تغییر", // In English: "Change"
    change_always_open_with:
      "آیا می‌خواهید همیشه این نوع فایل را با ... باز کنید؟", // In English: "Do you want to always open this type of file with" ///////////... can be replaced with the name of the software/program
    change_email: "تغییر ایمیل", // In English: "Change Email"
    change_ui_colors: "تغییر رنگ‌های رابط کاربری", // In English: "Change UI Colors"
    clock_visibility: "قابلیت دیدن ساعت", // In English: "Clock Visibility"
    close: "بستن", // In English: "Close"
    close_all_windows_confirm:
      "آیا مطمئن هستید که می‌خواهید همه پنجره‌ها را ببندید؟", // In English: "Are you sure you want to close all windows?"
    close_all_windows_and_log_out: "بستن پنجره‌ها و خروج", // In English: "Close Windows and Log Out"
    confirm: "تایید", // In English: "Confirm"
    confirm_2fa_setup: "کد را به برنامه تأیید هویت خود اضافه کرده‌ام", // In English: "I have added the code to my authenticator app"
    confirm_2fa_recovery: "کدهای بازیابی خود را در یک مکان امن ذخیره کرده‌ام", // In English: "I have saved my recovery codes in a secure location"
    confirm_code_generic_incorrect: "کد نادرست است", // In English: "Incorrect Code."
    confirm_code_generic_too_many_requests:
      "تعداددرخواست‌ها زیاداست. لطفاً چند دقیقه صبر کنید", // In English: "Too many requests. Please wait a few minutes."
    confirm_code_generic_submit: "ثبت کد", // In English: "Submit Code"
    confirm_code_generic_try_again: "دوباره امتحان کنید", // In English: "Try Again"
    confirm_code_generic_title: "کد تایید را وارد کنید", // In English: "Enter Confirmation Code"
    confirm_code_2fa_instruction:
      "کد ۶ رقمی را از برنامه تأیید هویت خود وارد کنید", // In English: "Enter the 6-digit code from your authenticator app."
    confirm_code_2fa_submit_btn: "ثبت", // In English: "Submit"
    confirm_code_2fa_title: "کد احراز هویت دو مرحله ای را وارد کنید", // In English: "Enter 2FA Code"
    confirm_delete_multiple_items:
      "آیا مطمئن هستید که می‌خواهید این موارد را برای همیشه حذف کنید؟", // In English: "Are you sure you want to permanently delete these items?"
    confirm_delete_single_item:
      "آیا می‌خواهید این مورد را برای همیشه حذف کنید؟", // In English: "Do you want to permanently delete this item?"
    confirm_open_apps_log_out:
      "یک یا چند برنامه شما هنوز باز است. آیا مطمئن هستید که می‌خواهید خارج شوید؟", // In English: "You have open apps. Are you sure you want to log out?"////////////Translation is not word by word
    confirm_delete_user:
      "آیا مطمئن هستید که می‌خواهید حساب خود را حذف کنید؟ همه فایل‌ها و داده‌های شما برای همیشه حذف خواهند شد این عمل قابل برگرداندن نیست.", // In English: "Are you sure you want to delete your account? All your files and data will be permanently deleted. This action cannot be undone."
    confirm_delete_user_title: "حذف حساب کاربری؟", // In English: "Delete Account?"
    confirm_session_revoke:
      "آیا مطمئن هستید که می خواهید این نشست را لغو کنید؟", // In English: "Are you sure you want to revoke this session?"/////////////////////TN: It's better to use session instead ofنشست
    confirm_your_email_address: "ایمیل خود را تأیید کنید", // In English: "Confirm Your Email Address"
    contact_us_verification_required:
      "شما باید یک آدرس ایمیل تأیید شده داشته باشید تا بتوانید از این استفاده کنید ", // In English: "You must have a verified email address to use this."
    copying_file: "درحال کپی کردن %%", // In English: "Copying %%"
    credits: "اعتبار", // In English: "Credits"
    clock_visible_hide: "مخفی-همیشه مخفی", // In English: "Hide - Always hidden"
    clock_visible_show: "نمایش-همیشه قابل مشاهده", // In English: "Show - Always visible"
    clock_visible_auto:
      "خودکار - به صورت پیش‌فرض، قابل مشاهده فقط در حالت تمام-صفحه", // In English: "Auto - Default, visible only in full-screen mode."
    close_all: "بستن همه", // In English: "Close All"
    created: "ایجاد شده", // In English: "Created"
    default: "پیش فرض", // In English: "Default"
    delete_account: "حذف حساب کاربری", // In English: "Delete Account"
    deleting_file: "در حال حذف %%", // In English: "Deleting %%"
    desktop: "دسکتاپ", // In English: "Desktop"
    developers: "تولیدکنندگان نرم افزار", // In English: "Developers"
    disable_2fa: "غیر فعال کردن احراز هویت دو مرحله ای", // In English: "Disable 2FA"
    disable_2fa_confirm:
      "آیا مطمئن هستید که می‌خواهید احراز هویت دو مرحله ای را غیرفعال کنید؟", // In English: "Are you sure you want to disable 2FA?"
    disable_2fa_instructions:
      "برای غیرفعال کردن احراز هویت دو مرحله ای ،رمز عبور خود را وارد کنید", // In English: "Enter your password to disable 2FA."
    documents: "اسناد", // In English: "Documents"
    dont_allow: "عدم اجازه", // In English: "Don't Allow"
    download_file: "دانلود فایل", // In English: "Download File"
    email_change_confirmation_sent:
      "یک ایمیل تاییدیه به آدرس ایمیل جدید شما ارسال شده است. لطفاً صندوق ایمیلهای دریافتی خود را بررسی کرده و دستورالعمل‌ها را برای تکمیل فرایند دنبال کنید.", // In English: "A confirmation email has been sent to your new email address. Please check your inbox and follow the instructions to complete the process."
    email_invalid: "ایمیل نا معتبر است", // In English: "Email is invalid."
    email_required: "وارد کردن ایمیل الزامی است", // In English: "Email is required."
    enable_2fa: "فعال کردن احراز هویت دو مرحله ای", // In English: "Enable 2FA"
    end_hard: "پایان دادن سخت", // In English: "End Hard"
    end_process_force_confirm:
      "آیا مطمئن هستید که می‌خواهید این فرآیند را به اجبار متوقف کنید؟", // In English: "Are you sure you want to force-quit this process?"
    end_soft: "پایان دادن نرم", // In English: "End Soft"
    enlarged_qr_code: "بارکد بزرگ شده", // In English: "Enlarged QR Code"
    enter_password_to_confirm_delete_user:
      "رمز عبور خود را برای تایید حذف حساب وارد کنید", // In English: "Enter your password to confirm account deletion"
    error_message_is_missing: "پیام خطا وجود ندارد", // In English: "Error message is missing."
    error_unknown_cause: "یک خطای ناشناخته رخ داده است", // In English: "An unknown error occurred."
    error_uploading_files: "بارگذاری فایل‌ها ناموفق بود", // In English: "Failed to upload files"
    favorites: "موارد دلخواه", // In English: "Favorites"
    fit: "اندازه‌گذاری", // In English: "Fit"
    folder: "پوشه", // In English: "Folder"
    force_quit: "خروج اجباری", // In English: "Force Quit"
    home: "خانه", // In English: "Home"
    hue: "رنگ", // In English: "Hue"
    incorrect_password: "رمز عبور نادرست است", // In English: "Incorrect password"
    item: "مورد", // In English: "item"
    license: "مجوز", // In English: "License"
    lightness: "روشنایی", // In English: "Lightness"
    link_copied: "لینک کپی شد", // In English: "Link copied"
    loading: "در حال بارگذاری", // In English: "Loading"
    log_into_another_account_anyway: "به هر حال وارد حساب دیگری شوید", // In English: "Log into another account anyway"
    looks_good: "خوب به نظر می‌رسد!", // In English: "Looks good!"
    manage_sessions: "مدیریت نشست‌ها", // In English: "Manage Sessions"//////////better to use sessions instead of نشستها
    menubar_style: "سبک نوار منو", // In English: "Menubar Style"
    menubar_style_desktop: "دسکتاپ", // In English: "Desktop"
    menubar_style_system: "سیستم", // In English: "System"
    menubar_style_window: "پنجره", // In English: "Window"
    modified: "تغییر داده شده", // In English: "Modified"
    new_email: "ایمیل جدید", // In English: "New Email"
    no: "خیر", // In English: "No"
    original_name: "نام اصلی", // In English: "Original Name"
    original_path: "مسیر اصلی", // In English: "Original Path"
    oss_code_and_content: "نرم‌افزار و محتوای متن‌باز", // In English: "Open Source Software and Content"
    password_recovery_rate_limit:
      "شما به محدودیت درخواست‌های ما رسیده‌اید؛ لطفاً چند دقیقه صبر کنید. برای جلوگیری از این مشکل در آینده، از بارگذاری مکرر صفحه خودداری کنید", // In English: "You've reached our rate-limit; please wait a few minutes. To prevent this in the future, avoid reloading the page too many times."
    password_recovery_token_invalid:
      "این توکن بازیابی رمز عبور دیگر معتبر نیست", // In English: "This password recovery token is no longer valid."
    password_recovery_unknown_error:
      "یک خطای ناشناخته رخ داده است. لطفاً بعداً دوباره تلاش کنید", // In English: "An unknown error occurred. Please try again later."
    password_required: "وارد کردن رمز عبور الزامی است.", // In English: "Password is required."
    password_strength_error:
      "رمز عبور باید حداقل ۸ کاراکتر داشته باشد و شامل حداقل یک حرف بزرگ، یک حرف کوچک، یک عدد و یک کاراکتر ویژه باشد", // In English: "Password must be at least 8 characters long and contain at least one uppercase letter, one lowercase letter, one number, and one special character."
    path: "مسیر", // In English: "Path"
    pictures: "تصاویر", // In English: "Pictures"
    plural_suffix: "ها", // In English: "s"
    print: "چاپ", // In English: "Print"
    privacy: "حریم خصوصی", // In English: "Privacy"
    proceed_to_login: "ادامه به ورود", // In English: "Proceed to login" //////
    proceed_with_account_deletion: "ادامه به حذف حساب کاربری", // In English: "Proceed with Account Deletion"
    process_status_initializing: "در حال راه‌اندازی", // In English: "Initializing"
    process_status_running: "در حال اجرا", // In English: "Running"
    process_type_app: "برنامه", // In English: "App"
    process_type_init: "راه اندازی", // In English: "Init"
    process_type_ui: "رابط کاربری", // In English: "UI"
    public: "عمومی", // In English: "Public"
    puter_description:
      "پیوتر یک کلاود با اولویت حفظ حریم خصوصی است که همه فایل‌ها، برنامه‌ها و بازی‌های شما را در یک فضای امن نگه می‌دارد که از هر جا و هر زمان قابل دسترسی است", // In English: "Puter is a privacy-first personal cloud to keep all your files, apps, and games in one secure place, accessible from anywhere at any time."
    reading: "%strong%درحال خواندن", // In English: "Reading %strong%"
    writing: "%strong%درحال نوشتن", // In English: "Writing %strong%"
    recommended: "پیشنهاد", // In English: "Recommended"
    replace: "جایگزین کردن", // In English: "Replace"
    replace_all: "جایگزینی همه", // In English: "Replace All"
    reset_colors: "بازنشانی رنگ ها", // In English: "Reset Colors"
    restart_puter_confirm:
      "آیا مطمئن هستید که می‌خواهید پیوتر را مجددا راه اندازی کنید", // In English: "Are you sure you want to restart Puter?"
    save: "ذخیره", // In English: "Save"
    saturation: "اشباع رنگ", // In English: "Saturation"
    save_account: "ذخیره حساب", // In English: "Save account"
    save_session: "ذخیره نشست", // In English: "Save session"//////،TN:better to use session instead of نشست
    scan_qr_2fa: " بارکد را با برنامه تایید هویت خود اسکن کنید", // In English: "Scan the QR code with your authenticator app"
    scan_qr_generic: " این بارکد را با گوشی همراه خود یا وسیله دیگری اسکن کنید", // In English: "Scan this QR code using your phone or another device"
    search: "جستجو", // In English: "Search"
    seconds: "ثانیه", // In English: "seconds"
    selected: "انتخاب شده", // In English: "selected"
    sessions: "نشست ها", // In English: "Sessions"//////TN: better to use sesions
    share: "به اشتراک گذاری", // In English: "Share"
    share_with: "اشتراک با", // In English: "Share with:"
    shortcut_to: "میانبر به", // In English: "Shortcut to"
    skip: "رد کردن", // In English: "Skip"
    something_went_wrong: "مشکلی پیش آمد", // In English: "Something went wrong."
    status: "وضعیت", // In English: "Status"
    storage_usage: "میزان استفاده شده از فضای ذخیره سازی", // In English: "Storage Usage"
    taskmgr_header_name: "نام", // In English: "Name"
    taskmgr_header_status: "وضعیت", // In English: "Status"
    taskmgr_header_type: "نوع", // In English: "Type"
    terms: "شرایط", // In English: "Terms"
    transparency: "شفافیت", // In English: "Transparency"
    two_factor: "احراز هویت دو مرحله ای", // In English: "Two Factor Authentication"
    two_factor_disabled: "احراز هویت دو مرحله ای غیر فعال شد", // In English: "2FA Disabled"
    two_factor_enabled: "احراز هویت دو مرحله ای فعال شد", // In English: "2FA Enabled"
    type_confirm_to_delete_account:
      "عبارت 'تأیید' را برای حذف حساب خود وارد کنید", // In English: "Type 'confirm' to delete your account."
    ui_colors: "رنگ‌های رابط کاربری", // In English: "UI Colors"
    ui_manage_sessions: "مدیریت نشستها", // In English: "Session Manager"////////TN: better to use sessions instead of نشستها
    ui_revoke: "لغو", // In English: "Revoke"
    unlimited: "نامحدود", // In English: "Unlimited"
    unzipping: " %strong%در حال استخراج ", // In English: "Unzipping %strong%"
    username_required: "وارد کردن نام کاربری الزامی است", // In English: "Username is required."
    videos: "ویدیو ها", // In English: "Videos"
    visibility: "قابلیت دیده شدن", // In English: "Visibility"
    yes: "بله", // In English: "Yes"
    sequencing: "%strong%ترتیب بندی", // In English: "Sequencing %strong%"
    zipping: "%strong%درحال فشرده سازی", // In English: "Zipping %strong%"
    setup2fa_1_step_heading: "برنامه تأیید هویت خود را باز کنید", // In English: "Open your authenticator app"
    setup2fa_1_instructions:
      "شما می‌توانید از هر برنامه تأیید هویتی که از پروتکل رمز یکبار مصرف مبتنی بر زمان (TOTP) پشتیبانی می‌کند استفاده کنید. اگر مطمئن نیستید، <a target='_blank' href='https://authy.com/download'>Authy</a> یک انتخاب مناسب برای اندروید و iOS است.", // In English: "
    // You can use any authenticator app that supports the Time-based One-Time Password (TOTP) protocol.
    // There are many to choose from, but if you're unsure
    // <a target="_blank" href="https://authy.com/download">Authy</a>
    // is a solid choice for Android and iOS.
    //"
    setup2fa_2_step_heading: " بارکد را اسکن کنید ", // In English: "Scan the QR code"
    setup2fa_3_step_heading: "کد ۶ رقمی را وارد کنید", // In English: "Enter the 6-digit code"
    setup2fa_4_step_heading: "کدهای بازیابی خود را کپی کنید", // In English: "Copy your recovery codes"
    setup2fa_4_instructions:
      "این کدهای بازیابی تنها راه دسترسی به حساب شما هستند در صورتی که تلفن خود را گم کنید یا نتوانید از برنامه تأیید هویت استفاده کنید. مطمئن شوید که آنها را در مکانی امن ذخیره کرده‌اید.", // In English: "
    //     These recovery codes are the only way to access your account if you lose your phone or can't use your authenticator app.
    //     Make sure to store them in a safe place.
    // "
    setup2fa_5_step_heading: "تنظیمات احراز هویت دو مرحله ای را تایید کنید", // In English: "Confirm 2FA setup"
    setup2fa_5_confirmation_1:
      "من کدهای بازیابی خود را در مکانی امن ذخیره کرده‌ام", // In English: "I have saved my recovery codes in a secure location"
    setup2fa_5_confirmation_2: "آماده فعال کردن احراز هویت دو مرحله ای هستم", // In English: "I am ready to enable 2FA"
    setup2fa_5_button: "فعال‌سازی احراز هویت دو مرحله‌ای", // In English: "Enable 2FA"
    login2fa_otp_title: "کد احراز هویت دو مرحله‌ای را وارد کنید", // In English: "Enter 2FA Code"
    login2fa_otp_instructions:
      "کد ۶ رقمی را از اپلیکیشن احراز هویت خود وارد کنید", // In English: "Enter the 6-digit code from your authenticator app."
    login2fa_recovery_title: "یک کد بازیابی وارد کنید", // In English: "Enter a recovery code"
    login2fa_recovery_instructions:
      "یکی از کدهای بازیابی خود را برای دسترسی به حساب خود وارد کنید", // In English: "Enter one of your recovery codes to access your account."
    login2fa_use_recovery_code: "از کد بازیابی استفاده کنید", // In English: "Use a recovery code"
    login2fa_recovery_back: "بازگشت", // In English: "Back"
    login2fa_recovery_placeholder: "XXXXXXX", // In English: "XXXXXXXX"
    Editor: "ویرایشگر", // In English: "Editor"
    Viewer: "مشاهده گر", // In English: "Viewer"
    "People with access": "افرادی که دسترسی دارند", // In English: "People with access"
    "Share With…": "اشتراک گذاری با...", // In English: "Share With…"
    Owner: "مالک", // In English: "Owner"
    "You can't share with yourself.":
      "شما نمی‌توانید  با خودتان به اشتراک بگذارید", // In English: "You can't share with yourself."
    "This user already has access to this item":
      "این کاربر از قبل به این مورد دسترسی دارد", // In English: "This user already has access to this item"

    "billing.change_payment_method": "تغییر روش پرداخت", // In English: "Change"
    "billing.cancel": "لغو", // In English: "Cancel"
    "billing.download_invoice": "دانلود فاکتور", // In English: "Download"
    "billing.payment_method": "روش پرداخت", // In English: "Payment Method"
    "billing.payment_method_updated": "روش پرداخت به‌روزرسانی شد!", // In English: "Payment method updated!"
    "billing.confirm_payment_method": "تأیید روش پرداخت", // In English: "Confirm Payment Method"
    "billing.payment_history": "تاریخچه پرداخت", // In English: "Payment History"
    "billing.refunded": "بازپرداخت شده", // In English: "Refunded"
    "billing.paid": "پرداخت شده", // In English: "Paid"
    "billing.ok": "تأیید", // In English: "OK"
    "billing.resume_subscription": "از سرگیری اشتراک", // In English: "Resume Subscription"
    "billing.subscription_cancelled": "اشتراک شما لغو شده است.", // In English: "Your subscription has been canceled."
    "billing.subscription_cancelled_description": "شما تا پایان این دوره صورتحساب همچنان به اشتراک خود دسترسی خواهید داشت.", // In English: "You will still have access to your subscription until the end of this billing period."
    "billing.offering.free": "رایگان", // In English: "Free"
    "billing.offering.pro": "حرفه‌ای", // In English: "Professional"
    "billing.offering.business": "تجاری", // In English: "Business"
    "billing.cloud_storage": "فضای ذخیره‌سازی ابری", // In English: "Cloud Storage"
    "billing.ai_access": "دسترسی به هوش مصنوعی", // In English: "AI Access"
    "billing.bandwidth": "پهنای باند", // In English: "Bandwidth"
    "billing.apps_and_games": "برنامه‌ها و بازی‌ها", // In English: "Apps & Games"
    "billing.upgrade_to_pro": "ارتقا به %strong%", // In English: "Upgrade to %strong%"
    "billing.switch_to": "تغییر به %strong%", // In English: "Switch to %strong%"
    "billing.payment_setup": "تنظیم پرداخت", // In English: "Payment Setup"
    "billing.back": "بازگشت", // In English: "Back"
    "billing.you_are_now_subscribed_to": "شما اکنون مشترک سطح %strong% هستید.", // In English: "You are now subscribed to %strong% tier."
    "billing.you_are_now_subscribed_to_without_tier": "شما اکنون مشترک شده‌اید", // In English: "You are now subscribed"
    "billing.subscription_cancellation_confirmation": "آیا مطمئن هستید که می‌خواهید اشتراک خود را لغو کنید؟", // In English: "Are you sure you want to cancel your subscription?"
    "billing.subscription_setup": "تنظیم اشتراک", // In English: "Subscription Setup"
    "billing.cancel_it": "لغو کن", // In English: "Cancel It"
    "billing.keep_it": "نگه دار", // In English: "Keep It"
    "billing.subscription_resumed": "اشتراک %strong% شما از سر گرفته شد!", // In English: "Your %strong% subscription has been resumed!"
    "billing.upgrade_now": "هم‌اکنون ارتقا دهید", // In English: "Upgrade Now"
    "billing.upgrade": "ارتقا", // In English: "Upgrade"
    "billing.currently_on_free_plan": "شما در حال حاضر در طرح رایگان هستید.", // In English: "You are currently on the free plan."
    "billing.download_receipt": "دانلود رسید", // In English: "Download Receipt"
    "billing.subscription_check_error": "هنگام بررسی وضعیت اشتراک شما مشکلی پیش آمد.", // In English: "A problem occurred while checking your subscription status."
    "billing.email_confirmation_needed": "ایمیل شما تأیید نشده است. ما اکنون یک کد برای تأیید آن ارسال خواهیم کرد.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
    "billing.sub_cancelled_but_valid_until": "شما اشتراک خود را لغو کرده‌اید و در پایان دوره صورتحساب به طور خودکار به سطح رایگان تغییر خواهد کرد. تا زمانی که مجدداً مشترک نشوید، هزینه‌ای از شما دریافت نخواهد شد.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
    "billing.current_plan_until_end_of_period": "طرح فعلی شما تا پایان این دوره صورتحساب.", // In English: "Your current plan until the end of this billing period."
    "billing.current_plan": "طرح فعلی", // In English: "Current plan"
    "billing.cancelled_subscription_tier": "اشتراک لغو شده (%%)", // In English: "Cancelled Subscription (%%)"
    "billing.manage": "مدیریت", // In English: "Manage"
    "billing.limited": "محدود", // In English: "Limited"
    "billing.expanded": "گسترش یافته", // In English: "Expanded"
    "billing.accelerated": "تسریع شده", // In English: "Accelerated"
    "billing.enjoy_msg": "از %% فضای ذخیره‌سازی ابری به همراه سایر مزایا لذت ببرید." // In English: "Enjoy %% of Cloud Storage plus other benefits."

  },
};

export default fa;
