/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const en = {
    name: "English",
    english_name: "English",
    code: "en",
    dictionary: {
        about: "About",
        account: "Account",
        account_password: "Verify Account Password",
        access_granted_to: "Access Granted To",
        add_existing_account: "Add Existing Account",
        all_fields_required: 'All fields are required.',
        allow: 'Allow',
        apply: "Apply",
        ascending: 'Ascending',
        associated_websites: "Associated Websites",
        auto_arrange: 'Auto Arrange',
        background: "Background",
        browse: "Browse",
        cancel: 'Cancel',
        center: 'Center',
        change: 'Change',
        change_always_open_with: "Do you want to always open this type of file with",
        change_desktop_background: 'Change desktop background…',
        change_email: "Change Email",
        change_language: "Change Language",
        change_password: "Change Password",
        change_ui_colors: "Change UI Colors",
        change_username: "Change Username",
        clock_visibility: 'Clock Visibility',
        close: 'Close',
        close_all_windows: "Close All Windows",
        close_all_windows_confirm: "Are you sure you want to close all windows?",
        close_all_windows_and_log_out: 'Close Windows and Log Out',
        color: 'Color',
        confirm: 'Confirm',
        confirm_2fa_setup: 'I have added the code to my authenticator app',
        confirm_2fa_recovery: 'I have saved my recovery codes in a secure location',
        confirm_account_for_free_referral_storage_c2a: 'Create an account and confirm your email address to receive 1 GB of free storage. Your friend will get 1 GB of free storage too.',
        confirm_code_generic_incorrect: "Incorrect Code.",
        confirm_code_generic_too_many_requests: "Too many requests. Please wait a few minutes.",
        confirm_code_generic_submit: "Submit Code",
        confirm_code_generic_try_again: "Try Again",
        confirm_code_generic_title: "Enter Confirmation Code",
        confirm_code_2fa_instruction: "Enter the 6-digit code from your authenticator app.",
        confirm_code_2fa_submit_btn: "Submit",
        confirm_code_2fa_title: "Enter 2FA Code",
        confirm_delete_multiple_items: 'Are you sure you want to permanently delete these items?',
        confirm_delete_single_item: 'Do you want to permanently delete this item?',
        confirm_open_apps_log_out: 'You have open apps. Are you sure you want to log out?',
        confirm_new_password: "Confirm New Password",
        confirm_delete_user: "Are you sure you want to delete your account? All your files and data will be permanently deleted. This action cannot be undone.",
        confirm_delete_user_title: "Delete Account?",
        confirm_session_revoke: "Are you sure you want to revoke this session?",
        confirm_your_email_address: "Confirm Your Email Address",
        contact_us: "Contact Us",
        contact_us_verification_required: "You must have a verified email address to use this.",
        contain: 'Contain',
        continue: "Continue",
        copy: 'Copy',
        copy_link: "Copy Link",
        copying: "Copying",
        copying_file: "Copying %%",
        cover: 'Cover',
        create_account: "Create Account",
        create_free_account: "Create Free Account",
        create_shortcut: "Create Shortcut",
        credits: "Credits",
        current_password: "Current Password",
        cut: 'Cut',
        clock: "Clock",
        clock_visible_hide: 'Hide - Always hidden',
        clock_visible_show: 'Show - Always visible',
        clock_visible_auto: 'Auto - Default, visible only in full-screen mode.',
        close_all: 'Close All',
        created: 'Created',
        date_modified: 'Date modified',
        default: 'Default',
        delete: 'Delete',
        delete_account: "Delete Account",
        delete_permanently: "Delete Permanently",
        deleting_file: "Deleting %%",
        deploy_as_app: 'Deploy as app',
        descending: 'Descending',
        desktop: 'Desktop',
        desktop_background_fit: "Fit",
        developers: "Developers",
        dir_published_as_website: `%strong% has been published to:`,
        disable_2fa: 'Disable 2FA',
        disable_2fa_confirm: "Are you sure you want to disable 2FA?",
        disable_2fa_instructions: "Enter your password to disable 2FA.",
        disassociate_dir: "Disassociate Directory",
        documents: 'Documents',
        dont_allow: 'Don\'t Allow',
        download: 'Download',
        download_file: 'Download File',
        downloading: "Downloading",
        email: "Email",
        email_change_confirmation_sent: "A confirmation email has been sent to your new email address. Please check your inbox and follow the instructions to complete the process.",
        email_invalid: 'Email is invalid.',
        email_or_username: "Email or Username",
        email_required: 'Email is required.',
        empty_trash: 'Empty Trash',
        empty_trash_confirmation: `Are you sure you want to permanently delete the items in Trash?`,
        emptying_trash: 'Emptying Trash…',
        enable_2fa: 'Enable 2FA',
        end_hard: "End Hard",
        end_process_force_confirm: "Are you sure you want to force-quit this process?",
        end_soft: "End Soft",
        enlarged_qr_code: "Enlarged QR Code",
        enter_password_to_confirm_delete_user: "Enter your password to confirm account deletion",
        error_message_is_missing: "Error message is missing.",
        error_unknown_cause: "An unknown error occurred.",
        error_uploading_files: "Failed to upload files",
        favorites: "Favorites",
        feedback: "Feedback",
        feedback_c2a: "Please use the form below to send us your feedback, comments, and bug reports.",
        feedback_sent_confirmation: "Thank you for contacting us. If you have an email associated with your account, you will hear back from us as soon as possible.",
        fit: "Fit",
        folder: 'Folder',
        force_quit: 'Force Quit',
        forgot_pass_c2a: "Forgot password?",
        from: "From",
        general: "General",
        get_a_copy_of_on_puter: `Get a copy of '%%' on Puter.com!`,
        get_copy_link: 'Get Copy Link',
        hide_all_windows: "Hide All Windows",
        home: 'Home',
        html_document: 'HTML document',
        hue: 'Hue',
        image: 'Image',
        incorrect_password: "Incorrect password",
        invite_link: "Invite Link",
        item: 'item',
        items_in_trash_cannot_be_renamed: `This item can't be renamed because it's in the trash. To rename this item, first drag it out of the Trash.`,
        jpeg_image: 'JPEG image',
        keep_in_taskbar: 'Keep in Taskbar',
        language: "Language",
        license: "License",
        lightness: 'Lightness',
        link_copied: "Link copied",
        loading: 'Loading',
        log_in: "Log In",
        log_into_another_account_anyway: 'Log into another account anyway',
        log_out: 'Log Out',
        looks_good: "Looks good!",
        manage_sessions: "Manage Sessions",
        menubar_style: "Menubar Style",
        menubar_style_desktop: "Desktop",
        menubar_style_system: "System",
        menubar_style_window: "Window",
        modified: 'Modified',
        move: 'Move',
        moving_file: "Moving %%",
        my_websites: "My Websites",
        name: 'Name',
        name_cannot_be_empty: 'Name cannot be empty.',
        name_cannot_contain_double_period: "Name can not be the '..' character.",
        name_cannot_contain_period: "Name can not be the '.' character.",
        name_cannot_contain_slash: "Name cannot contain the '/' character.",
        name_must_be_string: "Name can only be a string.",
        name_too_long: `Name can not be longer than %% characters.`,
        new: 'New',
        new_email: 'New Email',
        new_folder: 'New folder',
        new_password: "New Password",
        new_username: "New Username",
        no: 'No',
        no_dir_associated_with_site: 'No directory associated with this address.',
        no_websites_published: "You have not published any websites yet. Right click on a folder to get started.",
        ok: 'OK',
        open: "Open",
        open_in_new_tab: "Open in New Tab",
        open_in_new_window: "Open in New Window",
        open_with: "Open With",
        original_name: 'Original Name',
        original_path: 'Original Path',
        oss_code_and_content: "Open Source Software and Content",
        password: "Password",
        password_changed: "Password changed.",
        password_recovery_rate_limit: "You've reached our rate-limit; please wait a few minutes. To prevent this in the future, avoid reloading the page too many times.",
        password_recovery_token_invalid: "This password recovery token is no longer valid.",
        password_recovery_unknown_error: "An unknown error occurred. Please try again later.",
        password_required: 'Password is required.',
        password_strength_error: "Password must be at least 8 characters long and contain at least one uppercase letter, one lowercase letter, one number, and one special character.",
        passwords_do_not_match: '`New Password` and `Confirm New Password` do not match.',
        paste: 'Paste',
        paste_into_folder: "Paste Into Folder",
        path: 'Path',
        personalization: "Personalization",
        pick_name_for_website: "Pick a name for your website:",
        picture: "Picture",
        pictures: 'Pictures',
        plural_suffix: 's',
        powered_by_puter_js: `Powered by {{link=docs}}Puter.js{{/link}}`,
        preparing: "Preparing...",
        preparing_for_upload: "Preparing for upload...",
        print: 'Print',
        privacy: "Privacy",
        proceed_to_login: 'Proceed to login',
        proceed_with_account_deletion: "Proceed with Account Deletion",
        process_status_initializing: "Initializing",
        process_status_running: "Running",
        process_type_app: 'App',
        process_type_init: 'Init',
        process_type_ui: 'UI',
        properties: "Properties",
        public: 'Public',
        publish: "Publish",
        publish_as_website: 'Publish as website',
        puter_description: `Puter is a privacy-first personal cloud to keep all your files, apps, and games in one secure place, accessible from anywhere at any time.`,
        reading: "Reading %strong%",
        writing: "Writing %strong%",
        recent: "Recent",
        recommended: "Recommended",
        recover_password: "Recover Password",
        refer_friends_c2a: "Get 1 GB for every friend who creates and confirms an account on Puter. Your friend will get 1 GB too!",
        refer_friends_social_media_c2a: `Get 1 GB of free storage on Puter.com!`,
        refresh: 'Refresh',
        release_address_confirmation: `Are you sure you want to release this address?`,
        remove_from_taskbar:'Remove from Taskbar',
        rename: 'Rename',
        repeat: 'Repeat',
        replace: 'Replace',
        replace_all: 'Replace All',
        resend_confirmation_code: "Re-send Confirmation Code",
        reset_colors: "Reset Colors",
        restart_puter_confirm: "Are you sure you want to restart Puter?",
        restore: "Restore",
        save: 'Save',
        saturation: 'Saturation',
        save_account: 'Save account',
        save_account_to_get_copy_link: "Please create an account to proceed.",
        save_account_to_publish: 'Please create an account to proceed.',
        save_session: 'Save session',
        save_session_c2a: 'Create an account to save your current session and avoid losing your work.',
        scan_qr_c2a: 'Scan the code below\nto log into this session from other devices',
        scan_qr_2fa: 'Scan the QR code with your authenticator app',
        scan_qr_generic: 'Scan this QR code using your phone or another device',
        search: 'Search',
        seconds: 'seconds',
        security: "Security",
        select: "Select",
        selected: 'selected',
        select_color: 'Select color…',
        sessions: "Sessions",
        send: "Send",
        send_password_recovery_email: "Send Password Recovery Email",
        session_saved: "Thank you for creating an account. This session has been saved.",
        settings: "Settings",
        set_new_password: "Set New Password",
        share: "Share",
        share_to: "Share to",
        share_with: "Share with:",
        shortcut_to: "Shortcut to",
        show_all_windows: "Show All Windows",
        show_hidden: 'Show hidden',
        sign_in_with_puter: "Sign in with Puter",
        sign_up: "Sign Up",
        signing_in: "Signing in…",
        size: 'Size',
        skip: 'Skip',
        something_went_wrong: "Something went wrong.",
        sort_by: 'Sort by',
        start: 'Start',
        status: "Status",
        storage_usage: "Storage Usage",
        storage_puter_used: 'used by Puter',
        taking_longer_than_usual: 'Taking a little longer than usual. Please wait...',
        task_manager: "Task Manager",
        taskmgr_header_name: "Name",
        taskmgr_header_status: "Status",
        taskmgr_header_type: "Type",
        terms: "Terms",
        text_document: 'Text document',
        tos_fineprint: `By clicking 'Create Free Account' you agree to Puter's {{link=terms}}Terms of Service{{/link}} and {{link=privacy}}Privacy Policy{{/link}}.`,
        transparency: "Transparency",
        trash: 'Trash',
        two_factor: 'Two Factor Authentication',
        two_factor_disabled: '2FA Disabled',
        two_factor_enabled: '2FA Enabled',
        type: 'Type',
        type_confirm_to_delete_account: "Type 'confirm' to delete your account.",
        ui_colors: "UI Colors",
        ui_manage_sessions: "Session Manager",
        ui_revoke: "Revoke",
        undo: 'Undo',
        unlimited: 'Unlimited',
        unzip: "Unzip",
        unzipping: "Unzipping %strong%",
        upload: 'Upload',
        upload_here: 'Upload here',
        usage: 'Usage',
        username: "Username",
        username_changed: 'Username updated successfully.',
        username_required: 'Username is required.',
        versions: "Versions",
        videos: 'Videos',
        visibility: 'Visibility',
        yes: 'Yes',
        yes_release_it: 'Yes, Release It',
        you_have_been_referred_to_puter_by_a_friend: "You have been referred to Puter by a friend!",
        zip: "Zip",
        sequencing: "Sequencing %strong%",
        zipping: "Zipping %strong%",

        // === 2FA Setup ===
        setup2fa_1_step_heading: 'Open your authenticator app',
        setup2fa_1_instructions: `
            You can use any authenticator app that supports the Time-based One-Time Password (TOTP) protocol.
            There are many to choose from, but if you're unsure
            <a target="_blank" href="https://authy.com/download">Authy</a>
            is a solid choice for Android and iOS.
        `,
        setup2fa_2_step_heading: 'Scan the QR code',
        setup2fa_3_step_heading: 'Enter the 6-digit code',
        setup2fa_4_step_heading: 'Copy your recovery codes',
        setup2fa_4_instructions: `
            These recovery codes are the only way to access your account if you lose your phone or can't use your authenticator app.
            Make sure to store them in a safe place.
        `,
        setup2fa_5_step_heading: 'Confirm 2FA setup',
        setup2fa_5_confirmation_1: 'I have saved my recovery codes in a secure location',
        setup2fa_5_confirmation_2: 'I am ready to enable 2FA',
        setup2fa_5_button: 'Enable 2FA',

        // === 2FA Login ===
        login2fa_otp_title: 'Enter 2FA Code',
        login2fa_otp_instructions: 'Enter the 6-digit code from your authenticator app.',
        login2fa_recovery_title: 'Enter a recovery code',
        login2fa_recovery_instructions: 'Enter one of your recovery codes to access your account.',
        login2fa_use_recovery_code: 'Use a recovery code',
        login2fa_recovery_back: 'Back',
        login2fa_recovery_placeholder: 'XXXXXXXX',

        // Sharing
        'Editor': 'Editor',
        'Viewer': 'Viewer',
        'People with access': 'People with access',
        'Share With…' : 'Share With…',
        'Owner': 'Owner',
        "You can't share with yourself.": `You can't share with yourself.`,
        'This user already has access to this item': 'This user already has access to this item',

        // Billing
        'billing.change_payment_method': "Change",
        'billing.cancel': "Cancel",
        'billing.download_invoice': "Download",
        'billing.payment_method': "Payment Method",
        'billing.payment_method_updated': "Payment method updated!",
        'billing.confirm_payment_method': 'Confirm Payment Method',
        'billing.payment_history': "Payment History",
        'billing.refunded': "Refunded",
        'billing.paid': "Paid",
        'billing.ok': "OK",
        'billing.resume_subscription': 'Resume Subscription',
        'billing.subscription_cancelled': 'Your subscription has been canceled.',
        'billing.subscription_cancelled_description': 'You will still have access to your subscription until the end of this billing period.',
        'billing.offering.free': 'Free',
        'billing.offering.pro': 'Professional',
        'billing.offering.business': 'Business',
        'billing.cloud_storage': 'Cloud Storage',
        'billing.ai_access': 'AI Access',
        'billing.bandwidth': 'Bandwidth',
        'billing.apps_and_games': 'Apps & Games',
        'billing.upgrade_to_pro': 'Upgrade to %strong%',
        'billing.switch_to': 'Switch to %strong%',
        'billing.payment_setup': 'Payment Setup',
        'billing.back': 'Back',
        'billing.you_are_now_subscribed_to': 'You are now subscribed to %strong% tier.',
        'billing.you_are_now_subscribed_to_without_tier': 'You are now subscribed',
        'billing.subscription_cancellation_confirmation': 'Are you sure you want to cancel your subscription?',
        'billing.subscription_setup': 'Subscription Setup',
        'billing.cancel_it': 'Cancel It',
        'billing.keep_it': 'Keep It',
        'billing.subscription_resumed': 'Your %strong% subscription has been resumed!',
        'billing.upgrade_now': 'Upgrade Now',
        'billing.upgrade': 'Upgrade',
        'billing.currently_on_free_plan': 'You are currently on the free plan.',
        'billing.download_receipt': 'Download Receipt',
        'billing.subscription_check_error': 'A problem occurred while checking your subscription status.',
        'billing.payment_method_updated': 'Payment method updated!',
        'billing.email_confirmation_needed': 'Your email has not been confirmed. We\'ll send you a code to confirm it now.',
        'billing.sub_cancelled_but_valid_until': 'You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe.',
        'billing.current_plan_until_end_of_period': 'Your current plan until the end of this billing period.',
        'billing.current_plan': 'Current plan',
        'billing.cancelled_subscription_tier': 'Cancelled Subscription (%%)',
        'billing.manage': 'Manage',
        'billing.limited': 'Limited',
        'billing.expanded': 'Expanded',
        'billing.accelerated': 'Accelerated',
        'billing.enjoy_msg': 'Enjoy %% of Cloud Storage plus other benefits.',
    }
};

export default en;