/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const de = {
    name: "Deutsch",
    english_name: "German",
    code: "de",
    dictionary: {
        about: "Über",
        account: "Konto",
        account_password: "Kontopasswort eingeben",
        access_granted_to: "Zugriff gewährt an",
        add_existing_account: "Bestehendes Konto hinzufügen",
        all_fields_required: 'Alle Felder sind erforderlich.',
        allow: 'Erlauben',
        apply: "Anwenden",
        ascending: 'Aufsteigend',
        associated_websites: "Zugeordnete Webseiten",
        auto_arrange: 'Automatisch anordnen',
        background: "Hintergrund",
        browse: "Durchsuchen",
        cancel: 'Abbrechen',
        center: 'Zentrieren',
        change_desktop_background: 'Desktop-Hintergrund ändern…',
        change_email: "E-Mail ändern",
        change_language: "Sprache ändern",
        change_password: "Passwort ändern",
        change_ui_colors: "Farben der UI ändern",
        change_username: "Benutzername ändern",
        close: 'Schließen',
        close_all_windows: "Alle Fenster schließen",
        close_all_windows_confirm: "Möchten Sie wirklich alle Fenster schließen?",
        close_all_windows_and_log_out: 'Fenster schließen und abmelden',
        change_always_open_with: "Öffnen Sie diesen Dateityp immer mit",
        color: 'Farbe',
        confirm_2fa_setup: 'Ich habe den Code in meine Authentifizierungs-App eingegeben',
        confirm_2fa_recovery: 'Ich habe meine Wiederherstellungscodes an einem sicheren Ort gespeichert',
        confirm_account_for_free_referral_storage_c2a: 'Erstellen Sie ein Konto und bestätigen Sie Ihre E-Mail-Adresse, um 1 GB kostenlosen Speicherplatz zu erhalten. Ihr Freund erhält ebenfalls 1 GB kostenlosen Speicherplatz.',
        confirm_code_generic_incorrect: "Falscher Code.",
        confirm_code_generic_too_many_requests: "Zu viele Anfragen. Bitte warten Sie ein paar Minuten.",
        confirm_code_generic_submit: "Code einreichen",
        confirm_code_generic_try_again: "Erneut versuchen",
        confirm_code_generic_title: "Bestätigungscode eingeben",
        confirm_code_2fa_instruction: "Geben Sie den 6-stelligen Code aus Ihrer Authentifizierungs-App ein.",
        confirm_code_2fa_submit_btn: "Einreichen",
        confirm_code_2fa_title: "2FA-Code eingeben",
        confirm_delete_multiple_items: 'Möchten Sie diese Elemente dauerhaft löschen?',
        confirm_delete_single_item: 'Möchten Sie dieses Element dauerhaft löschen?',
        confirm_open_apps_log_out: 'Sie haben geöffnete Apps. Möchten Sie sich wirklich abmelden?',
        confirm_new_password: "Neues Passwort bestätigen",
        confirm_delete_user: "Möchten Sie Ihr Konto wirklich löschen? Alle Ihre Dateien und Daten werden dauerhaft gelöscht. Diese Aktion kann nicht rückgängig gemacht werden.",
        confirm_delete_user_title: "Konto löschen?",
        confirm_session_revoke: "Möchten Sie diese Sitzung wirklich widerrufen?",
        confirm_your_email_address: "Bestätigen Sie Ihre E-Mail-Adresse",
        contact_us: "Kontaktieren Sie uns",
        contact_us_verification_required: "Sie müssen eine verifizierte E-Mail-Adresse haben, um dies zu verwenden.",
        contain: 'Füllen',
        continue: "Weiter",
        copy: 'Kopieren',
        copy_link: "Link kopieren",
        copying: "Kopiere",
        copying_file: "Kopieren von %%",
        cover: 'Abdecken',
        create_account: "Konto erstellen",
        create_free_account: "Kostenloses Konto erstellen",
        create_shortcut: "Verknüpfung erstellen",
        credits: "Credits",
        current_password: "Aktuelles Passwort",
        cut: 'Ausschneiden',
        clock: "Uhr",
        clock_visible_hide: 'Ausblenden - Immer ausgeblendet',
        clock_visible_show: 'Sichtbar - Immer sichtbar',
        clock_visible_auto: 'Automatisch - Standard, nur im Vollbildmodus sichtbar.',
        close_all: 'Alle schließen',
        created: 'Erstellt',
        date_modified: 'Datum geändert',
        default: 'Standard',
        delete: 'Löschen',
        delete_account: "Konto löschen",
        delete_permanently: "Dauerhaft löschen",
        deleting_file: "Löschen von %%",
        deploy_as_app: 'Als App bereitstellen',
        descending: 'Absteigend',
        desktop: 'Desktop',
        desktop_background_fit: "Passend",
        developers: "Entwickler",
        dir_published_as_website: `%strong% wurde veröffentlicht unter:`,
        disable_2fa: '2FA deaktivieren',
        disable_2fa_confirm: "Möchten Sie 2FA wirklich deaktivieren?",
        disable_2fa_instructions: "Geben Sie Ihr Passwort ein, um 2FA zu deaktivieren.",
        disassociate_dir: "Verzeichnis trennen",
        documents: 'Dokumente',
        dont_allow: 'Nicht erlauben',
        download: 'Herunterladen',
        download_file: 'Datei herunterladen',
        downloading: "Lädt herunter",
        email: "E-Mail",
        email_change_confirmation_sent: "Eine Bestätigungs-E-Mail wurde an Ihre neue E-Mail-Adresse gesendet. Bitte überprüfen Sie Ihren Posteingang und folgen Sie den Anweisungen, um den Vorgang abzuschließen.",
        email_invalid: 'E-Mail ist ungültig.',
        email_or_username: "E-Mail oder Benutzername",
        email_required: 'E-Mail ist erforderlich.',
        empty_trash: 'Papierkorb leeren',
        empty_trash_confirmation: `Möchten Sie die Elemente im Papierkorb wirklich dauerhaft löschen?`,
        emptying_trash: 'Papierkorb wird geleert…',
        enable_2fa: '2FA aktivieren',
        end_hard: "Hart beenden",
        end_process_force_confirm: "Möchten Sie diesen Prozess wirklich beenden?",
        end_soft: "Weich beenden",
        enlarged_qr_code: "Vergrößerter QR-Code",
        enter_password_to_confirm_delete_user: "Geben Sie Ihr Passwort ein, um die Entferung des Kontos zu bestätigen",
        error_message_is_missing: "Fehlermeldung fehlt.",
        error_unknown_cause: "Ein unbekannter Fehler ist aufgetreten.",
        error_uploading_files: "Dateien konnten nicht hochgeladen werden",
        favorites: "Favoriten",
        feedback: "Rückmeldung",
        feedback_c2a: "Bitte verwenden Sie das folgende Formular, um uns Ihre Rückmeldung, Kommentare und Fehlerberichte zu senden.",
        feedback_sent_confirmation: "Danke, dass Sie uns kontaktiert haben. Wenn Sie eine E-Mail mit Ihrem Konto verknüpft haben, werden Sie so schnell wie möglich von uns hören.",
        fit: "Anpassen",
        folder: 'Ordner',
        force_quit: 'Beenden erzwingen',
        forgot_pass_c2a: "Passwort vergessen?",
        from: "Von",
        general: "Allgemein",
        get_a_copy_of_on_puter: `Holen Sie sich eine Kopie von '%%' auf Puter.com!`,
        get_copy_link: 'Kopierlink erhalten',
        hide_all_windows: "Alle Fenster verstecken",
        home: 'Startseite',
        html_document: 'HTML-Dokument',
        hue: 'Farbton',
        image: 'Bild',
        incorrect_password: "Falsches Passwort",
        invite_link: "Einladungslink",
        item: 'Element',
        items_in_trash_cannot_be_renamed: `Dieses Element kann nicht umbenannt werden, da es sich im Papierkorb befindet. Um dieses Element umzubenennen, ziehen Sie es zunächst aus dem Papierkorb.`,
        jpeg_image: 'JPEG-Bild',
        keep_in_taskbar: 'In Taskleiste behalten',
        language: "Sprache",
        license: "Lizenz",
        lightness: 'Helligkeit',
        link_copied: "Link kopiert",
        loading: 'Laden',
        log_in: "Anmelden",
        log_into_another_account_anyway: 'Trotzdem bei einem anderen Konto anmelden',
        log_out: 'Abmelden',
        looks_good: "Sieht gut aus!",
        manage_sessions: "Sitzungen verwalten",
        menubar_style: "Menüleisten-Stil",
        menubar_style_desktop: "Desktop",
        menubar_style_system: "System",
        menubar_style_window: "Fenster",
        modified: 'Geändert',
        move: 'Verschieben',
        moving_file: "Verschiebe %%",
        my_websites: "Meine Webseiten",
        name: 'Name',
        name_cannot_be_empty: 'Name darf nicht leer sein.',
        name_cannot_contain_double_period: "Name darf nicht das Zeichen '..' enthalten.",
        name_cannot_contain_period: "Name darf nicht das Zeichen '.' enthalten.",
        name_cannot_contain_slash: "Name darf nicht das Zeichen '/' enthalten.",
        name_must_be_string: "Name kann nur eine Zeichenfolge sein.",
        name_too_long: `Name darf nicht länger als %% Zeichen sein.`,
        new: 'Neu',
        new_email: 'Neue E-Mail',
        new_folder: 'Neuer Ordner',
        new_password: "Neues Passwort",
        new_username: "Neuer Benutzername",
        no: 'Nein',
        no_dir_associated_with_site: 'Mit dieser Adresse ist kein Verzeichnis verknüpft.',
        no_websites_published: "Sie haben noch keine Webseite veröffentlicht.",
        ok: 'OK',
        open: "Öffnen",
        open_in_new_tab: "In neuem Tab öffnen",
        open_in_new_window: "In neuem Fenster öffnen",
        open_with: "Öffnen mit",
        original_name: 'Originalname',
        original_path: 'Originalpfad',
        oss_code_and_content: "Open-Source-Software und Inhalte",
        password: "Passwort",
        password_changed: "Passwort geändert.",
        password_recovery_rate_limit: "Sie haben unser Limit erreicht; bitte warten Sie ein paar Minuten. Um dies in Zukunft zu vermeiden, laden Sie die Seite nicht zu oft neu.",
        password_recovery_token_invalid: "Dieses Passwort-Wiederherstellungstoken ist nicht mehr gültig.",
        password_recovery_unknown_error: "Ein unbekannter Fehler ist aufgetreten. Bitte versuchen Sie es später erneut.",
        password_required: 'Passwort ist erforderlich.',
        password_strength_error: "Das Passwort muss mindestens 8 Zeichen lang sein und mindestens einen Großbuchstaben, einen Kleinbuchstaben, eine Zahl und ein Sonderzeichen enthalten.",
        passwords_do_not_match: '`Neues Passwort` und `Neues Passwort bestätigen` stimmen nicht überein.',
        paste: 'Einfügen',
        paste_into_folder: "In Ordner einfügen",
        path: 'Pfad',
        personalization: "Personalisierung",
        pick_name_for_website: "Wählen Sie einen Namen für Ihre Webseite:",
        picture: "Bild",
        pictures: 'Bilder',
        plural_suffix: 's',
        powered_by_puter_js: `Betrieben von {{link=docs}}Puter.js{{/link}}`,
        preparing: "Bereite vor...",
        preparing_for_upload: "Vorbereiten zum Hochladen...",
        print: 'Drucken',
        privacy: "Datenschutz",
        proceed_to_login: 'Zum Login fortfahren',
        proceed_with_account_deletion: "Konto löschen",
        process_status_initializing: "Initialisierung",
        process_status_running: "Aktiv",
        process_type_app: 'App',
        process_type_init: 'Initialisierung',
        process_type_ui: 'Benutzeroberfläche',
        properties: "Eigenschaften",
        public: 'Öffentlich',
        publish: "Veröffentlichen",
        publish_as_website: 'Als Webseite veröffentlichen',
        puter_description: `Puter ist eine datenschutzorientierte persönliche Cloud, um alle Ihre Dateien, Apps und Spiele an einem sicheren Ort zu speichern, von überall und jederzeit zugänglich.`,
        reading_file: "Lesen von %strong%",
        recent: "Kürzlich",
        recommended: "Empfohlen",
        recover_password: "Passwort wiederherstellen",
        refer_friends_c2a: "Erhalten Sie 1 GB für jeden Freund, der ein Konto auf Puter erstellt und bestätigt. Ihr Freund erhält ebenfalls 1 GB!",
        refer_friends_social_media_c2a: `Erhalten Sie 1 GB kostenlosen Speicherplatz auf Puter.com!`,
        refresh: 'Aktualisieren',
        release_address_confirmation: `Möchten Sie diese Adresse wirklich freigeben?`,
        remove_from_taskbar:'Von Taskleiste entfernen',
        rename: 'Umbenennen',
        repeat: 'Wiederholen',
        replace: 'Ersetzen',
        replace_all: 'Alles ersetzen',
        resend_confirmation_code: "Bestätigungscode erneut senden",
        reset_colors: "Farben zurücksetzen",
        restart_puter_confirm: "Möchten Sie Puter wirklich neu starten?",
        restore: "Wiederherstellen",
        save: 'Speichern',
        saturation: 'Sättigung',
        save_account: 'Konto speichern',
        save_account_to_get_copy_link: "Bitte erstellen Sie ein Konto, um fortzufahren.",
        save_account_to_publish: 'Bitte erstellen Sie ein Konto, um fortzufahren.',
        save_session: 'Sitzung speichern',
        save_session_c2a: 'Erstellen Sie ein Konto, um Ihre aktuelle Sitzung zu speichern um den Verlust Ihrer Arbeit zu verhindern.',
        scan_qr_c2a: 'Scannen Sie den folgenden Code, um sich von anderen Geräten in diese Sitzung einzuloggen',
        scan_qr_2fa: 'Scannen Sie den QR-Code mit Ihrer Authentifizierungs-App',
        scan_qr_generic: 'Scannen Sie diesen QR-Code mit Ihrem Telefon oder einem anderen Gerät',
        search: 'Suchen',
        seconds: 'Sekunden',
        security: "Sicherheit",
        select: "Auswählen",
        selected: 'ausgewählt',
        select_color: 'Farbe auswählen…',
        sessions: "Sitzungen",
        send: "Senden",
        send_password_recovery_email: "Sende eine E-Mail, um Ihr Passwort wiederherzustellen",
        session_saved: "Vielen Dank, dass Sie ein Konto erstellt haben. Diese Sitzung wurde gespeichert.",
        settings: "Einstellungen",
        set_new_password: "Neues Passwort festlegen",
        share: "Teilen",
        share_to: "Teilen mit",
        share_with: "Teilen mit:",
        shortcut_to: "Verknüpfung zu",
        show_all_windows: "Alle Fenster anzeigen",
        show_hidden: 'Zeige versteckte',
        sign_in_with_puter: "Mit Puter anmelden",
        sign_up: "Registrieren",
        signing_in: "Anmelden…",
        size: 'Größe',
        skip: 'Überspringen',
        something_went_wrong: "Etwas ist schief gelaufen.",
        sort_by: 'Sortieren nach',
        start: 'Starten',
        status: "Status",
        storage_usage: "Speichernutzung",
        storage_puter_used: 'Verwendet von Puter',
        taking_longer_than_usual: 'Es dauert etwas länger als gewöhnlich. Bitte warten...',
        task_manager: "Task-Manager",
        taskmgr_header_name: "Name",
        taskmgr_header_status: "Status",
        taskmgr_header_type: "Typ",
        terms: "Bedingungen",
        text_document: 'Textdokument',
        tos_fineprint: `Durch Klicken auf 'Kostenloses Konto erstellen' stimmen Sie den {{link=terms}}Nutzungsbedingungen{{/link}} und den {{link=privacy}}Datenschutzrichtlinien{{/link}} von Puter zu.`,
        transparency: "Transparenz",
        trash: 'Papierkorb',
        two_factor: 'Zwei-Faktor-Authentifizierung',
        two_factor_disabled: '2FA deaktiviert',
        two_factor_enabled: '2FA aktiviert',
        type: 'Typ',
        type_confirm_to_delete_account: "Geben Sie 'confirm' ein, um Ihr Konto zu löschen.",
        ui_colors: "Farben der Benutzeroberfläche",
        ui_manage_sessions: "Sitzungsmanager",
        ui_revoke: "Widerrufen",
        undo: 'Rückgängig machen',
        unlimited: 'Unbegrenzt',
        unzip: "Entpacken",
        upload: 'Hochladen',
        upload_here: 'Hier hochladen',
        usage: 'Speicher',
        username: "Benutzername",
        username_changed: 'Benutzername erfolgreich geändert.',
        username_required: 'Benutzername ist erforderlich.',
        versions: "Versionen",
        videos: 'Videos',
        visibility: 'Sichtbarkeit',
        yes: 'Ja',
        yes_release_it: 'Ja, veröffentlichen',
        you_have_been_referred_to_puter_by_a_friend: "Sie wurden von einem Freund an Puter verwiesen!",
        zip: "Verpacken",
        zipping_file: "Verpacken von %strong%",

        // === 2FA Setup ===
        setup2fa_1_step_heading: 'Öffnen Sie Ihre Authentifizierungs-App',
        setup2fa_1_instructions: `
            Sie können jede Authentifizierungs-App verwenden, die das Time-based One-Time Password (TOTP) Protokoll unterstützt.
            Es gibt viele zur Auswahl, aber wenn Sie unsicher sind, ist 
            <a target="_blank" href="https://authy.com/download">Authy</a> 
            eine solide Wahl für Android und iOS.
        `,
        setup2fa_2_step_heading: 'Scannen Sie den QR-Code',
        setup2fa_3_step_heading: 'Geben Sie den 6-stelligen Code ein',
        setup2fa_4_step_heading: 'Kopieren Sie Ihre Wiederherstellungscodes',
        setup2fa_4_instructions: `
            Diese Wiederherstellungscodes sind die einzige Möglichkeit, auf Ihr Konto zuzugreifen, wenn Sie Ihr Telefon verlieren oder Ihre Authentifizierungs-App nicht verwenden können.
            Stellen Sie sicher, dass Sie sie an einem sicheren Ort aufbewahren.
        `,
        setup2fa_5_step_heading: 'Bestätigen Sie die 2FA-Einrichtung',
        setup2fa_5_confirmation_1: 'Ich habe meine Wiederherstellungscodes an einem sicheren Ort gespeichert',
        setup2fa_5_confirmation_2: 'Ich bin bereit, 2FA zu aktivieren',
        setup2fa_5_button: '2FA aktivieren',

        // === 2FA Login ===
        login2fa_otp_title: 'Geben Sie den 2FA-Code ein',
        login2fa_otp_instructions: 'Geben Sie den 6-stelligen Code aus Ihrer Authentifizierungs-App ein.',
        login2fa_recovery_title: 'Geben Sie einen Wiederherstellungscode ein',
        login2fa_recovery_instructions: 'Geben Sie einen Ihrer Wiederherstellungscodes ein, um auf Ihr Konto zuzugreifen.',
        login2fa_use_recovery_code: 'Verwenden Sie einen Wiederherstellungscode',
        login2fa_recovery_back: 'Zurück',
        login2fa_recovery_placeholder: 'XXXXXXXX',

        "change": "Änderung", // In English: "Change"
        "clock_visibility": "Uhrensichtbarkeit", // In English: "Clock Visibility"
        "confirm": "Bestätigen", // In English: "Confirm"
        "reading": "Lesen %strong%", // In English: "Reading %strong%"
        "writing": "Schreiben %strong%", // In English: "Writing %strong%"
        "unzipping": "Entpacken %strong%", // In English: "Unzipping %strong%"
        "sequencing": "Sequenzierung %strong%", // In English: "Sequencing %strong%"
        "zipping": "Zippen %strong%", // In English: "Zipping %strong%"
        "Editor": "Editor", // In English: "Editor"
        "Viewer": "Zuschauer", // In English: "Viewer"
        "People with access": "Personen mit Zugriff", // In English: "People with access"
        "Share With…": "Teilen mit...", // In English: "Share With…"
        "Owner": "Eigentümer", // In English: "Owner"
        "You can't share with yourself.": "Du kannst nicht mit dir selbst teilen.", // In English: "You can't share with yourself."
        "This user already has access to this item": "Dieser Benutzer hat bereits Zugriff auf dieses Element", // In English: "This user already has access to this item"

        "billing.change_payment_method": "Ändern", // In English: "Change"
        "billing.cancel": "Abbrechen", // In English: "Cancel"
        "billing.download_invoice": "Herunterladen", // In English: "Download"
        "billing.payment_method": "Zahlungsmethoden", // In English: "Payment Method"
        "billing.payment_method_updated": "Zahlungsmethoden wurden aktualisiert!", // In English: "Payment method updated!"
        "billing.confirm_payment_method": "Zahlungsmethode bestätigen", // In English: "Confirm Payment Method"
        "billing.payment_history": "Zahlungshistorie", // In English: "Payment History"
        "billing.refunded": "Rückerstattung", // In English: "Refunded"
        "billing.paid": "Bezahlt", // In English: "Paid"
        "billing.ok": "Ok", // In English: "OK"
        "billing.resume_subscription": "Abonnement fortsetzen", // In English: "Resume Subscription"
        "billing.subscription_cancelled": "Dein Abonnement wurde gekündigt.", // In English: "Your subscription has been canceled."
        "billing.subscription_cancelled_description": "Bis zum Ende des Abrechnungszeitraums haben Sie weiterhin Zugriff auf Ihr Abonnement.", // In English: "You will still have access to your subscription until the end of this billing period."
        "billing.offering.free": "Kostenlos", // In English: "Free"
        "billing.offering.pro": "Professionell", // In English: "Professional"
        "billing.offering.business": "Unternehmen", // In English: "Business"
        "billing.cloud_storage": "Cloud Speicher", // In English: "Cloud Storage"
        "billing.ai_access": "KI Zugang", // In English: "AI Access"
        "billing.bandwidth": "Bandbreite", // In English: "Bandwidth"
        "billing.apps_and_games": "Apps & Spiele", // In English: "Apps & Games"
        "billing.upgrade_to_pro": "Aktualisieren auf %strong%", // In English: "Upgrade to %strong%"
        "billing.switch_to": "Wechseln auf %strong%", // In English: "Switch to %strong%"
        "billing.payment_setup": "Einrichtung der Zahlung", // In English: "Payment Setup"
        "billing.back": "Zurück", // In English: "Back"
        "billing.you_are_now_subscribed_to": "Sie haben jetzt den %strong% Plan abonniert.", // In English: "You are now subscribed to %strong% tier."
        "billing.you_are_now_subscribed_to_without_tier": "Sie haben jetzt abonniert", // In English: "You are now subscribed"
        "billing.subscription_cancellation_confirmation": "Sind Sie sicher, dass Sie Ihr Abonnement kündigen möchten?", // In English: "Are you sure you want to cancel your subscription?"
        "billing.subscription_setup": "Abonnement Einrichtung", // In English: "Subscription Setup"
        "billing.cancel_it": "Abbrechen", // In English: "Cancel It"
        "billing.keep_it": "Behalten", // In English: "Keep It"
        "billing.subscription_resumed": "Ihr %strong%-Abonnement wurde fortgesetzt!", // In English: "Your %strong% subscription has been resumed!"
        "billing.upgrade_now": "Jetzt aktualisieren", // In English: "Upgrade Now"
        "billing.upgrade": "Aktualisieren", // In English: "Upgrade"
        "billing.currently_on_free_plan": "Sie sind derzeit im kostenlosen Abonnement.", // In English: "You are currently on the free plan."
        "billing.download_receipt": "Quittung herunterladen", // In English: "Download Receipt"
        "billing.subscription_check_error": "Bei der Überprüfung Ihres Abonnementstatus ist ein Problem aufgetreten.", // In English: "A problem occurred while checking your subscription status."
        "billing.email_confirmation_needed": "Ihre E-Mail wurde noch nicht bestätigt. Wir senden Ihnen jetzt einen Code zur Bestätigung.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
        "billing.sub_cancelled_but_valid_until": "Sie haben Ihr Abonnement gekündigt und es wird am Ende des Abrechnungszeitraums automatisch auf die kostenlose Version umgestellt. Es wird Ihnen nicht erneut in Rechnung gestellt, es sei denn, Sie abonnieren es erneut.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
        "billing.current_plan_until_end_of_period": "Ihr aktueller Plan bis zum Ende dieses Abrechnungszeitraums.", // In English: "Your current plan until the end of this billing period."
        "billing.current_plan": "Aktueller Plan", // In English: "Current plan"
        "billing.cancelled_subscription_tier": "Abonnement abbrechen (%%)", // In English: "Cancelled Subscription (%%)"
        "billing.manage": "Verwalten", // In English: "Manage"
        "billing.limited": "Begrenzt", // In English: "Limited"
        "billing.expanded": "Erweitert", // In English: "Expanded"
        "billing.accelerated": "Beschleunigt", // In English: "Accelerated"
        "billing.enjoy_msg": "Genießen Sie %% des Cloud-Speichers und weitere Vorteile.", // In English: "Enjoy %% of Cloud Storage plus other benefits."
    }
};

export default de;
