/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const da = {
	name: 'Dansk',
	english_name: 'Danish',
	code: 'da',
	dictionary: {
		about: 'Om',
		account: 'Konto',
		account_password: 'Bekræft kontoens adgangskode',
		access_granted_to: 'Adgang givet til',
		add_existing_account: 'Tilføj eksisterende konto',
		all_fields_required: 'Alle felter er påkrævede.',
		allow: 'Tillad',
		apply: 'Anvend',
		ascending: 'Stigende',
		associated_websites: 'Tilknyttede websteder',
		auto_arrange: 'Auto Arrangere',
		background: 'Baggrund',
		browse: 'Gennemse',
		cancel: 'Annuller',
		center: 'Center',
		change_desktop_background: 'Ændre skrivebordsbaggrund…',
		change_email: 'Ændre e-mail',
		change_language: 'Ændre sprog',
		change_password: 'Ændre adgangskode',
		change_ui_colors: 'Ændre UI-farver',
		change_username: 'Ændre brugernavn',
		close: 'Luk',
		close_all_windows: 'Luk alle vinduer',
		close_all_windows_confirm: 'Er du sikker på, at du vil lukke alle vinduer?',
		close_all_windows_and_log_out: 'Luk vinduer og log ud',
		change_always_open_with: 'Vil du altid åbne denne filtype med',
		color: 'Farve',
		confirm: 'Bekræft',
		confirm_2fa_setup: 'Jeg har tilføjet koden til min autentifikator-app',
		confirm_2fa_recovery: 'Jeg har gemt mine gendannelseskoder på et sikkert sted',
		confirm_account_for_free_referral_storage_c2a: 'Opret en konto og bekræft din e-mailadresse for at modtage 1 GB gratis lagerplads. Din ven vil også få 1 GB gratis lagerplads.',
		confirm_code_generic_incorrect: 'Forkert kode.',
		confirm_code_generic_too_many_requests: 'For mange anmodninger. Vent et par minutter.',
		confirm_code_generic_submit: 'Indsend kode',
		confirm_code_generic_try_again: 'Prøv igen',
		confirm_code_generic_title: 'Indtast bekræftelseskode',
		confirm_code_2fa_instruction: 'Indtast den 6-cifrede kode fra din autentifikator-app.',
		confirm_code_2fa_submit_btn: 'Indsend',
		confirm_code_2fa_title: 'Indtast 2FA-kode',
		confirm_delete_multiple_items: 'Er du sikker på, at du vil slette disse elementer permanent?',
		confirm_delete_single_item: 'Vil du slette dette element permanent?',
		confirm_open_apps_log_out: 'Du har åbne apps. Er du sikker på, at du vil logge ud?',
		confirm_new_password: 'Bekræft ny adgangskode',
		confirm_delete_user: 'Er du sikker på, at du vil slette din konto? Alle dine filer og data vil blive permanent slettet. Denne handling kan ikke fortrydes.',
		confirm_delete_user_title: 'Slet konto?',
		confirm_session_revoke: 'Er du sikker på, at du vil tilbagekalde denne session?',
		confirm_your_email_address: 'Bekræft din e-mailadresse',
		contact_us: 'Kontakt os',
		contact_us_verification_required: 'Du skal have en verificeret e-mailadresse for at bruge dette.',
		contain: 'Indeholde',
		continue: 'Fortsæt',
		copy: 'Kopier',
		copy_link: 'Kopier link',
		copying: 'Kopierer',
		copying_file: 'Kopierer %%',
		cover: 'Omslag',
		create_account: 'Opret konto',
		create_free_account: 'Opret gratis konto',
		create_shortcut: 'Opret genvej',
		credits: 'Kreditter',
		current_password: 'Nuværende adgangskode',
		cut: 'Klip',
		clock: 'Uret',
		clock_visible_hide: 'Skjul - Altid skjult',
		clock_visible_show: 'Vis - Altid synlig',
		clock_visible_auto: 'Auto - Standard, synlig kun i fuld skærm-tilstand.',
		close_all: 'Luk alle',
		created: 'Oprettet',
		date_modified: 'Dato ændret',
		default: 'Standard',
		delete: 'Slet',
		delete_account: 'Slet konto',
		delete_permanently: 'Slet permanent',
		deleting_file: 'Sletter %%',
		deploy_as_app: 'Implementer som app',
		descending: 'Faldende',
		desktop: 'Skrivebord',
		desktop_background_fit: 'Tilpas',
		developers: 'Udviklere',
		dir_published_as_website: `%strong% er blevet offentliggjort til:`,
		disable_2fa: 'Deaktiver 2FA',
		disable_2fa_confirm: 'Er du sikker på, at du vil deaktivere 2FA?',
		disable_2fa_instructions: 'Indtast din adgangskode for at deaktivere 2FA.',
		disassociate_dir: 'Fjern tilknytning til mappe',
		documents: 'Dokumenter',
		dont_allow: 'Tillad ikke',
		download: 'Download',
		download_file: 'Download fil',
		downloading: 'Downloader',
		email: 'E-mail',
		email_change_confirmation_sent: 'En bekræftelses-e-mail er sendt til din nye e-mailadresse. Kontroller din indbakke og følg instruktionerne for at fuldføre processen.',
		email_invalid: 'E-mail er ugyldig.',
		email_or_username: 'E-mail eller brugernavn',
		email_required: 'E-mail er påkrævet.',
		empty_trash: 'Tøm papirkurv',
		empty_trash_confirmation: `Er du sikker på, at du vil slette elementerne i papirkurven permanent?`,
		emptying_trash: 'Tømmer papirkurv…',
		enable_2fa: 'Aktivér 2FA',
		end_hard: 'Afslut hårdt',
		end_process_force_confirm: 'Er du sikker på, at du vil afslutte denne proces med tvang?',
		end_soft: 'Afslut blødt',
		enlarged_qr_code: 'Forstørret QR-kode',
		enter_password_to_confirm_delete_user: 'Indtast din adgangskode for at bekræfte sletning af konto',
		error_message_is_missing: 'Fejlmeddelelse mangler.',
		error_unknown_cause: 'Der opstod en ukendt fejl.',
		error_uploading_files: 'Fejl ved upload af filer',
		favorites: 'Favoritter',
		feedback: 'Feedback',
		feedback_c2a: 'Brug venligst formularen nedenfor til at sende os din feedback, kommentarer og fejlrapporter.',
		feedback_sent_confirmation: 'Tak fordi du kontaktede os. Hvis du har en e-mail knyttet til din konto, vil du høre fra os så hurtigt som muligt.',
		fit: 'Pas',
		folder: 'Mappe',
		force_quit: 'Tving afslut',
		forgot_pass_c2a: 'Glemt adgangskode?',
		from: 'Fra',
		general: 'Generelt',
		get_a_copy_of_on_puter: `Få en kopi af '%%' på Puter.com!`,
		get_copy_link: 'Få kopi-link',
		hide_all_windows: 'Skjul alle vinduer',
		home: 'Hjem',
		html_document: 'HTML-dokument',
		hue: 'Farvetone',
		image: 'Billede',
		incorrect_password: 'Forkert adgangskode',
		invite_link: 'Inviter link',
		item: 'element',
		items_in_trash_cannot_be_renamed: `Dette element kan ikke omdøbes, fordi det er i papirkurven. For at omdøbe dette element, skal du først trække det ud af papirkurven.`,
		jpeg_image: 'JPEG-billede',
		keep_in_taskbar: 'Behold i proceslinjen',
		language: 'Sprog',
		license: 'Licens',
		lightness: 'Lysstyrke',
		link_copied: 'Link kopieret',
		loading: 'Indlæser',
		log_in: 'Log ind',
		log_into_another_account_anyway: 'Log ind på en anden konto alligevel',
		log_out: 'Log ud',
		looks_good: 'Ser godt ud!',
		manage_sessions: 'Administrer sessioner',
		menubar_style: 'Menubjælke stil',
		menubar_style_desktop: 'Skrivebord',
		menubar_style_system: 'System',
		menubar_style_window: 'Vindue',
		modified: 'Ændret',
		move: 'Flyt',
		moving_file: 'Flytter %%',
		my_websites: 'Mine websteder',
		name: 'Navn',
		name_cannot_be_empty: 'Navn kan ikke være tomt.',
		name_cannot_contain_double_period: "Navn kan ikke være '..' tegn.",
		name_cannot_contain_period: "Navn kan ikke være '.' tegn.",
		name_cannot_contain_slash: "Navn kan ikke indeholde '/' tegn.",
		name_must_be_string: 'Navn kan kun være en streng.',
		name_too_long: `Navn kan ikke være længere end %% tegn.`,
		new: 'Ny',
		new_email: 'Ny e-mail',
		new_folder: 'Ny mappe',
		new_password: 'Ny adgangskode',
		new_username: 'Nyt brugernavn',
		no: 'Nej',
		no_dir_associated_with_site: 'Ingen mappe tilknyttet denne adresse.',
		no_websites_published: 'Du har ikke offentliggjort nogen websteder endnu. Højreklik på en mappe for at komme i gang.',
		ok: 'OK',
		open: 'Åbn',
		open_in_new_tab: 'Åbn i ny fane',
		open_in_new_window: 'Åbn i nyt vindue',
		open_with: 'Åbn med',
		original_name: 'Originalt navn',
		original_path: 'Original sti',
		oss_code_and_content: 'Open Source Software og indhold',
		password: 'Adgangskode',
		password_changed: 'Adgangskode ændret.',
		password_recovery_rate_limit: 'Du har nået vores rate-limit; vent venligst et par minutter. For at undgå dette i fremtiden, undgå at genindlæse siden for mange gange.',
		password_recovery_token_invalid: 'Denne adgangskodegendannelsestoken er ikke længere gyldig.',
		password_recovery_unknown_error: 'Der opstod en ukendt fejl. Prøv venligst igen senere.',
		password_required: 'Adgangskode er påkrævet.',
		password_strength_error: 'Adgangskoden skal være mindst 8 tegn lang og indeholde mindst ét stort bogstav, ét lille bogstav, ét tal og ét specialtegn.',
		passwords_do_not_match: '`Ny adgangskode` og `Bekræft ny adgangskode` stemmer ikke overens.',
		paste: 'Sæt ind',
		paste_into_folder: 'Sæt ind i mappe',
		path: 'Sti',
		personalization: 'Personalisering',
		pick_name_for_website: 'Vælg et navn til dit websted:',
		picture: 'Billede',
		pictures: 'Billeder',
		plural_suffix: 's',
		powered_by_puter_js: `Udviklet af {{link=docs}}Puter.js{{/link}}`,
		preparing: 'Forbereder...',
		preparing_for_upload: 'Forbereder til upload...',
		print: 'Udskriv',
		privacy: 'Privatliv',
		proceed_to_login: 'Fortsæt til login',
		proceed_with_account_deletion: 'Fortsæt med sletning af konto',
		process_status_initializing: 'Initialiserer',
		process_status_running: 'Kører',
		process_type_app: 'App',
		process_type_init: 'Init',
		process_type_ui: 'UI',
		properties: 'Egenskaber',
		public: 'Offentlig',
		publish: 'Offentliggør',
		publish_as_website: 'Offentliggør som websted',
		puter_description: `Puter er en privatlivsorienteret personlig sky til at opbevare alle dine filer, apps og spil på ét sikkert sted, tilgængeligt fra hvor som helst, når som helst.`,
		reading_file: 'Læser %strong%',
		recent: 'Seneste',
		recommended: 'Anbefalet',
		recover_password: 'Gendan adgangskode',
		refer_friends_c2a: 'Få 1 GB for hver ven, der opretter og bekræfter en konto på Puter. Din ven vil også få 1 GB!',
		refer_friends_social_media_c2a: `Få 1 GB gratis lagerplads på Puter.com!`,
		refresh: 'Opdater',
		release_address_confirmation: `Er du sikker på, at du vil frigive denne adresse?`,
		remove_from_taskbar: 'Fjern fra proceslinje',
		rename: 'Omdøb',
		repeat: 'Gentag',
		replace: 'Erstat',
		replace_all: 'Erstat alle',
		resend_confirmation_code: 'Send bekræftelseskode igen',
		reset_colors: 'Nulstil farver',
		restart_puter_confirm: 'Er du sikker på, at du vil genstarte Puter?',
		restore: 'Gendan',
		save: 'Gem',
		saturation: 'Mætning',
		save_account: 'Gem konto',
		save_account_to_get_copy_link: 'Opret venligst en konto for at fortsætte.',
		save_account_to_publish: 'Opret venligst en konto for at fortsætte.',
		save_session: 'Gem session',
		save_session_c2a: 'Opret en konto for at gemme din nuværende session og undgå at miste dit ændringer.',
		scan_qr_c2a: 'Scan koden nedenfor\nfor at logge ind på denne session fra andre enheder',
		scan_qr_2fa: 'Scan QR-koden med din autentifikator-app',
		scan_qr_generic: 'Scan denne QR-kode med din telefon eller en anden enhed',
		search: 'Søg',
		seconds: 'sekunder',
		security: 'Sikkerhed',
		select: 'Vælg',
		selected: 'valgt',
		select_color: 'Vælg farve…',
		sessions: 'Sessioner',
		send: 'Send',
		send_password_recovery_email: 'Send e-mail til gendannelse af adgangskode',
		session_saved: 'Tak fordi du oprettede en konto. Denne session er blevet gemt.',
		settings: 'Indstillinger',
		set_new_password: 'Indstil ny adgangskode',
		share: 'Del',
		share_to: 'Del til',
		share_with: 'Del med:',
		shortcut_to: 'Genvej til',
		show_all_windows: 'Vis alle vinduer',
		show_hidden: 'Vis skjulte',
		sign_in_with_puter: 'Log ind med Puter',
		sign_up: 'Tilmeld dig',
		signing_in: 'Logger ind…',
		size: 'Størrelse',
		skip: 'Spring over',
		something_went_wrong: 'Noget gik galt.',
		sort_by: 'Sorter efter',
		start: 'Start',
		status: 'Status',
		storage_usage: 'Lagerforbrug',
		storage_puter_used: 'brugt af Puter',
		taking_longer_than_usual: 'Tager lidt længere tid end normalt. Vent venligst...',
		task_manager: 'Opgavehåndtering',
		taskmgr_header_name: 'Navn',
		taskmgr_header_status: 'Status',
		taskmgr_header_type: 'Type',
		terms: 'Vilkår',
		text_document: 'Tekstdokument',
		tos_fineprint: `Ved at klikke på 'Opret gratis konto' accepterer du Puters {{link=terms}}Brugsvilkår{{/link}} og {{link=privacy}}Privatlivspolitik{{/link}}.`,
		transparency: 'Gennemsigtighed',
		trash: 'Papirkurv',
		two_factor: 'To-faktor autentifikation',
		two_factor_disabled: '2FA deaktiveret',
		two_factor_enabled: '2FA aktiveret',
		type: 'Type',
		type_confirm_to_delete_account: "Skriv 'bekræft' for at slette din konto.",
		ui_colors: 'UI-farver',
		ui_manage_sessions: 'Sessionshåndtering',
		ui_revoke: 'Tilbagekald',
		undo: 'Fortryd',
		unlimited: 'Ubegrænset',
		unzip: 'Udpak',
		upload: 'Upload',
		upload_here: 'Upload her',
		usage: 'Brug',
		username: 'Brugernavn',
		username_changed: 'Brugernavn opdateret succesfuldt.',
		username_required: 'Brugernavn er påkrævet.',
		versions: 'Versioner',
		videos: 'Videoer',
		visibility: 'Synlighed',
		yes: 'Ja',
		yes_release_it: 'Ja, frigiv det',
		you_have_been_referred_to_puter_by_a_friend: 'Du er blevet henvist til Puter af en ven!',
		zip: 'Zip',
		zipping_file: 'Zipper %strong%',

		// === 2FA Setup ===
		setup2fa_1_step_heading: 'Åbn din autentifikator-app',
		setup2fa_1_instructions: `
            Du kan bruge enhver autentifikator-app, der understøtter Time-based One-Time Password (TOTP) protokollen.
            Der er mange at vælge imellem, men hvis du er usikker
            <a target="_blank" href="https://authy.com/download">Authy</a>
            er et solidt valg til Android og iOS.
        `,
		setup2fa_2_step_heading: 'Scan QR-koden',
		setup2fa_3_step_heading: 'Indtast den 6-cifrede kode',
		setup2fa_4_step_heading: 'Kopier dine gendannelseskoder',
		setup2fa_4_instructions: `
            Disse gendannelseskoder er den eneste måde at få adgang til din konto, hvis du mister din telefon eller ikke kan bruge din autentifikator-app.
            Sørg for at opbevare dem på et sikkert sted.
        `,
		setup2fa_5_step_heading: 'Bekræft 2FA-opsætning',
		setup2fa_5_confirmation_1: 'Jeg har gemt mine gendannelseskoder på et sikkert sted',
		setup2fa_5_confirmation_2: 'Jeg er klar til at aktivere 2FA',
		setup2fa_5_button: 'Aktivér 2FA',

		// === 2FA Login ===
		login2fa_otp_title: 'Indtast 2FA-kode',
		login2fa_otp_instructions: 'Indtast den 6-cifrede kode fra din autentifikator-app.',
		login2fa_recovery_title: 'Indtast en gendannelseskode',
		login2fa_recovery_instructions: 'Indtast en af dine gendannelseskoder for at få adgang til din konto.',
		login2fa_use_recovery_code: 'Brug en gendannelseskode',
		login2fa_recovery_back: 'Tilbage',
		login2fa_recovery_placeholder: 'XXXXXXXX',

        change: 'Skift', 
        clock_visibility: 'Ur synlighed', 
        reading: 'Læser %strong%', 
        writing: 'Skriver %strong%', 
        unzipping: 'Udpakker %strong%', 
        sequencing: 'Sekventerer %strong%', 
        zipping: 'Zipper %strong%', 
        Editor: 'Redaktør', 
        Viewer: 'Seer', 
        People_with_access: 'Personer med adgang', 
        Share_With: 'Del med…', 
        Owner: 'Ejer', 
        You_cant_share_with_yourself: 'Du kan ikke dele med dig selv.', 
        This_user_already_has_access_to_this_item: 'Denne bruger har allerede adgang til dette element', 
        billing_change_payment_method: 'Skift betalingsmetode', 
        billing_cancel: 'Annuller', 
        billing_download_invoice: 'Download faktura', 
        billing_payment_method: 'Betalingsmetode', 
        billing_payment_method_updated: 'Betalingsmetode opdateret!', 
        billing_confirm_payment_method: 'Bekræft betalingsmetode', 
        billing_payment_history: 'Betalingshistorik', 
        billing_refunded: 'Refunderet', 
        billing_paid: 'Betalt', 
        billing_ok: 'OK', 
        billing_resume_subscription: 'Genoptag abonnement', 
        billing_subscription_cancelled: 'Dit abonnement er blevet annulleret.', 
        billing_subscription_cancelled_description: 'Du vil stadig have adgang til dit abonnement indtil slutningen af denne faktureringsperiode.', 
        billing_offering_free: 'Gratis', 
        billing_offering_pro: 'Professionel', 
        billing_offering_business: 'Forretning', 
        billing_cloud_storage: 'Cloud-lager', 
        billing_ai_access: 'AI-adgang', 
        billing_bandwidth: 'Båndbredde', 
        billing_apps_and_games: 'Apps & Spil', 
        billing_upgrade_to_pro: 'Opgrader til %strong%', 
        billing_switch_to: 'Skift til %strong%', 
        billing_payment_setup: 'Betalingsopsætning', 
        billing_back: 'Tilbage', 
        billing_you_are_now_subscribed_to: 'Du er nu abonneret på %strong% niveau.', 
        billing_you_are_now_subscribed_to_without_tier: 'Du har nu et abonnement', 
        billing_subscription_cancellation_confirmation: 'Er du sikker på, at du vil annullere dit abonnement?', 
        billing_subscription_setup: 'Abonnementsopsætning', 
        billing_cancel_it: 'Annuller det', 
        billing_keep_it: 'Behold det', 
        billing_subscription_resumed: 'Dit %strong% abonnement er blevet genoptaget!', 
        billing_upgrade_now: 'Opgrader nu', 
        billing_upgrade: 'Opgrader', 
        billing_currently_on_free_plan: 'Du bruger i øjeblikket den gratis version.', 
        billing_download_receipt: 'Download kvittering', 
        billing_subscription_check_error: 'Der opstod et problem under kontrol af din abonnementsstatus.', 
        billing_email_confirmation_needed: 'Din e-mail er ikke blevet bekræftet. Vi sender dig en kode for at bekræfte den nu.', 
        billing_sub_cancelled_but_valid_until: 'Du har annulleret dit abonnement, og det vil automatisk skifte til den gratis plan ved slutningen af faktureringsperioden. Du vil ikke blive opkrævet igen, medmindre du genabonnerer.', 
        billing_current_plan_until_end_of_period: 'Din nuværende plan indtil slutningen af denne faktureringsperiode.', 
        billing_current_plan: 'Nuværende plan', 
        billing_cancelled_subscription_tier: 'Annulleret abonnement (%%)', 
        billing_manage: 'Administrer', 
        billing_limited: 'Begrænset', 
        billing_expanded: 'Udvidet', 
        billing_accelerated: 'Accelereret', 
        billing_enjoy_msg: 'Nyd %% af Cloud-lager plus andre fordele.', 
    }
};

export default da;
