/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const br = {
  name: "Português (Brasil)",
  english_name: "Portuguese (Brazil)",
  code: "br",
  dictionary: {
    about: "Sobre",
    account: "Conta",
    account_password: "Verificar Senha da Conta",
    access_granted_to: "Acesso Concedido Para",
    add_existing_account: "Adicionar Conta Existente",
    all_fields_required: 'Todos os campos são obrigatórios.',
    allow: 'Permitir',
    apply: "Aplicar",
    ascending: 'Ascendente',
    associated_websites: "Sites Associados",
    auto_arrange: 'Organizar Automaticamente',
    background: "Plano de Fundo",
    browse: "Navegar",
    cancel: 'Cancelar',
    center: 'Centralizar',
    change_desktop_background: 'Mudar plano de fundo da área de trabalho…',
    change_email: "Mudar Email",
    change_language: "Mudar Idioma",
    change_password: "Mudar Senha",
    change_ui_colors: "Mudar Cores da Interface",
    change_username: "Mudar Nome de Usuário",
    close: 'Fechar',
    close_all_windows: "Fechar Todas as Janelas",
    close_all_windows_confirm: "Tem certeza de que deseja fechar todas as janelas?",
    close_all_windows_and_log_out: 'Fechar Janelas e Sair',
    change_always_open_with: "Deseja sempre abrir este tipo de arquivo com",
    color: 'Cor',
    confirm: 'Confirmar',
    confirm_2fa_setup: 'Adicionei o código ao meu aplicativo autenticador',
    confirm_2fa_recovery: 'Salvei meus códigos de recuperação em um local seguro',
    confirm_account_for_free_referral_storage_c2a: 'Crie uma conta e confirme seu endereço de e-mail para receber 1 GB de armazenamento gratuito. Seu amigo também receberá 1 GB de armazenamento gratuito.',
    confirm_code_generic_incorrect: "Código Incorreto.",
    confirm_code_generic_too_many_requests: "Muitas solicitações. Por favor, aguarde alguns minutos.",
    confirm_code_generic_submit: "Enviar Código",
    confirm_code_generic_try_again: "Tente Novamente",
    confirm_code_generic_title: "Digite o Código de Confirmação",
    confirm_code_2fa_instruction: "Digite o código de 6 dígitos do seu aplicativo autenticador.",
    confirm_code_2fa_submit_btn: "Enviar",
    confirm_code_2fa_title: "Digite o Código 2FA",
    confirm_delete_multiple_items: 'Tem certeza de que deseja excluir permanentemente estes itens?',
    confirm_delete_single_item: 'Deseja excluir permanentemente este item?',
    confirm_open_apps_log_out: 'Você tem aplicativos abertos. Tem certeza de que deseja sair?',
    confirm_new_password: "Confirmar Nova Senha",
    confirm_delete_user: "Tem certeza de que deseja excluir sua conta? Todos os seus arquivos e dados serão permanentemente excluídos. Esta ação não pode ser desfeita.",
    confirm_delete_user_title: "Excluir Conta?",
    confirm_session_revoke: "Tem certeza de que deseja revogar esta sessão?",
    confirm_your_email_address: "Confirme Seu Endereço de Email",
    contact_us: "Fale Conosco",
    contact_us_verification_required: "Você deve ter um endereço de e-mail verificado para usar isto.",
    contain: 'Conter',
    continue: "Continuar",
    copy: 'Copiar',
    copy_link: "Copiar Link",
    copying: "Copiando",
    copying_file: "Copiando %%",
    cover: 'Cobrir',
    create_account: "Criar Conta",
    create_free_account: "Criar Conta Gratuita",
    create_shortcut: "Criar Atalho",
    credits: "Créditos",
    current_password: "Senha Atual",
    cut: 'Recortar',
    clock: "Relógio",
    clock_visible_hide: 'Ocultar - Sempre oculto',
    clock_visible_show: 'Mostrar - Sempre visível',
    clock_visible_auto: 'Auto - Padrão, visível apenas no modo de tela cheia.',
    close_all: 'Fechar Tudo',
    created: 'Criado',
    date_modified: 'Data de modificação',
    default: 'Padrão',
    delete: 'Excluir',
    delete_account: "Excluir Conta",
    delete_permanently: "Excluir Permanentemente",
    deleting_file: "Excluindo %%",
    deploy_as_app: 'Implantar como aplicativo',
    descending: 'Descendente',
    desktop: 'Área de Trabalho',
    desktop_background_fit: "Ajustar",
    developers: "Desenvolvedores",
    dir_published_as_website: `%strong% foi publicado em:`,
    disable_2fa: 'Desativar 2FA',
    disable_2fa_confirm: "Tem certeza de que deseja desativar 2FA?",
    disable_2fa_instructions: "Digite sua senha para desativar 2FA.",
    disassociate_dir: "Desassociar Diretório",
    documents: 'Documentos',
    dont_allow: 'Não Permitir',
    download: 'Baixar',
    download_file: 'Baixar Arquivo',
    downloading: "Baixando",
    email: "Email",
    email_change_confirmation_sent: "Um e-mail de confirmação foi enviado para seu novo endereço de e-mail. Por favor, verifique sua caixa de entrada e siga as instruções para concluir o processo.",
    email_invalid: 'Email inválido.',
    email_or_username: "Email ou Nome de Usuário",
    email_required: 'Email é obrigatório.',
    empty_trash: 'Esvaziar Lixeira',
    empty_trash_confirmation: `Tem certeza de que deseja excluir permanentemente os itens na Lixeira?`,
    emptying_trash: 'Esvaziando Lixeira…',
    enable_2fa: 'Ativar 2FA',
    end_hard: "Finalizar Forçadamente",
    end_process_force_confirm: "Tem certeza de que deseja finalizar forçadamente este processo?",
    end_soft: "Finalizar Suavemente",
    enlarged_qr_code: "Código QR Ampliado",
    enter_password_to_confirm_delete_user: "Digite sua senha para confirmar a exclusão da conta",
    error_message_is_missing: "Mensagem de erro está ausente.",
    error_unknown_cause: "Ocorreu um erro desconhecido.",
    error_uploading_files: "Falha ao carregar arquivos",
    favorites: "Favoritos",
    feedback: "Feedback",
    feedback_c2a: "Por favor, use o formulário abaixo para nos enviar seu feedback, comentários e relatórios de bugs.",
    feedback_sent_confirmation: "Obrigado por nos contatar. Se você tiver um e-mail associado à sua conta, você receberá uma resposta nossa o mais rápido possível.",
    fit: "Ajustar",
    folder: 'Pasta',
    force_quit: 'Forçar Encerrar',
    forgot_pass_c2a: "Esqueceu a senha?",
    from: "De",
    general: "Geral",
    get_a_copy_of_on_puter: `Obtenha uma cópia de '%%' em Puter.com!`,
    get_copy_link: 'Obter Link de Cópia',
    hide_all_windows: "Ocultar Todas as Janelas",
    home: 'Início',
    html_document: 'Documento HTML',
    hue: 'Matiz',
    image: 'Imagem',
    incorrect_password: "Senha incorreta",
    invite_link: "Link de Convite",
    item: 'item',
    items_in_trash_cannot_be_renamed: `Este item não pode ser renomeado porque está na lixeira. Para renomear este item, primeiro arraste-o para fora da Lixeira.`,
    jpeg_image: 'Imagem JPEG',
    keep_in_taskbar: 'Manter na Barra de Tarefas',
    language: "Idioma",
    license: "Licença",
    lightness: 'Luminosidade',
    link_copied: "Link copiado",
    loading: 'Carregando',
    log_in: "Entrar",
    log_into_another_account_anyway: 'Entrar em outra conta de qualquer maneira',
    log_out: 'Sair',
    looks_good: "Parece bom!",
    manage_sessions: "Gerenciar Sessões",
    menubar_style: "Estilo da Barra de Menus",
    menubar_style_desktop: "Área de Trabalho",
    menubar_style_system: "Sistema",
    menubar_style_window: "Janela",
    modified: 'Modificado',
    move: 'Mover',
    moving_file: "Movendo %%",
    my_websites: "Meus Sites",
    name: 'Nome',
    name_cannot_be_empty: 'O nome não pode estar vazio.',
    name_cannot_contain_double_period: "O nome não pode ser o caractere '..'.",
    name_cannot_contain_period: "O nome não pode ser o caractere '.'.",
    name_cannot_contain_slash: "O nome não pode conter o caractere '/'.",
    name_must_be_string: "O nome só pode ser uma string.",
    name_too_long: `O nome não pode ter mais de %% caracteres.`,
    new: 'Novo',
    new_email: 'Novo Email',
    new_folder: 'Nova pasta',
    new_password: "Nova Senha",
    new_username: "Novo Nome de Usuário",
    "no": "Não",
    "no_dir_associated_with_site": "Nenhum diretório associado a este endereço.",
    "no_websites_published": "Você ainda não publicou nenhum site.",
    "ok": "OK",
    "open": "Abrir",
    "open_in_new_tab": "Abrir em Nova Aba",
    "open_in_new_window": "Abrir em Nova Janela",
    "open_with": "Abrir Com",
    "original_name": "Nome Original",
    "original_path": "Caminho Original",
    "oss_code_and_content": "Software e Conteúdo de Código Aberto",
    "password": "Senha",
    "password_changed": "Senha alterada.",
    "password_recovery_rate_limit": "Você atingiu nosso limite de tentativas; por favor, aguarde alguns minutos. Para evitar isso no futuro, evite recarregar a página muitas vezes.",
    "password_recovery_token_invalid": "Este token de recuperação de senha não é mais válido.",
    "password_recovery_unknown_error": "Ocorreu um erro desconhecido. Por favor, tente novamente mais tarde.",
    "password_required": "Senha é necessária.",
    "password_strength_error": "A senha deve ter pelo menos 8 caracteres e conter pelo menos uma letra maiúscula, uma letra minúscula, um número e um caractere especial.",
    "passwords_do_not_match": "`Nova Senha` e `Confirmar Nova Senha` não correspondem.",
    "paste": "Colar",
    "paste_into_folder": "Colar na Pasta",
    "path": "Caminho",
    "personalization": "Personalização",
    "pick_name_for_website": "Escolha um nome para o seu site:",
    "picture": "Imagem",
    "pictures": "Imagens",
    "plural_suffix": "s",
    "powered_by_puter_js": "Desenvolvido por {{link=docs}}Puter.js{{/link}}",
    "preparing": "Preparando...",
    "preparing_for_upload": "Preparando para upload...",
    "print": "Imprimir",
    "privacy": "Privacidade",
    "proceed_to_login": "Prossiga para o login",
    "proceed_with_account_deletion": "Prosseguir com a Exclusão da Conta",
    "process_status_initializing": "Inicializando",
    "process_status_running": "Executando",
    "process_type_app": "App",
    "process_type_init": "Início",
    "process_type_ui": "UI",
    "properties": "Propriedades",
    "public": "Público",
    "publish": "Publicar",
    "publish_as_website": "Publicar como site",
    "puter_description": "Puter é uma nuvem pessoal que prioriza a privacidade para manter todos os seus arquivos, aplicativos e jogos em um lugar seguro, acessível de qualquer lugar a qualquer momento.",
    "reading_file": "Lendo %strong%",
    "recent": "Recente",
    "recommended": "Recomendado",
    "recover_password": "Recuperar Senha",
    "refer_friends_c2a": "Ganhe 1 GB para cada amigo que criar e confirmar uma conta no Puter. Seu amigo também ganhará 1 GB!",
    "refer_friends_social_media_c2a": "Ganhe 1 GB de armazenamento gratuito no Puter.com!",
    "refresh": "Atualizar",
    "release_address_confirmation": "Tem certeza de que deseja liberar este endereço?",
    "remove_from_taskbar": "Remover da Barra de Tarefas",
    "rename": "Renomear",
    "repeat": "Repetir",
    "replace": "Substituir",
    "replace_all": "Substituir Todos",
    "resend_confirmation_code": "Reenviar Código de Confirmação",
    "reset_colors": "Redefinir Cores",
    "restart_puter_confirm": "Tem certeza de que deseja reiniciar o Puter?",
    "restore": "Restaurar",
    "save": "Salvar",
    "saturation": "Saturação",
    "save_account": "Salvar conta",
    "save_account_to_get_copy_link": "Por favor, crie uma conta para prosseguir.",
    "save_account_to_publish": "Por favor, crie uma conta para prosseguir.",
    "save_session": "Salvar sessão",
    "save_session_c2a": "Crie uma conta para salvar sua sessão atual e evitar perder seu trabalho.",
    "scan_qr_c2a": "Escaneie o código abaixo para fazer login nesta sessão a partir de outros dispositivos",
    "scan_qr_2fa": "Escaneie o código QR com seu aplicativo autenticador",
    "scan_qr_generic": "Escaneie este código QR usando seu telefone ou outro dispositivo",
    "search": "Buscar",
    "seconds": "segundos",
    "security": "Segurança",
    "select": "Selecionar",
    "selected": "selecionado",
    "select_color": "Selecionar cor…",
    "sessions": "Sessões",
    "send": "Enviar",
    "send_password_recovery_email": "Enviar E-mail de Recuperação de Senha",
    "session_saved": "Obrigado por criar uma conta. Esta sessão foi salva.",
    "settings": "Configurações",
    "set_new_password": "Definir Nova Senha",
    "share": "Compartilhar",
    "share_to": "Compartilhar para",
    "share_with": "Compartilhar com:",
    "shortcut_to": "Atalho para",
    "show_all_windows": "Mostrar Todas as Janelas",
    "show_hidden": "Mostrar ocultos",
    "sign_in_with_puter": "Entrar com Puter",
    "sign_up": "Cadastrar-se",
    "signing_in": "Entrando...",
    "size": "Tamanho",
    "skip": "Pular",
    "something_went_wrong": "Algo deu errado.",
    "sort_by": "Ordenar por",
    "start": "Iniciar",
    "status": "Status",
    "storage_usage": "Uso de Armazenamento",
    "storage_puter_used": "usado pelo Puter",
    "taking_longer_than_usual": "Levando um pouco mais de tempo do que o normal. Por favor, aguarde...",
    "task_manager": "Gerenciador de Tarefas",
    "taskmgr_header_name": "Nome",
    "taskmgr_header_status": "Status",
    "taskmgr_header_type": "Tipo",
    "terms": "Termos",
    "text_document": "Documento de texto",
    "tos_fineprint": "Ao clicar em 'Criar Conta Gratuita' você concorda com os {{link=terms}}Termos de Serviço{{/link}} e a {{link=privacy}}Política de Privacidade{{/link}} do Puter.",
    "transparency": "Transparência",
    "trash": "Lixeira",
    "two_factor": "Autenticação de Dois Fatores",
    "two_factor_disabled": "2FA Desativada",
    "two_factor_enabled": "2FA Ativada",
    "type": "Tipo",
    "type_confirm_to_delete_account": "Digite 'confirmar' para excluir sua conta.",
    "ui_colors": "Cores da Interface",
    "ui_manage_sessions": "Gerenciador de Sessões",
    "ui_revoke": "Revogar",
    "undo": "Desfazer",
    "unlimited": "Ilimitado",
    "unzip": "Descompactar",
    "upload": "Upload",
    "upload_here": "Fazer upload aqui",
    "usage": "Uso",
    "username": "Nome de Usuário",
    "username_changed": "Nome de usuário atualizado com sucesso.",
    "username_required": "Nome de usuário é necessário.",
    "versions": "Versões",
    "videos": "Vídeos",
    "visibility": "Visibilidade",
    "yes": "Sim",
    "yes_release_it": "Sim, Liberar",
    "you_have_been_referred_to_puter_by_a_friend": "Você foi indicado ao Puter por um amigo!",
    "zip": "Compactar",
    "zipping_file": "Compactando %strong%",

    // === 2FA Setup ===
    "setup2fa_1_step_heading": "Abra seu aplicativo autenticador",
    "setup2fa_1_instructions": `
        Você pode usar qualquer aplicativo autenticador que suporte o protocolo de Senha de Uso Único com Base em Tempo (TOTP).
        Existem muitas opções, mas se você não tiver certeza 
        <a target='_blank' href='https://authy.com/download'>Authy</a>
        é uma escolha sólida para Android e iOS.
        `,
    "setup2fa_2_step_heading": "Escaneie o código QR",
    "setup2fa_3_step_heading": "Digite o código de 6 dígitos",
    "setup2fa_4_step_heading": "Copie seus códigos de recuperação",
    "setup2fa_4_instructions": `
        Esses códigos de recuperação são a única maneira de acessar sua conta se você perder seu telefone ou não puder usar seu aplicativo autenticador.
        Certifique-se de armazená-los em um lugar seguro.
    `,
    "setup2fa_5_step_heading": "Confirme a configuração do 2FA",
    "setup2fa_5_confirmation_1": "Salvei meus códigos de recuperação em um local seguro",
    "setup2fa_5_confirmation_2": "Estou pronto para ativar o 2FA",
    "setup2fa_5_button": "Ativar 2FA",

    // === 2FA Login ===
    "login2fa_otp_title": "Digite o Código 2FA",
    "login2fa_otp_instructions": "Digite o código de 6 dígitos do seu aplicativo autenticador.",
    "login2fa_recovery_title": "Digite um código de recuperação",
    "login2fa_recovery_instructions": "Digite um dos seus códigos de recuperação para acessar sua conta.",
    "login2fa_use_recovery_code": "Usar um código de recuperação",
    "login2fa_recovery_back": "Voltar",
    "login2fa_recovery_placeholder": "XXXXXXXX",

    "change": "Alterar", // In English: "Change"
    "clock_visibility": "Visibilidade do relógio", // In English: "Clock Visibility"
    "reading": "Lendo %strong%", // In English: "Reading %strong%"
    "writing": "Escrevendo %strong%", // In English: "Writing %strong%"
    "unzipping": "Descompactando %strong%", // In English: "Unzipping %strong%"
    "sequencing": "Sequenciando %strong%", // In English: "Sequencing %strong%"
    "zipping": "Compactando %strong%", // In English: "Zipping %strong%"
    "Editor": "Editor", // In English: "Editor"
    "Viewer": "Visualizador", // In English: "Viewer"
    "People with access": "Pessoas com acesso", // In English: "People with access"
    "Share With…": "Compartilhar com...", // In English: "Share With…"
    "Owner": "Proprietário", // In English: "Owner"
    "You can't share with yourself.": "Vocẽ não pode compartilhar com você mesmo", // In English: "You can't share with yourself."
    "This user already has access to this item": "Esse usuário já tem acesso a esse item", // In English: "This user already has access to this item"     

    "billing.change_payment_method": "Mudar", // In English: "Change"
    "billing.cancel": "Cancelar", // In English: "Cancel"
    "billing.download_invoice": "Baixar", // In English: "Download"
    "billing.payment_method": "Método de Pagamento", // In English: "Payment Method"
    "billing.payment_method_updated": "Método de Pagamento Atualizado!", // In English: "Payment method updated!"
    "billing.confirm_payment_method": "Confirmar Método de Pagamento", // In English: "Confirm Payment Method"
    "billing.payment_history": "Histórico de Pagamento", // In English: "Payment History"
    "billing.refunded": "Reembolsado", // In English: "Refunded"
    "billing.paid": "Pago", // In English: "Paid"
    "billing.ok": "OK", // In English: "OK"
    "billing.resume_subscription": "Continuar Assinatura", // In English: "Resume Subscription"
    "billing.subscription_cancelled": "Sua assinatura foi cancelada", // In English: "Your subscription has been canceled."
    "billing.subscription_cancelled_description": "Você ainda terá acesso a sua assinatura até finalizar o período pago", // In English: "You will still have access to your subscription until the end of this billing period."
    "billing.offering.free": "Grátis", // In English: "Free"
    "billing.offering.pro": "Profissional", // In English: "Professional"
    "billing.offering.business": "Business", // In English: "Business"
    "billing.cloud_storage": "Armazenamento em Nuvem", // In English: "Cloud Storage"
    "billing.ai_access": "Acesso à IA", // In English: "AI Access"
    "billing.bandwidth": "Largura de banda", // In English: "Bandwidth"
    "billing.apps_and_games": "Apps e Games", // In English: "Apps & Games"
    "billing.upgrade_to_pro": "Atualize para %strong%", // In English: "Upgrade to %strong%"
    "billing.switch_to": "Mudar para %strong%", // In English: "Switch to %strong%"
    "billing.payment_setup": "Configuração de Pagamento", // In English: "Payment Setup"
    "billing.back": "Voltar", // In English: "Back"
    "billing.you_are_now_subscribed_to": "Agora você está inscrito no plano %strong%.", // In English: "You are now subscribed to %strong% tier."
    "billing.you_are_now_subscribed_to_without_tier": "Você agora está inscrito.", // In English: "You are now subscribed"
    "billing.subscription_cancellation_confirmation": "Você tem certeza que quer cancelar sua assinatura ?", // In English: "Are you sure you want to cancel your subscription?"
    "billing.subscription_setup": "Configuração de assinatura", // In English: "Subscription Setup"
    "billing.cancel_it": "Cancelar", // In English: "Cancel It"
    "billing.keep_it": "Mantenha isso", // In English: "Keep It"
    "billing.subscription_resumed": "Seu plano %strong% foi renovado!", // In English: "Your %strong% subscription has been resumed!"
    "billing.upgrade_now": "Atualizar Agora", // In English: "Upgrade Now"
    "billing.upgrade": "Atualizar", // In English: "Upgrade"
    "billing.currently_on_free_plan": "Você atualmente esta usando o plano grátis.", // In English: "You are currently on the free plan."
    "billing.download_receipt": "Baixar Comprovante", // In English: "Download Receipt"
    "billing.subscription_check_error": "Ocorreu um problema ao verificar o status da sua assinatura.", // In English: "A problem occurred while checking your subscription status."
    "billing.email_confirmation_needed": "Seu e-mail não foi confirmado. Enviaremos um código para confirmá-lo agora.", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
    "billing.sub_cancelled_but_valid_until": "Você cancelou sua assinatura e ela será automaticamente revertida para o plano gratuito no final do período de cobrança. Você não será cobrado novamente, a menos que reative a assinatura.", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
    "billing.current_plan_until_end_of_period": "Seu plano atual até o final deste período de cobrança.", // In English: "Your current plan until the end of this billing period."
    "billing.current_plan": "Plano atual", // In English: "Current plan"
    "billing.cancelled_subscription_tier": "Assinatura Cancelada (%%)", // In English: "Cancelled Subscription (%%)"
    "billing.manage": "Gerenciar", // In English: "Manage"
    "billing.limited": "Limitado", // In English: "Limited"
    "billing.expanded": "Expandido", // In English: "Expanded"
    "billing.accelerated": "Aprimorado", // In English: "Accelerated"
    "billing.enjoy_msg": "Aproveite %% de Armazenamento em Nuvem, além de outros benefícios.", // In English: "Enjoy %% of Cloud Storage plus other benefits."
  }
};

export default br;
