/**
 * Copyright (C) 2024-present Puter Technologies Inc.
 *
 * This file is part of Puter.
 *
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

const bn = {
  name: "বাংলা",
  english_name: "Bengali",
  code: "bn",
  dictionary: {
    about: "সম্পর্কে",
    account: "অ্যাকাউন্ট",
    account_password: "অ্যাকাউন্ট পাসওয়ার্ড যাচাই করুন",
    access_granted_to: "অ্যাক্সেস দেওয়া হয়েছে",
    add_existing_account: "বিদ্যমান অ্যাকাউন্ট যোগ করুন",
    all_fields_required: "সমস্ত ফিল্ড পূরন করুন.",
    allow: "অনুমতি দিন",
    apply: "প্রয়োগ করুন",
    ascending: "ঊর্ধ্বক্রমে",
    associated_websites: "সংযুক্ত ওয়েবসাইটগুলি",
    auto_arrange: "অটো বিন্যাস",
    background: "পেছনের অংশ",
    browse: "ব্রাউজ",
    cancel: "বাতিল করুন",
    center: "কেন্দ্র",
    change_desktop_background: "ডেস্কটপ পটভূমি পরিবর্তন করুন",
    change_email: "ই-মেইল পরিবর্তন করুন",
    change_language: "ভাষা পরিবর্তন করুন",
    change_password: "পাসওয়ার্ড পরিবর্তন করুন",
    change_ui_colors: "ইউআই রঙ পরিবর্তন করুন",
    change_username: "ইউজারনেম পরিবর্তন করুন",
    close: "বন্ধ করুন",
    close_all_windows: "সমস্ত উইন্ডো বন্ধ করুন",
    close_all_windows_confirm: "আপনি কি সমস্ত উইন্ডো বন্ধ করতে চান?",
    close_all_windows_and_log_out: "উইন্ডো বন্ধ এবং লগ আউট করুন",
    change_always_open_with:  "আপনি কি এই ধরনের ফাইলটি সবসময় এই সাথে খোলা রাখতে চান",
    color: "রঙ",
    confirm: "অনুমোদন",
    confirm_2fa_setup: "২ ফেক্টর অথেন্টিকেশন সেটাপ নিশ্চিত করুন",
    confirm_2fa_recovery: "আমি আমার পুনরুদ্ধার কোডগুলি একটি নিরাপদ স্থানে সংরক্ষণ করতে চাই",
    confirm_account_for_free_referral_storage_c2a: "একটি অ্যাকাউন্ট তৈরি করুন এবং আপনার ইমেল ঠিকানা নিশ্চিত করুন যাতে ফ্রি ১ জিবি স্টোরেজ পান। আপনার বন্ধুও ১ জিবি ফ্রি স্টোরেজ পাবেন",
    confirm_code_generic_incorrect: "কোডটি সঠিক নয় নিশ্চিত করুন।",
    confirm_code_generic_too_many_requests: "অনুরোধের সংখ্যা বেশি হয়েছে, দয়া করে পরে আবার চেষ্টা করুন।",
    confirm_code_generic_submit: "কোডটি নিশ্চিত করুন",
    confirm_code_generic_try_again: "আবার চেষ্টা করুন",
    confirm_code_generic_title: "শিরোনাম অনুমোদন দিন",
    confirm_code_2fa_instruction: "আপনার অথেন্টিকেশন অ্যাপ্লিকেশন থেকে ৬-ডিজিটের কোডটি প্রবেশ করুন।",
    confirm_code_2fa_submit_btn: "জমা দিন",
    confirm_code_2fa_title: "2FA কোড প্রবেশ করুন",
    confirm_delete_multiple_items: "আপনি কি নিশ্চিত যে আপনি এই আইটেমগুলি স্থায়ীভাবে মুছতে চান?",
    confirm_delete_single_item: "আপনি কি এই আইটেমটি স্থায়ীভাবে মুছতে চান?",
    confirm_open_apps_log_out:  "আপনার খোলা অ্যাপ আছে। আপনি কি নিশ্চিত যে আপনি লগ আউট করতে চান?",
    confirm_new_password: "নতুন পাসওয়ার্ড নিশ্চিত করুন",
    confirm_delete_user: "আপনি কি নিশ্চিত যে আপনি আপনার অ্যাকাউন্টটি মুছতে চান? সমস্ত আপনার ফাইল এবং ডেটা স্থায়ীভাবে মুছে ফেলা হবে। এই ক্রিয়াটি ফিরে পাওয়া যাবে না।",
    confirm_delete_user_title: "অ্যাকাউন্ট মুছে ফেলুন?",
    confirm_session_revoke: "আপনি কি নিশ্চিত যে আপনি এই সেশনটি প্রত্যাহার করতে চান?",
    confirm_your_email_address: "আপনার ইমেল ঠিকানা নিশ্চিত করুন",
    contact_us: "যোগাযোগ করুন",
    contact_us_verification_required: "যোগাযোগের জন্য যাচাইকরণ প্রয়োজন",
    contain: "অন্তর্ভুক্ত করুন",
    continue: "চালিয়ে যান",
    copy: "কপি",
    copy_link: "লিংক কপি করুন",
    copying: "কপি হচ্ছে",
    copying_file: "ফাইল কপি করা হচ্ছে %%",
    cover: "কভার",
    create_account: "অ্যাকাউন্ট তৈরি করুন",
    create_free_account: "ফ্রি অ্যাকাউন্ট তৈরি করুন",
    create_shortcut: "শর্টকাট তৈরি করুন",
    credits: "ক্রেডিট",
    current_password: "বর্তমান পাসওয়ার্ড",
    cut: "কাটুন",
    clock: "ঘড়ি",
    clock_visible_hide: "ঘড়ি লুকানো",
    clock_visible_show: "ঘড়ি দৃশ্যমান",
    clock_visible_auto: "ঘড়ি দৃশ্যমান অটো",
    close_all: "সমস্ত বন্ধ করুন",
    created: "তৈরি করা হয়েছে",
    date_modified: "তারিখ পরিবর্তন",
    default: "ডিফল্ট",
    delete: "মুছে ফেলুন",
    delete_account: "অ্যাকাউন্ট মুছে ফেলুন",
    delete_permanently: "স্থায়ীভাবে মুছুন",
    deleting_file: "ফাইল মুছে ফেলা হচ্ছে %%",
    deploy_as_app: "অ্যাপ্লিকেশন হিসেবে ডিপ্লয়",
    descending: "নিম্নক্রমে",
    desktop: "ডেস্কটপ",
    desktop_background_fit: "ফিট",
    developers: "ডেভেলপারগণ",
    dir_published_as_website: `%strong% প্রকাশিত হয়েছে:`,
    disable_2fa: "2FA অক্ষম করুন",
    disable_2fa_confirm: "আপনি কি নিশ্চিত যে আপনি 2FA অক্ষম করতে চান?",
    disable_2fa_instructions: "2FA অক্ষম করতে আপনার পাসওয়ার্ড লিখুন।",
    disassociate_dir: "ডিরেক্টরি অমিল করুন",
    documents: "ডকুমেন্টস",
    dont_allow: "অনুমতি নেই",
    download: "ডাউনলোড",
    download_file: "ফাইল ডাউনলোড করুন",
    downloading: "ডাউনলোড হচ্ছে",
    email: "ই-মেইল",
    email_change_confirmation_sent: "নতুন ই-মেইল ঠিকানা নিশ্চিতকরণের জন্য একটি নিশ্চিতকরণ ইমেল পাঠানো হয়েছে। আপনার ইনবক্স পরীক্ষা করুন এবং নির্দেশানুযায়ী প্রক্রিয়াটি সম্পন্ন করুন।",
    email_invalid: "ই-মেইল অবৈধ।",
    email_or_username: "ই-মেইল বা ইউজারনেম",
    email_required: "ই-মেইল প্রয়োজন।",
    empty_trash: "খালি ট্র্যাশ",
    empty_trash_confirmation: `আপনি কি নিশ্চিত যে আপনি ট্র্যাশে আইটেমগুলি স্থায়ীভাবে মুছতে চান?`,
    emptying_trash: "ট্র্যাশ খালি করা হচ্ছে…",
    enable_2fa: "2FA চালু করুন",
    end_hard: "হার্ড শেষ",
    end_process_force_confirm: "আপনি কি নিশ্চিত যে আপনি এই প্রক্রিয়াটি ফোর্স-কুইট করতে চান?",
    end_soft: "সফট শেষ",
    enlarged_qr_code: "বড় QR কোড",
    enter_password_to_confirm_delete_user: "অ্যাকাউন্ট মুছা নিশ্চিত করতে আপনার পাসওয়ার্ড লিখুন",
    error_message_is_missing: "ত্রুটি বার্তাটি অনুপস্থিত।",
    error_unknown_cause: "অজানা কারণে একটি অজানা ত্রুটি ঘটেছে।",
    error_uploading_files: "ফাইল আপলোড করতে ব্যর্থ",
    favorites: "প্রিয়",
    feedback: "প্রতিক্রিয়া",
    feedback_c2a: "নীচের ফর্মটি ব্যবহার করে আপনার মতামত, মন্তব্য এবং বাগ রিপোর্ট প্রেরণ করুন।",
    feedback_sent_confirmation: "আমাদের সাথে যোগাযোগ করার জন্য ধন্যবাদ। আপনার একাউন্টে ই-মেইল সংযোজন থাকলে আমরা যত তাড়াতাড়ি সম্ভব প্রতিক্রিয়া জানাবো",
    fit: "ফিট",
    folder: "ফোল্ডার",
    force_quit: "জোরালোভাবে বন্ধ",
    forgot_pass_c2a: "পাসওয়ার্ড ভুলে গেছেন?",
    from: "থেকে",
    general: "সাধারণ",
    get_a_copy_of_on_puter: `পিউটার ডটকমে '%%' এর একটি অনুলিপি পান!`,
    get_copy_link: "কপি লিংক নিন",
    hide_all_windows: "সমস্ত উইন্ডো লুকান",
    home: "হোম",
    html_document: "এইচটিএমএল ডকুমেন্ট",
    hue: "হিউ",
    image: "ছবি",
    incorrect_password: "ভুল পাসওয়ার্ড",
    invite_link: "আমন্ত্রণ লিংক",
    item: "আইটেম",
    items_in_trash_cannot_be_renamed: `এই আইটেমটি নাম পরিবর্তন করা যাবে না কারণ এটি ট্র্যাশে রয়েছে। এই আইটেমটির নাম পরিবর্তন করতে, প্রথমে এটি ট্র্যাশ থেকে তুলে নিন।`,
    jpeg_image: "জেপিইজি ইমেজ",
    keep_in_taskbar: "টাস্কবারে রাখুন",
    language: "ভাষা",
    license: "লাইসেন্স",
    lightness: "উজ্জ্বলতা",
    link_copied: "লিংক কপি করা হয়েছে",
    loading: "লোড হচ্ছে",
    log_in: "লগ ইন করুন",
    log_into_another_account_anyway: "অন্য অ্যাকাউন্টে লগ ইন করুন",
    log_out: "লগ আউট",
    looks_good: "ভাল দেখা যাচ্ছে!",
    manage_sessions: "সেশন পরিচালনা করুন",
    menubar_style: "মেনুবার স্টাইল",
    menubar_style_desktop: "ডেস্কটপ মেনুবার স্টাইল",
    menubar_style_system: "সিস্টেম",
    menubar_style_window: "উইন্ডো",
    modified: "পরিবর্তিত",
    move: "চলুন",
    moving_file: "ফাইল চলার পথে %%",
    my_websites: "আমার ওয়েবসাইটগুলি",
    name: "নাম",
    name_cannot_be_empty: "নাম ফাঁকা রাখা যাবে না।",
    name_cannot_contain_double_period: "নামে অবশ্যই '..' অক্ষর হতে পারবে না।",
    name_cannot_contain_period: "নামে অবশ্যই '.' অক্ষর হতে পারবে না।",
    name_cannot_contain_slash: "নামে '/' অক্ষর ধারণ করতে পারবে না।",
    name_must_be_string: "নামটি শুধুমাত্র একটি স্ট্রিং হতে পারে।",
    name_too_long: `নাম %% অক্ষরের চেয়ে বেশি হতে পারবে না।`,
    new: "নতুন",
    new_email: "নতুন ই-মেইল",
    new_folder: "নতুন ফোল্ডার",
    new_password: "নতুন পাসওয়ার্ড",
    new_username: "নতুন ব্যবহারকারীর নাম",
    no: "না",
    no_dir_associated_with_site: "এই ঠিকানা সম্পর্কিত কোনও ডিরেক্টরি নেই।",
    no_websites_published: "আপনি এখনও কোনও ওয়েবসাইট প্রকাশ করেননি। শুরু করতে একটি ফোল্ডারে ক্লিক করুন।",
    ok: "ঠিক আছে",
    open: "খোলা",
    open_in_new_tab: "নতুন ট্যাবে খুলুন",
    open_in_new_window: "নতুন উইন্ডোয়ে খুলুন",
    open_with: "দিয়ে খোলুন",
    original_name: "মূল নাম",
    original_path: "মূল পথ",
    oss_code_and_content: "ওপেন সোর্স সফটওয়্যার এবং কন্টেন্ট",
    password: "পাসওয়ার্ড",
    password_changed: "পাসওয়ার্ড পরিবর্তন করা হয়েছে।",
    password_recovery_rate_limit: "আপনি আমাদের রেকভারি সিস্টেমে প্রতি দিনে অধিকতর পাঁচবার ব্যবহার করতে পারবেন না। দয়া করে কয়েক ঘণ্টা অপেক্ষা করুন এবং পুনরায় চেষ্টা করুন।",
    password_recovery_sent: "আপনার পাসওয়ার্ড পুনরুদ্ধারের জন্য নির্দেশানুযায়ী একটি ই-মেইল পাঠানো হয়েছে।",
    password_requirements: "পাসওয়ার্ড অবশ্যই অবশ্যই ৮ অক্ষরের হতে হবে।",
    password_reset: "পাসওয়ার্ড রিসেট করুন",
    password_reset_confirmation: "পাসওয়ার্ড সেট করতে নীচের ফর্মটি পূরণ করুন।",
    password_reset_request_expired: "আপনার পাসওয়ার্ড রিসেট রিকোয়েস্টের মেয়াদ শেষ হয়ে গেছে। দয়া করে পুনরায় চেষ্টা করুন।",
    password_reset_sent:  "পাসওয়ার্ড রিসেট রিকোয়েস্ট সফলভাবে প্রেরিত হয়েছে। আপনার ইনবক্স দেখুন এবং নির্দেশানুযায়ী প্রক্রিয়াটি সম্পন্ন করুন।",
    password_update_success: "পাসওয়ার্ড সফলভাবে আপডেট হয়েছে!",
    passwords_do_not_match: "পাসওয়ার্ড মিল নেই",
    paste: "পেস্ট",
    paste_into_folder: "ফোল্ডারে পেস্ট করুন",
    path: "পথ",
    personalization: "ব্যক্তিগতীকরণ",
    pick_name_for_website: "আপনার ওয়েবসাইটের জন্য নাম নির্বাচন করুন:",
    picture: "ছবি",
    pictures: "চিত্র",
    plural_suffix: "গুলি",
    powered_by_puter_js: `{{link=docs}}Puter.js{{/link}} দ্বারা প্রচালিত`,
    preparing: "প্রস্তুতি চলছে...",
    preparing_for_upload: "আপলোডের জন্য প্রস্তুতি চলছে...",
    print: "প্রিন্ট",
    privacy: "গোপনীয়তা",
    proceed_to_login: "লগইনে অগ্রসর হোন",
    proceed_with_account_deletion: "অ্যাকাউন্ট মোছার জন্য অগ্রসর হন",
    process_status_initializing: "প্রাথমিককরণ হচ্ছে",
    process_status_running: "চলছে",
    process_type_app: "অ্যাপ",
    process_type_init: "প্রাথমিকতা",
    process_type_ui: "ইউআই",
    properties: "বৈশিষ্ট্য",
    public: "পাবলিক",
    publish: "প্রকাশ করুন",
    publish_as_website: "ওয়েবসাইট হিসাবে প্রকাশ করুন",
    puter_description: `Puter হল একটি গোপনীয়তা-প্রথম ব্যক্তিগত ক্লাউড, যেখানে আপনার সমস্ত ফাইল, অ্যাপ্লিকেশন এবং গেম একটি নিরাপদ জায়গায় রাখা হয়, যেখান থেকে যে কোনো সময় অ্যাক্সেস করা যায়।`,
    reading_file: "%strong% পড়া হচ্ছে",
    recent: "সাম্প্রতিক",
    recommended: "অনুমোদিত",
    recover_password: "পাসওয়ার্ড পুনরুদ্ধার করুন",
    refer_friends_c2a:  "Puter তে অ্যাকাউন্ট তৈরি এবং নিশ্চিতকরণ করে ১ জিবি পান। আপনার বন্ধুও ১ জিবি পাবে!",
    refer_friends_social_media_c2a: `Puter.com এ 1 GB বিনামূল্যের সংরক্ষণ পান!`,
    refresh: "রিফ্রেশ",
    release_address_confirmation: `আপনি কি নিশ্চিত যে আপনি এই ঠিকানা রিলিজ করতে চান?`,
    remove_from_taskbar: "টাস্কবার থেকে সরান",
    rename: "পুনঃনামকরণ",
    repeat: "পুনরাবৃত্তি",
    replace: "বদলান",
    replace_all: "সকল কিছু বদলান",
    resend_confirmation_code: "পুনরায় নিশ্চিতকরণ কোড প্রেরণ করুন",
    reset_colors: "রঙ পুনঃনির্ধারণ করুন",
    restart_puter_confirm: "আপনি কি নিশ্চিত যে Puter পুনরায় চালু করতে চান?",
    restore: "পুনরুদ্ধার",
    save: "সংরক্ষণ করুন",
    saturation: "সম্পৃক্তি",
    save_account: "অ্যাকাউন্ট সংরক্ষণ করুন",
    save_account_to_get_copy_link: "অগ্রসর হতে অ্যাকাউন্ট তৈরি করুন।",
    save_account_to_publish: "অগ্রসর হতে অ্যাকাউন্ট তৈরি করুন।",
    save_session: "সেশন সংরক্ষণ করুন",
    save_session_c2a: "আপনার বর্তমান সেশনটি সংরক্ষণ করতে একটি অ্যাকাউন্ট তৈরি করুন যাতে আপনার কাজ হারাতে না হয়।",
    scan_qr_c2a: "অন্যান্য ডিভাইস থেকে এই সেশনে লগইন করতে নীচের কোডটি স্ক্যান করুন",
    scan_qr_2fa: "আপনার প্রামাণিকতা অ্যাপ্লিকেশন দিয়ে QR কোডটি স্ক্যান করুন",
    scan_qr_generic: "আপনার ফোন বা অন্য ডিভাইস ব্যবহার করে এই QR কোড স্ক্যান করুন",
    search: "অনুসন্ধান",
    seconds: "সেকেন্ড",
    security: "নিরাপত্তা",
    select: "নির্বাচন করুন",
    selected: "নির্বাচিত",
    select_color: "রঙ নির্বাচন করুন…",
    sessions: "সেশনগুলি",
    send: "প্রেরণ করুন",
    send_password_recovery_email: "পাসওয়ার্ড পুনরুদ্ধারের ইমেল প্রেরণ করুন",
    session_saved: "অ্যাকাউন্ট তৈরি করার জন্য ধন্যবাদ। এই সেশনটি সংরক্ষিত হয়েছে।",
    settings: "সেটিংস",
    set_new_password: "নতুন পাসওয়ার্ড সেট করুন",
    share: "শেয়ার করুন",
    share_to: "শেয়ার করুন প্রতি",
    share_with: "সঙ্গে ভাগাভাগি করুন:",
    shortcut_to: "শর্টকাট",
    show_all_windows: "সমস্ত উইন্ডো দেখান",
    show_hidden: "লুকানো দেখান",
    sign_in_with_puter: "Puter দিয়ে সাইন ইন করুন",
    sign_up: "নিবন্ধন করুন",
    signing_in: "সাইন ইন হচ্ছে...",
    size: "আকার",
    skip: "এড়িয়ে যান",
    something_went_wrong: "কিছু সমস্যা হয়েছে।",
    sort_by: "অনুযায়ী সাজান",
    start: "শুরু",
    status: "অবস্থা",
    storage_usage: "স্টোরেজ ব্যবহার",
    storage_puter_used: "Puter দ্বারা ব্যবহৃত",
    taking_longer_than_usual: "স্বাভাবিক চেয়ে বেশি সময় নিচ্ছে। অনুগ্রহ করে অপেক্ষা করুন...",
    task_manager: "টাস্ক ম্যানেজার",
    taskmgr_header_name: "নাম",
    taskmgr_header_status: "অবস্থা",
    taskmgr_header_type: "ধরণ",
    terms: "শর্তাবলী",
    text_document: "পাঠ্য নথি",
    tos_fineprint: `‘ফ্রি অ্যাকাউন্ট তৈরি করুন’ ক্লিক করে আপনি Puter-এর {{link=terms}}সেবা শর্ত{{/link}} এবং {{link=privacy}}গোপনীয়তা নীতি{{/link}} এর সাথে সম্মত হন।`,
    transparency: "স্বচ্ছতা",
    trash: "আবর্জনা",
    two_factor: "দুটি ফ্যাক্টর প্রমাণীকরণ",
    two_factor_disabled: "2FA অক্ষম",
    two_factor_enabled: "2FA সক্ষম",
    type: "ধরণ",
    type_confirm_to_delete_account: "অ্যাকাউন্ট মোছার জন্য 'অনুমোদন' টাইপ করুন।",
    ui_colors: "ইউআই রঙ",
    ui_manage_sessions: "সেশন ম্যানেজার",
    ui_revoke: "প্রত্যাহার করুন",
    undo: "পূর্বাবস্থায় ফেরত যান",
    unlimited: "অসীম",
    unzip: "আনজিপ করুন",
    upload: "আপলোড করুন",
    upload_here: "এখানে আপলোড করুন",
    usage: "ব্যবহার",
    username: "ব্যবহারকারীর নাম",
    username_changed: "ব্যবহারকারীর নাম সফলভাবে আপডেট হয়েছে।",
    username_required: "ব্যবহারকারীর নাম প্রয়োজন।",
    versions: "সংস্করণ",
    videos: "ভিডিও",
    visibility: "দৃশ্যমানতা",
    yes: "হ্যাঁ",
    yes_release_it: "হ্যাঁ, এটি রিলিজ করুন",
    you_have_been_referred_to_puter_by_a_friend: "আপনাকে একটি বন্ধুর মাধ্যমে পিউটার-এ রেফার করা হয়েছে",
    zip: "জিপ",
    zipping_file: "%strong% জিপিং হচ্ছে",

    // === 2FA Setup ===
    setup2fa_1_step_heading: "আপনার প্রামাণিকতা অ্যাপ খুলুন",
    setup2fa_1_instructions: `
    আপনি যেকোনো প্রামাণিকতা অ্যাপ ব্যবহার করতে পারেন যা Time-based One-Time Password (TOTP) প্রোটোকল সমর্থন করে।
    অনেক বিকল্প রয়েছে, তবে যদি আপনি নিশ্চিত না হন
    <a target="_blank" href="https://authy.com/download">Authy</a>
    একটি ভালো পছন্দ Android এবং iOS এর জন্য।
  `,
    setup2fa_2_step_heading: "QR কোড স্ক্যান করুন",
    setup2fa_3_step_heading: "৬-টি অংকের কোড লিখুন",
    setup2fa_4_step_heading: "আপনার পুনরুদ্ধার কোড কপি করুন",
    setup2fa_4_instructions: `
    এই পুনরুদ্ধার কোডগুলি আপনার অ্যাকাউন্টে অ্যাক্সেস পাওয়ার একমাত্র উপায় যদি আপনি আপনার ফোন হারান বা আপনার প্রামাণিকতা অ্যাপ ব্যবহার করতে না পারেন।
    নিশ্চিত করুন যে আপনি তাদের একটি নিরাপদ জায়গায় সংরক্ষণ করেছেন।
  `,
    setup2fa_5_step_heading: "2FA সেটআপ নিশ্চিত করুন",
    setup2fa_5_confirmation_1: "আমি আমার পুনরুদ্ধার কোডগুলি একটি নিরাপদ অবস্থানে সংরক্ষণ করেছি",
    setup2fa_5_confirmation_2: "আমি 2FA সক্ষম করার জন্য প্রস্তুত",
    setup2fa_5_button: "2FA সক্ষম করুন",

    // === 2FA Login ===
    login2fa_otp_title: "2FA কোড লিখুন",
    login2fa_otp_instructions: "আপনার প্রামাণিকতা অ্যাপ থেকে ৬-টি অংকের কোড লিখুন।",
    login2fa_recovery_title: "একটি পুনরুদ্ধার কোড লিখুন",
    login2fa_recovery_instructions: "আপনার অ্যাকাউন্টে অ্যাক্সেস পাওয়ার জন্য আপনার পুনরুদ্ধার কোডগুলির মধ্য থেকে একটি লিখুন।",
    login2fa_use_recovery_code: "একটি পুনরুদ্ধার কোড ব্যবহার করুন",
    login2fa_recovery_back: "পিছনে",
    login2fa_recovery_placeholder: "XXXXXXXX",

    "change": "পরিবর্তন করুন", 
    "clock_visibility": "ঘড়ির দৃশ্যমানতা", 
    "password_recovery_token_invalid": "এই পাসওয়ার্ড পুনরুদ্ধার টোকেনটি আর সঠিক নয়।", 
    "password_recovery_unknown_error": "একটি অজানা ত্রুটি ঘটেছে। অনুগ্রহ করে পরে আবার চেষ্টা করুন।", 
    "password_required": "পাসওয়ার্ড প্রয়োজন।", 
    "password_strength_error": "পাসওয়ার্ড কমপক্ষে ৮ সংখার হতে হবে এবং এতে অন্তত একটি বড় হাতের অক্ষর, একটি ছোট হাতের অক্ষর, একটি সংখ্যা, এবং একটি বিশেষ অক্ষর থাকতে হবে।", 
    "reading": "পড়া হচ্ছে", 
    "writing": "লেখা হচ্ছে", 
    "unzipping": "আনজিপ করা হচ্ছে", 
    "sequencing": "ক্রমানুসারে সাজানো হচ্ছে", 
    "zipping": "জিপ করা হচ্ছে", 
    "Editor": "সম্পাদক", 
    "Viewer": "দর্শক", 
    "People with access": "যাদের অ্যাক্সেস আছে", 
    "Share With…": "শেয়ার করুন…", 
    "Owner": "মালিক", 
    "You can't share with yourself.": "নিজের সাথে শেয়ার করতে পারবেন না।", 
    "This user already has access to this item": "এই ব্যবহারকারীর ইতিমধ্যে এটাতে অ্যাক্সেস রয়েছে।",

    "billing.change_payment_method": "পরিশোধ পদ্ধতি পরিবর্তন করুন",
    "billing.cancel": "বাতিল করুন",
    "billing.download_invoice": "চালান ডাউনলোড করুন",
    "billing.payment_method": "পরিশোধ পদ্ধতি",
    "billing.payment_method_updated": "পরিশোধ পদ্ধতি আপডেট হয়েছে!",
    "billing.confirm_payment_method": "পরিশোধ পদ্ধতি নিশ্চিত করুন",
    "billing.payment_history": "পরিশোধ ইতিহাস",
    "billing.refunded": "ফেরত দেওয়া হয়েছে",
    "billing.paid": "পরিশোধিত",
    "billing.ok": "ঠিক আছে",
    "billing.resume_subscription": "সাবস্ক্রিপশন পুনরায় চালু করুন",
    "billing.subscription_cancelled": "আপনার সাবস্ক্রিপশন বাতিল করা হয়েছে।",
    "billing.subscription_cancelled_description": "এই বিলিং পিরিয়ডের শেষ পর্যন্ত আপনি আপনার সাবস্ক্রিপশনটি ব্যবহার করতে পারবেন।",
    "billing.offering.free": "বিনামূল্য",
    "billing.offering.pro": "প্রফেশনাল",
    "billing.offering.business": "ব্যবসায়িক",
    "billing.cloud_storage": "ক্লাউড স্টোরেজ",
    "billing.ai_access": "এআই অ্যাক্সেস",
    "billing.bandwidth": "ব্যান্ডউইথ",
    "billing.apps_and_games": "অ্যাপস এবং গেমস",
    "billing.upgrade_to_pro": "%strong%-এ আপগ্রেড করুন",
    "billing.switch_to": "%strong%-এ পরিবর্তন করুন",
    "billing.payment_setup": "পরিশোধ সেটআপ",
    "billing.back": "পেছনে যান",
    "billing.you_are_now_subscribed_to": "আপনি এখন %strong% স্তরের সাবস্ক্রাইবার।",
    "billing.you_are_now_subscribed_to_without_tier": "আপনি এখন সাবস্ক্রাইবার।",
    "billing.subscription_cancellation_confirmation": "আপনি কি নিশ্চিত যে আপনি আপনার সাবস্ক্রিপশন বাতিল করতে চান?",
    "billing.subscription_setup": "সাবস্ক্রিপশন সেটআপ",
    "billing.cancel_it": "বাতিল করুন",
    "billing.keep_it": "রাখুন",
    "billing.subscription_resumed": "আপনার %strong% সাবস্ক্রিপশন পুনরায় চালু করা হয়েছে!",
    "billing.upgrade_now": "এখনই আপগ্রেড করুন",
    "billing.upgrade": "আপগ্রেড করুন",
    "billing.currently_on_free_plan": "আপনি বর্তমানে ফ্রি প্ল্যানে আছেন।",
    "billing.download_receipt": "রসিদ ডাউনলোড করুন",
    "billing.subscription_check_error": "আপনার সাবস্ক্রিপশন স্ট্যাটাস চেক করার সময় একটি সমস্যা দেখা দিয়েছে।",
    "billing.email_confirmation_needed": "আপনার ইমেল নিশ্চিত করা হয়নি। আমরা এখনই এটি নিশ্চিত করার জন্য একটি কোড পাঠাব।",
    "billing.sub_cancelled_but_valid_until": "আপনি আপনার সাবস্ক্রিপশন বাতিল করেছেন এবং এটি বিলিং পিরিয়ডের শেষে স্বয়ংক্রিয়ভাবে ফ্রি স্তরে পরিবর্তিত হবে। আপনি পুনরায় সাবস্ক্রাইব না করা পর্যন্ত আর চার্জ হবে না।",
    "billing.current_plan_until_end_of_period": "এই বিলিং পিরিয়ডের শেষ পর্যন্ত আপনার বর্তমান প্ল্যান।",
    "billing.current_plan": "বর্তমান প্ল্যান",
    "billing.cancelled_subscription_tier": "বাতিল করা সাবস্ক্রিপশন (%%)",
    "billing.manage": "পরিচালনা করুন",
    "billing.limited": "সীমিত",
    "billing.expanded": "বিস্তৃত",
    "billing.accelerated": "ত্বরান্বিত",
    "billing.enjoy_msg": "%% ক্লাউড স্টোরেজ এবং অন্যান্য সুবিধা উপভোগ করুন।"
  },
};

export default bn;
