/*
 * Copyright (C) 2024-present Puter Technologies Inc.
 * 
 * This file is part of Puter.
 * 
 * Puter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */


const ar = {
  name: "العربية",
  english_name: "Arabic",
  code: "ar",
  dictionary: {
      about: "حول",
      account: "حساب",
      account_password: "تحقق من كلمة مرور الحساب",
      access_granted_to: "تم منح الوصول إلى",
      add_existing_account: "إضافة حساب موجود",
      all_fields_required: "جميع الحقول مطلوبة.",
      allow: "السماح",
      apply: "تطبيق",
      ascending: "تصاعدي",
      associated_websites: "المواقع المرتبطة",
      auto_arrange: "ترتيب تلقائي",
      background: "خلفية",
      browse: "تصفح",
      cancel: "إلغاء",
      center: "مركز",
      change_desktop_background: "تغيير خلفية سطح المكتب...",
      change_email: "تغيير البريد الإلكتروني",
      change_language: "تغيير اللغة",
      change_password: "تغيير كلمة المرور",
      change_ui_colors: "تغيير ألوان واجهة المستخدم",
      change_username: "تغيير اسم المستخدم",
      close: "إغلاق",
      close_all_windows: "إغلاق جميع النوافذ",
      close_all_windows_confirm: "هل أنت متأكد أنك تريد إغلاق جميع النوافذ؟",
      close_all_windows_and_log_out: "إغلاق النوافذ وتسجيل الخروج",
      change_always_open_with: "هل تريد دائمًا فتح هذا النوع من الملفات باستخدام",
      color: "لون",
      confirm: "تأكيد",
      confirm_2fa_setup: "لقد أضفت الرمز إلى تطبيق المصادقة",
      confirm_2fa_recovery: "لقد حفظت رموز الاسترداد في مكان آمن",
      confirm_account_for_free_referral_storage_c2a:
          "أنشئ حسابًا وقم بتأكيد عنوان بريدك الإلكتروني للحصول على 1 جيجابايت من مساحة التخزين المجانية. سيحصل صديقك أيضًا على 1 جيجابايت من مساحة التخزين المجانية.",
      confirm_code_generic_incorrect: "رمز غير صحيح.",
      confirm_code_generic_too_many_requests:
          "طلبات كثيرة جدًا. يرجى الانتظار بضع دقائق.",
      confirm_code_generic_submit: "إرسال الرمز",
      confirm_code_generic_try_again: "حاول مرة أخرى",
      confirm_code_generic_title: "أدخل رمز التأكيد",
      confirm_code_2fa_instruction:
          "أدخل الرمز المكون من 6 أرقام من تطبيق المصادقة الخاص بك.",
      confirm_code_2fa_submit_btn: "إرسال",
      confirm_code_2fa_title: "أدخل رمز المصادقة الثنائية",
      confirm_delete_multiple_items:
          "هل أنت متأكد أنك تريد حذف هذه العناصر نهائيًا؟",
      confirm_delete_single_item: "هل تريد حذف هذا العنصر نهائيًا؟",
      confirm_open_apps_log_out:
          "لديك تطبيقات مفتوحة. هل أنت متأكد أنك تريد تسجيل الخروج؟",
      confirm_new_password: "تأكيد كلمة المرور الجديدة",
      confirm_delete_user:
          "هل أنت متأكد أنك تريد حذف حسابك؟ سيتم حذف جميع ملفاتك وبياناتك نهائيًا. لا يمكن التراجع عن هذا الإجراء.",
      confirm_delete_user_title: "حذف الحساب؟",
      confirm_session_revoke: "هل أنت متأكد أنك تريد إلغاء هذه الجلسة؟",
      confirm_your_email_address: "تأكيد عنوان بريدك الإلكتروني",
      contact_us: "اتصل بنا",
      contact_us_verification_required:
          "يجب أن يكون لديك عنوان بريد إلكتروني مُؤكد لاستخدام هذه الخدمة.",
      contain: "احتواء",
      continue: "استمر",
      copy: "نسخ",
      copy_link: "نسخ الرابط",
      copying: "جارٍ النسخ",
      copying_file: "جارٍ نسخ %%",
      cover: "تغطية",
      create_account: "إنشاء حساب",
      create_free_account: "إنشاء حساب مجاني",
      create_shortcut: "إنشاء اختصار",
      credits: "الاعتمادات",
      current_password: "كلمة المرور الحالية",
      cut: "قص",
      clock: "ساعة",
      clock_visible_hide: "إخفاء - مخفية دائمًا",
      clock_visible_show: "إظهار - مرئية دائمًا",
      clock_visible_auto: "تلقائي - الافتراضي، مرئي فقط في وضع الشاشة الكاملة.",
      close_all: "إغلاق الكل",
      created: "تم الإنشاء",
      date_modified: "تاريخ التعديل",
      default: "افتراضي",
      delete: "حذف",
      delete_account: "حذف الحساب",
      delete_permanently: "حذف نهائي",
      deleting_file: "جارٍ حذف %%",
      deploy_as_app: "نشر كتطبيق",
      descending: "تنازلي",
      desktop: "سطح المكتب",
      desktop_background_fit: "ملائمة",
      developers: "المطورين",
      dir_published_as_website: "%strong% تم نشره إلى:",
      disable_2fa: "تعطيل المصادقة الثنائية",
      disable_2fa_confirm: "هل أنت متأكد أنك تريد تعطيل المصادقة الثنائية؟",
      disable_2fa_instructions: "أدخل كلمة المرور لتعطيل المصادقة الثنائية.",
      disassociate_dir: "فصل الدليل",
      documents: "المستندات",
      dont_allow: "عدم السماح",
      download: "تنزيل",
      download_file: "تنزيل الملف",
      downloading: "جارٍ التنزيل",
      email: "البريد الإلكتروني",
      email_change_confirmation_sent:
          "تم إرسال بريد تأكيد إلى عنوان بريدك الإلكتروني الجديد. يرجى التحقق من صندوق الوارد واتباع التعليمات لإكمال العملية.",
      email_invalid: "البريد الإلكتروني غير صالح.",
      email_or_username: "البريد الإلكتروني أو اسم المستخدم",
      email_required: "البريد الإلكتروني مطلوب.",
      empty_trash: "إفراغ سلة المهملات",
      empty_trash_confirmation:
          "هل أنت متأكد أنك تريد حذف العناصر في سلة المهملات نهائيًا؟",
      emptying_trash: "جارٍ إفراغ سلة المهملات...",
      enable_2fa: "تمكين المصادقة الثنائية",
      end_hard: "إنهاء صعب",
      end_process_force_confirm:
          "هل أنت متأكد أنك تريد إنهاء هذه العملية بالقوة؟",
      end_soft: "إنهاء سلس",
      enlarged_qr_code: "رمز QR مكبر",
      enter_password_to_confirm_delete_user: "أدخل كلمة المرور لتأكيد حذف الحساب",
      error_message_is_missing: "رسالة الخطأ مفقودة.",
      error_unknown_cause: "حدث خطأ غير معروف.",
      error_uploading_files: "فشل في تحميل الملفات",
      favorites: "المفضلة",
      feedback: "ملاحظات",
      feedback_c2a:
          "يرجى استخدام النموذج أدناه لإرسال ملاحظاتك وتعليقاتك وتقرير الأخطاء.",
      feedback_sent_confirmation:
          "شكرًا لتواصلك معنا. إذا كان لديك بريد إلكتروني مرتبط بحسابك، ستتلقى ردًا منا في أقرب وقت ممكن.",
      fit: "ملائمة",
      folder: "مجلد",
      force_quit: "إنهاء بالقوة",
      forgot_pass_c2a: "هل نسيت كلمة المرور؟",
      from: "من",
      general: "عام",
      get_a_copy_of_on_puter: "احصل على نسخة من '%%' على Puter.com!",
      get_copy_link: "احصل على رابط النسخ",
      hide_all_windows: "إخفاء جميع النوافذ",
      home: "الصفحة الرئيسية",
      html_document: "مستند HTML",
      hue: "درجة اللون",
      image: "صورة",
      incorrect_password: "كلمة مرور غير صحيحة",
      invite_link: "رابط الدعوة",
      item: "عنصر",
      items_in_trash_cannot_be_renamed:
          "لا يمكن إعادة تسمية هذا العنصر لأنه في سلة المهملات. لإعادة تسمية هذا العنصر، اسحبه أولاً خارج سلة المهملات.",
      jpeg_image: "صورة JPEG",
      keep_in_taskbar: "الاحتفاظ في شريط المهام",
      language: "اللغة",
      license: "رخصة",
      lightness: "إضاءة",
      link_copied: "تم نسخ الرابط",
      loading: "جارٍ التحميل",
      log_in: "تسجيل الدخول",
      log_into_another_account_anyway: "تسجيل الدخول إلى حساب آخر على أي حال",
      log_out: "تسجيل الخروج",
      looks_good: "يبدو جيدًا!",
      manage_sessions: "إدارة الجلسات",
      menubar_style: "نمط شريط القوائم",
      menubar_style_desktop: "سطح المكتب",
      menubar_style_system: "النظام",
      menubar_style_window: "النافذة",
      modified: "تم التعديل",
      move: "نقل",
      moving_file: "جارٍ نقل %%",
      my_websites: "مواقعي الإلكترونية",
      name: "اسم",
      name_cannot_be_empty: "الاسم لا يمكن أن يكون فارغًا.",
      name_cannot_contain_double_period: "الاسم لا يمكن أن يكون '..'.",
      name_cannot_contain_period: "الاسم لا يمكن أن يكون '.'.",
      name_cannot_contain_slash: "الاسم لا يمكن أن يحتوي على '/'.",
      name_must_be_string: "الاسم يجب أن يكون نصًا فقط.",
      name_too_long: "الاسم لا يمكن أن يكون أطول من %% حرف.",
      new: "جديد",
      new_email: "البريد الإلكتروني الجديد",
      new_folder: "مجلد جديد",
      new_password: "كلمة المرور الجديدة",
      new_username: "اسم المستخدم الجديد",
      no: "لا",
      no_dir_associated_with_site: "لا يوجد دليل مرتبط بهذا العنوان.",
      no_websites_published: "لم تنشر أي مواقع إلكترونية بعد.",
      ok: "موافق",
      open: "فتح",
      open_in_new_tab: "فتح في علامة تبويب جديدة",
      open_in_new_window: "فتح في نافذة جديدة",
      open_with: "فتح باستخدام",
      original_name: "الاسم الأصلي",
      original_path: "المسار الأصلي",
      oss_code_and_content: "برامج ومحتوى مفتوح المصدر",
      password: "كلمة المرور",
      password_changed: "تم تغيير كلمة المرور.",
      password_recovery_rate_limit:
          "لقد وصلت إلى الحد الأقصى؛ يرجى الانتظار بضع دقائق. لمنع حدوث ذلك في المستقبل، تجنب إعادة تحميل الصفحة كثيرًا.",
      password_recovery_token_invalid: "رمز استعادة كلمة المرور لم يعد صالحًا.",
      password_recovery_unknown_error:
          "حدث خطأ غير معروف. يرجى المحاولة مرة أخرى لاحقًا.",
      password_required: "كلمة المرور مطلوبة.",
      password_strength_error:
          "يجب أن تكون كلمة المرور بطول 8 أحرف على الأقل وتحتوي على حرف كبير واحد، حرف صغير واحد، رقم واحد، وحرف خاص واحد على الأقل.",
      passwords_do_not_match:
          "`كلمة المرور الجديدة` و`تأكيد كلمة المرور الجديدة` غير متطابقتين.",
      paste: "لصق",
      paste_into_folder: "لصق في المجلد",
      path: "المسار",
      personalization: "تخصيص",
      pick_name_for_website: "اختر اسمًا لموقعك الإلكتروني:",
      picture: "صورة",
      pictures: "الصور",
      plural_suffix: "s",
      powered_by_puter_js: "مدعوم بواسطة {{link=docs}}Puter.js{{/link}}",
      preparing: "جارٍ التحضير...",
      preparing_for_upload: "جارٍ التحضير للتحميل...",
      print: "طباعة",
      privacy: "الخصوصية",
      proceed_to_login: "المتابعة لتسجيل الدخول",
      proceed_with_account_deletion: "المتابعة مع حذف الحساب",
      process_status_initializing: "جارٍ التهيئة",
      process_status_running: "جارٍ التشغيل",
      process_type_app: "تطبيق",
      process_type_init: "تهيئة",
      process_type_ui: "واجهة المستخدم",
      properties: "الخصائص",
      public: "عام",
      publish: "نشر",
      publish_as_website: "نشر كموقع إلكتروني",
      puter_description:
          "Puter هو سحابة شخصية تركز على الخصوصية للحفاظ على جميع ملفاتك، تطبيقاتك، وألعابك في مكان آمن واحد، متاحة من أي مكان وفي أي وقت.",
      reading_file: "جارٍ قراءة %strong%",
      recent: "الأخيرة",
      recommended: "مُوصى به",
      recover_password: "استعادة كلمة المرور",
      refer_friends_c2a:
          "احصل على 1 جيجابايت عن كل صديق ينشئ حسابًا ويؤكده على Puter. سيحصل صديقك على 1 جيجابايت أيضًا!",
      refer_friends_social_media_c2a:
          "احصل على 1 جيجابايت من التخزين المجاني على Puter.com!",
      refresh: "تحديث",
      release_address_confirmation: "هل أنت متأكد أنك تريد تحرير هذا العنوان؟",
      remove_from_taskbar: "إزالة من شريط المهام",
      rename: "إعادة تسمية",
      repeat: "تكرار",
      replace: "استبدال",
      replace_all: "استبدال الكل",
      resend_confirmation_code: "إعادة إرسال رمز التأكيد",
      reset_colors: "إعادة ضبط الألوان",
      restart_puter_confirm: "هل أنت متأكد أنك تريد إعادة تشغيل Puter؟",
      restore: "استعادة",
      save: "حفظ",
      saturation: "تشبع",
      save_account: "حفظ الحساب",
      save_account_to_get_copy_link: "يرجى إنشاء حساب للمتابعة.",
      save_account_to_publish: "يرجى إنشاء حساب للمتابعة.",
      save_session: "حفظ الجلسة",
      save_session_c2a: "أنشئ حسابًا لحفظ جلستك الحالية وتجنب فقدان عملك.",
      scan_qr_c2a: "امسح الرمز أدناه لتسجيل الدخول إلى هذه الجلسة من أجهزة أخرى",
      scan_qr_2fa: "امسح رمز الاستجابة السريعة باستخدام تطبيق المصادقة الخاص بك",
      scan_qr_generic:
          "امسح رمز الاستجابة السريعة هذا باستخدام هاتفك أو جهاز آخر",
      search: "بحث",
      seconds: "ثوانٍ",
      security: "الأمان",
      select: "تحديد",
      selected: "محدد",
      select_color: "اختر لونًا…",
      sessions: "جلسات",
      send: "إرسال",
      send_password_recovery_email: "إرسال بريد استعادة كلمة المرور",
      session_saved: "شكرًا لإنشاء حساب. تم حفظ هذه الجلسة.",
      settings: "الإعدادات",
      set_new_password: "تعيين كلمة مرور جديدة",
      share: "مشاركة",
      share_to: "مشاركة إلى",
      share_with: "مشاركة مع:",
      shortcut_to: "اختصار إلى",
      show_all_windows: "عرض جميع النوافذ",
      show_hidden: "إظهار المخفي",
      sign_in_with_puter: "تسجيل الدخول باستخدام Puter",
      sign_up: "تسجيل",
      signing_in: "جارٍ تسجيل الدخول…",
      size: "الحجم",
      skip: "تخطي",
      something_went_wrong: "حدث خطأ ما.",
      sort_by: "فرز حسب",
      start: "بدء",
      status: "الحالة",
      storage_usage: "استخدام التخزين",
      storage_puter_used: "مستخدم بواسطة Puter",
      taking_longer_than_usual: "يستغرق وقتًا أطول من المعتاد. يرجى الانتظار...",
      task_manager: "مدير المهام",
      taskmgr_header_name: "الاسم",
      taskmgr_header_status: "الحالة",
      taskmgr_header_type: "النوع",
      terms: "الشروط",
      text_document: "مستند نصي",
      tos_fineprint:
          "بالنقر على 'إنشاء حساب مجاني' فإنك توافق على {{link=terms}}شروط الخدمة{{/link}} و{{link=privacy}}سياسة الخصوصية{{/link}} لـPuter.",
      transparency: "الشفافية",
      trash: "المهملات",
      two_factor: "المصادقة الثنائية",
      two_factor_disabled: "تم تعطيل المصادقة الثنائية",
      two_factor_enabled: "تم تمكين المصادقة الثنائية",
      type: "نوع",
      type_confirm_to_delete_account: "اكتب 'تأكيد' لحذف حسابك.",
      ui_colors: "ألوان واجهة المستخدم",
      ui_manage_sessions: "مدير الجلسات",
      ui_revoke: "إلغاء",
      undo: "تراجع",
      unlimited: "غير محدود",
      unzip: "فك الضغط",
      upload: "رفع",
      upload_here: "ارفع هنا",
      usage: "الاستخدام",
      username: "اسم المستخدم",
      username_changed: "تم تحديث اسم المستخدم بنجاح.",
      username_required: "اسم المستخدم مطلوب.",
      versions: "الإصدارات",
      videos: "مقاطع الفيديو",
      visibility: "الرؤية",
      yes: "نعم",
      yes_release_it: "نعم، أطلقه",
      you_have_been_referred_to_puter_by_a_friend:
          "تم إحالتك إلى Puter بواسطة صديق!",
      zip: "ضغط",
      zipping_file: "جارٍ ضغط %strong%",

      // === 2FA Setup ===
      setup2fa_1_step_heading: "افتح تطبيق المصادقة الخاص بك",
      setup2fa_1_instructions: `
        يمكنك استخدام أي تطبيق مصادقة يدعم بروتوكول كلمة المرور لمرة واحدة المعتمدة على الوقت (TOTP).
        هناك العديد للاختيار من بينها، ولكن إذا كنت غير متأكد
        <a target="_blank" href="https://authy.com/download">Authy</a>
        هو خيار موثوق به لنظام Android و iOS.
    `,
      setup2fa_2_step_heading: "مسح رمز الاستجابة السريعة (QR code)",
      setup2fa_3_step_heading: "أدخل الرمز المكون من 6 أرقام",
      setup2fa_4_step_heading: "انسخ رموز الاسترداد الخاصة بك",
      setup2fa_4_instructions: `
        هذه رموز الاسترداد هي الطريقة الوحيدة للوصول إلى حسابك إذا فقدت هاتفك أو لم تتمكن من استخدام تطبيق المصادقة الخاص بك.
        تأكد من حفظها في مكان آمن.
    `,
      setup2fa_5_step_heading: "تأكيد إعداد المصادقة الثنائية (2FA)",
      setup2fa_5_confirmation_1: "لقد قمت بحفظ رموز الاسترداد في مكان آمن",
      setup2fa_5_confirmation_2: "أنا جاهز لتمكين المصادقة الثنائية (2FA)",
      setup2fa_5_button: "تمكين المصادقة الثنائية (2FA)",

      // === 2FA Login ===
      login2fa_otp_title: "أدخل رمز المصادقة الثنائية (2FA)",
      login2fa_otp_instructions:
          "أدخل الرمز المكون من 6 أرقام من تطبيق المصادقة الخاص بك.",
      login2fa_recovery_title: "أدخل رمز الاسترداد",
      login2fa_recovery_instructions:
          "أدخل أحد رموز الاسترداد الخاصة بك للوصول إلى حسابك.",
      login2fa_use_recovery_code: "استخدام رمز الاسترداد",
      login2fa_recovery_back: "الرجوع",
      login2fa_recovery_placeholder: "XXXXXXXX",

    change: "تغيير", // In English: "Change"
    clock_visibility: "ظهور الساعة", // In English: "Clock Visibility"
    reading: "قراءة %strong%", // In English: "Reading %strong%"
    writing: "كتابة %strong%", // In English: "Writing %strong%"
    unzipping: "فك الضغط %strong%", // In English: "Unzipping %strong%"
    sequencing: "ترتيب %strong%", // In English: "Sequencing %strong%"
    zipping: "ضغط %strong%", // In English: "Zipping %strong%"
    Editor: "المحرر", // In English: "Editor"
    Viewer: "المشاهد", // In English: "Viewer"
    "People with access": "الأشخاص الذين لديهم تحكم", // In English: "People with access"
    "Share With…": "مشاركة مع...", // In English: "Share With…"
    Owner: "المالك", // In English: "Owner"
    "You can't share with yourself.": "لا يمكنك المشاركة مع نفسك.", // In English: "You can't share with yourself."
    "This user already has access to this item": "هذا المستخدم لديه بالفعل تحكم إلى هذا العنصر", // In English: "This user already has access to this item"
    
    "billing.change_payment_method": "تغيير طريقة الدفع", // In English: "Change"
    "billing.cancel": "إلغاء", // In English: "Cancel"
    "billing.download_invoice": "تحميل", // In English: "Download"
    "billing.payment_method": "طريقة الدفع", // In English: "Payment Method"
    "billing.payment_method_updated": "تم تحديث طريقة الدفع", // In English: "Payment method updated!"
    "billing.confirm_payment_method": "تأكيد طريقة الدفع", // In English: "Confirm Payment Method"
    "billing.payment_history": "سجل الدفع", // In English: "Payment History"
    "billing.refunded": "تم الاسترداد", // In English: "Refunded"
    "billing.paid": "مدفوع", // In English: "Paid"
    "billing.ok": "موافق", // In English: "OK"
    "billing.resume_subscription": "استئناف الاشتراك", // In English: "Resume Subscription"
    "billing.subscription_cancelled": "تم إلغاء اشتراكك", // In English: "Your subscription has been canceled."
    "billing.subscription_cancelled_description": "ستظل لديك إمكانية الوصول إلى اشتراكك حتى نهاية فترة الفوترة الحالية.", // In English: "You will still have access to your subscription until the end of this billing period."
    "billing.offering.free": "مجاني", // In English: "Free"
    "billing.offering.pro": "احترافي", // In English: "Professional"
    "billing.offering.business": "تجاري", // In English: "Business"
    "billing.cloud_storage": "Cloud Storage", // In English: "Cloud Storage"
    "billing.ai_access": "التحصل على الذكاء الاصطناعي", // In English: "AI Access"
    "billing.bandwidth": "Bandwidth", // In English: "Bandwidth"
    "billing.apps_and_games": "التطبيقات والألعاب", // In English: "Apps & Games"
    "billing.upgrade_to_pro": "الترقية إلى %strong%", // In English: "Upgrade to %strong%"
    "billing.switch_to": "التحويل إلى %strong%", // In English: "Switch to %strong%"
    "billing.payment_setup": "إعداد طريقة الدفع", // In English: "Payment Setup"
    "billing.back": "رجوع", // In English: "Back"
    "billing.you_are_now_subscribed_to": "أنت الآن مشترك في %strong% الفئة", // In English: "You are now subscribed to %strong% tier." 
    "billing.you_are_now_subscribed_to_without_tier": "أنت الآن مشترك", // In English: "You are now subscribed"
    "billing.subscription_cancellation_confirmation": "هل أنت متأكد من رغبتك في إلغاء اشتراكك؟", // In English: "Are you sure you want to cancel your subscription?"
    "billing.subscription_setup": "إعداد طريقة الاشتراك", // In English: "Subscription Setup"
    "billing.cancel_it": "إلغاؤها", // In English: "Cancel It"
    "billing.keep_it": "الاحتفاظ بها", // In English: "Keep It"
    "billing.subscription_resumed": "تم استئناف اشتراكك %strong%!", // In English: "Your %strong% subscription has been resumed!"
    "billing.upgrade_now": "قم بالترقية الآن", // In English: "Upgrade Now"
    "billing.upgrade": "ترقية", // In English: "Upgrade"
    "billing.currently_on_free_plan": "أنت حالياً على الفئة المجاني", // In English: "You are currently on the free plan."
    "billing.download_receipt": "تحميل التوصيل", // In English: "Download Receipt"
    "billing.subscription_check_error": "حدثت مشكلة أثناء التحقق من حالة اشتراكك", // In English: "A problem occurred while checking your subscription status."
    "billing.email_confirmation_needed": "لم يتم تأكيد بريدك الإلكتروني. سنرسل لك رمز التأكيد الآن", // In English: "Your email has not been confirmed. We'll send you a code to confirm it now."
    "billing.sub_cancelled_but_valid_until": "لقد ألغيت اشتراكك وستتحول تلقائياً إلى الفئة المجانية في نهاية فترة الفوترة. لن يتم فرض رسوم عليك مرة أخرى ما لم تعد الاشتراك", // In English: "You have cancelled your subscription and it will automatically switch to the free tier at the end of the billing period. You will not be charged again unless you re-subscribe."
    "billing.current_plan_until_end_of_period": "خطتك الحالية حتى نهاية هذه الفترة الفوترة", // In English: "Your current plan until the end of this billing period."
    "billing.current_plan": "الفئة الحالية", // In English: "Current plan"
    "billing.cancelled_subscription_tier": "إلغاء الاشتراك", // In English: "Cancelled Subscription (%%)"
    "billing.manage": "إدارة", // In English: "Manage"
    "billing.limited": "محدود", // In English: "Limited"
    "billing.expanded": "موسع", // In English: "Expanded"
    "billing.accelerated": "مسرع", // In English: "Accelerated"
    "billing.enjoy_msg": "استمتع بـ %% من Cloud Storage بالإضافة إلى مزايا أخرى.", // In English: "Enjoy %% of Cloud Storage plus other benefits."
  },
};

export default ar;
