# Changelog

## v2.5.0 (2025-01-07)

### Puter

#### Features

- hash-based distributed cache inval ([d386096](https://github.com/HeyPuter/puter/commit/d38609646793a5a14b8af96964fc7176725a0531))
- add Escape key functionality to UIPrompt for closing the prompt ([e1b6c83](https://github.com/HeyPuter/puter/commit/e1b6c83813d03809aba0abdecbf6de5529728031))
- set max token to 8096 ([b2ea8a3](https://github.com/HeyPuter/puter/commit/b2ea8a3888c5496858d257018071ba54abd6f4a8))
- added tagify in Filetype-Association input in dev center ([0cd1f15](https://github.com/HeyPuter/puter/commit/0cd1f151b5986ede431f1792139fa1a5471ae059))
- add reset edit changes button to dev-center ([55ffd80](https://github.com/HeyPuter/puter/commit/55ffd801e007723758eacc17ec732ee5a336123e))
- enable/disable save button in dev-center iff changes made ([63a0053](https://github.com/HeyPuter/puter/commit/63a0053da8c76bf4ac175c7f17353225443dd342))
- record signup metadata for abuse prevention ([66016b9](https://github.com/HeyPuter/puter/commit/66016b9db602ca85e8f0ddc846865d4641e64190))
- add support for categories in the Dev Center ([7cf215a](https://github.com/HeyPuter/puter/commit/7cf215ab677e3fc912a3bd1ac52795c1e8860c32))
- puter.js's showSpinner() will keep the spinner active for at least 1200ms ([fc5aca1](https://github.com/HeyPuter/puter/commit/fc5aca1f72de22c1530054272b55a59021ba9caa))
- allow developers to set social media images for their apps ([be36d31](https://github.com/HeyPuter/puter/commit/be36d31509280340e2a62a8c478b1e64617792a4))
- automatically open the browser when starting Puter ([2d43129](https://github.com/HeyPuter/puter/commit/2d4312972a1377a64732694811fe889f59573432))
- spinner for the `showWorking()` overlay in puter.js ([1062363](https://github.com/HeyPuter/puter/commit/1062363096418f164a6d00ed8872770ff64237b5))
- show profile pics in sharing notifications ([0e45132](https://github.com/HeyPuter/puter/commit/0e45132c05aa1106503fef02b7e4c97ecc675e10))
- Implement profile pictures ([0885937](https://github.com/HeyPuter/puter/commit/0885937f033caf35503eeb9e65bb390952992faf))
- allow `launchApp` to open explorer at a specific path ([8fefd4a](https://github.com/HeyPuter/puter/commit/8fefd4a61f0005d4f3ec2e43f7249f3edd91c837))
- Require email confirmation before sharing ([cdd1a8c](https://github.com/HeyPuter/puter/commit/cdd1a8c4e379b885ff48a874ae5577d2f0efae06))
- show unread notification count in the browser tab's title ([045259c](https://github.com/HeyPuter/puter/commit/045259cefbe24e3f52fe3840e4975d3243e99957))
- in Share window, display access level next to recipient ([cf4b6aa](https://github.com/HeyPuter/puter/commit/cf4b6aa1c24d936f9a42ca1e2945eea40939c970))
- when sharing, users can choose between 'viewer' and 'editor' for permissions ([0cbe013](https://github.com/HeyPuter/puter/commit/0cbe0139d7f306ce62992f1eda94d99e09b32df8))
- handle `notif.ack` in desktop ([a6650ee](https://github.com/HeyPuter/puter/commit/a6650ee2d8074aeb7c476e5572334853f1b6d7e8))
- add error handling to the share flow ([b5bb95e](https://github.com/HeyPuter/puter/commit/b5bb95e2d7f6021a6341e26cf15d5449ada48830))
- search ([55d2af1](https://github.com/HeyPuter/puter/commit/55d2af189e9479fb5980ce149ce74e890b325014))
- search endpoint ([b589512](https://github.com/HeyPuter/puter/commit/b589512c9dedec22fd41b92cbba2570042149873))
- the `socialLink` UI component ([1adfe5c](https://github.com/HeyPuter/puter/commit/1adfe5c70947d9de008c9d601f91b1ee14128d5d))
- Reaload App option in the window title bar context menu ([27c01c9](https://github.com/HeyPuter/puter/commit/27c01c9bd991ef871153eb5931f78fec265a62e4))
- add puter.auth.whoami() ([da0022a](https://github.com/HeyPuter/puter/commit/da0022abf0f880c7b52d2cd937ef9d1298fc09cc))
- add puter.log ([755736e](https://github.com/HeyPuter/puter/commit/755736edee9baa783be9b7d96083d908a2f2f750))
- collapsible sidebar menu in Dev Center ([1056231](https://github.com/HeyPuter/puter/commit/1056231004a629f3f76f2525ec7d83b67d3d7fa5))
- customize the order of Explorer sidebar items ([ff30de1](https://github.com/HeyPuter/puter/commit/ff30de1d6947e4692b5cf0da2e19ab37aacf1ec8))
- add extension API for modules ([14d45a2](https://github.com/HeyPuter/puter/commit/14d45a27edb99f63b4f6e010221e3a0880ae246d))
- first extension that implements a custom user options menu ([fc5e15f](https://github.com/HeyPuter/puter/commit/fc5e15f2a6d4eb5e5847fa7f2dd87b1fa382fc7c))
- add support for extensions ([b018571](https://github.com/HeyPuter/puter/commit/b018571a86f4114eab9b5edde4ecd87e343d22a7))
- add an 'Upload' button at the bottom of `OpenFilePicker` ([54ae69b](https://github.com/HeyPuter/puter/commit/54ae69b7b76016307c3b92437ca06dc2aa1eddb9))
- Allow apps to toggle `credentialless` via Dev Center ([af511c0](https://github.com/HeyPuter/puter/commit/af511c05e3ddddcce661c5406d5c831a21689608))
- add config for blocked email domains ([955b087](https://github.com/HeyPuter/puter/commit/955b087297f829b11b82dc9bd79a0e03721c5f33))
- add support for `fadeIn` effect for `UIWindow` ([13248a9](https://github.com/HeyPuter/puter/commit/13248a99bfa318e84cb99e2954a5f46805eda34f))
- welcome screen to quickly explain what Puter is ([564ff65](https://github.com/HeyPuter/puter/commit/564ff65363258cab4196b967dd556105e424d48c))
- v86 9p server support ([b145e30](https://github.com/HeyPuter/puter/commit/b145e30a90ff2f0d44d89f83dbda4de1bf2991d4))
- support readdir for directory symlinks ([7f1b870](https://github.com/HeyPuter/puter/commit/7f1b870d302421972c4f6221ae6d93b5979d51dd))
- allow passing cli args via url ([5317adf](https://github.com/HeyPuter/puter/commit/5317adf8a4961be3f0ca2a8c403c922633f934fa))
- add -c flag for phoenix ([b6c0cb6](https://github.com/HeyPuter/puter/commit/b6c0cb6abc1c29846b4b7e696812476bea24bbc7))
- progress indicator for emulator ([08601ae](https://github.com/HeyPuter/puter/commit/08601ae2af7b1f564690e6a9cae7e689cb7ba48a))
- translate README.md to Dutch ([31e2773](https://github.com/HeyPuter/puter/commit/31e2773743c336630c917e893b0148441f5fc515))
- add connectToInstance method to puter.ui ([62634b0](https://github.com/HeyPuter/puter/commit/62634b0afe4d33da08768975322d4deb23041442))
- add method to list models ([fd86934](https://github.com/HeyPuter/puter/commit/fd86934bc9021541810447cf7e2a5f33b3e283b3))
- add streaming to XHR driver client ([7600d9b](https://github.com/HeyPuter/puter/commit/7600d9b07c5b719d529f8a48c38d9178efefa266))
- add writable attribute to fs items ([2386d87](https://github.com/HeyPuter/puter/commit/2386d87229aa6205ef8ced6563371ab40a0def62))
- report feature flags in /whoami ([4561b89](https://github.com/HeyPuter/puter/commit/4561b8937de025471c2dfb1771465d779cefab5d))
- make public folders a config opt-in ([209555c](https://github.com/HeyPuter/puter/commit/209555c1d93845fa129bea450f9c25d595a3c60f))
- add feature flag for /share ([461ea3e](https://github.com/HeyPuter/puter/commit/461ea3eae6ad32bf34c43a822de7a06f08efb556))
- add message encryption between Puter peers ([cea2964](https://github.com/HeyPuter/puter/commit/cea29645fec493020a4f66e378b087fa17ae03d4))
- add test_mode flag ([9a9bd5e](https://github.com/HeyPuter/puter/commit/9a9bd5eaf0aca8fd1cc57455db03dba55801d5a0))
- add tts driver to puterai module ([78fa77d](https://github.com/HeyPuter/puter/commit/78fa77d9200e0b9fafc4014f8d0cb08c74cd16cb))
- add image generation driver to puterai module ([fb26fdb](https://github.com/HeyPuter/puter/commit/fb26fdbc561d5545d28352427553695cd3237ad5))
- add chat completions driver to puterai module ([4e3bd18](https://github.com/HeyPuter/puter/commit/4e3bd1831e92e83ce9b4e30a16afd562b0221dd8))
- add --overwrite-config and configurable uuid masking ([ef6671d](https://github.com/HeyPuter/puter/commit/ef6671da18f6841cb2143808fe21586ac3505942))
- add textract driver to puterai module ([f924d48](https://github.com/HeyPuter/puter/commit/f924d48b02f39884931db45a05dd61b65f2cee4a))
- add password reset from server console ([984ae9e](https://github.com/HeyPuter/puter/commit/984ae9e6a23da17414e43d58fc0e861827031269))
- add server command to scan permissions ([54471fa](https://github.com/HeyPuter/puter/commit/54471fada946a70eaa0df6bfceae995bc4e5848c))
- grant user driver perms from admin ([c9ded89](https://github.com/HeyPuter/puter/commit/c9ded89b22bb822c20aea379a17a8bdf74a658de))
- replace default_user with admin ([f0c36a1](https://github.com/HeyPuter/puter/commit/f0c36a1cdf16f11765c29360a5c38140008b90c7))
- add system user ([ab15629](https://github.com/HeyPuter/puter/commit/ab156297a746c0754145c2abdb2c99bb1b30651a))
- add options to disable winston and devwatch ([5d5f566](https://github.com/HeyPuter/puter/commit/5d5f5660b4020650b68b79ccf3860d3fb0bf98a9))
- add new file templates ([1f7f094](https://github.com/HeyPuter/puter/commit/1f7f094282fae915a2436701cfb756444cd3f781))
- add cross_origin_isolation option ([e539932](https://github.com/HeyPuter/puter/commit/e53993207077aecd2c01712519251993bb2562bc))
- add option to disable temporary users ([f9333b3](https://github.com/HeyPuter/puter/commit/f9333b3d1e05bd0dffaecd2e29afd08ea61559fc))
- add some default groups ([ba50d0f](https://github.com/HeyPuter/puter/commit/ba50d0f96d58075abec067d24e6532bd874093f0))
- Add support for dropping multiple Puter items onto Dev Center (close #311) ([8e7306c](https://github.com/HeyPuter/puter/commit/8e7306c23be01ee6c31cdb4c99f2fb1f71a2247f))

#### Translations


- complete Hungarian translation of Puter #972 ([7d2787d](https://github.com/HeyPuter/puter/commit/7d2787d26b3a64cbc128fb2cb3871b43b41912fe))
- add missing Igbo translations for billing-related terms ([f0f19e7](https://github.com/HeyPuter/puter/commit/f0f19e727e574a8558fcbbf27ba501f434db69f8))
- Complete the Vietnamese translation of Puter #954 ([56489c3](https://github.com/HeyPuter/puter/commit/56489c33f611fc053096b455e4cb7b3d8f20852c))
- Complete the  French (Français) translation of Puter #975 ([c840bc8](https://github.com/HeyPuter/puter/commit/c840bc8161055b90e040bdae3196817e0791ecf5))
- Complete the German (Deutsch) translation of Puter ([05fef67](https://github.com/HeyPuter/puter/commit/05fef6749e8d80f13ab94a4e0ea49ce4972a0961))
- (#954) Add Vietnamese translations for billing-related terms ([267a55a](https://github.com/HeyPuter/puter/commit/267a55aae50f87edb483abb375029ff79e736112))
- add vietnamese translations for billing in vi.js ([3e26dbe](https://github.com/HeyPuter/puter/commit/3e26dbe6a0411fe75c36cf2866d34f28a2dcb553))
- added a few Korean translatations ([b23e800](https://github.com/HeyPuter/puter/commit/b23e800f4e70f162b52cc15053d03961a37033bb))
- add brazillian translations for billing-related terms in br.js (revision) ([fdfc90a](https://github.com/HeyPuter/puter/commit/fdfc90a9317a19d45a0b2b3ad283be9a10a92732))
- add brazillian translations for billing-related terms in br.js ([e66df14](https://github.com/HeyPuter/puter/commit/e66df14862e6dd7278623279e43e2189e7ddafe5))
- Add Indonesian Translation for i18n ([033643b](https://github.com/HeyPuter/puter/commit/033643b0e757b51ea0be90e2198bbec65d31cfc5))
- add Polish translations for billing-related terms ([15f9ade](https://github.com/HeyPuter/puter/commit/15f9aded26eaa4c630fe948350d3a53cdb0278a3))
- update Urdu localization with missing translations ([0c4b994](https://github.com/HeyPuter/puter/commit/0c4b9946442ad92549522fcd91ea6aefbb9f19d6))
- Update ig.js ([382fb24](https://github.com/HeyPuter/puter/commit/382fb24dbb1737a8a54ed2491f80b2e2276cde61))
- feat: add vietnamese localization-a ([c2d3d69](https://github.com/HeyPuter/puter/commit/c2d3d69dbe33f36fcae13bcbc8e2a31a86025af9))
- Update zhtw.js, Complete Traditional Chinese translation based on English file #550 ([b9e73b7](https://github.com/HeyPuter/puter/commit/b9e73b7288aebb14e6bbf1915743e9157fc950b1))
- update zhtw.js to match en.js ([37fd666](https://github.com/HeyPuter/puter/commit/37fd666a9a6788d5f0c59311499f29896b48bc82))
- Add Tamil translation to translations.js ([8a3d043](https://github.com/HeyPuter/puter/commit/8a3d0430f39f872b8a460c344cce652c340b700b))
- Move Tamil translation to the rest of translations ([333d6e3](https://github.com/HeyPuter/puter/commit/333d6e3b651e460caca04a896cbc8c175555b79b))
- Translation improvements, mainly style and context-based ([8bece96](https://github.com/HeyPuter/puter/commit/8bece96f6224a060d5b408e08c58865fadb8b79c))
- update translation file es.js to be up to date with the file en.js ([1515278](https://github.com/HeyPuter/puter/commit/151527825f1eb4b060aaf97feb7d18af4fcddbf2))
- Translate en.js as of 2024-07-10 ([8e297cd](https://github.com/HeyPuter/puter/commit/8e297cd7e30757073e2f96593c363a273b639466))
- Create hu.js hungarian language ([69a80ab](https://github.com/HeyPuter/puter/commit/69a80ab3d2c94ee43d96021c3bcbdab04a4b5dc6))
- Update translations.js to Hungarian lang ([56820cf](https://github.com/HeyPuter/puter/commit/56820cf6ee56ff810a6b495a281ccbb2e7f9d8fb))
- Tamil translation ([81781f8](https://github.com/HeyPuter/puter/commit/81781f80afc07cd1e6278906cdc68c8092fbfedf))
- Update it.js ([84e31ef](https://github.com/HeyPuter/puter/commit/84e31eff2f58584d8fab7dd10606f2f6ced933a2))
- Update Armenian translation file ([3b8af7c](https://github.com/HeyPuter/puter/commit/3b8af7cc5c1be8ed67be827360bbfe0f0b5027e9))
- correct Igbo translation for "Free" in billing terms ([6f4d57a](https://github.com/HeyPuter/puter/commit/6f4d57a3c6da607038f4fbe49c691478f47933be))

#### Bug Fixes

- missing ll_copy import ([8a9164d](https://github.com/HeyPuter/puter/commit/8a9164d7c5380aafb864b56ca1a3ee59f24daf38))
- bad uuid reference to resourceService ([13003c4](https://github.com/HeyPuter/puter/commit/13003c486fbebad0f26dd1b569f5fd5f2cefc9e7))
- allow localhost for development ([ad8a397](https://github.com/HeyPuter/puter/commit/ad8a3978c07e44f7a534981ddd65bc131c9aac6b))
- rewrite confusing log message ([dacbbf0](https://github.com/HeyPuter/puter/commit/dacbbf033dcc0f4506198761eab3bfb6ef915336))
- AppInformationService initialization ([2332602](https://github.com/HeyPuter/puter/commit/233260233c4e52399541aedbf8b13800de80d3fd))
- dev center app icon SVG issue ([47a4313](https://github.com/HeyPuter/puter/commit/47a4313d92152b9e5b4036715ac4f19431be8940))
- app icon double-encode bug ([23eab63](https://github.com/HeyPuter/puter/commit/23eab63776a146a78b10e973518158fc07b13653))
- first read of recommended apps ([a6b9d33](https://github.com/HeyPuter/puter/commit/a6b9d33d27909ead3d14eff4446062d62aad4651))
- prefix peer addresses with protocol ([efd4730](https://github.com/HeyPuter/puter/commit/efd4730f757471c3eac2d5e396dd69b619ad2999))
- clone message object ([728ecbf](https://github.com/HeyPuter/puter/commit/728ecbfb033082186ca9480f2ab2d1607b57ca5a))
- timing for PrefixLogger call to /whoami ([2dc6c47](https://github.com/HeyPuter/puter/commit/2dc6c4737b9ec9db281b4b32ed4bd20ac490e47d))
- try catching icon read errors before stream ([e56a62c](https://github.com/HeyPuter/puter/commit/e56a62c5390958e585f299751bafd13becc1c9b6))
- try catching on stream_to_buffer ([ada051b](https://github.com/HeyPuter/puter/commit/ada051b9b87e945b4a80c1fae99b8c5644b82dc0))
- check if row.timestamp is Date ([5d049e8](https://github.com/HeyPuter/puter/commit/5d049e8f06dafe2e499ccfea66ef013a9b595396))
- AppES PD alert ([f14e1fe](https://github.com/HeyPuter/puter/commit/f14e1fefcf18438bd59eb86d625b8c5a6fb3ffc5))
- fix for previous fix ([648d6e0](https://github.com/HeyPuter/puter/commit/648d6e036d6f8040a1e440c1e76dc9dcc746156f))
- fix fallback icon behavior in get_icon_stream ([4f3a161](https://github.com/HeyPuter/puter/commit/4f3a1618b10dd393f5c94c0967beb228a593b214))
- revert test change ([9c86614](https://github.com/HeyPuter/puter/commit/9c86614df5d58ca0385450e1edb5adb5b6d72300))
- acl check for subdomain on access ([c69006e](https://github.com/HeyPuter/puter/commit/c69006e1852befa93f94a7c45651025214941a4e))
- attempt fix for prod issue with app icons ([925ebd5](https://github.com/HeyPuter/puter/commit/925ebd531013e36ee5c05d53ef229d314fb89435))
- remove redundant notification query ([f87769b](https://github.com/HeyPuter/puter/commit/f87769b445d53e6322a55a788e26d38629299ae9))
- share only emails email_confirmed recipients ([2336a62](https://github.com/HeyPuter/puter/commit/2336a62b4f635c025b02bb7efe91b5ddf58bae25))
- database issue with KBKV update ([7ba1b76](https://github.com/HeyPuter/puter/commit/7ba1b7656b5e24375cad639b9a8e37577b526c09))
- taskbar items of apps should always appear before Trash ([94e7f5d](https://github.com/HeyPuter/puter/commit/94e7f5deb4330a844a680c22f55b8753225a1a7e))
- fullpage mode ([65d9188](https://github.com/HeyPuter/puter/commit/65d918866ea0ee981bc26151332b730abccb7be8))
- bug in writeFile rename ([298609c](https://github.com/HeyPuter/puter/commit/298609c6e9080e00c90b66c673e104d90f9d3ed0))
- remove unnecessary `item_path` definition in `delete` fs api ([c792f4a](https://github.com/HeyPuter/puter/commit/c792f4a345b307d024f73ff2817ae473b2620913))
- add missing permissions ([69e9df1](https://github.com/HeyPuter/puter/commit/69e9df1ae21cf906dfcc3d9d7a23455e5274271c))
- logic from previous commit ([6ca7011](https://github.com/HeyPuter/puter/commit/6ca701139a07a0d20071cf1532cc6e95639a01da))
- add fallback moderation in case openai goes down ([c6e814d](https://github.com/HeyPuter/puter/commit/c6e814daa80eec01c10f319ebebcb84c42cd26e1))
- permission strings for ES services ([4d9cc9b](https://github.com/HeyPuter/puter/commit/4d9cc9bd830d0c73024f2bc5a91ab226aedefded))
- resolve issue #983 - Stuck on Creating new app loading screen ([c75c9d0](https://github.com/HeyPuter/puter/commit/c75c9d03833af52730cac89a8fee5f5c317f0f78))
- provide actor context to ws event ([1b57801](https://github.com/HeyPuter/puter/commit/1b578019f915918e51185f5705d7fa6e0328b9ae))
- context error in user connected event ([9600823](https://github.com/HeyPuter/puter/commit/96008233ba4935e789cd092c07aa8b351cb44d45))
- signup 500 for temp user ([01395f3](https://github.com/HeyPuter/puter/commit/01395f302e763cdad022c0e5a995869fcd805d86))
- bad import for TeePromise ([acf8ae3](https://github.com/HeyPuter/puter/commit/acf8ae302ec4ee79c11c2b0e810edd53f21446c5))
- sorting bug in AIChatService ([7acb096](https://github.com/HeyPuter/puter/commit/7acb096addd58113cc8d4338ba941cd14ac81f4f))
- test issues from contextlink removal ([545e7db](https://github.com/HeyPuter/puter/commit/545e7db5bdac6e39962390469767667bc62857fd))
- add missing import ([e279dc6](https://github.com/HeyPuter/puter/commit/e279dc6e5f4095550f41aadd194ea94e1e2a2271))
- fake_chat default model and usage errors ([13a895b](https://github.com/HeyPuter/puter/commit/13a895b76b1e5a677c2eeeb0a07be6ce9fd02a99))
- update test kernel ([a1c2226](https://github.com/HeyPuter/puter/commit/a1c2226561655e091cbc0d014ada62bfc7881f2a))
- correct AI comment faults ([b40d453](https://github.com/HeyPuter/puter/commit/b40d4534a71565a7f2d0ae278c98d7326c5aa963))
- update package-lock.json ([8577185](https://github.com/HeyPuter/puter/commit/857718538b8a7bf27dc036f4eeb3728cb6ea96e7))
- ignore two calls with undefined origin ([ab4ba76](https://github.com/HeyPuter/puter/commit/ab4ba76433ac623abaa17c0e5dd024e95b9fef3f))
- undefined APIOrigin ([340c7a8](https://github.com/HeyPuter/puter/commit/340c7a821fb91e2d106c2b3febf8182de7b21f7d))
- add id to the setting menu item in user option menu ([67ca4cc](https://github.com/HeyPuter/puter/commit/67ca4ccf20fd714848121192d5ae7c41f3763da4))
- add an id to `My Websites` content menu item ([e662c78](https://github.com/HeyPuter/puter/commit/e662c782b745f4f98024d1353a6a162d5fe58c44))
- remove unnecessary `integrity` and `crossorigin` attributes in dev center when linking to jquery ([8dec78b](https://github.com/HeyPuter/puter/commit/8dec78b090ec4434ad77003d6f3c25de98779864))
- remove inactive links in README ([f3d270c](https://github.com/HeyPuter/puter/commit/f3d270ccbcd8990270cf968a3638b7affa2df6ba))
- improve backend mod error handling ([fe1a4cf](https://github.com/HeyPuter/puter/commit/fe1a4cfd4d5dd1eddbb2d50ef3f5ebf78a81656d))
- app query should return app metadata ([3cedd17](https://github.com/HeyPuter/puter/commit/3cedd17b8ed4acb1099bc2e87aba0137339c8a17))
- safe parsing of app metadata ([a2c7b37](https://github.com/HeyPuter/puter/commit/a2c7b379f8181b373b0513d9166f75adc147aafa))
- configuration for browser launch ([791f774](https://github.com/HeyPuter/puter/commit/791f7748c7c1959f63327a73a7e24e41b574a910))
- previous fix ([ee7bedd](https://github.com/HeyPuter/puter/commit/ee7bedd5586d69ce74f32c1400f377d6a8971eaa))
- always adapt model for ClaudeEnough ([56710e1](https://github.com/HeyPuter/puter/commit/56710e17f3b06eef07e54c243f6b725fcc4a4583))
- automatically open browser when starting only if in dev env ([f500fb4](https://github.com/HeyPuter/puter/commit/f500fb47061f8f3a3dc7d871cb529f5c0b058185))
- image generation supports test mode ([f533dca](https://github.com/HeyPuter/puter/commit/f533dca1a6d88ca7a14bd69f15d0a151e24c58e1))
- share issue with prefix usernames ([d30d62f](https://github.com/HeyPuter/puter/commit/d30d62f558ca5f8c74090900aa39c13ca3ca1d2e))
- permission grants in open_item ([16257a7](https://github.com/HeyPuter/puter/commit/16257a7b5459550ee3782cf32c87a8241325878d))
- sharing notification click opening directories ([bfacfc2](https://github.com/HeyPuter/puter/commit/bfacfc2a4e4b50c9e0842f9f2d56de67a598b959))
- add placeholders ([2c86240](https://github.com/HeyPuter/puter/commit/2c862403994ff6385144841db07dcc94c5c2fc2e))
- capitalize `Hindi` in i18n ([35fd158](https://github.com/HeyPuter/puter/commit/35fd15854ad3cc92924c4ded752e337f467a7125))
- give camera and recorder write permission to Desktop ([65e6d6c](https://github.com/HeyPuter/puter/commit/65e6d6c09fd464b3fea979689fab5f26a2647c4a))
- potential null-or-undefined in DriverService ([01725ff](https://github.com/HeyPuter/puter/commit/01725ffebf86ed332087c877956e59570ea700ed))
- usage bug ([0fd3b1e](https://github.com/HeyPuter/puter/commit/0fd3b1e61157d989d55e6dacba2add0e03d260e7))
- update share email ([7e7234b](https://github.com/HeyPuter/puter/commit/7e7234b2f3fb89560108447cfd7fa87499ec6f38))
- allow scrolling of user list in share window ([905b5d8](https://github.com/HeyPuter/puter/commit/905b5d851ef68d923d8f7fbaddbe214cb812bae6))
- mobile detection ([b11016d](https://github.com/HeyPuter/puter/commit/b11016dab321717f2c367e985167a4689fc02814))
- mobile-friendly taskbar ([7a7c14f](https://github.com/HeyPuter/puter/commit/7a7c14fb040b28ef769abdba41b50d88c856fb20))
- prevent permission cycles ([e0128aa](https://github.com/HeyPuter/puter/commit/e0128aa88c54548304532282e5ed1b4a2d36ff3e))
- `launchApp` on explorer supports `~` now ([e482b00](https://github.com/HeyPuter/puter/commit/e482b00a303ca7ec0230be1924334d59adc00f8e))
- only allow UserActorType for ShareService ([69bfa60](https://github.com/HeyPuter/puter/commit/69bfa601993eb6c47c3555b92559878d76ba749e))
- new sessions miss notifications ([b1ffb8e](https://github.com/HeyPuter/puter/commit/b1ffb8eca13520fa41833f5361ff6a6505a80a2c))
- don't allow sharing with recipient just shared with ([d0f16c8](https://github.com/HeyPuter/puter/commit/d0f16c810509c7e4e8acba3408c71655664cfad2))
- add username to comments ([085d808](https://github.com/HeyPuter/puter/commit/085d808817e985f2bc52b7a91a31991ca3b2e89f))
- occasional db error from notics ([9e303a2](https://github.com/HeyPuter/puter/commit/9e303a2f7c7bf6ac9032e6c9b87bffd3126baa86))
- un-awked notif check in wrong place ([3f3f4e6](https://github.com/HeyPuter/puter/commit/3f3f4e6cb9fd3faad2e87fbf9ea1f09b934151ca))
- disabled sortable on sharing section in the sidebar ([9d7987f](https://github.com/HeyPuter/puter/commit/9d7987fae50b510f1836e306d5f6f497a560de08))
- add mixxing context to BroadcastService ([665471f](https://github.com/HeyPuter/puter/commit/665471f9f02b1f1163edb47932a31f52577ee7df))
- attempt at fixing broadcast ([22dd42e](https://github.com/HeyPuter/puter/commit/22dd42ef7f64d32ada0c776287f53a80a4470315))
- replace ll_readshares with better approach ([cd22425](https://github.com/HeyPuter/puter/commit/cd22425a3d363f6008b3d07f40a082769ee22a14))
- only add enabled_logs when not empty ([34836e3](https://github.com/HeyPuter/puter/commit/34836e374fccac297a6f0fa5f323f3609d0c9179))
- don't check share permission anymore ([249dc06](https://github.com/HeyPuter/puter/commit/249dc062014947c32bee8a8238b2c8acf86188bb))
- files shared array in notification ([27cc07e](https://github.com/HeyPuter/puter/commit/27cc07e985a799fae791d6edf61b7e656e0e182e))
- report path for broken files as /-void/ ([5725bd8](https://github.com/HeyPuter/puter/commit/5725bd8c66539564e7f58f96c6e81044a3751f97))
- issue with popover closing when clicked ([ac3317a](https://github.com/HeyPuter/puter/commit/ac3317aea918953358947638ca11822baa38e23f))
- groups manager location ([a08e975](https://github.com/HeyPuter/puter/commit/a08e9758fe7625d31279b8947a4e5ca6471578ff))
- don't show kvstore in usages ([402ffb0](https://github.com/HeyPuter/puter/commit/402ffb0fd1e812a8db8ea90ac53ed613fdd30a4b))
- add missing id for task_manager menu item ([4f9d9a5](https://github.com/HeyPuter/puter/commit/4f9d9a54efb3c5177125904a1c9ddec66ca089dc))
- Update security.txt canonical URL ([6c44032](https://github.com/HeyPuter/puter/commit/6c44032293836871a27fb3c857a0ff3b80462702))
- update apps cache by reading from primary db ([e8f67da](https://github.com/HeyPuter/puter/commit/e8f67da9a3d81273f59d136c8383f00d9dc8ca5a))
- logging in AppConnection ([5caa2c0](https://github.com/HeyPuter/puter/commit/5caa2c0e3a152d1fc947b86329778db462139db0))
- persist clock visibility change ([1a6d648](https://github.com/HeyPuter/puter/commit/1a6d648a6ecdda07b23da9e6f4ef49b70b54cce1))
- don't access `metadata.credentialless` if it doesn't exist ([9590bbd](https://github.com/HeyPuter/puter/commit/9590bbdad1099cf75d6073663a9fcec5f3136482))
- reinitialize settings tabs for DOM events ([16b9f09](https://github.com/HeyPuter/puter/commit/16b9f09e66ffe1584f925cb1a9f261bc159c8dda))
- use correct cursor when hovering over sidebar items ([c44b9ab](https://github.com/HeyPuter/puter/commit/c44b9ab8d5f575393bf864fd30235287f845a4e8))
- issue with context menu divider item stealing the event from previous item ([121043d](https://github.com/HeyPuter/puter/commit/121043d312577a6e048497108309cd08b73df4d0))
- issue with non-scrollable window body and document Context Menu ([0315cb3](https://github.com/HeyPuter/puter/commit/0315cb333719b08c6581b556c69a14cbe671b7bd))
- temporary fix because .on can't call ensure_service ([f836ac3](https://github.com/HeyPuter/puter/commit/f836ac30a901a7b3258399a54eab5c7c8cc47463))
- issues in kdmod ([0a47daa](https://github.com/HeyPuter/puter/commit/0a47daa2896d97c318aec2e2288f61ade5f4ea48))
- Collector bug on undefined body ([14f477a](https://github.com/HeyPuter/puter/commit/14f477a6330c9169145a7f8b2721d02e7517513b))
- hyphenize_confirm_code bug ([463c96c](https://github.com/HeyPuter/puter/commit/463c96c69a915ea75db66fd449e83a61ca036f6f))
- app close issue in phoenix ([38adb57](https://github.com/HeyPuter/puter/commit/38adb5741b241081dd3f30de2f9afdd708cc9fa5))
- reading JSON string from service_usage_monthly ([b30de5b](https://github.com/HeyPuter/puter/commit/b30de5bf786ae8f28f3248277c5b2df2f0e5ebf4))
- recently broke counting service sql ([7ba16d1](https://github.com/HeyPuter/puter/commit/7ba16d1c21d07e58cefebf967e5ca2b74502e841))
- ignore invalid entries from service_usage_monthly ([f108795](https://github.com/HeyPuter/puter/commit/f1087953b57297a1e066ea68563e8a273a1af4c0))
- service usage screen ([193da63](https://github.com/HeyPuter/puter/commit/193da633044f463ec1ed60eca4608761fc40b1d7))
- continue work on blocked_email_domains (2) ([4dc1e01](https://github.com/HeyPuter/puter/commit/4dc1e01682571f16a25eebb2e9c7918587ca89ae))
- continue work on blocked_email_domains ([515051d](https://github.com/HeyPuter/puter/commit/515051dabf9f2a145ae2d090f829df7188e9fd28))
- errors thrown by launch_app ([c22a69f](https://github.com/HeyPuter/puter/commit/c22a69ffb1809ad7959f8a8fe934052369b5d44f))
- notepad save issue ([bc51d4b](https://github.com/HeyPuter/puter/commit/bc51d4bd52b5d0a7bb4feddea7bb9d73e449f7d8))
- height 100% on flexer and step view ([c6bc42f](https://github.com/HeyPuter/puter/commit/c6bc42f551a46919b4b70a9ae3dfec85086b0233))
- wait no ([12e0cec](https://github.com/HeyPuter/puter/commit/12e0cecf02f4d906035a6f0059557416475db106))
- phoenix incorrect lookup order ([c8f913d](https://github.com/HeyPuter/puter/commit/c8f913d710454d0ab3da2147309b442a78965720))
- turns out we don't support `utm_source` I learn something new about Puter every day! ([99ce3bd](https://github.com/HeyPuter/puter/commit/99ce3bde199de729c4796a681c188c4a0da9165e))
- issue with service scripts that use TestView ([e0b9072](https://github.com/HeyPuter/puter/commit/e0b90721299fa3013f66c866ba637c52efe9df1d))
- 1954f8-related issue #2 ([143cfb5](https://github.com/HeyPuter/puter/commit/143cfb5654eca8b50fb7ff434f47db24d7bdf3aa))
- 1954f8-related issue ([f5865da](https://github.com/HeyPuter/puter/commit/f5865daede2b32682d0472926bc5db65c9ef37ab))
- small issue in Service.js ([3c5d2af](https://github.com/HeyPuter/puter/commit/3c5d2af8c8341ef78236ef38153ed0b4f20c5cac))
- prevent code from breaking just because it was bundled ([fb1216d](https://github.com/HeyPuter/puter/commit/fb1216d488bed8ee8d88c7c71e4a6f1054e3a01c))
- don't display all apps for extensionless files ([010282e](https://github.com/HeyPuter/puter/commit/010282edf299c2a39e53de7441b8850d0b8011b8))
- creating app shortcut in self-hosted ([38dcb60](https://github.com/HeyPuter/puter/commit/38dcb60d3f407dd185999d01d8e14355b47df0b8))
- disable thumbnails for AppData uploads ([37e7b6a](https://github.com/HeyPuter/puter/commit/37e7b6ad70f197db3be8712315446079caa23892))
- thumbnail service updates ([c2a9506](https://github.com/HeyPuter/puter/commit/c2a9506b4855f67d320eb479a67800098d73e8ec))
- remove redundant openai model fallback ([9db55fc](https://github.com/HeyPuter/puter/commit/9db55fc5f7a975ab301c88bbac493b7a5b1933bb))
- app pseudonym in wrong conditional block ([9985996](https://github.com/HeyPuter/puter/commit/99859966866ebce005f88e3a916c68dc04ba97bf))
- properly add owner object to fsentries ([04c05a5](https://github.com/HeyPuter/puter/commit/04c05a5bb8b73dda21093a2bf563f5cd6faaa356))
- add progress bar fix ([a70d0dd](https://github.com/HeyPuter/puter/commit/a70d0dd0881b0a07cea404fe13515a5e10321e3e))
- allow ETX to propagate to bash ([259877b](https://github.com/HeyPuter/puter/commit/259877b677a7bfc8e5b377c8852d687978c9bc24))
- error deleting entry from My Websites window ([fff8993](https://github.com/HeyPuter/puter/commit/fff89932002d67bf0f121532709c871263e33473))
- second half of connectToInstance ([4311b48](https://github.com/HeyPuter/puter/commit/4311b482fd629c6d1f65956eb711c8e890453179))
- error in process.handle_connection ([cb324cc](https://github.com/HeyPuter/puter/commit/cb324cc125285b5cd6a6b0cebf444a6cd873ded9))
- quick patch to avoid columnify error ([4396534](https://github.com/HeyPuter/puter/commit/439653458eab38e622cf215ae96b6af34d1db7d4))
- upsert subdomain check to insert only ([f2acd83](https://github.com/HeyPuter/puter/commit/f2acd83b72c388939233fd7145f2dcf78d8ad39e))
- simplify callback listener and fix async bug ([db3e0b5](https://github.com/HeyPuter/puter/commit/db3e0b5ce84e4b0b35550f380da97b5d6fcb394b))
- email change on account with unverified email ([33de981](https://github.com/HeyPuter/puter/commit/33de98107f6e3284acb180b1a44bb02ae082642f))
- html-webpack-plugin dev dep ([cc4ab1c](https://github.com/HeyPuter/puter/commit/cc4ab1cb36a002929f26a39f252a262fc1f1aab4))
- double-echo in phoenix ([6bdcae7](https://github.com/HeyPuter/puter/commit/6bdcae769d311b5deb82136d5e35d7ad986bca28))
- webpack error reporting + unintentional whitespace changes ([4910838](https://github.com/HeyPuter/puter/commit/4910838ab1a72738b44f948cbf65feea848e5271))
- dist ([ed7d6dc](https://github.com/HeyPuter/puter/commit/ed7d6dcbfbf432ae90d9e379dbf47de5587a57a2))
- use jq el for focus ([d350264](https://github.com/HeyPuter/puter/commit/d35026467eb9a5f67d6ec0c99f2a24d418b8e3a5))
- fix sourcemap ([cd39bb5](https://github.com/HeyPuter/puter/commit/cd39bb5aa073286baa053f8458f0af54a4b7313a))
- remove now-redundant loadScript call ([c9d09a7](https://github.com/HeyPuter/puter/commit/c9d09a78b6f4bc9682d13d2f982f9a2b7f77dd66))
- env for dev build ([46a0f71](https://github.com/HeyPuter/puter/commit/46a0f714d10c2fa99ee9436f453176d54cc161f8))
- mistakes ([3092300](https://github.com/HeyPuter/puter/commit/3092300a0144791b25816b39845a3d85968e9059))
- add env to EmitPlugin config ([4b89101](https://github.com/HeyPuter/puter/commit/4b8910169a26f85489135cd84b27fe8f91b37bc6))
- remove accidentally left-over code ([72946f9](https://github.com/HeyPuter/puter/commit/72946f920c9f27f4c9de3156aa9144d290699222))
- don't var when no var ([5f7d1f5](https://github.com/HeyPuter/puter/commit/5f7d1f589a56b3d3ea2026dcbd5f9c48b8dc9e6d))
- fallback to read access in /sign ([813ee95](https://github.com/HeyPuter/puter/commit/813ee95cee6f1fca79a886b12d8fe4603ca0d213))
- typo in a default file ([aa61c30](https://github.com/HeyPuter/puter/commit/aa61c3009c624099e7bd518870b18b02c008530c))
- fix 500 when check-app has bad url ([9a62200](https://github.com/HeyPuter/puter/commit/9a622004ea488783127abd83f3f4caf779a5aabb))
- ll_write ([a7cdb70](https://github.com/HeyPuter/puter/commit/a7cdb70251ae86f883257de3596838d20196c62d))
- don't try to sanitize null owners ([cb4cab5](https://github.com/HeyPuter/puter/commit/cb4cab529affa5c28ddb32b90328ad47f21de8d4))
- missing key for feature flag perm check ([1482048](https://github.com/HeyPuter/puter/commit/14820481b9700a5c61c6d9a156944f42f9879008))
- implicit app permissions bug ([6b4a19e](https://github.com/HeyPuter/puter/commit/6b4a19e12a115be2c0e323d17340ab2ce2b6b025))
- share services and features with apps ([48fea77](https://github.com/HeyPuter/puter/commit/48fea77a20a0938fc2272483c798b817ca1c9848))
- admin user public folder ([3819584](https://github.com/HeyPuter/puter/commit/3819584d119076658c9d4be2b2b941c58d122ad4))
- add anti-csrf token for /revoke-session ([b6b64d3](https://github.com/HeyPuter/puter/commit/b6b64d3bccb6e17240a245c956ead2ae5a87c8dd))
- only show 2fa when available ([9fa12d4](https://github.com/HeyPuter/puter/commit/9fa12d43fc782d7e4d2584b1cf74dca13b7ced25))
- requirement for email_confirmed in backend ([6e325fa](https://github.com/HeyPuter/puter/commit/6e325fa000f19b8f20d79829ab2bd78edce80425))
- do primary read of user after setting email_confirmed ([ef245b7](https://github.com/HeyPuter/puter/commit/ef245b70df482ff470877459fcb28e1f490fe42d))
- require confirmed email for public folder ([0519b4a](https://github.com/HeyPuter/puter/commit/0519b4a71b236e464c9d1136065e8f5ba15def8e))
- sqlite condition in MonthlyUsageService ([d4319ea](https://github.com/HeyPuter/puter/commit/d4319ea072e0793a32dbddb1d456227cf481e42c))
- add context to event listener aiife ([3f07ead](https://github.com/HeyPuter/puter/commit/3f07ead1b9940ee133c142f4c34d19884bbb3cd2))
- missing method in SLink ([5b74b4a](https://github.com/HeyPuter/puter/commit/5b74b4affae5473029e887542717c76c7b32f562))
- disable unconfigured ai services ([476acae](https://github.com/HeyPuter/puter/commit/476acae0e0d07c7b025cdbcfd86aacfedd7831a5))
- add missing driver parameter to /call endpoint ([b520783](https://github.com/HeyPuter/puter/commit/b520783bf4a543c71eaef73277f42d5918ac4469))
- sqlite migrations error ([d0e461e](https://github.com/HeyPuter/puter/commit/d0e461e206300e7fe3f9bc7f54eaa3a25bb762d8))
- prevent large logs from service events (2) ([e514dfc](https://github.com/HeyPuter/puter/commit/e514dfcf5049771af3901334e37b1a7c53e05452))
- prevent large logs from service events (1) ([fa9cc8e](https://github.com/HeyPuter/puter/commit/fa9cc8efcfda5e573c73841ae49c423879e5fcd8))
- fix templates ([5d2a6fc](https://github.com/HeyPuter/puter/commit/5d2a6fce305a3dcd4857f52ebb75f529dffe4790))
- popup login in co isolation mode ([8f87770](https://github.com/HeyPuter/puter/commit/8f87770cebab32c00cb10133979d426306685292))
- add necessary iframe attributes for co isolation ([2a5cec7](https://github.com/HeyPuter/puter/commit/2a5cec7ee914c9c97ae90b85464f9fc5332ad2fb))
- chore: fix confirm for type_confirm_to_delete_account ([02e1b1e](https://github.com/HeyPuter/puter/commit/02e1b1e8f5f8e22d7ab39ebff99f7dd8e08a4221))
- syntax error and formatting issue ([3a09e84](https://github.com/HeyPuter/puter/commit/3a09e84838fe8b74bd050641620eec87d9f59dfc))
- #432 ([f897e84](https://github.com/HeyPuter/puter/commit/f897e844989083b0b369ba0ce4d2c5a9f3db5ad8))
- `launch_app` not considering `explorer` as a special case ([98e6964](https://github.com/HeyPuter/puter/commit/98e69642d027a83975a0b2b825317213098bb689))
- well kinda (HOSTNAME in phoenix) ([7043b94](https://github.com/HeyPuter/puter/commit/7043b9400c63842c4c54d82724167666708d3119))
- it was github actions the entire time ([602a198](https://github.com/HeyPuter/puter/commit/602a19895c05b45a7d283470e7af3ae786be1bf2))
- run mocha within packages in monorepo ([58c199c](https://github.com/HeyPuter/puter/commit/58c199c15356ac087a04b16dd18e8fe0f1aea359))
- make webpack output not look like errors ([ad3d318](https://github.com/HeyPuter/puter/commit/ad3d318d07377c78c0429247225655e489b68be4))
- No scrollbar for session list ([45f131f](https://github.com/HeyPuter/puter/commit/45f131f8eaf94cf3951ca7ffeb6f311590233b8a))
- fix path issues under win32 platform ([d80f2fa](https://github.com/HeyPuter/puter/commit/d80f2fa847bfaef98dc8d482898f5c15f268e4bd))
- remove abnoxious debug file ([5c636d4](https://github.com/HeyPuter/puter/commit/5c636d4fd25e14ba3813f7fca3b70ff7bd6860e7))
- read_only fields in ES ([e8f4c32](https://github.com/HeyPuter/puter/commit/e8f4c328bff5c36b95fe460b80803e12e619f8ee))
### Security


#### Bug Fixes

- verify dest_node uid matches signature ([e208b99](https://github.com/HeyPuter/puter/commit/e208b99d211e98cd88e0a8b2917bbe6b2f2423a0))
- always use actor ([1954f86](https://github.com/HeyPuter/puter/commit/1954f86680be642e1af03f648d6b587fe67dfaa8))
- signing in public folders ([937528f](https://github.com/HeyPuter/puter/commit/937528f7676e8ace7287141e1f5057842a2b5eb7))
- remove unconfirmed_email from /whoami for apps ([a002ad0](https://github.com/HeyPuter/puter/commit/a002ad08e5622a349b5d24ed2c7c5f61215146b8))
- hoist acl check in ll_read ([6a2fbc1](https://github.com/HeyPuter/puter/commit/6a2fbc1925952ecceed741afe138270d1eeda7b7))
### Backend


#### Features

- add comments for fsentries ([db79a72](https://github.com/HeyPuter/puter/commit/db79a72daab5460bc8e24f6e16c6280291b2f6fe))
### AI


#### Features

- add xAI grok-beta ([28adcf5](https://github.com/HeyPuter/puter/commit/28adcf533fd867dfdf3bda0007753e65c91ff5e5))
- add groq ([53e7a91](https://github.com/HeyPuter/puter/commit/53e7a91f1800b60b48575a6e41d96d2ccbd6d362))
- add mistral ([055c628](https://github.com/HeyPuter/puter/commit/055c628afd2e33589d3dc66c52934505143eafd4))
- add togetherai ([bdfdf23](https://github.com/HeyPuter/puter/commit/bdfdf2331b37680b95ac56b31026d3bdab4c173b))
- add claude ([d009cd0](https://github.com/HeyPuter/puter/commit/d009cd0aaff645a24d37085ed41c55fe296a5722))
- add streaming ([9d5963c](https://github.com/HeyPuter/puter/commit/9d5963cdf5fe63a4f7970d2d03bc307f4d4fa3ab))

#### Bug Fixes

- close streams ([eb18550](https://github.com/HeyPuter/puter/commit/eb18550f411947a0d8ccaf283701596b1386cfe6))
- adapt message role for claude ([c08b897](https://github.com/HeyPuter/puter/commit/c08b897d4a6a77c54a7e8d2e705e2048ab4797ba))
### GUI

### Putility


#### Features

- trait method override support ([43c5402](https://github.com/HeyPuter/puter/commit/43c5402b7cb92e604cbe59badc8f735131d2c349))
### Docker


#### Bug Fixes

- ensure temp admin pass shows ([d2c7477](https://github.com/HeyPuter/puter/commit/d2c7477b3bf170be492a6d5387330645cdf9c33a))
### Puter JS


#### Features

- add drivers module ([439f52b](https://github.com/HeyPuter/puter/commit/439f52b5a3f1a94e6d15ddacc315ae797f4709c2))

#### Bug Fixes

- fix settings object check ([5a616f6](https://github.com/HeyPuter/puter/commit/5a616f67dd22a0dcbb8a380bbbd2347a0029ce31))
### API


#### Features

- add /lsmod ([32f0edb](https://github.com/HeyPuter/puter/commit/32f0edb93a8fb0c33b0614b99c7fc439c8f6afc9))



## v2.4.2 (2024-07-22)

### Puter

#### Features

- add new file templates ([1f7f094](https://github.com/HeyPuter/puter/commit/1f7f094282fae915a2436701cfb756444cd3f781))
- add cross_origin_isolation option ([e539932](https://github.com/HeyPuter/puter/commit/e53993207077aecd2c01712519251993bb2562bc))
- add option to disable temporary users ([f9333b3](https://github.com/HeyPuter/puter/commit/f9333b3d1e05bd0dffaecd2e29afd08ea61559fc))
- add some default groups ([ba50d0f](https://github.com/HeyPuter/puter/commit/ba50d0f96d58075abec067d24e6532bd874093f0))
- Add support for dropping multiple Puter items onto Dev Center (close #311) ([8e7306c](https://github.com/HeyPuter/puter/commit/8e7306c23be01ee6c31cdb4c99f2fb1f71a2247f))

#### Translations

- Update ig.js ([382fb24](https://github.com/HeyPuter/puter/commit/382fb24dbb1737a8a54ed2491f80b2e2276cde61))
- feat: add vietnamese localization-a ([c2d3d69](https://github.com/HeyPuter/puter/commit/c2d3d69dbe33f36fcae13bcbc8e2a31a86025af9))
- Update zhtw.js, Complete Traditional Chinese translation based on English file #550 ([b9e73b7](https://github.com/HeyPuter/puter/commit/b9e73b7288aebb14e6bbf1915743e9157fc950b1))
- update zhtw.js to match en.js ([37fd666](https://github.com/HeyPuter/puter/commit/37fd666a9a6788d5f0c59311499f29896b48bc82))
- Add Tamil translation to translations.js ([8a3d043](https://github.com/HeyPuter/puter/commit/8a3d0430f39f872b8a460c344cce652c340b700b))
- Move Tamil translation to the rest of translations ([333d6e3](https://github.com/HeyPuter/puter/commit/333d6e3b651e460caca04a896cbc8c175555b79b))
- Translation improvements, mainly style and context-based ([8bece96](https://github.com/HeyPuter/puter/commit/8bece96f6224a060d5b408e08c58865fadb8b79c))
- update translation file es.js to be up to date with the file en.js ([1515278](https://github.com/HeyPuter/puter/commit/151527825f1eb4b060aaf97feb7d18af4fcddbf2))
- Translate en.js as of 2024-07-10 ([8e297cd](https://github.com/HeyPuter/puter/commit/8e297cd7e30757073e2f96593c363a273b639466))
- Create hu.js hungarian language ([69a80ab](https://github.com/HeyPuter/puter/commit/69a80ab3d2c94ee43d96021c3bcbdab04a4b5dc6))
- Update translations.js to Hungarian lang ([56820cf](https://github.com/HeyPuter/puter/commit/56820cf6ee56ff810a6b495a281ccbb2e7f9d8fb))
- Tamil translation ([81781f8](https://github.com/HeyPuter/puter/commit/81781f80afc07cd1e6278906cdc68c8092fbfedf))
- Update it.js ([84e31ef](https://github.com/HeyPuter/puter/commit/84e31eff2f58584d8fab7dd10606f2f6ced933a2))
- Update Armenian translation file ([3b8af7c](https://github.com/HeyPuter/puter/commit/3b8af7cc5c1be8ed67be827360bbfe0f0b5027e9))

#### Bug Fixes

- fix templates ([5d2a6fc](https://github.com/HeyPuter/puter/commit/5d2a6fce305a3dcd4857f52ebb75f529dffe4790))
- popup login in co isolation mode ([8f87770](https://github.com/HeyPuter/puter/commit/8f87770cebab32c00cb10133979d426306685292))
- add necessary iframe attributes for co isolation ([2a5cec7](https://github.com/HeyPuter/puter/commit/2a5cec7ee914c9c97ae90b85464f9fc5332ad2fb))
- chore: fix confirm for type_confirm_to_delete_account ([02e1b1e](https://github.com/HeyPuter/puter/commit/02e1b1e8f5f8e22d7ab39ebff99f7dd8e08a4221))
- syntax error and formatting issue ([3a09e84](https://github.com/HeyPuter/puter/commit/3a09e84838fe8b74bd050641620eec87d9f59dfc))
- #432 ([f897e84](https://github.com/HeyPuter/puter/commit/f897e844989083b0b369ba0ce4d2c5a9f3db5ad8))
- `launch_app` not considering `explorer` as a special case ([98e6964](https://github.com/HeyPuter/puter/commit/98e69642d027a83975a0b2b825317213098bb689))
- well kinda (HOSTNAME in phoenix) ([7043b94](https://github.com/HeyPuter/puter/commit/7043b9400c63842c4c54d82724167666708d3119))
- it was github actions the entire time ([602a198](https://github.com/HeyPuter/puter/commit/602a19895c05b45a7d283470e7af3ae786be1bf2))
- fix CI attempt #7 ([614f2c5](https://github.com/HeyPuter/puter/commit/614f2c5061525f230ccd879bfb047434ac46a9ba))
- fix CI attempt #6 ([9d549b1](https://github.com/HeyPuter/puter/commit/9d549b192d149eac96c316ded645bf7c2e96153d))
- fix CI attempt #5 ([74adcdd](https://github.com/HeyPuter/puter/commit/74adcddc1d60e0a513408a0716ed2b301126225d))
- fix CI attempt #4 ([84b993b](https://github.com/HeyPuter/puter/commit/84b993bce913c3ad99127063bcfaae19331b199c))
- fix CI attempt #3 ([3bca973](https://github.com/HeyPuter/puter/commit/3bca973f5f4e65a2bd24c634c347fbd681a7458b))
- fix CI attempt #2 ([aebe89a](https://github.com/HeyPuter/puter/commit/aebe89a1acb070764551e8e89e325325ffbed8f9))
- run mocha within packages in monorepo ([58c199c](https://github.com/HeyPuter/puter/commit/58c199c15356ac087a04b16dd18e8fe0f1aea359))
- make webpack output not look like errors ([ad3d318](https://github.com/HeyPuter/puter/commit/ad3d318d07377c78c0429247225655e489b68be4))
- No scrollbar for session list ([45f131f](https://github.com/HeyPuter/puter/commit/45f131f8eaf94cf3951ca7ffeb6f311590233b8a))
- fix path issues under win32 platform ([d80f2fa](https://github.com/HeyPuter/puter/commit/d80f2fa847bfaef98dc8d482898f5c15f268e4bd))
- remove abnoxious debug file ([5c636d4](https://github.com/HeyPuter/puter/commit/5c636d4fd25e14ba3813f7fca3b70ff7bd6860e7))
- read_only fields in ES ([e8f4c32](https://github.com/HeyPuter/puter/commit/e8f4c328bff5c36b95fe460b80803e12e619f8ee))

### Security

#### Bug Fixes

- hoist acl check in ll_read ([6a2fbc1](https://github.com/HeyPuter/puter/commit/6a2fbc1925952ecceed741afe138270d1eeda7b7))

## v2.4.1 (2024-07-11)

### Puter


#### Features

- update BR translation ([42a6b39](https://github.com/HeyPuter/puter/commit/42a6b3938a588b8b4d1bd976c37e9c6e58408c75))
- JSON support for kv driver ([3ed7916](https://github.com/HeyPuter/puter/commit/3ed7916856f03eafbe0891f2ab39c34d20d2bd24))

#### Translations

- Update bn.js file formatting ([cff488f](https://github.com/HeyPuter/puter/commit/cff488f4f4378ca6c7568a585a665f2a3b87b89c))
- Issue#530 - Update bengali translations ([92abc99](https://github.com/HeyPuter/puter/commit/92abc9947f811f94f17a5ee5a4b73ee2b210900a))
- Added missing Romanian translations. ([8440f56](https://github.com/HeyPuter/puter/commit/8440f566b91c9eb4f01addcb850061e3fbe3afc7))
- Add 2FA Romanian translations ([473b651](https://github.com/HeyPuter/puter/commit/473b6512c697854e3f3badae1eb7b87742954da5))
- Add Japanese Translation ([47ec74f](https://github.com/HeyPuter/puter/commit/47ec74f0aa6adb3952e6460909029a4acb0c3039))
- Completing Italian translation based on English file ([f5a8ee1](https://github.com/HeyPuter/puter/commit/f5a8ee1c6ab950d62c90b6257791f026a508b4e4))
- Completing Italian translation based on English file. ([a96abb5](https://github.com/HeyPuter/puter/commit/a96abb5793528d0dc56d75f95d771e1dcf5960d1))
- Completing Arabic translation based on English file ([78a0ace](https://github.com/HeyPuter/puter/commit/78a0acea6980b6d491da4874edbd98e17c0d9577))
- Update Arabic translations in src/gui/src/i18n/translations/ar.js to match English version in src/gui/src/i18n/translations/en.js ([fe5be7f](https://github.com/HeyPuter/puter/commit/fe5be7f3cf7f336730137293ba86a637e8d8591d))
- Update Arabic translations in src/gui/src/i18n/translations/ar.js to match English version in src/gui/src/i18n/translations/en.js ([bffa192](https://github.com/HeyPuter/puter/commit/bffa192805216fc17045cd8d629f34784dca7f3f))
- Ukrainian updated ([e61039f](https://github.com/HeyPuter/puter/commit/e61039faf409b0ad85c7513b0123f3f2e92ebe32))
- Update ru.js issue #547 ([17145d0](https://github.com/HeyPuter/puter/commit/17145d0be6a9a1445947cc0c4bec8f16a475144c))
- Russian translation fixed ([8836011](https://github.com/HeyPuter/puter/commit/883601142873f10d69c84874499065a7d29af054))

#### Bug Fixes

- remove flag that breaks puter-js webpack ([7aadae5](https://github.com/HeyPuter/puter/commit/7aadae58ce1a51f925bf64c3d65ac1fa6971b164))
- Improve `getMimeType` to remove trailing dot in the extension if preset ([535475b](https://github.com/HeyPuter/puter/commit/535475b3c36a37e3319ed067a24fb671790dcda3))


## 2.4.0 (2024-07-08)


### Features

* add (pt-br) translation for system settings. ([77211c4](https://github.com/HeyPuter/puter/commit/77211c4f71b0285fb3060f7e5c8d493b4d7c4f0c))
* add /group/list endpoint ([d55f38c](https://github.com/HeyPuter/puter/commit/d55f38ca68899c3574cfe328d2b206b1143ff0d4))
* add /share/file-by-username endpoint ([5d214c7](https://github.com/HeyPuter/puter/commit/5d214c7b52887b594af6be497f1892baf7d77679))
* add /sharelink/request endpoint ([742f625](https://github.com/HeyPuter/puter/commit/742f625309f9f4cfa70cf7d2fe5b03fd164913ea))
* add /show urls ([079e25a](https://github.com/HeyPuter/puter/commit/079e25a9fe8e179f26d72378856058eb656e2314))
* add app metadata ([f7216b9](https://github.com/HeyPuter/puter/commit/f7216b95672b38802b288ef5b022e947017ff311))
* add appdata permission (if applicable) on app share ([9751fd9](https://github.com/HeyPuter/puter/commit/9751fd92a50e75385cffed0ca847d5076ba98c92))
* add cookie for site token ([a813fbb](https://github.com/HeyPuter/puter/commit/a813fbbb88bcfb8b9a61976e2a4fc4aab943fc88))
* add cross-server event broadcasting ([1207a15](https://github.com/HeyPuter/puter/commit/1207a158bdc88a90b14d31d03387ce353c176a9c))
* add debug mod ([16b1649](https://github.com/HeyPuter/puter/commit/16b1649ff62fd87a4dda5d2e1c68941c864c5da4))
* add endpoints for share tokens ([301ffaf](https://github.com/HeyPuter/puter/commit/301ffaf61dbb4fca1a855650ab80707ae6d9f602))
* Add exit status code to apps ([7674da4](https://github.com/HeyPuter/puter/commit/7674da4cd225bcad34079251c5600fc32e32248b))
* add external mod loading ([eb05fbd](https://github.com/HeyPuter/puter/commit/eb05fbd2dc4877553b5118a069a9afdc32bea137))
* add group management endpoints ([4216346](https://github.com/HeyPuter/puter/commit/4216346384d90dcba429dbcb175e6f86482d19f4))
* add group permission endpoints ([c374b0c](https://github.com/HeyPuter/puter/commit/c374b0cbca761e7c8a47d56a09551f2e9378066a))
* add mark-read endpoint ([0101f42](https://github.com/HeyPuter/puter/commit/0101f425d480705c20df4919a76f66e987f5790f))
* add permission rewriter for app by name ([16c4907](https://github.com/HeyPuter/puter/commit/16c4907be592dae31ed3c1aa3fac3b9655255d6f))
* add protected apps ([f2f3d6f](https://github.com/HeyPuter/puter/commit/f2f3d6ff460932698fb8da7309fbce3e96132950))
* add protected subdomains ([86fca17](https://github.com/HeyPuter/puter/commit/86fca17fb17c0c24397c29b49b133deadea1de8b))
* add querystring-informed errors ([e7c0b83](https://github.com/HeyPuter/puter/commit/e7c0b8320a6829315d9154d6d513bab4491c47ea))
* add readdir delegate for shares in a user directory ([8424d44](https://github.com/HeyPuter/puter/commit/8424d446099ac30ccf829c57d43eef1f235618e4))
* add readdir delegate for sharing user homedirs ([19a5eb0](https://github.com/HeyPuter/puter/commit/19a5eb00763f3ac31df8483fb59cb7a96c448745))
* add service for notifications ([a1e6887](https://github.com/HeyPuter/puter/commit/a1e6887bf93da21b9482040b3e30ee083fb23477))
* add service to test file share logic ([332371f](https://github.com/HeyPuter/puter/commit/332371fccb198462948a440419adc7a26d671a23))
* add share list to stat ([8c49ba2](https://github.com/HeyPuter/puter/commit/8c49ba2553ce6bee20eb5b6f2721bc80f639e98a))
* add share service and share-by-email to /share ([db5990a](https://github.com/HeyPuter/puter/commit/db5990a98935817c0e16d30e921bb99c57a98fc8))
* add subdomain permission (if applicable) on app share ([13e2f72](https://github.com/HeyPuter/puter/commit/13e2f72c9f33f485570f13f45341246b1a05879f))
* add user-group permission check ([0014940](https://github.com/HeyPuter/puter/commit/00149402e041443aa3ac571fbe97a9a85f95564b))
* **backend:** add script service ([30550fc](https://github.com/HeyPuter/puter/commit/30550fcddda18469735499546de502d29b85e2ad))
* **backend:** Add tab completion to server console command arguments ([fa81dca](https://github.com/HeyPuter/puter/commit/fa81dca9507b7fa0f82099b75f2ab89c865626ac))
* **backend:** Add tab-completion to server console command names ([e1e76c6](https://github.com/HeyPuter/puter/commit/e1e76c6be71fdeb3b6246307b626734d8dc26f86))
* **backend:** add tip of day ([2d8e624](https://github.com/HeyPuter/puter/commit/2d8e6240c61dc6301f49cbdcd1c3b04736f9ca93))
* **backend:** allow services to provide user properties ([522664d](https://github.com/HeyPuter/puter/commit/522664d415c33342500defec309c2ff15bc94804))
* **backend:** allow services to provide whoami values ([fccabf1](https://github.com/HeyPuter/puter/commit/fccabf1bc0c4418f3599222616dd63bf98c14fe1))
* **backend:** improve logger and reduce logs ([4bdad75](https://github.com/HeyPuter/puter/commit/4bdad75766d0617a164024b39b79bf5373c495a6))
* Display app icon and description in embeds ([ef298ce](https://github.com/HeyPuter/puter/commit/ef298ce3aa3ce90224e883fb0ba33f9cd3a3da44))
* get first test working on share-test service ([88d6bee](https://github.com/HeyPuter/puter/commit/88d6bee9546f36d689c53ec7fe95f01f772f5211))
* **git:** Add --color and --no-color options ([d6dd1a5](https://github.com/HeyPuter/puter/commit/d6dd1a5bb0a2b2bba2cfe86d2e51ff2a6e42841c))
* **git:** Add a --debug option, which sets the DEBUG global ([fa3df72](https://github.com/HeyPuter/puter/commit/fa3df72f6ed2d45a440ebc2aacbbae67bf042478))
* **git:** Add authentication to clone, fetch, and pull. ([364d580](https://github.com/HeyPuter/puter/commit/364d580ff896691ee70d3735f495c720651a9f41))
* **git:** Add diff display to `show` and `log` subcommands ([3cad1ec](https://github.com/HeyPuter/puter/commit/3cad1ec436f99a78f782ab9576325d4341284964))
* **git:** Add start-revision and file arguments to `git log` ([49c2f16](https://github.com/HeyPuter/puter/commit/49c2f163515d2130c17a6f6a6a16bc27ea69336a))
* **git:** Allow checking out a commit instead of a branch ([057b3ac](https://github.com/HeyPuter/puter/commit/057b3acf00af49c005b9bf7069c5d22983a32e1e))
* **git:** Color output for `git status` files ([bab5204](https://github.com/HeyPuter/puter/commit/bab5204209aa2efc0c053643677a78db6ede0929))
* **git:** Display file contents as a string for `git show FILE_OID` ([a680371](https://github.com/HeyPuter/puter/commit/a68037111a04580cfa2688694a68ef6ac7a495fa))
* **git:** Display ref names in `git log` and `git show` ([45cdfcb](https://github.com/HeyPuter/puter/commit/45cdfcb5bfa66937b33054a127e0b17001f3faa4))
* **git:** Format output closer to canonical git ([60976b1](https://github.com/HeyPuter/puter/commit/60976b1ed61984d9d290f3a0ae99dd97632e9909))
* **git:** Handle detached HEAD in `git status` and `git branch --list` ([2c9b1a3](https://github.com/HeyPuter/puter/commit/2c9b1a3ffc3d5e282ffe5b83a86314e99445bbc6))
* **git:** Implement `git branch` ([ad4f132](https://github.com/HeyPuter/puter/commit/ad4f13255d52f8226f22800c16b388cf0e6384d7))
* **git:** Implement `git checkout` ([35e4453](https://github.com/HeyPuter/puter/commit/35e4453930bc4e151887f83c97efec19cc15da70))
* **git:** Implement `git cherry-pick` ([2e4259d](https://github.com/HeyPuter/puter/commit/2e4259d267b3cfafd5cefc57a02643c6432fec4d))
* **git:** Implement `git clone` ([95c8235](https://github.com/HeyPuter/puter/commit/95c8235a4a1fea39a46c40df04cb1004a2fe7b23))
* **git:** Implement `git diff` ([622b6a9](https://github.com/HeyPuter/puter/commit/622b6a9b921c3c03efc0b519c9a26c6701d80e50))
* **git:** Implement `git fetch` ([98a4b9e](https://github.com/HeyPuter/puter/commit/98a4b9ede39b94c0c6b6b8345d7551359961186a))
* **git:** Implement `git pull` ([eb2b6a0](https://github.com/HeyPuter/puter/commit/eb2b6a08b03cee0612885412cd4b03c9564044e3))
* **git:** Implement `git push` ([8c70229](https://github.com/HeyPuter/puter/commit/8c70229a188b743220db076a740a992fd7971301))
* **git:** Implement `git remote` ([43ce0d5](https://github.com/HeyPuter/puter/commit/43ce0d5b45d4eb4f296afcaaa1ecadc125c53e89))
* **git:** Implement `git restore` ([4ba8a32](https://github.com/HeyPuter/puter/commit/4ba8a32b45d395f28433572db5644d630776789e))
* **git:** Make `git add` work for deleted files ([9551544](https://github.com/HeyPuter/puter/commit/955154468f48e45028dad2e916708d6a763affad))
* **git:** Make shorten_hash() guaranteed to produce a unique hash ([dd10a37](https://github.com/HeyPuter/puter/commit/dd10a377493c0d8f10a1ac8779dc27f3f3bf6c37))
* **git:** Resolve more forms of commit reference ([b6906bb](https://github.com/HeyPuter/puter/commit/b6906bbcaaa50fc8a8c60beb6d2d38bcb7dda758))
* **git:** Understand references like `HEAD^` and `main~3` ([711dbc0](https://github.com/HeyPuter/puter/commit/711dbc0d2fde9c2ddc6c86f64fb4caa7837c9dcb))
* implicit access from apps to shared appdata dirs ([31d4eb0](https://github.com/HeyPuter/puter/commit/31d4eb090efb340fdfb7cb6b751145e859624eeb))
* introduce notification selection via driver ([c5334b0](https://github.com/HeyPuter/puter/commit/c5334b0e19cf9762f536ec482c3ff872e9c12399))
* multi-recipient multi-file share endpoint ([846fdc2](https://github.com/HeyPuter/puter/commit/846fdc20d4a887a1f8a4f3bda4fafe41efab2733))
* **parsely:** Add a fail() parser ([5656d9d](https://github.com/HeyPuter/puter/commit/5656d9d42f76202a534ad640d3a4e287e0e40418))
* **parsely:** Add stringUntil() parser ([d46b043](https://github.com/HeyPuter/puter/commit/d46b043c5d16f1205d61de3f3ba43ed8ad7bff93))
* **phoenix:** Add --dump and --file options to sed ([f250f86](https://github.com/HeyPuter/puter/commit/f250f86446a506f24fa2ad396328e3a2212a68d0))
* **phoenix:** Add more commands to sed, including labels and branching ([306014a](https://github.com/HeyPuter/puter/commit/306014adc77a7ca155feb95d1146cb46ee075b52))
* **phoenix:** Expose parsed arg tokens to apps that request them ([4067c82](https://github.com/HeyPuter/puter/commit/4067c82486c99cad20f41927ad39ebea438b717f))
* **phoenix:** Implement an `exit` builtin ([3184d34](https://github.com/HeyPuter/puter/commit/3184d3482c7b95c0fd1fc0745555ff82fc9a8c99))
* **phoenix:** Implement parsing of sed scripts ([0d4f907](https://github.com/HeyPuter/puter/commit/0d4f907b6675b15bd50a55f50aa28f0803b18b7b))
* **phoenix:** Make `clear` clear scrollback unless `-x` is given ([75a989a](https://github.com/HeyPuter/puter/commit/75a989a7b69bfdfdf69e5f0365027c5b27d8bfc6))
* **Phoenix:** Pass command line arguments and ENV when launching apps ([8f1c4fc](https://github.com/HeyPuter/puter/commit/8f1c4fcda98e72a7b970e8c6fc2fe39a5e012264))
* **phoenix:** Respond to exit status codes ([5de3052](https://github.com/HeyPuter/puter/commit/5de305202656a172b187dac87543d6c1c69a2958))
* **phoenix:** Show actual host name in prompt and neofetch ([4539408](https://github.com/HeyPuter/puter/commit/4539408a218a50244dc615cf7de56c29dcac53e6))
* rate-limit for excessive groups ([4af279a](https://github.com/HeyPuter/puter/commit/4af279a72fc9de89ddc3ba51806ca3760a36265d))
* re-send unreads on login ([02fc4d8](https://github.com/HeyPuter/puter/commit/02fc4d86b7166fb4803be5d28e2a593d6b7d9785))
* register dev center to apps ([10f4d7d](https://github.com/HeyPuter/puter/commit/10f4d7d50ce9314f9c3888c74cb17c8ebbecee98))
* send notification when file gets shared ([2f6c428](https://github.com/HeyPuter/puter/commit/2f6c428a403a006f7878861d2f0356c3294519be))
* start directory index frame ([fb1e2f2](https://github.com/HeyPuter/puter/commit/fb1e2f21fb67aefe0602f6c978199c7cd019bbf7))
* support canonical puter.js url in dev ([fd41ae2](https://github.com/HeyPuter/puter/commit/fd41ae217c7a9f7229326f62a829471580a744bd))
* **ui:** add new components ([577bd59](https://github.com/HeyPuter/puter/commit/577bd59b6cc94810e851ad544f8234e25a4e6e27))
* **ui:** add new components ([38ba425](https://github.com/HeyPuter/puter/commit/38ba42575ce9f3506f8ce219b9580202b3ed9993))
* **ui:** allow component-based settings tabs ([1245960](https://github.com/HeyPuter/puter/commit/124596058a286241b51dd87ce2fc1a68478cb5b8))
* update share endpoint to support more things ([dd5fde5](https://github.com/HeyPuter/puter/commit/dd5fde5130c1840ab598e6622766ae835142e58a))


### Bug Fixes

* add app_uid param to kv interface ([f7a0549](https://github.com/HeyPuter/puter/commit/f7a054956b8739a3bc305a49faee929ea0da1e15))
* add missing columns for public directory update ([b10302a](https://github.com/HeyPuter/puter/commit/b10302ad744fd9c58f9735743e075815183c772c))
* Add missing file extension to 0009_app-prefix-fix.sql in DB init ([a8160a8](https://github.com/HeyPuter/puter/commit/a8160a8cdcdd6aff98728a6f1643d93386e6bb5a))
* add permission implicator for file modes ([e63ab3a](https://github.com/HeyPuter/puter/commit/e63ab3a67f6555eb13d6af477a8da9f1b54d6608))
* add stream limit ([ceba309](https://github.com/HeyPuter/puter/commit/ceba309dbd4df89f310d1a530f939a5b7991f4c7))
* **backend:** remove a bad thing that really doesn't work ([8d22276](https://github.com/HeyPuter/puter/commit/8d22276f13106f7642d11da30b1500817a20ad43))
* bug introduced when refactoring /share to Sequence ([ecb9978](https://github.com/HeyPuter/puter/commit/ecb997885c1efb766827c84d2ffb8dc6ddabe992))
* check subdomain earlier for /apps ([4e3a24e](https://github.com/HeyPuter/puter/commit/4e3a24e6093e279e210765e07e436f4e63b74072))
* column nullability blunder ([1429d6f](https://github.com/HeyPuter/puter/commit/1429d6f57c67dff51fc41ca0c2868f8d000845f1))
* Correct APIError imports ([062e23b](https://github.com/HeyPuter/puter/commit/062e23b5c9673db1f8b0ff0469289d52dd1e3f99))
* correct shown flag behavior ([632c536](https://github.com/HeyPuter/puter/commit/632c5366161ff8fbbd4d60c61dfbe52dad488a2c))
* database migration ([9b39309](https://github.com/HeyPuter/puter/commit/9b39309e18a2927d25fe794d91da4e4d068c4bca))
* do not delegate to select on read like ever that is really dumb ([a2a10b9](https://github.com/HeyPuter/puter/commit/a2a10b94be59403e03fb08bec5d7c056ce5b554f))
* docker runtime fail because stdout columns ([94c0449](https://github.com/HeyPuter/puter/commit/94c0449437ce4cb26d00a15a3f277bc7b09367b4))
* fix issues with apps in /share endpoint ([0cf90ee](https://github.com/HeyPuter/puter/commit/0cf90ee39af6548d271dec45ed8ee9e6df1cd14d))
* fix owner ids for default apps ([283f409](https://github.com/HeyPuter/puter/commit/283f409a662d126e7f3ce811f1467ac6fab9a522))
* fix permission cascade properly this time ([de58866](https://github.com/HeyPuter/puter/commit/de5886698e1eae2b250baac174b57029f3244e96))
* Fix phoenix app prefix and TokenService test ([afb9d86](https://github.com/HeyPuter/puter/commit/afb9d866b5091058711db931cde904947e661c15))
* fix that fix ([b126b67](https://github.com/HeyPuter/puter/commit/b126b670940a0e20cfe7bd0eba3db891bab5c142))
* fix typo ([ce328b7](https://github.com/HeyPuter/puter/commit/ce328b7245ad741b64c5885f64f806fc98a55d84))
* **git:** Make git commit display detached HEAD correctly ([73d0f5a](https://github.com/HeyPuter/puter/commit/73d0f5a90cb5dcbadfc6d0fd22f14e8bc0e61f86))
* group permission audit table ([7d2f6d2](https://github.com/HeyPuter/puter/commit/7d2f6d256f56e30d752e9999c6e8bde68f9d9637))
* handle subpaths under another user ([d128cee](https://github.com/HeyPuter/puter/commit/d128ceed6f4928fa0793815feb2e2715cd273ff8))
* handling of batch requests with zero files ([c0063a8](https://github.com/HeyPuter/puter/commit/c0063a871fd891a1774f1bee00e86170fed249fa))
* i forgot to test reloading ([7eabb43](https://github.com/HeyPuter/puter/commit/7eabb43bd4257b4129d67eaeda2aa27e8268dc78))
* improve console experience on mac ([15465bf](https://github.com/HeyPuter/puter/commit/15465bfc5035a64762f7c86a3d38af8be6be5b59))
* incorrect error from suggested_apps ([b648817](https://github.com/HeyPuter/puter/commit/b648817f2743c2b6214ebe4177d921c9b9027594))
* Make polyfilled import.meta.filename getter a valid function ([85c6798](https://github.com/HeyPuter/puter/commit/85c679844869b6b05fcbda231d8dc7026a66da97))
* null email in request to /share ([bf63144](https://github.com/HeyPuter/puter/commit/bf63144f7a79c48bd650ae851ddd0c8a10d748c3))
* Only run Component initialization functions once ([5b43358](https://github.com/HeyPuter/puter/commit/5b43358219402bee3eadf4a0f184a4b924d3293b))
* oops ([a136ee5](https://github.com/HeyPuter/puter/commit/a136ee5edd3149798a0d82f494f423f503b65f00))
* **parsely:** Make Repeat parser work when no separator is given ([9b4d16f](https://github.com/HeyPuter/puter/commit/9b4d16fbe9d5698c57f9da725a22b528a7d7cac2))
* peers array assumption ([10cbf08](https://github.com/HeyPuter/puter/commit/10cbf08233620440aa39f5302deaac4f59f02247))
* **phoenix:** Add missing newlines to sed command output ([e047b0b](https://github.com/HeyPuter/puter/commit/e047b0bf302284da61e677432e4cc25b531b24f2))
* **phoenix:** Gracefully handle completing a non-existent path ([d76e713](https://github.com/HeyPuter/puter/commit/d76e7130cba9f0ca05940abafe4fd1a41464aa83))
* property validation on some permission endpoints ([0855f2b](https://github.com/HeyPuter/puter/commit/0855f2b36eca3bbdaa8429cbde3aa1242e8e96ee))
* readdir on file ([a72ec97](https://github.com/HeyPuter/puter/commit/a72ec9799ac3bd76ceafa22cce149e373a13f3b9))
* remove last component when share URL is file ([1166e69](https://github.com/HeyPuter/puter/commit/1166e69c76688d1811701c56cd4df9d38e286793))
* remove legacy permission check in stat ([f2c6e01](https://github.com/HeyPuter/puter/commit/f2c6e01296e4214336e63bc2d69bcbf17f59890f))
* Remove null or duplicate app entries from suggest_app_for_fsentry() ([6900233](https://github.com/HeyPuter/puter/commit/6900233c5aaa2d1a49f495e9f9a060796757a91e))
* **security:** Move token for socket.io to request body ([49b257e](https://github.com/HeyPuter/puter/commit/49b257ecffbb1e12090b86a67528a5ad09da69db))
* switch share notif username to sender ([cd65217](https://github.com/HeyPuter/puter/commit/cd65217f5cda1c986ee231e2eeeef5abefa36ecb))
* **Terminal:** Accept input from Chrome on Android ([4ef3e53](https://github.com/HeyPuter/puter/commit/4ef3e53de34f0097950a7e707ca2483863beafb5))
* Throw an error when readdir is called on a non-directory ([46eb4ed](https://github.com/HeyPuter/puter/commit/46eb4ed2b96c235e10e15645a30d2f192a1af0de))
* type error in puter-site ([d96f924](https://github.com/HeyPuter/puter/commit/d96f924cad7a13ea6e9084bb0ebb79ecc5fcb8a3))
* ui color input attributes ([d9c4fbb](https://github.com/HeyPuter/puter/commit/d9c4fbbd1dcce12ee05ee33652a5fa518196463d))
* **ui:** improve Component base class ([f8780d0](https://github.com/HeyPuter/puter/commit/f8780d032b10138851c22af53b8610c578139acc))
* update email share object ([9033f6f](https://github.com/HeyPuter/puter/commit/9033f6f8c74ef8739294d640ac1c7eba95519bbd))
* update PD alert custom details ([2f16322](https://github.com/HeyPuter/puter/commit/2f163221bdde09425cae11ef7f8e4eb0b10c7103))
* update test kernel ([55c609b](https://github.com/HeyPuter/puter/commit/55c609b3fec4ef018febc6e88c44a6277960d728))
* validate size metadata ([2008db0](https://github.com/HeyPuter/puter/commit/2008db08524259264a0c8186a34fc75d7a133f5f))

## 2.3.0 (2024-05-22)


### Features

* add /healthcheck endpoint ([c166560](https://github.com/HeyPuter/puter/commit/c166560ff4ab5a453d3ec4f97326c995deb7f522))
* Add command names to phoenix tab-completion ([cf0eee1](https://github.com/HeyPuter/puter/commit/cf0eee1fa35328e05aefc8a425b5977efe5f4ec9))
* add option to change desktop background to default ([03f05f3](https://github.com/HeyPuter/puter/commit/03f05f316f11e8afe5fcee40b2b80a0de5e6826f))
* allow apps to add a menubar via puter.js ([331d9e7](https://github.com/HeyPuter/puter/commit/331d9e75428ec7609394f59b1755374c7340f83e))
* Allow querying puter-apps driver by partial app names ([dc5b010](https://github.com/HeyPuter/puter/commit/dc5b010d0913d2151b4851f8da5df72d2c8f42e7))
* Display upload errors in UIWindowProgress dialog ([edebbee](https://github.com/HeyPuter/puter/commit/edebbee9e7e9efbb33bf709b637c103be40d15a8))
* Implement 'Like' predicate in entity storage ([a854a0d](https://github.com/HeyPuter/puter/commit/a854a0dc0aa79a31695db833184c5ca3698632a9))
* improve password recovery experience ([04432df](https://github.com/HeyPuter/puter/commit/04432df5540811710ce1cc47ce6c136e5453bccb))
* **security:** add ip rate limiting ([ccf1afc](https://github.com/HeyPuter/puter/commit/ccf1afc93c24ee7f9a126216209a185d6b4d9fe4))
* Show "Deleting /foo" in progress window when deleting files ([f07c13a](https://github.com/HeyPuter/puter/commit/f07c13a50cee790eec44bce2f6e56fbcbf73f9b0))


### Bug Fixes

* Add missing file extension to 0009_app-prefix-fix.sql in DB init ([a8160a8](https://github.com/HeyPuter/puter/commit/a8160a8cdcdd6aff98728a6f1643d93386e6bb5a))
* Add missing TextEncoder to PTT ([8d4a1e0](https://github.com/HeyPuter/puter/commit/8d4a1e0ed3872e2c82b9e4be9b6d8b359e9cea09))
* Correct APIError imports ([062e23b](https://github.com/HeyPuter/puter/commit/062e23b5c9673db1f8b0ff0469289d52dd1e3f99))
* Correct grep output when asking for line numbers ([c8a20ca](https://github.com/HeyPuter/puter/commit/c8a20cadbfd539d185d32f4558916825fcf265ba))
* Correct inverted instanceof check in SignalReader.read() ([d4c2b49](https://github.com/HeyPuter/puter/commit/d4c2b492ef4864804776d3cb7d24797fdc536886))
* Correct variables used in errors in sign.js ([fa7c6be](https://github.com/HeyPuter/puter/commit/fa7c6bee9699527028be0ae9759155bc67c52324))
* Eliminates duplicate translation keys ([5800350](https://github.com/HeyPuter/puter/commit/5800350b253994dea410afff64e3df2a171e7775))
* fix error handling for outdated node versions ([4c1d5a4](https://github.com/HeyPuter/puter/commit/4c1d5a4b6d009ce075897d499d3517219bd745a4))
* Fix phoenix app prefix and TokenService test ([afb9d86](https://github.com/HeyPuter/puter/commit/afb9d866b5091058711db931cde904947e661c15))
* increase QR code size ([d2de46e](https://github.com/HeyPuter/puter/commit/d2de46edfbc05d132d5c929f6935b82515fbbda0))
* Make PathCommandProvider reject queries with path separators ([d733119](https://github.com/HeyPuter/puter/commit/d73311945610417a1ebc7bb0723ced0a599594b4))
* Make url variable accessible to all users of it ([2f30ae7](https://github.com/HeyPuter/puter/commit/2f30ae7a825adcd8da95888c38fe39c34acee0ff))
* Only run Component initialization functions once ([5b43358](https://github.com/HeyPuter/puter/commit/5b43358219402bee3eadf4a0f184a4b924d3293b))
* Parse octal echo escapes ([6ad8f5e](https://github.com/HeyPuter/puter/commit/6ad8f5e06abd050d319271f818d72debf5bc8e44))
* reduce token lengths ([5a76bad](https://github.com/HeyPuter/puter/commit/5a76bad28dfd8ec89a309941e410a54927fae22d))
* reliability issue :bug: ([1d546d9](https://github.com/HeyPuter/puter/commit/1d546d9ef70ef9066ad5838e9782ae330d289f29))
* Remove null or duplicate app entries from suggest_app_for_fsentry() ([6900233](https://github.com/HeyPuter/puter/commit/6900233c5aaa2d1a49f495e9f9a060796757a91e))
* **security:** always use application/octet-stream ([74e213a](https://github.com/HeyPuter/puter/commit/74e213a534dbf2844c8cebeee7eb59ec70de306e))
* **security:** Fix session revocation ([eb166a6](https://github.com/HeyPuter/puter/commit/eb166a67a9f0caf4fd77f9e27dc8209c2fc51f4c))
* **security:** Move token for socket.io to request body ([49b257e](https://github.com/HeyPuter/puter/commit/49b257ecffbb1e12090b86a67528a5ad09da69db))
* **security:** Prevent email enumeration ([ed70314](https://github.com/HeyPuter/puter/commit/ed703146863f896df76c98fad7127c6748c0ef9b))
* **security:** skip cache when checking old passwd ([7800ef6](https://github.com/HeyPuter/puter/commit/7800ef61029c8d1ba47491b4028a0cb972298725))
* **Terminal:** Accept input from Chrome on Android ([4ef3e53](https://github.com/HeyPuter/puter/commit/4ef3e53de34f0097950a7e707ca2483863beafb5))
* test release-please action [#3](https://github.com/HeyPuter/puter/issues/3) ([8fb0a66](https://github.com/HeyPuter/puter/commit/8fb0a66ef21921990e564e5f61c0e80e7f929dc7))
* test release-please action [#4](https://github.com/HeyPuter/puter/issues/4) ([f392de7](https://github.com/HeyPuter/puter/commit/f392de722a5232b622ed91b656a31cdc443c2e84))
* typographical error :bug: ([2949f71](https://github.com/HeyPuter/puter/commit/2949f71691eb0a258888c5d2a5bb496d2fe64a23))
* typographical errors :bug: ([4d30740](https://github.com/HeyPuter/puter/commit/4d30740198402cd1cc61b9ea4c45e006b69ec87e))
* Use correct variable for version number ([52d5299](https://github.com/HeyPuter/puter/commit/52d52993744dffa9f7f59a232da5df9077560731))
* use primary read in signup ([30f17ad](https://github.com/HeyPuter/puter/commit/30f17ade3a893d2283316e581836607e2029f9b9))

## [2.2.0](https://github.com/HeyPuter/puter/compare/v2.1.1...v2.2.0) (2024-04-23)


### Features

* add /healthcheck endpoint ([c166560](https://github.com/HeyPuter/puter/commit/c166560ff4ab5a453d3ec4f97326c995deb7f522))
* allow apps to add a menubar via puter.js ([331d9e7](https://github.com/HeyPuter/puter/commit/331d9e75428ec7609394f59b1755374c7340f83e))

## [2.1.1](https://github.com/HeyPuter/puter/compare/v2.1.0...v2.1.1) (2024-04-22)


### Bug Fixes

* test release-please action [#3](https://github.com/HeyPuter/puter/issues/3) ([8fb0a66](https://github.com/HeyPuter/puter/commit/8fb0a66ef21921990e564e5f61c0e80e7f929dc7))
* test release-please action [#4](https://github.com/HeyPuter/puter/issues/4) ([f392de7](https://github.com/HeyPuter/puter/commit/f392de722a5232b622ed91b656a31cdc443c2e84))
