# Fuzz with retrowrite


This folder contain all file needed for fuzzing campaign for both version.
To install dependancies for fuzzing campaign you will need to run [setup_fuzz.sh](setup_fuzz.sh) from the root retrowrite folder:

## Userspace
 ```bash
# userpace install
$ ./fuzzing/setup_fuzz.sh
```
You can use the [docker](docker/) for the fuzzing campaign

## [Kernel](kernel/)
> **_NOTE:_** This script will setup all the environment (syzkaller virtual machine file and dependencies), it take some time to setup and download everything.
>
> It will take about 10 GB on your disk for the virtual machine image disk and go tools, so make sure you have enough space.
 
```bash
# kernel install
$ ./fuzzing/setup_fuzz.sh kernel
```

This script will create all needed file for the fuzzing campaign:
* [./kernel/vms_files/linux/](./kernel/vms_files/linux/) : linux source used  
* [./kernel/vms_files/busybox/](./kernel/vms_files/busybox/) :
* [./kernel/vms_files/initramfs/](./kernel/vms_files/initramfs/) :
* [./kernel/vms_files/image/](./kernel/vms_files/image/) : syzkaller images

We wrote all scripts with the assumption that the module tested is in the classic Linux tree, because that's what we used for the evaluation.


##### Fuzzing campaign

[./kernel/fuzz-module.sh](./kernel/fuzz-module.sh) : create, prepare and run a fuzzing campaign of a module from a modules in the linux sources.

You might want to setup the variables `CAMPAIGN_DURATION` , `NUM_RUNS`, `NB_VMS`, `CPU_VMS` and `MEMORY_VMS` depending of your available resources.

An exemple to fuzz ext4 modules
* `./fuzzing/kernel/fuzz-module.sh ext4`

[./kernel/measure_coverage.sh](./kernel/measure_coverage.sh) : measure the coverage of the fuzzing campaign, by replaying all the test cases and checking which basic blocks are hit. This script will need the `campaign/` folder containing the finished fuzzing campaign generated by `fuzz-module.sh`.

An example to measure our fuzzing:
* `./fuzzing/kernel/measure_coverage.sh ext4`

#### For custom modules

We provide an example of how to run a fuzzing campaign for out-of-tree modules in the [kernel_demo](/demos/kernel_demo/) folder.
