package com.andaily.hb.service.operation.job;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;

import static org.junit.jupiter.api.Assertions.*;

/**
 * 2023/12/28 12:11
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
class NetworkFrequencyMonitorLogGeneratorTest {


    @Test
    @Disabled
    void testTcp() throws Exception {
        String serverAddress = "127.0.0.1"; // 服务器地址
        int port = 12345; // 服务器端口

        try (Socket socket = new Socket(serverAddress, port)) {
            socket.setSoTimeout(2000);
            // 发送请求
            OutputStream out = socket.getOutputStream();
            out.write("Hello, server!".getBytes());

            // 接收响应
            InputStream in = socket.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String response = reader.readLine();
            assertNotNull(response);
//            System.out.println("Server response: " + response);

        }

    }

    @Test
    @Disabled
    void testUdp() throws Exception {

        String serverAddress = "127.0.0.1"; // 服务器地址
        int port = 12345; // 服务器端口


        try (DatagramSocket socket = new DatagramSocket()) {
            socket.setSoTimeout(2000);
            // 发送请求
            byte[] sendData = "Hello, server!".getBytes();
            InetAddress serverHost = InetAddress.getByName(serverAddress);
            DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, serverHost, port);
            socket.send(sendPacket);

            // 接收响应
            byte[] receiveData = new byte[1024];
            DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
            socket.receive(receivePacket);
            String response = new String(receivePacket.getData(), 0, receivePacket.getLength());
            assertNotNull(response);
//            System.out.println("Server response: " + response);
        }

    }

}