package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.shared.GuidGenerator;
import com.andaily.hb.domain.user.WeixinUser;
import com.andaily.hb.infrastructure.AbstractRepositoryTest;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;

import java.util.ArrayList;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;

/**
 * 2023/11/20 16:32
 *
 * @author Shengzhao Li
 */
class WeixinUserRepositoryTest extends AbstractRepositoryTest {


    @Autowired
    private WeixinUserRepository userRepository;

    @Test
    void findByGuid() {

        WeixinUser user = userRepository.findByGuid("guid");
        assertNull(user);

    }

    @Test
    void findByPage() {

        WeixinUser user = new WeixinUser()
                .nickName("AaaBB")
                .openId(GuidGenerator.generate())
                .hbUsername("aaaa");
        userRepository.saveAndFlush(user);

        PageRequest page = PageRequest.of(0, 10);
        Page<WeixinUser> userPage = userRepository.findAll((Specification<WeixinUser>) (root, query, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            //查询条件
//            final String nickName = (String) map.get("nickName");
//            if (StringUtils.isNotEmpty(nickName)) {
            predicates.add(criteriaBuilder.like(root.get("nickName"), "%aa%"));
//            }
            predicates.add(criteriaBuilder.equal(root.get("archived"), false));
            //sort
            Order order = criteriaBuilder.desc(root.get("createTime"));
            return query.where(predicates.toArray(new Predicate[0])).orderBy(order).getRestriction();
        }, page);

        assertNotNull(userPage);
        assertEquals(1, userPage.getTotalElements());
        assertEquals(1, userPage.getTotalPages());
//        List<WeixinUser> list = userPage.get().toList();
        List<WeixinUser> list = userPage.getContent();
        assertEquals(1, list.size());


    }


}