package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.shared.GuidGenerator;
import com.andaily.hb.domain.user.User;
import com.andaily.hb.domain.user.UserPrivilege;
import com.andaily.hb.domain.user.WeixinUser;
import com.andaily.hb.infrastructure.AbstractRepositoryTest;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

import static org.junit.jupiter.api.Assertions.*;

/**
 * 2023/11/20 15:19
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Transactional
class UserRepositoryJpaTest extends AbstractRepositoryTest {


    @Autowired
    private UserRepositoryJpa userRepository;


    private User newUser() {
        User user = new User("user_" + RandomStringUtils.random(6, true, true), "123", "123", "ewo@honyee.cc");
        userRepository.save(user);
        return userRepository.findByGuid(user.guid());
    }


    @Test
    void findByGuid() {

        User user = userRepository.findByGuid("oood");
        assertNull(user);

        user = newUser();

        fullClean();

        user = userRepository.findByGuid(user.guid());
        assertNotNull(user);
        assertNotNull(user.email());


        final User user2 = userRepository.findByUsername(user.username());
        assertNotNull(user2);

    }


    @Test
    void findByUsername() {

        User user = userRepository.findByUsername("username");
        assertNull(user);
    }

    @Test
    void findUserPrivileges() {

        final User user = newUser();

//        UserPrivilege userPrivilege = new UserPrivilege(user, Privilege.CREATE_EDIT_INSTANCE);
//        userRepository.save(userPrivilege);

        fullClean();

        final List<UserPrivilege> privileges = userRepository.findUserPrivileges(user);
        assertNotNull(privileges);
        assertEquals(privileges.size(), 0);
    }

    @Test
    void findByUsernameIgnoreArchived() {

        User user = userRepository.findByUsernameIgnoreArchived("od");
        assertNull(user);

        user = newUser();

        fullClean();

        final User user1 = userRepository.findByUsernameIgnoreArchived(user.username());
        assertNotNull(user1);
        assertNull(user1.creator());
    }

    @Test
    void findWeixinUsersByUsername() {


        final List<WeixinUser> users = userRepository.findWeixinUsersByUsername("username");
        assertTrue(users.isEmpty());
    }


    @Test
    void findWeixinUserGuids() {

        final List<String> list = userRepository.findWeixinUserGuids(GuidGenerator.generate());
        assertTrue(list.isEmpty());
    }

    @Test
    void findWeixinUserByGuid() {
    }

    @Test
    void findWeixinUsersByInstanceGuid() {

        final List<WeixinUser> list = userRepository.findWeixinUsersByInstanceGuid(GuidGenerator.generate());
        assertTrue(list.isEmpty());
    }
}