package com.andaily.hb.infrastructure.jpa;

import com.andaily.hb.domain.shared.GuidGenerator;
import com.andaily.hb.domain.user.SystemSetting;
import com.andaily.hb.infrastructure.AbstractRepositoryTest;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import static org.junit.jupiter.api.Assertions.*;

/**
 * 2023/11/20 15:28
 *
 * @author Shengzhao Li
 * @since 3.0.0
 */
@Transactional
class SystemSettingRepositoryTest extends AbstractRepositoryTest {


    @Autowired
    private SystemSettingRepository repositoryJpa;

    @Test
    void findSystemSetting() {
        final SystemSetting setting = repositoryJpa.findByGuid(GuidGenerator.generate());
        assertNull(setting);

        SystemSetting setting1 = new SystemSetting();
        repositoryJpa.save(setting1);

        fullClean();

        final SystemSetting setting2 = repositoryJpa.findByGuid(setting1.guid());
        assertNotNull(setting2);
        assertEquals(setting2.cleanMonitorLogFrequency(), 30);

    }
}